/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Wed Mar 21 19:30:16 2018

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_41 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 23832, "epsg", 23832,
        "DGN95 / Indonesia TM-3 zone 47.2", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=100.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 47.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",100.5],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9999],PARAMETER[\"false_easting\",200000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",1500000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"23832\"]]");
    p = add_epsg_def_ex (filter, first, last, 23833, "epsg", 23833,
        "DGN95 / Indonesia TM-3 zone 48.1", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=103.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 48.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",103.5],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9999],PARAMETER[\"false_easting\",200000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",1500000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"23833\"]]");
    p = add_epsg_def_ex (filter, first, last, 23834, "epsg", 23834,
        "DGN95 / Indonesia TM-3 zone 48.2", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=106.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 48.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",106.5],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9999],PARAMETER[\"false_easting\",200000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",1500000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"23834\"]]");
    p = add_epsg_def_ex (filter, first, last, 23835, "epsg", 23835,
        "DGN95 / Indonesia TM-3 zone 49.1", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=109.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 49.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",109.5],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9999],PARAMETER[\"false_easting\",200000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",1500000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"23835\"]]");
    p = add_epsg_def_ex (filter, first, last, 23836, "epsg", 23836,
        "DGN95 / Indonesia TM-3 zone 49.2", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=112.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 49.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",112.5],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9999],PARAMETER[\"false_easting\",200000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",1500000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"23836\"]]");
    p = add_epsg_def_ex (filter, first, last, 23837, "epsg", 23837,
        "DGN95 / Indonesia TM-3 zone 50.1", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=115.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 50.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",115.5],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9999],PARAMETER[\"false_easting\",200000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",1500000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"23837\"]]");
    p = add_epsg_def_ex (filter, first, last, 23838, "epsg", 23838,
        "DGN95 / Indonesia TM-3 zone 50.2", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=118.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 50.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",118.5],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9999],PARAMETER[\"false_easting\",200000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",1500000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"23838\"]]");
    p = add_epsg_def_ex (filter, first, last, 23839, "epsg", 23839,
        "DGN95 / Indonesia TM-3 zone 51.1", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=121.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 51.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",121.5],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9999],PARAMETER[\"false_easting\",200000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",1500000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"23839\"]]");
    p = add_epsg_def_ex (filter, first, last, 23840, "epsg", 23840,
        "DGN95 / Indonesia TM-3 zone 51.2", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=124.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 51.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",124.5],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9999],PARAMETER[\"false_easting\",200000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",1500000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"23840\"]]");
    p = add_epsg_def_ex (filter, first, last, 23841, "epsg", 23841,
        "DGN95 / Indonesia TM-3 zone 52.1", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=127.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 52.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",127.5],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9999],PARAMETER[\"false_easting\",200000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",1500000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"23841\"]]");
    p = add_epsg_def_ex (filter, first, last, 23842, "epsg", 23842,
        "DGN95 / Indonesia TM-3 zone 52.2", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=130.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 52.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",130.5],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9999],PARAMETER[\"false_easting\",200000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",1500000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"23842\"]]");
    p = add_epsg_def_ex (filter, first, last, 23843, "epsg", 23843,
        "DGN95 / Indonesia TM-3 zone 53.1", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=133.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 53.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",133.5],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9999],PARAMETER[\"false_easting\",200000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",1500000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"23843\"]]");
    p = add_epsg_def_ex (filter, first, last, 23844, "epsg", 23844,
        "DGN95 / Indonesia TM-3 zone 53.2", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=136.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 53.2\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",136.5],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9999],PARAMETER[\"false_easting\",200000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",1500000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"23844\"]]");
    p = add_epsg_def_ex (filter, first, last, 23845, "epsg", 23845,
        "DGN95 / Indonesia TM-3 zone 54.1", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=139.5 +k=0.9999 +x_0=200000 ");
    add_proj4text (p, 1,
        "+y_0=1500000 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / Indonesia TM-3 zone 54.1\",GEOGCS[\"DGN");
    add_srs_wkt (p, 1,
        "95\",DATUM[\"Datum_Geodesi_Nasional_1995\",SPHEROID[\"WG");
    add_srs_wkt (p, 2,
        "S 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4755\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",139.5],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9999],PARAMETER[\"false_easting\",200000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",1500000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"23845\"]]");
    p = add_epsg_def_ex (filter, first, last, 23846, "epsg", 23846,
        "ID74 / UTM zone 46N", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 46N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",93],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 10,
        "96],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"23846\"]]");
    p = add_epsg_def_ex (filter, first, last, 23847, "epsg", 23847,
        "ID74 / UTM zone 47N", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 47N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",99],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 10,
        "96],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"23847\"]]");
    p = add_epsg_def_ex (filter, first, last, 23848, "epsg", 23848,
        "ID74 / UTM zone 48N", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 48N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",105],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 10,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 12,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"23848\"]]");
    p = add_epsg_def_ex (filter, first, last, 23849, "epsg", 23849,
        "ID74 / UTM zone 49N", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 49N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",111],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 10,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 12,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"23849\"]]");
    p = add_epsg_def_ex (filter, first, last, 23850, "epsg", 23850,
        "ID74 / UTM zone 50N", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 50N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",117],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 10,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 12,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"23850\"]]");
    p = add_epsg_def_ex (filter, first, last, 23851, "epsg", 23851,
        "ID74 / UTM zone 51N", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 51N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",123],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 10,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 12,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"23851\"]]");
    p = add_epsg_def_ex (filter, first, last, 23852, "epsg", 23852,
        "ID74 / UTM zone 52N", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 52N\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",129],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 10,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 12,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"23852\"]]");
    p = add_epsg_def_ex (filter, first, last, 23853, "epsg", 23853,
        "ID74 / UTM zone 53N (deprecated)", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +a=6378160 +b=6356774.50408554 +towgs");
    add_proj4text (p, 1,
        "84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 53N (deprecated)\",GEOGCS[\"ID7");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"Indonesian_Datum_1974\",SPHEROID[\"Indonesia");
    add_srs_wkt (p, 2,
        "n National Spheroid\",6378160,298.247,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7021\"]],TOWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6238\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",135],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"23853\"]]");
    p = add_epsg_def_ex (filter, first, last, 23866, "epsg", 23866,
        "DGN95 / UTM zone 46N", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 46N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",93],PARAMETER[\"scale_factor\",0.9996],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"23866\"]]");
    p = add_epsg_def_ex (filter, first, last, 23867, "epsg", 23867,
        "DGN95 / UTM zone 47N", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 47N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",99],PARAMETER[\"scale_factor\",0.9996],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"23867\"]]");
    p = add_epsg_def_ex (filter, first, last, 23868, "epsg", 23868,
        "DGN95 / UTM zone 48N", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 48N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",105],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"23868\"]]");
    p = add_epsg_def_ex (filter, first, last, 23869, "epsg", 23869,
        "DGN95 / UTM zone 49N", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 49N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",111],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"23869\"]]");
    p = add_epsg_def_ex (filter, first, last, 23870, "epsg", 23870,
        "DGN95 / UTM zone 50N", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 50N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",117],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"23870\"]]");
    p = add_epsg_def_ex (filter, first, last, 23871, "epsg", 23871,
        "DGN95 / UTM zone 51N", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 51N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",123],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"23871\"]]");
    p = add_epsg_def_ex (filter, first, last, 23872, "epsg", 23872,
        "DGN95 / UTM zone 52N", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 52N\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",129],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"23872\"]]");
    p = add_epsg_def_ex (filter, first, last, 23877, "epsg", 23877,
        "DGN95 / UTM zone 47S", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 47S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",99],PARAMETER[\"scale_factor\",0.9996],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_easting\",500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 12,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"23877\"]]");
    p = add_epsg_def_ex (filter, first, last, 23878, "epsg", 23878,
        "DGN95 / UTM zone 48S", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 48S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",105],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"23878\"]]");
    p = add_epsg_def_ex (filter, first, last, 23879, "epsg", 23879,
        "DGN95 / UTM zone 49S", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 49S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",111],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"23879\"]]");
    p = add_epsg_def_ex (filter, first, last, 23880, "epsg", 23880,
        "DGN95 / UTM zone 50S", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 50S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",117],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"23880\"]]");
    p = add_epsg_def_ex (filter, first, last, 23881, "epsg", 23881,
        "DGN95 / UTM zone 51S", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 51S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",123],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"23881\"]]");
    p = add_epsg_def_ex (filter, first, last, 23882, "epsg", 23882,
        "DGN95 / UTM zone 52S", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 52S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",129],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"23882\"]]");
    p = add_epsg_def_ex (filter, first, last, 23883, "epsg", 23883,
        "DGN95 / UTM zone 53S", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 53S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",135],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"23883\"]]");
    p = add_epsg_def_ex (filter, first, last, 23884, "epsg", 23884,
        "DGN95 / UTM zone 54S", 0, 0,
        "WGS 84", "Greenwich",
        "Datum_Geodesi_Nasional_1995", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +south +ellps=WGS84 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"DGN95 / UTM zone 54S\",GEOGCS[\"DGN95\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Datum_Geodesi_Nasional_1995\",SPHEROID[\"WGS 84\",637813");
    add_srs_wkt (p, 2,
        "7,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6755\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4755\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",141],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 12,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"23884\"]]");
    p = add_epsg_def_ex (filter, first, last, 23886, "epsg", 23886,
        "ID74 / UTM zone 46S (deprecated)", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 46S (deprecated)\",GEOGCS[\"ID7");
    add_srs_wkt (p, 1,
        "4\",DATUM[\"Indonesian_Datum_1974\",SPHEROID[\"Indonesia");
    add_srs_wkt (p, 2,
        "n National Spheroid\",6378160,298.247,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7021\"]],TOWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6238\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",93],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Northing\",NORTH],AUTHORITY[\"EPSG\",\"23886\"]]");
    p = add_epsg_def_ex (filter, first, last, 23887, "epsg", 23887,
        "ID74 / UTM zone 47S", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 47S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",99],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 10,
        "96],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"23887\"]]");
    p = add_epsg_def_ex (filter, first, last, 23888, "epsg", 23888,
        "ID74 / UTM zone 48S", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 48S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",105],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 10,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"23888\"]]");
    p = add_epsg_def_ex (filter, first, last, 23889, "epsg", 23889,
        "ID74 / UTM zone 49S", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=49 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 49S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",111],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 10,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"23889\"]]");
    p = add_epsg_def_ex (filter, first, last, 23890, "epsg", 23890,
        "ID74 / UTM zone 50S", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=50 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 50S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",117],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 10,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"23890\"]]");
    p = add_epsg_def_ex (filter, first, last, 23891, "epsg", 23891,
        "ID74 / UTM zone 51S", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 51S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",123],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 10,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"23891\"]]");
    p = add_epsg_def_ex (filter, first, last, 23892, "epsg", 23892,
        "ID74 / UTM zone 52S", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 52S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",129],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 10,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"23892\"]]");
    p = add_epsg_def_ex (filter, first, last, 23893, "epsg", 23893,
        "ID74 / UTM zone 53S", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 53S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",135],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 10,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"23893\"]]");
    p = add_epsg_def_ex (filter, first, last, 23894, "epsg", 23894,
        "ID74 / UTM zone 54S", 0, 0,
        "Indonesian National Spheroid", "Greenwich",
        "Indonesian_Datum_1974", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +south +a=6378160 +b=6356774.50408554");
    add_proj4text (p, 1,
        " +towgs84=-24,-15,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ID74 / UTM zone 54S\",GEOGCS[\"ID74\",DATUM[\"I");
    add_srs_wkt (p, 1,
        "ndonesian_Datum_1974\",SPHEROID[\"Indonesian National Sp");
    add_srs_wkt (p, 2,
        "heroid\",6378160,298.247,AUTHORITY[\"EPSG\",\"7021\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[-24,-15,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6238\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4238\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",141],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 10,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"23894\"]]");
    p = add_epsg_def_ex (filter, first, last, 23946, "epsg", 23946,
        "Indian 1954 / UTM zone 46N", 0, 0,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Indian_1954", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +a=6377276.345 +b=6356075.41314024 +t");
    add_proj4text (p, 1,
        "owgs84=217,823,299,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Indian 1954 / UTM zone 46N\",GEOGCS[\"Indian 19");
    add_srs_wkt (p, 1,
        "54\",DATUM[\"Indian_1954\",SPHEROID[\"Everest 1830 (1937");
    add_srs_wkt (p, 2,
        " Adjustment)\",6377276.345,300.8017,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7015\"]],TOWGS84[217,823,299,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6239\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4239\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",93],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"23946\"]]");
    p = add_epsg_def_ex (filter, first, last, 23947, "epsg", 23947,
        "Indian 1954 / UTM zone 47N", 0, 0,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Indian_1954", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +a=6377276.345 +b=6356075.41314024 +t");
    add_proj4text (p, 1,
        "owgs84=217,823,299,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Indian 1954 / UTM zone 47N\",GEOGCS[\"Indian 19");
    add_srs_wkt (p, 1,
        "54\",DATUM[\"Indian_1954\",SPHEROID[\"Everest 1830 (1937");
    add_srs_wkt (p, 2,
        " Adjustment)\",6377276.345,300.8017,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7015\"]],TOWGS84[217,823,299,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6239\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4239\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",99],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"23947\"]]");
    p = add_epsg_def_ex (filter, first, last, 23948, "epsg", 23948,
        "Indian 1954 / UTM zone 48N", 0, 0,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Indian_1954", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +a=6377276.345 +b=6356075.41314024 +t");
    add_proj4text (p, 1,
        "owgs84=217,823,299,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Indian 1954 / UTM zone 48N\",GEOGCS[\"Indian 19");
    add_srs_wkt (p, 1,
        "54\",DATUM[\"Indian_1954\",SPHEROID[\"Everest 1830 (1937");
    add_srs_wkt (p, 2,
        " Adjustment)\",6377276.345,300.8017,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7015\"]],TOWGS84[217,823,299,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6239\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4239\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",105],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"23948\"]]");
    p = add_epsg_def_ex (filter, first, last, 24047, "epsg", 24047,
        "Indian 1975 / UTM zone 47N", 0, 0,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Indian_1975", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +a=6377276.345 +b=6356075.41314024 +t");
    add_proj4text (p, 1,
        "owgs84=210,814,289,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Indian 1975 / UTM zone 47N\",GEOGCS[\"Indian 19");
    add_srs_wkt (p, 1,
        "75\",DATUM[\"Indian_1975\",SPHEROID[\"Everest 1830 (1937");
    add_srs_wkt (p, 2,
        " Adjustment)\",6377276.345,300.8017,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7015\"]],TOWGS84[210,814,289,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6240\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4240\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",99],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",0.9996],PARAMETER[\"false_easting\",500000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"24047\"]]");
    p = add_epsg_def_ex (filter, first, last, 24048, "epsg", 24048,
        "Indian 1975 / UTM zone 48N", 0, 0,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Indian_1975", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +a=6377276.345 +b=6356075.41314024 +t");
    add_proj4text (p, 1,
        "owgs84=210,814,289,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Indian 1975 / UTM zone 48N\",GEOGCS[\"Indian 19");
    add_srs_wkt (p, 1,
        "75\",DATUM[\"Indian_1975\",SPHEROID[\"Everest 1830 (1937");
    add_srs_wkt (p, 2,
        " Adjustment)\",6377276.345,300.8017,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7015\"]],TOWGS84[210,814,289,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6240\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4240\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",105],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9996],PARAMETER[\"false_easting\",500000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"24048\"]]");
    p = add_epsg_def_ex (filter, first, last, 24100, "epsg", 24100,
        "Jamaica 1875 / Jamaica (Old Grid)", 0, 0,
        "Clarke 1880", "Greenwich",
        "Jamaica_1875", "Lambert_Conformal_Conic_1SP", "Clarke's foot",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=18 +lat_0=18 +lon_0=-77 +k_0=1 +x_0=167");
    add_proj4text (p, 1,
        "638.49597 +y_0=121918.90616 +a=6378249.144808011 +b=6356");
    add_proj4text (p, 2,
        "514.966204134 +to_meter=0.3047972654 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Jamaica 1875 / Jamaica (Old Grid)\",GEOGCS[\"Ja");
    add_srs_wkt (p, 1,
        "maica 1875\",DATUM[\"Jamaica_1875\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "80\",6378249.144808011,293.4663076556365,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7034\"]],AUTHORITY[\"EPSG\",\"6241\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4241\"]],PROJECTION[\"Lambert_Conformal_Conic_1S");
    add_srs_wkt (p, 8,
        "P\"],PARAMETER[\"latitude_of_origin\",18],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-77],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",550000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",400000],UNIT[\"Clarke's foot\",0.3047972654,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9005\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 13,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"24100\"]]");
    p = add_epsg_def_ex (filter, first, last, 24200, "epsg", 24200,
        "JAD69 / Jamaica National Grid", 0, 0,
        "Clarke 1866", "Greenwich",
        "Jamaica_1969", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=18 +lat_0=18 +lon_0=-77 +k_0=1 +x_0=250");
    add_proj4text (p, 1,
        "000 +y_0=150000 +ellps=clrk66 +towgs84=70,207,389.5,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JAD69 / Jamaica National Grid\",GEOGCS[\"JAD69\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Jamaica_1969\",SPHEROID[\"Clarke 1866\",6378206");
    add_srs_wkt (p, 2,
        ".4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[70,207,389.5,0,0,0,0],AUTHORITY[\"EPSG\",\"6242\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"4242\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 8,
        "mal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",18],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"central_meridian\",-77],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1],PARAMETER[\"false_easting\",250000],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_northing\",150000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"24200\"]]");
    p = add_epsg_def_ex (filter, first, last, 24305, "epsg", 24305,
        "Kalianpur 1937 / UTM zone 45N", 0, 0,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Kalianpur_1937", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=45 +a=6377276.345 +b=6356075.41314024 +t");
    add_proj4text (p, 1,
        "owgs84=214,804,268,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1937 / UTM zone 45N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1937\",DATUM[\"Kalianpur_1937\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1937 Adjustment)\",6377276.345,300.8017,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7015\"]],TOWGS84[214,804,268,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6144\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 7,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4144\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 9,
        "rigin\",0],PARAMETER[\"central_meridian\",87],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 11,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24305\"]]");
    p = add_epsg_def_ex (filter, first, last, 24306, "epsg", 24306,
        "Kalianpur 1937 / UTM zone 46N", 0, 0,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Kalianpur_1937", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +a=6377276.345 +b=6356075.41314024 +t");
    add_proj4text (p, 1,
        "owgs84=214,804,268,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1937 / UTM zone 46N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1937\",DATUM[\"Kalianpur_1937\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1937 Adjustment)\",6377276.345,300.8017,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7015\"]],TOWGS84[214,804,268,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6144\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 7,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4144\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 9,
        "rigin\",0],PARAMETER[\"central_meridian\",93],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"scale_factor\",0.9996],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 11,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24306\"]]");
    p = add_epsg_def_ex (filter, first, last, 24311, "epsg", 24311,
        "Kalianpur 1962 / UTM zone 41N", 0, 0,
        "Everest 1830 (1962 Definition)", "Greenwich",
        "Kalianpur_1962", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=41 +a=6377301.243 +b=6356100.230165384 +");
    add_proj4text (p, 1,
        "towgs84=283,682,231,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1962 / UTM zone 41N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1962\",DATUM[\"Kalianpur_1962\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1962 Definition)\",6377301.243,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7044\"]],TOWGS84[283,682,231,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6145\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4145\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",0],PARAMETER[\"central_meridian\",63],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24311\"]]");
    p = add_epsg_def_ex (filter, first, last, 24312, "epsg", 24312,
        "Kalianpur 1962 / UTM zone 42N", 0, 0,
        "Everest 1830 (1962 Definition)", "Greenwich",
        "Kalianpur_1962", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=42 +a=6377301.243 +b=6356100.230165384 +");
    add_proj4text (p, 1,
        "towgs84=283,682,231,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1962 / UTM zone 42N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1962\",DATUM[\"Kalianpur_1962\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1962 Definition)\",6377301.243,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7044\"]],TOWGS84[283,682,231,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6145\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4145\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",0],PARAMETER[\"central_meridian\",69],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24312\"]]");
    p = add_epsg_def_ex (filter, first, last, 24313, "epsg", 24313,
        "Kalianpur 1962 / UTM zone 43N", 0, 0,
        "Everest 1830 (1962 Definition)", "Greenwich",
        "Kalianpur_1962", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=43 +a=6377301.243 +b=6356100.230165384 +");
    add_proj4text (p, 1,
        "towgs84=283,682,231,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1962 / UTM zone 43N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1962\",DATUM[\"Kalianpur_1962\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1962 Definition)\",6377301.243,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7044\"]],TOWGS84[283,682,231,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6145\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4145\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",0],PARAMETER[\"central_meridian\",75],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24313\"]]");
    p = add_epsg_def_ex (filter, first, last, 24342, "epsg", 24342,
        "Kalianpur 1975 / UTM zone 42N", 0, 0,
        "Everest 1830 (1975 Definition)", "Greenwich",
        "Kalianpur_1975", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=42 +a=6377299.151 +b=6356098.145120132 +");
    add_proj4text (p, 1,
        "towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / UTM zone 42N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1975 Definition)\",6377299.151,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4146\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",0],PARAMETER[\"central_meridian\",69],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24342\"]]");
    p = add_epsg_def_ex (filter, first, last, 24343, "epsg", 24343,
        "Kalianpur 1975 / UTM zone 43N", 0, 0,
        "Everest 1830 (1975 Definition)", "Greenwich",
        "Kalianpur_1975", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=43 +a=6377299.151 +b=6356098.145120132 +");
    add_proj4text (p, 1,
        "towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / UTM zone 43N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1975 Definition)\",6377299.151,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4146\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",0],PARAMETER[\"central_meridian\",75],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24343\"]]");
    p = add_epsg_def_ex (filter, first, last, 24344, "epsg", 24344,
        "Kalianpur 1975 / UTM zone 44N", 0, 0,
        "Everest 1830 (1975 Definition)", "Greenwich",
        "Kalianpur_1975", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=44 +a=6377299.151 +b=6356098.145120132 +");
    add_proj4text (p, 1,
        "towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / UTM zone 44N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1975 Definition)\",6377299.151,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4146\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",0],PARAMETER[\"central_meridian\",81],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24344\"]]");
    p = add_epsg_def_ex (filter, first, last, 24345, "epsg", 24345,
        "Kalianpur 1975 / UTM zone 45N", 0, 0,
        "Everest 1830 (1975 Definition)", "Greenwich",
        "Kalianpur_1975", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=45 +a=6377299.151 +b=6356098.145120132 +");
    add_proj4text (p, 1,
        "towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / UTM zone 45N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1975 Definition)\",6377299.151,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4146\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",0],PARAMETER[\"central_meridian\",87],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24345\"]]");
    p = add_epsg_def_ex (filter, first, last, 24346, "epsg", 24346,
        "Kalianpur 1975 / UTM zone 46N", 0, 0,
        "Everest 1830 (1975 Definition)", "Greenwich",
        "Kalianpur_1975", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +a=6377299.151 +b=6356098.145120132 +");
    add_proj4text (p, 1,
        "towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / UTM zone 46N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1975 Definition)\",6377299.151,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4146\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",0],PARAMETER[\"central_meridian\",93],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24346\"]]");
    p = add_epsg_def_ex (filter, first, last, 24347, "epsg", 24347,
        "Kalianpur 1975 / UTM zone 47N", 0, 0,
        "Everest 1830 (1975 Definition)", "Greenwich",
        "Kalianpur_1975", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +a=6377299.151 +b=6356098.145120132 +");
    add_proj4text (p, 1,
        "towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / UTM zone 47N\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1975 Definition)\",6377299.151,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4146\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",0],PARAMETER[\"central_meridian\",99],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"24347\"]]");
    p = add_epsg_def_ex (filter, first, last, 24370, "epsg", 24370,
        "Kalianpur 1880 / India zone 0", 0, 0,
        "Everest (1830 Definition)", "Greenwich",
        "Kalianpur_1880", "Lambert_Conformal_Conic_1SP", "Indian yard",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.5 +lat_0=39.5 +lon_0=68 +k_0=0.99846");
    add_proj4text (p, 1,
        "154 +x_0=2153865.73916853 +y_0=2368292.194628102 +a=6377");
    add_proj4text (p, 2,
        "299.36559538 +b=6356098.359005156 +to_meter=0.9143985307");
    add_proj4text (p, 3,
        "444408 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1880 / India zone 0\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1880\",DATUM[\"Kalianpur_1880\",SPHEROID[\"Everest (");
    add_srs_wkt (p, 2,
        "1830 Definition)\",6377299.36559538,300.8017255433549,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7042\"]],AUTHORITY[\"EPSG\",\"6243\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4243\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 8,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",39.");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"central_meridian\",68],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.99846154],PARAMETER[\"false_easting\",2355500");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",2590000],UNIT[\"Indian ya");
    add_srs_wkt (p, 12,
        "rd\",0.9143985307444408,AUTHORITY[\"EPSG\",\"9084\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"24370\"]]");
    p = add_epsg_def_ex (filter, first, last, 24371, "epsg", 24371,
        "Kalianpur 1880 / India zone I", 0, 0,
        "Everest (1830 Definition)", "Greenwich",
        "Kalianpur_1880", "Lambert_Conformal_Conic_1SP", "Indian yard",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=68 +k_0=0.99878");
    add_proj4text (p, 1,
        "641 +x_0=2743195.592233322 +y_0=914398.5307444407 +a=637");
    add_proj4text (p, 2,
        "7299.36559538 +b=6356098.359005156 +to_meter=0.914398530");
    add_proj4text (p, 3,
        "7444408 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1880 / India zone I\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1880\",DATUM[\"Kalianpur_1880\",SPHEROID[\"Everest (");
    add_srs_wkt (p, 2,
        "1830 Definition)\",6377299.36559538,300.8017255433549,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7042\"]],AUTHORITY[\"EPSG\",\"6243\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4243\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 8,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",32.");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"central_meridian\",68],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.99878641],PARAMETER[\"false_easting\",3000000");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",1000000],UNIT[\"Indian ya");
    add_srs_wkt (p, 12,
        "rd\",0.9143985307444408,AUTHORITY[\"EPSG\",\"9084\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"24371\"]]");
    p = add_epsg_def_ex (filter, first, last, 24372, "epsg", 24372,
        "Kalianpur 1880 / India zone IIa", 0, 0,
        "Everest (1830 Definition)", "Greenwich",
        "Kalianpur_1880", "Lambert_Conformal_Conic_1SP", "Indian yard",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=74 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.592233322 +y_0=914398.5307444407 +a=6377299");
    add_proj4text (p, 2,
        ".36559538 +b=6356098.359005156 +to_meter=0.9143985307444");
    add_proj4text (p, 3,
        "408 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1880 / India zone IIa\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1880\",DATUM[\"Kalianpur_1880\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " (1830 Definition)\",6377299.36559538,300.8017255433549,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7042\"]],AUTHORITY[\"EPSG\",\"6243\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4243\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 8,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",26");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",74],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",0.99878641],PARAMETER[\"false_easting\",3000000]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",1000000],UNIT[\"Indian yar");
    add_srs_wkt (p, 12,
        "d\",0.9143985307444408,AUTHORITY[\"EPSG\",\"9084\"]],AXI");
    add_srs_wkt (p, 13,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"24372\"]]");
    p = add_epsg_def_ex (filter, first, last, 24373, "epsg", 24373,
        "Kalianpur 1880 / India zone IIIa", 0, 0,
        "Everest (1830 Definition)", "Greenwich",
        "Kalianpur_1880", "Lambert_Conformal_Conic_1SP", "Indian yard",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=19 +lat_0=19 +lon_0=80 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.592233322 +y_0=914398.5307444407 +a=6377299");
    add_proj4text (p, 2,
        ".36559538 +b=6356098.359005156 +to_meter=0.9143985307444");
    add_proj4text (p, 3,
        "408 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1880 / India zone IIIa\",GEOGCS[\"Kal");
    add_srs_wkt (p, 1,
        "ianpur 1880\",DATUM[\"Kalianpur_1880\",SPHEROID[\"Everes");
    add_srs_wkt (p, 2,
        "t (1830 Definition)\",6377299.36559538,300.8017255433549");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7042\"]],AUTHORITY[\"EPSG\",\"6243");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"4243\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 8,
        "Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 9,
        "19],PARAMETER[\"central_meridian\",80],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",0.99878641],PARAMETER[\"false_easting\",300000");
    add_srs_wkt (p, 11,
        "0],PARAMETER[\"false_northing\",1000000],UNIT[\"Indian y");
    add_srs_wkt (p, 12,
        "ard\",0.9143985307444408,AUTHORITY[\"EPSG\",\"9084\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"24373\"]]");
    p = add_epsg_def_ex (filter, first, last, 24374, "epsg", 24374,
        "Kalianpur 1880 / India zone IVa", 0, 0,
        "Everest (1830 Definition)", "Greenwich",
        "Kalianpur_1880", "Lambert_Conformal_Conic_1SP", "Indian yard",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=12 +lat_0=12 +lon_0=80 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.592233322 +y_0=914398.5307444407 +a=6377299");
    add_proj4text (p, 2,
        ".36559538 +b=6356098.359005156 +to_meter=0.9143985307444");
    add_proj4text (p, 3,
        "408 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1880 / India zone IVa\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1880\",DATUM[\"Kalianpur_1880\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " (1830 Definition)\",6377299.36559538,300.8017255433549,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7042\"]],AUTHORITY[\"EPSG\",\"6243\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4243\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 8,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",12");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",80],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",0.99878641],PARAMETER[\"false_easting\",3000000]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",1000000],UNIT[\"Indian yar");
    add_srs_wkt (p, 12,
        "d\",0.9143985307444408,AUTHORITY[\"EPSG\",\"9084\"]],AXI");
    add_srs_wkt (p, 13,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"24374\"]]");
    p = add_epsg_def_ex (filter, first, last, 24375, "epsg", 24375,
        "Kalianpur 1937 / India zone IIb", 0, 0,
        "Everest 1830 (1937 Adjustment)", "Greenwich",
        "Kalianpur_1937", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=90 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743185.69 +y_0=914395.23 +a=6377276.345 +b=6356075");
    add_proj4text (p, 2,
        ".41314024 +towgs84=214,804,268,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1937 / India zone IIb\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1937\",DATUM[\"Kalianpur_1937\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " 1830 (1937 Adjustment)\",6377276.345,300.8017,AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"7015\"]],TOWGS84[214,804,268,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"6144\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 7,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4144\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 9,
        "titude_of_origin\",26],PARAMETER[\"central_meridian\",90");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"scale_factor\",0.99878641],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",2743185.69],PARAMETER[\"false_northing\",91");
    add_srs_wkt (p, 12,
        "4395.23],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 14,
        "Y[\"EPSG\",\"24375\"]]");
    p = add_epsg_def_ex (filter, first, last, 24376, "epsg", 24376,
        "Kalianpur 1962 / India zone I", 0, 0,
        "Everest 1830 (1962 Definition)", "Greenwich",
        "Kalianpur_1962", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=68 +k_0=0.99878");
    add_proj4text (p, 1,
        "641 +x_0=2743196.4 +y_0=914398.8 +a=6377301.243 +b=63561");
    add_proj4text (p, 2,
        "00.230165384 +towgs84=283,682,231,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1962 / India zone I\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1962\",DATUM[\"Kalianpur_1962\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1962 Definition)\",6377301.243,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7044\"]],TOWGS84[283,682,231,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6145\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4145\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",32.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",68],PARAMETER[\"scale_factor\",0.99878641],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",2743196.4],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 12,
        "914398.8],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"24376\"]]");
    p = add_epsg_def_ex (filter, first, last, 24377, "epsg", 24377,
        "Kalianpur 1962 / India zone IIa", 0, 0,
        "Everest 1830 (1962 Definition)", "Greenwich",
        "Kalianpur_1962", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=74 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743196.4 +y_0=914398.8 +a=6377301.243 +b=6356100.2");
    add_proj4text (p, 2,
        "30165384 +towgs84=283,682,231,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1962 / India zone IIa\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1962\",DATUM[\"Kalianpur_1962\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " 1830 (1962 Definition)\",6377301.243,300.8017255,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7044\"]],TOWGS84[283,682,231,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6145\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4145\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "latitude_of_origin\",26],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 10,
        "74],PARAMETER[\"scale_factor\",0.99878641],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_easting\",2743196.4],PARAMETER[\"false_northing\",9");
    add_srs_wkt (p, 12,
        "14398.8],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 14,
        "Y[\"EPSG\",\"24377\"]]");
    p = add_epsg_def_ex (filter, first, last, 24378, "epsg", 24378,
        "Kalianpur 1975 / India zone I", 0, 0,
        "Everest 1830 (1975 Definition)", "Greenwich",
        "Kalianpur_1975", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=68 +k_0=0.99878");
    add_proj4text (p, 1,
        "641 +x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=63560");
    add_proj4text (p, 2,
        "98.145120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 3,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / India zone I\",GEOGCS[\"Kalian");
    add_srs_wkt (p, 1,
        "pur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest 1");
    add_srs_wkt (p, 2,
        "830 (1975 Definition)\",6377299.151,300.8017255,AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4146\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",32.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",68],PARAMETER[\"scale_factor\",0.99878641],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",2743195.5],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 12,
        "914398.5],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"24378\"]]");
    p = add_epsg_def_ex (filter, first, last, 24379, "epsg", 24379,
        "Kalianpur 1975 / India zone IIa", 0, 0,
        "Everest 1830 (1975 Definition)", "Greenwich",
        "Kalianpur_1975", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=74 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=6356098.1");
    add_proj4text (p, 2,
        "45120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / India zone IIa\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " 1830 (1975 Definition)\",6377299.151,300.8017255,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4146\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "latitude_of_origin\",26],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 10,
        "74],PARAMETER[\"scale_factor\",0.99878641],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_easting\",2743195.5],PARAMETER[\"false_northing\",9");
    add_srs_wkt (p, 12,
        "14398.5],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 14,
        "Y[\"EPSG\",\"24379\"]]");
    p = add_epsg_def_ex (filter, first, last, 24380, "epsg", 24380,
        "Kalianpur 1975 / India zone IIb", 0, 0,
        "Everest 1830 (1975 Definition)", "Greenwich",
        "Kalianpur_1975", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=90 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=6356098.1");
    add_proj4text (p, 2,
        "45120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / India zone IIb\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " 1830 (1975 Definition)\",6377299.151,300.8017255,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4146\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "latitude_of_origin\",26],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 10,
        "90],PARAMETER[\"scale_factor\",0.99878641],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_easting\",2743195.5],PARAMETER[\"false_northing\",9");
    add_srs_wkt (p, 12,
        "14398.5],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 14,
        "Y[\"EPSG\",\"24380\"]]");
    p = add_epsg_def_ex (filter, first, last, 24381, "epsg", 24381,
        "Kalianpur 1975 / India zone IIIa", 0, 0,
        "Everest 1830 (1975 Definition)", "Greenwich",
        "Kalianpur_1975", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=19 +lat_0=19 +lon_0=80 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=6356098.1");
    add_proj4text (p, 2,
        "45120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / India zone IIIa\",GEOGCS[\"Kal");
    add_srs_wkt (p, 1,
        "ianpur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everes");
    add_srs_wkt (p, 2,
        "t 1830 (1975 Definition)\",6377299.151,300.8017255,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORT");
    add_srs_wkt (p, 7,
        "H],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4146\"]");
    add_srs_wkt (p, 8,
        "],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"latitude_of_origin\",19],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",80],PARAMETER[\"scale_factor\",0.99878641],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",2743195.5],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 12,
        "914398.5],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"24381\"]]");
    p = add_epsg_def_ex (filter, first, last, 24382, "epsg", 24382,
        "Kalianpur 1880 / India zone IIb", 0, 0,
        "Everest (1830 Definition)", "Greenwich",
        "Kalianpur_1880", "Lambert_Conformal_Conic_1SP", "Indian yard",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=26 +lat_0=26 +lon_0=90 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.592233322 +y_0=914398.5307444407 +a=6377299");
    add_proj4text (p, 2,
        ".36559538 +b=6356098.359005156 +to_meter=0.9143985307444");
    add_proj4text (p, 3,
        "408 +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1880 / India zone IIb\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1880\",DATUM[\"Kalianpur_1880\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " (1830 Definition)\",6377299.36559538,300.8017255433549,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7042\"]],AUTHORITY[\"EPSG\",\"6243\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4243\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 8,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",26");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",90],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",0.99878641],PARAMETER[\"false_easting\",3000000]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",1000000],UNIT[\"Indian yar");
    add_srs_wkt (p, 12,
        "d\",0.9143985307444408,AUTHORITY[\"EPSG\",\"9084\"]],AXI");
    add_srs_wkt (p, 13,
        "S[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"24382\"]]");
    p = add_epsg_def_ex (filter, first, last, 24383, "epsg", 24383,
        "Kalianpur 1975 / India zone IVa", 0, 0,
        "Everest 1830 (1975 Definition)", "Greenwich",
        "Kalianpur_1975", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=12 +lat_0=12 +lon_0=80 +k_0=0.99878641 ");
    add_proj4text (p, 1,
        "+x_0=2743195.5 +y_0=914398.5 +a=6377299.151 +b=6356098.1");
    add_proj4text (p, 2,
        "45120132 +towgs84=295,736,257,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kalianpur 1975 / India zone IVa\",GEOGCS[\"Kali");
    add_srs_wkt (p, 1,
        "anpur 1975\",DATUM[\"Kalianpur_1975\",SPHEROID[\"Everest");
    add_srs_wkt (p, 2,
        " 1830 (1975 Definition)\",6377299.151,300.8017255,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7045\"]],TOWGS84[295,736,257,0,0,0,0],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"6146\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4146\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "latitude_of_origin\",12],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 10,
        "80],PARAMETER[\"scale_factor\",0.99878641],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_easting\",2743195.5],PARAMETER[\"false_northing\",9");
    add_srs_wkt (p, 12,
        "14398.5],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 14,
        "Y[\"EPSG\",\"24383\"]]");
    p = add_epsg_def_ex (filter, first, last, 24500, "epsg", 24500,
        "Kertau 1968 / Singapore Grid", 0, 0,
        "Everest 1830 Modified", "Greenwich",
        "Kertau_1968", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=1.287646666666667 +lon_0=103.853002222");
    add_proj4text (p, 1,
        "2222 +x_0=30000 +y_0=30000 +a=6377304.063 +b=6356103.038");
    add_proj4text (p, 2,
        "993155 +towgs84=-11,851,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / Singapore Grid\",GEOGCS[\"Kertau ");
    add_srs_wkt (p, 1,
        "1968\",DATUM[\"Kertau_1968\",SPHEROID[\"Everest 1830 Mod");
    add_srs_wkt (p, 2,
        "ified\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"7018\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[-11,851,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6245\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4245\"]],PROJECTION[\"Cassini_So");
    add_srs_wkt (p, 8,
        "ldner\"],PARAMETER[\"latitude_of_origin\",1.287646666666");
    add_srs_wkt (p, 9,
        "667],PARAMETER[\"central_meridian\",103.8530022222222],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",30000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 11,
        "hing\",30000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"24500\"]]");
    p = add_epsg_def_ex (filter, first, last, 24547, "epsg", 24547,
        "Kertau 1968 / UTM zone 47N", 0, 0,
        "Everest 1830 Modified", "Greenwich",
        "Kertau_1968", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +a=6377304.063 +b=6356103.038993155 +");
    add_proj4text (p, 1,
        "towgs84=-11,851,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / UTM zone 47N\",GEOGCS[\"Kertau 19");
    add_srs_wkt (p, 1,
        "68\",DATUM[\"Kertau_1968\",SPHEROID[\"Everest 1830 Modif");
    add_srs_wkt (p, 2,
        "ied\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"7018\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[-11,851,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6245\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4245\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",99],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 10,
        "9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"24547\"]]");
    p = add_epsg_def_ex (filter, first, last, 24548, "epsg", 24548,
        "Kertau 1968 / UTM zone 48N", 0, 0,
        "Everest 1830 Modified", "Greenwich",
        "Kertau_1968", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=48 +a=6377304.063 +b=6356103.038993155 +");
    add_proj4text (p, 1,
        "towgs84=-11,851,5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau 1968 / UTM zone 48N\",GEOGCS[\"Kertau 19");
    add_srs_wkt (p, 1,
        "68\",DATUM[\"Kertau_1968\",SPHEROID[\"Everest 1830 Modif");
    add_srs_wkt (p, 2,
        "ied\",6377304.063,300.8017,AUTHORITY[\"EPSG\",\"7018\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[-11,851,5,0,0,0,0],AUTHORITY[\"EPSG\",\"6245\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4245\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",105],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9996],PARAMETER[\"false_easting\",500000],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"24548\"]]");
    p = add_epsg_def_ex (filter, first, last, 24571, "epsg", 24571,
        "Kertau / R.S.O. Malaya (ch) (deprecated)", 0, 0,
        "Everest 1830 Modified", "Greenwich",
        "Kertau_1968", "Hotine_Oblique_Mercator", "British chain (Benoit 1895 B)",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=4 +lonc=102.25 +alpha=323.0257905 +k=");
    add_proj4text (p, 1,
        "0.99984 +x_0=804671.2997750348 +y_0=0 +no_uoff +gamma=32");
    add_proj4text (p, 2,
        "3.1301023611111 +a=6377304.063 +b=6356103.038993155 +tow");
    add_proj4text (p, 3,
        "gs84=-11,851,5,0,0,0,0 +to_meter=20.11678249437587 +no_d");
    add_proj4text (p, 4,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kertau / R.S.O. Malaya (ch) (deprecated)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Kertau 1968\",DATUM[\"Kertau_1968\",SPHEROID[\"Ever");
    add_srs_wkt (p, 2,
        "est 1830 Modified\",6377304.063,300.8017,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7018\"]],TOWGS84[-11,851,5,0,0,0,0],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"6245\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4245\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Hotine_Oblique_Mercator\"],PARAMETER[\"latitude_of_cen");
    add_srs_wkt (p, 9,
        "ter\",4],PARAMETER[\"longitude_of_center\",102.25],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"azimuth\",323.0257905],PARAMETER[\"rectified_grid");
    add_srs_wkt (p, 11,
        "_angle\",323.1301023611111],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 12,
        ".99984],PARAMETER[\"false_easting\",40000],PARAMETER[\"f");
    add_srs_wkt (p, 13,
        "alse_northing\",0],UNIT[\"British chain (Benoit 1895 B)\"");
    add_srs_wkt (p, 14,
        ",20.11678249437587,AUTHORITY[\"EPSG\",\"9062\"]],AXIS[\"");
    add_srs_wkt (p, 15,
        "Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 16,
        "G\",\"24571\"]]");
    p = add_epsg_def_ex (filter, first, last, 24600, "epsg", 24600,
        "KOC Lambert", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Kuwait_Oil_Company", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=32.5 +lat_0=32.5 +lon_0=45 +k_0=0.99878");
    add_proj4text (p, 1,
        "64078000001 +x_0=1500000 +y_0=1166200 +ellps=clrk80 +tow");
    add_proj4text (p, 2,
        "gs84=-294.7,-200.1,525.5,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"KOC Lambert\",GEOGCS[\"KOC\",DATUM[\"Kuwait_Oil");
    add_srs_wkt (p, 1,
        "_Company\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,29");
    add_srs_wkt (p, 2,
        "3.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-294.7,-200.");
    add_srs_wkt (p, 3,
        "1,525.5,0,0,0,0],AUTHORITY[\"EPSG\",\"6246\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4246\"]],PROJECTION[\"Lambert_Conformal_Coni");
    add_srs_wkt (p, 8,
        "c_1SP\"],PARAMETER[\"latitude_of_origin\",32.5],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",45],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 10,
        "9987864078],PARAMETER[\"false_easting\",1500000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",1166200],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 13,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"24600\"]]");
    p = add_epsg_def_ex (filter, first, last, 24718, "epsg", 24718,
        "La Canoa / UTM zone 18N", 0, 0,
        "International 1924", "Greenwich",
        "La_Canoa", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=intl +towgs84=-273.5,110.6,-35");
    add_proj4text (p, 1,
        "7.9,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"La Canoa / UTM zone 18N\",GEOGCS[\"La Canoa\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"La_Canoa\",SPHEROID[\"International 1924\",637838");
    add_srs_wkt (p, 2,
        "8,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-273.5,110.6");
    add_srs_wkt (p, 3,
        ",-357.9,0,0,0,0],AUTHORITY[\"EPSG\",\"6247\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4247\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-75],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"24718\"]]");
    p = add_epsg_def_ex (filter, first, last, 24719, "epsg", 24719,
        "La Canoa / UTM zone 19N", 0, 0,
        "International 1924", "Greenwich",
        "La_Canoa", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=intl +towgs84=-273.5,110.6,-35");
    add_proj4text (p, 1,
        "7.9,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"La Canoa / UTM zone 19N\",GEOGCS[\"La Canoa\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"La_Canoa\",SPHEROID[\"International 1924\",637838");
    add_srs_wkt (p, 2,
        "8,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-273.5,110.6");
    add_srs_wkt (p, 3,
        ",-357.9,0,0,0,0],AUTHORITY[\"EPSG\",\"6247\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4247\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-69],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"24719\"]]");
    p = add_epsg_def_ex (filter, first, last, 24720, "epsg", 24720,
        "La Canoa / UTM zone 20N", 0, 0,
        "International 1924", "Greenwich",
        "La_Canoa", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=intl +towgs84=-273.5,110.6,-35");
    add_proj4text (p, 1,
        "7.9,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"La Canoa / UTM zone 20N\",GEOGCS[\"La Canoa\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"La_Canoa\",SPHEROID[\"International 1924\",637838");
    add_srs_wkt (p, 2,
        "8,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-273.5,110.6");
    add_srs_wkt (p, 3,
        ",-357.9,0,0,0,0],AUTHORITY[\"EPSG\",\"6247\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4247\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-63],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 11,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 12,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"24720\"]]");
    p = add_epsg_def_ex (filter, first, last, 24817, "epsg", 24817,
        "PSAD56 / UTM zone 17N", 0, 0,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=intl +towgs84=-288,175,-376,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 17N\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",-81],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"24817\"]]");
    p = add_epsg_def_ex (filter, first, last, 24818, "epsg", 24818,
        "PSAD56 / UTM zone 18N", 0, 0,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=intl +towgs84=-288,175,-376,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 18N\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",-75],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"24818\"]]");
    p = add_epsg_def_ex (filter, first, last, 24819, "epsg", 24819,
        "PSAD56 / UTM zone 19N", 0, 0,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=intl +towgs84=-288,175,-376,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 19N\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",-69],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"24819\"]]");
    p = add_epsg_def_ex (filter, first, last, 24820, "epsg", 24820,
        "PSAD56 / UTM zone 20N", 0, 0,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=intl +towgs84=-288,175,-376,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 20N\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",-63],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"24820\"]]");
    p = add_epsg_def_ex (filter, first, last, 24821, "epsg", 24821,
        "PSAD56 / UTM zone 21N", 0, 0,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=intl +towgs84=-288,175,-376,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 21N\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",-57],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"24821\"]]");
    p = add_epsg_def_ex (filter, first, last, 24877, "epsg", 24877,
        "PSAD56 / UTM zone 17S", 0, 0,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +south +ellps=intl +towgs84=-288,175,");
    add_proj4text (p, 1,
        "-376,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 17S\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",-81],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"24877\"]]");
    p = add_epsg_def_ex (filter, first, last, 24878, "epsg", 24878,
        "PSAD56 / UTM zone 18S", 0, 0,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +south +ellps=intl +towgs84=-288,175,");
    add_proj4text (p, 1,
        "-376,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 18S\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",-75],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"24878\"]]");
    p = add_epsg_def_ex (filter, first, last, 24879, "epsg", 24879,
        "PSAD56 / UTM zone 19S", 0, 0,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=intl +towgs84=-288,175,");
    add_proj4text (p, 1,
        "-376,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 19S\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",-69],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"24879\"]]");
    p = add_epsg_def_ex (filter, first, last, 24880, "epsg", 24880,
        "PSAD56 / UTM zone 20S", 0, 0,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +south +ellps=intl +towgs84=-288,175,");
    add_proj4text (p, 1,
        "-376,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 20S\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",-63],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"24880\"]]");
    p = add_epsg_def_ex (filter, first, last, 24881, "epsg", 24881,
        "PSAD56 / UTM zone 21S", 0, 0,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +south +ellps=intl +towgs84=-288,175,");
    add_proj4text (p, 1,
        "-376,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 21S\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",-57],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"24881\"]]");
    p = add_epsg_def_ex (filter, first, last, 24882, "epsg", 24882,
        "PSAD56 / UTM zone 22S", 0, 0,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +south +ellps=intl +towgs84=-288,175,");
    add_proj4text (p, 1,
        "-376,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / UTM zone 22S\",GEOGCS[\"PSAD56\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Provisional_South_American_Datum_1956\",SPHEROID[\"In");
    add_srs_wkt (p, 2,
        "ternational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",-51],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 13,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"24882\"]]");
    p = add_epsg_def_ex (filter, first, last, 24891, "epsg", 24891,
        "PSAD56 / Peru west zone", 0, 0,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-6 +lon_0=-80.5 +k=0.99983008 +x_0=22");
    add_proj4text (p, 1,
        "2000 +y_0=1426834.743 +ellps=intl +towgs84=-288,175,-376");
    add_proj4text (p, 2,
        ",0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / Peru west zone\",GEOGCS[\"PSAD56\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Provisional_South_American_Datum_1956\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-");
    add_srs_wkt (p, 9,
        "6],PARAMETER[\"central_meridian\",-80.5],PARAMETER[\"sca");
    add_srs_wkt (p, 10,
        "le_factor\",0.99983008],PARAMETER[\"false_easting\",2220");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",1426834.743],UNIT[\"met");
    add_srs_wkt (p, 12,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 13,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"24891\"]]");
    p = add_epsg_def_ex (filter, first, last, 24892, "epsg", 24892,
        "PSAD56 / Peru central zone", 0, 0,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-9.5 +lon_0=-76 +k=0.99932994 +x_0=72");
    add_proj4text (p, 1,
        "0000 +y_0=1039979.159 +ellps=intl +towgs84=-288,175,-376");
    add_proj4text (p, 2,
        ",0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / Peru central zone\",GEOGCS[\"PSAD56\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Provisional_South_American_Datum_1956\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7022\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 7,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[\"");
    add_srs_wkt (p, 8,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 9,
        "-9.5],PARAMETER[\"central_meridian\",-76],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",0.99932994],PARAMETER[\"false_easting\",720");
    add_srs_wkt (p, 11,
        "000],PARAMETER[\"false_northing\",1039979.159],UNIT[\"me");
    add_srs_wkt (p, 12,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"24892\"]]");
    p = add_epsg_def_ex (filter, first, last, 24893, "epsg", 24893,
        "PSAD56 / Peru east zone", 0, 0,
        "International 1924", "Greenwich",
        "Provisional_South_American_Datum_1956", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-9.5 +lon_0=-70.5 +k=0.99952992 +x_0=");
    add_proj4text (p, 1,
        "1324000 +y_0=1040084.558 +ellps=intl +towgs84=-288,175,-");
    add_proj4text (p, 2,
        "376,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"PSAD56 / Peru east zone\",GEOGCS[\"PSAD56\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Provisional_South_American_Datum_1956\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "22\"]],TOWGS84[-288,175,-376,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6248\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4248\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",-");
    add_srs_wkt (p, 9,
        "9.5],PARAMETER[\"central_meridian\",-70.5],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",0.99952992],PARAMETER[\"false_easting\",13");
    add_srs_wkt (p, 11,
        "24000],PARAMETER[\"false_northing\",1040084.558],UNIT[\"");
    add_srs_wkt (p, 12,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"24893\"]]");
    p = add_epsg_def_ex (filter, first, last, 25000, "epsg", 25000,
        "Leigon / Ghana Metre Grid", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Leigon", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=4.666666666666667 +lon_0=-1 +k=0.9997");
    add_proj4text (p, 1,
        "5 +x_0=274319.51 +y_0=0 +ellps=clrk80 +towgs84=-130,29,3");
    add_proj4text (p, 2,
        "64,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Leigon / Ghana Metre Grid\",GEOGCS[\"Leigon\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Leigon\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.1");
    add_srs_wkt (p, 2,
        "45,293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-130,29");
    add_srs_wkt (p, 3,
        ",364,0,0,0,0],AUTHORITY[\"EPSG\",\"6250\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4250\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",4.666666666666667],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-1],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".99975],PARAMETER[\"false_easting\",274319.51],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 12,
        "\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"25000\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

