/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Wed Mar 21 19:30:16 2018

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_37 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 7560, "epsg", 7560,
        "NAD83(2011) / WISCRS Marinette (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.69166666666666 +lon_0=-87.71111111");
    add_proj4text (p, 1,
        "111111 +k=1.0000234982 +x_0=238658.8794 +y_0=0.0032 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Marinette (m)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",44.6916666");
    add_srs_wkt (p, 9,
        "6666666],PARAMETER[\"central_meridian\",-87.711111111111");
    add_srs_wkt (p, 10,
        "11],PARAMETER[\"scale_factor\",1.0000234982],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",238658.8794],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0.0032],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "7560\"]]");
    p = add_epsg_def_ex (filter, first, last, 7561, "epsg", 7561,
        "NAD83(2011) / WISCRS Menominee (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.71666666666667 +lon_0=-88.41666666");
    add_proj4text (p, 1,
        "666667 +k=1.0000362499 +x_0=105461.0121 +y_0=0.0029 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Menominee (m)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",44.7166666");
    add_srs_wkt (p, 9,
        "6666667],PARAMETER[\"central_meridian\",-88.416666666666");
    add_srs_wkt (p, 10,
        "67],PARAMETER[\"scale_factor\",1.0000362499],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",105461.0121],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0.0029],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "7561\"]]");
    p = add_epsg_def_ex (filter, first, last, 7562, "epsg", 7562,
        "NAD83(2011) / WISCRS Monroe (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.00007392861111 +lat_0=44.00007392861");
    add_proj4text (p, 1,
        "111 +lon_0=-90.64166666666668 +k_0=1.0000434122 +x_0=204");
    add_proj4text (p, 2,
        "521.209 +y_0=121923.9861 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Monroe (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 8,
        "ormal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",44.0");
    add_srs_wkt (p, 9,
        "0007392861111],PARAMETER[\"central_meridian\",-90.641666");
    add_srs_wkt (p, 10,
        "66666668],PARAMETER[\"scale_factor\",1.0000434122],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",204521.209],PARAMETER[\"false_nor");
    add_srs_wkt (p, 12,
        "thing\",121923.9861],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"7562\"]]");
    p = add_epsg_def_ex (filter, first, last, 7563, "epsg", 7563,
        "NAD83(2011) / WISCRS Oconto (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.39722222222222 +lon_0=-87.90833333");
    add_proj4text (p, 1,
        "333335 +k=1.0000236869 +x_0=182880.3676 +y_0=0.0033 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Oconto (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",44.397222222");
    add_srs_wkt (p, 9,
        "22222],PARAMETER[\"central_meridian\",-87.90833333333335");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"scale_factor\",1.0000236869],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_easting\",182880.3676],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0.0033],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "7563\"]]");
    p = add_epsg_def_ex (filter, first, last, 7564, "epsg", 7564,
        "NAD83(2011) / WISCRS Oneida (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.70422377027778 +lat_0=45.70422377027");
    add_proj4text (p, 1,
        "778 +lon_0=-89.54444444444444 +k_0=1.0000686968 +x_0=701");
    add_proj4text (p, 2,
        "04.1401 +y_0=57588.0346 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Oneida (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 8,
        "ormal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",45.7");
    add_srs_wkt (p, 9,
        "0422377027778],PARAMETER[\"central_meridian\",-89.544444");
    add_srs_wkt (p, 10,
        "44444444],PARAMETER[\"scale_factor\",1.0000686968],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",70104.1401],PARAMETER[\"false_nor");
    add_srs_wkt (p, 12,
        "thing\",57588.0346],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"7564\"]]");
    p = add_epsg_def_ex (filter, first, last, 7565, "epsg", 7565,
        "NAD83(2011) / WISCRS Pepin and Pierce (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.63614887194444 +lat_0=44.63614887194");
    add_proj4text (p, 1,
        "444 +lon_0=-92.22777777777777 +k_0=1.0000362977 +x_0=167");
    add_proj4text (p, 2,
        "640.3354 +y_0=86033.0876 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Pepin and Pierce (m)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 7,
        "de\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"La");
    add_srs_wkt (p, 8,
        "mbert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 9,
        "gin\",44.63614887194444],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 10,
        "-92.22777777777777],PARAMETER[\"scale_factor\",1.0000362");
    add_srs_wkt (p, 11,
        "977],PARAMETER[\"false_easting\",167640.3354],PARAMETER[");
    add_srs_wkt (p, 12,
        "\"false_northing\",86033.0876],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 14,
        ",AUTHORITY[\"EPSG\",\"7565\"]]");
    p = add_epsg_def_ex (filter, first, last, 7566, "epsg", 7566,
        "NAD83(2011) / WISCRS Polk (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.66111111111111 +lon_0=-92.63333333");
    add_proj4text (p, 1,
        "333334 +k=1.0000433849 +x_0=141732.2823 +y_0=0.0059 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Polk (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 8,
        "cator\"],PARAMETER[\"latitude_of_origin\",44.66111111111");
    add_srs_wkt (p, 9,
        "111],PARAMETER[\"central_meridian\",-92.63333333333334],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"scale_factor\",1.0000433849],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",141732.2823],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 12,
        ".0059],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"75");
    add_srs_wkt (p, 14,
        "66\"]]");
    p = add_epsg_def_ex (filter, first, last, 7567, "epsg", 7567,
        "NAD83(2011) / WISCRS Portage (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.41682397527777 +lat_0=44.41682397527");
    add_proj4text (p, 1,
        "777 +lon_0=-89.5 +k_0=1.000039936 +x_0=56388.1128 +y_0=5");
    add_proj4text (p, 2,
        "0022.1874 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Portage (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 8,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",44.");
    add_srs_wkt (p, 9,
        "41682397527777],PARAMETER[\"central_meridian\",-89.5],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"scale_factor\",1.000039936],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "easting\",56388.1128],PARAMETER[\"false_northing\",50022");
    add_srs_wkt (p, 12,
        ".1874],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"75");
    add_srs_wkt (p, 14,
        "67\"]]");
    p = add_epsg_def_ex (filter, first, last, 7568, "epsg", 7568,
        "NAD83(2011) / WISCRS Price (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.55555555555555 +lon_0=-90.48888888");
    add_proj4text (p, 1,
        "888889 +k=1.0000649554 +x_0=227990.8546 +y_0=0.0109 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Price (m)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(2011)\",DATUM[\"NAD83_National_Spatial_Reference_System");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",44.5555555555");
    add_srs_wkt (p, 9,
        "5555],PARAMETER[\"central_meridian\",-90.48888888888889]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"scale_factor\",1.0000649554],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",227990.8546],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 12,
        "0.0109],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 14,
        "568\"]]");
    p = add_epsg_def_ex (filter, first, last, 7569, "epsg", 7569,
        "NAD83(2011) / WISCRS Richland (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.3223129275 +lat_0=43.3223129275 +lon");
    add_proj4text (p, 1,
        "_0=-90.43055555555556 +k_0=1.0000375653 +x_0=202387.6048");
    add_proj4text (p, 2,
        " +y_0=134255.4253 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Richland (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 8,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",43");
    add_srs_wkt (p, 9,
        ".3223129275],PARAMETER[\"central_meridian\",-90.43055555");
    add_srs_wkt (p, 10,
        "555556],PARAMETER[\"scale_factor\",1.0000375653],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_easting\",202387.6048],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",134255.4253],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"7569\"]]");
    p = add_epsg_def_ex (filter, first, last, 7570, "epsg", 7570,
        "NAD83(2011) / WISCRS Rock (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.94444444444444 +lon_0=-89.07222222");
    add_proj4text (p, 1,
        "222222 +k=1.0000337311 +x_0=146304.2926 +y_0=0.0068 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Rock (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 8,
        "cator\"],PARAMETER[\"latitude_of_origin\",41.94444444444");
    add_srs_wkt (p, 9,
        "444],PARAMETER[\"central_meridian\",-89.07222222222222],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"scale_factor\",1.0000337311],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",146304.2926],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 12,
        ".0068],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"75");
    add_srs_wkt (p, 14,
        "70\"]]");
    p = add_epsg_def_ex (filter, first, last, 7571, "epsg", 7571,
        "NAD83(2011) / WISCRS Rusk (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.91944444444444 +lon_0=-91.06666666");
    add_proj4text (p, 1,
        "666666 +k=1.0000495976 +x_0=250546.1013 +y_0=0.0234 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Rusk (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 8,
        "cator\"],PARAMETER[\"latitude_of_origin\",43.91944444444");
    add_srs_wkt (p, 9,
        "444],PARAMETER[\"central_meridian\",-91.06666666666666],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"scale_factor\",1.0000495976],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",250546.1013],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 12,
        ".0234],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"75");
    add_srs_wkt (p, 14,
        "71\"]]");
    p = add_epsg_def_ex (filter, first, last, 7572, "epsg", 7572,
        "NAD83(2011) / WISCRS Sauk (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.81944444444445 +lon_0=-89.90000000");
    add_proj4text (p, 1,
        "000001 +k=1.0000373868 +x_0=185623.5716 +y_0=0.0051 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Sauk (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 8,
        "cator\"],PARAMETER[\"latitude_of_origin\",42.81944444444");
    add_srs_wkt (p, 9,
        "445],PARAMETER[\"central_meridian\",-89.9],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1.0000373868],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "185623.5716],PARAMETER[\"false_northing\",0.0051],UNIT[\"");
    add_srs_wkt (p, 12,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7572\"]]");
    p = add_epsg_def_ex (filter, first, last, 7573, "epsg", 7573,
        "NAD83(2011) / WISCRS Sawyer (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.90009913138888 +lat_0=45.90009913138");
    add_proj4text (p, 1,
        "888 +lon_0=-91.11666666666666 +k_0=1.0000573461 +x_0=216");
    add_proj4text (p, 2,
        "713.2336 +y_0=120734.1631 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Sawyer (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 8,
        "ormal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",45.9");
    add_srs_wkt (p, 9,
        "0009913138888],PARAMETER[\"central_meridian\",-91.116666");
    add_srs_wkt (p, 10,
        "66666666],PARAMETER[\"scale_factor\",1.0000573461],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",216713.2336],PARAMETER[\"false_no");
    add_srs_wkt (p, 12,
        "rthing\",120734.1631],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"7573\"]]");
    p = add_epsg_def_ex (filter, first, last, 7574, "epsg", 7574,
        "NAD83(2011) / WISCRS Shawano (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.03611111111111 +lon_0=-88.60555555");
    add_proj4text (p, 1,
        "555555 +k=1.000032144 +x_0=262433.3253 +y_0=0.0095999999");
    add_proj4text (p, 2,
        "99999999 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Shawano (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",44.03611111");
    add_srs_wkt (p, 9,
        "111111],PARAMETER[\"central_meridian\",-88.6055555555555");
    add_srs_wkt (p, 10,
        "5],PARAMETER[\"scale_factor\",1.000032144],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_easting\",262433.3253],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0.0096],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "7574\"]]");
    p = add_epsg_def_ex (filter, first, last, 7575, "epsg", 7575,
        "NAD83(2011) / WISCRS St. Croix (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.03611111111111 +lon_0=-92.63333333");
    add_proj4text (p, 1,
        "333334 +k=1.0000381803 +x_0=165506.7302 +y_0=0.0103 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS St. Croix (m)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",44.0361111");
    add_srs_wkt (p, 9,
        "1111111],PARAMETER[\"central_meridian\",-92.633333333333");
    add_srs_wkt (p, 10,
        "34],PARAMETER[\"scale_factor\",1.0000381803],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",165506.7302],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0.0103],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "7575\"]]");
    p = add_epsg_def_ex (filter, first, last, 7576, "epsg", 7576,
        "NAD83(2011) / WISCRS Taylor (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.17782208583333 +lat_0=45.17782208583");
    add_proj4text (p, 1,
        "333 +lon_0=-90.48333333333333 +k_0=1.0000597566 +x_0=187");
    add_proj4text (p, 2,
        "147.5744 +y_0=107746.7522 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Taylor (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 8,
        "ormal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",45.1");
    add_srs_wkt (p, 9,
        "7782208583333],PARAMETER[\"central_meridian\",-90.483333");
    add_srs_wkt (p, 10,
        "33333333],PARAMETER[\"scale_factor\",1.0000597566],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",187147.5744],PARAMETER[\"false_no");
    add_srs_wkt (p, 12,
        "rthing\",107746.7522],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"7576\"]]");
    p = add_epsg_def_ex (filter, first, last, 7577, "epsg", 7577,
        "NAD83(2011) / WISCRS Trempealeau (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.16111111111111 +lon_0=-91.36666666");
    add_proj4text (p, 1,
        "666666 +k=1.0000361538 +x_0=256946.9138 +y_0=0.0041 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Trempealeau (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 8,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",43.16111");
    add_srs_wkt (p, 9,
        "111111111],PARAMETER[\"central_meridian\",-91.3666666666");
    add_srs_wkt (p, 10,
        "6666],PARAMETER[\"scale_factor\",1.0000361538],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_easting\",256946.9138],PARAMETER[\"false_northi");
    add_srs_wkt (p, 12,
        "ng\",0.0041],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"7577\"]]");
    p = add_epsg_def_ex (filter, first, last, 7578, "epsg", 7578,
        "NAD83(2011) / WISCRS Vernon (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.57503293972223 +lat_0=43.57503293972");
    add_proj4text (p, 1,
        "223 +lon_0=-90.78333333333333 +k_0=1.0000408158 +x_0=222");
    add_proj4text (p, 2,
        "504.4451 +y_0=47532.0602 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Vernon (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Conf");
    add_srs_wkt (p, 8,
        "ormal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",43.5");
    add_srs_wkt (p, 9,
        "7503293972223],PARAMETER[\"central_meridian\",-90.783333");
    add_srs_wkt (p, 10,
        "33333333],PARAMETER[\"scale_factor\",1.0000408158],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",222504.4451],PARAMETER[\"false_no");
    add_srs_wkt (p, 12,
        "rthing\",47532.0602],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"7578\"]]");
    p = add_epsg_def_ex (filter, first, last, 7579, "epsg", 7579,
        "NAD83(2011) / WISCRS Vilas (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.07784409055556 +lat_0=46.07784409055");
    add_proj4text (p, 1,
        "556 +lon_0=-89.48888888888889 +k_0=1.0000730142 +x_0=134");
    add_proj4text (p, 2,
        "417.0689 +y_0=50337.1092 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Vilas (m)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(2011)\",DATUM[\"NAD83_National_Spatial_Reference_System");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 8,
        "rmal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",46.07");
    add_srs_wkt (p, 9,
        "784409055556],PARAMETER[\"central_meridian\",-89.4888888");
    add_srs_wkt (p, 10,
        "8888889],PARAMETER[\"scale_factor\",1.0000730142],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_easting\",134417.0689],PARAMETER[\"false_nor");
    add_srs_wkt (p, 12,
        "thing\",50337.1092],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"7579\"]]");
    p = add_epsg_def_ex (filter, first, last, 7580, "epsg", 7580,
        "NAD83(2011) / WISCRS Walworth (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.66946209694444 +lat_0=42.66946209694");
    add_proj4text (p, 1,
        "444 +lon_0=-88.54166666666667 +k_0=1.0000367192 +x_0=232");
    add_proj4text (p, 2,
        "562.8651 +y_0=111088.2224 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Walworth (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 8,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",42");
    add_srs_wkt (p, 9,
        ".66946209694444],PARAMETER[\"central_meridian\",-88.5416");
    add_srs_wkt (p, 10,
        "6666666667],PARAMETER[\"scale_factor\",1.0000367192],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",232562.8651],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",111088.2224],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHOR");
    add_srs_wkt (p, 14,
        "ITY[\"EPSG\",\"7580\"]]");
    p = add_epsg_def_ex (filter, first, last, 7581, "epsg", 7581,
        "NAD83(2011) / WISCRS Washburn (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.96121983333334 +lat_0=45.96121983333");
    add_proj4text (p, 1,
        "334 +lon_0=-91.78333333333333 +k_0=1.0000475376 +x_0=234");
    add_proj4text (p, 2,
        "086.8682 +y_0=188358.6058 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Washburn (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 8,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",45");
    add_srs_wkt (p, 9,
        ".96121983333334],PARAMETER[\"central_meridian\",-91.7833");
    add_srs_wkt (p, 10,
        "3333333333],PARAMETER[\"scale_factor\",1.0000475376],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",234086.8682],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",188358.6058],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHOR");
    add_srs_wkt (p, 14,
        "ITY[\"EPSG\",\"7581\"]]");
    p = add_epsg_def_ex (filter, first, last, 7582, "epsg", 7582,
        "NAD83(2011) / WISCRS Washington (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.91805555555555 +lon_0=-88.06388888");
    add_proj4text (p, 1,
        "888888 +k=1.00003738 +x_0=120091.4415 +y_0=0.003 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Washington (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 8,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",42.91805");
    add_srs_wkt (p, 9,
        "555555555],PARAMETER[\"central_meridian\",-88.0638888888");
    add_srs_wkt (p, 10,
        "8888],PARAMETER[\"scale_factor\",1.00003738],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",120091.4415],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0.003],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 14,
        "582\"]]");
    p = add_epsg_def_ex (filter, first, last, 7583, "epsg", 7583,
        "NAD83(2011) / WISCRS Waukesha (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.56944444444445 +lon_0=-88.22499999");
    add_proj4text (p, 1,
        "999999 +k=1.0000346179 +x_0=208788.418 +y_0=0.0034 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Waukesha (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",42.5694444");
    add_srs_wkt (p, 9,
        "4444445],PARAMETER[\"central_meridian\",-88.225],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"scale_factor\",1.0000346179],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",208788.418],PARAMETER[\"false_northing\",0.0034],U");
    add_srs_wkt (p, 12,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7583\"]]");
    p = add_epsg_def_ex (filter, first, last, 7584, "epsg", 7584,
        "NAD83(2011) / WISCRS Waupaca (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.42027777777778 +lon_0=-88.81666666");
    add_proj4text (p, 1,
        "666666 +k=1.0000333645 +x_0=185013.9709 +y_0=0.007 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Waupaca (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",43.42027777");
    add_srs_wkt (p, 9,
        "777778],PARAMETER[\"central_meridian\",-88.8166666666666");
    add_srs_wkt (p, 10,
        "6],PARAMETER[\"scale_factor\",1.0000333645],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",185013.9709],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0.007],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 14,
        "584\"]]");
    p = add_epsg_def_ex (filter, first, last, 7585, "epsg", 7585,
        "NAD83(2011) / WISCRS Waushara (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.11394404583334 +lat_0=44.11394404583");
    add_proj4text (p, 1,
        "334 +lon_0=-89.24166666666667 +k_0=1.0000392096 +x_0=120");
    add_proj4text (p, 2,
        "091.4402 +y_0=45069.7587 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Waushara (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 8,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",44");
    add_srs_wkt (p, 9,
        ".11394404583334],PARAMETER[\"central_meridian\",-89.2416");
    add_srs_wkt (p, 10,
        "6666666667],PARAMETER[\"scale_factor\",1.0000392096],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",120091.4402],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",45069.7587],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"7585\"]]");
    p = add_epsg_def_ex (filter, first, last, 7586, "epsg", 7586,
        "NAD83(2011) / WISCRS Wood (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.36259546944444 +lat_0=44.36259546944");
    add_proj4text (p, 1,
        "444 +lon_0=-90 +k_0=1.0000421209 +x_0=208483.6173 +y_0=1");
    add_proj4text (p, 2,
        "34589.754 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Wood (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 8,
        "mal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",44.362");
    add_srs_wkt (p, 9,
        "59546944444],PARAMETER[\"central_meridian\",-90],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"scale_factor\",1.0000421209],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",208483.6173],PARAMETER[\"false_northing\",134589.7");
    add_srs_wkt (p, 12,
        "54],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7586\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 7587, "epsg", 7587,
        "NAD83(2011) / WISCRS Adams and Juneau (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.36666666666667 +lon_0=-90 +k=1.000");
    add_proj4text (p, 1,
        "0365285 +x_0=147218.6941325883 +y_0=0.00365760731521463 ");
    add_proj4text (p, 2,
        "+ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Adams and Juneau (ftUS)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 2,
        "ference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 3,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 7,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"");
    add_srs_wkt (p, 8,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 9,
        "43.36666666666667],PARAMETER[\"central_meridian\",-90],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"scale_factor\",1.0000365285],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",482999.999],PARAMETER[\"false_northing\",0.0");
    add_srs_wkt (p, 12,
        "12],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"7587\"]]");
    p = add_epsg_def_ex (filter, first, last, 7588, "epsg", 7588,
        "NAD83(2011) / WISCRS Ashland (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.70611111111111 +lon_0=-90.62222222");
    add_proj4text (p, 1,
        "222222 +k=1.0000495683 +x_0=172821.945948692 +y_0=0.0018");
    add_proj4text (p, 2,
        "28803657607315 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Ashland (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 8,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",45.70611");
    add_srs_wkt (p, 9,
        "111111111],PARAMETER[\"central_meridian\",-90.6222222222");
    add_srs_wkt (p, 10,
        "2222],PARAMETER[\"scale_factor\",1.0000495683],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_easting\",567000.0010000002],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",0.006],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 13,
        "2192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 14,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7588\"]]");
    p = add_epsg_def_ex (filter, first, last, 7589, "epsg", 7589,
        "NAD83(2011) / WISCRS Barron (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.13333333333333 +lon_0=-91.84999999");
    add_proj4text (p, 1,
        "999999 +k=1.0000486665 +x_0=93150 +y_0=0.003048006096012");
    add_proj4text (p, 2,
        "192 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Barron (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",45.1333333");
    add_srs_wkt (p, 9,
        "3333333],PARAMETER[\"central_meridian\",-91.85],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"scale_factor\",1.0000486665],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",305609.625],PARAMETER[\"false_northing\",0.01],UNIT");
    add_srs_wkt (p, 12,
        "[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"7589\"]]");
    p = add_epsg_def_ex (filter, first, last, 7590, "epsg", 7590,
        "NAD83(2011) / WISCRS Bayfield (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.66964837722222 +lat_0=46.66964837722");
    add_proj4text (p, 1,
        "222 +lon_0=-91.15277777777779 +k_0=1.0000331195 +x_0=228");
    add_proj4text (p, 2,
        "600.4575057151 +y_0=148551.4835661671 +ellps=GRS80 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Bayfield (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 8,
        "Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 9,
        "46.66964837722222],PARAMETER[\"central_meridian\",-91.15");
    add_srs_wkt (p, 10,
        "277777777779],PARAMETER[\"scale_factor\",1.0000331195],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_easting\",750000.0010000002],PARAMETER[");
    add_srs_wkt (p, 12,
        "\"false_northing\",487372.659],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 13,
        ".3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X");
    add_srs_wkt (p, 14,
        "\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7590\"]]");
    p = add_epsg_def_ex (filter, first, last, 7591, "epsg", 7591,
        "NAD83(2011) / WISCRS Brown (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43 +lon_0=-88 +k=1.00002 +x_0=31599.9");
    add_proj4text (p, 1,
        "9989839979 +y_0=4599.999898399797 +ellps=GRS80 +units=us");
    add_proj4text (p, 2,
        "-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Brown (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",43],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"central_meridian\",-88],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1.00002],PARAMETER[\"false_easting\",103674.333],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",15091.833],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
        ",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7591\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 7592, "epsg", 7592,
        "NAD83(2011) / WISCRS Buffalo (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.48138888888889 +lon_0=-91.79722222");
    add_proj4text (p, 1,
        "222222 +k=1.0000382778 +x_0=175260.3502159004 +y_0=0.004");
    add_proj4text (p, 2,
        "876809753619507 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Buffalo (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 8,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",43.48138");
    add_srs_wkt (p, 9,
        "888888889],PARAMETER[\"central_meridian\",-91.7972222222");
    add_srs_wkt (p, 10,
        "2222],PARAMETER[\"scale_factor\",1.0000382778],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_easting\",574999.999],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",0.016],UNIT[\"US survey foot\",0.3048006096012192,AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 14,
        "NORTH],AUTHORITY[\"EPSG\",\"7592\"]]");
    p = add_epsg_def_ex (filter, first, last, 7593, "epsg", 7593,
        "NAD83(2011) / WISCRS Burnett (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.89871486583333 +lat_0=45.89871486583");
    add_proj4text (p, 1,
        "333 +lon_0=-92.45777777777778 +k_0=1.0000383841 +x_0=640");
    add_proj4text (p, 2,
        "08.12771145543 +y_0=59445.90419100838 +ellps=GRS80 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Burnett (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 8,
        "Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 9,
        "45.89871486583333],PARAMETER[\"central_meridian\",-92.45");
    add_srs_wkt (p, 10,
        "777777777778],PARAMETER[\"scale_factor\",1.0000383841],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_easting\",209999.999],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_northing\",195032.104],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 13,
        "6096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST");
    add_srs_wkt (p, 14,
        "],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7593\"]]");
    p = add_epsg_def_ex (filter, first, last, 7594, "epsg", 7594,
        "NAD83(2011) / WISCRS Calumet, Fond du Lac, Outagamie and Winnebago (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.71944444444445 +lon_0=-88.5 +k=1.0");
    add_proj4text (p, 1,
        "000286569 +x_0=244754.8892049784 +y_0=0.0048768097536195");
    add_proj4text (p, 2,
        "07 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Calumet, Fond du Lac, Outa");
    add_srs_wkt (p, 1,
        "gamie and Winnebago (ftUS)\",GEOGCS[\"NAD83(2011)\",DATU");
    add_srs_wkt (p, 2,
        "M[\"NAD83_National_Spatial_Reference_System_2011\",SPHER");
    add_srs_wkt (p, 3,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 5,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 6,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 7,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 8,
        "SG\",\"6318\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 9,
        "METER[\"latitude_of_origin\",42.71944444444445],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"central_meridian\",-88.5],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 11,
        ",1.0000286569],PARAMETER[\"false_easting\",802999.999],P");
    add_srs_wkt (p, 12,
        "ARAMETER[\"false_northing\",0.016],UNIT[\"US survey foot");
    add_srs_wkt (p, 13,
        "\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS");
    add_srs_wkt (p, 14,
        "[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7594");
    add_srs_wkt (p, 15,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 7595, "epsg", 7595,
        "NAD83(2011) / WISCRS Chippewa (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.97785689861112 +lat_0=44.97785689861");
    add_proj4text (p, 1,
        "112 +lon_0=-91.29444444444444 +k_0=1.0000391127 +x_0=600");
    add_proj4text (p, 2,
        "45.72009144018 +y_0=44091.43449326898 +ellps=GRS80 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Chippewa (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 8,
        "Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 9,
        "44.97785689861112],PARAMETER[\"central_meridian\",-91.29");
    add_srs_wkt (p, 10,
        "444444444444],PARAMETER[\"scale_factor\",1.0000391127],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_easting\",197000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 12,
        "thing\",144656.648],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 13,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 14,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7595\"]]");
    p = add_epsg_def_ex (filter, first, last, 7596, "epsg", 7596,
        "NAD83(2011) / WISCRS Clark (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.6 +lon_0=-90.70833333333334 +k=1.0");
    add_proj4text (p, 1,
        "000463003 +x_0=199949.198983998 +y_0=0.00853441706883413");
    add_proj4text (p, 2,
        "7 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Clark (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",43.6],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",-90.70833333333334],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"scale_factor\",1.0000463003],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",655999.997],PARAMETER[\"false_northing\",0.028],UNIT");
    add_srs_wkt (p, 12,
        "[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"7596\"]]");
    p = add_epsg_def_ex (filter, first, last, 7597, "epsg", 7597,
        "NAD83(2011) / WISCRS Columbia (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.46254664583333 +lat_0=43.46254664583");
    add_proj4text (p, 1,
        "333 +lon_0=-89.39444444444445 +k_0=1.00003498 +x_0=16916");
    add_proj4text (p, 2,
        "4.338023876 +y_0=111569.613512827 +ellps=GRS80 +units=us");
    add_proj4text (p, 3,
        "-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Columbia (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 8,
        "Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 9,
        "43.46254664583333],PARAMETER[\"central_meridian\",-89.39");
    add_srs_wkt (p, 10,
        "444444444445],PARAMETER[\"scale_factor\",1.00003498],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",554999.999],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",366041.307],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 13,
        "96012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],");
    add_srs_wkt (p, 14,
        "AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7597\"]]");
    p = add_epsg_def_ex (filter, first, last, 7598, "epsg", 7598,
        "NAD83(2011) / WISCRS Crawford (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.200055605 +lat_0=43.200055605 +lon_0");
    add_proj4text (p, 1,
        "=-90.9388888888889 +k_0=1.0000349151 +x_0=113690.6273812");
    add_proj4text (p, 2,
        "548 +y_0=53703.12024384048 +ellps=GRS80 +units=us-ft +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Crawford (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 8,
        "Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 9,
        "43.200055605],PARAMETER[\"central_meridian\",-90.9388888");
    add_srs_wkt (p, 10,
        "888889],PARAMETER[\"scale_factor\",1.0000349151],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_easting\",373000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",176190.987],UNIT[\"US survey foot\",0.3048006096012192,");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"7598\"]]");
    p = add_epsg_def_ex (filter, first, last, 7599, "epsg", 7599,
        "NAD83(2011) / WISCRS Dane (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.0695160375 +lat_0=43.0695160375 +lon");
    add_proj4text (p, 1,
        "_0=-89.42222222222223 +k_0=1.0000384786 +x_0=247193.2943");
    add_proj4text (p, 2,
        "865888 +y_0=146591.9896367793 +ellps=GRS80 +units=us-ft ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Dane (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 8,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",43.");
    add_srs_wkt (p, 9,
        "0695160375],PARAMETER[\"central_meridian\",-89.422222222");
    add_srs_wkt (p, 10,
        "22223],PARAMETER[\"scale_factor\",1.0000384786],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",811000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",480943.886],UNIT[\"US survey foot\",0.3048006096012192,");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"7599\"]]");
    p = add_epsg_def_ex (filter, first, last, 7600, "epsg", 7600,
        "NAD83(2011) / WISCRS Dodge and Jefferson (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.47222222222222 +lon_0=-88.77500000");
    add_proj4text (p, 1,
        "000001 +k=1.0000346418 +x_0=263347.7263906528 +y_0=0.007");
    add_proj4text (p, 2,
        "62001524003048 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Dodge and Jefferson (ftUS)");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial");
    add_srs_wkt (p, 2,
        "_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",41.47222222222222],PARAMETER[\"central_meridian\",-8");
    add_srs_wkt (p, 10,
        "8.775],PARAMETER[\"scale_factor\",1.0000346418],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",863999.9990000002],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_northing\",0.025],UNIT[\"US survey foot\",0.30480060960");
    add_srs_wkt (p, 13,
        "12192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXI");
    add_srs_wkt (p, 14,
        "S[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7600\"]]");
    p = add_epsg_def_ex (filter, first, last, 7601, "epsg", 7601,
        "NAD83(2011) / WISCRS Door (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.4 +lon_0=-87.27222222222223 +k=1.0");
    add_proj4text (p, 1,
        "000187521 +x_0=158801.1176022352 +y_0=0.0024384048768097");
    add_proj4text (p, 2,
        "54 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Door (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",44.4],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"central_meridian\",-87.27222222222223],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"scale_factor\",1.0000187521],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",521000],PARAMETER[\"false_northing\",0.00800000000000");
    add_srs_wkt (p, 12,
        "0002],UNIT[\"US survey foot\",0.3048006096012192,AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH");
    add_srs_wkt (p, 14,
        "],AUTHORITY[\"EPSG\",\"7601\"]]");
    p = add_epsg_def_ex (filter, first, last, 7602, "epsg", 7602,
        "NAD83(2011) / WISCRS Douglas (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.88333333333333 +lon_0=-91.91666666");
    add_proj4text (p, 1,
        "666667 +k=1.0000385418 +x_0=59131.31826263652 +y_0=0.003");
    add_proj4text (p, 2,
        "962407924815849 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Douglas (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 8,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",45.88333");
    add_srs_wkt (p, 9,
        "333333333],PARAMETER[\"central_meridian\",-91.9166666666");
    add_srs_wkt (p, 10,
        "6667],PARAMETER[\"scale_factor\",1.0000385418],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_easting\",194000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 12,
        "0.013],UNIT[\"US survey foot\",0.3048006096012192,AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 14,
        "H],AUTHORITY[\"EPSG\",\"7602\"]]");
    p = add_epsg_def_ex (filter, first, last, 7603, "epsg", 7603,
        "NAD83(2011) / WISCRS Dunn (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.40833333333333 +lon_0=-91.89444444");
    add_proj4text (p, 1,
        "444445 +k=1.0000410324 +x_0=51816.10393700787 +y_0=0.003");
    add_proj4text (p, 2,
        "048006096012192 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Dunn (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",44.40833333");
    add_srs_wkt (p, 9,
        "333333],PARAMETER[\"central_meridian\",-91.8944444444444");
    add_srs_wkt (p, 10,
        "5],PARAMETER[\"scale_factor\",1.0000410324],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",170000.001],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0.01],UNIT[\"US survey foot\",0.3048006096012192,AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 14,
        "H],AUTHORITY[\"EPSG\",\"7603\"]]");
    p = add_epsg_def_ex (filter, first, last, 7604, "epsg", 7604,
        "NAD83(2011) / WISCRS Eau Claire (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.87228112638889 +lat_0=44.87228112638");
    add_proj4text (p, 1,
        "889 +lon_0=-91.28888888888889 +k_0=1.000035079 +x_0=1200");
    add_proj4text (p, 2,
        "91.4401828804 +y_0=91687.92390144781 +ellps=GRS80 +units");
    add_proj4text (p, 3,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Eau Claire (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamber");
    add_srs_wkt (p, 8,
        "t_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 9,
        ",44.87228112638889],PARAMETER[\"central_meridian\",-91.2");
    add_srs_wkt (p, 10,
        "8888888888889],PARAMETER[\"scale_factor\",1.000035079],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_easting\",394000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 12,
        "thing\",300812.797],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 13,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 14,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7604\"]]");
    p = add_epsg_def_ex (filter, first, last, 7605, "epsg", 7605,
        "NAD83(2011) / WISCRS Florence (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.43888888888888 +lon_0=-88.14166666");
    add_proj4text (p, 1,
        "666668 +k=1.0000552095 +x_0=133502.6682245364 +y_0=0.006");
    add_proj4text (p, 2,
        "400812801625603 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Florence (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 8,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",45.43888");
    add_srs_wkt (p, 9,
        "888888888],PARAMETER[\"central_meridian\",-88.1416666666");
    add_srs_wkt (p, 10,
        "6668],PARAMETER[\"scale_factor\",1.0000552095],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_easting\",438000.004],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",0.021],UNIT[\"US survey foot\",0.3048006096012192,AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 14,
        "NORTH],AUTHORITY[\"EPSG\",\"7605\"]]");
    p = add_epsg_def_ex (filter, first, last, 7606, "epsg", 7606,
        "NAD83(2011) / WISCRS Forest (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.00555555555555 +lon_0=-88.63333333");
    add_proj4text (p, 1,
        "333334 +k=1.0000673004 +x_0=275844.5532131065 +y_0=0.015");
    add_proj4text (p, 2,
        "8496316992634 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Forest (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",44.0055555");
    add_srs_wkt (p, 9,
        "5555555],PARAMETER[\"central_meridian\",-88.633333333333");
    add_srs_wkt (p, 10,
        "34],PARAMETER[\"scale_factor\",1.0000673004],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",905000.0050000002],PARAMETER[\"false_nor");
    add_srs_wkt (p, 12,
        "thing\",0.052],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 13,
        "2,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"7606\"]]");
    p = add_epsg_def_ex (filter, first, last, 7607, "epsg", 7607,
        "NAD83(2011) / WISCRS Grant (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.41111111111111 +lon_0=-90.8 +k=1.0");
    add_proj4text (p, 1,
        "000349452 +x_0=242316.484023368 +y_0=0.01005842011684023");
    add_proj4text (p, 2,
        " +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Grant (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",41.4111111");
    add_srs_wkt (p, 9,
        "1111111],PARAMETER[\"central_meridian\",-90.8],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"scale_factor\",1.0000349452],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",794999.998],PARAMETER[\"false_northing\",0.033],UNIT");
    add_srs_wkt (p, 12,
        "[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"7607\"]]");
    p = add_epsg_def_ex (filter, first, last, 7608, "epsg", 7608,
        "NAD83(2011) / WISCRS Green and Lafayette (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.63756227694444 +lat_0=42.63756227694");
    add_proj4text (p, 1,
        "444 +lon_0=-89.83888888888889 +k_0=1.0000390487 +x_0=170");
    add_proj4text (p, 2,
        "078.7401574803 +y_0=45830.29484378968 +ellps=GRS80 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Green and Lafayette (ftUS)");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial");
    add_srs_wkt (p, 2,
        "_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",42.63756227694444],PARAMETER[\"central_merid");
    add_srs_wkt (p, 10,
        "ian\",-89.83888888888889],PARAMETER[\"scale_factor\",1.0");
    add_srs_wkt (p, 11,
        "000390487],PARAMETER[\"false_easting\",558000],PARAMETER");
    add_srs_wkt (p, 12,
        "[\"false_northing\",150361.559],UNIT[\"US survey foot\",");
    add_srs_wkt (p, 13,
        "0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 14,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7608\"]");
    add_srs_wkt (p, 15,
        "]");
    p = add_epsg_def_ex (filter, first, last, 7609, "epsg", 7609,
        "NAD83(2011) / WISCRS Green Lake and Marquette (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.80700011777778 +lat_0=43.80700011777");
    add_proj4text (p, 1,
        "778 +lon_0=-89.24166666666667 +k_0=1.0000344057 +x_0=150");
    add_proj4text (p, 2,
        "876.3017526035 +y_0=79170.77937515875 +ellps=GRS80 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Green Lake and Marquette (");
    add_srs_wkt (p, 1,
        "ftUS)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Sp");
    add_srs_wkt (p, 2,
        "atial_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 3,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 7,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",43.80700011777778],PARAMETER[\"central_m");
    add_srs_wkt (p, 10,
        "eridian\",-89.24166666666667],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 11,
        ",1.0000344057],PARAMETER[\"false_easting\",495000],PARAM");
    add_srs_wkt (p, 12,
        "ETER[\"false_northing\",259746.132],UNIT[\"US survey foo");
    add_srs_wkt (p, 13,
        "t\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXI");
    add_srs_wkt (p, 14,
        "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"760");
    add_srs_wkt (p, 15,
        "9\"]]");
    p = add_epsg_def_ex (filter, first, last, 7610, "epsg", 7610,
        "NAD83(2011) / WISCRS Iowa (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.53888888888888 +lon_0=-90.16111111");
    add_proj4text (p, 1,
        "111111 +k=1.0000394961 +x_0=113081.0261620523 +y_0=0.004");
    add_proj4text (p, 2,
        "572009144018288 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Iowa (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",42.53888888");
    add_srs_wkt (p, 9,
        "888888],PARAMETER[\"central_meridian\",-90.1611111111111");
    add_srs_wkt (p, 10,
        "1],PARAMETER[\"scale_factor\",1.0000394961],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",371000],PARAMETER[\"false_northing\",0.0");
    add_srs_wkt (p, 12,
        "15],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"7610\"]]");
    p = add_epsg_def_ex (filter, first, last, 7611, "epsg", 7611,
        "NAD83(2011) / WISCRS Iron (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.43333333333333 +lon_0=-90.25555555");
    add_proj4text (p, 1,
        "555556 +k=1.0000677153 +x_0=220980.4419608839 +y_0=0.008");
    add_proj4text (p, 2,
        "534417068834137 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Iron (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",45.43333333");
    add_srs_wkt (p, 9,
        "333333],PARAMETER[\"central_meridian\",-90.2555555555555");
    add_srs_wkt (p, 10,
        "6],PARAMETER[\"scale_factor\",1.0000677153],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",725000],PARAMETER[\"false_northing\",0.0");
    add_srs_wkt (p, 12,
        "28],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"7611\"]]");
    p = add_epsg_def_ex (filter, first, last, 7612, "epsg", 7612,
        "NAD83(2011) / WISCRS Jackson (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.25333512777778 +lon_0=-90.84429651");
    add_proj4text (p, 1,
        "944444 +k=1.0000353 +x_0=27000 +y_0=24999.99989839979 +e");
    add_proj4text (p, 2,
        "llps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Jackson (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 8,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",44.25333");
    add_srs_wkt (p, 9,
        "512777778],PARAMETER[\"central_meridian\",-90.8442965194");
    add_srs_wkt (p, 10,
        "4444],PARAMETER[\"scale_factor\",1.0000353],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",88582.5],PARAMETER[\"false_northing\",82");
    add_srs_wkt (p, 12,
        "020.833],UNIT[\"US survey foot\",0.3048006096012192,AUTH");
    add_srs_wkt (p, 13,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NO");
    add_srs_wkt (p, 14,
        "RTH],AUTHORITY[\"EPSG\",\"7612\"]]");
    p = add_epsg_def_ex (filter, first, last, 7613, "epsg", 7613,
        "NAD83(2011) / WISCRS Kenosha, Milwaukee, Ozaukee and Racine (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.21666666666667 +lon_0=-87.89444444");
    add_proj4text (p, 1,
        "444445 +k=1.0000260649 +x_0=185928.3727711455 +y_0=0.000");
    add_proj4text (p, 2,
        "9144018288036576 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Kenosha, Milwaukee, Ozauke");
    add_srs_wkt (p, 1,
        "e and Racine (ftUS)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD");
    add_srs_wkt (p, 2,
        "83_National_Spatial_Reference_System_2011\",SPHEROID[\"G");
    add_srs_wkt (p, 3,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 4,
        "9\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 7,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 8,
        "6318\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "latitude_of_origin\",42.21666666666667],PARAMETER[\"cent");
    add_srs_wkt (p, 10,
        "ral_meridian\",-87.89444444444445],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 11,
        "tor\",1.0000260649],PARAMETER[\"false_easting\",610000.0");
    add_srs_wkt (p, 12,
        "03],PARAMETER[\"false_northing\",0.003],UNIT[\"US survey");
    add_srs_wkt (p, 13,
        " foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]]");
    add_srs_wkt (p, 14,
        ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 15,
        "7613\"]]");
    p = add_epsg_def_ex (filter, first, last, 7614, "epsg", 7614,
        "NAD83(2011) / WISCRS Kewaunee, Manitowoc and Sheboygan (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.26666666666667 +lon_0=-87.55 +k=1.");
    add_proj4text (p, 1,
        "0000233704 +x_0=79857.76154432308 +y_0=0.001219202438404");
    add_proj4text (p, 2,
        "877 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Kewaunee, Manitowoc and Sh");
    add_srs_wkt (p, 1,
        "eboygan (ftUS)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_Na");
    add_srs_wkt (p, 2,
        "tional_Spatial_Reference_System_2011\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 7,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6318");
    add_srs_wkt (p, 8,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 9,
        "itude_of_origin\",43.26666666666667],PARAMETER[\"central");
    add_srs_wkt (p, 10,
        "_meridian\",-87.55],PARAMETER[\"scale_factor\",1.0000233");
    add_srs_wkt (p, 11,
        "704],PARAMETER[\"false_easting\",262000.006],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",0.004],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 13,
        "6096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST");
    add_srs_wkt (p, 14,
        "],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7614\"]]");
    p = add_epsg_def_ex (filter, first, last, 7615, "epsg", 7615,
        "NAD83(2011) / WISCRS La Crosse (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.45111111111111 +lon_0=-91.31666666");
    add_proj4text (p, 1,
        "666666 +k=1.0000319985 +x_0=130454.6596901194 +y_0=0.003");
    add_proj4text (p, 2,
        "352806705613411 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS La Crosse (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "16\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",43.4511");
    add_srs_wkt (p, 9,
        "1111111111],PARAMETER[\"central_meridian\",-91.316666666");
    add_srs_wkt (p, 10,
        "66666],PARAMETER[\"scale_factor\",1.0000319985],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",427999.996],PARAMETER[\"false_northi");
    add_srs_wkt (p, 12,
        "ng\",0.011],UNIT[\"US survey foot\",0.3048006096012192,A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"7615\"]]");
    p = add_epsg_def_ex (filter, first, last, 7616, "epsg", 7616,
        "NAD83(2011) / WISCRS Langlade (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.15423710527778 +lat_0=45.15423710527");
    add_proj4text (p, 1,
        "778 +lon_0=-89.03333333333333 +k_0=1.0000627024 +x_0=198");
    add_proj4text (p, 2,
        "425.1968503937 +y_0=105279.7828803657 +ellps=GRS80 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Langlade (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 8,
        "Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 9,
        "45.15423710527778],PARAMETER[\"central_meridian\",-89.03");
    add_srs_wkt (p, 10,
        "333333333333],PARAMETER[\"scale_factor\",1.0000627024],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_easting\",651000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 12,
        "thing\",345405.421],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 13,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 14,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7616\"]]");
    p = add_epsg_def_ex (filter, first, last, 7617, "epsg", 7617,
        "NAD83(2011) / WISCRS Lincoln (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.84444444444445 +lon_0=-89.73333333");
    add_proj4text (p, 1,
        "333333 +k=1.0000599003 +x_0=116129.0322580645 +y_0=0.005");
    add_proj4text (p, 2,
        "791211582423164 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Lincoln (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 8,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",44.84444");
    add_srs_wkt (p, 9,
        "444444445],PARAMETER[\"central_meridian\",-89.7333333333");
    add_srs_wkt (p, 10,
        "3333],PARAMETER[\"scale_factor\",1.0000599003],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_easting\",381000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 12,
        "0.019],UNIT[\"US survey foot\",0.3048006096012192,AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 14,
        "H],AUTHORITY[\"EPSG\",\"7617\"]]");
    p = add_epsg_def_ex (filter, first, last, 7618, "epsg", 7618,
        "NAD83(2011) / WISCRS Marathon (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.90090442361111 +lat_0=44.90090442361");
    add_proj4text (p, 1,
        "111 +lon_0=-89.77 +k_0=1.000053289 +x_0=74676.1493522987");
    add_proj4text (p, 2,
        " +y_0=55049.26695453391 +ellps=GRS80 +units=us-ft +no_de");
    add_proj4text (p, 3,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Marathon (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 8,
        "Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 9,
        "44.90090442361111],PARAMETER[\"central_meridian\",-89.77");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"scale_factor\",1.000053289],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",245000],PARAMETER[\"false_northing\",18060");
    add_srs_wkt (p, 12,
        "7.47],UNIT[\"US survey foot\",0.3048006096012192,AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH");
    add_srs_wkt (p, 14,
        "],AUTHORITY[\"EPSG\",\"7618\"]]");
    p = add_epsg_def_ex (filter, first, last, 7619, "epsg", 7619,
        "NAD83(2011) / WISCRS Marinette (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.69166666666666 +lon_0=-87.71111111");
    add_proj4text (p, 1,
        "111111 +k=1.0000234982 +x_0=238658.8794513589 +y_0=0.003");
    add_proj4text (p, 2,
        "048006096012192 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Marinette (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "16\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",44.6916");
    add_srs_wkt (p, 9,
        "6666666666],PARAMETER[\"central_meridian\",-87.711111111");
    add_srs_wkt (p, 10,
        "11111],PARAMETER[\"scale_factor\",1.0000234982],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",783000.007],PARAMETER[\"false_northi");
    add_srs_wkt (p, 12,
        "ng\",0.01],UNIT[\"US survey foot\",0.3048006096012192,AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 14,
        "NORTH],AUTHORITY[\"EPSG\",\"7619\"]]");
    p = add_epsg_def_ex (filter, first, last, 7620, "epsg", 7620,
        "NAD83(2011) / WISCRS Menominee (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.71666666666667 +lon_0=-88.41666666");
    add_proj4text (p, 1,
        "666667 +k=1.0000362499 +x_0=105461.0121412243 +y_0=0.003");
    add_proj4text (p, 2,
        "048006096012192 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Menominee (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "16\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",44.7166");
    add_srs_wkt (p, 9,
        "6666666667],PARAMETER[\"central_meridian\",-88.416666666");
    add_srs_wkt (p, 10,
        "66667],PARAMETER[\"scale_factor\",1.0000362499],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",346000.004],PARAMETER[\"false_northi");
    add_srs_wkt (p, 12,
        "ng\",0.01],UNIT[\"US survey foot\",0.3048006096012192,AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 14,
        "NORTH],AUTHORITY[\"EPSG\",\"7620\"]]");
    p = add_epsg_def_ex (filter, first, last, 7621, "epsg", 7621,
        "NAD83(2011) / WISCRS Monroe (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.00007392861111 +lat_0=44.00007392861");
    add_proj4text (p, 1,
        "111 +lon_0=-90.64166666666668 +k_0=1.0000434122 +x_0=204");
    add_proj4text (p, 2,
        "521.2090424181 +y_0=121923.9861823724 +ellps=GRS80 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Monroe (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 8,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",44");
    add_srs_wkt (p, 9,
        ".00007392861111],PARAMETER[\"central_meridian\",-90.6416");
    add_srs_wkt (p, 10,
        "6666666668],PARAMETER[\"scale_factor\",1.0000434122],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",671000],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",400012.278],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 13,
        "2192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 14,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7621\"]]");
    p = add_epsg_def_ex (filter, first, last, 7622, "epsg", 7622,
        "NAD83(2011) / WISCRS Oconto (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.39722222222222 +lon_0=-87.90833333");
    add_proj4text (p, 1,
        "333335 +k=1.0000236869 +x_0=182880.3675895352 +y_0=0.003");
    add_proj4text (p, 2,
        "352806705613411 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Oconto (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",44.3972222");
    add_srs_wkt (p, 9,
        "2222222],PARAMETER[\"central_meridian\",-87.908333333333");
    add_srs_wkt (p, 10,
        "35],PARAMETER[\"scale_factor\",1.0000236869],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",600000.0060000002],PARAMETER[\"false_nor");
    add_srs_wkt (p, 12,
        "thing\",0.011],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 13,
        "2,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"7622\"]]");
    p = add_epsg_def_ex (filter, first, last, 7623, "epsg", 7623,
        "NAD83(2011) / WISCRS Oneida (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.70422377027778 +lat_0=45.70422377027");
    add_proj4text (p, 1,
        "778 +lon_0=-89.54444444444444 +k_0=1.0000686968 +x_0=701");
    add_proj4text (p, 2,
        "04.14020828041 +y_0=57588.03474726949 +ellps=GRS80 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Oneida (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 8,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",45");
    add_srs_wkt (p, 9,
        ".70422377027778],PARAMETER[\"central_meridian\",-89.5444");
    add_srs_wkt (p, 10,
        "4444444444],PARAMETER[\"scale_factor\",1.0000686968],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",230000],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",188936.744],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 13,
        "2192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 14,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7623\"]]");
    p = add_epsg_def_ex (filter, first, last, 7624, "epsg", 7624,
        "NAD83(2011) / WISCRS Pepin and Pierce (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.63614887194444 +lat_0=44.63614887194");
    add_proj4text (p, 1,
        "444 +lon_0=-92.22777777777777 +k_0=1.0000362977 +x_0=167");
    add_proj4text (p, 2,
        "640.3352806706 +y_0=86033.08773177546 +ellps=GRS80 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Pepin and Pierce (ftUS)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 2,
        "ference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 3,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 7,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"");
    add_srs_wkt (p, 8,
        "Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 9,
        "rigin\",44.63614887194444],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",-92.22777777777777],PARAMETER[\"scale_factor\",1.000036");
    add_srs_wkt (p, 11,
        "2977],PARAMETER[\"false_easting\",550000],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",282260.222],UNIT[\"US survey foot\",0.304");
    add_srs_wkt (p, 13,
        "8006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 14,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7624\"]]");
    p = add_epsg_def_ex (filter, first, last, 7625, "epsg", 7625,
        "NAD83(2011) / WISCRS Polk (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.66111111111111 +lon_0=-92.63333333");
    add_proj4text (p, 1,
        "333334 +k=1.0000433849 +x_0=141732.2822453645 +y_0=0.005");
    add_proj4text (p, 2,
        "791211582423164 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Polk (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",44.66111111");
    add_srs_wkt (p, 9,
        "111111],PARAMETER[\"central_meridian\",-92.6333333333333");
    add_srs_wkt (p, 10,
        "4],PARAMETER[\"scale_factor\",1.0000433849],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",464999.996],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0.019],UNIT[\"US survey foot\",0.3048006096012192,AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"7625\"]]");
    p = add_epsg_def_ex (filter, first, last, 7626, "epsg", 7626,
        "NAD83(2011) / WISCRS Portage (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.41682397527777 +lat_0=44.41682397527");
    add_proj4text (p, 1,
        "777 +lon_0=-89.5 +k_0=1.000039936 +x_0=56388.11277622555");
    add_proj4text (p, 2,
        " +y_0=50022.1874523749 +ellps=GRS80 +units=us-ft +no_def");
    add_proj4text (p, 3,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Portage (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 8,
        "Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 9,
        "44.41682397527777],PARAMETER[\"central_meridian\",-89.5]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"scale_factor\",1.000039936],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",185000],PARAMETER[\"false_northing\",164114");
    add_srs_wkt (p, 12,
        ".46],UNIT[\"US survey foot\",0.3048006096012192,AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 14,
        ",AUTHORITY[\"EPSG\",\"7626\"]]");
    p = add_epsg_def_ex (filter, first, last, 7627, "epsg", 7627,
        "NAD83(2011) / WISCRS Price (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.55555555555555 +lon_0=-90.48888888");
    add_proj4text (p, 1,
        "888889 +k=1.0000649554 +x_0=227990.8544577089 +y_0=0.010");
    add_proj4text (p, 2,
        "97282194564389 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Price (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",44.5555555");
    add_srs_wkt (p, 9,
        "5555555],PARAMETER[\"central_meridian\",-90.488888888888");
    add_srs_wkt (p, 10,
        "89],PARAMETER[\"scale_factor\",1.0000649554],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",747999.995],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0.036],UNIT[\"US survey foot\",0.3048006096012192,AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"7627\"]]");
    p = add_epsg_def_ex (filter, first, last, 7628, "epsg", 7628,
        "NAD83(2011) / WISCRS Richland (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.3223129275 +lat_0=43.3223129275 +lon");
    add_proj4text (p, 1,
        "_0=-90.43055555555556 +k_0=1.0000375653 +x_0=202387.6047");
    add_proj4text (p, 2,
        "752095 +y_0=134255.4254508509 +ellps=GRS80 +units=us-ft ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Richland (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 8,
        "Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 9,
        "43.3223129275],PARAMETER[\"central_meridian\",-90.430555");
    add_srs_wkt (p, 10,
        "55555556],PARAMETER[\"scale_factor\",1.0000375653],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",664000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",440469.675],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 13,
        "92,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"7628\"]]");
    p = add_epsg_def_ex (filter, first, last, 7629, "epsg", 7629,
        "NAD83(2011) / WISCRS Rock (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.94444444444444 +lon_0=-89.07222222");
    add_proj4text (p, 1,
        "222222 +k=1.0000337311 +x_0=146304.2926085852 +y_0=0.006");
    add_proj4text (p, 2,
        "705613411226822 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Rock (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",41.94444444");
    add_srs_wkt (p, 9,
        "444444],PARAMETER[\"central_meridian\",-89.0722222222222");
    add_srs_wkt (p, 10,
        "2],PARAMETER[\"scale_factor\",1.0000337311],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",480000],PARAMETER[\"false_northing\",0.0");
    add_srs_wkt (p, 12,
        "22],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"7629\"]]");
    p = add_epsg_def_ex (filter, first, last, 7630, "epsg", 7630,
        "NAD83(2011) / WISCRS Rusk (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.91944444444444 +lon_0=-91.06666666");
    add_proj4text (p, 1,
        "666666 +k=1.0000495976 +x_0=250546.1013970028 +y_0=0.023");
    add_proj4text (p, 2,
        "46964693929388 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Rusk (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",43.91944444");
    add_srs_wkt (p, 9,
        "444444],PARAMETER[\"central_meridian\",-91.0666666666666");
    add_srs_wkt (p, 10,
        "6],PARAMETER[\"scale_factor\",1.0000495976],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",822000.0010000002],PARAMETER[\"false_nor");
    add_srs_wkt (p, 12,
        "thing\",0.077],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 13,
        "2,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"7630\"]]");
    p = add_epsg_def_ex (filter, first, last, 7631, "epsg", 7631,
        "NAD83(2011) / WISCRS Sauk (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.81944444444445 +lon_0=-89.90000000");
    add_proj4text (p, 1,
        "000001 +k=1.0000373868 +x_0=185623.5715519431 +y_0=0.005");
    add_proj4text (p, 2,
        "181610363220727 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Sauk (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",42.81944444");
    add_srs_wkt (p, 9,
        "444445],PARAMETER[\"central_meridian\",-89.9],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"scale_factor\",1.0000373868],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",609000.0010000002],PARAMETER[\"false_northing\",0.017");
    add_srs_wkt (p, 12,
        "],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 14,
        "HORITY[\"EPSG\",\"7631\"]]");
    p = add_epsg_def_ex (filter, first, last, 7632, "epsg", 7632,
        "NAD83(2011) / WISCRS Sawyer (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.90009913138888 +lat_0=45.90009913138");
    add_proj4text (p, 1,
        "888 +lon_0=-91.11666666666666 +k_0=1.0000573461 +x_0=216");
    add_proj4text (p, 2,
        "713.2337312675 +y_0=120734.1631699263 +ellps=GRS80 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Sawyer (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 8,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",45");
    add_srs_wkt (p, 9,
        ".90009913138888],PARAMETER[\"central_meridian\",-91.1166");
    add_srs_wkt (p, 10,
        "6666666666],PARAMETER[\"scale_factor\",1.0000573461],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",711000.0010000002],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",396108.667],UNIT[\"US survey foot\",0.3");
    add_srs_wkt (p, 13,
        "048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\"");
    add_srs_wkt (p, 14,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7632\"]]");
    p = add_epsg_def_ex (filter, first, last, 7633, "epsg", 7633,
        "NAD83(2011) / WISCRS Shawano (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.03611111111111 +lon_0=-88.60555555");
    add_proj4text (p, 1,
        "555555 +k=1.000032144 +x_0=262433.3251714504 +y_0=0.0094");
    add_proj4text (p, 2,
        "48818897637795 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Shawano (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 8,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",44.03611");
    add_srs_wkt (p, 9,
        "111111111],PARAMETER[\"central_meridian\",-88.6055555555");
    add_srs_wkt (p, 10,
        "5555],PARAMETER[\"scale_factor\",1.000032144],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_easting\",861000.0010000002],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",0.031],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 13,
        "192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[");
    add_srs_wkt (p, 14,
        "\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7633\"]]");
    p = add_epsg_def_ex (filter, first, last, 7634, "epsg", 7634,
        "NAD83(2011) / WISCRS St. Croix (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.03611111111111 +lon_0=-92.63333333");
    add_proj4text (p, 1,
        "333334 +k=1.0000381803 +x_0=165506.7300990602 +y_0=0.010");
    add_proj4text (p, 2,
        "36322072644145 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS St. Croix (ftUS)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "16\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",44.0361");
    add_srs_wkt (p, 9,
        "1111111111],PARAMETER[\"central_meridian\",-92.633333333");
    add_srs_wkt (p, 10,
        "33334],PARAMETER[\"scale_factor\",1.0000381803],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",542999.997],PARAMETER[\"false_northi");
    add_srs_wkt (p, 12,
        "ng\",0.034],UNIT[\"US survey foot\",0.3048006096012192,A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"7634\"]]");
    p = add_epsg_def_ex (filter, first, last, 7635, "epsg", 7635,
        "NAD83(2011) / WISCRS Taylor (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.17782208583333 +lat_0=45.17782208583");
    add_proj4text (p, 1,
        "333 +lon_0=-90.48333333333333 +k_0=1.0000597566 +x_0=187");
    add_proj4text (p, 2,
        "147.5742951486 +y_0=107746.7521463043 +ellps=GRS80 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Taylor (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 8,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",45");
    add_srs_wkt (p, 9,
        ".17782208583333],PARAMETER[\"central_meridian\",-90.4833");
    add_srs_wkt (p, 10,
        "3333333333],PARAMETER[\"scale_factor\",1.0000597566],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",614000],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",353499.136],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 13,
        "2192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 14,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7635\"]]");
    p = add_epsg_def_ex (filter, first, last, 7636, "epsg", 7636,
        "NAD83(2011) / WISCRS Trempealeau (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.16111111111111 +lon_0=-91.36666666");
    add_proj4text (p, 1,
        "666666 +k=1.0000361538 +x_0=256946.9138938278 +y_0=0.003");
    add_proj4text (p, 2,
        "962407924815849 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Trempealeau (ftUS)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",43.1");
    add_srs_wkt (p, 9,
        "6111111111111],PARAMETER[\"central_meridian\",-91.366666");
    add_srs_wkt (p, 10,
        "66666666],PARAMETER[\"scale_factor\",1.0000361538],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",843000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",0.013],UNIT[\"US survey foot\",0.3048006096012192,AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 14,
        "NORTH],AUTHORITY[\"EPSG\",\"7636\"]]");
    p = add_epsg_def_ex (filter, first, last, 7637, "epsg", 7637,
        "NAD83(2011) / WISCRS Vernon (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.57503293972223 +lat_0=43.57503293972");
    add_proj4text (p, 1,
        "223 +lon_0=-90.78333333333333 +k_0=1.0000408158 +x_0=222");
    add_proj4text (p, 2,
        "504.44500889 +y_0=47532.0603505207 +ellps=GRS80 +units=u");
    add_proj4text (p, 3,
        "s-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Vernon (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 8,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",43");
    add_srs_wkt (p, 9,
        ".57503293972223],PARAMETER[\"central_meridian\",-90.7833");
    add_srs_wkt (p, 10,
        "3333333333],PARAMETER[\"scale_factor\",1.0000408158],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",730000],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",155944.768],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 13,
        "2192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 14,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7637\"]]");
    p = add_epsg_def_ex (filter, first, last, 7638, "epsg", 7638,
        "NAD83(2011) / WISCRS Vilas (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.07784409055556 +lat_0=46.07784409055");
    add_proj4text (p, 1,
        "556 +lon_0=-89.48888888888889 +k_0=1.0000730142 +x_0=134");
    add_proj4text (p, 2,
        "417.0688341377 +y_0=50337.10927101854 +ellps=GRS80 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Vilas (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 8,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",46");
    add_srs_wkt (p, 9,
        ".07784409055556],PARAMETER[\"central_meridian\",-89.4888");
    add_srs_wkt (p, 10,
        "8888888889],PARAMETER[\"scale_factor\",1.0000730142],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",441000],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",165147.666],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 13,
        "2192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 14,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7638\"]]");
    p = add_epsg_def_ex (filter, first, last, 7639, "epsg", 7639,
        "NAD83(2011) / WISCRS Walworth (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.66946209694444 +lat_0=42.66946209694");
    add_proj4text (p, 1,
        "444 +lon_0=-88.54166666666667 +k_0=1.0000367192 +x_0=232");
    add_proj4text (p, 2,
        "562.8651257302 +y_0=111088.2224028448 +ellps=GRS80 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Walworth (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 8,
        "Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 9,
        "42.66946209694444],PARAMETER[\"central_meridian\",-88.54");
    add_srs_wkt (p, 10,
        "166666666667],PARAMETER[\"scale_factor\",1.0000367192],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_easting\",763000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 12,
        "thing\",364461.943],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 13,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 14,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7639\"]]");
    p = add_epsg_def_ex (filter, first, last, 7640, "epsg", 7640,
        "NAD83(2011) / WISCRS Washburn (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.96121983333334 +lat_0=45.96121983333");
    add_proj4text (p, 1,
        "334 +lon_0=-91.78333333333333 +k_0=1.0000475376 +x_0=234");
    add_proj4text (p, 2,
        "086.8681737363 +y_0=188358.6059436119 +ellps=GRS80 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Washburn (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 8,
        "Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 9,
        "45.96121983333334],PARAMETER[\"central_meridian\",-91.78");
    add_srs_wkt (p, 10,
        "333333333333],PARAMETER[\"scale_factor\",1.0000475376],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_easting\",768000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 12,
        "thing\",617973.193],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 13,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 14,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7640\"]]");
    p = add_epsg_def_ex (filter, first, last, 7641, "epsg", 7641,
        "NAD83(2011) / WISCRS Washington (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.91805555555555 +lon_0=-88.06388888");
    add_proj4text (p, 1,
        "888888 +k=1.00003738 +x_0=120091.4414020828 +y_0=0.00304");
    add_proj4text (p, 2,
        "8006096012192 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Washington (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 8,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",42.918");
    add_srs_wkt (p, 9,
        "05555555555],PARAMETER[\"central_meridian\",-88.06388888");
    add_srs_wkt (p, 10,
        "888888],PARAMETER[\"scale_factor\",1.00003738],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_easting\",394000.004],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",0.01],UNIT[\"US survey foot\",0.3048006096012192,AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",N");
    add_srs_wkt (p, 14,
        "ORTH],AUTHORITY[\"EPSG\",\"7641\"]]");
    p = add_epsg_def_ex (filter, first, last, 7642, "epsg", 7642,
        "NAD83(2011) / WISCRS Waukesha (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.56944444444445 +lon_0=-88.22499999");
    add_proj4text (p, 1,
        "999999 +k=1.0000346179 +x_0=208788.4178816358 +y_0=0.003");
    add_proj4text (p, 2,
        "352806705613411 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Waukesha (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 8,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",42.56944");
    add_srs_wkt (p, 9,
        "444444445],PARAMETER[\"central_meridian\",-88.225],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"scale_factor\",1.0000346179],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",685000.0010000002],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 12,
        "0.011],UNIT[\"US survey foot\",0.3048006096012192,AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 14,
        "H],AUTHORITY[\"EPSG\",\"7642\"]]");
    p = add_epsg_def_ex (filter, first, last, 7643, "epsg", 7643,
        "NAD83(2011) / WISCRS Waupaca (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.42027777777778 +lon_0=-88.81666666");
    add_proj4text (p, 1,
        "666666 +k=1.0000333645 +x_0=185013.9709423419 +y_0=0.007");
    add_proj4text (p, 2,
        "010414020828041 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Waupaca (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 8,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",43.42027");
    add_srs_wkt (p, 9,
        "777777778],PARAMETER[\"central_meridian\",-88.8166666666");
    add_srs_wkt (p, 10,
        "6666],PARAMETER[\"scale_factor\",1.0000333645],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_easting\",607000.003],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",0.023],UNIT[\"US survey foot\",0.3048006096012192,AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 14,
        "NORTH],AUTHORITY[\"EPSG\",\"7643\"]]");
    p = add_epsg_def_ex (filter, first, last, 7644, "epsg", 7644,
        "NAD83(2011) / WISCRS Waushara (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.11394404583334 +lat_0=44.11394404583");
    add_proj4text (p, 1,
        "334 +lon_0=-89.24166666666667 +k_0=1.0000392096 +x_0=120");
    add_proj4text (p, 2,
        "091.4401828804 +y_0=45069.7588011176 +ellps=GRS80 +units");
    add_proj4text (p, 3,
        "=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Waushara (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 8,
        "Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 9,
        "44.11394404583334],PARAMETER[\"central_meridian\",-89.24");
    add_srs_wkt (p, 10,
        "166666666667],PARAMETER[\"scale_factor\",1.0000392096],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_easting\",394000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 12,
        "thing\",147866.367],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 13,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 14,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7644\"]]");
    p = add_epsg_def_ex (filter, first, last, 7645, "epsg", 7645,
        "NAD83(2011) / WISCRS Wood (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.36259546944444 +lat_0=44.36259546944");
    add_proj4text (p, 1,
        "444 +lon_0=-90 +k_0=1.0000421209 +x_0=208483.6172720346 ");
    add_proj4text (p, 2,
        "+y_0=134589.7539243078 +ellps=GRS80 +units=us-ft +no_def");
    add_proj4text (p, 3,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Wood (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 8,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",44.");
    add_srs_wkt (p, 9,
        "36259546944444],PARAMETER[\"central_meridian\",-90],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",1.0000421209],PARAMETER[\"false_e");
    add_srs_wkt (p, 11,
        "asting\",684000.0010000002],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",441566.551],UNIT[\"US survey foot\",0.3048006096012192,");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"7645\"]]");
    p = add_epsg_def_ex (filter, first, last, 7683, "epsg", 7683,
        "GSK-2011", 1, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378136.5 +b=6356751.757955603 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"GSK-2011\",DATUM[\"Geodezicheskaya_Sistema_Koor");
    add_srs_wkt (p, 1,
        "dinat_2011\",SPHEROID[\"GSK-2011\",6378136.5,298.2564151");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"1025\"]],AUTHORITY[\"EPSG\",\"1159");
    add_srs_wkt (p, 3,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 4,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 6,
        "AST],AUTHORITY[\"EPSG\",\"7683\"]]");
    p = add_epsg_def_ex (filter, first, last, 7686, "epsg", 7686,
        "Kyrg-06", 1, 1,
        "GRS 1980", "Greenwich",
        "Kyrgyzstan_Geodetic_Datum_2006", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"Kyrg-06\",DATUM[\"Kyrgyzstan_Geodetic_Datum_200");
    add_srs_wkt (p, 1,
        "6\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORIT");
    add_srs_wkt (p, 2,
        "Y[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1160\"]],PRIM");
    add_srs_wkt (p, 3,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"7686\"]]");
    p = add_epsg_def_ex (filter, first, last, 7692, "epsg", 7692,
        "Kyrg-06 / zone 1", 0, 0,
        "GRS 1980", "Greenwich",
        "Kyrgyzstan_Geodetic_Datum_2006", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=68.51666666666667 +k=1 +x_0=");
    add_proj4text (p, 1,
        "1300000 +y_0=14743.5 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kyrg-06 / zone 1\",GEOGCS[\"Kyrg-06\",DATUM[\"K");
    add_srs_wkt (p, 1,
        "yrgyzstan_Geodetic_Datum_2006\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1160\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"7686\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",68.51666666");
    add_srs_wkt (p, 9,
        "666667],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",1300000],PARAMETER[\"false_northing\",14743.5]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"7692\"]]");
    p = add_epsg_def_ex (filter, first, last, 7693, "epsg", 7693,
        "Kyrg-06 / zone 2", 0, 0,
        "GRS 1980", "Greenwich",
        "Kyrgyzstan_Geodetic_Datum_2006", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=71.51666666666667 +k=1 +x_0=");
    add_proj4text (p, 1,
        "2300000 +y_0=14743.5 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kyrg-06 / zone 2\",GEOGCS[\"Kyrg-06\",DATUM[\"K");
    add_srs_wkt (p, 1,
        "yrgyzstan_Geodetic_Datum_2006\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1160\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"7686\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",71.51666666");
    add_srs_wkt (p, 9,
        "666667],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",2300000],PARAMETER[\"false_northing\",14743.5]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"7693\"]]");
    p = add_epsg_def_ex (filter, first, last, 7694, "epsg", 7694,
        "Kyrg-06 / zone 3", 0, 0,
        "GRS 1980", "Greenwich",
        "Kyrgyzstan_Geodetic_Datum_2006", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=74.51666666666667 +k=1 +x_0=");
    add_proj4text (p, 1,
        "3300000 +y_0=14743.5 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kyrg-06 / zone 3\",GEOGCS[\"Kyrg-06\",DATUM[\"K");
    add_srs_wkt (p, 1,
        "yrgyzstan_Geodetic_Datum_2006\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1160\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"7686\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",74.51666666");
    add_srs_wkt (p, 9,
        "666667],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",3300000],PARAMETER[\"false_northing\",14743.5]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"7694\"]]");
    p = add_epsg_def_ex (filter, first, last, 7695, "epsg", 7695,
        "Kyrg-06 / zone 4", 0, 0,
        "GRS 1980", "Greenwich",
        "Kyrgyzstan_Geodetic_Datum_2006", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=77.51666666666667 +k=1 +x_0=");
    add_proj4text (p, 1,
        "4300000 +y_0=14743.5 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kyrg-06 / zone 4\",GEOGCS[\"Kyrg-06\",DATUM[\"K");
    add_srs_wkt (p, 1,
        "yrgyzstan_Geodetic_Datum_2006\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1160\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"7686\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",77.51666666");
    add_srs_wkt (p, 9,
        "666667],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",4300000],PARAMETER[\"false_northing\",14743.5]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"7695\"]]");
    p = add_epsg_def_ex (filter, first, last, 7696, "epsg", 7696,
        "Kyrg-06 / zone 5", 0, 0,
        "GRS 1980", "Greenwich",
        "Kyrgyzstan_Geodetic_Datum_2006", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=80.51666666666667 +k=1 +x_0=");
    add_proj4text (p, 1,
        "5300000 +y_0=14743.5 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Kyrg-06 / zone 5\",GEOGCS[\"Kyrg-06\",DATUM[\"K");
    add_srs_wkt (p, 1,
        "yrgyzstan_Geodetic_Datum_2006\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"1160\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"7686\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",80.51666666");
    add_srs_wkt (p, 9,
        "666667],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "easting\",5300000],PARAMETER[\"false_northing\",14743.5]");
    add_srs_wkt (p, 11,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"E");
    add_srs_wkt (p, 12,
        "asting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"7696\"]]");
    p = add_epsg_def_ex (filter, first, last, 7755, "epsg", 7755,
        "WGS 84 / India NSF LCC", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=12.472955 +lat_2=35.17280444444444 +lat");
    add_proj4text (p, 1,
        "_0=24 +lon_0=80 +x_0=4000000 +y_0=4000000 +datum=WGS84 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / India NSF LCC\",GEOGCS[\"WGS 84\",DATU");
    add_srs_wkt (p, 1,
        "M[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326");
    add_srs_wkt (p, 3,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 4,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 6,
        "AST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 7,
        "Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
        ",12.472955],PARAMETER[\"standard_parallel_2\",35.1728044");
    add_srs_wkt (p, 9,
        "4444444],PARAMETER[\"latitude_of_origin\",24],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",80],PARAMETER[\"false_easting\",400");
    add_srs_wkt (p, 11,
        "0000],PARAMETER[\"false_northing\",4000000],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7755\"]]");
    p = add_epsg_def_ex (filter, first, last, 7756, "epsg", 7756,
        "WGS 84 / Andhra Pradesh", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=13.75 +lat_2=18.75 +lat_0=16.25543298 +");
    add_proj4text (p, 1,
        "lon_0=80.875 +x_0=1000000 +y_0=1000000 +datum=WGS84 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Andhra Pradesh\",GEOGCS[\"WGS 84\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.25722356");
    add_srs_wkt (p, 2,
        "3,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"632");
    add_srs_wkt (p, 3,
        "6\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 4,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 6,
        "EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lambert");
    add_srs_wkt (p, 7,
        "_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\"");
    add_srs_wkt (p, 8,
        ",13.75],PARAMETER[\"standard_parallel_2\",18.75],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"latitude_of_origin\",16.25543298],PARAMETER[\"centr");
    add_srs_wkt (p, 10,
        "al_meridian\",80.875],PARAMETER[\"false_easting\",100000");
    add_srs_wkt (p, 11,
        "0],PARAMETER[\"false_northing\",1000000],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"7756\"]]");
    p = add_epsg_def_ex (filter, first, last, 7757, "epsg", 7757,
        "WGS 84 / Arunachal Pradesh", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=27 +lat_2=29 +lat_0=28.00157897 +lon_0=");
    add_proj4text (p, 1,
        "94.5 +x_0=1000000 +y_0=1000000 +datum=WGS84 +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Arunachal Pradesh\",GEOGCS[\"WGS 84\",");
    add_srs_wkt (p, 1,
        "DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.25722");
    add_srs_wkt (p, 2,
        "3563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 6,
        "\",EAST],AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 7,
        "ert_Conformal_Conic_2SP\"],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 8,
        "_1\",27],PARAMETER[\"standard_parallel_2\",29],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"latitude_of_origin\",28.00157897],PARAMETER[\"central");
    add_srs_wkt (p, 10,
        "_meridian\",94.5],PARAMETER[\"false_easting\",1000000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",1000000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"7757\"]]");
    p = add_epsg_def_ex (filter, first, last, 7758, "epsg", 7758,
        "WGS 84 / Assam", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=24.66666666666667 +lat_2=27.33333333333");
    add_proj4text (p, 1,
        "333 +lat_0=26.00257703 +lon_0=92.75 +x_0=1000000 +y_0=10");
    add_proj4text (p, 2,
        "00000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Assam\",GEOGCS[\"WGS 84\",DATUM[\"WGS_");
    add_srs_wkt (p, 1,
        "1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRI");
    add_srs_wkt (p, 3,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 7,
        "_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",24.66666");
    add_srs_wkt (p, 8,
        "666666667],PARAMETER[\"standard_parallel_2\",27.33333333");
    add_srs_wkt (p, 9,
        "333333],PARAMETER[\"latitude_of_origin\",26.00257703],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"central_meridian\",92.75],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",1000000],PARAMETER[\"false_northing\",1000000],U");
    add_srs_wkt (p, 12,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7758\"]]");
    p = add_epsg_def_ex (filter, first, last, 7759, "epsg", 7759,
        "WGS 84 / Bihar", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=24.625 +lat_2=27.125 +lat_0=25.87725247");
    add_proj4text (p, 1,
        " +lon_0=85.875 +x_0=1000000 +y_0=1000000 +datum=WGS84 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Bihar\",GEOGCS[\"WGS 84\",DATUM[\"WGS_");
    add_srs_wkt (p, 1,
        "1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRI");
    add_srs_wkt (p, 3,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 7,
        "_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",24.625],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"standard_parallel_2\",27.125],PARAMETER[\"la");
    add_srs_wkt (p, 9,
        "titude_of_origin\",25.87725247],PARAMETER[\"central_meri");
    add_srs_wkt (p, 10,
        "dian\",85.875],PARAMETER[\"false_easting\",1000000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"7759\"]]");
    p = add_epsg_def_ex (filter, first, last, 7760, "epsg", 7760,
        "WGS 84 / Delhi", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=28.375 +lat_2=28.875 +lat_0=28.62510126");
    add_proj4text (p, 1,
        " +lon_0=77 +x_0=1000000 +y_0=1000000 +datum=WGS84 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Delhi\",GEOGCS[\"WGS 84\",DATUM[\"WGS_");
    add_srs_wkt (p, 1,
        "1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRI");
    add_srs_wkt (p, 3,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 7,
        "_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",28.375],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"standard_parallel_2\",28.875],PARAMETER[\"la");
    add_srs_wkt (p, 9,
        "titude_of_origin\",28.62510126],PARAMETER[\"central_meri");
    add_srs_wkt (p, 10,
        "dian\",77],PARAMETER[\"false_easting\",1000000],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_northing\",1000000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"7760\"]]");
    p = add_epsg_def_ex (filter, first, last, 7761, "epsg", 7761,
        "WGS 84 / Gujarat", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=20.79166666666667 +lat_2=23.95833333333");
    add_proj4text (p, 1,
        "333 +lat_0=22.37807121 +lon_0=71.375 +x_0=1000000 +y_0=1");
    add_proj4text (p, 2,
        "000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Gujarat\",GEOGCS[\"WGS 84\",DATUM[\"WG");
    add_srs_wkt (p, 1,
        "S_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 7,
        "mal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",20.79");
    add_srs_wkt (p, 8,
        "166666666667],PARAMETER[\"standard_parallel_2\",23.95833");
    add_srs_wkt (p, 9,
        "333333333],PARAMETER[\"latitude_of_origin\",22.37807121]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"central_meridian\",71.375],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",1000000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 12,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7761\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 7762, "epsg", 7762,
        "WGS 84 / Haryana", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=28.08333333333333 +lat_2=30.41666666666");
    add_proj4text (p, 1,
        "667 +lat_0=29.25226266 +lon_0=76 +x_0=1000000 +y_0=10000");
    add_proj4text (p, 2,
        "00 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / Haryana\",GEOGCS[\"WGS 84\",DATUM[\"WG");
    add_srs_wkt (p, 1,
        "S_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHO");
    add_srs_wkt (p, 2,
        "RITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],P");
    add_srs_wkt (p, 3,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 4,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 5,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 7,
        "mal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",28.08");
    add_srs_wkt (p, 8,
        "333333333333],PARAMETER[\"standard_parallel_2\",30.41666");
    add_srs_wkt (p, 9,
        "666666667],PARAMETER[\"latitude_of_origin\",29.25226266]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"central_meridian\",76],PARAMETER[\"false_ea");
    add_srs_wkt (p, 11,
        "sting\",1000000],PARAMETER[\"false_northing\",1000000],U");
    add_srs_wkt (p, 12,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7762\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

