/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Wed Mar 21 19:30:16 2018

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_36 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 7330, "epsg", 7330,
        "NAD83(2011) / InGCS Knox (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.4 +lon_0=-87.45 +k=1.000015 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Knox (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",38.4],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"central_meridian\",-87.45],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1.000015],PARAMETER[\"false_easting\",787400],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",118110],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 12,
        ".3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7330\"]]");
    p = add_epsg_def_ex (filter, first, last, 7331, "epsg", 7331,
        "NAD83(2011) / InGCS LaGrange-Noble (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.25 +lon_0=-85.45 +k=1.000037 +x_0=");
    add_proj4text (p, 1,
        "240000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS LaGrange-Noble (m)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 8,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",41.25]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"central_meridian\",-85.45],PARAMETER[\"scal");
    add_srs_wkt (p, 10,
        "e_factor\",1.000037],PARAMETER[\"false_easting\",240000]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",36000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"7331\"]]");
    p = add_epsg_def_ex (filter, first, last, 7332, "epsg", 7332,
        "NAD83(2011) / InGCS LaGrange-Noble (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.25 +lon_0=-85.45 +k=1.000037 +x_0=");
    add_proj4text (p, 1,
        "240000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS LaGrange-Noble (ftUS)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 7,
        "de\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 8,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",41");
    add_srs_wkt (p, 9,
        ".25],PARAMETER[\"central_meridian\",-85.45],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1.000037],PARAMETER[\"false_easting\",787");
    add_srs_wkt (p, 11,
        "400],PARAMETER[\"false_northing\",118110],UNIT[\"US surv");
    add_srs_wkt (p, 12,
        "ey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"7332\"]]");
    p = add_epsg_def_ex (filter, first, last, 7333, "epsg", 7333,
        "NAD83(2011) / InGCS Lake-Newton (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.7 +lon_0=-87.40000000000001 +k=1.0");
    add_proj4text (p, 1,
        "00026 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Lake-Newton (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 8,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",40.7],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"central_meridian\",-87.4],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 10,
        "ctor\",1.000026],PARAMETER[\"false_easting\",240000],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",36000],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"7333\"]]");
    p = add_epsg_def_ex (filter, first, last, 7334, "epsg", 7334,
        "NAD83(2011) / InGCS Lake-Newton (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.7 +lon_0=-87.40000000000001 +k=1.0");
    add_proj4text (p, 1,
        "00026 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=us-ft +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Lake-Newton (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 8,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",40.7],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",-87.4],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",1.000026],PARAMETER[\"false_easting\",787400],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",118110],UNIT[\"US survey foo");
    add_srs_wkt (p, 12,
        "t\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXI");
    add_srs_wkt (p, 13,
        "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"733");
    add_srs_wkt (p, 14,
        "4\"]]");
    p = add_epsg_def_ex (filter, first, last, 7335, "epsg", 7335,
        "NAD83(2011) / InGCS LaPorte-Pulaski-Starke (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.9 +lon_0=-86.75 +k=1.000027 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS LaPorte-Pulaski-Starke (m)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_R");
    add_srs_wkt (p, 2,
        "eference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298");
    add_srs_wkt (p, 3,
        ".257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 9,
        ",40.9],PARAMETER[\"central_meridian\",-86.75],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"scale_factor\",1.000027],PARAMETER[\"false_easting\",2");
    add_srs_wkt (p, 11,
        "40000],PARAMETER[\"false_northing\",36000],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"7335\"]]");
    p = add_epsg_def_ex (filter, first, last, 7336, "epsg", 7336,
        "NAD83(2011) / InGCS LaPorte-Pulaski-Starke (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.9 +lon_0=-86.75 +k=1.000027 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS LaPorte-Pulaski-Starke (ftU");
    add_srs_wkt (p, 1,
        "S)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spati");
    add_srs_wkt (p, 2,
        "al_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",40.9],PARAMETER[\"central_meridian\",-86.75],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"scale_factor\",1.000027],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",787400],PARAMETER[\"false_northing\",118110],UNIT[\"U");
    add_srs_wkt (p, 12,
        "S survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"7336\"]]");
    p = add_epsg_def_ex (filter, first, last, 7337, "epsg", 7337,
        "NAD83(2011) / InGCS Monroe-Morgan (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.95 +lon_0=-86.5 +k=1.000028 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Monroe-Morgan (m)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "16\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",38.95],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",-86.5],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",1.000028],PARAMETER[\"false_easting\",240000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",36000],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NO");
    add_srs_wkt (p, 13,
        "RTH],AUTHORITY[\"EPSG\",\"7337\"]]");
    p = add_epsg_def_ex (filter, first, last, 7338, "epsg", 7338,
        "NAD83(2011) / InGCS Monroe-Morgan (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.95 +lon_0=-86.5 +k=1.000028 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Monroe-Morgan (ftUS)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refere");
    add_srs_wkt (p, 2,
        "nce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 3,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",38.9");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"central_meridian\",-86.5],PARAMETER[\"sca");
    add_srs_wkt (p, 10,
        "le_factor\",1.000028],PARAMETER[\"false_easting\",787400");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",118110],UNIT[\"US survey ");
    add_srs_wkt (p, 12,
        "foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "7338\"]]");
    p = add_epsg_def_ex (filter, first, last, 7339, "epsg", 7339,
        "NAD83(2011) / InGCS Montgomery-Putnam (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.45 +lon_0=-86.95 +k=1.000031 +x_0=");
    add_proj4text (p, 1,
        "240000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Montgomery-Putnam (m)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 7,
        "de\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 8,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",39");
    add_srs_wkt (p, 9,
        ".45],PARAMETER[\"central_meridian\",-86.95],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1.000031],PARAMETER[\"false_easting\",240");
    add_srs_wkt (p, 11,
        "000],PARAMETER[\"false_northing\",36000],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"7339\"]]");
    p = add_epsg_def_ex (filter, first, last, 7340, "epsg", 7340,
        "NAD83(2011) / InGCS Montgomery-Putnam (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.45 +lon_0=-86.95 +k=1.000031 +x_0=");
    add_proj4text (p, 1,
        "240000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Montgomery-Putnam (ftUS)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 2,
        "ference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 3,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 7,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"");
    add_srs_wkt (p, 8,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 9,
        "39.45],PARAMETER[\"central_meridian\",-86.95],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"scale_factor\",1.000031],PARAMETER[\"false_easting\",7");
    add_srs_wkt (p, 11,
        "87400],PARAMETER[\"false_northing\",118110],UNIT[\"US su");
    add_srs_wkt (p, 12,
        "rvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 13,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"7340\"]]");
    p = add_epsg_def_ex (filter, first, last, 7341, "epsg", 7341,
        "NAD83(2011) / InGCS Owen (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.15 +lon_0=-86.90000000000001 +k=1.");
    add_proj4text (p, 1,
        "000026 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Owen (m)\",GEOGCS[\"NAD83(2");
    add_srs_wkt (p, 1,
        "011)\",DATUM[\"NAD83_National_Spatial_Reference_System_2");
    add_srs_wkt (p, 2,
        "011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",39.15],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",-86.9],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "1.000026],PARAMETER[\"false_easting\",240000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",36000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 13,
        "ORITY[\"EPSG\",\"7341\"]]");
    p = add_epsg_def_ex (filter, first, last, 7342, "epsg", 7342,
        "NAD83(2011) / InGCS Owen (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.15 +lon_0=-86.90000000000001 +k=1.");
    add_proj4text (p, 1,
        "000026 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=us-ft ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Owen (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",39.15],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"central_meridian\",-86.9],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1.000026],PARAMETER[\"false_easting\",787400],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",118110],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 12,
        ".3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7342\"]]");
    p = add_epsg_def_ex (filter, first, last, 7343, "epsg", 7343,
        "NAD83(2011) / InGCS Parke-Vermillion (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.6 +lon_0=-87.34999999999999 +k=1.0");
    add_proj4text (p, 1,
        "00022 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Parke-Vermillion (m)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refere");
    add_srs_wkt (p, 2,
        "nce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 3,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",39.6");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-87.35],PARAMETER[\"sca");
    add_srs_wkt (p, 10,
        "le_factor\",1.000022],PARAMETER[\"false_easting\",240000");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",36000],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"7343\"]]");
    p = add_epsg_def_ex (filter, first, last, 7344, "epsg", 7344,
        "NAD83(2011) / InGCS Parke-Vermillion (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.6 +lon_0=-87.34999999999999 +k=1.0");
    add_proj4text (p, 1,
        "00022 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=us-ft +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Parke-Vermillion (ftUS)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",3");
    add_srs_wkt (p, 9,
        "9.6],PARAMETER[\"central_meridian\",-87.35],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1.000022],PARAMETER[\"false_easting\",787");
    add_srs_wkt (p, 11,
        "400],PARAMETER[\"false_northing\",118110],UNIT[\"US surv");
    add_srs_wkt (p, 12,
        "ey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"7344\"]]");
    p = add_epsg_def_ex (filter, first, last, 7345, "epsg", 7345,
        "NAD83(2011) / InGCS Perry (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.8 +lon_0=-86.7 +k=1.00002 +x_0=240");
    add_proj4text (p, 1,
        "000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Perry (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 8,
        "cator\"],PARAMETER[\"latitude_of_origin\",37.8],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-86.7],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1.00002],PARAMETER[\"false_easting\",240000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",36000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 13,
        "ORITY[\"EPSG\",\"7345\"]]");
    p = add_epsg_def_ex (filter, first, last, 7346, "epsg", 7346,
        "NAD83(2011) / InGCS Perry (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.8 +lon_0=-86.7 +k=1.00002 +x_0=240");
    add_proj4text (p, 1,
        "000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Perry (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",37.8],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"central_meridian\",-86.7],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1.00002],PARAMETER[\"false_easting\",787400],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",118110],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 12,
        "3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7346\"]]");
    p = add_epsg_def_ex (filter, first, last, 7347, "epsg", 7347,
        "NAD83(2011) / InGCS Pike-Warrick (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.85 +lon_0=-87.3 +k=1.000015 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Pike-Warrick (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 8,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",37.85],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",-87.3],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",1.000015],PARAMETER[\"false_easting\",240000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",36000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"7347\"]]");
    p = add_epsg_def_ex (filter, first, last, 7348, "epsg", 7348,
        "NAD83(2011) / InGCS Pike-Warrick (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.85 +lon_0=-87.3 +k=1.000015 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Pike-Warrick (ftUS)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",37.8");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"central_meridian\",-87.3],PARAMETER[\"sca");
    add_srs_wkt (p, 10,
        "le_factor\",1.000015],PARAMETER[\"false_easting\",787400");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_northing\",118110],UNIT[\"US survey ");
    add_srs_wkt (p, 12,
        "foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "7348\"]]");
    p = add_epsg_def_ex (filter, first, last, 7349, "epsg", 7349,
        "NAD83(2011) / InGCS Posey (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.75 +lon_0=-87.95 +k=1.000013 +x_0=");
    add_proj4text (p, 1,
        "240000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Posey (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 8,
        "cator\"],PARAMETER[\"latitude_of_origin\",37.75],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-87.95],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",1.000013],PARAMETER[\"false_easting\",240000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",36000],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"7349\"]]");
    p = add_epsg_def_ex (filter, first, last, 7350, "epsg", 7350,
        "NAD83(2011) / InGCS Posey (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.75 +lon_0=-87.95 +k=1.000013 +x_0=");
    add_proj4text (p, 1,
        "240000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Posey (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",37.75],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",-87.95],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",1.000013],PARAMETER[\"false_easting\",787400],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",118110],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
        ",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7350\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 7351, "epsg", 7351,
        "NAD83(2011) / InGCS Randolph-Wayne (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.7 +lon_0=-85.05 +k=1.000044 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Randolph-Wayne (m)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 8,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",39.7],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",-85.05],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",1.000044],PARAMETER[\"false_easting\",240000],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",36000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",N");
    add_srs_wkt (p, 13,
        "ORTH],AUTHORITY[\"EPSG\",\"7351\"]]");
    p = add_epsg_def_ex (filter, first, last, 7352, "epsg", 7352,
        "NAD83(2011) / InGCS Randolph-Wayne (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.7 +lon_0=-85.05 +k=1.000044 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Randolph-Wayne (ftUS)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 7,
        "de\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 8,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",39");
    add_srs_wkt (p, 9,
        ".7],PARAMETER[\"central_meridian\",-85.05],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1.000044],PARAMETER[\"false_easting\",7874");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",118110],UNIT[\"US surve");
    add_srs_wkt (p, 12,
        "y foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]");
    add_srs_wkt (p, 13,
        "],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"7352\"]]");
    p = add_epsg_def_ex (filter, first, last, 7353, "epsg", 7353,
        "NAD83(2011) / InGCS Ripley (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.9 +lon_0=-85.3 +k=1.000038 +x_0=24");
    add_proj4text (p, 1,
        "0000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Ripley (m)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(2011)\",DATUM[\"NAD83_National_Spatial_Reference_System");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",38.9],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-85.3],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1.000038],PARAMETER[\"false_easting\",240000],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",36000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"7353\"]]");
    p = add_epsg_def_ex (filter, first, last, 7354, "epsg", 7354,
        "NAD83(2011) / InGCS Ripley (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.9 +lon_0=-85.3 +k=1.000038 +x_0=24");
    add_proj4text (p, 1,
        "0000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Ripley (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",38.9],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",-85.3],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1.000038],PARAMETER[\"false_easting\",787400],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",118110],UNIT[\"US survey foot\",");
    add_srs_wkt (p, 12,
        "0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7354\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 7355, "epsg", 7355,
        "NAD83(2011) / InGCS Shelby (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.3 +lon_0=-85.90000000000001 +k=1.0");
    add_proj4text (p, 1,
        "0003 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Shelby (m)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(2011)\",DATUM[\"NAD83_National_Spatial_Reference_System");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",39.3],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-85.9],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1.00003],PARAMETER[\"false_easting\",240000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",36000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 13,
        "ORITY[\"EPSG\",\"7355\"]]");
    p = add_epsg_def_ex (filter, first, last, 7356, "epsg", 7356,
        "NAD83(2011) / InGCS Shelby (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.3 +lon_0=-85.90000000000001 +k=1.0");
    add_proj4text (p, 1,
        "0003 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=us-ft +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Shelby (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",39.3],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",-85.9],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1.00003],PARAMETER[\"false_easting\",787400],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",118110],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 12,
        ".3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7356\"]]");
    p = add_epsg_def_ex (filter, first, last, 7357, "epsg", 7357,
        "NAD83(2011) / InGCS Spencer (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.75 +lon_0=-87.05 +k=1.000014 +x_0=");
    add_proj4text (p, 1,
        "240000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Spencer (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",37.75],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"central_meridian\",-87.05],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1.000014],PARAMETER[\"false_easting\",240000],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_northing\",36000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"7357\"]]");
    p = add_epsg_def_ex (filter, first, last, 7358, "epsg", 7358,
        "NAD83(2011) / InGCS Spencer (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.75 +lon_0=-87.05 +k=1.000014 +x_0=");
    add_proj4text (p, 1,
        "240000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Spencer (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",37.75],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"central_meridian\",-87.05],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 10,
        "ctor\",1.000014],PARAMETER[\"false_easting\",787400],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",118110],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
        ",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7358\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 7359, "epsg", 7359,
        "NAD83(2011) / InGCS Steuben (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.5 +lon_0=-85 +k=1.000041 +x_0=2400");
    add_proj4text (p, 1,
        "00 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Steuben (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",41.5],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"central_meridian\",-85],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1.000041],PARAMETER[\"false_easting\",240000],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_northing\",36000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"7359\"]]");
    p = add_epsg_def_ex (filter, first, last, 7360, "epsg", 7360,
        "NAD83(2011) / InGCS Steuben (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.5 +lon_0=-85 +k=1.000041 +x_0=2400");
    add_proj4text (p, 1,
        "00 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Steuben (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",41.5],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",-85],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",1.000041],PARAMETER[\"false_easting\",787400],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",118110],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 12,
        "3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7360\"]]");
    p = add_epsg_def_ex (filter, first, last, 7361, "epsg", 7361,
        "NAD83(2011) / InGCS Sullivan (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.9 +lon_0=-87.5 +k=1.000017 +x_0=24");
    add_proj4text (p, 1,
        "0000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Sullivan (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",38.9],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"central_meridian\",-87.5],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 10,
        "r\",1.000017],PARAMETER[\"false_easting\",240000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",36000],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"7361\"]]");
    p = add_epsg_def_ex (filter, first, last, 7362, "epsg", 7362,
        "NAD83(2011) / InGCS Sullivan (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38.9 +lon_0=-87.5 +k=1.000017 +x_0=24");
    add_proj4text (p, 1,
        "0000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Sullivan (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 8,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",38.9],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"central_meridian\",-87.5],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 10,
        "ctor\",1.000017],PARAMETER[\"false_easting\",787400],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",118110],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
        ",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7362\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 7363, "epsg", 7363,
        "NAD83(2011) / InGCS Tippecanoe-White (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.2 +lon_0=-86.90000000000001 +k=1.0");
    add_proj4text (p, 1,
        "00026 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Tippecanoe-White (m)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refere");
    add_srs_wkt (p, 2,
        "nce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 3,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",40.2");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-86.9],PARAMETER[\"scal");
    add_srs_wkt (p, 10,
        "e_factor\",1.000026],PARAMETER[\"false_easting\",240000]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",36000],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 12,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 13,
        "NORTH],AUTHORITY[\"EPSG\",\"7363\"]]");
    p = add_epsg_def_ex (filter, first, last, 7364, "epsg", 7364,
        "NAD83(2011) / InGCS Tippecanoe-White (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.2 +lon_0=-86.90000000000001 +k=1.0");
    add_proj4text (p, 1,
        "00026 +x_0=240000 +y_0=36000 +ellps=GRS80 +units=us-ft +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Tippecanoe-White (ftUS)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",4");
    add_srs_wkt (p, 9,
        "0.2],PARAMETER[\"central_meridian\",-86.9],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1.000026],PARAMETER[\"false_easting\",7874");
    add_srs_wkt (p, 11,
        "00],PARAMETER[\"false_northing\",118110],UNIT[\"US surve");
    add_srs_wkt (p, 12,
        "y foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]");
    add_srs_wkt (p, 13,
        "],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"7364\"]]");
    p = add_epsg_def_ex (filter, first, last, 7365, "epsg", 7365,
        "NAD83(2011) / InGCS Vanderburgh (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.8 +lon_0=-87.55 +k=1.000015 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Vanderburgh (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 8,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",37.8],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"central_meridian\",-87.55],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",1.000015],PARAMETER[\"false_easting\",240000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",36000],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 13,
        "TH],AUTHORITY[\"EPSG\",\"7365\"]]");
    p = add_epsg_def_ex (filter, first, last, 7366, "epsg", 7366,
        "NAD83(2011) / InGCS Vanderburgh (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=37.8 +lon_0=-87.55 +k=1.000015 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Vanderburgh (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referenc");
    add_srs_wkt (p, 2,
        "e_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222");
    add_srs_wkt (p, 3,
        "101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1");
    add_srs_wkt (p, 4,
        "116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901");
    add_srs_wkt (p, 5,
        "\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 6,
        "\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\"");
    add_srs_wkt (p, 7,
        ",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transv");
    add_srs_wkt (p, 8,
        "erse_Mercator\"],PARAMETER[\"latitude_of_origin\",37.8],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",-87.55],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",1.000015],PARAMETER[\"false_easting\",787400],");
    add_srs_wkt (p, 11,
        "PARAMETER[\"false_northing\",118110],UNIT[\"US survey fo");
    add_srs_wkt (p, 12,
        "ot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"73");
    add_srs_wkt (p, 14,
        "66\"]]");
    p = add_epsg_def_ex (filter, first, last, 7367, "epsg", 7367,
        "NAD83(2011) / InGCS Vigo (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.25 +lon_0=-87.45 +k=1.00002 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Vigo (m)\",GEOGCS[\"NAD83(2");
    add_srs_wkt (p, 1,
        "011)\",DATUM[\"NAD83_National_Spatial_Reference_System_2");
    add_srs_wkt (p, 2,
        "011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",39.25],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",-87.45],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",1.00002],PARAMETER[\"false_easting\",240000],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_northing\",36000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 13,
        "ORITY[\"EPSG\",\"7367\"]]");
    p = add_epsg_def_ex (filter, first, last, 7368, "epsg", 7368,
        "NAD83(2011) / InGCS Vigo (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=39.25 +lon_0=-87.45 +k=1.00002 +x_0=2");
    add_proj4text (p, 1,
        "40000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Vigo (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",39.25],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"central_meridian\",-87.45],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",1.00002],PARAMETER[\"false_easting\",787400],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",118110],UNIT[\"US survey foot\",0");
    add_srs_wkt (p, 12,
        ".3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X");
    add_srs_wkt (p, 13,
        "\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7368\"]]");
    p = add_epsg_def_ex (filter, first, last, 7369, "epsg", 7369,
        "NAD83(2011) / InGCS Wells (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.55 +lon_0=-85.25 +k=1.000034 +x_0=");
    add_proj4text (p, 1,
        "240000 +y_0=36000 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Wells (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 8,
        "cator\"],PARAMETER[\"latitude_of_origin\",40.55],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-85.25],PARAMETER[\"scale_factor");
    add_srs_wkt (p, 10,
        "\",1.000034],PARAMETER[\"false_easting\",240000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",36000],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"7369\"]]");
    p = add_epsg_def_ex (filter, first, last, 7370, "epsg", 7370,
        "NAD83(2011) / InGCS Wells (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40.55 +lon_0=-85.25 +k=1.000034 +x_0=");
    add_proj4text (p, 1,
        "240000 +y_0=36000 +ellps=GRS80 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / InGCS Wells (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",40.55],PARA");
    add_srs_wkt (p, 9,
        "METER[\"central_meridian\",-85.25],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 10,
        "tor\",1.000034],PARAMETER[\"false_easting\",787400],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",118110],UNIT[\"US survey foot\"");
    add_srs_wkt (p, 12,
        ",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7370\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 7373, "epsg", 7373,
        "ONGD14", 1, 1,
        "GRS 1980", "Greenwich",
        "Oman_National_Geodetic_Datum_2014", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"ONGD14\",DATUM[\"Oman_National_Geodetic_Datum_2");
    add_srs_wkt (p, 1,
        "014\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"1147\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 6,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"7373\"]]");
    p = add_epsg_def_ex (filter, first, last, 7374, "epsg", 7374,
        "ONGD14 / UTM zone 39N", 0, 0,
        "GRS 1980", "Greenwich",
        "Oman_National_Geodetic_Datum_2014", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ONGD14 / UTM zone 39N\",GEOGCS[\"ONGD14\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Oman_National_Geodetic_Datum_2014\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1147\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"7373\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",51],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"7374\"]]");
    p = add_epsg_def_ex (filter, first, last, 7375, "epsg", 7375,
        "ONGD14 / UTM zone 40N", 0, 0,
        "GRS 1980", "Greenwich",
        "Oman_National_Geodetic_Datum_2014", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ONGD14 / UTM zone 40N\",GEOGCS[\"ONGD14\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Oman_National_Geodetic_Datum_2014\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1147\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"7373\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",57],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"7375\"]]");
    p = add_epsg_def_ex (filter, first, last, 7376, "epsg", 7376,
        "ONGD14 / UTM zone 41N", 0, 0,
        "GRS 1980", "Greenwich",
        "Oman_National_Geodetic_Datum_2014", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=41 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ONGD14 / UTM zone 41N\",GEOGCS[\"ONGD14\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Oman_National_Geodetic_Datum_2014\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1147\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"7373\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",63],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"7376\"]]");
    p = add_epsg_def_ex (filter, first, last, 7400, "epsg", 7400,
        "NTF (Paris)", 1, 1,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "none", "grad",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +a=6378249.2 +b=6356515 +towgs84=-168,-60,");
    add_proj4text (p, 1,
        "320,0,0,0,0 +pm=paris +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) + NGF IGN69 height\",GEOGCS[\"NTF");
    add_srs_wkt (p, 1,
        " (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Pari");
    add_srs_wkt (p, 2,
        "s\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212");
    add_srs_wkt (p, 3,
        "936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,32");
    add_srs_wkt (p, 4,
        "0,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\"");
    add_srs_wkt (p, 5,
        ",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",");
    add_srs_wkt (p, 6,
        "0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AXIS[\"");
    add_srs_wkt (p, 7,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 8,
        "PSG\",\"4807\"]],VERT_CS[\"NGF-IGN69 height\",VERT_DATUM");
    add_srs_wkt (p, 9,
        "[\"Nivellement General de la France - IGN69\",2005,AUTHO");
    add_srs_wkt (p, 10,
        "RITY[\"EPSG\",\"5119\"]],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"572");
    add_srs_wkt (p, 12,
        "0\"]],AUTHORITY[\"EPSG\",\"7400\"]]");
    p = add_epsg_def_ex (filter, first, last, 7401, "epsg", 7401,
        "NTF (Paris) / France II (deprecated)", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +tow");
    add_proj4text (p, 2,
        "gs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +vunits=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) / France II + NGF Lallemand\",PRO");
    add_srs_wkt (p, 1,
        "JCS[\"NTF (Paris) / France II (deprecated)\",GEOGCS[\"NT");
    add_srs_wkt (p, 2,
        "F (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Par");
    add_srs_wkt (p, 3,
        "is\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.466021");
    add_srs_wkt (p, 4,
        "2936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,3");
    add_srs_wkt (p, 5,
        "20,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris");
    add_srs_wkt (p, 6,
        "\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\"");
    add_srs_wkt (p, 7,
        ",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AXIS[");
    add_srs_wkt (p, 8,
        "\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 9,
        "EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Conic_1");
    add_srs_wkt (p, 10,
        "SP\"],PARAMETER[\"latitude_of_origin\",52],PARAMETER[\"c");
    add_srs_wkt (p, 11,
        "entral_meridian\",0],PARAMETER[\"scale_factor\",0.999877");
    add_srs_wkt (p, 12,
        "42],PARAMETER[\"false_easting\",600000],PARAMETER[\"fals");
    add_srs_wkt (p, 13,
        "e_northing\",2200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 15,
        "[\"EPSG\",\"27582\"]],VERT_CS[\"NGF Lallemand height\",V");
    add_srs_wkt (p, 16,
        "ERT_DATUM[\"Nivellement General de la France - Lallemand");
    add_srs_wkt (p, 17,
        "\",2005,AUTHORITY[\"EPSG\",\"5118\"]],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 18,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"");
    add_srs_wkt (p, 19,
        "EPSG\",\"5719\"]],AUTHORITY[\"EPSG\",\"7401\"]]");
    p = add_epsg_def_ex (filter, first, last, 7402, "epsg", 7402,
        "NTF (Paris) / France II (deprecated)", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +tow");
    add_proj4text (p, 2,
        "gs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +vunits=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) / France II + NGF IGN69\",PROJCS[");
    add_srs_wkt (p, 1,
        "\"NTF (Paris) / France II (deprecated)\",GEOGCS[\"NTF (P");
    add_srs_wkt (p, 2,
        "aris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\"");
    add_srs_wkt (p, 3,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 4,
        "269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320,0");
    add_srs_wkt (p, 5,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\",2");
    add_srs_wkt (p, 6,
        ".33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",0.");
    add_srs_wkt (p, 7,
        "01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AXIS[\"L");
    add_srs_wkt (p, 8,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 9,
        "SG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP");
    add_srs_wkt (p, 10,
        "\"],PARAMETER[\"latitude_of_origin\",52],PARAMETER[\"cen");
    add_srs_wkt (p, 11,
        "tral_meridian\",0],PARAMETER[\"scale_factor\",0.99987742");
    add_srs_wkt (p, 12,
        "],PARAMETER[\"false_easting\",600000],PARAMETER[\"false_");
    add_srs_wkt (p, 13,
        "northing\",2200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 15,
        "\"EPSG\",\"27582\"]],VERT_CS[\"NGF-IGN69 height\",VERT_D");
    add_srs_wkt (p, 16,
        "ATUM[\"Nivellement General de la France - IGN69\",2005,A");
    add_srs_wkt (p, 17,
        "UTHORITY[\"EPSG\",\"5119\"]],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 18,
        "\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 19,
        "5720\"]],AUTHORITY[\"EPSG\",\"7402\"]]");
    p = add_epsg_def_ex (filter, first, last, 7403, "epsg", 7403,
        "NTF (Paris) / France III (deprecated)", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=3200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) / France III + NGF IGN69\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"NTF (Paris) / France III (deprecated)\",GEOGCS[\"NTF ");
    add_srs_wkt (p, 2,
        "(Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris");
    add_srs_wkt (p, 3,
        "\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46602129");
    add_srs_wkt (p, 4,
        "36269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320");
    add_srs_wkt (p, 5,
        ",0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\"");
    add_srs_wkt (p, 6,
        ",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",");
    add_srs_wkt (p, 7,
        "0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AXIS[\"");
    add_srs_wkt (p, 8,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 9,
        "PSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Conic_1S");
    add_srs_wkt (p, 10,
        "P\"],PARAMETER[\"latitude_of_origin\",49],PARAMETER[\"ce");
    add_srs_wkt (p, 11,
        "ntral_meridian\",0],PARAMETER[\"scale_factor\",0.9998774");
    add_srs_wkt (p, 12,
        "99],PARAMETER[\"false_easting\",600000],PARAMETER[\"fals");
    add_srs_wkt (p, 13,
        "e_northing\",3200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 15,
        "[\"EPSG\",\"27583\"]],VERT_CS[\"NGF-IGN69 height\",VERT_");
    add_srs_wkt (p, 16,
        "DATUM[\"Nivellement General de la France - IGN69\",2005,");
    add_srs_wkt (p, 17,
        "AUTHORITY[\"EPSG\",\"5119\"]],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 18,
        "[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 19,
        "\"5720\"]],AUTHORITY[\"EPSG\",\"7403\"]]");
    p = add_epsg_def_ex (filter, first, last, 7404, "epsg", 7404,
        "RT90", 1, 1,
        "Bessel 1841", "Greenwich",
        "Rikets_koordinatsystem_1990", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=414.1,41.3,603.1,-0");
    add_proj4text (p, 1,
        ".855,2.141,-7.023,0 +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"RT90 + RH70 height\",GEOGCS[\"RT90\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Rikets_koordinatsystem_1990\",SPHEROID[\"Bessel 1841\",6");
    add_srs_wkt (p, 2,
        "377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],TOW");
    add_srs_wkt (p, 3,
        "GS84[414.1,41.3,603.1,-0.855,2.141,-7.023,0],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6124\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4124\"]],VERT_CS[");
    add_srs_wkt (p, 8,
        "\"RH70 height\",VERT_DATUM[\"Rikets hojdsystem 1970\",20");
    add_srs_wkt (p, 9,
        "05,AUTHORITY[\"EPSG\",\"5117\"]],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 10,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"5718\"]],AUTHORITY[\"EPSG\",\"7404\"]]");
    p = add_epsg_def_ex (filter, first, last, 7405, "epsg", 7405,
        "OSGB 1936 / British National Grid", 0, 0,
        "Airy 1830", "Greenwich",
        "OSGB_1936", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=49 +lon_0=-2 +k=0.9996012717 +x_0=400");
    add_proj4text (p, 1,
        "000 +y_0=-100000 +ellps=airy +towgs84=446.448,-125.157,5");
    add_proj4text (p, 2,
        "42.06,0.15,0.247,0.842,-20.489 +units=m +vunits=m +no_de");
    add_proj4text (p, 3,
        "fs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"OSGB 1936 / British National Grid + ODN heigh");
    add_srs_wkt (p, 1,
        "t\",PROJCS[\"OSGB 1936 / British National Grid\",GEOGCS[");
    add_srs_wkt (p, 2,
        "\"OSGB 1936\",DATUM[\"OSGB_1936\",SPHEROID[\"Airy 1830\"");
    add_srs_wkt (p, 3,
        ",6377563.396,299.3249646,AUTHORITY[\"EPSG\",\"7001\"]],T");
    add_srs_wkt (p, 4,
        "OWGS84[446.448,-125.157,542.06,0.15,0.247,0.842,-20.489]");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"6277\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 6,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 7,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 8,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4277");
    add_srs_wkt (p, 9,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 10,
        "itude_of_origin\",49],PARAMETER[\"central_meridian\",-2]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"scale_factor\",0.9996012717],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_easting\",400000],PARAMETER[\"false_northing\",-1000");
    add_srs_wkt (p, 13,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 14,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 15,
        "PSG\",\"27700\"]],VERT_CS[\"ODN height\",VERT_DATUM[\"Or");
    add_srs_wkt (p, 16,
        "dnance Datum Newlyn\",2005,AUTHORITY[\"EPSG\",\"5101\"]]");
    add_srs_wkt (p, 17,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"U");
    add_srs_wkt (p, 18,
        "p\",UP],AUTHORITY[\"EPSG\",\"5701\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 19,
        ",\"7405\"]]");
    p = add_epsg_def_ex (filter, first, last, 7406, "epsg", 7406,
        "NAD27", 1, 1,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +datum=NAD27 +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD27 + NGVD29 height\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "67\"]],VERT_CS[\"NGVD29 height\",VERT_DATUM[\"National G");
    add_srs_wkt (p, 8,
        "eodetic Vertical Datum 1929\",2005,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 9,
        "5102\"]],UNIT[\"US survey foot\",0.3048006096012192,AUTH");
    add_srs_wkt (p, 10,
        "ORITY[\"EPSG\",\"9003\"]],AXIS[\"Up\",UP],AUTHORITY[\"EP");
    add_srs_wkt (p, 11,
        "SG\",\"5702\"]],AUTHORITY[\"EPSG\",\"7406\"]]");
    p = add_epsg_def_ex (filter, first, last, 7407, "epsg", 7407,
        "NAD27 / Texas North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.65 +lat_2=36.18333333333333 +lat_0=3");
    add_proj4text (p, 1,
        "4 +lon_0=-101.5 +x_0=609601.2192024384 +y_0=0 +datum=NAD");
    add_proj4text (p, 2,
        "27 +units=us-ft +vunits=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD27 / Texas North + NGVD29 height\",PROJCS[");
    add_srs_wkt (p, 1,
        "\"NAD27 / Texas North\",GEOGCS[\"NAD27\",DATUM[\"North_A");
    add_srs_wkt (p, 2,
        "merican_Datum_1927\",SPHEROID[\"Clarke 1866\",6378206.4,");
    add_srs_wkt (p, 3,
        "294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 7,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_1\",34.65],PARAMETER[\"standard_parallel_2\"");
    add_srs_wkt (p, 10,
        ",36.18333333333333],PARAMETER[\"latitude_of_origin\",34]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"central_meridian\",-101.5],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_easting\",2000000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 13,
        "T[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 15,
        "TY[\"EPSG\",\"32037\"]],VERT_CS[\"NGVD29 height\",VERT_D");
    add_srs_wkt (p, 16,
        "ATUM[\"National Geodetic Vertical Datum 1929\",2005,AUTH");
    add_srs_wkt (p, 17,
        "ORITY[\"EPSG\",\"5102\"]],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 18,
        "006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"Up\",U");
    add_srs_wkt (p, 19,
        "P],AUTHORITY[\"EPSG\",\"5702\"]],AUTHORITY[\"EPSG\",\"74");
    add_srs_wkt (p, 20,
        "07\"]]");
    p = add_epsg_def_ex (filter, first, last, 7408, "epsg", 7408,
        "Amersfoort", 1, 1,
        "Bessel 1841", "Greenwich",
        "Amersfoort", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=565.2369,50.0087,46");
    add_proj4text (p, 1,
        "5.658,-0.406857,0.350733,-1.87035,4.0812 +vunits=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"RD/NAP\",GEOGCS[\"Amersfoort\",DATUM[\"Amersf");
    add_srs_wkt (p, 1,
        "oort\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[565.2369,50.0087,4");
    add_srs_wkt (p, 3,
        "65.658,-0.406857,0.350733,-1.87035,4.0812],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6289\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4289\"]],VERT_CS[\"");
    add_srs_wkt (p, 8,
        "NAP height\",VERT_DATUM[\"Normaal Amsterdams Peil\",2005");
    add_srs_wkt (p, 9,
        ",AUTHORITY[\"EPSG\",\"5109\"]],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 10,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"5709\"]],AUTHORITY[\"EPSG\",\"7408\"]]");
    p = add_epsg_def_ex (filter, first, last, 7409, "epsg", 7409,
        "ETRS89", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +vunit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 + EVRF2000 height\",GEOGCS[\"ETRS89\",");
    add_srs_wkt (p, 1,
        "DATUM[\"European_Terrestrial_Reference_System_1989\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4258\"]],VERT_CS[\"EVRF");
    add_srs_wkt (p, 8,
        "2000 height\",VERT_DATUM[\"European Vertical Reference F");
    add_srs_wkt (p, 9,
        "rame 2000\",2005,AUTHORITY[\"EPSG\",\"5129\"]],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"5730\"]],AUTHORITY[\"EPSG\",\"7409\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 7410, "epsg", 7410,
        "PSD93", 1, 1,
        "Clarke 1880 (RGS)", "Greenwich",
        "PDO_Survey_Datum_1993", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=clrk80 +towgs84=-180.624,-225.516,1");
    add_proj4text (p, 1,
        "73.919,-0.81,-1.898,8.336,16.71006 +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"PSHD93\",GEOGCS[\"PSD93\",DATUM[\"PDO_Survey_");
    add_srs_wkt (p, 1,
        "Datum_1993\",SPHEROID[\"Clarke 1880 (RGS)\",6378249.145,");
    add_srs_wkt (p, 2,
        "293.465,AUTHORITY[\"EPSG\",\"7012\"]],TOWGS84[-180.624,-");
    add_srs_wkt (p, 3,
        "225.516,173.919,-0.81,-1.898,8.336,16.71006],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6134\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4134\"]],VERT_CS[");
    add_srs_wkt (p, 8,
        "\"PHD93 height\",VERT_DATUM[\"PDO Height Datum 1993\",20");
    add_srs_wkt (p, 9,
        "05,AUTHORITY[\"EPSG\",\"5123\"]],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 10,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 11,
        "\",\"5724\"]],AUTHORITY[\"EPSG\",\"7410\"]]");
    p = add_epsg_def_ex (filter, first, last, 7411, "epsg", 7411,
        "NTF (Paris) / Lambert zone II", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +tow");
    add_proj4text (p, 2,
        "gs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +vunits=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) / Lambert zone II + NGF Lallemand");
    add_srs_wkt (p, 1,
        " height\",PROJCS[\"NTF (Paris) / Lambert zone II\",GEOGC");
    add_srs_wkt (p, 2,
        "S[\"NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francai");
    add_srs_wkt (p, 3,
        "se_Paris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.");
    add_srs_wkt (p, 4,
        "4660212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168");
    add_srs_wkt (p, 5,
        ",-60,320,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"");
    add_srs_wkt (p, 6,
        "Paris\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"");
    add_srs_wkt (p, 7,
        "grad\",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]]");
    add_srs_wkt (p, 8,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 9,
        "RITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_");
    add_srs_wkt (p, 10,
        "Conic_1SP\"],PARAMETER[\"latitude_of_origin\",52],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"central_meridian\",0],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 12,
        ".99987742],PARAMETER[\"false_easting\",600000],PARAMETER");
    add_srs_wkt (p, 13,
        "[\"false_northing\",2200000],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 15,
        "UTHORITY[\"EPSG\",\"27572\"]],VERT_CS[\"NGF Lallemand he");
    add_srs_wkt (p, 16,
        "ight\",VERT_DATUM[\"Nivellement General de la France - L");
    add_srs_wkt (p, 17,
        "allemand\",2005,AUTHORITY[\"EPSG\",\"5118\"]],UNIT[\"met");
    add_srs_wkt (p, 18,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUT");
    add_srs_wkt (p, 19,
        "HORITY[\"EPSG\",\"5719\"]],AUTHORITY[\"EPSG\",\"7411\"]]");
    p = add_epsg_def_ex (filter, first, last, 7412, "epsg", 7412,
        "NTF (Paris) / Lambert zone II", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +tow");
    add_proj4text (p, 2,
        "gs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +vunits=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) / Lambert zone II + NGF IGN69\",P");
    add_srs_wkt (p, 1,
        "ROJCS[\"NTF (Paris) / Lambert zone II\",GEOGCS[\"NTF (Pa");
    add_srs_wkt (p, 2,
        "ris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46602129362");
    add_srs_wkt (p, 4,
        "69,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320,0,");
    add_srs_wkt (p, 5,
        "0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\",2.");
    add_srs_wkt (p, 6,
        "33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",0.0");
    add_srs_wkt (p, 7,
        "1570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AXIS[\"La");
    add_srs_wkt (p, 8,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 9,
        "G\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"latitude_of_origin\",52],PARAMETER[\"centr");
    add_srs_wkt (p, 11,
        "al_meridian\",0],PARAMETER[\"scale_factor\",0.99987742],");
    add_srs_wkt (p, 12,
        "PARAMETER[\"false_easting\",600000],PARAMETER[\"false_no");
    add_srs_wkt (p, 13,
        "rthing\",2200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 15,
        "EPSG\",\"27572\"]],VERT_CS[\"NGF Lallemand height\",VERT");
    add_srs_wkt (p, 16,
        "_DATUM[\"Nivellement General de la France - Lallemand\",");
    add_srs_wkt (p, 17,
        "2005,AUTHORITY[\"EPSG\",\"5118\"]],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 18,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EP");
    add_srs_wkt (p, 19,
        "SG\",\"5719\"]],AUTHORITY[\"EPSG\",\"7412\"]]");
    p = add_epsg_def_ex (filter, first, last, 7413, "epsg", 7413,
        "NTF (Paris) / Lambert zone III", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=3200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) / Lambert zone III + NGF IGN69\",");
    add_srs_wkt (p, 1,
        "PROJCS[\"NTF (Paris) / Lambert zone III\",GEOGCS[\"NTF (");
    add_srs_wkt (p, 2,
        "Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_Paris\"");
    add_srs_wkt (p, 3,
        ",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660212936");
    add_srs_wkt (p, 4,
        "269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60,320,0");
    add_srs_wkt (p, 5,
        ",0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Paris\",2");
    add_srs_wkt (p, 6,
        ".33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"grad\",0.");
    add_srs_wkt (p, 7,
        "01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AXIS[\"L");
    add_srs_wkt (p, 8,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 9,
        "SG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP");
    add_srs_wkt (p, 10,
        "\"],PARAMETER[\"latitude_of_origin\",49],PARAMETER[\"cen");
    add_srs_wkt (p, 11,
        "tral_meridian\",0],PARAMETER[\"scale_factor\",0.99987749");
    add_srs_wkt (p, 12,
        "9],PARAMETER[\"false_easting\",600000],PARAMETER[\"false");
    add_srs_wkt (p, 13,
        "_northing\",3200000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 15,
        "[\"EPSG\",\"27573\"]],VERT_CS[\"NGF Lallemand height\",V");
    add_srs_wkt (p, 16,
        "ERT_DATUM[\"Nivellement General de la France - Lallemand");
    add_srs_wkt (p, 17,
        "\",2005,AUTHORITY[\"EPSG\",\"5118\"]],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 18,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"");
    add_srs_wkt (p, 19,
        "EPSG\",\"5719\"]],AUTHORITY[\"EPSG\",\"7413\"]]");
    p = add_epsg_def_ex (filter, first, last, 7414, "epsg", 7414,
        "Tokyo", 1, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=-146.414,507.337,68");
    add_proj4text (p, 1,
        "0.507,0,0,0,0 +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"Tokyo + JSLD69 height\",GEOGCS[\"Tokyo\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377397.155,299.152");
    add_srs_wkt (p, 2,
        "8128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[-146.414,507.");
    add_srs_wkt (p, 3,
        "337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"6301\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"4301\"]],VERT_CS[\"JSLD69 height\",VERT_");
    add_srs_wkt (p, 8,
        "DATUM[\"Japanese Standard Levelling Datum 1969\",2005,AU");
    add_srs_wkt (p, 9,
        "THORITY[\"EPSG\",\"5122\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 10,
        "EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5");
    add_srs_wkt (p, 11,
        "723\"]],AUTHORITY[\"EPSG\",\"7414\"]]");
    p = add_epsg_def_ex (filter, first, last, 7415, "epsg", 7415,
        "Amersfoort / RD New", 0, 0,
        "Bessel 1841", "Greenwich",
        "Amersfoort", "Oblique_Stereographic", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=52.15616055555555 +lon_0=5.387638888");
    add_proj4text (p, 1,
        "88889 +k=0.9999079 +x_0=155000 +y_0=463000 +ellps=bessel");
    add_proj4text (p, 2,
        " +towgs84=565.2369,50.0087,465.658,-0.406857,0.350733,-1");
    add_proj4text (p, 3,
        ".87035,4.0812 +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"Amersfoort / RD New + NAP height\",PROJCS[\"A");
    add_srs_wkt (p, 1,
        "mersfoort / RD New\",GEOGCS[\"Amersfoort\",DATUM[\"Amers");
    add_srs_wkt (p, 2,
        "foort\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[565.2369,50.0087,");
    add_srs_wkt (p, 4,
        "465.658,-0.406857,0.350733,-1.87035,4.0812],AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"6289\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 7,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 8,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"4289\"]],PROJECTI");
    add_srs_wkt (p, 9,
        "ON[\"Oblique_Stereographic\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 10,
        "igin\",52.15616055555555],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 11,
        ",5.38763888888889],PARAMETER[\"scale_factor\",0.9999079]");
    add_srs_wkt (p, 12,
        ",PARAMETER[\"false_easting\",155000],PARAMETER[\"false_n");
    add_srs_wkt (p, 13,
        "orthing\",463000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 15,
        "EPSG\",\"28992\"]],VERT_CS[\"NAP height\",VERT_DATUM[\"N");
    add_srs_wkt (p, 16,
        "ormaal Amsterdams Peil\",2005,AUTHORITY[\"EPSG\",\"5109\"");
    add_srs_wkt (p, 17,
        "]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 18,
        "Up\",UP],AUTHORITY[\"EPSG\",\"5709\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 19,
        ",\"7415\"]]");
    p = add_epsg_def_ex (filter, first, last, 7416, "epsg", 7416,
        "ETRS89 / UTM zone 32N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 32N + DVR90 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / UTM zone 32N\",GEOGCS[\"ETRS89\",DATUM[\"Eur");
    add_srs_wkt (p, 2,
        "opean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",9],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 11,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "1\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AU");
    add_srs_wkt (p, 14,
        "THORITY[\"EPSG\",\"25832\"]],VERT_CS[\"DVR90 height\",VE");
    add_srs_wkt (p, 15,
        "RT_DATUM[\"Dansk Vertikal Reference 1990\",2005,AUTHORIT");
    add_srs_wkt (p, 16,
        "Y[\"EPSG\",\"5206\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5799\"]");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"7416\"]]");
    p = add_epsg_def_ex (filter, first, last, 7417, "epsg", 7417,
        "ETRS89 / UTM zone 33N", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / UTM zone 33N + DVR90 height\",PROJCS");
    add_srs_wkt (p, 1,
        "[\"ETRS89 / UTM zone 33N\",GEOGCS[\"ETRS89\",DATUM[\"Eur");
    add_srs_wkt (p, 2,
        "opean_Terrestrial_Reference_System_1989\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"]],");
    add_srs_wkt (p, 5,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 6,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 7,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 8,
        "AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 9,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"central_meridian\",15],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 11,
        "96],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"25833\"]],VERT_CS[\"DVR90 height\",V");
    add_srs_wkt (p, 15,
        "ERT_DATUM[\"Dansk Vertikal Reference 1990\",2005,AUTHORI");
    add_srs_wkt (p, 16,
        "TY[\"EPSG\",\"5206\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 17,
        "\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5799\"");
    add_srs_wkt (p, 18,
        "]],AUTHORITY[\"EPSG\",\"7417\"]]");
    p = add_epsg_def_ex (filter, first, last, 7418, "epsg", 7418,
        "ETRS89 / Kp2000 Jutland", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9.5 +k=0.99995 +x_0=200000 +");
    add_proj4text (p, 1,
        "y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vuni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / Kp2000 Jutland + DVR90 height\",PROJ");
    add_srs_wkt (p, 1,
        "CS[\"ETRS89 / Kp2000 Jutland\",GEOGCS[\"ETRS89\",DATUM[\"");
    add_srs_wkt (p, 2,
        "European_Terrestrial_Reference_System_1989\",SPHEROID[\"");
    add_srs_wkt (p, 3,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 4,
        "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"");
    add_srs_wkt (p, 5,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 6,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 8,
        "T],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 9,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"central_meridian\",9.5],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 11,
        "0.99995],PARAMETER[\"false_easting\",200000],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 14,
        "H],AUTHORITY[\"EPSG\",\"2196\"]],VERT_CS[\"DVR90 height\"");
    add_srs_wkt (p, 15,
        ",VERT_DATUM[\"Dansk Vertikal Reference 1990\",2005,AUTHO");
    add_srs_wkt (p, 16,
        "RITY[\"EPSG\",\"5206\"]],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 17,
        "SG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"579");
    add_srs_wkt (p, 18,
        "9\"]],AUTHORITY[\"EPSG\",\"7418\"]]");
    p = add_epsg_def_ex (filter, first, last, 7419, "epsg", 7419,
        "ETRS89 / Kp2000 Zealand", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=0.99995 +x_0=500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / Kp2000 Zealand + DVR90 height\",PROJ");
    add_srs_wkt (p, 1,
        "CS[\"ETRS89 / Kp2000 Zealand\",GEOGCS[\"ETRS89\",DATUM[\"");
    add_srs_wkt (p, 2,
        "European_Terrestrial_Reference_System_1989\",SPHEROID[\"");
    add_srs_wkt (p, 3,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 4,
        "19\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6258\"");
    add_srs_wkt (p, 5,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 6,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 8,
        "T],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 9,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"central_meridian\",12],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 11,
        ".99995],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 14,
        "H],AUTHORITY[\"EPSG\",\"2197\"]],VERT_CS[\"DVR90 height\"");
    add_srs_wkt (p, 15,
        ",VERT_DATUM[\"Dansk Vertikal Reference 1990\",2005,AUTHO");
    add_srs_wkt (p, 16,
        "RITY[\"EPSG\",\"5206\"]],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 17,
        "SG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"579");
    add_srs_wkt (p, 18,
        "9\"]],AUTHORITY[\"EPSG\",\"7419\"]]");
    p = add_epsg_def_ex (filter, first, last, 7420, "epsg", 7420,
        "ETRS89 / Kp2000 Bornholm", 0, 0,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=900000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +vunits=m +n");
    add_proj4text (p, 2,
        "o_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 / Kp2000 Bornholm + DVR90 height\",PRO");
    add_srs_wkt (p, 1,
        "JCS[\"ETRS89 / Kp2000 Bornholm\",GEOGCS[\"ETRS89\",DATUM");
    add_srs_wkt (p, 2,
        "[\"European_Terrestrial_Reference_System_1989\",SPHEROID");
    add_srs_wkt (p, 3,
        "[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"625");
    add_srs_wkt (p, 5,
        "8\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 6,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 8,
        "EAST],AUTHORITY[\"EPSG\",\"4258\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 9,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],PARA");
    add_srs_wkt (p, 10,
        "METER[\"central_meridian\",15],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 11,
        ",1],PARAMETER[\"false_easting\",900000],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"2198\"]],VERT_CS[\"DVR90 height\",VE");
    add_srs_wkt (p, 15,
        "RT_DATUM[\"Dansk Vertikal Reference 1990\",2005,AUTHORIT");
    add_srs_wkt (p, 16,
        "Y[\"EPSG\",\"5206\"]],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 17,
        ",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"5799\"]");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"7420\"]]");
    p = add_epsg_def_ex (filter, first, last, 7421, "epsg", 7421,
        "NTF (Paris) / Lambert zone II", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.8 +lat_0=46.8 +lon_0=0 +k_0=0.999877");
    add_proj4text (p, 1,
        "42 +x_0=600000 +y_0=2200000 +a=6378249.2 +b=6356515 +tow");
    add_proj4text (p, 2,
        "gs84=-168,-60,320,0,0,0,0 +pm=paris +units=m +vunits=m +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) / Lambert zone II + NGF-IGN69 hei");
    add_srs_wkt (p, 1,
        "ght\",PROJCS[\"NTF (Paris) / Lambert zone II\",GEOGCS[\"");
    add_srs_wkt (p, 2,
        "NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise_P");
    add_srs_wkt (p, 3,
        "aris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.4660");
    add_srs_wkt (p, 4,
        "212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-60");
    add_srs_wkt (p, 5,
        ",320,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"Par");
    add_srs_wkt (p, 6,
        "is\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"gra");
    add_srs_wkt (p, 7,
        "d\",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],AX");
    add_srs_wkt (p, 8,
        "IS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORIT");
    add_srs_wkt (p, 9,
        "Y[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_Con");
    add_srs_wkt (p, 10,
        "ic_1SP\"],PARAMETER[\"latitude_of_origin\",52],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"central_meridian\",0],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 12,
        "987742],PARAMETER[\"false_easting\",600000],PARAMETER[\"");
    add_srs_wkt (p, 13,
        "false_northing\",2200000],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 15,
        "ORITY[\"EPSG\",\"27572\"]],VERT_CS[\"NGF-IGN69 height\",");
    add_srs_wkt (p, 16,
        "VERT_DATUM[\"Nivellement General de la France - IGN69\",");
    add_srs_wkt (p, 17,
        "2005,AUTHORITY[\"EPSG\",\"5119\"]],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 18,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EP");
    add_srs_wkt (p, 19,
        "SG\",\"5720\"]],AUTHORITY[\"EPSG\",\"7421\"]]");
    p = add_epsg_def_ex (filter, first, last, 7422, "epsg", 7422,
        "NTF (Paris) / Lambert zone III", 0, 0,
        "Clarke 1880 (IGN)", "Paris",
        "Nouvelle_Triangulation_Francaise_Paris", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.10000000000001 +lat_0=44.10000000000");
    add_proj4text (p, 1,
        "001 +lon_0=0 +k_0=0.999877499 +x_0=600000 +y_0=3200000 +");
    add_proj4text (p, 2,
        "a=6378249.2 +b=6356515 +towgs84=-168,-60,320,0,0,0,0 +pm");
    add_proj4text (p, 3,
        "=paris +units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NTF (Paris) / Lambert zone III + NGF-IGN69 he");
    add_srs_wkt (p, 1,
        "ight\",PROJCS[\"NTF (Paris) / Lambert zone III\",GEOGCS[");
    add_srs_wkt (p, 2,
        "\"NTF (Paris)\",DATUM[\"Nouvelle_Triangulation_Francaise");
    add_srs_wkt (p, 3,
        "_Paris\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,293.46");
    add_srs_wkt (p, 4,
        "60212936269,AUTHORITY[\"EPSG\",\"7011\"]],TOWGS84[-168,-");
    add_srs_wkt (p, 5,
        "60,320,0,0,0,0],AUTHORITY[\"EPSG\",\"6807\"]],PRIMEM[\"P");
    add_srs_wkt (p, 6,
        "aris\",2.33722917,AUTHORITY[\"EPSG\",\"8903\"]],UNIT[\"g");
    add_srs_wkt (p, 7,
        "rad\",0.01570796326794897,AUTHORITY[\"EPSG\",\"9105\"]],");
    add_srs_wkt (p, 8,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 9,
        "ITY[\"EPSG\",\"4807\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 10,
        "onic_1SP\"],PARAMETER[\"latitude_of_origin\",49],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"central_meridian\",0],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 12,
        "999877499],PARAMETER[\"false_easting\",600000],PARAMETER");
    add_srs_wkt (p, 13,
        "[\"false_northing\",3200000],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 15,
        "UTHORITY[\"EPSG\",\"27573\"]],VERT_CS[\"NGF-IGN69 height");
    add_srs_wkt (p, 16,
        "\",VERT_DATUM[\"Nivellement General de la France - IGN69");
    add_srs_wkt (p, 17,
        "\",2005,AUTHORITY[\"EPSG\",\"5119\"]],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 18,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"");
    add_srs_wkt (p, 19,
        "EPSG\",\"5720\"]],AUTHORITY[\"EPSG\",\"7422\"]]");
    p = add_epsg_def_ex (filter, first, last, 7423, "epsg", 7423,
        "ETRS89", 1, 1,
        "GRS 1980", "Greenwich",
        "European_Terrestrial_Reference_System_1989", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +vunit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"ETRS89 + EVRF2007 height\",GEOGCS[\"ETRS89\",");
    add_srs_wkt (p, 1,
        "DATUM[\"European_Terrestrial_Reference_System_1989\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6258\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4258\"]],VERT_CS[\"EVRF");
    add_srs_wkt (p, 8,
        "2007 height\",VERT_DATUM[\"European Vertical Reference F");
    add_srs_wkt (p, 9,
        "rame 2007\",2005,AUTHORITY[\"EPSG\",\"5215\"]],UNIT[\"me");
    add_srs_wkt (p, 10,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"5621\"]],AUTHORITY[\"EPSG\",\"7423\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 7528, "epsg", 7528,
        "NAD83(2011) / WISCRS Adams and Juneau (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.36666666666667 +lon_0=-90 +k=1.000");
    add_proj4text (p, 1,
        "0365285 +x_0=147218.6942 +y_0=0.0037 +ellps=GRS80 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Adams and Juneau (m)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 7,
        "de\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tr");
    add_srs_wkt (p, 8,
        "ansverse_Mercator\"],PARAMETER[\"latitude_of_origin\",43");
    add_srs_wkt (p, 9,
        ".36666666666667],PARAMETER[\"central_meridian\",-90],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",1.0000365285],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "easting\",147218.6942],PARAMETER[\"false_northing\",0.00");
    add_srs_wkt (p, 12,
        "37],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7528\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 7529, "epsg", 7529,
        "NAD83(2011) / WISCRS Ashland (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.70611111111111 +lon_0=-90.62222222");
    add_proj4text (p, 1,
        "222222 +k=1.0000495683 +x_0=172821.9461 +y_0=0.0017 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Ashland (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",45.70611111");
    add_srs_wkt (p, 9,
        "111111],PARAMETER[\"central_meridian\",-90.6222222222222");
    add_srs_wkt (p, 10,
        "2],PARAMETER[\"scale_factor\",1.0000495683],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",172821.9461],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0.0017],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "7529\"]]");
    p = add_epsg_def_ex (filter, first, last, 7530, "epsg", 7530,
        "NAD83(2011) / WISCRS Barron (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.13333333333333 +lon_0=-91.84999999");
    add_proj4text (p, 1,
        "999999 +k=1.0000486665 +x_0=93150 +y_0=0.0029 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Barron (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",45.133333333");
    add_srs_wkt (p, 9,
        "33333],PARAMETER[\"central_meridian\",-91.85],PARAMETER[");
    add_srs_wkt (p, 10,
        "\"scale_factor\",1.0000486665],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",93150],PARAMETER[\"false_northing\",0.0029],UNIT[\"me");
    add_srs_wkt (p, 12,
        "tre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],A");
    add_srs_wkt (p, 13,
        "XIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7530\"]]");
    p = add_epsg_def_ex (filter, first, last, 7531, "epsg", 7531,
        "NAD83(2011) / WISCRS Bayfield (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=46.66964837722222 +lat_0=46.66964837722");
    add_proj4text (p, 1,
        "222 +lon_0=-91.15277777777779 +k_0=1.0000331195 +x_0=228");
    add_proj4text (p, 2,
        "600.4575 +y_0=148551.4837 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Bayfield (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 8,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",46");
    add_srs_wkt (p, 9,
        ".66964837722222],PARAMETER[\"central_meridian\",-91.1527");
    add_srs_wkt (p, 10,
        "7777777779],PARAMETER[\"scale_factor\",1.0000331195],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",228600.4575],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "northing\",148551.4837],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHOR");
    add_srs_wkt (p, 14,
        "ITY[\"EPSG\",\"7531\"]]");
    p = add_epsg_def_ex (filter, first, last, 7532, "epsg", 7532,
        "NAD83(2011) / WISCRS Brown (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43 +lon_0=-88 +k=1.00002 +x_0=31600 +");
    add_proj4text (p, 1,
        "y_0=4600 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Brown (m)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(2011)\",DATUM[\"NAD83_National_Spatial_Reference_System");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",43],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"central_meridian\",-88],PARAMETER[\"scale_factor\",1.");
    add_srs_wkt (p, 10,
        "00002],PARAMETER[\"false_easting\",31600],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_northing\",4600],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 12,
        ",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"7532\"]]");
    p = add_epsg_def_ex (filter, first, last, 7533, "epsg", 7533,
        "NAD83(2011) / WISCRS Buffalo (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.48138888888889 +lon_0=-91.79722222");
    add_proj4text (p, 1,
        "222222 +k=1.0000382778 +x_0=175260.3502 +y_0=0.0048 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Buffalo (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",43.48138888");
    add_srs_wkt (p, 9,
        "888889],PARAMETER[\"central_meridian\",-91.7972222222222");
    add_srs_wkt (p, 10,
        "2],PARAMETER[\"scale_factor\",1.0000382778],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",175260.3502],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0.0048],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "7533\"]]");
    p = add_epsg_def_ex (filter, first, last, 7534, "epsg", 7534,
        "NAD83(2011) / WISCRS Burnett (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.89871486583333 +lat_0=45.89871486583");
    add_proj4text (p, 1,
        "333 +lon_0=-92.45777777777778 +k_0=1.0000383841 +x_0=640");
    add_proj4text (p, 2,
        "08.1276 +y_0=59445.9043 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Burnett (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 8,
        "formal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",45.");
    add_srs_wkt (p, 9,
        "89871486583333],PARAMETER[\"central_meridian\",-92.45777");
    add_srs_wkt (p, 10,
        "777777778],PARAMETER[\"scale_factor\",1.0000383841],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_easting\",64008.1276],PARAMETER[\"false_no");
    add_srs_wkt (p, 12,
        "rthing\",59445.9043],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"7534\"]]");
    p = add_epsg_def_ex (filter, first, last, 7535, "epsg", 7535,
        "NAD83(2011) / WISCRS Calumet, Fond du Lac, Outagamie and Winnebago (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.71944444444445 +lon_0=-88.5 +k=1.0");
    add_proj4text (p, 1,
        "000286569 +x_0=244754.8893 +y_0=0.0049 +ellps=GRS80 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Calumet, Fond du Lac, Outa");
    add_srs_wkt (p, 1,
        "gamie and Winnebago (m)\",GEOGCS[\"NAD83(2011)\",DATUM[\"");
    add_srs_wkt (p, 2,
        "NAD83_National_Spatial_Reference_System_2011\",SPHEROID[");
    add_srs_wkt (p, 3,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 7,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 8,
        ",\"6318\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"latitude_of_origin\",42.71944444444445],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "central_meridian\",-88.5],PARAMETER[\"scale_factor\",1.0");
    add_srs_wkt (p, 11,
        "000286569],PARAMETER[\"false_easting\",244754.8893],PARA");
    add_srs_wkt (p, 12,
        "METER[\"false_northing\",0.0049],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 14,
        "H],AUTHORITY[\"EPSG\",\"7535\"]]");
    p = add_epsg_def_ex (filter, first, last, 7536, "epsg", 7536,
        "NAD83(2011) / WISCRS Chippewa (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.97785689861112 +lat_0=44.97785689861");
    add_proj4text (p, 1,
        "112 +lon_0=-91.29444444444444 +k_0=1.0000391127 +x_0=600");
    add_proj4text (p, 2,
        "45.72 +y_0=44091.4346 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Chippewa (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 8,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",44");
    add_srs_wkt (p, 9,
        ".97785689861112],PARAMETER[\"central_meridian\",-91.2944");
    add_srs_wkt (p, 10,
        "4444444444],PARAMETER[\"scale_factor\",1.0000391127],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",60045.72],PARAMETER[\"false_nor");
    add_srs_wkt (p, 12,
        "thing\",44091.4346],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"7536\"]]");
    p = add_epsg_def_ex (filter, first, last, 7537, "epsg", 7537,
        "NAD83(2011) / WISCRS Clark (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.6 +lon_0=-90.70833333333334 +k=1.0");
    add_proj4text (p, 1,
        "000463003 +x_0=199949.1989 +y_0=0.0086 +ellps=GRS80 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Clark (m)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(2011)\",DATUM[\"NAD83_National_Spatial_Reference_System");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",43.6],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"central_meridian\",-90.70833333333334],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1.0000463003],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",199949.1989],PARAMETER[\"false_northing\",0.0086],UNIT[");
    add_srs_wkt (p, 12,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7537\"]]");
    p = add_epsg_def_ex (filter, first, last, 7538, "epsg", 7538,
        "NAD83(2011) / WISCRS Columbia (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.46254664583333 +lat_0=43.46254664583");
    add_proj4text (p, 1,
        "333 +lon_0=-89.39444444444445 +k_0=1.00003498 +x_0=16916");
    add_proj4text (p, 2,
        "4.3381 +y_0=111569.6134 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Columbia (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 8,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",43");
    add_srs_wkt (p, 9,
        ".46254664583333],PARAMETER[\"central_meridian\",-89.3944");
    add_srs_wkt (p, 10,
        "4444444445],PARAMETER[\"scale_factor\",1.00003498],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"false_easting\",169164.3381],PARAMETER[\"false_no");
    add_srs_wkt (p, 12,
        "rthing\",111569.6134],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"7538\"]]");
    p = add_epsg_def_ex (filter, first, last, 7539, "epsg", 7539,
        "NAD83(2011) / WISCRS Crawford (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.200055605 +lat_0=43.200055605 +lon_0");
    add_proj4text (p, 1,
        "=-90.9388888888889 +k_0=1.0000349151 +x_0=113690.6274 +y");
    add_proj4text (p, 2,
        "_0=53703.1201 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Crawford (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 8,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",43");
    add_srs_wkt (p, 9,
        ".200055605],PARAMETER[\"central_meridian\",-90.938888888");
    add_srs_wkt (p, 10,
        "8889],PARAMETER[\"scale_factor\",1.0000349151],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_easting\",113690.6274],PARAMETER[\"false_northi");
    add_srs_wkt (p, 12,
        "ng\",53703.1201],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 13,
        "001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"7539\"]]");
    p = add_epsg_def_ex (filter, first, last, 7540, "epsg", 7540,
        "NAD83(2011) / WISCRS Dane (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.0695160375 +lat_0=43.0695160375 +lon");
    add_proj4text (p, 1,
        "_0=-89.42222222222223 +k_0=1.0000384786 +x_0=247193.2944");
    add_proj4text (p, 2,
        " +y_0=146591.9896 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Dane (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Confor");
    add_srs_wkt (p, 8,
        "mal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",43.069");
    add_srs_wkt (p, 9,
        "5160375],PARAMETER[\"central_meridian\",-89.422222222222");
    add_srs_wkt (p, 10,
        "23],PARAMETER[\"scale_factor\",1.0000384786],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",247193.2944],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",146591.9896],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 13,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"7540\"]]");
    p = add_epsg_def_ex (filter, first, last, 7541, "epsg", 7541,
        "NAD83(2011) / WISCRS Dodge and Jefferson (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.47222222222222 +lon_0=-88.77500000");
    add_proj4text (p, 1,
        "000001 +k=1.0000346418 +x_0=263347.7263 +y_0=0.0076 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Dodge and Jefferson (m)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 2,
        "ference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 3,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 7,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"");
    add_srs_wkt (p, 8,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 9,
        "41.47222222222222],PARAMETER[\"central_meridian\",-88.77");
    add_srs_wkt (p, 10,
        "5],PARAMETER[\"scale_factor\",1.0000346418],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",263347.7263],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0.0076],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "7541\"]]");
    p = add_epsg_def_ex (filter, first, last, 7542, "epsg", 7542,
        "NAD83(2011) / WISCRS Door (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.4 +lon_0=-87.27222222222223 +k=1.0");
    add_proj4text (p, 1,
        "000187521 +x_0=158801.1176 +y_0=0.0023 +ellps=GRS80 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Door (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 8,
        "cator\"],PARAMETER[\"latitude_of_origin\",44.4],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"central_meridian\",-87.27222222222223],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1.0000187521],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "158801.1176],PARAMETER[\"false_northing\",0.0023],UNIT[\"");
    add_srs_wkt (p, 12,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7542\"]]");
    p = add_epsg_def_ex (filter, first, last, 7543, "epsg", 7543,
        "NAD83(2011) / WISCRS Douglas (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.88333333333333 +lon_0=-91.91666666");
    add_proj4text (p, 1,
        "666667 +k=1.0000385418 +x_0=59131.3183 +y_0=0.0041 +ellp");
    add_proj4text (p, 2,
        "s=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Douglas (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",45.88333333");
    add_srs_wkt (p, 9,
        "333333],PARAMETER[\"central_meridian\",-91.9166666666666");
    add_srs_wkt (p, 10,
        "7],PARAMETER[\"scale_factor\",1.0000385418],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",59131.3183],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0.0041],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "7543\"]]");
    p = add_epsg_def_ex (filter, first, last, 7544, "epsg", 7544,
        "NAD83(2011) / WISCRS Dunn (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.40833333333333 +lon_0=-91.89444444");
    add_proj4text (p, 1,
        "444445 +k=1.0000410324 +x_0=51816.104 +y_0=0.003 +ellps=");
    add_proj4text (p, 2,
        "GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Dunn (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 8,
        "cator\"],PARAMETER[\"latitude_of_origin\",44.40833333333");
    add_srs_wkt (p, 9,
        "333],PARAMETER[\"central_meridian\",-91.89444444444445],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"scale_factor\",1.0000410324],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",51816.104],PARAMETER[\"false_northing\",0.0");
    add_srs_wkt (p, 12,
        "03],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 13,
        "\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7544\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 7545, "epsg", 7545,
        "NAD83(2011) / WISCRS Eau Claire (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.87228112638889 +lat_0=44.87228112638");
    add_proj4text (p, 1,
        "889 +lon_0=-91.28888888888889 +k_0=1.000035079 +x_0=1200");
    add_proj4text (p, 2,
        "91.4402 +y_0=91687.92389999999 +ellps=GRS80 +units=m +no");
    add_proj4text (p, 3,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Eau Claire (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_");
    add_srs_wkt (p, 8,
        "Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 9,
        "44.87228112638889],PARAMETER[\"central_meridian\",-91.28");
    add_srs_wkt (p, 10,
        "888888888889],PARAMETER[\"scale_factor\",1.000035079],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",120091.4402],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_northing\",91687.9239],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 13,
        "G\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHOR");
    add_srs_wkt (p, 14,
        "ITY[\"EPSG\",\"7545\"]]");
    p = add_epsg_def_ex (filter, first, last, 7546, "epsg", 7546,
        "NAD83(2011) / WISCRS Florence (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.43888888888888 +lon_0=-88.14166666");
    add_proj4text (p, 1,
        "666668 +k=1.0000552095 +x_0=133502.6683 +y_0=0.0063 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Florence (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",45.4388888");
    add_srs_wkt (p, 9,
        "8888888],PARAMETER[\"central_meridian\",-88.141666666666");
    add_srs_wkt (p, 10,
        "68],PARAMETER[\"scale_factor\",1.0000552095],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",133502.6683],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0.0063],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "7546\"]]");
    p = add_epsg_def_ex (filter, first, last, 7547, "epsg", 7547,
        "NAD83(2011) / WISCRS Forest (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.00555555555555 +lon_0=-88.63333333");
    add_proj4text (p, 1,
        "333334 +k=1.0000673004 +x_0=275844.5533 +y_0=0.0157 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Forest (m)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syste");
    add_srs_wkt (p, 2,
        "m_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]]");
    add_srs_wkt (p, 4,
        ",PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UN");
    add_srs_wkt (p, 5,
        "IT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"91");
    add_srs_wkt (p, 6,
        "22\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST]");
    add_srs_wkt (p, 7,
        ",AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_M");
    add_srs_wkt (p, 8,
        "ercator\"],PARAMETER[\"latitude_of_origin\",44.005555555");
    add_srs_wkt (p, 9,
        "55555],PARAMETER[\"central_meridian\",-88.63333333333334");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"scale_factor\",1.0000673004],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_easting\",275844.5533],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0.0157],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "7547\"]]");
    p = add_epsg_def_ex (filter, first, last, 7548, "epsg", 7548,
        "NAD83(2011) / WISCRS Grant (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.41111111111111 +lon_0=-90.8 +k=1.0");
    add_proj4text (p, 1,
        "000349452 +x_0=242316.4841 +y_0=0.01 +ellps=GRS80 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Grant (m)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "(2011)\",DATUM[\"NAD83_National_Spatial_Reference_System");
    add_srs_wkt (p, 2,
        "_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",41.4111111111");
    add_srs_wkt (p, 9,
        "1111],PARAMETER[\"central_meridian\",-90.8],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "scale_factor\",1.0000349452],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",242316.4841],PARAMETER[\"false_northing\",0.01],UNIT[\"");
    add_srs_wkt (p, 12,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7548\"]]");
    p = add_epsg_def_ex (filter, first, last, 7549, "epsg", 7549,
        "NAD83(2011) / WISCRS Green and Lafayette (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.63756227694444 +lat_0=42.63756227694");
    add_proj4text (p, 1,
        "444 +lon_0=-89.83888888888889 +k_0=1.0000390487 +x_0=170");
    add_proj4text (p, 2,
        "078.7403 +y_0=45830.2947 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Green and Lafayette (m)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 2,
        "ference_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 3,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 5,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 6,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 7,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"");
    add_srs_wkt (p, 8,
        "Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 9,
        "rigin\",42.63756227694444],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",-89.83888888888889],PARAMETER[\"scale_factor\",1.000039");
    add_srs_wkt (p, 11,
        "0487],PARAMETER[\"false_easting\",170078.7403],PARAMETER");
    add_srs_wkt (p, 12,
        "[\"false_northing\",45830.2947],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 13,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH");
    add_srs_wkt (p, 14,
        "],AUTHORITY[\"EPSG\",\"7549\"]]");
    p = add_epsg_def_ex (filter, first, last, 7550, "epsg", 7550,
        "NAD83(2011) / WISCRS Green Lake and Marquette (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.80700011777778 +lat_0=43.80700011777");
    add_proj4text (p, 1,
        "778 +lon_0=-89.24166666666667 +k_0=1.0000344057 +x_0=150");
    add_proj4text (p, 2,
        "876.3018 +y_0=79170.7795 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Green Lake and Marquette (");
    add_srs_wkt (p, 1,
        "m)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spati");
    add_srs_wkt (p, 2,
        "al_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_origin\",43.80700011777778],PARAMETER[\"central_meri");
    add_srs_wkt (p, 10,
        "dian\",-89.24166666666667],PARAMETER[\"scale_factor\",1.");
    add_srs_wkt (p, 11,
        "0000344057],PARAMETER[\"false_easting\",150876.3018],PAR");
    add_srs_wkt (p, 12,
        "AMETER[\"false_northing\",79170.7795],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"7550\"]]");
    p = add_epsg_def_ex (filter, first, last, 7551, "epsg", 7551,
        "NAD83(2011) / WISCRS Iowa (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.53888888888888 +lon_0=-90.16111111");
    add_proj4text (p, 1,
        "111111 +k=1.0000394961 +x_0=113081.0261 +y_0=0.0045 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Iowa (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 8,
        "cator\"],PARAMETER[\"latitude_of_origin\",42.53888888888");
    add_srs_wkt (p, 9,
        "888],PARAMETER[\"central_meridian\",-90.16111111111111],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"scale_factor\",1.0000394961],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",113081.0261],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 12,
        ".0045],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"75");
    add_srs_wkt (p, 14,
        "51\"]]");
    p = add_epsg_def_ex (filter, first, last, 7552, "epsg", 7552,
        "NAD83(2011) / WISCRS Iron (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45.43333333333333 +lon_0=-90.25555555");
    add_proj4text (p, 1,
        "555556 +k=1.0000677153 +x_0=220980.4419 +y_0=0.008500000");
    add_proj4text (p, 2,
        "000000001 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Iron (m)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "2011)\",DATUM[\"NAD83_National_Spatial_Reference_System_");
    add_srs_wkt (p, 2,
        "2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]],P");
    add_srs_wkt (p, 4,
        "RIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT");
    add_srs_wkt (p, 5,
        "[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122");
    add_srs_wkt (p, 6,
        "\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],A");
    add_srs_wkt (p, 7,
        "UTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_Mer");
    add_srs_wkt (p, 8,
        "cator\"],PARAMETER[\"latitude_of_origin\",45.43333333333");
    add_srs_wkt (p, 9,
        "333],PARAMETER[\"central_meridian\",-90.25555555555556],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"scale_factor\",1.0000677153],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",220980.4419],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 12,
        ".0085],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"75");
    add_srs_wkt (p, 14,
        "52\"]]");
    p = add_epsg_def_ex (filter, first, last, 7553, "epsg", 7553,
        "NAD83(2011) / WISCRS Jackson (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.25333512777778 +lon_0=-90.84429651");
    add_proj4text (p, 1,
        "944444 +k=1.0000353 +x_0=27000 +y_0=25000 +ellps=GRS80 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Jackson (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",44.25333512");
    add_srs_wkt (p, 9,
        "777778],PARAMETER[\"central_meridian\",-90.8442965194444");
    add_srs_wkt (p, 10,
        "4],PARAMETER[\"scale_factor\",1.0000353],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",27000],PARAMETER[\"false_northing\",25000],");
    add_srs_wkt (p, 12,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"7553\"]]");
    p = add_epsg_def_ex (filter, first, last, 7554, "epsg", 7554,
        "NAD83(2011) / WISCRS Kenosha, Milwaukee, Ozaukee and Racine (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.21666666666667 +lon_0=-87.89444444");
    add_proj4text (p, 1,
        "444445 +k=1.0000260649 +x_0=185928.3728 +y_0=0.0009 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Kenosha, Milwaukee, Ozauke");
    add_srs_wkt (p, 1,
        "e and Racine (m)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_");
    add_srs_wkt (p, 2,
        "National_Spatial_Reference_System_2011\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 3,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],AUTHORITY[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"63");
    add_srs_wkt (p, 8,
        "18\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",42.21666666666667],PARAMETER[\"centr");
    add_srs_wkt (p, 10,
        "al_meridian\",-87.89444444444445],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 11,
        "or\",1.0000260649],PARAMETER[\"false_easting\",185928.37");
    add_srs_wkt (p, 12,
        "28],PARAMETER[\"false_northing\",0.0009],UNIT[\"metre\",");
    add_srs_wkt (p, 13,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"7554\"]]");
    p = add_epsg_def_ex (filter, first, last, 7555, "epsg", 7555,
        "NAD83(2011) / WISCRS Kewaunee, Manitowoc and Sheboygan (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.26666666666667 +lon_0=-87.55 +k=1.");
    add_proj4text (p, 1,
        "0000233704 +x_0=79857.7614 +y_0=0.0012 +ellps=GRS80 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Kewaunee, Manitowoc and Sh");
    add_srs_wkt (p, 1,
        "eboygan (m)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_Natio");
    add_srs_wkt (p, 2,
        "nal_Spatial_Reference_System_2011\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 3,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 5,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 6,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 7,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]]");
    add_srs_wkt (p, 8,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 9,
        "e_of_origin\",43.26666666666667],PARAMETER[\"central_mer");
    add_srs_wkt (p, 10,
        "idian\",-87.55],PARAMETER[\"scale_factor\",1.0000233704]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_easting\",79857.7614],PARAMETER[\"fal");
    add_srs_wkt (p, 12,
        "se_northing\",0.0012],UNIT[\"metre\",1,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"7555\"]]");
    p = add_epsg_def_ex (filter, first, last, 7556, "epsg", 7556,
        "NAD83(2011) / WISCRS La Crosse (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.45111111111111 +lon_0=-91.31666666");
    add_proj4text (p, 1,
        "666666 +k=1.0000319985 +x_0=130454.6598 +y_0=0.0033 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS La Crosse (m)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sy");
    add_srs_wkt (p, 2,
        "stem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse");
    add_srs_wkt (p, 8,
        "_Mercator\"],PARAMETER[\"latitude_of_origin\",43.4511111");
    add_srs_wkt (p, 9,
        "1111111],PARAMETER[\"central_meridian\",-91.316666666666");
    add_srs_wkt (p, 10,
        "66],PARAMETER[\"scale_factor\",1.0000319985],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",130454.6598],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0.0033],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "7556\"]]");
    p = add_epsg_def_ex (filter, first, last, 7557, "epsg", 7557,
        "NAD83(2011) / WISCRS Langlade (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.15423710527778 +lat_0=45.15423710527");
    add_proj4text (p, 1,
        "778 +lon_0=-89.03333333333333 +k_0=1.0000627024 +x_0=198");
    add_proj4text (p, 2,
        "425.197 +y_0=105279.7829 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Langlade (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 8,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",45");
    add_srs_wkt (p, 9,
        ".15423710527778],PARAMETER[\"central_meridian\",-89.0333");
    add_srs_wkt (p, 10,
        "3333333333],PARAMETER[\"scale_factor\",1.0000627024],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",198425.197],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",105279.7829],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"7557\"]]");
    p = add_epsg_def_ex (filter, first, last, 7558, "epsg", 7558,
        "NAD83(2011) / WISCRS Lincoln (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.84444444444445 +lon_0=-89.73333333");
    add_proj4text (p, 1,
        "333333 +k=1.0000599003 +x_0=116129.0323 +y_0=0.0058 +ell");
    add_proj4text (p, 2,
        "ps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Lincoln (m)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Syst");
    add_srs_wkt (p, 2,
        "em_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transverse_");
    add_srs_wkt (p, 8,
        "Mercator\"],PARAMETER[\"latitude_of_origin\",44.84444444");
    add_srs_wkt (p, 9,
        "444445],PARAMETER[\"central_meridian\",-89.7333333333333");
    add_srs_wkt (p, 10,
        "3],PARAMETER[\"scale_factor\",1.0000599003],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",116129.0323],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0.0058],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "7558\"]]");
    p = add_epsg_def_ex (filter, first, last, 7559, "epsg", 7559,
        "NAD83(2011) / WISCRS Marathon (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.90090442361111 +lat_0=44.90090442361");
    add_proj4text (p, 1,
        "111 +lon_0=-89.77 +k_0=1.000053289 +x_0=74676.1493 +y_0=");
    add_proj4text (p, 2,
        "55049.2669 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / WISCRS Marathon (m)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_Sys");
    add_srs_wkt (p, 2,
        "tem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 8,
        "nformal_Conic_1SP\"],PARAMETER[\"latitude_of_origin\",44");
    add_srs_wkt (p, 9,
        ".90090442361111],PARAMETER[\"central_meridian\",-89.77],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"scale_factor\",1.000053289],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_easting\",74676.1493],PARAMETER[\"false_northing\",550");
    add_srs_wkt (p, 12,
        "49.2669],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 13,
        "AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "7559\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

