/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Wed Mar 21 19:30:16 2018

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_33 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 6661, "epsg", 6661,
        "NAD83(CSRS) / UTM zone 18N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83(CSRS) / UTM zone 18N + CGVD2013 height\"");
    add_srs_wkt (p, 1,
        ",PROJCS[\"NAD83(CSRS) / UTM zone 18N\",GEOGCS[\"NAD83(CS");
    add_srs_wkt (p, 2,
        "RS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 8,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[");
    add_srs_wkt (p, 9,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",0],PARAMETER[\"central_meridian\",-75],PARAMETER[\"scal");
    add_srs_wkt (p, 11,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 12,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 14,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"2959\"]],VERT_CS[\"CG");
    add_srs_wkt (p, 15,
        "VD2013 height\",VERT_DATUM[\"Canadian Geodetic Vertical ");
    add_srs_wkt (p, 16,
        "Datum of 2013\",2005,AUTHORITY[\"EPSG\",\"1127\"]],UNIT[");
    add_srs_wkt (p, 17,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"6647\"]],AUTHORITY[\"EPSG\",\"666");
    add_srs_wkt (p, 19,
        "1\"]]");
    p = add_epsg_def_ex (filter, first, last, 6662, "epsg", 6662,
        "NAD83(CSRS) / UTM zone 19N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83(CSRS) / UTM zone 19N + CGVD2013 height\"");
    add_srs_wkt (p, 1,
        ",PROJCS[\"NAD83(CSRS) / UTM zone 19N\",GEOGCS[\"NAD83(CS");
    add_srs_wkt (p, 2,
        "RS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 8,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[");
    add_srs_wkt (p, 9,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",0],PARAMETER[\"central_meridian\",-69],PARAMETER[\"scal");
    add_srs_wkt (p, 11,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 12,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 14,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"2960\"]],VERT_CS[\"CG");
    add_srs_wkt (p, 15,
        "VD2013 height\",VERT_DATUM[\"Canadian Geodetic Vertical ");
    add_srs_wkt (p, 16,
        "Datum of 2013\",2005,AUTHORITY[\"EPSG\",\"1127\"]],UNIT[");
    add_srs_wkt (p, 17,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"6647\"]],AUTHORITY[\"EPSG\",\"666");
    add_srs_wkt (p, 19,
        "2\"]]");
    p = add_epsg_def_ex (filter, first, last, 6663, "epsg", 6663,
        "NAD83(CSRS) / UTM zone 20N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83(CSRS) / UTM zone 20N + CGVD2013 height\"");
    add_srs_wkt (p, 1,
        ",PROJCS[\"NAD83(CSRS) / UTM zone 20N\",GEOGCS[\"NAD83(CS");
    add_srs_wkt (p, 2,
        "RS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 8,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[");
    add_srs_wkt (p, 9,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",0],PARAMETER[\"central_meridian\",-63],PARAMETER[\"scal");
    add_srs_wkt (p, 11,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 12,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 14,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"2961\"]],VERT_CS[\"CG");
    add_srs_wkt (p, 15,
        "VD2013 height\",VERT_DATUM[\"Canadian Geodetic Vertical ");
    add_srs_wkt (p, 16,
        "Datum of 2013\",2005,AUTHORITY[\"EPSG\",\"1127\"]],UNIT[");
    add_srs_wkt (p, 17,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"6647\"]],AUTHORITY[\"EPSG\",\"666");
    add_srs_wkt (p, 19,
        "3\"]]");
    p = add_epsg_def_ex (filter, first, last, 6664, "epsg", 6664,
        "NAD83(CSRS) / UTM zone 21N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83(CSRS) / UTM zone 21N + CGVD2013 height\"");
    add_srs_wkt (p, 1,
        ",PROJCS[\"NAD83(CSRS) / UTM zone 21N\",GEOGCS[\"NAD83(CS");
    add_srs_wkt (p, 2,
        "RS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 8,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[");
    add_srs_wkt (p, 9,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",0],PARAMETER[\"central_meridian\",-57],PARAMETER[\"scal");
    add_srs_wkt (p, 11,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 12,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 14,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"2962\"]],VERT_CS[\"CG");
    add_srs_wkt (p, 15,
        "VD2013 height\",VERT_DATUM[\"Canadian Geodetic Vertical ");
    add_srs_wkt (p, 16,
        "Datum of 2013\",2005,AUTHORITY[\"EPSG\",\"1127\"]],UNIT[");
    add_srs_wkt (p, 17,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"6647\"]],AUTHORITY[\"EPSG\",\"666");
    add_srs_wkt (p, 19,
        "4\"]]");
    p = add_epsg_def_ex (filter, first, last, 6665, "epsg", 6665,
        "NAD83(CSRS) / UTM zone 22N", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=22 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"NAD83(CSRS) / UTM zone 22N + CGVD2013 height\"");
    add_srs_wkt (p, 1,
        ",PROJCS[\"NAD83(CSRS) / UTM zone 22N\",GEOGCS[\"NAD83(CS");
    add_srs_wkt (p, 2,
        "RS)\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",");
    add_srs_wkt (p, 3,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 8,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[");
    add_srs_wkt (p, 9,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 10,
        ",0],PARAMETER[\"central_meridian\",-51],PARAMETER[\"scal");
    add_srs_wkt (p, 11,
        "e_factor\",0.9996],PARAMETER[\"false_easting\",500000],P");
    add_srs_wkt (p, 12,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 13,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 14,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"3761\"]],VERT_CS[\"CG");
    add_srs_wkt (p, 15,
        "VD2013 height\",VERT_DATUM[\"Canadian Geodetic Vertical ");
    add_srs_wkt (p, 16,
        "Datum of 2013\",2005,AUTHORITY[\"EPSG\",\"1127\"]],UNIT[");
    add_srs_wkt (p, 17,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP");
    add_srs_wkt (p, 18,
        "],AUTHORITY[\"EPSG\",\"6647\"]],AUTHORITY[\"EPSG\",\"666");
    add_srs_wkt (p, 19,
        "5\"]]");
    p = add_epsg_def_ex (filter, first, last, 6668, "epsg", 6668,
        "JGD2011", 1, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"");
    add_srs_wkt (p, 3,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 4,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 5,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"6668\"]]");
    p = add_epsg_def_ex (filter, first, last, 6669, "epsg", 6669,
        "JGD2011 / Japan Plane Rectangular CS I", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=33 +lon_0=129.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS I\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",33],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",129.5],PARAMETER[\"scale_factor\",0.9999],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",0],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"6669\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 6670, "epsg", 6670,
        "JGD2011 / Japan Plane Rectangular CS II", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=33 +lon_0=131 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS II\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",33],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",131],PARAMETER[\"scale_factor\",0.9999],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"6670\"]]");
    p = add_epsg_def_ex (filter, first, last, 6671, "epsg", 6671,
        "JGD2011 / Japan Plane Rectangular CS III", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=132.1666666666667 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS III\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",36],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",132.1666666666667],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.9999],PARAMETER[\"false_easting\",0],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"6671\"]]");
    p = add_epsg_def_ex (filter, first, last, 6672, "epsg", 6672,
        "JGD2011 / Japan Plane Rectangular CS IV", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=33 +lon_0=133.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS IV\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",33],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",133.5],PARAMETER[\"scale_factor\",0.9999],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",0],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"6672\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 6673, "epsg", 6673,
        "JGD2011 / Japan Plane Rectangular CS V", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=134.3333333333333 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS V\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",36],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",134.3333333333333],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9999],PARAMETER[\"false_easting\",0],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"6673\"]]");
    p = add_epsg_def_ex (filter, first, last, 6674, "epsg", 6674,
        "JGD2011 / Japan Plane Rectangular CS VI", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=136 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS VI\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",36],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",136],PARAMETER[\"scale_factor\",0.9999],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",0],PARAMETER[\"false_northing\",0],");
    add_srs_wkt (p, 11,
        "UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 12,
        ",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"6674\"]]");
    p = add_epsg_def_ex (filter, first, last, 6675, "epsg", 6675,
        "JGD2011 / Japan Plane Rectangular CS VII", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=137.1666666666667 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS VII\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",36],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",137.1666666666667],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 10,
        ",0.9999],PARAMETER[\"false_easting\",0],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"6675\"]]");
    p = add_epsg_def_ex (filter, first, last, 6676, "epsg", 6676,
        "JGD2011 / Japan Plane Rectangular CS VIII", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=138.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS VIII\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",36],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",138.5],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",0],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"667");
    add_srs_wkt (p, 13,
        "6\"]]");
    p = add_epsg_def_ex (filter, first, last, 6677, "epsg", 6677,
        "JGD2011 / Japan Plane Rectangular CS IX", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36 +lon_0=139.8333333333333 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS IX\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",36],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",139.8333333333333],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9999],PARAMETER[\"false_easting\",0],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"6677\"]]");
    p = add_epsg_def_ex (filter, first, last, 6678, "epsg", 6678,
        "JGD2011 / Japan Plane Rectangular CS X", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=40 +lon_0=140.8333333333333 +k=0.9999");
    add_proj4text (p, 1,
        " +x_0=0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS X\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",40],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",140.8333333333333],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 10,
        ".9999],PARAMETER[\"false_easting\",0],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 12,
        "\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"6678\"]]");
    p = add_epsg_def_ex (filter, first, last, 6679, "epsg", 6679,
        "JGD2011 / Japan Plane Rectangular CS XI", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44 +lon_0=140.25 +k=0.9999 +x_0=0 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XI\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",44],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",140.25],PARAMETER[\"scale_factor\",0.9999],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",0],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"6679\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 6680, "epsg", 6680,
        "JGD2011 / Japan Plane Rectangular CS XII", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44 +lon_0=142.25 +k=0.9999 +x_0=0 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XII\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",44],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",142.25],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_easting\",0],PARAMETER[\"false_northing");
    add_srs_wkt (p, 11,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 12,
        "S[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"668");
    add_srs_wkt (p, 13,
        "0\"]]");
    p = add_epsg_def_ex (filter, first, last, 6681, "epsg", 6681,
        "JGD2011 / Japan Plane Rectangular CS XIII", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44 +lon_0=144.25 +k=0.9999 +x_0=0 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XIII\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",44],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",144.25],PARAMETER[\"scale_factor\",0.9999],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",0],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 12,
        "IS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"66");
    add_srs_wkt (p, 13,
        "81\"]]");
    p = add_epsg_def_ex (filter, first, last, 6682, "epsg", 6682,
        "JGD2011 / Japan Plane Rectangular CS XIV", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=142 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XIV\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",26],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",142],PARAMETER[\"scale_factor\",0.9999],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",0],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"6682\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 6683, "epsg", 6683,
        "JGD2011 / Japan Plane Rectangular CS XV", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=127.5 +k=0.9999 +x_0=0 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XV\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 4,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",26],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",127.5],PARAMETER[\"scale_factor\",0.9999],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",0],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 11,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"6683\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 6684, "epsg", 6684,
        "JGD2011 / Japan Plane Rectangular CS XVI", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=124 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XVI\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",26],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",124],PARAMETER[\"scale_factor\",0.9999],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",0],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"6684\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 6685, "epsg", 6685,
        "JGD2011 / Japan Plane Rectangular CS XVII", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=131 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XVII\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",26],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",131],PARAMETER[\"scale_factor\",0.9999],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"6685\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 6686, "epsg", 6686,
        "JGD2011 / Japan Plane Rectangular CS XVIII", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=20 +lon_0=136 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XVIII\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",20],PARAMETER[\"centra");
    add_srs_wkt (p, 9,
        "l_meridian\",136],PARAMETER[\"scale_factor\",0.9999],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"false_easting\",0],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"6686\"");
    add_srs_wkt (p, 13,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 6687, "epsg", 6687,
        "JGD2011 / Japan Plane Rectangular CS XIX", 0, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=26 +lon_0=154 +k=0.9999 +x_0=0 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / Japan Plane Rectangular CS XIX\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"6668\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",26],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",154],PARAMETER[\"scale_factor\",0.9999],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",0],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 11,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 12,
        "X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"6687\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 6688, "epsg", 6688,
        "JGD2011 / UTM zone 51N", 0, 0,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=51 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / UTM zone 51N\",GEOGCS[\"JGD2011\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Japanese_Geodetic_Datum_2011\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 6,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6668\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",123],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6688\"]]");
    p = add_epsg_def_ex (filter, first, last, 6689, "epsg", 6689,
        "JGD2011 / UTM zone 52N", 0, 0,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=52 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / UTM zone 52N\",GEOGCS[\"JGD2011\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Japanese_Geodetic_Datum_2011\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 6,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6668\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",129],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6689\"]]");
    p = add_epsg_def_ex (filter, first, last, 6690, "epsg", 6690,
        "JGD2011 / UTM zone 53N", 0, 0,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=53 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / UTM zone 53N\",GEOGCS[\"JGD2011\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Japanese_Geodetic_Datum_2011\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 6,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6668\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",135],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6690\"]]");
    p = add_epsg_def_ex (filter, first, last, 6691, "epsg", 6691,
        "JGD2011 / UTM zone 54N", 0, 0,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=54 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / UTM zone 54N\",GEOGCS[\"JGD2011\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Japanese_Geodetic_Datum_2011\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 6,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6668\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",141],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6691\"]]");
    p = add_epsg_def_ex (filter, first, last, 6692, "epsg", 6692,
        "JGD2011 / UTM zone 55N", 0, 0,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=55 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"JGD2011 / UTM zone 55N\",GEOGCS[\"JGD2011\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"Japanese_Geodetic_Datum_2011\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 2,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Greenwich\",0,AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251994");
    add_srs_wkt (p, 5,
        "33,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH");
    add_srs_wkt (p, 6,
        "],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6668\"]]");
    add_srs_wkt (p, 7,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 8,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",147],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"scale_factor\",0.9996],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"6692\"]]");
    p = add_epsg_def_ex (filter, first, last, 6696, "epsg", 6696,
        "JGD2000", 1, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2000", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +vunit");
    add_proj4text (p, 1,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"JGD2000 + JGD2000 (vertical) height\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"JGD2000\",DATUM[\"Japanese_Geodetic_Datum_2000\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6612\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4612\"]],VERT_CS[\"JGD2000");
    add_srs_wkt (p, 8,
        " (vertical) height\",VERT_DATUM[\"Japanese Geodetic Datu");
    add_srs_wkt (p, 9,
        "m 2000 (vertical)\",2005,AUTHORITY[\"EPSG\",\"1130\"]],U");
    add_srs_wkt (p, 10,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Up\"");
    add_srs_wkt (p, 11,
        ",UP],AUTHORITY[\"EPSG\",\"6694\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "6696\"]]");
    p = add_epsg_def_ex (filter, first, last, 6697, "epsg", 6697,
        "JGD2011", 1, 1,
        "GRS 1980", "Greenwich",
        "Japanese_Geodetic_Datum_2011", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"JGD2011 + JGD2011 (vertical) height\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"JGD2011\",DATUM[\"Japanese_Geodetic_Datum_2011\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],AUTHORITY[\"EPSG\",\"1128\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 6,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 7,
        "SG\",\"6668\"]],VERT_CS[\"JGD2011 (vertical) height\",VE");
    add_srs_wkt (p, 8,
        "RT_DATUM[\"Japanese Geodetic Datum 2011 (vertical)\",200");
    add_srs_wkt (p, 9,
        "5,AUTHORITY[\"EPSG\",\"1131\"]],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 10,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 11,
        ",\"6695\"]],AUTHORITY[\"EPSG\",\"6697\"]]");
    p = add_epsg_def_ex (filter, first, last, 6700, "epsg", 6700,
        "Tokyo", 1, 1,
        "Bessel 1841", "Greenwich",
        "Tokyo", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=bessel +towgs84=-146.414,507.337,68");
    add_proj4text (p, 1,
        "0.507,0,0,0,0 +vunits=m +no_defs");
    add_srs_wkt (p, 0,
        "COMPD_CS[\"Tokyo + JSLD72 height\",GEOGCS[\"Tokyo\",DATU");
    add_srs_wkt (p, 1,
        "M[\"Tokyo\",SPHEROID[\"Bessel 1841\",6377397.155,299.152");
    add_srs_wkt (p, 2,
        "8128,AUTHORITY[\"EPSG\",\"7004\"]],TOWGS84[-146.414,507.");
    add_srs_wkt (p, 3,
        "337,680.507,0,0,0,0],AUTHORITY[\"EPSG\",\"6301\"]],PRIME");
    add_srs_wkt (p, 4,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 5,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 7,
        "RITY[\"EPSG\",\"4301\"]],VERT_CS[\"JSLD72 height\",VERT_");
    add_srs_wkt (p, 8,
        "DATUM[\"Japanese Standard Levelling Datum 1972\",2005,AU");
    add_srs_wkt (p, 9,
        "THORITY[\"EPSG\",\"1129\"]],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 10,
        "EPSG\",\"9001\"]],AXIS[\"Up\",UP],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 11,
        "693\"]],AUTHORITY[\"EPSG\",\"6700\"]]");
    p = add_epsg_def_ex (filter, first, last, 6703, "epsg", 6703,
        "WGS 84 / TM 60 SW", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-60 +k=0.9996 +x_0=500000 +y");
    add_proj4text (p, 1,
        "_0=10000000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / TM 60 SW\",GEOGCS[\"WGS 84\",DATUM[\"W");
    add_srs_wkt (p, 1,
        "GS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTH");
    add_srs_wkt (p, 2,
        "ORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],");
    add_srs_wkt (p, 3,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 4,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 5,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",-60],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "996],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"6703\"]]");
    p = add_epsg_def_ex (filter, first, last, 6706, "epsg", 6706,
        "RDN2008", 1, 1,
        "GRS 1980", "Greenwich",
        "Rete_Dinamica_Nazionale_2008", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +no_de");
    add_proj4text (p, 1,
        "fs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"RDN2008\",DATUM[\"Rete_Dinamica_Nazionale_2008\"");
    add_srs_wkt (p, 1,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 2,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"1132\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"6706\"]]");
    p = add_epsg_def_ex (filter, first, last, 6707, "epsg", 6707,
        "RDN2008 / UTM zone 32N (N-E)", 0, 1,
        "GRS 1980", "Greenwich",
        "Rete_Dinamica_Nazionale_2008", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RDN2008 / UTM zone 32N (N-E)\",GEOGCS[\"RDN2008");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Rete_Dinamica_Nazionale_2008\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1132\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"6706\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",9],PARAMETER[\"scale_factor\",0.999");
    add_srs_wkt (p, 10,
        "6],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 12,
        "1\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"6707\"]]");
    p = add_epsg_def_ex (filter, first, last, 6708, "epsg", 6708,
        "RDN2008 / UTM zone 33N (N-E)", 0, 1,
        "GRS 1980", "Greenwich",
        "Rete_Dinamica_Nazionale_2008", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RDN2008 / UTM zone 33N (N-E)\",GEOGCS[\"RDN2008");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Rete_Dinamica_Nazionale_2008\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1132\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"6706\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",15],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 10,
        "96],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"6708\"]]");
    p = add_epsg_def_ex (filter, first, last, 6709, "epsg", 6709,
        "RDN2008 / UTM zone 34N (N-E)", 0, 1,
        "GRS 1980", "Greenwich",
        "Rete_Dinamica_Nazionale_2008", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RDN2008 / UTM zone 34N (N-E)\",GEOGCS[\"RDN2008");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Rete_Dinamica_Nazionale_2008\",SPHEROID[\"GRS");
    add_srs_wkt (p, 2,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"1132\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"6706\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 8,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"central_meridian\",21],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 10,
        "96],PARAMETER[\"false_easting\",500000],PARAMETER[\"fals");
    add_srs_wkt (p, 11,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 12,
        "01\"]],AXIS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"6709\"]]");
    p = add_epsg_def_ex (filter, first, last, 6720, "epsg", 6720,
        "WGS 84 / CIG92", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105.625 +k=1.000024 +x_0=500");
    add_proj4text (p, 1,
        "00 +y_0=1300000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / CIG92\",GEOGCS[\"WGS 84\",DATUM[\"WGS_");
    add_srs_wkt (p, 1,
        "1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORI");
    add_srs_wkt (p, 2,
        "TY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRI");
    add_srs_wkt (p, 3,
        "MEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 4,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 5,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",105.625],PARAMETER[\"scale_factor\",1.0");
    add_srs_wkt (p, 9,
        "00024],PARAMETER[\"false_easting\",50000],PARAMETER[\"fa");
    add_srs_wkt (p, 10,
        "lse_northing\",1300000],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",");
    add_srs_wkt (p, 12,
        "NORTH],AUTHORITY[\"EPSG\",\"6720\"]]");
    p = add_epsg_def_ex (filter, first, last, 6721, "epsg", 6721,
        "GDA94 / CIG94", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105.625 +k=1.00002514 +x_0=5");
    add_proj4text (p, 1,
        "0000 +y_0=1300000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / CIG94\",GEOGCS[\"GDA94\",DATUM[\"Geocen");
    add_srs_wkt (p, 1,
        "tric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84");
    add_srs_wkt (p, 3,
        "[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS");
    add_srs_wkt (p, 6,
        "[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[");
    add_srs_wkt (p, 7,
        "\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Mercator\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 9,
        "meridian\",105.625],PARAMETER[\"scale_factor\",1.0000251");
    add_srs_wkt (p, 10,
        "4],PARAMETER[\"false_easting\",50000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",1300000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"6721\"]]");
    p = add_epsg_def_ex (filter, first, last, 6722, "epsg", 6722,
        "WGS 84 / CKIG92", 0, 0,
        "WGS 84", "Greenwich",
        "WGS_1984", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=96.875 +k=1 +x_0=50000 +y_0=");
    add_proj4text (p, 1,
        "1400000 +datum=WGS84 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 84 / CKIG92\",GEOGCS[\"WGS 84\",DATUM[\"WGS");
    add_srs_wkt (p, 1,
        "_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHOR");
    add_srs_wkt (p, 2,
        "ITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PR");
    add_srs_wkt (p, 3,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 4,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 5,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4326\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",96.875],PARAMETER[\"scale_factor\",1],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"false_easting\",50000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",1400000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"6722\"]]");
    p = add_epsg_def_ex (filter, first, last, 6723, "epsg", 6723,
        "GDA94 / CKIG94", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=96.875 +k=0.99999387 +x_0=50");
    add_proj4text (p, 1,
        "000 +y_0=1500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +un");
    add_proj4text (p, 2,
        "its=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / CKIG94\",GEOGCS[\"GDA94\",DATUM[\"Geoce");
    add_srs_wkt (p, 1,
        "ntric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",96.875],PARAMETER[\"scale_factor\",0.9999938");
    add_srs_wkt (p, 10,
        "7],PARAMETER[\"false_easting\",50000],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "northing\",1500000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"6723\"]]");
    p = add_epsg_def_ex (filter, first, last, 6732, "epsg", 6732,
        "GDA94 / MGA zone 41 (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=41 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 41 (deprecated)\",GEOGCS[\"GDA");
    add_srs_wkt (p, 1,
        "94\",DATUM[\"Geocentric_Datum_of_Australia_1994\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6283\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",63],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 13,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"6732\"]]");
    p = add_epsg_def_ex (filter, first, last, 6733, "epsg", 6733,
        "GDA94 / MGA zone 42 (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=42 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 42 (deprecated)\",GEOGCS[\"GDA");
    add_srs_wkt (p, 1,
        "94\",DATUM[\"Geocentric_Datum_of_Australia_1994\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6283\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",69],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 13,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"6733\"]]");
    p = add_epsg_def_ex (filter, first, last, 6734, "epsg", 6734,
        "GDA94 / MGA zone 43 (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=43 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 43 (deprecated)\",GEOGCS[\"GDA");
    add_srs_wkt (p, 1,
        "94\",DATUM[\"Geocentric_Datum_of_Australia_1994\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6283\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",75],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 13,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"6734\"]]");
    p = add_epsg_def_ex (filter, first, last, 6735, "epsg", 6735,
        "GDA94 / MGA zone 44 (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=44 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 44 (deprecated)\",GEOGCS[\"GDA");
    add_srs_wkt (p, 1,
        "94\",DATUM[\"Geocentric_Datum_of_Australia_1994\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6283\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",81],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",0.9996],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",10000000],UNIT[\"metre\",1,AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nor");
    add_srs_wkt (p, 13,
        "thing\",NORTH],AUTHORITY[\"EPSG\",\"6735\"]]");
    p = add_epsg_def_ex (filter, first, last, 6736, "epsg", 6736,
        "GDA94 / MGA zone 46", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=46 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 46\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",93],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"6736\"]]");
    p = add_epsg_def_ex (filter, first, last, 6737, "epsg", 6737,
        "GDA94 / MGA zone 47", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=47 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 47\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",99],PARAMETER[\"scale_factor\",0.9996],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"false_easting\",500000],PARAMETER[\"false_no");
    add_srs_wkt (p, 11,
        "rthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"6737\"]]");
    p = add_epsg_def_ex (filter, first, last, 6738, "epsg", 6738,
        "GDA94 / MGA zone 59", 0, 0,
        "GRS 1980", "Greenwich",
        "Geocentric_Datum_of_Australia_1994", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=59 +south +ellps=GRS80 +towgs84=0,0,0,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GDA94 / MGA zone 59\",GEOGCS[\"GDA94\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Geocentric_Datum_of_Australia_1994\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 2,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 3,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6283\"]],PRIM");
    add_srs_wkt (p, 4,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 5,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 6,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4283\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",171],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",10000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"6738\"]]");
    p = add_epsg_def_ex (filter, first, last, 6783, "epsg", 6783,
        "NAD83(CORS96)", 1, 1,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "none", "degree",
        "Latitude", "North", "Longitude", "East");
    add_proj4text (p, 0,
        "+proj=longlat +ellps=GRS80 +no_defs");
    add_srs_wkt (p, 0,
        "GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Oper");
    add_srs_wkt (p, 1,
        "ating_Reference_Station_1996\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 2,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 6,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]]");
    p = add_epsg_def_ex (filter, first, last, 6784, "epsg", 6784,
        "NAD83(CORS96) / Oregon Baker zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.5 +lon_0=-117.8333333333333 +k=1.0");
    add_proj4text (p, 1,
        "0016 +x_0=40000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Baker zone (m)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operating_R");
    add_srs_wkt (p, 2,
        "eference_Station_1996\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 4,
        "SG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 9,
        ",44.5],PARAMETER[\"central_meridian\",-117.8333333333333");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"scale_factor\",1.00016],PARAMETER[\"false_");
    add_srs_wkt (p, 11,
        "easting\",40000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 12,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST]");
    add_srs_wkt (p, 13,
        ",AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6784\"]]");
    p = add_epsg_def_ex (filter, first, last, 6785, "epsg", 6785,
        "NAD83(CORS96) / Oregon Baker zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.5 +lon_0=-117.8333333333333 +k=1.0");
    add_proj4text (p, 1,
        "0016 +x_0=39999.99999984 +y_0=0 +ellps=GRS80 +units=ft +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Baker zone (ft)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operating_");
    add_srs_wkt (p, 2,
        "Reference_Station_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",44.5],PARAMETER[\"central_meridian\",-117.8333333333");
    add_srs_wkt (p, 10,
        "333],PARAMETER[\"scale_factor\",1.00016],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",131233.5958],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 12,
        "],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXI");
    add_srs_wkt (p, 13,
        "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"678");
    add_srs_wkt (p, 14,
        "5\"]]");
    p = add_epsg_def_ex (filter, first, last, 6786, "epsg", 6786,
        "NAD83(2011) / Oregon Baker zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.5 +lon_0=-117.8333333333333 +k=1.0");
    add_proj4text (p, 1,
        "0016 +x_0=40000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Baker zone (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 8,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",44.5],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"central_meridian\",-117.8333333333333],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"scale_factor\",1.00016],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",40000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 13,
        "\",NORTH],AUTHORITY[\"EPSG\",\"6786\"]]");
    p = add_epsg_def_ex (filter, first, last, 6787, "epsg", 6787,
        "NAD83(2011) / Oregon Baker zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.5 +lon_0=-117.8333333333333 +k=1.0");
    add_proj4text (p, 1,
        "0016 +x_0=39999.99999984 +y_0=0 +ellps=GRS80 +units=ft +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Baker zone (ft)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 8,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",44.5],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"central_meridian\",-117.8333333333333],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"scale_factor\",1.00016],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",131233.5958],PARAMETER[\"false_northing\",0],UNIT[\"foo");
    add_srs_wkt (p, 12,
        "t\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"X\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6787\"]]");
    p = add_epsg_def_ex (filter, first, last, 6788, "epsg", 6788,
        "NAD83(CORS96) / Oregon Bend-Klamath Falls zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.75 +lon_0=-121.75 +k=1.0002 +x_0=8");
    add_proj4text (p, 1,
        "0000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Bend-Klamath Falls zone ");
    add_srs_wkt (p, 1,
        "(m)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuousl");
    add_srs_wkt (p, 2,
        "y_Operating_Reference_Station_1996\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 3,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 6,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 7,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",41.75],PARAMETER[\"central_meridian\",-1");
    add_srs_wkt (p, 10,
        "21.75],PARAMETER[\"scale_factor\",1.0002],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",80000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 12,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6788\"]]");
    p = add_epsg_def_ex (filter, first, last, 6789, "epsg", 6789,
        "NAD83(CORS96) / Oregon Bend-Klamath Falls zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.75 +lon_0=-121.75 +k=1.0002 +x_0=7");
    add_proj4text (p, 1,
        "9999.99999968 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Bend-Klamath Falls zone ");
    add_srs_wkt (p, 1,
        "(ft)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuous");
    add_srs_wkt (p, 2,
        "ly_Operating_Reference_Station_1996\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NO");
    add_srs_wkt (p, 7,
        "RTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",41.75],PARAMETER[\"central_meridian\",-1");
    add_srs_wkt (p, 10,
        "21.75],PARAMETER[\"scale_factor\",1.0002],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",262467.1916],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 12,
        "0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"67");
    add_srs_wkt (p, 14,
        "89\"]]");
    p = add_epsg_def_ex (filter, first, last, 6790, "epsg", 6790,
        "NAD83(2011) / Oregon Bend-Klamath Falls zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.75 +lon_0=-121.75 +k=1.0002 +x_0=8");
    add_proj4text (p, 1,
        "0000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Bend-Klamath Falls zone (m");
    add_srs_wkt (p, 1,
        ")\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatia");
    add_srs_wkt (p, 2,
        "l_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 3,
        "298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",41.75],PARAMETER[\"central_meridian\",-121.75],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",1.0002],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",80000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"6790\"]]");
    p = add_epsg_def_ex (filter, first, last, 6791, "epsg", 6791,
        "NAD83(2011) / Oregon Bend-Klamath Falls zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.75 +lon_0=-121.75 +k=1.0002 +x_0=7");
    add_proj4text (p, 1,
        "9999.99999968 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Bend-Klamath Falls zone (f");
    add_srs_wkt (p, 1,
        "t)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spati");
    add_srs_wkt (p, 2,
        "al_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",41.75],PARAMETER[\"central_meridian\",-121.75],PARA");
    add_srs_wkt (p, 10,
        "METER[\"scale_factor\",1.0002],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",262467.1916],PARAMETER[\"false_northing\",0],UNIT[\"f");
    add_srs_wkt (p, 12,
        "oot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"X\",EA");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6791\"]]");
    p = add_epsg_def_ex (filter, first, last, 6792, "epsg", 6792,
        "NAD83(CORS96) / Oregon Bend-Redmond-Prineville zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.66666666666666 +lat_0=44.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-121.25 +k_0=1.00012 +x_0=80000 +y_0=130000 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Bend-Redmond-Prineville ");
    add_srs_wkt (p, 1,
        "zone (m)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Contin");
    add_srs_wkt (p, 2,
        "uously_Operating_Reference_Station_1996\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"67");
    add_srs_wkt (p, 8,
        "83\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"latitude_of_origin\",44.66666666666666],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"central_meridian\",-121.25],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 11,
        ",1.00012],PARAMETER[\"false_easting\",80000],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",130000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 13,
        "SG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHO");
    add_srs_wkt (p, 14,
        "RITY[\"EPSG\",\"6792\"]]");
    p = add_epsg_def_ex (filter, first, last, 6793, "epsg", 6793,
        "NAD83(CORS96) / Oregon Bend-Redmond-Prineville zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_1SP", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.66666666666666 +lat_0=44.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-121.25 +k_0=1.00012 +x_0=79999.99999968 +y_0");
    add_proj4text (p, 2,
        "=130000.00001472 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Bend-Redmond-Prineville ");
    add_srs_wkt (p, 1,
        "zone (ft)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Conti");
    add_srs_wkt (p, 2,
        "nuously_Operating_Reference_Station_1996\",SPHEROID[\"GR");
    add_srs_wkt (p, 3,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 4,
        "\"]],AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 7,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 8,
        "6783\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"latitude_of_origin\",44.66666666666666],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"central_meridian\",-121.25],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 11,
        "r\",1.00012],PARAMETER[\"false_easting\",262467.1916],PA");
    add_srs_wkt (p, 12,
        "RAMETER[\"false_northing\",426509.1864],UNIT[\"foot\",0.");
    add_srs_wkt (p, 13,
        "3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 14,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6793\"]]");
    p = add_epsg_def_ex (filter, first, last, 6794, "epsg", 6794,
        "NAD83(2011) / Oregon Bend-Redmond-Prineville zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.66666666666666 +lat_0=44.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-121.25 +k_0=1.00012 +x_0=80000 +y_0=130000 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Bend-Redmond-Prineville zo");
    add_srs_wkt (p, 1,
        "ne (m)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_S");
    add_srs_wkt (p, 2,
        "patial_Reference_System_2011\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 3,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 7,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PRO");
    add_srs_wkt (p, 8,
        "JECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"lat");
    add_srs_wkt (p, 9,
        "itude_of_origin\",44.66666666666666],PARAMETER[\"central");
    add_srs_wkt (p, 10,
        "_meridian\",-121.25],PARAMETER[\"scale_factor\",1.00012]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_easting\",80000],PARAMETER[\"false_no");
    add_srs_wkt (p, 12,
        "rthing\",130000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 13,
        "001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"6794\"]]");
    p = add_epsg_def_ex (filter, first, last, 6795, "epsg", 6795,
        "NAD83(2011) / Oregon Bend-Redmond-Prineville zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.66666666666666 +lat_0=44.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-121.25 +k_0=1.00012 +x_0=79999.99999968 +y_0");
    add_proj4text (p, 2,
        "=130000.00001472 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Bend-Redmond-Prineville zo");
    add_srs_wkt (p, 1,
        "ne (ft)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_");
    add_srs_wkt (p, 2,
        "Spatial_Reference_System_2011\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 3,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 7,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"la");
    add_srs_wkt (p, 9,
        "titude_of_origin\",44.66666666666666],PARAMETER[\"centra");
    add_srs_wkt (p, 10,
        "l_meridian\",-121.25],PARAMETER[\"scale_factor\",1.00012");
    add_srs_wkt (p, 11,
        "],PARAMETER[\"false_easting\",262467.1916],PARAMETER[\"f");
    add_srs_wkt (p, 12,
        "alse_northing\",426509.1864],UNIT[\"foot\",0.3048,AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"9002\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 14,
        "H],AUTHORITY[\"EPSG\",\"6795\"]]");
    p = add_epsg_def_ex (filter, first, last, 6796, "epsg", 6796,
        "NAD83(CORS96) / Oregon Bend-Burns zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.66666666666666 +lat_0=43.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-119.75 +k_0=1.0002 +x_0=120000 +y_0=60000 +e");
    add_proj4text (p, 2,
        "llps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Bend-Burns zone (m)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operat");
    add_srs_wkt (p, 2,
        "ing_Reference_Station_1996\",SPHEROID[\"GRS 1980\",63781");
    add_srs_wkt (p, 3,
        "37,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 7,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",43.66666666666666],PARAMETER[\"central_m");
    add_srs_wkt (p, 10,
        "eridian\",-119.75],PARAMETER[\"scale_factor\",1.0002],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",120000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",60000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 13,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 14,
        "\",\"6796\"]]");
    p = add_epsg_def_ex (filter, first, last, 6797, "epsg", 6797,
        "NAD83(CORS96) / Oregon Bend-Burns zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_1SP", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.66666666666666 +lat_0=43.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-119.75 +k_0=1.0002 +x_0=119999.99999952 +y_0");
    add_proj4text (p, 2,
        "=59999.99999976 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Bend-Burns zone (ft)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Opera");
    add_srs_wkt (p, 2,
        "ting_Reference_Station_1996\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 3,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 7,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",43.66666666666666],PARAMETER[\"central_m");
    add_srs_wkt (p, 10,
        "eridian\",-119.75],PARAMETER[\"scale_factor\",1.0002],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",393700.7874],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_northing\",196850.3937],UNIT[\"foot\",0.3048,AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"9002\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"6797\"]]");
    p = add_epsg_def_ex (filter, first, last, 6798, "epsg", 6798,
        "NAD83(2011) / Oregon Bend-Burns zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.66666666666666 +lat_0=43.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-119.75 +k_0=1.0002 +x_0=120000 +y_0=60000 +e");
    add_proj4text (p, 2,
        "llps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Bend-Burns zone (m)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refere");
    add_srs_wkt (p, 2,
        "nce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572");
    add_srs_wkt (p, 3,
        "22101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Lamb");
    add_srs_wkt (p, 8,
        "ert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",43.66666666666666],PARAMETER[\"central_meridian\",-1");
    add_srs_wkt (p, 10,
        "19.75],PARAMETER[\"scale_factor\",1.0002],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",120000],PARAMETER[\"false_northing\",60000");
    add_srs_wkt (p, 12,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6798\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 6799, "epsg", 6799,
        "NAD83(2011) / Oregon Bend-Burns zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.66666666666666 +lat_0=43.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-119.75 +k_0=1.0002 +x_0=119999.99999952 +y_0");
    add_proj4text (p, 2,
        "=59999.99999976 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Bend-Burns zone (ft)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refer");
    add_srs_wkt (p, 2,
        "ence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.257");
    add_srs_wkt (p, 3,
        "222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 7,
        "de\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"La");
    add_srs_wkt (p, 8,
        "mbert_Conformal_Conic_1SP\"],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 9,
        "gin\",43.66666666666666],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 10,
        "-119.75],PARAMETER[\"scale_factor\",1.0002],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",393700.7874],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",196850.3937],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9002\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"6799\"]]");
    p = add_epsg_def_ex (filter, first, last, 6800, "epsg", 6800,
        "NAD83(CORS96) / Oregon Canyonville-Grants Pass zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-123.3333333333333 +k=1.0");
    add_proj4text (p, 1,
        "0007 +x_0=40000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Canyonville-Grants Pass ");
    add_srs_wkt (p, 1,
        "zone (m)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Contin");
    add_srs_wkt (p, 2,
        "uously_Operating_Reference_Station_1996\",SPHEROID[\"GRS");
    add_srs_wkt (p, 3,
        " 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 4,
        "]],AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"67");
    add_srs_wkt (p, 8,
        "83\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",42.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",-123.3333333333333],PARAMETER[\"scale_factor\",1.00007]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_easting\",40000],PARAMETER[\"false_no");
    add_srs_wkt (p, 12,
        "rthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"6800\"]]");
    p = add_epsg_def_ex (filter, first, last, 6801, "epsg", 6801,
        "NAD83(CORS96) / Oregon Canyonville-Grants Pass zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-123.3333333333333 +k=1.0");
    add_proj4text (p, 1,
        "0007 +x_0=39999.99999984 +y_0=0 +ellps=GRS80 +units=ft +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Canyonville-Grants Pass ");
    add_srs_wkt (p, 1,
        "zone (ft)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Conti");
    add_srs_wkt (p, 2,
        "nuously_Operating_Reference_Station_1996\",SPHEROID[\"GR");
    add_srs_wkt (p, 3,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 4,
        "\"]],AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 7,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 8,
        "6783\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "latitude_of_origin\",42.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 10,
        ",-123.3333333333333],PARAMETER[\"scale_factor\",1.00007]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_easting\",131233.5958],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9002\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"6801\"]]");
    p = add_epsg_def_ex (filter, first, last, 6802, "epsg", 6802,
        "NAD83(2011) / Oregon Canyonville-Grants Pass zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-123.3333333333333 +k=1.0");
    add_proj4text (p, 1,
        "0007 +x_0=40000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Canyonville-Grants Pass zo");
    add_srs_wkt (p, 1,
        "ne (m)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_S");
    add_srs_wkt (p, 2,
        "patial_Reference_System_2011\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 3,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 7,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PRO");
    add_srs_wkt (p, 8,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 9,
        "_origin\",42.5],PARAMETER[\"central_meridian\",-123.3333");
    add_srs_wkt (p, 10,
        "333333333],PARAMETER[\"scale_factor\",1.00007],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_easting\",40000],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 12,
        "],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6802\"]");
    add_srs_wkt (p, 14,
        "]");
    p = add_epsg_def_ex (filter, first, last, 6803, "epsg", 6803,
        "NAD83(2011) / Oregon Canyonville-Grants Pass zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.5 +lon_0=-123.3333333333333 +k=1.0");
    add_proj4text (p, 1,
        "0007 +x_0=39999.99999984 +y_0=0 +ellps=GRS80 +units=ft +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Canyonville-Grants Pass zo");
    add_srs_wkt (p, 1,
        "ne (ft)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_");
    add_srs_wkt (p, 2,
        "Spatial_Reference_System_2011\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 3,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 7,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",42.5],PARAMETER[\"central_meridian\",-123.333");
    add_srs_wkt (p, 10,
        "3333333333],PARAMETER[\"scale_factor\",1.00007],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"false_easting\",131233.5958],PARAMETER[\"false_north");
    add_srs_wkt (p, 12,
        "ing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"6803\"]]");
    p = add_epsg_def_ex (filter, first, last, 6804, "epsg", 6804,
        "NAD83(CORS96) / Oregon Columbia River East zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.66666666666666 +lat_0=45.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-120.5 +k_0=1.000008 +x_0=150000 +y_0=30000 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Columbia River East zone");
    add_srs_wkt (p, 1,
        " (m)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuous");
    add_srs_wkt (p, 2,
        "ly_Operating_Reference_Station_1996\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NO");
    add_srs_wkt (p, 7,
        "RTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"latitude_of_origin\",45.66666666666666],PARAMETER[\"c");
    add_srs_wkt (p, 10,
        "entral_meridian\",-120.5],PARAMETER[\"scale_factor\",1.0");
    add_srs_wkt (p, 11,
        "00008],PARAMETER[\"false_easting\",150000],PARAMETER[\"f");
    add_srs_wkt (p, 12,
        "alse_northing\",30000],UNIT[\"metre\",1,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 13,
        "\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"6804\"]]");
    p = add_epsg_def_ex (filter, first, last, 6805, "epsg", 6805,
        "NAD83(CORS96) / Oregon Columbia River East zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Lambert_Conformal_Conic_1SP", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.66666666666666 +lat_0=45.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-120.5 +k_0=1.000008 +x_0=150000.00001464 +y_");
    add_proj4text (p, 2,
        "0=30000.00001512 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Columbia River East zone");
    add_srs_wkt (p, 1,
        " (ft)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuou");
    add_srs_wkt (p, 2,
        "sly_Operating_Reference_Station_1996\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 7,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783");
    add_srs_wkt (p, 8,
        "\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP\"],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"latitude_of_origin\",45.66666666666666],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "central_meridian\",-120.5],PARAMETER[\"scale_factor\",1.");
    add_srs_wkt (p, 11,
        "000008],PARAMETER[\"false_easting\",492125.9843],PARAMET");
    add_srs_wkt (p, 12,
        "ER[\"false_northing\",98425.1969],UNIT[\"foot\",0.3048,A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"9002\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"6805\"]]");
    p = add_epsg_def_ex (filter, first, last, 6806, "epsg", 6806,
        "NAD83(2011) / Oregon Columbia River East zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.66666666666666 +lat_0=45.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-120.5 +k_0=1.000008 +x_0=150000 +y_0=30000 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Columbia River East zone (");
    add_srs_wkt (p, 1,
        "m)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spati");
    add_srs_wkt (p, 2,
        "al_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_origin\",45.66666666666666],PARAMETER[\"central_meri");
    add_srs_wkt (p, 10,
        "dian\",-120.5],PARAMETER[\"scale_factor\",1.000008],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_easting\",150000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 12,
        "ng\",30000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 13,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 14,
        ",\"6806\"]]");
    p = add_epsg_def_ex (filter, first, last, 6807, "epsg", 6807,
        "NAD83(2011) / Oregon Columbia River East zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Lambert_Conformal_Conic_1SP", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.66666666666666 +lat_0=45.66666666666");
    add_proj4text (p, 1,
        "666 +lon_0=-120.5 +k_0=1.000008 +x_0=150000.00001464 +y_");
    add_proj4text (p, 2,
        "0=30000.00001512 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Columbia River East zone (");
    add_srs_wkt (p, 1,
        "ft)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spat");
    add_srs_wkt (p, 2,
        "ial_Reference_System_2011\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 3,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Lambert_Conformal_Conic_1SP\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 9,
        "de_of_origin\",45.66666666666666],PARAMETER[\"central_me");
    add_srs_wkt (p, 10,
        "ridian\",-120.5],PARAMETER[\"scale_factor\",1.000008],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",492125.9843],PARAMETER[\"false");
    add_srs_wkt (p, 12,
        "_northing\",98425.1969],UNIT[\"foot\",0.3048,AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"9002\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 14,
        "HORITY[\"EPSG\",\"6807\"]]");
    p = add_epsg_def_ex (filter, first, last, 6808, "epsg", 6808,
        "NAD83(CORS96) / Oregon Columbia River West zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Hotine_Oblique_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=45.91666666666666 +lonc=-123 +alpha=2");
    add_proj4text (p, 1,
        "95 +k=1 +x_0=7000000 +y_0=-3000000 +no_uoff +gamma=295 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Columbia River West zone");
    add_srs_wkt (p, 1,
        " (m)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuous");
    add_srs_wkt (p, 2,
        "ly_Operating_Reference_Station_1996\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NO");
    add_srs_wkt (p, 7,
        "RTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Hotine_Oblique_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_center\",45.91666666666666],PARAMETER[\"longi");
    add_srs_wkt (p, 10,
        "tude_of_center\",-123],PARAMETER[\"azimuth\",295],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"rectified_grid_angle\",295],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 12,
        "or\",1],PARAMETER[\"false_easting\",7000000],PARAMETER[\"");
    add_srs_wkt (p, 13,
        "false_northing\",-3000000],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"6808\"]]");
    p = add_epsg_def_ex (filter, first, last, 6809, "epsg", 6809,
        "NAD83(CORS96) / Oregon Columbia River West zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Hotine_Oblique_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=45.91666666666666 +lonc=-123 +alpha=2");
    add_proj4text (p, 1,
        "95 +k=1 +x_0=7000000.00000248 +y_0=-2999999.999988 +no_u");
    add_proj4text (p, 2,
        "off +gamma=295 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Columbia River West zone");
    add_srs_wkt (p, 1,
        " (ft)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuou");
    add_srs_wkt (p, 2,
        "sly_Operating_Reference_Station_1996\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 7,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783");
    add_srs_wkt (p, 8,
        "\"]],PROJECTION[\"Hotine_Oblique_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "latitude_of_center\",45.91666666666666],PARAMETER[\"long");
    add_srs_wkt (p, 10,
        "itude_of_center\",-123],PARAMETER[\"azimuth\",295],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"rectified_grid_angle\",295],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 12,
        "tor\",1],PARAMETER[\"false_easting\",22965879.2651],PARA");
    add_srs_wkt (p, 13,
        "METER[\"false_northing\",-9842519.685],UNIT[\"foot\",0.3");
    add_srs_wkt (p, 14,
        "048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"X\",EAST],AXIS[");
    add_srs_wkt (p, 15,
        "\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6809\"]]");
    p = add_epsg_def_ex (filter, first, last, 6810, "epsg", 6810,
        "NAD83(2011) / Oregon Columbia River West zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Hotine_Oblique_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=45.91666666666666 +lonc=-123 +alpha=2");
    add_proj4text (p, 1,
        "95 +k=1 +x_0=7000000 +y_0=-3000000 +no_uoff +gamma=295 +");
    add_proj4text (p, 2,
        "ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Columbia River West zone (");
    add_srs_wkt (p, 1,
        "m)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spati");
    add_srs_wkt (p, 2,
        "al_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Hotine_Oblique_Mercator\"],PARAMETER[\"latitude_of_");
    add_srs_wkt (p, 9,
        "center\",45.91666666666666],PARAMETER[\"longitude_of_cen");
    add_srs_wkt (p, 10,
        "ter\",-123],PARAMETER[\"azimuth\",295],PARAMETER[\"recti");
    add_srs_wkt (p, 11,
        "fied_grid_angle\",295],PARAMETER[\"scale_factor\",1],PAR");
    add_srs_wkt (p, 12,
        "AMETER[\"false_easting\",7000000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 13,
        "hing\",-3000000],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 14,
        "001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 15,
        "PSG\",\"6810\"]]");
    p = add_epsg_def_ex (filter, first, last, 6811, "epsg", 6811,
        "NAD83(2011) / Oregon Columbia River West zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Hotine_Oblique_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=45.91666666666666 +lonc=-123 +alpha=2");
    add_proj4text (p, 1,
        "95 +k=1 +x_0=7000000.00000248 +y_0=-2999999.999988 +no_u");
    add_proj4text (p, 2,
        "off +gamma=295 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Columbia River West zone (");
    add_srs_wkt (p, 1,
        "ft)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spat");
    add_srs_wkt (p, 2,
        "ial_Reference_System_2011\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 3,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Hotine_Oblique_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_center\",45.91666666666666],PARAMETER[\"longitude_of_c");
    add_srs_wkt (p, 10,
        "enter\",-123],PARAMETER[\"azimuth\",295],PARAMETER[\"rec");
    add_srs_wkt (p, 11,
        "tified_grid_angle\",295],PARAMETER[\"scale_factor\",1],P");
    add_srs_wkt (p, 12,
        "ARAMETER[\"false_easting\",22965879.2651],PARAMETER[\"fa");
    add_srs_wkt (p, 13,
        "lse_northing\",-9842519.685],UNIT[\"foot\",0.3048,AUTHOR");
    add_srs_wkt (p, 14,
        "ITY[\"EPSG\",\"9002\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 15,
        "H],AUTHORITY[\"EPSG\",\"6811\"]]");
    p = add_epsg_def_ex (filter, first, last, 6812, "epsg", 6812,
        "NAD83(CORS96) / Oregon Cottage Grove-Canyonville zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-123.3333333");
    add_proj4text (p, 1,
        "333333 +k=1.000023 +x_0=50000 +y_0=0 +ellps=GRS80 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Cottage Grove-Canyonvill");
    add_srs_wkt (p, 1,
        "e zone (m)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Cont");
    add_srs_wkt (p, 2,
        "inuously_Operating_Reference_Station_1996\",SPHEROID[\"G");
    add_srs_wkt (p, 3,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 4,
        "9\"]],AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 7,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 8,
        "6783\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "latitude_of_origin\",42.83333333333334],PARAMETER[\"cent");
    add_srs_wkt (p, 10,
        "ral_meridian\",-123.3333333333333],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 11,
        "tor\",1.000023],PARAMETER[\"false_easting\",50000],PARAM");
    add_srs_wkt (p, 12,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 13,
        "EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 14,
        "HORITY[\"EPSG\",\"6812\"]]");
    p = add_epsg_def_ex (filter, first, last, 6813, "epsg", 6813,
        "NAD83(CORS96) / Oregon Cottage Grove-Canyonville zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-123.3333333");
    add_proj4text (p, 1,
        "333333 +k=1.000023 +x_0=50000.00001504 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Cottage Grove-Canyonvill");
    add_srs_wkt (p, 1,
        "e zone (ft)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Con");
    add_srs_wkt (p, 2,
        "tinuously_Operating_Reference_Station_1996\",SPHEROID[\"");
    add_srs_wkt (p, 3,
        "GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 4,
        "19\"]],AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 7,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 8,
        "6783\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "latitude_of_origin\",42.83333333333334],PARAMETER[\"cent");
    add_srs_wkt (p, 10,
        "ral_meridian\",-123.3333333333333],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 11,
        "tor\",1.000023],PARAMETER[\"false_easting\",164041.9948]");
    add_srs_wkt (p, 12,
        ",PARAMETER[\"false_northing\",0],UNIT[\"foot\",0.3048,AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"9002\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 14,
        "NORTH],AUTHORITY[\"EPSG\",\"6813\"]]");
    p = add_epsg_def_ex (filter, first, last, 6814, "epsg", 6814,
        "NAD83(2011) / Oregon Cottage Grove-Canyonville zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-123.3333333");
    add_proj4text (p, 1,
        "333333 +k=1.000023 +x_0=50000 +y_0=0 +ellps=GRS80 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Cottage Grove-Canyonville ");
    add_srs_wkt (p, 1,
        "zone (m)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National");
    add_srs_wkt (p, 2,
        "_Spatial_Reference_System_2011\",SPHEROID[\"GRS 1980\",6");
    add_srs_wkt (p, 3,
        "378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",42.83333333333334],PARAMETER[\"central_merid");
    add_srs_wkt (p, 10,
        "ian\",-123.3333333333333],PARAMETER[\"scale_factor\",1.0");
    add_srs_wkt (p, 11,
        "00023],PARAMETER[\"false_easting\",50000],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"6814\"]]");
    p = add_epsg_def_ex (filter, first, last, 6815, "epsg", 6815,
        "NAD83(2011) / Oregon Cottage Grove-Canyonville zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-123.3333333");
    add_proj4text (p, 1,
        "333333 +k=1.000023 +x_0=50000.00001504 +y_0=0 +ellps=GRS");
    add_proj4text (p, 2,
        "80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Cottage Grove-Canyonville ");
    add_srs_wkt (p, 1,
        "zone (ft)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_Nationa");
    add_srs_wkt (p, 2,
        "l_Spatial_Reference_System_2011\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 3,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 7,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],");
    add_srs_wkt (p, 8,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 9,
        "_of_origin\",42.83333333333334],PARAMETER[\"central_meri");
    add_srs_wkt (p, 10,
        "dian\",-123.3333333333333],PARAMETER[\"scale_factor\",1.");
    add_srs_wkt (p, 11,
        "000023],PARAMETER[\"false_easting\",164041.9948],PARAMET");
    add_srs_wkt (p, 12,
        "ER[\"false_northing\",0],UNIT[\"foot\",0.3048,AUTHORITY[");
    add_srs_wkt (p, 13,
        "\"EPSG\",\"9002\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"6815\"]]");
    p = add_epsg_def_ex (filter, first, last, 6816, "epsg", 6816,
        "NAD83(CORS96) / Oregon Dufur-Madras zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.5 +lon_0=-121 +k=1.00011 +x_0=8000");
    add_proj4text (p, 1,
        "0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Dufur-Madras zone (m)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Oper");
    add_srs_wkt (p, 2,
        "ating_Reference_Station_1996\",SPHEROID[\"GRS 1980\",637");
    add_srs_wkt (p, 3,
        "8137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 6,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 7,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PRO");
    add_srs_wkt (p, 8,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 9,
        "_origin\",44.5],PARAMETER[\"central_meridian\",-121],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",1.00011],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",80000],PARAMETER[\"false_northing\",0],UNIT[\"metre");
    add_srs_wkt (p, 12,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 13,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6816\"]]");
    p = add_epsg_def_ex (filter, first, last, 6817, "epsg", 6817,
        "NAD83(CORS96) / Oregon Dufur-Madras zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.5 +lon_0=-121 +k=1.00011 +x_0=7999");
    add_proj4text (p, 1,
        "9.99999968 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Dufur-Madras zone (ft)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Ope");
    add_srs_wkt (p, 2,
        "rating_Reference_Station_1996\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 3,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 7,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 9,
        "f_origin\",44.5],PARAMETER[\"central_meridian\",-121],PA");
    add_srs_wkt (p, 10,
        "RAMETER[\"scale_factor\",1.00011],PARAMETER[\"false_east");
    add_srs_wkt (p, 11,
        "ing\",262467.1916],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 12,
        "\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6817\"]]");
    p = add_epsg_def_ex (filter, first, last, 6818, "epsg", 6818,
        "NAD83(2011) / Oregon Dufur-Madras zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.5 +lon_0=-121 +k=1.00011 +x_0=8000");
    add_proj4text (p, 1,
        "0 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Dufur-Madras zone (m)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Refe");
    add_srs_wkt (p, 2,
        "rence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",4");
    add_srs_wkt (p, 9,
        "4.5],PARAMETER[\"central_meridian\",-121],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1.00011],PARAMETER[\"false_easting\",80000]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"6818\"]]");
    p = add_epsg_def_ex (filter, first, last, 6819, "epsg", 6819,
        "NAD83(2011) / Oregon Dufur-Madras zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=44.5 +lon_0=-121 +k=1.00011 +x_0=7999");
    add_proj4text (p, 1,
        "9.99999968 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Dufur-Madras zone (ft)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Ref");
    add_srs_wkt (p, 2,
        "erence_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2");
    add_srs_wkt (p, 3,
        "57222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",4");
    add_srs_wkt (p, 9,
        "4.5],PARAMETER[\"central_meridian\",-121],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1.00011],PARAMETER[\"false_easting\",262467");
    add_srs_wkt (p, 11,
        ".1916],PARAMETER[\"false_northing\",0],UNIT[\"foot\",0.3");
    add_srs_wkt (p, 12,
        "048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"X\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6819\"]]");
    p = add_epsg_def_ex (filter, first, last, 6820, "epsg", 6820,
        "NAD83(CORS96) / Oregon Eugene zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.75 +lon_0=-123.1666666666667 +k=1.");
    add_proj4text (p, 1,
        "000015 +x_0=50000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Eugene zone (m)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operating_");
    add_srs_wkt (p, 2,
        "Reference_Station_1996\",SPHEROID[\"GRS 1980\",6378137,2");
    add_srs_wkt (p, 3,
        "98.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",43.75],PARAMETER[\"central_meridian\",-123.166666666");
    add_srs_wkt (p, 10,
        "6667],PARAMETER[\"scale_factor\",1.000015],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_easting\",50000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 12,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",");
    add_srs_wkt (p, 13,
        "EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6820\"]]");
    p = add_epsg_def_ex (filter, first, last, 6821, "epsg", 6821,
        "NAD83(CORS96) / Oregon Eugene zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.75 +lon_0=-123.1666666666667 +k=1.");
    add_proj4text (p, 1,
        "000015 +x_0=50000.00001504 +y_0=0 +ellps=GRS80 +units=ft");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Eugene zone (ft)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operating");
    add_srs_wkt (p, 2,
        "_Reference_Station_1996\",SPHEROID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 3,
        "298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",43.75],PARAMETER[\"central_meridian\",-123.16666666");
    add_srs_wkt (p, 10,
        "66667],PARAMETER[\"scale_factor\",1.000015],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",164041.9948],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 14,
        "821\"]]");
    p = add_epsg_def_ex (filter, first, last, 6822, "epsg", 6822,
        "NAD83(2011) / Oregon Eugene zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.75 +lon_0=-123.1666666666667 +k=1.");
    add_proj4text (p, 1,
        "000015 +x_0=50000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Eugene zone (m)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference_S");
    add_srs_wkt (p, 2,
        "ystem_2011\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"1116");
    add_srs_wkt (p, 4,
        "\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]");
    add_srs_wkt (p, 5,
        "],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",E");
    add_srs_wkt (p, 7,
        "AST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transver");
    add_srs_wkt (p, 8,
        "se_Mercator\"],PARAMETER[\"latitude_of_origin\",43.75],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"central_meridian\",-123.1666666666667],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"scale_factor\",1.000015],PARAMETER[\"false_easting");
    add_srs_wkt (p, 11,
        "\",50000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 12,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"6822\"]]");
    p = add_epsg_def_ex (filter, first, last, 6823, "epsg", 6823,
        "NAD83(2011) / Oregon Eugene zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.75 +lon_0=-123.1666666666667 +k=1.");
    add_proj4text (p, 1,
        "000015 +x_0=50000.00001504 +y_0=0 +ellps=GRS80 +units=ft");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Eugene zone (ft)\",GEOGCS[");
    add_srs_wkt (p, 1,
        "\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"11");
    add_srs_wkt (p, 4,
        "16\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",43.75],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",-123.1666666666667],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"scale_factor\",1.000015],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",164041.9948],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 12,
        "foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6823\"]]");
    p = add_epsg_def_ex (filter, first, last, 6824, "epsg", 6824,
        "NAD83(CORS96) / Oregon Grants Pass-Ashland zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.75 +lon_0=-123.3333333333333 +k=1.");
    add_proj4text (p, 1,
        "000043 +x_0=50000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Grants Pass-Ashland zone");
    add_srs_wkt (p, 1,
        " (m)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuous");
    add_srs_wkt (p, 2,
        "ly_Operating_Reference_Station_1996\",SPHEROID[\"GRS 198");
    add_srs_wkt (p, 3,
        "0\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NO");
    add_srs_wkt (p, 7,
        "RTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",41.75],PARAMETER[\"central_meridian\",-1");
    add_srs_wkt (p, 10,
        "23.3333333333333],PARAMETER[\"scale_factor\",1.000043],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_easting\",50000],PARAMETER[\"false_nort");
    add_srs_wkt (p, 12,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 13,
        ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "6824\"]]");
    p = add_epsg_def_ex (filter, first, last, 6825, "epsg", 6825,
        "NAD83(CORS96) / Oregon Grants Pass-Ashland zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.75 +lon_0=-123.3333333333333 +k=1.");
    add_proj4text (p, 1,
        "000043 +x_0=50000.00001504 +y_0=0 +ellps=GRS80 +units=ft");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Grants Pass-Ashland zone");
    add_srs_wkt (p, 1,
        " (ft)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuou");
    add_srs_wkt (p, 2,
        "sly_Operating_Reference_Station_1996\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 7,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783");
    add_srs_wkt (p, 8,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 9,
        "itude_of_origin\",41.75],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 10,
        "-123.3333333333333],PARAMETER[\"scale_factor\",1.000043]");
    add_srs_wkt (p, 11,
        ",PARAMETER[\"false_easting\",164041.9948],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 13,
        ",\"9002\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY");
    add_srs_wkt (p, 14,
        "[\"EPSG\",\"6825\"]]");
    p = add_epsg_def_ex (filter, first, last, 6826, "epsg", 6826,
        "NAD83(2011) / Oregon Grants Pass-Ashland zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.75 +lon_0=-123.3333333333333 +k=1.");
    add_proj4text (p, 1,
        "000043 +x_0=50000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Grants Pass-Ashland zone (");
    add_srs_wkt (p, 1,
        "m)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spati");
    add_srs_wkt (p, 2,
        "al_Reference_System_2011\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"");
    add_srs_wkt (p, 7,
        "Longitude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTI");
    add_srs_wkt (p, 8,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 9,
        "in\",41.75],PARAMETER[\"central_meridian\",-123.33333333");
    add_srs_wkt (p, 10,
        "33333],PARAMETER[\"scale_factor\",1.000043],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",50000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 12,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6826\"]]");
    p = add_epsg_def_ex (filter, first, last, 6827, "epsg", 6827,
        "NAD83(2011) / Oregon Grants Pass-Ashland zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.75 +lon_0=-123.3333333333333 +k=1.");
    add_proj4text (p, 1,
        "000043 +x_0=50000.00001504 +y_0=0 +ellps=GRS80 +units=ft");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Grants Pass-Ashland zone (");
    add_srs_wkt (p, 1,
        "ft)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spat");
    add_srs_wkt (p, 2,
        "ial_Reference_System_2011\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 3,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",41.75],PARAMETER[\"central_meridian\",-123.333333");
    add_srs_wkt (p, 10,
        "3333333],PARAMETER[\"scale_factor\",1.000043],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"false_easting\",164041.9948],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]");
    add_srs_wkt (p, 13,
        "],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"6827\"]]");
    p = add_epsg_def_ex (filter, first, last, 6828, "epsg", 6828,
        "NAD83(CORS96) / Oregon Gresham-Warm Springs zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45 +lon_0=-122.3333333333333 +k=1.000");
    add_proj4text (p, 1,
        "05 +x_0=10000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Gresham-Warm Springs zon");
    add_srs_wkt (p, 1,
        "e (m)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuou");
    add_srs_wkt (p, 2,
        "sly_Operating_Reference_Station_1996\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 5,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 6,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 7,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783");
    add_srs_wkt (p, 8,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 9,
        "itude_of_origin\",45],PARAMETER[\"central_meridian\",-12");
    add_srs_wkt (p, 10,
        "2.3333333333333],PARAMETER[\"scale_factor\",1.00005],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_easting\",10000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 12,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6");
    add_srs_wkt (p, 14,
        "828\"]]");
    p = add_epsg_def_ex (filter, first, last, 6829, "epsg", 6829,
        "NAD83(CORS96) / Oregon Gresham-Warm Springs zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45 +lon_0=-122.3333333333333 +k=1.000");
    add_proj4text (p, 1,
        "05 +x_0=10000.0000152 +y_0=0 +ellps=GRS80 +units=ft +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon Gresham-Warm Springs zon");
    add_srs_wkt (p, 1,
        "e (ft)\",GEOGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuo");
    add_srs_wkt (p, 2,
        "usly_Operating_Reference_Station_1996\",SPHEROID[\"GRS 1");
    add_srs_wkt (p, 3,
        "980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 7,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"678");
    add_srs_wkt (p, 8,
        "3\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 9,
        "titude_of_origin\",45],PARAMETER[\"central_meridian\",-1");
    add_srs_wkt (p, 10,
        "22.3333333333333],PARAMETER[\"scale_factor\",1.00005],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_easting\",32808.399],PARAMETER[\"false_n");
    add_srs_wkt (p, 12,
        "orthing\",0],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 13,
        "002\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 14,
        "PSG\",\"6829\"]]");
    p = add_epsg_def_ex (filter, first, last, 6830, "epsg", 6830,
        "NAD83(2011) / Oregon Gresham-Warm Springs zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45 +lon_0=-122.3333333333333 +k=1.000");
    add_proj4text (p, 1,
        "05 +x_0=10000 +y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Gresham-Warm Springs zone ");
    add_srs_wkt (p, 1,
        "(m)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spat");
    add_srs_wkt (p, 2,
        "ial_Reference_System_2011\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 3,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",45],PARAMETER[\"central_meridian\",-122.333333333");
    add_srs_wkt (p, 10,
        "3333],PARAMETER[\"scale_factor\",1.00005],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",10000],PARAMETER[\"false_northing\",0],UNI");
    add_srs_wkt (p, 12,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",E");
    add_srs_wkt (p, 13,
        "AST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6830\"]]");
    p = add_epsg_def_ex (filter, first, last, 6831, "epsg", 6831,
        "NAD83(2011) / Oregon Gresham-Warm Springs zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45 +lon_0=-122.3333333333333 +k=1.000");
    add_proj4text (p, 1,
        "05 +x_0=10000.0000152 +y_0=0 +ellps=GRS80 +units=ft +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon Gresham-Warm Springs zone ");
    add_srs_wkt (p, 1,
        "(ft)\",GEOGCS[\"NAD83(2011)\",DATUM[\"NAD83_National_Spa");
    add_srs_wkt (p, 2,
        "tial_Reference_System_2011\",SPHEROID[\"GRS 1980\",63781");
    add_srs_wkt (p, 3,
        "37,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 7,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 9,
        "rigin\",45],PARAMETER[\"central_meridian\",-122.33333333");
    add_srs_wkt (p, 10,
        "33333],PARAMETER[\"scale_factor\",1.00005],PARAMETER[\"f");
    add_srs_wkt (p, 11,
        "alse_easting\",32808.399],PARAMETER[\"false_northing\",0");
    add_srs_wkt (p, 12,
        "],UNIT[\"foot\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXI");
    add_srs_wkt (p, 13,
        "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"683");
    add_srs_wkt (p, 14,
        "1\"]]");
    p = add_epsg_def_ex (filter, first, last, 6832, "epsg", 6832,
        "NAD83(CORS96) / Oregon La Grande zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45 +lon_0=-118 +k=1.00013 +x_0=40000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon La Grande zone (m)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operati");
    add_srs_wkt (p, 2,
        "ng_Reference_Station_1996\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 3,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 5,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[");
    add_srs_wkt (p, 7,
        "\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJEC");
    add_srs_wkt (p, 8,
        "TION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_or");
    add_srs_wkt (p, 9,
        "igin\",45],PARAMETER[\"central_meridian\",-118],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"scale_factor\",1.00013],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 11,
        "40000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 13,
        ",NORTH],AUTHORITY[\"EPSG\",\"6832\"]]");
    p = add_epsg_def_ex (filter, first, last, 6833, "epsg", 6833,
        "NAD83(CORS96) / Oregon La Grande zone (ft)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Continuously_Operating_Reference_Station_1996", "Transverse_Mercator", "foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45 +lon_0=-118 +k=1.00013 +x_0=39999.");
    add_proj4text (p, 1,
        "99999984 +y_0=0 +ellps=GRS80 +units=ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CORS96) / Oregon La Grande zone (ft)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(CORS96)\",DATUM[\"NAD83_Continuously_Operat");
    add_srs_wkt (p, 2,
        "ing_Reference_Station_1996\",SPHEROID[\"GRS 1980\",63781");
    add_srs_wkt (p, 3,
        "37,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"1133\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 7,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"6783\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_o");
    add_srs_wkt (p, 9,
        "rigin\",45],PARAMETER[\"central_meridian\",-118],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"scale_factor\",1.00013],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",131233.5958],PARAMETER[\"false_northing\",0],UNIT[\"foo");
    add_srs_wkt (p, 12,
        "t\",0.3048,AUTHORITY[\"EPSG\",\"9002\"]],AXIS[\"X\",EAST");
    add_srs_wkt (p, 13,
        "],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"6833\"]]");
    p = add_epsg_def_ex (filter, first, last, 6834, "epsg", 6834,
        "NAD83(2011) / Oregon La Grande zone (m)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2011", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=45 +lon_0=-118 +k=1.00013 +x_0=40000 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(2011) / Oregon La Grande zone (m)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"NAD83(2011)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2011\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "1116\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"6318\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",45],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"central_meridian\",-118],PARAMETER[\"scale_f");
    add_srs_wkt (p, 10,
        "actor\",1.00013],PARAMETER[\"false_easting\",40000],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 13,
        "HORITY[\"EPSG\",\"6834\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

