/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Wed Mar 21 19:30:16 2018

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_03 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 2325, "epsg", 2325,
        "ED50 / TM45", 0, 1,
        "International 1924", "Greenwich",
        "European_Datum_1950", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=intl +towgs84=-87,-98,-121,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50 / TM45\",GEOGCS[\"ED50\",DATUM[\"European_");
    add_srs_wkt (p, 1,
        "Datum_1950\",SPHEROID[\"International 1924\",6378388,297");
    add_srs_wkt (p, 2,
        ",AUTHORITY[\"EPSG\",\"7022\"]],TOWGS84[-87,-98,-121,0,0,");
    add_srs_wkt (p, 3,
        "0,0],AUTHORITY[\"EPSG\",\"6230\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 6,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4230\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",4");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 10,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 11,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 12,
        "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2325\"]]");
    p = add_epsg_def_ex (filter, first, last, 2326, "epsg", 2326,
        "Hong Kong 1980 Grid System", 0, 1,
        "International 1924", "Greenwich",
        "Hong_Kong_1980", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=22.31213333333334 +lon_0=114.17855555");
    add_proj4text (p, 1,
        "55556 +k=1 +x_0=836694.05 +y_0=819069.8 +ellps=intl +tow");
    add_proj4text (p, 2,
        "gs84=-162.619,-276.959,-161.764,0.067753,-2.243649,-1.15");
    add_proj4text (p, 3,
        "8827,-1.094246 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Hong Kong 1980 Grid System\",GEOGCS[\"Hong Kong");
    add_srs_wkt (p, 1,
        " 1980\",DATUM[\"Hong_Kong_1980\",SPHEROID[\"Internationa");
    add_srs_wkt (p, 2,
        "l 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[-162.619,-276.959,-161.764,0.067753,-2.243649,-1.1588");
    add_srs_wkt (p, 4,
        "27,-1.094246],AUTHORITY[\"EPSG\",\"6611\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 5,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 7,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 8,
        "PSG\",\"4611\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"latitude_of_origin\",22.31213333333334],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"central_meridian\",114.1785555555556],PARAMETER[\"s");
    add_srs_wkt (p, 11,
        "cale_factor\",1],PARAMETER[\"false_easting\",836694.05],");
    add_srs_wkt (p, 12,
        "PARAMETER[\"false_northing\",819069.8],UNIT[\"metre\",1,");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 14,
        "XIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2326\"]]");
    p = add_epsg_def_ex (filter, first, last, 2327, "epsg", 2327,
        "Xian 1980 / Gauss-Kruger zone 13", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=13500000 +y_0=0");
    add_proj4text (p, 1,
        " +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / Gauss-Kruger zone 13\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
        "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
        "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",75],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",13500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"2327\"]]");
    p = add_epsg_def_ex (filter, first, last, 2328, "epsg", 2328,
        "Xian 1980 / Gauss-Kruger zone 14", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=14500000 +y_0=0");
    add_proj4text (p, 1,
        " +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / Gauss-Kruger zone 14\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
        "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
        "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",81],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",14500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"2328\"]]");
    p = add_epsg_def_ex (filter, first, last, 2329, "epsg", 2329,
        "Xian 1980 / Gauss-Kruger zone 15", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=15500000 +y_0=0");
    add_proj4text (p, 1,
        " +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / Gauss-Kruger zone 15\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
        "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
        "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",87],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",15500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"2329\"]]");
    p = add_epsg_def_ex (filter, first, last, 2330, "epsg", 2330,
        "Xian 1980 / Gauss-Kruger zone 16", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=16500000 +y_0=0");
    add_proj4text (p, 1,
        " +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / Gauss-Kruger zone 16\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
        "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
        "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",93],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",16500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"2330\"]]");
    p = add_epsg_def_ex (filter, first, last, 2331, "epsg", 2331,
        "Xian 1980 / Gauss-Kruger zone 17", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=17500000 +y_0=0");
    add_proj4text (p, 1,
        " +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / Gauss-Kruger zone 17\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
        "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
        "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",99],PARAMETER[\"scale");
    add_srs_wkt (p, 9,
        "_factor\",1],PARAMETER[\"false_easting\",17500000],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"2331\"]]");
    p = add_epsg_def_ex (filter, first, last, 2332, "epsg", 2332,
        "Xian 1980 / Gauss-Kruger zone 18", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=");
    add_proj4text (p, 1,
        "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / Gauss-Kruger zone 18\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
        "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
        "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",105],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",18500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"2332\"]]");
    p = add_epsg_def_ex (filter, first, last, 2333, "epsg", 2333,
        "Xian 1980 / Gauss-Kruger zone 19", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=");
    add_proj4text (p, 1,
        "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / Gauss-Kruger zone 19\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
        "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
        "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",111],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",19500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"2333\"]]");
    p = add_epsg_def_ex (filter, first, last, 2334, "epsg", 2334,
        "Xian 1980 / Gauss-Kruger zone 20", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=20500000 +y_0=");
    add_proj4text (p, 1,
        "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / Gauss-Kruger zone 20\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
        "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
        "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",117],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",20500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"2334\"]]");
    p = add_epsg_def_ex (filter, first, last, 2335, "epsg", 2335,
        "Xian 1980 / Gauss-Kruger zone 21", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=21500000 +y_0=");
    add_proj4text (p, 1,
        "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / Gauss-Kruger zone 21\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
        "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
        "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",123],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",21500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"2335\"]]");
    p = add_epsg_def_ex (filter, first, last, 2336, "epsg", 2336,
        "Xian 1980 / Gauss-Kruger zone 22", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=22500000 +y_0=");
    add_proj4text (p, 1,
        "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / Gauss-Kruger zone 22\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
        "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
        "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",129],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",22500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"2336\"]]");
    p = add_epsg_def_ex (filter, first, last, 2337, "epsg", 2337,
        "Xian 1980 / Gauss-Kruger zone 23", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=23500000 +y_0=");
    add_proj4text (p, 1,
        "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / Gauss-Kruger zone 23\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
        "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
        "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",135],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",23500000],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"");
    add_srs_wkt (p, 11,
        "EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"2337\"]]");
    p = add_epsg_def_ex (filter, first, last, 2338, "epsg", 2338,
        "Xian 1980 / Gauss-Kruger CM 75E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / Gauss-Kruger CM 75E\",GEOGCS[\"Xian");
    add_srs_wkt (p, 1,
        " 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",637814");
    add_srs_wkt (p, 2,
        "0,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 6,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",75],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",1],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"2338\"]]");
    p = add_epsg_def_ex (filter, first, last, 2339, "epsg", 2339,
        "Xian 1980 / Gauss-Kruger CM 81E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / Gauss-Kruger CM 81E\",GEOGCS[\"Xian");
    add_srs_wkt (p, 1,
        " 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",637814");
    add_srs_wkt (p, 2,
        "0,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 6,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",81],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",1],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"2339\"]]");
    p = add_epsg_def_ex (filter, first, last, 2340, "epsg", 2340,
        "Xian 1980 / Gauss-Kruger CM 87E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / Gauss-Kruger CM 87E\",GEOGCS[\"Xian");
    add_srs_wkt (p, 1,
        " 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",637814");
    add_srs_wkt (p, 2,
        "0,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 6,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",87],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",1],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"2340\"]]");
    p = add_epsg_def_ex (filter, first, last, 2341, "epsg", 2341,
        "Xian 1980 / Gauss-Kruger CM 93E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / Gauss-Kruger CM 93E\",GEOGCS[\"Xian");
    add_srs_wkt (p, 1,
        " 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",637814");
    add_srs_wkt (p, 2,
        "0,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 6,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",93],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",1],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"2341\"]]");
    p = add_epsg_def_ex (filter, first, last, 2342, "epsg", 2342,
        "Xian 1980 / Gauss-Kruger CM 99E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / Gauss-Kruger CM 99E\",GEOGCS[\"Xian");
    add_srs_wkt (p, 1,
        " 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",637814");
    add_srs_wkt (p, 2,
        "0,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[");
    add_srs_wkt (p, 5,
        "\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Long");
    add_srs_wkt (p, 6,
        "itude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PROJECTION[\"");
    add_srs_wkt (p, 7,
        "Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 8,
        "0],PARAMETER[\"central_meridian\",99],PARAMETER[\"scale_");
    add_srs_wkt (p, 9,
        "factor\",1],PARAMETER[\"false_easting\",500000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 11,
        "G\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"2342\"]]");
    p = add_epsg_def_ex (filter, first, last, 2343, "epsg", 2343,
        "Xian 1980 / Gauss-Kruger CM 105E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / Gauss-Kruger CM 105E\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
        "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
        "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",105],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"2343\"]]");
    p = add_epsg_def_ex (filter, first, last, 2344, "epsg", 2344,
        "Xian 1980 / Gauss-Kruger CM 111E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / Gauss-Kruger CM 111E\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
        "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
        "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",111],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"2344\"]]");
    p = add_epsg_def_ex (filter, first, last, 2345, "epsg", 2345,
        "Xian 1980 / Gauss-Kruger CM 117E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / Gauss-Kruger CM 117E\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
        "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
        "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",117],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"2345\"]]");
    p = add_epsg_def_ex (filter, first, last, 2346, "epsg", 2346,
        "Xian 1980 / Gauss-Kruger CM 123E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / Gauss-Kruger CM 123E\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
        "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
        "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",123],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"2346\"]]");
    p = add_epsg_def_ex (filter, first, last, 2347, "epsg", 2347,
        "Xian 1980 / Gauss-Kruger CM 129E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / Gauss-Kruger CM 129E\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
        "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
        "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",129],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"2347\"]]");
    p = add_epsg_def_ex (filter, first, last, 2348, "epsg", 2348,
        "Xian 1980 / Gauss-Kruger CM 135E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / Gauss-Kruger CM 135E\",GEOGCS[\"Xia");
    add_srs_wkt (p, 1,
        "n 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975\",63781");
    add_srs_wkt (p, 2,
        "40,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 6,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PROJECTION[");
    add_srs_wkt (p, 7,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 8,
        ",0],PARAMETER[\"central_meridian\",135],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",1],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 11,
        "PSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTH");
    add_srs_wkt (p, 12,
        "ORITY[\"EPSG\",\"2348\"]]");
    p = add_epsg_def_ex (filter, first, last, 2349, "epsg", 2349,
        "Xian 1980 / 3-degree Gauss-Kruger zone 25", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0");
    add_proj4text (p, 1,
        " +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 25\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",75],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",25500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"2349\"]]");
    p = add_epsg_def_ex (filter, first, last, 2350, "epsg", 2350,
        "Xian 1980 / 3-degree Gauss-Kruger zone 26", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0");
    add_proj4text (p, 1,
        " +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 26\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",78],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",26500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"2350\"]]");
    p = add_epsg_def_ex (filter, first, last, 2351, "epsg", 2351,
        "Xian 1980 / 3-degree Gauss-Kruger zone 27", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0");
    add_proj4text (p, 1,
        " +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 27\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",81],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",27500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"2351\"]]");
    p = add_epsg_def_ex (filter, first, last, 2352, "epsg", 2352,
        "Xian 1980 / 3-degree Gauss-Kruger zone 28", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0");
    add_proj4text (p, 1,
        " +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 28\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",84],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",28500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"2352\"]]");
    p = add_epsg_def_ex (filter, first, last, 2353, "epsg", 2353,
        "Xian 1980 / 3-degree Gauss-Kruger zone 29", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0");
    add_proj4text (p, 1,
        " +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 29\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",87],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",29500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"2353\"]]");
    p = add_epsg_def_ex (filter, first, last, 2354, "epsg", 2354,
        "Xian 1980 / 3-degree Gauss-Kruger zone 30", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0");
    add_proj4text (p, 1,
        " +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 30\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",90],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",30500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"2354\"]]");
    p = add_epsg_def_ex (filter, first, last, 2355, "epsg", 2355,
        "Xian 1980 / 3-degree Gauss-Kruger zone 31", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0");
    add_proj4text (p, 1,
        " +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 31\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",93],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",31500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"2355\"]]");
    p = add_epsg_def_ex (filter, first, last, 2356, "epsg", 2356,
        "Xian 1980 / 3-degree Gauss-Kruger zone 32", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0");
    add_proj4text (p, 1,
        " +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 32\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",96],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",32500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"2356\"]]");
    p = add_epsg_def_ex (filter, first, last, 2357, "epsg", 2357,
        "Xian 1980 / 3-degree Gauss-Kruger zone 33", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0");
    add_proj4text (p, 1,
        " +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 33\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",99],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",1],PARAMETER[\"false_easting\",33500");
    add_srs_wkt (p, 10,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AU");
    add_srs_wkt (p, 11,
        "THORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"2357\"]]");
    p = add_epsg_def_ex (filter, first, last, 2358, "epsg", 2358,
        "Xian 1980 / 3-degree Gauss-Kruger zone 34", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=");
    add_proj4text (p, 1,
        "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 34\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",102],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",3450");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"2358\"]]");
    p = add_epsg_def_ex (filter, first, last, 2359, "epsg", 2359,
        "Xian 1980 / 3-degree Gauss-Kruger zone 35", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=");
    add_proj4text (p, 1,
        "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 35\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",105],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",3550");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"2359\"]]");
    p = add_epsg_def_ex (filter, first, last, 2360, "epsg", 2360,
        "Xian 1980 / 3-degree Gauss-Kruger zone 36", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=");
    add_proj4text (p, 1,
        "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 36\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",108],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",3650");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"2360\"]]");
    p = add_epsg_def_ex (filter, first, last, 2361, "epsg", 2361,
        "Xian 1980 / 3-degree Gauss-Kruger zone 37", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=");
    add_proj4text (p, 1,
        "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 37\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",111],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",3750");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"2361\"]]");
    p = add_epsg_def_ex (filter, first, last, 2362, "epsg", 2362,
        "Xian 1980 / 3-degree Gauss-Kruger zone 38", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=");
    add_proj4text (p, 1,
        "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 38\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",114],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",3850");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"2362\"]]");
    p = add_epsg_def_ex (filter, first, last, 2363, "epsg", 2363,
        "Xian 1980 / 3-degree Gauss-Kruger zone 39", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=");
    add_proj4text (p, 1,
        "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 39\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",117],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",3950");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"2363\"]]");
    p = add_epsg_def_ex (filter, first, last, 2364, "epsg", 2364,
        "Xian 1980 / 3-degree Gauss-Kruger zone 40", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=");
    add_proj4text (p, 1,
        "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 40\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",120],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",4050");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"2364\"]]");
    p = add_epsg_def_ex (filter, first, last, 2365, "epsg", 2365,
        "Xian 1980 / 3-degree Gauss-Kruger zone 41", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=");
    add_proj4text (p, 1,
        "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 41\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",123],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",4150");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"2365\"]]");
    p = add_epsg_def_ex (filter, first, last, 2366, "epsg", 2366,
        "Xian 1980 / 3-degree Gauss-Kruger zone 42", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=");
    add_proj4text (p, 1,
        "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 42\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",126],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",4250");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"2366\"]]");
    p = add_epsg_def_ex (filter, first, last, 2367, "epsg", 2367,
        "Xian 1980 / 3-degree Gauss-Kruger zone 43", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=");
    add_proj4text (p, 1,
        "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 43\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",129],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",4350");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"2367\"]]");
    p = add_epsg_def_ex (filter, first, last, 2368, "epsg", 2368,
        "Xian 1980 / 3-degree Gauss-Kruger zone 44", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=");
    add_proj4text (p, 1,
        "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 44\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",132],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",4450");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"2368\"]]");
    p = add_epsg_def_ex (filter, first, last, 2369, "epsg", 2369,
        "Xian 1980 / 3-degree Gauss-Kruger zone 45", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=");
    add_proj4text (p, 1,
        "0 +a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger zone 45\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",135],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",4550");
    add_srs_wkt (p, 10,
        "0000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,A");
    add_srs_wkt (p, 11,
        "UTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\"");
    add_srs_wkt (p, 12,
        ",EAST],AUTHORITY[\"EPSG\",\"2369\"]]");
    p = add_epsg_def_ex (filter, first, last, 2370, "epsg", 2370,
        "Xian 1980 / 3-degree Gauss-Kruger CM 75E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 75E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975");
    add_srs_wkt (p, 2,
        "\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 6,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",75],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"2370\"]]");
    p = add_epsg_def_ex (filter, first, last, 2371, "epsg", 2371,
        "Xian 1980 / 3-degree Gauss-Kruger CM 78E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 78E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975");
    add_srs_wkt (p, 2,
        "\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 6,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",78],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"2371\"]]");
    p = add_epsg_def_ex (filter, first, last, 2372, "epsg", 2372,
        "Xian 1980 / 3-degree Gauss-Kruger CM 81E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 81E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975");
    add_srs_wkt (p, 2,
        "\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 6,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",81],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"2372\"]]");
    p = add_epsg_def_ex (filter, first, last, 2373, "epsg", 2373,
        "Xian 1980 / 3-degree Gauss-Kruger CM 84E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 84E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975");
    add_srs_wkt (p, 2,
        "\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 6,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",84],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"2373\"]]");
    p = add_epsg_def_ex (filter, first, last, 2374, "epsg", 2374,
        "Xian 1980 / 3-degree Gauss-Kruger CM 87E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 87E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975");
    add_srs_wkt (p, 2,
        "\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 6,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",87],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"2374\"]]");
    p = add_epsg_def_ex (filter, first, last, 2375, "epsg", 2375,
        "Xian 1980 / 3-degree Gauss-Kruger CM 90E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 90E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975");
    add_srs_wkt (p, 2,
        "\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 6,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",90],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"2375\"]]");
    p = add_epsg_def_ex (filter, first, last, 2376, "epsg", 2376,
        "Xian 1980 / 3-degree Gauss-Kruger CM 93E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 93E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975");
    add_srs_wkt (p, 2,
        "\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 6,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",93],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"2376\"]]");
    p = add_epsg_def_ex (filter, first, last, 2377, "epsg", 2377,
        "Xian 1980 / 3-degree Gauss-Kruger CM 96E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 96E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975");
    add_srs_wkt (p, 2,
        "\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 6,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",96],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"2377\"]]");
    p = add_epsg_def_ex (filter, first, last, 2378, "epsg", 2378,
        "Xian 1980 / 3-degree Gauss-Kruger CM 99E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 99E\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 1975");
    add_srs_wkt (p, 2,
        "\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AX");
    add_srs_wkt (p, 6,
        "IS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PRO");
    add_srs_wkt (p, 7,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 8,
        "_origin\",0],PARAMETER[\"central_meridian\",99],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"scale_factor\",1],PARAMETER[\"false_easting\",500000");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 11,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EA");
    add_srs_wkt (p, 12,
        "ST],AUTHORITY[\"EPSG\",\"2378\"]]");
    p = add_epsg_def_ex (filter, first, last, 2379, "epsg", 2379,
        "Xian 1980 / 3-degree Gauss-Kruger CM 102E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 102E\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",102],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"2379\"]]");
    p = add_epsg_def_ex (filter, first, last, 2380, "epsg", 2380,
        "Xian 1980 / 3-degree Gauss-Kruger CM 105E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 105E\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",105],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"2380\"]]");
    p = add_epsg_def_ex (filter, first, last, 2381, "epsg", 2381,
        "Xian 1980 / 3-degree Gauss-Kruger CM 108E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 108E\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",108],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"2381\"]]");
    p = add_epsg_def_ex (filter, first, last, 2382, "epsg", 2382,
        "Xian 1980 / 3-degree Gauss-Kruger CM 111E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 111E\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",111],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"2382\"]]");
    p = add_epsg_def_ex (filter, first, last, 2383, "epsg", 2383,
        "Xian 1980 / 3-degree Gauss-Kruger CM 114E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 114E\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",114],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"2383\"]]");
    p = add_epsg_def_ex (filter, first, last, 2384, "epsg", 2384,
        "Xian 1980 / 3-degree Gauss-Kruger CM 117E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 117E\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",117],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"2384\"]]");
    p = add_epsg_def_ex (filter, first, last, 2385, "epsg", 2385,
        "Xian 1980 / 3-degree Gauss-Kruger CM 120E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 120E\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",120],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"2385\"]]");
    p = add_epsg_def_ex (filter, first, last, 2386, "epsg", 2386,
        "Xian 1980 / 3-degree Gauss-Kruger CM 123E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 123E\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",123],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"2386\"]]");
    p = add_epsg_def_ex (filter, first, last, 2387, "epsg", 2387,
        "Xian 1980 / 3-degree Gauss-Kruger CM 126E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 126E\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",126],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"2387\"]]");
    p = add_epsg_def_ex (filter, first, last, 2388, "epsg", 2388,
        "Xian 1980 / 3-degree Gauss-Kruger CM 129E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 129E\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",129],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"2388\"]]");
    p = add_epsg_def_ex (filter, first, last, 2389, "epsg", 2389,
        "Xian 1980 / 3-degree Gauss-Kruger CM 132E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 132E\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",132],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"2389\"]]");
    p = add_epsg_def_ex (filter, first, last, 2390, "epsg", 2390,
        "Xian 1980 / 3-degree Gauss-Kruger CM 135E", 0, 1,
        "IAG 1975", "Greenwich",
        "Xian_1980", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+a=6378140 +b=6356755.288157528 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Xian 1980 / 3-degree Gauss-Kruger CM 135E\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"Xian 1980\",DATUM[\"Xian_1980\",SPHEROID[\"IAG 197");
    add_srs_wkt (p, 2,
        "5\",6378140,298.257,AUTHORITY[\"EPSG\",\"7049\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6610\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 6,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4610\"]],PR");
    add_srs_wkt (p, 7,
        "OJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_o");
    add_srs_wkt (p, 8,
        "f_origin\",0],PARAMETER[\"central_meridian\",135],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"scale_factor\",1],PARAMETER[\"false_easting\",5000");
    add_srs_wkt (p, 10,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 11,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",");
    add_srs_wkt (p, 12,
        "EAST],AUTHORITY[\"EPSG\",\"2390\"]]");
    p = add_epsg_def_ex (filter, first, last, 2391, "epsg", 2391,
        "KKJ / Finland zone 1", 0, 1,
        "International 1924", "Greenwich",
        "Kartastokoordinaattijarjestelma_1966", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=1500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.34");
    add_proj4text (p, 2,
        "5,-1.376,1.496 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"KKJ / Finland zone 1\",GEOGCS[\"KKJ\",DATUM[\"K");
    add_srs_wkt (p, 1,
        "artastokoordinaattijarjestelma_1966\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.49");
    add_srs_wkt (p, 4,
        "6],AUTHORITY[\"EPSG\",\"6123\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 8,
        "23\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",21");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",1500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 12,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 13,
        "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2391\"]]");
    p = add_epsg_def_ex (filter, first, last, 2392, "epsg", 2392,
        "KKJ / Finland zone 2", 0, 1,
        "International 1924", "Greenwich",
        "Kartastokoordinaattijarjestelma_1966", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=2500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.34");
    add_proj4text (p, 2,
        "5,-1.376,1.496 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"KKJ / Finland zone 2\",GEOGCS[\"KKJ\",DATUM[\"K");
    add_srs_wkt (p, 1,
        "artastokoordinaattijarjestelma_1966\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.49");
    add_srs_wkt (p, 4,
        "6],AUTHORITY[\"EPSG\",\"6123\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 8,
        "23\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",24");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",2500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 12,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 13,
        "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2392\"]]");
    p = add_epsg_def_ex (filter, first, last, 2393, "epsg", 2393,
        "KKJ / Finland Uniform Coordinate System", 0, 1,
        "International 1924", "Greenwich",
        "Kartastokoordinaattijarjestelma_1966", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=3500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.34");
    add_proj4text (p, 2,
        "5,-1.376,1.496 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"KKJ / Finland Uniform Coordinate System\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"KKJ\",DATUM[\"Kartastokoordinaattijarjestelma_1966\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"International 1924\",6378388,297,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7022\"]],TOWGS84[-96.062,-82.428,-121.753,4.801");
    add_srs_wkt (p, 4,
        ",0.345,-1.376,1.496],AUTHORITY[\"EPSG\",\"6123\"]],PRIME");
    add_srs_wkt (p, 5,
        "M[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"d");
    add_srs_wkt (p, 6,
        "egree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]]");
    add_srs_wkt (p, 7,
        ",AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHO");
    add_srs_wkt (p, 8,
        "RITY[\"EPSG\",\"4123\"]],PROJECTION[\"Transverse_Mercato");
    add_srs_wkt (p, 9,
        "r\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cen");
    add_srs_wkt (p, 10,
        "tral_meridian\",27],PARAMETER[\"scale_factor\",1],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_easting\",3500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 12,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"23");
    add_srs_wkt (p, 14,
        "93\"]]");
    p = add_epsg_def_ex (filter, first, last, 2394, "epsg", 2394,
        "KKJ / Finland zone 4", 0, 1,
        "International 1924", "Greenwich",
        "Kartastokoordinaattijarjestelma_1966", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=intl +towgs84=-96.062,-82.428,-121.753,4.801,0.34");
    add_proj4text (p, 2,
        "5,-1.376,1.496 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"KKJ / Finland zone 4\",GEOGCS[\"KKJ\",DATUM[\"K");
    add_srs_wkt (p, 1,
        "artastokoordinaattijarjestelma_1966\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "TOWGS84[-96.062,-82.428,-121.753,4.801,0.345,-1.376,1.49");
    add_srs_wkt (p, 4,
        "6],AUTHORITY[\"EPSG\",\"6123\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 6,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 7,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"41");
    add_srs_wkt (p, 8,
        "23\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 9,
        "atitude_of_origin\",0],PARAMETER[\"central_meridian\",30");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 11,
        "g\",4500000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 12,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AX");
    add_srs_wkt (p, 13,
        "IS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2394\"]]");
    p = add_epsg_def_ex (filter, first, last, 2395, "epsg", 2395,
        "South Yemen / Gauss-Kruger zone 8", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "South_Yemen", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=8500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=-76,-138,67,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"South Yemen / Gauss-Kruger zone 8\",GEOGCS[\"So");
    add_srs_wkt (p, 1,
        "uth Yemen\",DATUM[\"South_Yemen\",SPHEROID[\"Krassowsky ");
    add_srs_wkt (p, 2,
        "1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[-76,-138,67,0,0,0,0],AUTHORITY[\"EPSG\",\"6164\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4164\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",45],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",8500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "2395\"]]");
    p = add_epsg_def_ex (filter, first, last, 2396, "epsg", 2396,
        "South Yemen / Gauss-Kruger zone 9", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "South_Yemen", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=9500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=-76,-138,67,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"South Yemen / Gauss-Kruger zone 9\",GEOGCS[\"So");
    add_srs_wkt (p, 1,
        "uth Yemen\",DATUM[\"South_Yemen\",SPHEROID[\"Krassowsky ");
    add_srs_wkt (p, 2,
        "1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],TOWGS");
    add_srs_wkt (p, 3,
        "84[-76,-138,67,0,0,0,0],AUTHORITY[\"EPSG\",\"6164\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4164\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 8,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 9,
        "entral_meridian\",51],PARAMETER[\"scale_factor\",1],PARA");
    add_srs_wkt (p, 10,
        "METER[\"false_easting\",9500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 11,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 12,
        "AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "2396\"]]");
    p = add_epsg_def_ex (filter, first, last, 2397, "epsg", 2397,
        "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 3", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_83", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=24.9,-126.4,-93.2,-0.063,-0.247,-0.");
    add_proj4text (p, 2,
        "041,1.01 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 3");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_1942_83\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7024\"]],TOWGS84[24.9,-126.4,-93.2,-0.063,-0.24");
    add_srs_wkt (p, 4,
        "7,-0.041,1.01],AUTHORITY[\"EPSG\",\"6178\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 5,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 7,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 8,
        "PSG\",\"4178\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 10,
        "idian\",9],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_easting\",3500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 12,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",");
    add_srs_wkt (p, 13,
        "NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2397\"]]");
    p = add_epsg_def_ex (filter, first, last, 2398, "epsg", 2398,
        "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 4", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_83", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.9,-126.4,-93.2,-0.063,-0.247,-0");
    add_proj4text (p, 2,
        ".041,1.01 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 4");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_1942_83\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7024\"]],TOWGS84[24.9,-126.4,-93.2,-0.063,-0.24");
    add_srs_wkt (p, 4,
        "7,-0.041,1.01],AUTHORITY[\"EPSG\",\"6178\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 5,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 7,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 8,
        "PSG\",\"4178\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 10,
        "idian\",12],PARAMETER[\"scale_factor\",1],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",4500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 12,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2398\"]]");
    p = add_epsg_def_ex (filter, first, last, 2399, "epsg", 2399,
        "Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 5", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Pulkovo_1942_83", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=24.9,-126.4,-93.2,-0.063,-0.247,-0");
    add_proj4text (p, 2,
        ".041,1.01 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pulkovo 1942(83) / 3-degree Gauss-Kruger zone 5");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"Pulkovo 1942(83)\",DATUM[\"Pulkovo_1942_83\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7024\"]],TOWGS84[24.9,-126.4,-93.2,-0.063,-0.24");
    add_srs_wkt (p, 4,
        "7,-0.041,1.01],AUTHORITY[\"EPSG\",\"6178\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 5,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 7,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 8,
        "PSG\",\"4178\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 10,
        "idian\",15],PARAMETER[\"scale_factor\",1],PARAMETER[\"fa");
    add_srs_wkt (p, 11,
        "lse_easting\",5500000],PARAMETER[\"false_northing\",0],U");
    add_srs_wkt (p, 12,
        "NIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\"");
    add_srs_wkt (p, 13,
        ",NORTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2399\"]]");
    p = add_epsg_def_ex (filter, first, last, 2400, "epsg", 2400,
        "RT90 2.5 gon W (deprecated)", 0, 1,
        "Bessel 1841", "Greenwich",
        "Rikets_koordinatsystem_1990", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15.80827777777778 +k=1 +x_0=");
    add_proj4text (p, 1,
        "1500000 +y_0=0 +ellps=bessel +towgs84=414.1,41.3,603.1,-");
    add_proj4text (p, 2,
        "0.855,2.141,-7.023,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"RT90 2.5 gon W (deprecated)\",GEOGCS[\"RT90\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"Rikets_koordinatsystem_1990\",SPHEROID[\"Bessel 1");
    add_srs_wkt (p, 2,
        "841\",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[414.1,41.3,603.1,-0.855,2.141,-7.023,0],AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"6124\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 5,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 6,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],");
    add_srs_wkt (p, 7,
        "AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4124\"]],P");
    add_srs_wkt (p, 8,
        "ROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_");
    add_srs_wkt (p, 9,
        "of_origin\",0],PARAMETER[\"central_meridian\",15.8082777");
    add_srs_wkt (p, 10,
        "7777778],PARAMETER[\"scale_factor\",1],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_easting\",1500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 12,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",NO");
    add_srs_wkt (p, 13,
        "RTH],AXIS[\"Y\",EAST],AUTHORITY[\"EPSG\",\"2400\"]]");
    p = add_epsg_def_ex (filter, first, last, 2401, "epsg", 2401,
        "Beijing 1954 / 3-degree Gauss-Kruger zone 25", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 25\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",75],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",25500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"2401\"]]");
    p = add_epsg_def_ex (filter, first, last, 2402, "epsg", 2402,
        "Beijing 1954 / 3-degree Gauss-Kruger zone 26", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 26\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",78],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",26500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"2402\"]]");
    p = add_epsg_def_ex (filter, first, last, 2403, "epsg", 2403,
        "Beijing 1954 / 3-degree Gauss-Kruger zone 27", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 27\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",81],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",27500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"2403\"]]");
    p = add_epsg_def_ex (filter, first, last, 2404, "epsg", 2404,
        "Beijing 1954 / 3-degree Gauss-Kruger zone 28", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 28\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",84],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",28500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"2404\"]]");
    p = add_epsg_def_ex (filter, first, last, 2405, "epsg", 2405,
        "Beijing 1954 / 3-degree Gauss-Kruger zone 29", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 29\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",87],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",29500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"2405\"]]");
    p = add_epsg_def_ex (filter, first, last, 2406, "epsg", 2406,
        "Beijing 1954 / 3-degree Gauss-Kruger zone 30", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 30\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",90],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",30500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"2406\"]]");
    p = add_epsg_def_ex (filter, first, last, 2407, "epsg", 2407,
        "Beijing 1954 / 3-degree Gauss-Kruger zone 31", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 31\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",93],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",31500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"2407\"]]");
    p = add_epsg_def_ex (filter, first, last, 2408, "epsg", 2408,
        "Beijing 1954 / 3-degree Gauss-Kruger zone 32", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 32\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",96],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",32500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"2408\"]]");
    p = add_epsg_def_ex (filter, first, last, 2409, "epsg", 2409,
        "Beijing 1954 / 3-degree Gauss-Kruger zone 33", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33500000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=");
    add_proj4text (p, 2,
        "m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 33\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",99],PARAMETER[\"sc");
    add_srs_wkt (p, 10,
        "ale_factor\",1],PARAMETER[\"false_easting\",33500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],");
    add_srs_wkt (p, 13,
        "AUTHORITY[\"EPSG\",\"2409\"]]");
    p = add_epsg_def_ex (filter, first, last, 2410, "epsg", 2410,
        "Beijing 1954 / 3-degree Gauss-Kruger zone 34", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 34\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",102],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",34500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"2410\"]]");
    p = add_epsg_def_ex (filter, first, last, 2411, "epsg", 2411,
        "Beijing 1954 / 3-degree Gauss-Kruger zone 35", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 35\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",105],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",35500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"2411\"]]");
    p = add_epsg_def_ex (filter, first, last, 2412, "epsg", 2412,
        "Beijing 1954 / 3-degree Gauss-Kruger zone 36", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 36\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",108],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",36500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"2412\"]]");
    p = add_epsg_def_ex (filter, first, last, 2413, "epsg", 2413,
        "Beijing 1954 / 3-degree Gauss-Kruger zone 37", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 37\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",111],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",37500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"2413\"]]");
    p = add_epsg_def_ex (filter, first, last, 2414, "epsg", 2414,
        "Beijing 1954 / 3-degree Gauss-Kruger zone 38", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 38\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",114],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",38500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"2414\"]]");
    p = add_epsg_def_ex (filter, first, last, 2415, "epsg", 2415,
        "Beijing 1954 / 3-degree Gauss-Kruger zone 39", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 39\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",117],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",39500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"2415\"]]");
    p = add_epsg_def_ex (filter, first, last, 2416, "epsg", 2416,
        "Beijing 1954 / 3-degree Gauss-Kruger zone 40", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 40\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",120],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",40500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"2416\"]]");
    p = add_epsg_def_ex (filter, first, last, 2417, "epsg", 2417,
        "Beijing 1954 / 3-degree Gauss-Kruger zone 41", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 41\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",123],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",41500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"2417\"]]");
    p = add_epsg_def_ex (filter, first, last, 2418, "epsg", 2418,
        "Beijing 1954 / 3-degree Gauss-Kruger zone 42", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 42\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",126],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",42500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"2418\"]]");
    p = add_epsg_def_ex (filter, first, last, 2419, "epsg", 2419,
        "Beijing 1954 / 3-degree Gauss-Kruger zone 43", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 43\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",129],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",43500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"2419\"]]");
    p = add_epsg_def_ex (filter, first, last, 2420, "epsg", 2420,
        "Beijing 1954 / 3-degree Gauss-Kruger zone 44", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 44\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",132],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",44500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"2420\"]]");
    p = add_epsg_def_ex (filter, first, last, 2421, "epsg", 2421,
        "Beijing 1954 / 3-degree Gauss-Kruger zone 45", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units");
    add_proj4text (p, 2,
        "=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger zone 45\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "024\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",0],PARAMETER[\"central_meridian\",135],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "cale_factor\",1],PARAMETER[\"false_easting\",45500000],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST]");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"2421\"]]");
    p = add_epsg_def_ex (filter, first, last, 2422, "epsg", 2422,
        "Beijing 1954 / 3-degree Gauss-Kruger CM 75E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 75E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"central_meridian\",75],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",1],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"2422\"]]");
    p = add_epsg_def_ex (filter, first, last, 2423, "epsg", 2423,
        "Beijing 1954 / 3-degree Gauss-Kruger CM 78E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 78E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"central_meridian\",78],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",1],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"2423\"]]");
    p = add_epsg_def_ex (filter, first, last, 2424, "epsg", 2424,
        "Beijing 1954 / 3-degree Gauss-Kruger CM 81E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 81E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"central_meridian\",81],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",1],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"2424\"]]");
    p = add_epsg_def_ex (filter, first, last, 2425, "epsg", 2425,
        "Beijing 1954 / 3-degree Gauss-Kruger CM 84E", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Beijing_1954", "Transverse_Mercator", "metre",
        "X", "North", "Y", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=500000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=krass +towgs84=15.8,-154.4,-82.3,0,0,0,0 +units=m ");
    add_proj4text (p, 2,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Beijing 1954 / 3-degree Gauss-Kruger CM 84E\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"Beijing 1954\",DATUM[\"Beijing_1954\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],TOWGS84[15.8,-154.4,-82.3,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6214\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4214\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 9,
        ",0],PARAMETER[\"central_meridian\",84],PARAMETER[\"scale");
    add_srs_wkt (p, 10,
        "_factor\",1],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 12,
        "SG\",\"9001\"]],AXIS[\"X\",NORTH],AXIS[\"Y\",EAST],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"2425\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

