# $Id: man.mk 173 2007-05-23 23:16:28Z kate $
# This Makefile provides rules for building manpages with docbook,
# and rendering those pages to various formats (namely roff).

# XXX are figures supported? We only use roff for ASCII output
# (XHTML or TeX otherwise), so is that relevant? What about
# tables (perhaps with the tbl macros)?

# Just because I always forget: groff -man -Tascii <file> | less

# XSLT
# Currently we have no customisations here
XSLT = 			xsltproc --xinclude
MANSTYLE ?=	http://docbook.sourceforge.net/release/xsl/current/manpages/docbook.xsl

MANDIR = 		../roff
STYLEOPT=		--stringparam man.hyphenate 1 \
				--stringparam man.justify 1 \
				--stringparam man.hyphenate.urls 0 \
				--stringparam man.break.after.slash 1 \
				--stringparam man.hyphenate.filenames 0 \
				--stringparam man.hyphenate.computer.inlines 0 \
				--stringparam man.links.are.numbered 1 \
				--stringparam man.links.list.enabled 1

all: man

man: $(MANDIR)/$(NAME)

$(MANDIR)/$(NAME): $(MANDIR)
	$(XSLT) $(STYLEOPT) -o $(MANDIR)/$(NAME) $(MANSTYLE) $(SOURCE)

$(MANDIR):
	mkdir -p $(MANDIR)

clean: 
	rm -f $(MANDIR)/$(NAME)

force:

