/*
 * This declarations of the PIC18F6722 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2014.
 *
 * This file is generated automatically by the cinc2h.pl, 2014-03-09 13:33:25 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC18F6722_H__
#define __PIC18F6722_H__

//==============================================================================

//==============================================================================
//
//	Register Definitions
//
//==============================================================================


//==============================================================================
//        SSP2CON2 Bits

extern __at(0x0F62) __sfr SSP2CON2;

typedef union
  {
  struct
    {
    unsigned SEN                : 1;
    unsigned RSEN               : 1;
    unsigned PEN                : 1;
    unsigned RCEN               : 1;
    unsigned ACKEN              : 1;
    unsigned ACKDT              : 1;
    unsigned ACKSTAT            : 1;
    unsigned GCEN               : 1;
    };

  struct
    {
    unsigned SEN2               : 1;
    unsigned RSEN2              : 1;
    unsigned PEN2               : 1;
    unsigned RCEN2              : 1;
    unsigned ACKEN2             : 1;
    unsigned ACKDT2             : 1;
    unsigned ACKSTAT2           : 1;
    unsigned GCEN2              : 1;
    };
  } __SSP2CON2bits_t;

extern __at(0x0F62) volatile __SSP2CON2bits_t SSP2CON2bits;

#define _SSP2CON2_SEN           0x01
#define _SSP2CON2_SEN2          0x01
#define _SSP2CON2_RSEN          0x02
#define _SSP2CON2_RSEN2         0x02
#define _SSP2CON2_PEN           0x04
#define _SSP2CON2_PEN2          0x04
#define _SSP2CON2_RCEN          0x08
#define _SSP2CON2_RCEN2         0x08
#define _SSP2CON2_ACKEN         0x10
#define _SSP2CON2_ACKEN2        0x10
#define _SSP2CON2_ACKDT         0x20
#define _SSP2CON2_ACKDT2        0x20
#define _SSP2CON2_ACKSTAT       0x40
#define _SSP2CON2_ACKSTAT2      0x40
#define _SSP2CON2_GCEN          0x80
#define _SSP2CON2_GCEN2         0x80

//==============================================================================


//==============================================================================
//        SSP2CON1 Bits

extern __at(0x0F63) __sfr SSP2CON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM02             : 1;
    unsigned SSPM12             : 1;
    unsigned SSPM22             : 1;
    unsigned SSPM32             : 1;
    unsigned CKP2               : 1;
    unsigned SSPEN2             : 1;
    unsigned SSPOV2             : 1;
    unsigned WCOL2              : 1;
    };
  } __SSP2CON1bits_t;

extern __at(0x0F63) volatile __SSP2CON1bits_t SSP2CON1bits;

#define _SSP2CON1_SSPM0         0x01
#define _SSP2CON1_SSPM02        0x01
#define _SSP2CON1_SSPM1         0x02
#define _SSP2CON1_SSPM12        0x02
#define _SSP2CON1_SSPM2         0x04
#define _SSP2CON1_SSPM22        0x04
#define _SSP2CON1_SSPM3         0x08
#define _SSP2CON1_SSPM32        0x08
#define _SSP2CON1_CKP           0x10
#define _SSP2CON1_CKP2          0x10
#define _SSP2CON1_SSPEN         0x20
#define _SSP2CON1_SSPEN2        0x20
#define _SSP2CON1_SSPOV         0x40
#define _SSP2CON1_SSPOV2        0x40
#define _SSP2CON1_WCOL          0x80
#define _SSP2CON1_WCOL2         0x80

//==============================================================================


//==============================================================================
//        SSP2STAT Bits

extern __at(0x0F64) __sfr SSP2STAT;

typedef union
  {
  struct
    {
    unsigned BF                 : 1;
    unsigned UA                 : 1;
    unsigned R_NOT_W            : 1;
    unsigned S                  : 1;
    unsigned P                  : 1;
    unsigned D_NOT_A            : 1;
    unsigned CKE                : 1;
    unsigned SMP                : 1;
    };

  struct
    {
    unsigned BF2                : 1;
    unsigned UA2                : 1;
    unsigned R_W                : 1;
    unsigned I2C_START          : 1;
    unsigned I2C_STOP           : 1;
    unsigned D_A                : 1;
    unsigned CKE2               : 1;
    unsigned SMP2               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_READ           : 1;
    unsigned START2             : 1;
    unsigned STOP2              : 1;
    unsigned I2C_DAT            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_W              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_A              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_WRITE          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_ADDRESS        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned READ_WRITE         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DATA_ADDRESS       : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R                  : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned D                  : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RW2                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DA2                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSP2STATbits_t;

extern __at(0x0F64) volatile __SSP2STATbits_t SSP2STATbits;

#define _SSP2STAT_BF            0x01
#define _SSP2STAT_BF2           0x01
#define _SSP2STAT_UA            0x02
#define _SSP2STAT_UA2           0x02
#define _SSP2STAT_R_NOT_W       0x04
#define _SSP2STAT_R_W           0x04
#define _SSP2STAT_I2C_READ      0x04
#define _SSP2STAT_NOT_W         0x04
#define _SSP2STAT_NOT_WRITE     0x04
#define _SSP2STAT_READ_WRITE    0x04
#define _SSP2STAT_R             0x04
#define _SSP2STAT_RW2           0x04
#define _SSP2STAT_S             0x08
#define _SSP2STAT_I2C_START     0x08
#define _SSP2STAT_START2        0x08
#define _SSP2STAT_P             0x10
#define _SSP2STAT_I2C_STOP      0x10
#define _SSP2STAT_STOP2         0x10
#define _SSP2STAT_D_NOT_A       0x20
#define _SSP2STAT_D_A           0x20
#define _SSP2STAT_I2C_DAT       0x20
#define _SSP2STAT_NOT_A         0x20
#define _SSP2STAT_NOT_ADDRESS   0x20
#define _SSP2STAT_DATA_ADDRESS  0x20
#define _SSP2STAT_D             0x20
#define _SSP2STAT_DA2           0x20
#define _SSP2STAT_CKE           0x40
#define _SSP2STAT_CKE2          0x40
#define _SSP2STAT_SMP           0x80
#define _SSP2STAT_SMP2          0x80

//==============================================================================

extern __at(0x0F65) __sfr SSP2ADD;
extern __at(0x0F66) __sfr SSP2BUF;

//==============================================================================
//        ECCP2DEL Bits

extern __at(0x0F67) __sfr ECCP2DEL;

typedef union
  {
  struct
    {
    unsigned P2DC0              : 1;
    unsigned P2DC1              : 1;
    unsigned P2DC2              : 1;
    unsigned P2DC3              : 1;
    unsigned P2DC4              : 1;
    unsigned P2DC5              : 1;
    unsigned P2DC6              : 1;
    unsigned P2RSEN             : 1;
    };

  struct
    {
    unsigned PDC0               : 1;
    unsigned PDC1               : 1;
    unsigned PDC2               : 1;
    unsigned PDC3               : 1;
    unsigned PDC4               : 1;
    unsigned PDC5               : 1;
    unsigned PDC6               : 1;
    unsigned PRSEN              : 1;
    };

  struct
    {
    unsigned P2DC               : 7;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PDC                : 7;
    unsigned                    : 1;
    };
  } __ECCP2DELbits_t;

extern __at(0x0F67) volatile __ECCP2DELbits_t ECCP2DELbits;

#define _ECCP2DEL_P2DC0         0x01
#define _ECCP2DEL_PDC0          0x01
#define _ECCP2DEL_P2DC1         0x02
#define _ECCP2DEL_PDC1          0x02
#define _ECCP2DEL_P2DC2         0x04
#define _ECCP2DEL_PDC2          0x04
#define _ECCP2DEL_P2DC3         0x08
#define _ECCP2DEL_PDC3          0x08
#define _ECCP2DEL_P2DC4         0x10
#define _ECCP2DEL_PDC4          0x10
#define _ECCP2DEL_P2DC5         0x20
#define _ECCP2DEL_PDC5          0x20
#define _ECCP2DEL_P2DC6         0x40
#define _ECCP2DEL_PDC6          0x40
#define _ECCP2DEL_P2RSEN        0x80
#define _ECCP2DEL_PRSEN         0x80

//==============================================================================


//==============================================================================
//        ECCP2AS Bits

extern __at(0x0F68) __sfr ECCP2AS;

typedef union
  {
  struct
    {
    unsigned PSS2BD0            : 1;
    unsigned PSS2BD1            : 1;
    unsigned PSS2AC0            : 1;
    unsigned PSS2AC1            : 1;
    unsigned ECCP2AS0           : 1;
    unsigned ECCP2AS1           : 1;
    unsigned ECCP2AS2           : 1;
    unsigned ECCP2ASE           : 1;
    };

  struct
    {
    unsigned PSSBD0             : 1;
    unsigned PSSBD1             : 1;
    unsigned PSSAC0             : 1;
    unsigned PSSAC1             : 1;
    unsigned ECCPAS0            : 1;
    unsigned ECCPAS1            : 1;
    unsigned ECCPAS2            : 1;
    unsigned ECCPASE            : 1;
    };

  struct
    {
    unsigned PSS2BD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned PSSBD              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSSAC              : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS2AC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ECCP2AS            : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ECCPAS             : 3;
    unsigned                    : 1;
    };
  } __ECCP2ASbits_t;

extern __at(0x0F68) volatile __ECCP2ASbits_t ECCP2ASbits;

#define _ECCP2AS_PSS2BD0        0x01
#define _ECCP2AS_PSSBD0         0x01
#define _ECCP2AS_PSS2BD1        0x02
#define _ECCP2AS_PSSBD1         0x02
#define _ECCP2AS_PSS2AC0        0x04
#define _ECCP2AS_PSSAC0         0x04
#define _ECCP2AS_PSS2AC1        0x08
#define _ECCP2AS_PSSAC1         0x08
#define _ECCP2AS_ECCP2AS0       0x10
#define _ECCP2AS_ECCPAS0        0x10
#define _ECCP2AS_ECCP2AS1       0x20
#define _ECCP2AS_ECCPAS1        0x20
#define _ECCP2AS_ECCP2AS2       0x40
#define _ECCP2AS_ECCPAS2        0x40
#define _ECCP2AS_ECCP2ASE       0x80
#define _ECCP2AS_ECCPASE        0x80

//==============================================================================


//==============================================================================
//        ECCP3DEL Bits

extern __at(0x0F69) __sfr ECCP3DEL;

typedef union
  {
  struct
    {
    unsigned P3DC0              : 1;
    unsigned P3DC1              : 1;
    unsigned P3DC2              : 1;
    unsigned P3DC3              : 1;
    unsigned P3DC4              : 1;
    unsigned P3DC5              : 1;
    unsigned P3DC6              : 1;
    unsigned P3RSEN             : 1;
    };

  struct
    {
    unsigned PDC0               : 1;
    unsigned PDC1               : 1;
    unsigned PDC2               : 1;
    unsigned PDC3               : 1;
    unsigned PDC4               : 1;
    unsigned PDC5               : 1;
    unsigned PDC6               : 1;
    unsigned PRSEN              : 1;
    };

  struct
    {
    unsigned P3DC               : 7;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PDC                : 7;
    unsigned                    : 1;
    };
  } __ECCP3DELbits_t;

extern __at(0x0F69) volatile __ECCP3DELbits_t ECCP3DELbits;

#define _ECCP3DEL_P3DC0         0x01
#define _ECCP3DEL_PDC0          0x01
#define _ECCP3DEL_P3DC1         0x02
#define _ECCP3DEL_PDC1          0x02
#define _ECCP3DEL_P3DC2         0x04
#define _ECCP3DEL_PDC2          0x04
#define _ECCP3DEL_P3DC3         0x08
#define _ECCP3DEL_PDC3          0x08
#define _ECCP3DEL_P3DC4         0x10
#define _ECCP3DEL_PDC4          0x10
#define _ECCP3DEL_P3DC5         0x20
#define _ECCP3DEL_PDC5          0x20
#define _ECCP3DEL_P3DC6         0x40
#define _ECCP3DEL_PDC6          0x40
#define _ECCP3DEL_P3RSEN        0x80
#define _ECCP3DEL_PRSEN         0x80

//==============================================================================


//==============================================================================
//        ECCP3AS Bits

extern __at(0x0F6A) __sfr ECCP3AS;

typedef union
  {
  struct
    {
    unsigned PSS3BD0            : 1;
    unsigned PSS3BD1            : 1;
    unsigned PSS3AC0            : 1;
    unsigned PSS3AC1            : 1;
    unsigned ECCP3AS0           : 1;
    unsigned ECCP3AS1           : 1;
    unsigned ECCP3AS2           : 1;
    unsigned ECCP3ASE           : 1;
    };

  struct
    {
    unsigned PSSBD0             : 1;
    unsigned PSSBD1             : 1;
    unsigned PSSAC0             : 1;
    unsigned PSSAC1             : 1;
    unsigned ECCPAS0            : 1;
    unsigned ECCPAS1            : 1;
    unsigned ECCPAS2            : 1;
    unsigned ECCPASE            : 1;
    };

  struct
    {
    unsigned PSS3BD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned PSSBD              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSSAC              : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS3AC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ECCPAS             : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ECCP3AS            : 3;
    unsigned                    : 1;
    };
  } __ECCP3ASbits_t;

extern __at(0x0F6A) volatile __ECCP3ASbits_t ECCP3ASbits;

#define _ECCP3AS_PSS3BD0        0x01
#define _ECCP3AS_PSSBD0         0x01
#define _ECCP3AS_PSS3BD1        0x02
#define _ECCP3AS_PSSBD1         0x02
#define _ECCP3AS_PSS3AC0        0x04
#define _ECCP3AS_PSSAC0         0x04
#define _ECCP3AS_PSS3AC1        0x08
#define _ECCP3AS_PSSAC1         0x08
#define _ECCP3AS_ECCP3AS0       0x10
#define _ECCP3AS_ECCPAS0        0x10
#define _ECCP3AS_ECCP3AS1       0x20
#define _ECCP3AS_ECCPAS1        0x20
#define _ECCP3AS_ECCP3AS2       0x40
#define _ECCP3AS_ECCPAS2        0x40
#define _ECCP3AS_ECCP3ASE       0x80
#define _ECCP3AS_ECCPASE        0x80

//==============================================================================


//==============================================================================
//        RCSTA2 Bits

extern __at(0x0F6B) __sfr RCSTA2;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned ADDEN              : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned RCD8               : 1;
    unsigned OERR2              : 1;
    unsigned FERR2              : 1;
    unsigned ADDEN2             : 1;
    unsigned CREN2              : 1;
    unsigned SREN2              : 1;
    unsigned RC9                : 1;
    unsigned SPEN2              : 1;
    };

  struct
    {
    unsigned RX9D2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_RC8            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RC8_9              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RX92               : 1;
    unsigned                    : 1;
    };
  } __RCSTA2bits_t;

extern __at(0x0F6B) volatile __RCSTA2bits_t RCSTA2bits;

#define _RCSTA2_RX9D            0x01
#define _RCSTA2_RCD8            0x01
#define _RCSTA2_RX9D2           0x01
#define _RCSTA2_OERR            0x02
#define _RCSTA2_OERR2           0x02
#define _RCSTA2_FERR            0x04
#define _RCSTA2_FERR2           0x04
#define _RCSTA2_ADDEN           0x08
#define _RCSTA2_ADDEN2          0x08
#define _RCSTA2_CREN            0x10
#define _RCSTA2_CREN2           0x10
#define _RCSTA2_SREN            0x20
#define _RCSTA2_SREN2           0x20
#define _RCSTA2_RX9             0x40
#define _RCSTA2_RC9             0x40
#define _RCSTA2_NOT_RC8         0x40
#define _RCSTA2_RC8_9           0x40
#define _RCSTA2_RX92            0x40
#define _RCSTA2_SPEN            0x80
#define _RCSTA2_SPEN2           0x80

//==============================================================================


//==============================================================================
//        TXSTA2 Bits

extern __at(0x0F6C) __sfr TXSTA2;

typedef union
  {
  struct
    {
    unsigned TX9D               : 1;
    unsigned TRMT               : 1;
    unsigned BRGH               : 1;
    unsigned SENDB              : 1;
    unsigned SYNC               : 1;
    unsigned TXEN               : 1;
    unsigned TX9                : 1;
    unsigned CSRC               : 1;
    };

  struct
    {
    unsigned TXD8               : 1;
    unsigned TRMT2              : 1;
    unsigned BRGH2              : 1;
    unsigned SENDB2             : 1;
    unsigned SYNC2              : 1;
    unsigned TXEN2              : 1;
    unsigned TX8_9              : 1;
    unsigned CSRC2              : 1;
    };

  struct
    {
    unsigned TX9D2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_TX8            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TX92               : 1;
    unsigned                    : 1;
    };
  } __TXSTA2bits_t;

extern __at(0x0F6C) volatile __TXSTA2bits_t TXSTA2bits;

#define _TXSTA2_TX9D            0x01
#define _TXSTA2_TXD8            0x01
#define _TXSTA2_TX9D2           0x01
#define _TXSTA2_TRMT            0x02
#define _TXSTA2_TRMT2           0x02
#define _TXSTA2_BRGH            0x04
#define _TXSTA2_BRGH2           0x04
#define _TXSTA2_SENDB           0x08
#define _TXSTA2_SENDB2          0x08
#define _TXSTA2_SYNC            0x10
#define _TXSTA2_SYNC2           0x10
#define _TXSTA2_TXEN            0x20
#define _TXSTA2_TXEN2           0x20
#define _TXSTA2_TX9             0x40
#define _TXSTA2_TX8_9           0x40
#define _TXSTA2_NOT_TX8         0x40
#define _TXSTA2_TX92            0x40
#define _TXSTA2_CSRC            0x80
#define _TXSTA2_CSRC2           0x80

//==============================================================================

extern __at(0x0F6D) __sfr TXREG2;
extern __at(0x0F6E) __sfr RCREG2;
extern __at(0x0F6F) __sfr SPBRG2;

//==============================================================================
//        CCP5CON Bits

extern __at(0x0F70) __sfr CCP5CON;

typedef union
  {
  struct
    {
    unsigned CCP5M0             : 1;
    unsigned CCP5M1             : 1;
    unsigned CCP5M2             : 1;
    unsigned CCP5M3             : 1;
    unsigned DCCP5Y             : 1;
    unsigned DCCP5X             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DC5B0              : 1;
    unsigned DC5B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP5M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC5B               : 2;
    unsigned                    : 2;
    };
  } __CCP5CONbits_t;

extern __at(0x0F70) volatile __CCP5CONbits_t CCP5CONbits;

#define _CCP5M0                 0x01
#define _CCP5M1                 0x02
#define _CCP5M2                 0x04
#define _CCP5M3                 0x08
#define _DCCP5Y                 0x10
#define _DC5B0                  0x10
#define _DCCP5X                 0x20
#define _DC5B1                  0x20

//==============================================================================

extern __at(0x0F71) __sfr CCPR5;
extern __at(0x0F71) __sfr CCPR5L;
extern __at(0x0F72) __sfr CCPR5H;

//==============================================================================
//        CCP4CON Bits

extern __at(0x0F73) __sfr CCP4CON;

typedef union
  {
  struct
    {
    unsigned CCP4M0             : 1;
    unsigned CCP4M1             : 1;
    unsigned CCP4M2             : 1;
    unsigned CCP4M3             : 1;
    unsigned DCCP4Y             : 1;
    unsigned DCCP4X             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DC4B0              : 1;
    unsigned DC4B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP4M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC4B               : 2;
    unsigned                    : 2;
    };
  } __CCP4CONbits_t;

extern __at(0x0F73) volatile __CCP4CONbits_t CCP4CONbits;

#define _CCP4M0                 0x01
#define _CCP4M1                 0x02
#define _CCP4M2                 0x04
#define _CCP4M3                 0x08
#define _DCCP4Y                 0x10
#define _DC4B0                  0x10
#define _DCCP4X                 0x20
#define _DC4B1                  0x20

//==============================================================================

extern __at(0x0F74) __sfr CCPR4;
extern __at(0x0F74) __sfr CCPR4L;
extern __at(0x0F75) __sfr CCPR4H;

//==============================================================================
//        T4CON Bits

extern __at(0x0F76) __sfr T4CON;

typedef union
  {
  struct
    {
    unsigned T4CKPS0            : 1;
    unsigned T4CKPS1            : 1;
    unsigned TMR4ON             : 1;
    unsigned T4OUTPS0           : 1;
    unsigned T4OUTPS1           : 1;
    unsigned T4OUTPS2           : 1;
    unsigned T4OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T4CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T4OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T4CONbits_t;

extern __at(0x0F76) volatile __T4CONbits_t T4CONbits;

#define _T4CKPS0                0x01
#define _T4CKPS1                0x02
#define _TMR4ON                 0x04
#define _T4OUTPS0               0x08
#define _T4OUTPS1               0x10
#define _T4OUTPS2               0x20
#define _T4OUTPS3               0x40

//==============================================================================

extern __at(0x0F77) __sfr PR4;
extern __at(0x0F78) __sfr TMR4;

//==============================================================================
//        ECCP1DEL Bits

extern __at(0x0F79) __sfr ECCP1DEL;

typedef union
  {
  struct
    {
    unsigned P1DC0              : 1;
    unsigned P1DC1              : 1;
    unsigned P1DC2              : 1;
    unsigned P1DC3              : 1;
    unsigned P1DC4              : 1;
    unsigned P1DC5              : 1;
    unsigned P1DC6              : 1;
    unsigned P1RSEN             : 1;
    };

  struct
    {
    unsigned PDC0               : 1;
    unsigned PDC1               : 1;
    unsigned PDC2               : 1;
    unsigned PDC3               : 1;
    unsigned PDC4               : 1;
    unsigned PDC5               : 1;
    unsigned PDC6               : 1;
    unsigned PRSEN              : 1;
    };

  struct
    {
    unsigned P1DC               : 7;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PDC                : 7;
    unsigned                    : 1;
    };
  } __ECCP1DELbits_t;

extern __at(0x0F79) volatile __ECCP1DELbits_t ECCP1DELbits;

#define _P1DC0                  0x01
#define _PDC0                   0x01
#define _P1DC1                  0x02
#define _PDC1                   0x02
#define _P1DC2                  0x04
#define _PDC2                   0x04
#define _P1DC3                  0x08
#define _PDC3                   0x08
#define _P1DC4                  0x10
#define _PDC4                   0x10
#define _P1DC5                  0x20
#define _PDC5                   0x20
#define _P1DC6                  0x40
#define _PDC6                   0x40
#define _P1RSEN                 0x80
#define _PRSEN                  0x80

//==============================================================================


//==============================================================================
//        BAUDCON2 Bits

extern __at(0x0F7C) __sfr BAUDCON2;

typedef union
  {
  struct
    {
    unsigned ABDEN              : 1;
    unsigned WUE                : 1;
    unsigned                    : 1;
    unsigned BRG16              : 1;
    unsigned SCKP               : 1;
    unsigned                    : 1;
    unsigned RCIDL              : 1;
    unsigned ABDOVF             : 1;
    };

  struct
    {
    unsigned ABDEN2             : 1;
    unsigned WUE2               : 1;
    unsigned                    : 1;
    unsigned BRG162             : 1;
    unsigned SCKP2              : 1;
    unsigned                    : 1;
    unsigned RCMT               : 1;
    unsigned ABDOVF2            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RCIDL2             : 1;
    unsigned                    : 1;
    };
  } __BAUDCON2bits_t;

extern __at(0x0F7C) volatile __BAUDCON2bits_t BAUDCON2bits;

#define _BAUDCON2_ABDEN         0x01
#define _BAUDCON2_ABDEN2        0x01
#define _BAUDCON2_WUE           0x02
#define _BAUDCON2_WUE2          0x02
#define _BAUDCON2_BRG16         0x08
#define _BAUDCON2_BRG162        0x08
#define _BAUDCON2_SCKP          0x10
#define _BAUDCON2_SCKP2         0x10
#define _BAUDCON2_RCIDL         0x40
#define _BAUDCON2_RCMT          0x40
#define _BAUDCON2_RCIDL2        0x40
#define _BAUDCON2_ABDOVF        0x80
#define _BAUDCON2_ABDOVF2       0x80

//==============================================================================

extern __at(0x0F7D) __sfr SPBRGH2;

//==============================================================================
//        BAUDCON Bits

extern __at(0x0F7E) __sfr BAUDCON;

typedef union
  {
  struct
    {
    unsigned ABDEN              : 1;
    unsigned WUE                : 1;
    unsigned                    : 1;
    unsigned BRG16              : 1;
    unsigned SCKP               : 1;
    unsigned                    : 1;
    unsigned RCIDL              : 1;
    unsigned ABDOVF             : 1;
    };

  struct
    {
    unsigned ABDEN1             : 1;
    unsigned WUE1               : 1;
    unsigned                    : 1;
    unsigned BRG161             : 1;
    unsigned SCKP1              : 1;
    unsigned                    : 1;
    unsigned RCMT               : 1;
    unsigned ABDOVF1            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RCIDL1             : 1;
    unsigned                    : 1;
    };
  } __BAUDCONbits_t;

extern __at(0x0F7E) volatile __BAUDCONbits_t BAUDCONbits;

#define _ABDEN                  0x01
#define _ABDEN1                 0x01
#define _WUE                    0x02
#define _WUE1                   0x02
#define _BRG16                  0x08
#define _BRG161                 0x08
#define _SCKP                   0x10
#define _SCKP1                  0x10
#define _RCIDL                  0x40
#define _RCMT                   0x40
#define _RCIDL1                 0x40
#define _ABDOVF                 0x80
#define _ABDOVF1                0x80

//==============================================================================


//==============================================================================
//        BAUDCON1 Bits

extern __at(0x0F7E) __sfr BAUDCON1;

typedef union
  {
  struct
    {
    unsigned ABDEN              : 1;
    unsigned WUE                : 1;
    unsigned                    : 1;
    unsigned BRG16              : 1;
    unsigned SCKP               : 1;
    unsigned                    : 1;
    unsigned RCIDL              : 1;
    unsigned ABDOVF             : 1;
    };

  struct
    {
    unsigned ABDEN1             : 1;
    unsigned WUE1               : 1;
    unsigned                    : 1;
    unsigned BRG161             : 1;
    unsigned SCKP1              : 1;
    unsigned                    : 1;
    unsigned RCMT               : 1;
    unsigned ABDOVF1            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RCIDL1             : 1;
    unsigned                    : 1;
    };
  } __BAUDCON1bits_t;

extern __at(0x0F7E) volatile __BAUDCON1bits_t BAUDCON1bits;

#define _BAUDCON1_ABDEN         0x01
#define _BAUDCON1_ABDEN1        0x01
#define _BAUDCON1_WUE           0x02
#define _BAUDCON1_WUE1          0x02
#define _BAUDCON1_BRG16         0x08
#define _BAUDCON1_BRG161        0x08
#define _BAUDCON1_SCKP          0x10
#define _BAUDCON1_SCKP1         0x10
#define _BAUDCON1_RCIDL         0x40
#define _BAUDCON1_RCMT          0x40
#define _BAUDCON1_RCIDL1        0x40
#define _BAUDCON1_ABDOVF        0x80
#define _BAUDCON1_ABDOVF1       0x80

//==============================================================================

extern __at(0x0F7F) __sfr SPBRGH;
extern __at(0x0F7F) __sfr SPBRGH1;

//==============================================================================
//        PORTA Bits

extern __at(0x0F80) __sfr PORTA;

typedef union
  {
  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned RA6                : 1;
    unsigned RA7                : 1;
    };

  struct
    {
    unsigned AN0                : 1;
    unsigned AN1                : 1;
    unsigned VREFM              : 1;
    unsigned VREFP              : 1;
    unsigned T0CKI              : 1;
    unsigned LVDIN              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned AN2                : 1;
    unsigned AN3                : 1;
    unsigned                    : 1;
    unsigned AN4                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned HLVDIN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PORTAbits_t;

extern __at(0x0F80) volatile __PORTAbits_t PORTAbits;

#define _PORTA_RA0              0x01
#define _PORTA_AN0              0x01
#define _PORTA_RA1              0x02
#define _PORTA_AN1              0x02
#define _PORTA_RA2              0x04
#define _PORTA_VREFM            0x04
#define _PORTA_AN2              0x04
#define _PORTA_RA3              0x08
#define _PORTA_VREFP            0x08
#define _PORTA_AN3              0x08
#define _PORTA_RA4              0x10
#define _PORTA_T0CKI            0x10
#define _PORTA_RA5              0x20
#define _PORTA_LVDIN            0x20
#define _PORTA_AN4              0x20
#define _PORTA_HLVDIN           0x20
#define _PORTA_RA6              0x40
#define _PORTA_RA7              0x80

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x0F81) __sfr PORTB;

typedef union
  {
  struct
    {
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RB2                : 1;
    unsigned RB3                : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };

  struct
    {
    unsigned INT0               : 1;
    unsigned INT1               : 1;
    unsigned INT2               : 1;
    unsigned INT3               : 1;
    unsigned KBI0               : 1;
    unsigned KBI1               : 1;
    unsigned KBI2               : 1;
    unsigned KBI3               : 1;
    };

  struct
    {
    unsigned FLT0               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned INT                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned KBI                : 4;
    };
  } __PORTBbits_t;

extern __at(0x0F81) volatile __PORTBbits_t PORTBbits;

#define _PORTB_RB0              0x01
#define _PORTB_INT0             0x01
#define _PORTB_FLT0             0x01
#define _PORTB_RB1              0x02
#define _PORTB_INT1             0x02
#define _PORTB_RB2              0x04
#define _PORTB_INT2             0x04
#define _PORTB_RB3              0x08
#define _PORTB_INT3             0x08
#define _PORTB_RB4              0x10
#define _PORTB_KBI0             0x10
#define _PORTB_RB5              0x20
#define _PORTB_KBI1             0x20
#define _PORTB_RB6              0x40
#define _PORTB_KBI2             0x40
#define _PORTB_RB7              0x80
#define _PORTB_KBI3             0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x0F82) __sfr PORTC;

typedef union
  {
  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };

  struct
    {
    unsigned T1OSO              : 1;
    unsigned T1OSI              : 1;
    unsigned ECCP1              : 1;
    unsigned SCK                : 1;
    unsigned SDI                : 1;
    unsigned SDO                : 1;
    unsigned TX                 : 1;
    unsigned RX                 : 1;
    };

  struct
    {
    unsigned T13CKI             : 1;
    unsigned ECCP2              : 1;
    unsigned CCP1               : 1;
    unsigned SCL                : 1;
    unsigned SDA                : 1;
    unsigned SDO1               : 1;
    unsigned CK                 : 1;
    unsigned DT1                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned CCP2               : 1;
    unsigned P1A                : 1;
    unsigned SCL1               : 1;
    unsigned SDA1               : 1;
    unsigned                    : 1;
    unsigned CK1                : 1;
    unsigned RX1                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned P2A                : 1;
    unsigned                    : 1;
    unsigned SCK1               : 1;
    unsigned SDI1               : 1;
    unsigned                    : 1;
    unsigned TX1                : 1;
    unsigned                    : 1;
    };
  } __PORTCbits_t;

extern __at(0x0F82) volatile __PORTCbits_t PORTCbits;

#define _PORTC_RC0              0x01
#define _PORTC_T1OSO            0x01
#define _PORTC_T13CKI           0x01
#define _PORTC_RC1              0x02
#define _PORTC_T1OSI            0x02
#define _PORTC_ECCP2            0x02
#define _PORTC_CCP2             0x02
#define _PORTC_P2A              0x02
#define _PORTC_RC2              0x04
#define _PORTC_ECCP1            0x04
#define _PORTC_CCP1             0x04
#define _PORTC_P1A              0x04
#define _PORTC_RC3              0x08
#define _PORTC_SCK              0x08
#define _PORTC_SCL              0x08
#define _PORTC_SCL1             0x08
#define _PORTC_SCK1             0x08
#define _PORTC_RC4              0x10
#define _PORTC_SDI              0x10
#define _PORTC_SDA              0x10
#define _PORTC_SDA1             0x10
#define _PORTC_SDI1             0x10
#define _PORTC_RC5              0x20
#define _PORTC_SDO              0x20
#define _PORTC_SDO1             0x20
#define _PORTC_RC6              0x40
#define _PORTC_TX               0x40
#define _PORTC_CK               0x40
#define _PORTC_CK1              0x40
#define _PORTC_TX1              0x40
#define _PORTC_RC7              0x80
#define _PORTC_RX               0x80
#define _PORTC_DT1              0x80
#define _PORTC_RX1              0x80

//==============================================================================


//==============================================================================
//        PORTD Bits

extern __at(0x0F83) __sfr PORTD;

typedef union
  {
  struct
    {
    unsigned RD0                : 1;
    unsigned RD1                : 1;
    unsigned RD2                : 1;
    unsigned RD3                : 1;
    unsigned RD4                : 1;
    unsigned RD5                : 1;
    unsigned RD6                : 1;
    unsigned RD7                : 1;
    };

  struct
    {
    unsigned PSP0               : 1;
    unsigned PSP1               : 1;
    unsigned PSP2               : 1;
    unsigned PSP3               : 1;
    unsigned PSP4               : 1;
    unsigned PSP5               : 1;
    unsigned PSP6               : 1;
    unsigned PSP7               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SDO2               : 1;
    unsigned SDA2               : 1;
    unsigned SCL2               : 1;
    unsigned SS2                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SDI2               : 1;
    unsigned SCK2               : 1;
    unsigned NOT_SS2            : 1;
    };
  } __PORTDbits_t;

extern __at(0x0F83) volatile __PORTDbits_t PORTDbits;

#define _PORTD_RD0              0x01
#define _PORTD_PSP0             0x01
#define _PORTD_RD1              0x02
#define _PORTD_PSP1             0x02
#define _PORTD_RD2              0x04
#define _PORTD_PSP2             0x04
#define _PORTD_RD3              0x08
#define _PORTD_PSP3             0x08
#define _PORTD_RD4              0x10
#define _PORTD_PSP4             0x10
#define _PORTD_SDO2             0x10
#define _PORTD_RD5              0x20
#define _PORTD_PSP5             0x20
#define _PORTD_SDA2             0x20
#define _PORTD_SDI2             0x20
#define _PORTD_RD6              0x40
#define _PORTD_PSP6             0x40
#define _PORTD_SCL2             0x40
#define _PORTD_SCK2             0x40
#define _PORTD_RD7              0x80
#define _PORTD_PSP7             0x80
#define _PORTD_SS2              0x80
#define _PORTD_NOT_SS2          0x80

//==============================================================================


//==============================================================================
//        PORTE Bits

extern __at(0x0F84) __sfr PORTE;

typedef union
  {
  struct
    {
    unsigned RE0                : 1;
    unsigned RE1                : 1;
    unsigned RE2                : 1;
    unsigned RE3                : 1;
    unsigned RE4                : 1;
    unsigned RE5                : 1;
    unsigned RE6                : 1;
    unsigned RE7                : 1;
    };

  struct
    {
    unsigned RD                 : 1;
    unsigned WR                 : 1;
    unsigned CS                 : 1;
    unsigned P3C                : 1;
    unsigned P3B                : 1;
    unsigned P1C                : 1;
    unsigned P1B                : 1;
    unsigned ECCP2              : 1;
    };

  struct
    {
    unsigned NOT_RD             : 1;
    unsigned NOT_WR             : 1;
    unsigned NOT_CS             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP2               : 1;
    };

  struct
    {
    unsigned P2D                : 1;
    unsigned P2C                : 1;
    unsigned P2B                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned P2A                : 1;
    };
  } __PORTEbits_t;

extern __at(0x0F84) volatile __PORTEbits_t PORTEbits;

#define _PORTE_RE0              0x01
#define _PORTE_RD               0x01
#define _PORTE_NOT_RD           0x01
#define _PORTE_P2D              0x01
#define _PORTE_RE1              0x02
#define _PORTE_WR               0x02
#define _PORTE_NOT_WR           0x02
#define _PORTE_P2C              0x02
#define _PORTE_RE2              0x04
#define _PORTE_CS               0x04
#define _PORTE_NOT_CS           0x04
#define _PORTE_P2B              0x04
#define _PORTE_RE3              0x08
#define _PORTE_P3C              0x08
#define _PORTE_RE4              0x10
#define _PORTE_P3B              0x10
#define _PORTE_RE5              0x20
#define _PORTE_P1C              0x20
#define _PORTE_RE6              0x40
#define _PORTE_P1B              0x40
#define _PORTE_RE7              0x80
#define _PORTE_ECCP2            0x80
#define _PORTE_CCP2             0x80
#define _PORTE_P2A              0x80

//==============================================================================


//==============================================================================
//        PORTF Bits

extern __at(0x0F85) __sfr PORTF;

typedef union
  {
  struct
    {
    unsigned RF0                : 1;
    unsigned RF1                : 1;
    unsigned RF2                : 1;
    unsigned RF3                : 1;
    unsigned RF4                : 1;
    unsigned RF5                : 1;
    unsigned RF6                : 1;
    unsigned RF7                : 1;
    };

  struct
    {
    unsigned AN5                : 1;
    unsigned AN6                : 1;
    unsigned AN7                : 1;
    unsigned AN8                : 1;
    unsigned AN9                : 1;
    unsigned AN10               : 1;
    unsigned AN11               : 1;
    unsigned SS1                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned C2OUT              : 1;
    unsigned C1OUT              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CVREF              : 1;
    unsigned                    : 1;
    unsigned NOT_SS1            : 1;
    };
  } __PORTFbits_t;

extern __at(0x0F85) volatile __PORTFbits_t PORTFbits;

#define _PORTF_RF0              0x01
#define _PORTF_AN5              0x01
#define _PORTF_RF1              0x02
#define _PORTF_AN6              0x02
#define _PORTF_C2OUT            0x02
#define _PORTF_RF2              0x04
#define _PORTF_AN7              0x04
#define _PORTF_C1OUT            0x04
#define _PORTF_RF3              0x08
#define _PORTF_AN8              0x08
#define _PORTF_RF4              0x10
#define _PORTF_AN9              0x10
#define _PORTF_RF5              0x20
#define _PORTF_AN10             0x20
#define _PORTF_CVREF            0x20
#define _PORTF_RF6              0x40
#define _PORTF_AN11             0x40
#define _PORTF_RF7              0x80
#define _PORTF_SS1              0x80
#define _PORTF_NOT_SS1          0x80

//==============================================================================


//==============================================================================
//        PORTG Bits

extern __at(0x0F86) __sfr PORTG;

typedef union
  {
  struct
    {
    unsigned RG0                : 1;
    unsigned RG1                : 1;
    unsigned RG2                : 1;
    unsigned RG3                : 1;
    unsigned RG4                : 1;
    unsigned RG5                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ECCP3              : 1;
    unsigned TX2                : 1;
    unsigned RX2                : 1;
    unsigned CCP4               : 1;
    unsigned CCP5               : 1;
    unsigned MCLR               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned P3A                : 1;
    unsigned CK2                : 1;
    unsigned DT2                : 1;
    unsigned P3D                : 1;
    unsigned P1D                : 1;
    unsigned NOT_MCLR           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG                 : 6;
    unsigned                    : 2;
    };
  } __PORTGbits_t;

extern __at(0x0F86) volatile __PORTGbits_t PORTGbits;

#define _PORTG_RG0              0x01
#define _PORTG_ECCP3            0x01
#define _PORTG_P3A              0x01
#define _PORTG_CCP3             0x01
#define _PORTG_RG1              0x02
#define _PORTG_TX2              0x02
#define _PORTG_CK2              0x02
#define _PORTG_RG2              0x04
#define _PORTG_RX2              0x04
#define _PORTG_DT2              0x04
#define _PORTG_RG3              0x08
#define _PORTG_CCP4             0x08
#define _PORTG_P3D              0x08
#define _PORTG_RG4              0x10
#define _PORTG_CCP5             0x10
#define _PORTG_P1D              0x10
#define _PORTG_RG5              0x20
#define _PORTG_MCLR             0x20
#define _PORTG_NOT_MCLR         0x20

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x0F89) __sfr LATA;

typedef struct
  {
  unsigned LATA0                : 1;
  unsigned LATA1                : 1;
  unsigned LATA2                : 1;
  unsigned LATA3                : 1;
  unsigned LATA4                : 1;
  unsigned LATA5                : 1;
  unsigned LATA6                : 1;
  unsigned LATA7                : 1;
  } __LATAbits_t;

extern __at(0x0F89) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04
#define _LATA3                  0x08
#define _LATA4                  0x10
#define _LATA5                  0x20
#define _LATA6                  0x40
#define _LATA7                  0x80

//==============================================================================


//==============================================================================
//        LATB Bits

extern __at(0x0F8A) __sfr LATB;

typedef struct
  {
  unsigned LATB0                : 1;
  unsigned LATB1                : 1;
  unsigned LATB2                : 1;
  unsigned LATB3                : 1;
  unsigned LATB4                : 1;
  unsigned LATB5                : 1;
  unsigned LATB6                : 1;
  unsigned LATB7                : 1;
  } __LATBbits_t;

extern __at(0x0F8A) volatile __LATBbits_t LATBbits;

#define _LATB0                  0x01
#define _LATB1                  0x02
#define _LATB2                  0x04
#define _LATB3                  0x08
#define _LATB4                  0x10
#define _LATB5                  0x20
#define _LATB6                  0x40
#define _LATB7                  0x80

//==============================================================================


//==============================================================================
//        LATC Bits

extern __at(0x0F8B) __sfr LATC;

typedef struct
  {
  unsigned LATC0                : 1;
  unsigned LATC1                : 1;
  unsigned LATC2                : 1;
  unsigned LATC3                : 1;
  unsigned LATC4                : 1;
  unsigned LATC5                : 1;
  unsigned LATC6                : 1;
  unsigned LATC7                : 1;
  } __LATCbits_t;

extern __at(0x0F8B) volatile __LATCbits_t LATCbits;

#define _LATC0                  0x01
#define _LATC1                  0x02
#define _LATC2                  0x04
#define _LATC3                  0x08
#define _LATC4                  0x10
#define _LATC5                  0x20
#define _LATC6                  0x40
#define _LATC7                  0x80

//==============================================================================


//==============================================================================
//        LATD Bits

extern __at(0x0F8C) __sfr LATD;

typedef struct
  {
  unsigned LATD0                : 1;
  unsigned LATD1                : 1;
  unsigned LATD2                : 1;
  unsigned LATD3                : 1;
  unsigned LATD4                : 1;
  unsigned LATD5                : 1;
  unsigned LATD6                : 1;
  unsigned LATD7                : 1;
  } __LATDbits_t;

extern __at(0x0F8C) volatile __LATDbits_t LATDbits;

#define _LATD0                  0x01
#define _LATD1                  0x02
#define _LATD2                  0x04
#define _LATD3                  0x08
#define _LATD4                  0x10
#define _LATD5                  0x20
#define _LATD6                  0x40
#define _LATD7                  0x80

//==============================================================================


//==============================================================================
//        LATE Bits

extern __at(0x0F8D) __sfr LATE;

typedef struct
  {
  unsigned LATE0                : 1;
  unsigned LATE1                : 1;
  unsigned LATE2                : 1;
  unsigned LATE3                : 1;
  unsigned LATE4                : 1;
  unsigned LATE5                : 1;
  unsigned LATE6                : 1;
  unsigned LATE7                : 1;
  } __LATEbits_t;

extern __at(0x0F8D) volatile __LATEbits_t LATEbits;

#define _LATE0                  0x01
#define _LATE1                  0x02
#define _LATE2                  0x04
#define _LATE3                  0x08
#define _LATE4                  0x10
#define _LATE5                  0x20
#define _LATE6                  0x40
#define _LATE7                  0x80

//==============================================================================


//==============================================================================
//        LATF Bits

extern __at(0x0F8E) __sfr LATF;

typedef struct
  {
  unsigned LATF0                : 1;
  unsigned LATF1                : 1;
  unsigned LATF2                : 1;
  unsigned LATF3                : 1;
  unsigned LATF4                : 1;
  unsigned LATF5                : 1;
  unsigned LATF6                : 1;
  unsigned LATF7                : 1;
  } __LATFbits_t;

extern __at(0x0F8E) volatile __LATFbits_t LATFbits;

#define _LATF0                  0x01
#define _LATF1                  0x02
#define _LATF2                  0x04
#define _LATF3                  0x08
#define _LATF4                  0x10
#define _LATF5                  0x20
#define _LATF6                  0x40
#define _LATF7                  0x80

//==============================================================================


//==============================================================================
//        LATG Bits

extern __at(0x0F8F) __sfr LATG;

typedef union
  {
  struct
    {
    unsigned LATG0              : 1;
    unsigned LATG1              : 1;
    unsigned LATG2              : 1;
    unsigned LATG3              : 1;
    unsigned LATG4              : 1;
    unsigned LATG5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LATG               : 6;
    unsigned                    : 2;
    };
  } __LATGbits_t;

extern __at(0x0F8F) volatile __LATGbits_t LATGbits;

#define _LATG0                  0x01
#define _LATG1                  0x02
#define _LATG2                  0x04
#define _LATG3                  0x08
#define _LATG4                  0x10
#define _LATG5                  0x20

//==============================================================================


//==============================================================================
//        DDRA Bits

extern __at(0x0F92) __sfr DDRA;

typedef union
  {
  struct
    {
    unsigned TRISA0             : 1;
    unsigned TRISA1             : 1;
    unsigned TRISA2             : 1;
    unsigned TRISA3             : 1;
    unsigned TRISA4             : 1;
    unsigned TRISA5             : 1;
    unsigned TRISA6             : 1;
    unsigned TRISA7             : 1;
    };

  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned RA6                : 1;
    unsigned RA7                : 1;
    };
  } __DDRAbits_t;

extern __at(0x0F92) volatile __DDRAbits_t DDRAbits;

#define _TRISA0                 0x01
#define _RA0                    0x01
#define _TRISA1                 0x02
#define _RA1                    0x02
#define _TRISA2                 0x04
#define _RA2                    0x04
#define _TRISA3                 0x08
#define _RA3                    0x08
#define _TRISA4                 0x10
#define _RA4                    0x10
#define _TRISA5                 0x20
#define _RA5                    0x20
#define _TRISA6                 0x40
#define _RA6                    0x40
#define _TRISA7                 0x80
#define _RA7                    0x80

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x0F92) __sfr TRISA;

typedef union
  {
  struct
    {
    unsigned TRISA0             : 1;
    unsigned TRISA1             : 1;
    unsigned TRISA2             : 1;
    unsigned TRISA3             : 1;
    unsigned TRISA4             : 1;
    unsigned TRISA5             : 1;
    unsigned TRISA6             : 1;
    unsigned TRISA7             : 1;
    };

  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned RA6                : 1;
    unsigned RA7                : 1;
    };
  } __TRISAbits_t;

extern __at(0x0F92) volatile __TRISAbits_t TRISAbits;

#define _TRISA_TRISA0           0x01
#define _TRISA_RA0              0x01
#define _TRISA_TRISA1           0x02
#define _TRISA_RA1              0x02
#define _TRISA_TRISA2           0x04
#define _TRISA_RA2              0x04
#define _TRISA_TRISA3           0x08
#define _TRISA_RA3              0x08
#define _TRISA_TRISA4           0x10
#define _TRISA_RA4              0x10
#define _TRISA_TRISA5           0x20
#define _TRISA_RA5              0x20
#define _TRISA_TRISA6           0x40
#define _TRISA_RA6              0x40
#define _TRISA_TRISA7           0x80
#define _TRISA_RA7              0x80

//==============================================================================


//==============================================================================
//        DDRB Bits

extern __at(0x0F93) __sfr DDRB;

typedef union
  {
  struct
    {
    unsigned TRISB0             : 1;
    unsigned TRISB1             : 1;
    unsigned TRISB2             : 1;
    unsigned TRISB3             : 1;
    unsigned TRISB4             : 1;
    unsigned TRISB5             : 1;
    unsigned TRISB6             : 1;
    unsigned TRISB7             : 1;
    };

  struct
    {
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RB2                : 1;
    unsigned RB3                : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };
  } __DDRBbits_t;

extern __at(0x0F93) volatile __DDRBbits_t DDRBbits;

#define _TRISB0                 0x01
#define _RB0                    0x01
#define _TRISB1                 0x02
#define _RB1                    0x02
#define _TRISB2                 0x04
#define _RB2                    0x04
#define _TRISB3                 0x08
#define _RB3                    0x08
#define _TRISB4                 0x10
#define _RB4                    0x10
#define _TRISB5                 0x20
#define _RB5                    0x20
#define _TRISB6                 0x40
#define _RB6                    0x40
#define _TRISB7                 0x80
#define _RB7                    0x80

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x0F93) __sfr TRISB;

typedef union
  {
  struct
    {
    unsigned TRISB0             : 1;
    unsigned TRISB1             : 1;
    unsigned TRISB2             : 1;
    unsigned TRISB3             : 1;
    unsigned TRISB4             : 1;
    unsigned TRISB5             : 1;
    unsigned TRISB6             : 1;
    unsigned TRISB7             : 1;
    };

  struct
    {
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RB2                : 1;
    unsigned RB3                : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };
  } __TRISBbits_t;

extern __at(0x0F93) volatile __TRISBbits_t TRISBbits;

#define _TRISB_TRISB0           0x01
#define _TRISB_RB0              0x01
#define _TRISB_TRISB1           0x02
#define _TRISB_RB1              0x02
#define _TRISB_TRISB2           0x04
#define _TRISB_RB2              0x04
#define _TRISB_TRISB3           0x08
#define _TRISB_RB3              0x08
#define _TRISB_TRISB4           0x10
#define _TRISB_RB4              0x10
#define _TRISB_TRISB5           0x20
#define _TRISB_RB5              0x20
#define _TRISB_TRISB6           0x40
#define _TRISB_RB6              0x40
#define _TRISB_TRISB7           0x80
#define _TRISB_RB7              0x80

//==============================================================================


//==============================================================================
//        DDRC Bits

extern __at(0x0F94) __sfr DDRC;

typedef union
  {
  struct
    {
    unsigned TRISC0             : 1;
    unsigned TRISC1             : 1;
    unsigned TRISC2             : 1;
    unsigned TRISC3             : 1;
    unsigned TRISC4             : 1;
    unsigned TRISC5             : 1;
    unsigned TRISC6             : 1;
    unsigned TRISC7             : 1;
    };

  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };
  } __DDRCbits_t;

extern __at(0x0F94) volatile __DDRCbits_t DDRCbits;

#define _TRISC0                 0x01
#define _RC0                    0x01
#define _TRISC1                 0x02
#define _RC1                    0x02
#define _TRISC2                 0x04
#define _RC2                    0x04
#define _TRISC3                 0x08
#define _RC3                    0x08
#define _TRISC4                 0x10
#define _RC4                    0x10
#define _TRISC5                 0x20
#define _RC5                    0x20
#define _TRISC6                 0x40
#define _RC6                    0x40
#define _TRISC7                 0x80
#define _RC7                    0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x0F94) __sfr TRISC;

typedef union
  {
  struct
    {
    unsigned TRISC0             : 1;
    unsigned TRISC1             : 1;
    unsigned TRISC2             : 1;
    unsigned TRISC3             : 1;
    unsigned TRISC4             : 1;
    unsigned TRISC5             : 1;
    unsigned TRISC6             : 1;
    unsigned TRISC7             : 1;
    };

  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };
  } __TRISCbits_t;

extern __at(0x0F94) volatile __TRISCbits_t TRISCbits;

#define _TRISC_TRISC0           0x01
#define _TRISC_RC0              0x01
#define _TRISC_TRISC1           0x02
#define _TRISC_RC1              0x02
#define _TRISC_TRISC2           0x04
#define _TRISC_RC2              0x04
#define _TRISC_TRISC3           0x08
#define _TRISC_RC3              0x08
#define _TRISC_TRISC4           0x10
#define _TRISC_RC4              0x10
#define _TRISC_TRISC5           0x20
#define _TRISC_RC5              0x20
#define _TRISC_TRISC6           0x40
#define _TRISC_RC6              0x40
#define _TRISC_TRISC7           0x80
#define _TRISC_RC7              0x80

//==============================================================================


//==============================================================================
//        DDRD Bits

extern __at(0x0F95) __sfr DDRD;

typedef union
  {
  struct
    {
    unsigned TRISD0             : 1;
    unsigned TRISD1             : 1;
    unsigned TRISD2             : 1;
    unsigned TRISD3             : 1;
    unsigned TRISD4             : 1;
    unsigned TRISD5             : 1;
    unsigned TRISD6             : 1;
    unsigned TRISD7             : 1;
    };

  struct
    {
    unsigned RD0                : 1;
    unsigned RD1                : 1;
    unsigned RD2                : 1;
    unsigned RD3                : 1;
    unsigned RD4                : 1;
    unsigned RD5                : 1;
    unsigned RD6                : 1;
    unsigned RD7                : 1;
    };
  } __DDRDbits_t;

extern __at(0x0F95) volatile __DDRDbits_t DDRDbits;

#define _TRISD0                 0x01
#define _RD0                    0x01
#define _TRISD1                 0x02
#define _RD1                    0x02
#define _TRISD2                 0x04
#define _RD2                    0x04
#define _TRISD3                 0x08
#define _RD3                    0x08
#define _TRISD4                 0x10
#define _RD4                    0x10
#define _TRISD5                 0x20
#define _RD5                    0x20
#define _TRISD6                 0x40
#define _RD6                    0x40
#define _TRISD7                 0x80
#define _RD7                    0x80

//==============================================================================


//==============================================================================
//        TRISD Bits

extern __at(0x0F95) __sfr TRISD;

typedef union
  {
  struct
    {
    unsigned TRISD0             : 1;
    unsigned TRISD1             : 1;
    unsigned TRISD2             : 1;
    unsigned TRISD3             : 1;
    unsigned TRISD4             : 1;
    unsigned TRISD5             : 1;
    unsigned TRISD6             : 1;
    unsigned TRISD7             : 1;
    };

  struct
    {
    unsigned RD0                : 1;
    unsigned RD1                : 1;
    unsigned RD2                : 1;
    unsigned RD3                : 1;
    unsigned RD4                : 1;
    unsigned RD5                : 1;
    unsigned RD6                : 1;
    unsigned RD7                : 1;
    };
  } __TRISDbits_t;

extern __at(0x0F95) volatile __TRISDbits_t TRISDbits;

#define _TRISD_TRISD0           0x01
#define _TRISD_RD0              0x01
#define _TRISD_TRISD1           0x02
#define _TRISD_RD1              0x02
#define _TRISD_TRISD2           0x04
#define _TRISD_RD2              0x04
#define _TRISD_TRISD3           0x08
#define _TRISD_RD3              0x08
#define _TRISD_TRISD4           0x10
#define _TRISD_RD4              0x10
#define _TRISD_TRISD5           0x20
#define _TRISD_RD5              0x20
#define _TRISD_TRISD6           0x40
#define _TRISD_RD6              0x40
#define _TRISD_TRISD7           0x80
#define _TRISD_RD7              0x80

//==============================================================================


//==============================================================================
//        DDRE Bits

extern __at(0x0F96) __sfr DDRE;

typedef union
  {
  struct
    {
    unsigned TRISE0             : 1;
    unsigned TRISE1             : 1;
    unsigned TRISE2             : 1;
    unsigned TRISE3             : 1;
    unsigned TRISE4             : 1;
    unsigned TRISE5             : 1;
    unsigned TRISE6             : 1;
    unsigned TRISE7             : 1;
    };

  struct
    {
    unsigned RE0                : 1;
    unsigned RE1                : 1;
    unsigned RE2                : 1;
    unsigned RE3                : 1;
    unsigned RE4                : 1;
    unsigned RE5                : 1;
    unsigned RE6                : 1;
    unsigned RE7                : 1;
    };
  } __DDREbits_t;

extern __at(0x0F96) volatile __DDREbits_t DDREbits;

#define _TRISE0                 0x01
#define _RE0                    0x01
#define _TRISE1                 0x02
#define _RE1                    0x02
#define _TRISE2                 0x04
#define _RE2                    0x04
#define _TRISE3                 0x08
#define _RE3                    0x08
#define _TRISE4                 0x10
#define _RE4                    0x10
#define _TRISE5                 0x20
#define _RE5                    0x20
#define _TRISE6                 0x40
#define _RE6                    0x40
#define _TRISE7                 0x80
#define _RE7                    0x80

//==============================================================================


//==============================================================================
//        TRISE Bits

extern __at(0x0F96) __sfr TRISE;

typedef union
  {
  struct
    {
    unsigned TRISE0             : 1;
    unsigned TRISE1             : 1;
    unsigned TRISE2             : 1;
    unsigned TRISE3             : 1;
    unsigned TRISE4             : 1;
    unsigned TRISE5             : 1;
    unsigned TRISE6             : 1;
    unsigned TRISE7             : 1;
    };

  struct
    {
    unsigned RE0                : 1;
    unsigned RE1                : 1;
    unsigned RE2                : 1;
    unsigned RE3                : 1;
    unsigned RE4                : 1;
    unsigned RE5                : 1;
    unsigned RE6                : 1;
    unsigned RE7                : 1;
    };
  } __TRISEbits_t;

extern __at(0x0F96) volatile __TRISEbits_t TRISEbits;

#define _TRISE_TRISE0           0x01
#define _TRISE_RE0              0x01
#define _TRISE_TRISE1           0x02
#define _TRISE_RE1              0x02
#define _TRISE_TRISE2           0x04
#define _TRISE_RE2              0x04
#define _TRISE_TRISE3           0x08
#define _TRISE_RE3              0x08
#define _TRISE_TRISE4           0x10
#define _TRISE_RE4              0x10
#define _TRISE_TRISE5           0x20
#define _TRISE_RE5              0x20
#define _TRISE_TRISE6           0x40
#define _TRISE_RE6              0x40
#define _TRISE_TRISE7           0x80
#define _TRISE_RE7              0x80

//==============================================================================


//==============================================================================
//        DDRF Bits

extern __at(0x0F97) __sfr DDRF;

typedef union
  {
  struct
    {
    unsigned TRISF0             : 1;
    unsigned TRISF1             : 1;
    unsigned TRISF2             : 1;
    unsigned TRISF3             : 1;
    unsigned TRISF4             : 1;
    unsigned TRISF5             : 1;
    unsigned TRISF6             : 1;
    unsigned TRISF7             : 1;
    };

  struct
    {
    unsigned RF0                : 1;
    unsigned RF1                : 1;
    unsigned RF2                : 1;
    unsigned RF3                : 1;
    unsigned RF4                : 1;
    unsigned RF5                : 1;
    unsigned RF6                : 1;
    unsigned RF7                : 1;
    };
  } __DDRFbits_t;

extern __at(0x0F97) volatile __DDRFbits_t DDRFbits;

#define _TRISF0                 0x01
#define _RF0                    0x01
#define _TRISF1                 0x02
#define _RF1                    0x02
#define _TRISF2                 0x04
#define _RF2                    0x04
#define _TRISF3                 0x08
#define _RF3                    0x08
#define _TRISF4                 0x10
#define _RF4                    0x10
#define _TRISF5                 0x20
#define _RF5                    0x20
#define _TRISF6                 0x40
#define _RF6                    0x40
#define _TRISF7                 0x80
#define _RF7                    0x80

//==============================================================================


//==============================================================================
//        TRISF Bits

extern __at(0x0F97) __sfr TRISF;

typedef union
  {
  struct
    {
    unsigned TRISF0             : 1;
    unsigned TRISF1             : 1;
    unsigned TRISF2             : 1;
    unsigned TRISF3             : 1;
    unsigned TRISF4             : 1;
    unsigned TRISF5             : 1;
    unsigned TRISF6             : 1;
    unsigned TRISF7             : 1;
    };

  struct
    {
    unsigned RF0                : 1;
    unsigned RF1                : 1;
    unsigned RF2                : 1;
    unsigned RF3                : 1;
    unsigned RF4                : 1;
    unsigned RF5                : 1;
    unsigned RF6                : 1;
    unsigned RF7                : 1;
    };
  } __TRISFbits_t;

extern __at(0x0F97) volatile __TRISFbits_t TRISFbits;

#define _TRISF_TRISF0           0x01
#define _TRISF_RF0              0x01
#define _TRISF_TRISF1           0x02
#define _TRISF_RF1              0x02
#define _TRISF_TRISF2           0x04
#define _TRISF_RF2              0x04
#define _TRISF_TRISF3           0x08
#define _TRISF_RF3              0x08
#define _TRISF_TRISF4           0x10
#define _TRISF_RF4              0x10
#define _TRISF_TRISF5           0x20
#define _TRISF_RF5              0x20
#define _TRISF_TRISF6           0x40
#define _TRISF_RF6              0x40
#define _TRISF_TRISF7           0x80
#define _TRISF_RF7              0x80

//==============================================================================


//==============================================================================
//        DDRG Bits

extern __at(0x0F98) __sfr DDRG;

typedef union
  {
  struct
    {
    unsigned TRISG0             : 1;
    unsigned TRISG1             : 1;
    unsigned TRISG2             : 1;
    unsigned TRISG3             : 1;
    unsigned TRISG4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG0                : 1;
    unsigned RG1                : 1;
    unsigned RG2                : 1;
    unsigned RG3                : 1;
    unsigned RG4                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISG              : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned RG                 : 5;
    unsigned                    : 3;
    };
  } __DDRGbits_t;

extern __at(0x0F98) volatile __DDRGbits_t DDRGbits;

#define _TRISG0                 0x01
#define _RG0                    0x01
#define _TRISG1                 0x02
#define _RG1                    0x02
#define _TRISG2                 0x04
#define _RG2                    0x04
#define _TRISG3                 0x08
#define _RG3                    0x08
#define _TRISG4                 0x10
#define _RG4                    0x10

//==============================================================================


//==============================================================================
//        TRISG Bits

extern __at(0x0F98) __sfr TRISG;

typedef union
  {
  struct
    {
    unsigned TRISG0             : 1;
    unsigned TRISG1             : 1;
    unsigned TRISG2             : 1;
    unsigned TRISG3             : 1;
    unsigned TRISG4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RG0                : 1;
    unsigned RG1                : 1;
    unsigned RG2                : 1;
    unsigned RG3                : 1;
    unsigned RG4                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISG              : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned RG                 : 5;
    unsigned                    : 3;
    };
  } __TRISGbits_t;

extern __at(0x0F98) volatile __TRISGbits_t TRISGbits;

#define _TRISG_TRISG0           0x01
#define _TRISG_RG0              0x01
#define _TRISG_TRISG1           0x02
#define _TRISG_RG1              0x02
#define _TRISG_TRISG2           0x04
#define _TRISG_RG2              0x04
#define _TRISG_TRISG3           0x08
#define _TRISG_RG3              0x08
#define _TRISG_TRISG4           0x10
#define _TRISG_RG4              0x10

//==============================================================================


//==============================================================================
//        OSCTUNE Bits

extern __at(0x0F9B) __sfr OSCTUNE;

typedef union
  {
  struct
    {
    unsigned TUN0               : 1;
    unsigned TUN1               : 1;
    unsigned TUN2               : 1;
    unsigned TUN3               : 1;
    unsigned TUN4               : 1;
    unsigned                    : 1;
    unsigned PLLEN              : 1;
    unsigned INTSRC             : 1;
    };

  struct
    {
    unsigned TUN                : 5;
    unsigned                    : 3;
    };
  } __OSCTUNEbits_t;

extern __at(0x0F9B) volatile __OSCTUNEbits_t OSCTUNEbits;

#define _TUN0                   0x01
#define _TUN1                   0x02
#define _TUN2                   0x04
#define _TUN3                   0x08
#define _TUN4                   0x10
#define _PLLEN                  0x40
#define _INTSRC                 0x80

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x0F9D) __sfr PIE1;

typedef union
  {
  struct
    {
    unsigned TMR1IE             : 1;
    unsigned TMR2IE             : 1;
    unsigned CCP1IE             : 1;
    unsigned SSP1IE             : 1;
    unsigned TX1IE              : 1;
    unsigned RC1IE              : 1;
    unsigned ADIE               : 1;
    unsigned PSPIE              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SSPIE              : 1;
    unsigned TXIE               : 1;
    unsigned RCIE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIE1bits_t;

extern __at(0x0F9D) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _CCP1IE                 0x04
#define _SSP1IE                 0x08
#define _SSPIE                  0x08
#define _TX1IE                  0x10
#define _TXIE                   0x10
#define _RC1IE                  0x20
#define _RCIE                   0x20
#define _ADIE                   0x40
#define _PSPIE                  0x80

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x0F9E) __sfr PIR1;

typedef union
  {
  struct
    {
    unsigned TMR1IF             : 1;
    unsigned TMR2IF             : 1;
    unsigned CCP1IF             : 1;
    unsigned SSP1IF             : 1;
    unsigned TX1IF              : 1;
    unsigned RC1IF              : 1;
    unsigned ADIF               : 1;
    unsigned PSPIF              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SSPIF              : 1;
    unsigned TXIF               : 1;
    unsigned RCIF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIR1bits_t;

extern __at(0x0F9E) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _CCP1IF                 0x04
#define _SSP1IF                 0x08
#define _SSPIF                  0x08
#define _TX1IF                  0x10
#define _TXIF                   0x10
#define _RC1IF                  0x20
#define _RCIF                   0x20
#define _ADIF                   0x40
#define _PSPIF                  0x80

//==============================================================================


//==============================================================================
//        IPR1 Bits

extern __at(0x0F9F) __sfr IPR1;

typedef union
  {
  struct
    {
    unsigned TMR1IP             : 1;
    unsigned TMR2IP             : 1;
    unsigned CCP1IP             : 1;
    unsigned SSP1IP             : 1;
    unsigned TX1IP              : 1;
    unsigned RC1IP              : 1;
    unsigned ADIP               : 1;
    unsigned PSPIP              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SSPIP              : 1;
    unsigned TXIP               : 1;
    unsigned RCIP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __IPR1bits_t;

extern __at(0x0F9F) volatile __IPR1bits_t IPR1bits;

#define _TMR1IP                 0x01
#define _TMR2IP                 0x02
#define _CCP1IP                 0x04
#define _SSP1IP                 0x08
#define _SSPIP                  0x08
#define _TX1IP                  0x10
#define _TXIP                   0x10
#define _RC1IP                  0x20
#define _RCIP                   0x20
#define _ADIP                   0x40
#define _PSPIP                  0x80

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0FA0) __sfr PIE2;

typedef union
  {
  struct
    {
    unsigned CCP2IE             : 1;
    unsigned TMR3IE             : 1;
    unsigned HLVDIE             : 1;
    unsigned BCL1IE             : 1;
    unsigned EEIE               : 1;
    unsigned                    : 1;
    unsigned CMIE               : 1;
    unsigned OSCFIE             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LVDIE              : 1;
    unsigned BCLIE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIE2bits_t;

extern __at(0x0FA0) volatile __PIE2bits_t PIE2bits;

#define _CCP2IE                 0x01
#define _TMR3IE                 0x02
#define _HLVDIE                 0x04
#define _LVDIE                  0x04
#define _BCL1IE                 0x08
#define _BCLIE                  0x08
#define _EEIE                   0x10
#define _CMIE                   0x40
#define _OSCFIE                 0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x0FA1) __sfr PIR2;

typedef union
  {
  struct
    {
    unsigned CCP2IF             : 1;
    unsigned TMR3IF             : 1;
    unsigned HLVDIF             : 1;
    unsigned BCL1IF             : 1;
    unsigned EEIF               : 1;
    unsigned                    : 1;
    unsigned CMIF               : 1;
    unsigned OSCFIF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LVDIF              : 1;
    unsigned BCLIF              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIR2bits_t;

extern __at(0x0FA1) volatile __PIR2bits_t PIR2bits;

#define _CCP2IF                 0x01
#define _TMR3IF                 0x02
#define _HLVDIF                 0x04
#define _LVDIF                  0x04
#define _BCL1IF                 0x08
#define _BCLIF                  0x08
#define _EEIF                   0x10
#define _CMIF                   0x40
#define _OSCFIF                 0x80

//==============================================================================


//==============================================================================
//        IPR2 Bits

extern __at(0x0FA2) __sfr IPR2;

typedef union
  {
  struct
    {
    unsigned CCP2IP             : 1;
    unsigned TMR3IP             : 1;
    unsigned HLVDIP             : 1;
    unsigned BCL1IP             : 1;
    unsigned EEIP               : 1;
    unsigned                    : 1;
    unsigned CMIP               : 1;
    unsigned OSCFIP             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LVDIP              : 1;
    unsigned BCLIP              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __IPR2bits_t;

extern __at(0x0FA2) volatile __IPR2bits_t IPR2bits;

#define _CCP2IP                 0x01
#define _TMR3IP                 0x02
#define _HLVDIP                 0x04
#define _LVDIP                  0x04
#define _BCL1IP                 0x08
#define _BCLIP                  0x08
#define _EEIP                   0x10
#define _CMIP                   0x40
#define _OSCFIP                 0x80

//==============================================================================


//==============================================================================
//        PIE3 Bits

extern __at(0x0FA3) __sfr PIE3;

typedef struct
  {
  unsigned CCP3IE               : 1;
  unsigned CCP4IE               : 1;
  unsigned CCP5IE               : 1;
  unsigned TMR4IE               : 1;
  unsigned TX2IE                : 1;
  unsigned RC2IE                : 1;
  unsigned BCL2IE               : 1;
  unsigned SSP2IE               : 1;
  } __PIE3bits_t;

extern __at(0x0FA3) volatile __PIE3bits_t PIE3bits;

#define _CCP3IE                 0x01
#define _CCP4IE                 0x02
#define _CCP5IE                 0x04
#define _TMR4IE                 0x08
#define _TX2IE                  0x10
#define _RC2IE                  0x20
#define _BCL2IE                 0x40
#define _SSP2IE                 0x80

//==============================================================================


//==============================================================================
//        PIR3 Bits

extern __at(0x0FA4) __sfr PIR3;

typedef struct
  {
  unsigned CCP3IF               : 1;
  unsigned CCP4IF               : 1;
  unsigned CCP5IF               : 1;
  unsigned TMR4IF               : 1;
  unsigned TX2IF                : 1;
  unsigned RC2IF                : 1;
  unsigned BCL2IF               : 1;
  unsigned SSP2IF               : 1;
  } __PIR3bits_t;

extern __at(0x0FA4) volatile __PIR3bits_t PIR3bits;

#define _CCP3IF                 0x01
#define _CCP4IF                 0x02
#define _CCP5IF                 0x04
#define _TMR4IF                 0x08
#define _TX2IF                  0x10
#define _RC2IF                  0x20
#define _BCL2IF                 0x40
#define _SSP2IF                 0x80

//==============================================================================


//==============================================================================
//        IPR3 Bits

extern __at(0x0FA5) __sfr IPR3;

typedef struct
  {
  unsigned CCP3IP               : 1;
  unsigned CCP4IP               : 1;
  unsigned CCP5IP               : 1;
  unsigned TMR4IP               : 1;
  unsigned TX2IP                : 1;
  unsigned RC2IP                : 1;
  unsigned BCL2IP               : 1;
  unsigned SSP2IP               : 1;
  } __IPR3bits_t;

extern __at(0x0FA5) volatile __IPR3bits_t IPR3bits;

#define _CCP3IP                 0x01
#define _CCP4IP                 0x02
#define _CCP5IP                 0x04
#define _TMR4IP                 0x08
#define _TX2IP                  0x10
#define _RC2IP                  0x20
#define _BCL2IP                 0x40
#define _SSP2IP                 0x80

//==============================================================================


//==============================================================================
//        EECON1 Bits

extern __at(0x0FA6) __sfr EECON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned FREE                 : 1;
  unsigned                      : 1;
  unsigned CFGS                 : 1;
  unsigned EEPGD                : 1;
  } __EECON1bits_t;

extern __at(0x0FA6) volatile __EECON1bits_t EECON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _CFGS                   0x40
#define _EEPGD                  0x80

//==============================================================================

extern __at(0x0FA7) __sfr EECON2;
extern __at(0x0FA8) __sfr EEDATA;
extern __at(0x0FA9) __sfr EEADR;
extern __at(0x0FAA) __sfr EEADRH;

//==============================================================================
//        RCSTA Bits

extern __at(0x0FAB) __sfr RCSTA;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned ADDEN              : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned RCD8               : 1;
    unsigned OERR1              : 1;
    unsigned FERR1              : 1;
    unsigned ADDEN1             : 1;
    unsigned CREN1              : 1;
    unsigned SREN1              : 1;
    unsigned RC9                : 1;
    unsigned SPEN1              : 1;
    };

  struct
    {
    unsigned RX9D1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_RC8            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RC8_9              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RX91               : 1;
    unsigned                    : 1;
    };
  } __RCSTAbits_t;

extern __at(0x0FAB) volatile __RCSTAbits_t RCSTAbits;

#define _RX9D                   0x01
#define _RCD8                   0x01
#define _RX9D1                  0x01
#define _OERR                   0x02
#define _OERR1                  0x02
#define _FERR                   0x04
#define _FERR1                  0x04
#define _ADDEN                  0x08
#define _ADDEN1                 0x08
#define _CREN                   0x10
#define _CREN1                  0x10
#define _SREN                   0x20
#define _SREN1                  0x20
#define _RX9                    0x40
#define _RC9                    0x40
#define _NOT_RC8                0x40
#define _RC8_9                  0x40
#define _RX91                   0x40
#define _SPEN                   0x80
#define _SPEN1                  0x80

//==============================================================================


//==============================================================================
//        RCSTA1 Bits

extern __at(0x0FAB) __sfr RCSTA1;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned ADDEN              : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned RCD8               : 1;
    unsigned OERR1              : 1;
    unsigned FERR1              : 1;
    unsigned ADDEN1             : 1;
    unsigned CREN1              : 1;
    unsigned SREN1              : 1;
    unsigned RC9                : 1;
    unsigned SPEN1              : 1;
    };

  struct
    {
    unsigned RX9D1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_RC8            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RC8_9              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RX91               : 1;
    unsigned                    : 1;
    };
  } __RCSTA1bits_t;

extern __at(0x0FAB) volatile __RCSTA1bits_t RCSTA1bits;

#define _RCSTA1_RX9D            0x01
#define _RCSTA1_RCD8            0x01
#define _RCSTA1_RX9D1           0x01
#define _RCSTA1_OERR            0x02
#define _RCSTA1_OERR1           0x02
#define _RCSTA1_FERR            0x04
#define _RCSTA1_FERR1           0x04
#define _RCSTA1_ADDEN           0x08
#define _RCSTA1_ADDEN1          0x08
#define _RCSTA1_CREN            0x10
#define _RCSTA1_CREN1           0x10
#define _RCSTA1_SREN            0x20
#define _RCSTA1_SREN1           0x20
#define _RCSTA1_RX9             0x40
#define _RCSTA1_RC9             0x40
#define _RCSTA1_NOT_RC8         0x40
#define _RCSTA1_RC8_9           0x40
#define _RCSTA1_RX91            0x40
#define _RCSTA1_SPEN            0x80
#define _RCSTA1_SPEN1           0x80

//==============================================================================


//==============================================================================
//        TXSTA Bits

extern __at(0x0FAC) __sfr TXSTA;

typedef union
  {
  struct
    {
    unsigned TX9D               : 1;
    unsigned TRMT               : 1;
    unsigned BRGH               : 1;
    unsigned SENDB              : 1;
    unsigned SYNC               : 1;
    unsigned TXEN               : 1;
    unsigned TX9                : 1;
    unsigned CSRC               : 1;
    };

  struct
    {
    unsigned TXD8               : 1;
    unsigned TRMT1              : 1;
    unsigned BRGH1              : 1;
    unsigned SENDB1             : 1;
    unsigned SYNC1              : 1;
    unsigned TXEN1              : 1;
    unsigned TX8_9              : 1;
    unsigned CSRC1              : 1;
    };

  struct
    {
    unsigned TX9D1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_TX8            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TX91               : 1;
    unsigned                    : 1;
    };
  } __TXSTAbits_t;

extern __at(0x0FAC) volatile __TXSTAbits_t TXSTAbits;

#define _TX9D                   0x01
#define _TXD8                   0x01
#define _TX9D1                  0x01
#define _TRMT                   0x02
#define _TRMT1                  0x02
#define _BRGH                   0x04
#define _BRGH1                  0x04
#define _SENDB                  0x08
#define _SENDB1                 0x08
#define _SYNC                   0x10
#define _SYNC1                  0x10
#define _TXEN                   0x20
#define _TXEN1                  0x20
#define _TX9                    0x40
#define _TX8_9                  0x40
#define _NOT_TX8                0x40
#define _TX91                   0x40
#define _CSRC                   0x80
#define _CSRC1                  0x80

//==============================================================================


//==============================================================================
//        TXSTA1 Bits

extern __at(0x0FAC) __sfr TXSTA1;

typedef union
  {
  struct
    {
    unsigned TX9D               : 1;
    unsigned TRMT               : 1;
    unsigned BRGH               : 1;
    unsigned SENDB              : 1;
    unsigned SYNC               : 1;
    unsigned TXEN               : 1;
    unsigned TX9                : 1;
    unsigned CSRC               : 1;
    };

  struct
    {
    unsigned TXD8               : 1;
    unsigned TRMT1              : 1;
    unsigned BRGH1              : 1;
    unsigned SENDB1             : 1;
    unsigned SYNC1              : 1;
    unsigned TXEN1              : 1;
    unsigned TX8_9              : 1;
    unsigned CSRC1              : 1;
    };

  struct
    {
    unsigned TX9D1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_TX8            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TX91               : 1;
    unsigned                    : 1;
    };
  } __TXSTA1bits_t;

extern __at(0x0FAC) volatile __TXSTA1bits_t TXSTA1bits;

#define _TXSTA1_TX9D            0x01
#define _TXSTA1_TXD8            0x01
#define _TXSTA1_TX9D1           0x01
#define _TXSTA1_TRMT            0x02
#define _TXSTA1_TRMT1           0x02
#define _TXSTA1_BRGH            0x04
#define _TXSTA1_BRGH1           0x04
#define _TXSTA1_SENDB           0x08
#define _TXSTA1_SENDB1          0x08
#define _TXSTA1_SYNC            0x10
#define _TXSTA1_SYNC1           0x10
#define _TXSTA1_TXEN            0x20
#define _TXSTA1_TXEN1           0x20
#define _TXSTA1_TX9             0x40
#define _TXSTA1_TX8_9           0x40
#define _TXSTA1_NOT_TX8         0x40
#define _TXSTA1_TX91            0x40
#define _TXSTA1_CSRC            0x80
#define _TXSTA1_CSRC1           0x80

//==============================================================================

extern __at(0x0FAD) __sfr TXREG;
extern __at(0x0FAD) __sfr TXREG1;
extern __at(0x0FAE) __sfr RCREG;
extern __at(0x0FAE) __sfr RCREG1;
extern __at(0x0FAF) __sfr SPBRG;
extern __at(0x0FAF) __sfr SPBRG1;

//==============================================================================
//        PSPCON Bits

extern __at(0x0FB0) __sfr PSPCON;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PSPMODE              : 1;
  unsigned IBOV                 : 1;
  unsigned OBF                  : 1;
  unsigned IBF                  : 1;
  } __PSPCONbits_t;

extern __at(0x0FB0) volatile __PSPCONbits_t PSPCONbits;

#define _PSPMODE                0x10
#define _IBOV                   0x20
#define _OBF                    0x40
#define _IBF                    0x80

//==============================================================================


//==============================================================================
//        T3CON Bits

extern __at(0x0FB1) __sfr T3CON;

typedef union
  {
  struct
    {
    unsigned TMR3ON             : 1;
    unsigned TMR3CS             : 1;
    unsigned NOT_T3SYNC         : 1;
    unsigned T3CCP1             : 1;
    unsigned T3CKPS0            : 1;
    unsigned T3CKPS1            : 1;
    unsigned T3CCP2             : 1;
    unsigned RD16               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T3SYNC             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T3INSYNC           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T3CKPS             : 2;
    unsigned                    : 2;
    };
  } __T3CONbits_t;

extern __at(0x0FB1) volatile __T3CONbits_t T3CONbits;

#define _T3CON_TMR3ON           0x01
#define _T3CON_TMR3CS           0x02
#define _T3CON_NOT_T3SYNC       0x04
#define _T3CON_T3SYNC           0x04
#define _T3CON_T3INSYNC         0x04
#define _T3CON_T3CCP1           0x08
#define _T3CON_T3CKPS0          0x10
#define _T3CON_T3CKPS1          0x20
#define _T3CON_T3CCP2           0x40
#define _T3CON_RD16             0x80

//==============================================================================

extern __at(0x0FB2) __sfr TMR3;
extern __at(0x0FB2) __sfr TMR3L;
extern __at(0x0FB3) __sfr TMR3H;

//==============================================================================
//        CMCON Bits

extern __at(0x0FB4) __sfr CMCON;

typedef union
  {
  struct
    {
    unsigned CM0                : 1;
    unsigned CM1                : 1;
    unsigned CM2                : 1;
    unsigned CIS                : 1;
    unsigned C1INV              : 1;
    unsigned C2INV              : 1;
    unsigned C1OUT              : 1;
    unsigned C2OUT              : 1;
    };

  struct
    {
    unsigned CM                 : 3;
    unsigned                    : 5;
    };
  } __CMCONbits_t;

extern __at(0x0FB4) volatile __CMCONbits_t CMCONbits;

#define _CM0                    0x01
#define _CM1                    0x02
#define _CM2                    0x04
#define _CIS                    0x08
#define _C1INV                  0x10
#define _C2INV                  0x20
#define _C1OUT                  0x40
#define _C2OUT                  0x80

//==============================================================================


//==============================================================================
//        CVRCON Bits

extern __at(0x0FB5) __sfr CVRCON;

typedef union
  {
  struct
    {
    unsigned CVR0               : 1;
    unsigned CVR1               : 1;
    unsigned CVR2               : 1;
    unsigned CVR3               : 1;
    unsigned CVRSS              : 1;
    unsigned CVRR               : 1;
    unsigned CVROE              : 1;
    unsigned CVREN              : 1;
    };

  struct
    {
    unsigned CVR                : 4;
    unsigned                    : 4;
    };
  } __CVRCONbits_t;

extern __at(0x0FB5) volatile __CVRCONbits_t CVRCONbits;

#define _CVR0                   0x01
#define _CVR1                   0x02
#define _CVR2                   0x04
#define _CVR3                   0x08
#define _CVRSS                  0x10
#define _CVRR                   0x20
#define _CVROE                  0x40
#define _CVREN                  0x80

//==============================================================================


//==============================================================================
//        ECCP1AS Bits

extern __at(0x0FB6) __sfr ECCP1AS;

typedef union
  {
  struct
    {
    unsigned PSS1BD0            : 1;
    unsigned PSS1BD1            : 1;
    unsigned PSS1AC0            : 1;
    unsigned PSS1AC1            : 1;
    unsigned ECCP1AS0           : 1;
    unsigned ECCP1AS1           : 1;
    unsigned ECCP1AS2           : 1;
    unsigned ECCP1ASE           : 1;
    };

  struct
    {
    unsigned PSSBD0             : 1;
    unsigned PSSBD1             : 1;
    unsigned PSSAC0             : 1;
    unsigned PSSAC1             : 1;
    unsigned ECCPAS0            : 1;
    unsigned ECCPAS1            : 1;
    unsigned ECCPAS2            : 1;
    unsigned ECCPASE            : 1;
    };

  struct
    {
    unsigned PSSBD              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned PSS1BD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS1AC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSSAC              : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ECCPAS             : 3;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ECCP1AS            : 3;
    unsigned                    : 1;
    };
  } __ECCP1ASbits_t;

extern __at(0x0FB6) volatile __ECCP1ASbits_t ECCP1ASbits;

#define _PSS1BD0                0x01
#define _PSSBD0                 0x01
#define _PSS1BD1                0x02
#define _PSSBD1                 0x02
#define _PSS1AC0                0x04
#define _PSSAC0                 0x04
#define _PSS1AC1                0x08
#define _PSSAC1                 0x08
#define _ECCP1AS0               0x10
#define _ECCPAS0                0x10
#define _ECCP1AS1               0x20
#define _ECCPAS1                0x20
#define _ECCP1AS2               0x40
#define _ECCPAS2                0x40
#define _ECCP1ASE               0x80
#define _ECCPASE                0x80

//==============================================================================


//==============================================================================
//        CCP3CON Bits

extern __at(0x0FB7) __sfr CCP3CON;

typedef union
  {
  struct
    {
    unsigned CCP3M0             : 1;
    unsigned CCP3M1             : 1;
    unsigned CCP3M2             : 1;
    unsigned CCP3M3             : 1;
    unsigned DC3B0              : 1;
    unsigned DC3B1              : 1;
    unsigned P3M0               : 1;
    unsigned P3M1               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP3Y              : 1;
    unsigned CCP3X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP3M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC3B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P3M                : 2;
    };
  } __CCP3CONbits_t;

extern __at(0x0FB7) volatile __CCP3CONbits_t CCP3CONbits;

#define _CCP3M0                 0x01
#define _CCP3M1                 0x02
#define _CCP3M2                 0x04
#define _CCP3M3                 0x08
#define _DC3B0                  0x10
#define _CCP3Y                  0x10
#define _DC3B1                  0x20
#define _CCP3X                  0x20
#define _P3M0                   0x40
#define _P3M1                   0x80

//==============================================================================


//==============================================================================
//        ECCP3CON Bits

extern __at(0x0FB7) __sfr ECCP3CON;

typedef union
  {
  struct
    {
    unsigned CCP3M0             : 1;
    unsigned CCP3M1             : 1;
    unsigned CCP3M2             : 1;
    unsigned CCP3M3             : 1;
    unsigned DC3B0              : 1;
    unsigned DC3B1              : 1;
    unsigned P3M0               : 1;
    unsigned P3M1               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP3Y              : 1;
    unsigned CCP3X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP3M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC3B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P3M                : 2;
    };
  } __ECCP3CONbits_t;

extern __at(0x0FB7) volatile __ECCP3CONbits_t ECCP3CONbits;

#define _ECCP3CON_CCP3M0        0x01
#define _ECCP3CON_CCP3M1        0x02
#define _ECCP3CON_CCP3M2        0x04
#define _ECCP3CON_CCP3M3        0x08
#define _ECCP3CON_DC3B0         0x10
#define _ECCP3CON_CCP3Y         0x10
#define _ECCP3CON_DC3B1         0x20
#define _ECCP3CON_CCP3X         0x20
#define _ECCP3CON_P3M0          0x40
#define _ECCP3CON_P3M1          0x80

//==============================================================================

extern __at(0x0FB8) __sfr CCPR3;
extern __at(0x0FB8) __sfr CCPR3L;
extern __at(0x0FB9) __sfr CCPR3H;

//==============================================================================
//        CCP2CON Bits

extern __at(0x0FBA) __sfr CCP2CON;

typedef union
  {
  struct
    {
    unsigned CCP2M0             : 1;
    unsigned CCP2M1             : 1;
    unsigned CCP2M2             : 1;
    unsigned CCP2M3             : 1;
    unsigned DC2B0              : 1;
    unsigned DC2B1              : 1;
    unsigned P2M0               : 1;
    unsigned P2M1               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP2Y              : 1;
    unsigned CCP2X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC2B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P2M                : 2;
    };
  } __CCP2CONbits_t;

extern __at(0x0FBA) volatile __CCP2CONbits_t CCP2CONbits;

#define _CCP2M0                 0x01
#define _CCP2M1                 0x02
#define _CCP2M2                 0x04
#define _CCP2M3                 0x08
#define _DC2B0                  0x10
#define _CCP2Y                  0x10
#define _DC2B1                  0x20
#define _CCP2X                  0x20
#define _P2M0                   0x40
#define _P2M1                   0x80

//==============================================================================


//==============================================================================
//        ECCP2CON Bits

extern __at(0x0FBA) __sfr ECCP2CON;

typedef union
  {
  struct
    {
    unsigned CCP2M0             : 1;
    unsigned CCP2M1             : 1;
    unsigned CCP2M2             : 1;
    unsigned CCP2M3             : 1;
    unsigned DC2B0              : 1;
    unsigned DC2B1              : 1;
    unsigned P2M0               : 1;
    unsigned P2M1               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP2Y              : 1;
    unsigned CCP2X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC2B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P2M                : 2;
    };
  } __ECCP2CONbits_t;

extern __at(0x0FBA) volatile __ECCP2CONbits_t ECCP2CONbits;

#define _ECCP2CON_CCP2M0        0x01
#define _ECCP2CON_CCP2M1        0x02
#define _ECCP2CON_CCP2M2        0x04
#define _ECCP2CON_CCP2M3        0x08
#define _ECCP2CON_DC2B0         0x10
#define _ECCP2CON_CCP2Y         0x10
#define _ECCP2CON_DC2B1         0x20
#define _ECCP2CON_CCP2X         0x20
#define _ECCP2CON_P2M0          0x40
#define _ECCP2CON_P2M1          0x80

//==============================================================================

extern __at(0x0FBB) __sfr CCPR2;
extern __at(0x0FBB) __sfr CCPR2L;
extern __at(0x0FBC) __sfr CCPR2H;

//==============================================================================
//        CCP1CON Bits

extern __at(0x0FBD) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned P1M0               : 1;
    unsigned P1M1               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP1Y              : 1;
    unsigned CCP1X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P1M                : 2;
    };
  } __CCP1CONbits_t;

extern __at(0x0FBD) volatile __CCP1CONbits_t CCP1CONbits;

#define _CCP1M0                 0x01
#define _CCP1M1                 0x02
#define _CCP1M2                 0x04
#define _CCP1M3                 0x08
#define _DC1B0                  0x10
#define _CCP1Y                  0x10
#define _DC1B1                  0x20
#define _CCP1X                  0x20
#define _P1M0                   0x40
#define _P1M1                   0x80

//==============================================================================


//==============================================================================
//        ECCP1CON Bits

extern __at(0x0FBD) __sfr ECCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned P1M0               : 1;
    unsigned P1M1               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP1Y              : 1;
    unsigned CCP1X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P1M                : 2;
    };
  } __ECCP1CONbits_t;

extern __at(0x0FBD) volatile __ECCP1CONbits_t ECCP1CONbits;

#define _ECCP1CON_CCP1M0        0x01
#define _ECCP1CON_CCP1M1        0x02
#define _ECCP1CON_CCP1M2        0x04
#define _ECCP1CON_CCP1M3        0x08
#define _ECCP1CON_DC1B0         0x10
#define _ECCP1CON_CCP1Y         0x10
#define _ECCP1CON_DC1B1         0x20
#define _ECCP1CON_CCP1X         0x20
#define _ECCP1CON_P1M0          0x40
#define _ECCP1CON_P1M1          0x80

//==============================================================================

extern __at(0x0FBE) __sfr CCPR1;
extern __at(0x0FBE) __sfr CCPR1L;
extern __at(0x0FBF) __sfr CCPR1H;

//==============================================================================
//        ADCON2 Bits

extern __at(0x0FC0) __sfr ADCON2;

typedef union
  {
  struct
    {
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    unsigned ACQT0              : 1;
    unsigned ACQT1              : 1;
    unsigned ACQT2              : 1;
    unsigned                    : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned ADCS               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned ACQT               : 3;
    unsigned                    : 2;
    };
  } __ADCON2bits_t;

extern __at(0x0FC0) volatile __ADCON2bits_t ADCON2bits;

#define _ADCS0                  0x01
#define _ADCS1                  0x02
#define _ADCS2                  0x04
#define _ACQT0                  0x08
#define _ACQT1                  0x10
#define _ACQT2                  0x20
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x0FC1) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned PCFG0              : 1;
    unsigned PCFG1              : 1;
    unsigned PCFG2              : 1;
    unsigned PCFG3              : 1;
    unsigned VCFG0              : 1;
    unsigned VCFG1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PCFG               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned VCFG               : 2;
    unsigned                    : 2;
    };
  } __ADCON1bits_t;

extern __at(0x0FC1) volatile __ADCON1bits_t ADCON1bits;

#define _PCFG0                  0x01
#define _PCFG1                  0x02
#define _PCFG2                  0x04
#define _PCFG3                  0x08
#define _VCFG0                  0x10
#define _VCFG1                  0x20

//==============================================================================


//==============================================================================
//        ADCON0 Bits

extern __at(0x0FC2) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned DONE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO_DONE            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned NOT_DONE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 4;
    unsigned                    : 2;
    };
  } __ADCON0bits_t;

extern __at(0x0FC2) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _DONE                   0x02
#define _GO_DONE                0x02
#define _GO                     0x02
#define _NOT_DONE               0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _CHS3                   0x20

//==============================================================================

extern __at(0x0FC3) __sfr ADRES;
extern __at(0x0FC3) __sfr ADRESL;
extern __at(0x0FC4) __sfr ADRESH;

//==============================================================================
//        SSP1CON2 Bits

extern __at(0x0FC5) __sfr SSP1CON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSP1CON2bits_t;

extern __at(0x0FC5) volatile __SSP1CON2bits_t SSP1CON2bits;

#define _SEN                    0x01
#define _RSEN                   0x02
#define _PEN                    0x04
#define _RCEN                   0x08
#define _ACKEN                  0x10
#define _ACKDT                  0x20
#define _ACKSTAT                0x40
#define _GCEN                   0x80

//==============================================================================


//==============================================================================
//        SSPCON2 Bits

extern __at(0x0FC5) __sfr SSPCON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSPCON2bits_t;

extern __at(0x0FC5) volatile __SSPCON2bits_t SSPCON2bits;

#define _SSPCON2_SEN            0x01
#define _SSPCON2_RSEN           0x02
#define _SSPCON2_PEN            0x04
#define _SSPCON2_RCEN           0x08
#define _SSPCON2_ACKEN          0x10
#define _SSPCON2_ACKDT          0x20
#define _SSPCON2_ACKSTAT        0x40
#define _SSPCON2_GCEN           0x80

//==============================================================================


//==============================================================================
//        SSP1CON1 Bits

extern __at(0x0FC6) __sfr SSP1CON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP1CON1bits_t;

extern __at(0x0FC6) volatile __SSP1CON1bits_t SSP1CON1bits;

#define _SSPM0                  0x01
#define _SSPM1                  0x02
#define _SSPM2                  0x04
#define _SSPM3                  0x08
#define _CKP                    0x10
#define _SSPEN                  0x20
#define _SSPOV                  0x40
#define _WCOL                   0x80

//==============================================================================


//==============================================================================
//        SSPCON1 Bits

extern __at(0x0FC6) __sfr SSPCON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCON1bits_t;

extern __at(0x0FC6) volatile __SSPCON1bits_t SSPCON1bits;

#define _SSPCON1_SSPM0          0x01
#define _SSPCON1_SSPM1          0x02
#define _SSPCON1_SSPM2          0x04
#define _SSPCON1_SSPM3          0x08
#define _SSPCON1_CKP            0x10
#define _SSPCON1_SSPEN          0x20
#define _SSPCON1_SSPOV          0x40
#define _SSPCON1_WCOL           0x80

//==============================================================================


//==============================================================================
//        SSP1STAT Bits

extern __at(0x0FC7) __sfr SSP1STAT;

typedef union
  {
  struct
    {
    unsigned BF                 : 1;
    unsigned UA                 : 1;
    unsigned R_NOT_W            : 1;
    unsigned S                  : 1;
    unsigned P                  : 1;
    unsigned D_NOT_A            : 1;
    unsigned CKE                : 1;
    unsigned SMP                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R_W                : 1;
    unsigned I2C_START          : 1;
    unsigned I2C_STOP           : 1;
    unsigned D_A                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_READ           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_DAT            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_W              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_A              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_WRITE          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_ADDRESS        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned READ_WRITE         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DATA_ADDRESS       : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R                  : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned D                  : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSP1STATbits_t;

extern __at(0x0FC7) volatile __SSP1STATbits_t SSP1STATbits;

#define _BF                     0x01
#define _UA                     0x02
#define _R_NOT_W                0x04
#define _R_W                    0x04
#define _I2C_READ               0x04
#define _NOT_W                  0x04
#define _NOT_WRITE              0x04
#define _READ_WRITE             0x04
#define _R                      0x04
#define _S                      0x08
#define _I2C_START              0x08
#define _P                      0x10
#define _I2C_STOP               0x10
#define _D_NOT_A                0x20
#define _D_A                    0x20
#define _I2C_DAT                0x20
#define _NOT_A                  0x20
#define _NOT_ADDRESS            0x20
#define _DATA_ADDRESS           0x20
#define _D                      0x20
#define _CKE                    0x40
#define _SMP                    0x80

//==============================================================================


//==============================================================================
//        SSPSTAT Bits

extern __at(0x0FC7) __sfr SSPSTAT;

typedef union
  {
  struct
    {
    unsigned BF                 : 1;
    unsigned UA                 : 1;
    unsigned R_NOT_W            : 1;
    unsigned S                  : 1;
    unsigned P                  : 1;
    unsigned D_NOT_A            : 1;
    unsigned CKE                : 1;
    unsigned SMP                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R_W                : 1;
    unsigned I2C_START          : 1;
    unsigned I2C_STOP           : 1;
    unsigned D_A                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_READ           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned I2C_DAT            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_W              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_A              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_WRITE          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_ADDRESS        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned READ_WRITE         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned DATA_ADDRESS       : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R                  : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned D                  : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSPSTATbits_t;

extern __at(0x0FC7) volatile __SSPSTATbits_t SSPSTATbits;

#define _SSPSTAT_BF             0x01
#define _SSPSTAT_UA             0x02
#define _SSPSTAT_R_NOT_W        0x04
#define _SSPSTAT_R_W            0x04
#define _SSPSTAT_I2C_READ       0x04
#define _SSPSTAT_NOT_W          0x04
#define _SSPSTAT_NOT_WRITE      0x04
#define _SSPSTAT_READ_WRITE     0x04
#define _SSPSTAT_R              0x04
#define _SSPSTAT_S              0x08
#define _SSPSTAT_I2C_START      0x08
#define _SSPSTAT_P              0x10
#define _SSPSTAT_I2C_STOP       0x10
#define _SSPSTAT_D_NOT_A        0x20
#define _SSPSTAT_D_A            0x20
#define _SSPSTAT_I2C_DAT        0x20
#define _SSPSTAT_NOT_A          0x20
#define _SSPSTAT_NOT_ADDRESS    0x20
#define _SSPSTAT_DATA_ADDRESS   0x20
#define _SSPSTAT_D              0x20
#define _SSPSTAT_CKE            0x40
#define _SSPSTAT_SMP            0x80

//==============================================================================

extern __at(0x0FC8) __sfr SSP1ADD;
extern __at(0x0FC8) __sfr SSPADD;
extern __at(0x0FC9) __sfr SSP1BUF;
extern __at(0x0FC9) __sfr SSPBUF;

//==============================================================================
//        T2CON Bits

extern __at(0x0FCA) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned T2OUTPS0           : 1;
    unsigned T2OUTPS1           : 1;
    unsigned T2OUTPS2           : 1;
    unsigned T2OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T2OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x0FCA) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _T2OUTPS0               0x08
#define _T2OUTPS1               0x10
#define _T2OUTPS2               0x20
#define _T2OUTPS3               0x40

//==============================================================================

extern __at(0x0FCB) __sfr PR2;
extern __at(0x0FCC) __sfr TMR2;

//==============================================================================
//        T1CON Bits

extern __at(0x0FCD) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned TMR1CS             : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned T1OSCEN            : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned T1RUN              : 1;
    unsigned RD16               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1SYNC             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1INSYNC           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };
  } __T1CONbits_t;

extern __at(0x0FCD) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _TMR1CS                 0x02
#define _NOT_T1SYNC             0x04
#define _T1SYNC                 0x04
#define _T1INSYNC               0x04
#define _T1OSCEN                0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _T1RUN                  0x40
#define _RD16                   0x80

//==============================================================================

extern __at(0x0FCE) __sfr TMR1;
extern __at(0x0FCE) __sfr TMR1L;
extern __at(0x0FCF) __sfr TMR1H;

//==============================================================================
//        RCON Bits

extern __at(0x0FD0) __sfr RCON;

typedef union
  {
  struct
    {
    unsigned NOT_BOR            : 1;
    unsigned NOT_POR            : 1;
    unsigned NOT_PD             : 1;
    unsigned NOT_TO             : 1;
    unsigned NOT_RI             : 1;
    unsigned                    : 1;
    unsigned SBOREN             : 1;
    unsigned IPEN               : 1;
    };

  struct
    {
    unsigned BOR                : 1;
    unsigned POR                : 1;
    unsigned PD                 : 1;
    unsigned TO                 : 1;
    unsigned RI                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __RCONbits_t;

extern __at(0x0FD0) volatile __RCONbits_t RCONbits;

#define _NOT_BOR                0x01
#define _BOR                    0x01
#define _NOT_POR                0x02
#define _POR                    0x02
#define _NOT_PD                 0x04
#define _PD                     0x04
#define _NOT_TO                 0x08
#define _TO                     0x08
#define _NOT_RI                 0x10
#define _RI                     0x10
#define _SBOREN                 0x40
#define _IPEN                   0x80

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0FD1) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SWDTE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __WDTCONbits_t;

extern __at(0x0FD1) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _SWDTE                  0x01

//==============================================================================


//==============================================================================
//        HLVDCON Bits

extern __at(0x0FD2) __sfr HLVDCON;

typedef union
  {
  struct
    {
    unsigned HLVDL0             : 1;
    unsigned HLVDL1             : 1;
    unsigned HLVDL2             : 1;
    unsigned HLVDL3             : 1;
    unsigned HLVDEN             : 1;
    unsigned IRVST              : 1;
    unsigned                    : 1;
    unsigned VDIRMAG            : 1;
    };

  struct
    {
    unsigned LVV0               : 1;
    unsigned LVV1               : 1;
    unsigned LVV2               : 1;
    unsigned LVV3               : 1;
    unsigned LVDEN              : 1;
    unsigned IVRST              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LVDL0              : 1;
    unsigned LVDL1              : 1;
    unsigned LVDL2              : 1;
    unsigned LVDL3              : 1;
    unsigned                    : 1;
    unsigned BGST               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LVV                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned HLVDL              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned LVDL               : 4;
    unsigned                    : 4;
    };
  } __HLVDCONbits_t;

extern __at(0x0FD2) volatile __HLVDCONbits_t HLVDCONbits;

#define _HLVDL0                 0x01
#define _LVV0                   0x01
#define _LVDL0                  0x01
#define _HLVDL1                 0x02
#define _LVV1                   0x02
#define _LVDL1                  0x02
#define _HLVDL2                 0x04
#define _LVV2                   0x04
#define _LVDL2                  0x04
#define _HLVDL3                 0x08
#define _LVV3                   0x08
#define _LVDL3                  0x08
#define _HLVDEN                 0x10
#define _LVDEN                  0x10
#define _IRVST                  0x20
#define _IVRST                  0x20
#define _BGST                   0x20
#define _VDIRMAG                0x80

//==============================================================================


//==============================================================================
//        LVDCON Bits

extern __at(0x0FD2) __sfr LVDCON;

typedef union
  {
  struct
    {
    unsigned HLVDL0             : 1;
    unsigned HLVDL1             : 1;
    unsigned HLVDL2             : 1;
    unsigned HLVDL3             : 1;
    unsigned HLVDEN             : 1;
    unsigned IRVST              : 1;
    unsigned                    : 1;
    unsigned VDIRMAG            : 1;
    };

  struct
    {
    unsigned LVV0               : 1;
    unsigned LVV1               : 1;
    unsigned LVV2               : 1;
    unsigned LVV3               : 1;
    unsigned LVDEN              : 1;
    unsigned IVRST              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LVDL0              : 1;
    unsigned LVDL1              : 1;
    unsigned LVDL2              : 1;
    unsigned LVDL3              : 1;
    unsigned                    : 1;
    unsigned BGST               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LVV                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned HLVDL              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned LVDL               : 4;
    unsigned                    : 4;
    };
  } __LVDCONbits_t;

extern __at(0x0FD2) volatile __LVDCONbits_t LVDCONbits;

#define _LVDCON_HLVDL0          0x01
#define _LVDCON_LVV0            0x01
#define _LVDCON_LVDL0           0x01
#define _LVDCON_HLVDL1          0x02
#define _LVDCON_LVV1            0x02
#define _LVDCON_LVDL1           0x02
#define _LVDCON_HLVDL2          0x04
#define _LVDCON_LVV2            0x04
#define _LVDCON_LVDL2           0x04
#define _LVDCON_HLVDL3          0x08
#define _LVDCON_LVV3            0x08
#define _LVDCON_LVDL3           0x08
#define _LVDCON_HLVDEN          0x10
#define _LVDCON_LVDEN           0x10
#define _LVDCON_IRVST           0x20
#define _LVDCON_IVRST           0x20
#define _LVDCON_BGST            0x20
#define _LVDCON_VDIRMAG         0x80

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x0FD3) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS0               : 1;
    unsigned SCS1               : 1;
    unsigned IOFS               : 1;
    unsigned OSTS               : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned IDLEN              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned FLTS               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SCS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned IRCF               : 3;
    unsigned                    : 1;
    };
  } __OSCCONbits_t;

extern __at(0x0FD3) volatile __OSCCONbits_t OSCCONbits;

#define _SCS0                   0x01
#define _SCS1                   0x02
#define _IOFS                   0x04
#define _FLTS                   0x04
#define _OSTS                   0x08
#define _IRCF0                  0x10
#define _IRCF1                  0x20
#define _IRCF2                  0x40
#define _IDLEN                  0x80

//==============================================================================


//==============================================================================
//        T0CON Bits

extern __at(0x0FD5) __sfr T0CON;

typedef union
  {
  struct
    {
    unsigned T0PS0              : 1;
    unsigned T0PS1              : 1;
    unsigned T0PS2              : 1;
    unsigned PSA                : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned T08BIT             : 1;
    unsigned TMR0ON             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0PS3              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T0PS               : 4;
    unsigned                    : 4;
    };
  } __T0CONbits_t;

extern __at(0x0FD5) volatile __T0CONbits_t T0CONbits;

#define _T0PS0                  0x01
#define _T0PS1                  0x02
#define _T0PS2                  0x04
#define _PSA                    0x08
#define _T0PS3                  0x08
#define _T0SE                   0x10
#define _T0CS                   0x20
#define _T08BIT                 0x40
#define _TMR0ON                 0x80

//==============================================================================

extern __at(0x0FD6) __sfr TMR0;
extern __at(0x0FD6) __sfr TMR0L;
extern __at(0x0FD7) __sfr TMR0H;

//==============================================================================
//        STATUS Bits

extern __at(0x0FD8) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned OV                   : 1;
  unsigned N                    : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0FD8) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _OV                     0x08
#define _N                      0x10

//==============================================================================

extern __at(0x0FD9) __sfr FSR2L;
extern __at(0x0FDA) __sfr FSR2H;
extern __at(0x0FDB) __sfr PLUSW2;
extern __at(0x0FDC) __sfr PREINC2;
extern __at(0x0FDD) __sfr POSTDEC2;
extern __at(0x0FDE) __sfr POSTINC2;
extern __at(0x0FDF) __sfr INDF2;
extern __at(0x0FE0) __sfr BSR;
extern __at(0x0FE1) __sfr FSR1L;
extern __at(0x0FE2) __sfr FSR1H;
extern __at(0x0FE3) __sfr PLUSW1;
extern __at(0x0FE4) __sfr PREINC1;
extern __at(0x0FE5) __sfr POSTDEC1;
extern __at(0x0FE6) __sfr POSTINC1;
extern __at(0x0FE7) __sfr INDF1;
extern __at(0x0FE8) __sfr WREG;
extern __at(0x0FE9) __sfr FSR0L;
extern __at(0x0FEA) __sfr FSR0H;
extern __at(0x0FEB) __sfr PLUSW0;
extern __at(0x0FEC) __sfr PREINC0;
extern __at(0x0FED) __sfr POSTDEC0;
extern __at(0x0FEE) __sfr POSTINC0;
extern __at(0x0FEF) __sfr INDF0;

//==============================================================================
//        INTCON3 Bits

extern __at(0x0FF0) __sfr INTCON3;

typedef union
  {
  struct
    {
    unsigned INT1IF             : 1;
    unsigned INT2IF             : 1;
    unsigned INT3IF             : 1;
    unsigned INT1IE             : 1;
    unsigned INT2IE             : 1;
    unsigned INT3IE             : 1;
    unsigned INT1IP             : 1;
    unsigned INT2IP             : 1;
    };

  struct
    {
    unsigned INT1F              : 1;
    unsigned INT2F              : 1;
    unsigned INT3F              : 1;
    unsigned INT1E              : 1;
    unsigned INT2E              : 1;
    unsigned INT3E              : 1;
    unsigned INT1P              : 1;
    unsigned INT2P              : 1;
    };
  } __INTCON3bits_t;

extern __at(0x0FF0) volatile __INTCON3bits_t INTCON3bits;

#define _INT1IF                 0x01
#define _INT1F                  0x01
#define _INT2IF                 0x02
#define _INT2F                  0x02
#define _INT3IF                 0x04
#define _INT3F                  0x04
#define _INT1IE                 0x08
#define _INT1E                  0x08
#define _INT2IE                 0x10
#define _INT2E                  0x10
#define _INT3IE                 0x20
#define _INT3E                  0x20
#define _INT1IP                 0x40
#define _INT1P                  0x40
#define _INT2IP                 0x80
#define _INT2P                  0x80

//==============================================================================


//==============================================================================
//        INTCON2 Bits

extern __at(0x0FF1) __sfr INTCON2;

typedef union
  {
  struct
    {
    unsigned RBIP               : 1;
    unsigned INT3IP             : 1;
    unsigned TMR0IP             : 1;
    unsigned INTEDG3            : 1;
    unsigned INTEDG2            : 1;
    unsigned INTEDG1            : 1;
    unsigned INTEDG0            : 1;
    unsigned NOT_RBPU           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned INT3P              : 1;
    unsigned T0IP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RBPU               : 1;
    };
  } __INTCON2bits_t;

extern __at(0x0FF1) volatile __INTCON2bits_t INTCON2bits;

#define _RBIP                   0x01
#define _INT3IP                 0x02
#define _INT3P                  0x02
#define _TMR0IP                 0x04
#define _T0IP                   0x04
#define _INTEDG3                0x08
#define _INTEDG2                0x10
#define _INTEDG1                0x20
#define _INTEDG0                0x40
#define _NOT_RBPU               0x80
#define _RBPU                   0x80

//==============================================================================


//==============================================================================
//        INTCON Bits

extern __at(0x0FF2) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned RBIF               : 1;
    unsigned INT0IF             : 1;
    unsigned TMR0IF             : 1;
    unsigned RBIE               : 1;
    unsigned INT0IE             : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE_GIEL          : 1;
    unsigned GIE_GIEH           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned INT0F              : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned INT0E              : 1;
    unsigned T0IE               : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GIEL               : 1;
    unsigned GIEH               : 1;
    };
  } __INTCONbits_t;

extern __at(0x0FF2) volatile __INTCONbits_t INTCONbits;

#define _RBIF                   0x01
#define _INT0IF                 0x02
#define _INT0F                  0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _RBIE                   0x08
#define _INT0IE                 0x10
#define _INT0E                  0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE_GIEL              0x40
#define _PEIE                   0x40
#define _GIEL                   0x40
#define _GIE_GIEH               0x80
#define _GIE                    0x80
#define _GIEH                   0x80

//==============================================================================

extern __at(0x0FF3) __sfr PROD;
extern __at(0x0FF3) __sfr PRODL;
extern __at(0x0FF4) __sfr PRODH;
extern __at(0x0FF5) __sfr TABLAT;
extern __at(0x0FF6) __sfr TBLPTR;
extern __at(0x0FF6) __sfr TBLPTRL;
extern __at(0x0FF7) __sfr TBLPTRH;
extern __at(0x0FF8) __sfr TBLPTRU;
extern __at(0x0FF9) __sfr PC;
extern __at(0x0FF9) __sfr PCL;
extern __at(0x0FFA) __sfr PCLATH;
extern __at(0x0FFB) __sfr PCLATU;

//==============================================================================
//        STKPTR Bits

extern __at(0x0FFC) __sfr STKPTR;

typedef union
  {
  struct
    {
    unsigned STKPTR0            : 1;
    unsigned STKPTR1            : 1;
    unsigned STKPTR2            : 1;
    unsigned STKPTR3            : 1;
    unsigned STKPTR4            : 1;
    unsigned                    : 1;
    unsigned STKUNF             : 1;
    unsigned STKFUL             : 1;
    };

  struct
    {
    unsigned SP0                : 1;
    unsigned SP1                : 1;
    unsigned SP2                : 1;
    unsigned SP3                : 1;
    unsigned SP4                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned STKOVF             : 1;
    };

  struct
    {
    unsigned STKPTR             : 5;
    unsigned                    : 3;
    };

  struct
    {
    unsigned SP                 : 5;
    unsigned                    : 3;
    };
  } __STKPTRbits_t;

extern __at(0x0FFC) volatile __STKPTRbits_t STKPTRbits;

#define _STKPTR0                0x01
#define _SP0                    0x01
#define _STKPTR1                0x02
#define _SP1                    0x02
#define _STKPTR2                0x04
#define _SP2                    0x04
#define _STKPTR3                0x08
#define _SP3                    0x08
#define _STKPTR4                0x10
#define _SP4                    0x10
#define _STKUNF                 0x40
#define _STKFUL                 0x80
#define _STKOVF                 0x80

//==============================================================================

extern __at(0x0FFD) __sfr TOS;
extern __at(0x0FFD) __sfr TOSL;
extern __at(0x0FFE) __sfr TOSH;
extern __at(0x0FFF) __sfr TOSU;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define __CONFIG1H              0x300001
#define __CONFIG2L              0x300002
#define __CONFIG2H              0x300003
#define __CONFIG3H              0x300005
#define __CONFIG4L              0x300006
#define __CONFIG5L              0x300008
#define __CONFIG5H              0x300009
#define __CONFIG6L              0x30000A
#define __CONFIG6H              0x30000B
#define __CONFIG7L              0x30000C
#define __CONFIG7H              0x30000D

//----------------------------- CONFIG1H Options -------------------------------

#define _OSC_LP_1H              0xF0    // LP oscillator.
#define _OSC_XT_1H              0xF1    // XT oscillator.
#define _OSC_HS_1H              0xF2    // HS oscillator.
#define _OSC_RC_1H              0xF3    // External RC oscillator, CLKO function on RA6.
#define _OSC_EC_1H              0xF4    // EC oscillator, CLKO function on RA6.
#define _OSC_ECIO6_1H           0xF5    // EC oscillator, port function on RA6.
#define _OSC_HSPLL_1H           0xF6    // HS oscillator, PLL enabled (Clock Frequency = 4 x FOSC1).
#define _OSC_RCIO6_1H           0xF7    // External RC oscillator, port function on RA6.
#define _OSC_INTIO67_1H         0xF8    // Internal oscillator block, port function on RA6 and RA7.
#define _OSC_INTIO7_1H          0xF9    // Internal oscillator block, CLKO function on RA6, port function on RA7.
#define _FCMEN_OFF_1H           0xBF    // Fail-Safe Clock Monitor disabled.
#define _FCMEN_ON_1H            0xFF    // Fail-Safe Clock Monitor enabled.
#define _IESO_OFF_1H            0x7F    // Two-Speed Start-up disabled.
#define _IESO_ON_1H             0xFF    // Two-Speed Start-up enabled.

//----------------------------- CONFIG2L Options -------------------------------

#define _PWRT_ON_2L             0xFE    // PWRT enabled.
#define _PWRT_OFF_2L            0xFF    // PWRT disabled.
#define _BOREN_OFF_2L           0xF9    // Brown-out Reset disabled in hardware and software.
#define _BOREN_ON_2L            0xFB    // Brown-out Reset enabled and controlled by software (SBOREN is enabled).
#define _BOREN_NOSLP_2L         0xFD    // Brown-out Reset enabled in hardware only and disabled in Sleep mode (SBOREN is disabled).
#define _BOREN_SBORDIS_2L       0xFF    // Brown-out Reset enabled in hardware only (SBOREN is disabled).
#define _BORV_0_2L              0xE7    // Maximum setting.
#define _BORV_1_2L              0xEF    
#define _BORV_2_2L              0xF7    
#define _BORV_3_2L              0xFF    // Minimum setting.

//----------------------------- CONFIG2H Options -------------------------------

#define _WDT_OFF_2H             0xFE    // WDT disabled (control is placed on the SWDTEN bit).
#define _WDT_ON_2H              0xFF    // WDT enabled.
#define _WDTPS_1_2H             0xE1    // 1:1.
#define _WDTPS_2_2H             0xE3    // 1:2.
#define _WDTPS_4_2H             0xE5    // 1:4.
#define _WDTPS_8_2H             0xE7    // 1:8.
#define _WDTPS_16_2H            0xE9    // 1:16.
#define _WDTPS_32_2H            0xEB    // 1:32.
#define _WDTPS_64_2H            0xED    // 1:64.
#define _WDTPS_128_2H           0xEF    // 1:128.
#define _WDTPS_256_2H           0xF1    // 1:256.
#define _WDTPS_512_2H           0xF3    // 1:512.
#define _WDTPS_1024_2H          0xF5    // 1:1024.
#define _WDTPS_2048_2H          0xF7    // 1:2048.
#define _WDTPS_4096_2H          0xF9    // 1:4096.
#define _WDTPS_8192_2H          0xFB    // 1:8192.
#define _WDTPS_16384_2H         0xFD    // 1:16384.
#define _WDTPS_32768_2H         0xFF    // 1:32768.

//----------------------------- CONFIG3H Options -------------------------------

#define _CCP2MX_PORTE_3H        0xFE    // ECCP2 input/output is multiplexed with RE7.
#define _CCP2MX_PORTC_3H        0xFF    // ECCP2 input/output is multiplexed with RC1.
#define _LPT1OSC_OFF_3H         0xFB    // Timer1 configured for higher power operation.
#define _LPT1OSC_ON_3H          0xFF    // Timer1 configured for low-power operation.
#define _MCLRE_OFF_3H           0x7F    // RG5 input pin enabled; MCLR disabled.
#define _MCLRE_ON_3H            0xFF    // MCLR pin enabled; RG5 input pin disabled.

//----------------------------- CONFIG4L Options -------------------------------

#define _STVREN_OFF_4L          0xFE    // Stack full/underflow will not cause Reset.
#define _STVREN_ON_4L           0xFF    // Stack full/underflow will cause Reset.
#define _LVP_OFF_4L             0xFB    // Single-Supply ICSP disabled.
#define _LVP_ON_4L              0xFF    // Single-Supply ICSP enabled.
#define _BBSIZ_BB2K_4L          0xCF    // 1K word (2 Kbytes) Boot Block size.
#define _BBSIZ_BB4K_4L          0xDF    // 2K words (4 Kbytes) Boot Block size.
#define _BBSIZ_BB8K_4L          0xEF    // 4K words (8 Kbytes) Boot Block size.
#define _XINST_OFF_4L           0xBF    // Instruction set extension and Indexed Addressing mode disabled (Legacy mode).
#define _XINST_ON_4L            0xFF    // Instruction set extension and Indexed Addressing mode enabled.
#define _DEBUG_ON_4L            0x7F    // Background debugger enabled, RB6 and RB7 are dedicated to In-Circuit Debug.
#define _DEBUG_OFF_4L           0xFF    // Background debugger disabled, RB6 and RB7 configured as general purpose I/O pins.

//----------------------------- CONFIG5L Options -------------------------------

#define _CP0_ON_5L              0xFE    // Block 0 (000800, 001000 or 002000-003FFFh) code-protected.
#define _CP0_OFF_5L             0xFF    // Block 0 (000800, 001000 or 002000-003FFFh) not code-protected.
#define _CP1_ON_5L              0xFD    // Block 1 (004000-007FFFh) code-protected.
#define _CP1_OFF_5L             0xFF    // Block 1 (004000-007FFFh) not code-protected.
#define _CP2_ON_5L              0xFB    // Block 2 (008000-00BFFFh) code-protected.
#define _CP2_OFF_5L             0xFF    // Block 2 (008000-00BFFFh) not code-protected.
#define _CP3_ON_5L              0xF7    // Block 3 (00C000-00FFFFh) code-protected.
#define _CP3_OFF_5L             0xFF    // Block 3 (00C000-00FFFFh) not code-protected.
#define _CP4_ON_5L              0xEF    // Block 4 (010000-013FFFh) code-protected.
#define _CP4_OFF_5L             0xFF    // Block 4 (010000-013FFFh) not code-protected.
#define _CP5_ON_5L              0xDF    // Block 5 (014000-017FFFh) code-protected.
#define _CP5_OFF_5L             0xFF    // Block 5 (014000-017FFFh) not code-protected.
#define _CP6_ON_5L              0xBF    // Block 6 (01BFFF-018000h) code-protected.
#define _CP6_OFF_5L             0xFF    // Block 6 (01BFFF-018000h) not code-protected.
#define _CP7_ON_5L              0x7F    // Block 7 (01C000-01FFFFh) code-protected.
#define _CP7_OFF_5L             0xFF    // Block 7 (01C000-01FFFFh) not code-protected.

//----------------------------- CONFIG5H Options -------------------------------

#define _CPB_ON_5H              0xBF    // Boot Block (000000-0007FFh) code-protected.
#define _CPB_OFF_5H             0xFF    // Boot Block (000000-0007FFh) not code-protected.
#define _CPD_ON_5H              0x7F    // Data EEPROM code-protected.
#define _CPD_OFF_5H             0xFF    // Data EEPROM not code-protected.

//----------------------------- CONFIG6L Options -------------------------------

#define _WRT0_ON_6L             0xFE    // Block 0 (000800, 001000 or 002000-003FFFh) write-protected.
#define _WRT0_OFF_6L            0xFF    // Block 0 (000800, 001000 or 002000-003FFFh) not write-protected.
#define _WRT1_ON_6L             0xFD    // Block 1 (004000-007FFFh) write-protected.
#define _WRT1_OFF_6L            0xFF    // Block 1 (004000-007FFFh) not write-protected.
#define _WRT2_ON_6L             0xFB    // Block 2 (008000-00BFFFh) write-protected.
#define _WRT2_OFF_6L            0xFF    // Block 2 (008000-00BFFFh) not write-protected.
#define _WRT3_ON_6L             0xF7    // Block 3 (00C000-00FFFFh) write-protected.
#define _WRT3_OFF_6L            0xFF    // Block 3 (00C000-00FFFFh) not write-protected.
#define _WRT4_ON_6L             0xEF    // Block 4 (010000-013FFFh) write-protected.
#define _WRT4_OFF_6L            0xFF    // Block 4 (010000-013FFFh) not write-protected.
#define _WRT5_ON_6L             0xDF    // Block 5 (014000-017FFFh) write-protected.
#define _WRT5_OFF_6L            0xFF    // Block 5 (014000-017FFFh) not write-protected.
#define _WRT6_ON_6L             0xBF    // Block 6 (01BFFF-018000h) write-protected.
#define _WRT6_OFF_6L            0xFF    // Block 6 (01BFFF-018000h) not write-protected.
#define _WRT7_ON_6L             0x7F    // Block 7 (01C000-01FFFFh) write-protected.
#define _WRT7_OFF_6L            0xFF    // Block 7 (01C000-01FFFFh) not write-protected.

//----------------------------- CONFIG6H Options -------------------------------

#define _WRTC_ON_6H             0xDF    // Configuration registers (300000-3000FFh) write-protected.
#define _WRTC_OFF_6H            0xFF    // Configuration registers (300000-3000FFh) not write-protected.
#define _WRTB_ON_6H             0xBF    // Boot Block (000000-007FFF, 000FFF or 001FFFh) write-protected.
#define _WRTB_OFF_6H            0xFF    // Boot Block (000000-007FFF, 000FFF or 001FFFh) not write-protected.
#define _WRTD_ON_6H             0x7F    // Data EEPROM write-protected.
#define _WRTD_OFF_6H            0xFF    // Data EEPROM not write-protected.

//----------------------------- CONFIG7L Options -------------------------------

#define _EBTR0_ON_7L            0xFE    // Block 0 (000800, 001000 or 002000-003FFFh) protected from table reads executed in other blocks.
#define _EBTR0_OFF_7L           0xFF    // Block 0 (000800, 001000 or 002000-003FFFh) not protected from table reads executed in other blocks.
#define _EBTR1_ON_7L            0xFD    // Block 1 (004000-007FFFh) protected from table reads executed in other blocks.
#define _EBTR1_OFF_7L           0xFF    // Block 1 (004000-007FFFh) not protected from table reads executed in other blocks.
#define _EBTR2_ON_7L            0xFB    // Block 2 (008000-00BFFFh) protected from table reads executed in other blocks.
#define _EBTR2_OFF_7L           0xFF    // Block 2 (008000-00BFFFh) not protected from table reads executed in other blocks.
#define _EBTR3_ON_7L            0xF7    // Block 3 (00C000-00FFFFh) protected from table reads executed in other blocks.
#define _EBTR3_OFF_7L           0xFF    // Block 3 (00C000-00FFFFh) not protected from table reads executed in other blocks.
#define _EBTR4_ON_7L            0xEF    // Block 4 (010000-013FFFh) protected from table reads executed in other blocks.
#define _EBTR4_OFF_7L           0xFF    // Block 4 (010000-013FFFh) not protected from table reads executed in other blocks.
#define _EBTR5_ON_7L            0xDF    // Block 5 (014000-017FFFh) protected from table reads executed in other blocks.
#define _EBTR5_OFF_7L           0xFF    // Block 5 (014000-017FFFh) not protected from table reads executed in other blocks.
#define _EBTR6_ON_7L            0xBF    // Block 6 (018000-01BFFFh) protected from table reads executed in other blocks.
#define _EBTR6_OFF_7L           0xFF    // Block 6 (018000-01BFFFh) not protected from table reads executed in other blocks.
#define _EBTR7_ON_7L            0x7F    // Block 7 (01C000-01FFFFh) protected from table reads executed in other blocks.
#define _EBTR7_OFF_7L           0xFF    // Block 7 (01C000-01FFFFh) not protected from table reads executed in other blocks.

//----------------------------- CONFIG7H Options -------------------------------

#define _EBTRB_ON_7H            0xBF    // Boot Block (000000-007FFF, 000FFF or 001FFFh) protected from table reads executed in other blocks.
#define _EBTRB_OFF_7H           0xFF    // Boot Block (000000-007FFF, 000FFF or 001FFFh) not protected from table reads executed in other blocks.

//==============================================================================

#define __DEVID1                0x3FFFFE
#define __DEVID2                0x3FFFFF

#define __IDLOC0                0x200000
#define __IDLOC1                0x200001
#define __IDLOC2                0x200002
#define __IDLOC3                0x200003
#define __IDLOC4                0x200004
#define __IDLOC5                0x200005
#define __IDLOC6                0x200006
#define __IDLOC7                0x200007

#endif // #ifndef __PIC18F6722_H__
