/*
 * This declarations of the PIC18F4450 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2014.
 *
 * This file is generated automatically by the cinc2h.pl, 2014-03-09 13:33:17 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC18F4450_H__
#define __PIC18F4450_H__

//==============================================================================

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0F66) __sfr UFRM;

//==============================================================================
//        UFRML Bits

extern __at(0x0F66) __sfr UFRML;

typedef struct
  {
  unsigned FRM0                 : 1;
  unsigned FRM1                 : 1;
  unsigned FRM2                 : 1;
  unsigned FRM3                 : 1;
  unsigned FRM4                 : 1;
  unsigned FRM5                 : 1;
  unsigned FRM6                 : 1;
  unsigned FRM7                 : 1;
  } __UFRMLbits_t;

extern __at(0x0F66) volatile __UFRMLbits_t UFRMLbits;

#define _FRM0                   0x01
#define _FRM1                   0x02
#define _FRM2                   0x04
#define _FRM3                   0x08
#define _FRM4                   0x10
#define _FRM5                   0x20
#define _FRM6                   0x40
#define _FRM7                   0x80

//==============================================================================


//==============================================================================
//        UFRMH Bits

extern __at(0x0F67) __sfr UFRMH;

typedef struct
  {
  unsigned FRM8                 : 1;
  unsigned FRM9                 : 1;
  unsigned FRM10                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UFRMHbits_t;

extern __at(0x0F67) volatile __UFRMHbits_t UFRMHbits;

#define _FRM8                   0x01
#define _FRM9                   0x02
#define _FRM10                  0x04

//==============================================================================


//==============================================================================
//        UIR Bits

extern __at(0x0F68) __sfr UIR;

typedef struct
  {
  unsigned URSTIF               : 1;
  unsigned UERRIF               : 1;
  unsigned ACTVIF               : 1;
  unsigned TRNIF                : 1;
  unsigned IDLEIF               : 1;
  unsigned STALLIF              : 1;
  unsigned SOFIF                : 1;
  unsigned                      : 1;
  } __UIRbits_t;

extern __at(0x0F68) volatile __UIRbits_t UIRbits;

#define _URSTIF                 0x01
#define _UERRIF                 0x02
#define _ACTVIF                 0x04
#define _TRNIF                  0x08
#define _IDLEIF                 0x10
#define _STALLIF                0x20
#define _SOFIF                  0x40

//==============================================================================


//==============================================================================
//        UIE Bits

extern __at(0x0F69) __sfr UIE;

typedef struct
  {
  unsigned URSTIE               : 1;
  unsigned UERRIE               : 1;
  unsigned ACTVIE               : 1;
  unsigned TRNIE                : 1;
  unsigned IDLEIE               : 1;
  unsigned STALLIE              : 1;
  unsigned SOFIE                : 1;
  unsigned                      : 1;
  } __UIEbits_t;

extern __at(0x0F69) volatile __UIEbits_t UIEbits;

#define _URSTIE                 0x01
#define _UERRIE                 0x02
#define _ACTVIE                 0x04
#define _TRNIE                  0x08
#define _IDLEIE                 0x10
#define _STALLIE                0x20
#define _SOFIE                  0x40

//==============================================================================


//==============================================================================
//        UEIR Bits

extern __at(0x0F6A) __sfr UEIR;

typedef struct
  {
  unsigned PIDEF                : 1;
  unsigned CRC5EF               : 1;
  unsigned CRC16EF              : 1;
  unsigned DFN8EF               : 1;
  unsigned BTOEF                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BTSEF                : 1;
  } __UEIRbits_t;

extern __at(0x0F6A) volatile __UEIRbits_t UEIRbits;

#define _PIDEF                  0x01
#define _CRC5EF                 0x02
#define _CRC16EF                0x04
#define _DFN8EF                 0x08
#define _BTOEF                  0x10
#define _BTSEF                  0x80

//==============================================================================


//==============================================================================
//        UEIE Bits

extern __at(0x0F6B) __sfr UEIE;

typedef struct
  {
  unsigned PIDEE                : 1;
  unsigned CRC5EE               : 1;
  unsigned CRC16EE              : 1;
  unsigned DFN8EE               : 1;
  unsigned BTOEE                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BTSEE                : 1;
  } __UEIEbits_t;

extern __at(0x0F6B) volatile __UEIEbits_t UEIEbits;

#define _PIDEE                  0x01
#define _CRC5EE                 0x02
#define _CRC16EE                0x04
#define _DFN8EE                 0x08
#define _BTOEE                  0x10
#define _BTSEE                  0x80

//==============================================================================


//==============================================================================
//        USTAT Bits

extern __at(0x0F6C) __sfr USTAT;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned PPBI               : 1;
    unsigned DIR                : 1;
    unsigned ENDP0              : 1;
    unsigned ENDP1              : 1;
    unsigned ENDP2              : 1;
    unsigned ENDP3              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 3;
    unsigned ENDP               : 4;
    unsigned                    : 1;
    };
  } __USTATbits_t;

extern __at(0x0F6C) volatile __USTATbits_t USTATbits;

#define _PPBI                   0x02
#define _DIR                    0x04
#define _ENDP0                  0x08
#define _ENDP1                  0x10
#define _ENDP2                  0x20
#define _ENDP3                  0x40

//==============================================================================


//==============================================================================
//        UCON Bits

extern __at(0x0F6D) __sfr UCON;

typedef struct
  {
  unsigned                      : 1;
  unsigned SUSPND               : 1;
  unsigned RESUME               : 1;
  unsigned USBEN                : 1;
  unsigned PKTDIS               : 1;
  unsigned SE0                  : 1;
  unsigned PPBRST               : 1;
  unsigned                      : 1;
  } __UCONbits_t;

extern __at(0x0F6D) volatile __UCONbits_t UCONbits;

#define _SUSPND                 0x02
#define _RESUME                 0x04
#define _USBEN                  0x08
#define _PKTDIS                 0x10
#define _SE0                    0x20
#define _PPBRST                 0x40

//==============================================================================


//==============================================================================
//        UADDR Bits

extern __at(0x0F6E) __sfr UADDR;

typedef union
  {
  struct
    {
    unsigned ADDR0              : 1;
    unsigned ADDR1              : 1;
    unsigned ADDR2              : 1;
    unsigned ADDR3              : 1;
    unsigned ADDR4              : 1;
    unsigned ADDR5              : 1;
    unsigned ADDR6              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADDR               : 7;
    unsigned                    : 1;
    };
  } __UADDRbits_t;

extern __at(0x0F6E) volatile __UADDRbits_t UADDRbits;

#define _ADDR0                  0x01
#define _ADDR1                  0x02
#define _ADDR2                  0x04
#define _ADDR3                  0x08
#define _ADDR4                  0x10
#define _ADDR5                  0x20
#define _ADDR6                  0x40

//==============================================================================


//==============================================================================
//        UCFG Bits

extern __at(0x0F6F) __sfr UCFG;

typedef union
  {
  struct
    {
    unsigned PPB0               : 1;
    unsigned PPB1               : 1;
    unsigned FSEN               : 1;
    unsigned UTRDIS             : 1;
    unsigned UPUEN              : 1;
    unsigned                    : 1;
    unsigned UOEMON             : 1;
    unsigned UTEYE              : 1;
    };

  struct
    {
    unsigned PPB                : 2;
    unsigned                    : 6;
    };
  } __UCFGbits_t;

extern __at(0x0F6F) volatile __UCFGbits_t UCFGbits;

#define _PPB0                   0x01
#define _PPB1                   0x02
#define _FSEN                   0x04
#define _UTRDIS                 0x08
#define _UPUEN                  0x10
#define _UOEMON                 0x40
#define _UTEYE                  0x80

//==============================================================================


//==============================================================================
//        UEP0 Bits

extern __at(0x0F70) __sfr UEP0;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP0bits_t;

extern __at(0x0F70) volatile __UEP0bits_t UEP0bits;

#define _EPSTALL                0x01
#define _EPINEN                 0x02
#define _EPOUTEN                0x04
#define _EPCONDIS               0x08
#define _EPHSHK                 0x10

//==============================================================================


//==============================================================================
//        UEP1 Bits

extern __at(0x0F71) __sfr UEP1;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP1bits_t;

extern __at(0x0F71) volatile __UEP1bits_t UEP1bits;

#define _UEP1_EPSTALL           0x01
#define _UEP1_EPINEN            0x02
#define _UEP1_EPOUTEN           0x04
#define _UEP1_EPCONDIS          0x08
#define _UEP1_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP2 Bits

extern __at(0x0F72) __sfr UEP2;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP2bits_t;

extern __at(0x0F72) volatile __UEP2bits_t UEP2bits;

#define _UEP2_EPSTALL           0x01
#define _UEP2_EPINEN            0x02
#define _UEP2_EPOUTEN           0x04
#define _UEP2_EPCONDIS          0x08
#define _UEP2_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP3 Bits

extern __at(0x0F73) __sfr UEP3;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP3bits_t;

extern __at(0x0F73) volatile __UEP3bits_t UEP3bits;

#define _UEP3_EPSTALL           0x01
#define _UEP3_EPINEN            0x02
#define _UEP3_EPOUTEN           0x04
#define _UEP3_EPCONDIS          0x08
#define _UEP3_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP4 Bits

extern __at(0x0F74) __sfr UEP4;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP4bits_t;

extern __at(0x0F74) volatile __UEP4bits_t UEP4bits;

#define _UEP4_EPSTALL           0x01
#define _UEP4_EPINEN            0x02
#define _UEP4_EPOUTEN           0x04
#define _UEP4_EPCONDIS          0x08
#define _UEP4_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP5 Bits

extern __at(0x0F75) __sfr UEP5;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP5bits_t;

extern __at(0x0F75) volatile __UEP5bits_t UEP5bits;

#define _UEP5_EPSTALL           0x01
#define _UEP5_EPINEN            0x02
#define _UEP5_EPOUTEN           0x04
#define _UEP5_EPCONDIS          0x08
#define _UEP5_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP6 Bits

extern __at(0x0F76) __sfr UEP6;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP6bits_t;

extern __at(0x0F76) volatile __UEP6bits_t UEP6bits;

#define _UEP6_EPSTALL           0x01
#define _UEP6_EPINEN            0x02
#define _UEP6_EPOUTEN           0x04
#define _UEP6_EPCONDIS          0x08
#define _UEP6_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP7 Bits

extern __at(0x0F77) __sfr UEP7;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP7bits_t;

extern __at(0x0F77) volatile __UEP7bits_t UEP7bits;

#define _UEP7_EPSTALL           0x01
#define _UEP7_EPINEN            0x02
#define _UEP7_EPOUTEN           0x04
#define _UEP7_EPCONDIS          0x08
#define _UEP7_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP8 Bits

extern __at(0x0F78) __sfr UEP8;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP8bits_t;

extern __at(0x0F78) volatile __UEP8bits_t UEP8bits;

#define _UEP8_EPSTALL           0x01
#define _UEP8_EPINEN            0x02
#define _UEP8_EPOUTEN           0x04
#define _UEP8_EPCONDIS          0x08
#define _UEP8_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP9 Bits

extern __at(0x0F79) __sfr UEP9;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP9bits_t;

extern __at(0x0F79) volatile __UEP9bits_t UEP9bits;

#define _UEP9_EPSTALL           0x01
#define _UEP9_EPINEN            0x02
#define _UEP9_EPOUTEN           0x04
#define _UEP9_EPCONDIS          0x08
#define _UEP9_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP10 Bits

extern __at(0x0F7A) __sfr UEP10;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP10bits_t;

extern __at(0x0F7A) volatile __UEP10bits_t UEP10bits;

#define _UEP10_EPSTALL          0x01
#define _UEP10_EPINEN           0x02
#define _UEP10_EPOUTEN          0x04
#define _UEP10_EPCONDIS         0x08
#define _UEP10_EPHSHK           0x10

//==============================================================================


//==============================================================================
//        UEP11 Bits

extern __at(0x0F7B) __sfr UEP11;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP11bits_t;

extern __at(0x0F7B) volatile __UEP11bits_t UEP11bits;

#define _UEP11_EPSTALL          0x01
#define _UEP11_EPINEN           0x02
#define _UEP11_EPOUTEN          0x04
#define _UEP11_EPCONDIS         0x08
#define _UEP11_EPHSHK           0x10

//==============================================================================


//==============================================================================
//        UEP12 Bits

extern __at(0x0F7C) __sfr UEP12;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP12bits_t;

extern __at(0x0F7C) volatile __UEP12bits_t UEP12bits;

#define _UEP12_EPSTALL          0x01
#define _UEP12_EPINEN           0x02
#define _UEP12_EPOUTEN          0x04
#define _UEP12_EPCONDIS         0x08
#define _UEP12_EPHSHK           0x10

//==============================================================================


//==============================================================================
//        UEP13 Bits

extern __at(0x0F7D) __sfr UEP13;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP13bits_t;

extern __at(0x0F7D) volatile __UEP13bits_t UEP13bits;

#define _UEP13_EPSTALL          0x01
#define _UEP13_EPINEN           0x02
#define _UEP13_EPOUTEN          0x04
#define _UEP13_EPCONDIS         0x08
#define _UEP13_EPHSHK           0x10

//==============================================================================


//==============================================================================
//        UEP14 Bits

extern __at(0x0F7E) __sfr UEP14;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP14bits_t;

extern __at(0x0F7E) volatile __UEP14bits_t UEP14bits;

#define _UEP14_EPSTALL          0x01
#define _UEP14_EPINEN           0x02
#define _UEP14_EPOUTEN          0x04
#define _UEP14_EPCONDIS         0x08
#define _UEP14_EPHSHK           0x10

//==============================================================================


//==============================================================================
//        UEP15 Bits

extern __at(0x0F7F) __sfr UEP15;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP15bits_t;

extern __at(0x0F7F) volatile __UEP15bits_t UEP15bits;

#define _UEP15_EPSTALL          0x01
#define _UEP15_EPINEN           0x02
#define _UEP15_EPOUTEN          0x04
#define _UEP15_EPCONDIS         0x08
#define _UEP15_EPHSHK           0x10

//==============================================================================


//==============================================================================
//        PORTA Bits

extern __at(0x0F80) __sfr PORTA;

typedef union
  {
  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned RA6                : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned AN0                : 1;
    unsigned AN1                : 1;
    unsigned AN2                : 1;
    unsigned AN3                : 1;
    unsigned T0CKI              : 1;
    unsigned AN4                : 1;
    unsigned OSC2               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned VREFM              : 1;
    unsigned VREFP              : 1;
    unsigned RCV                : 1;
    unsigned LVDIN              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned HLVDIN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA                 : 7;
    unsigned                    : 1;
    };
  } __PORTAbits_t;

extern __at(0x0F80) volatile __PORTAbits_t PORTAbits;

#define _PORTA_RA0              0x01
#define _PORTA_AN0              0x01
#define _PORTA_RA1              0x02
#define _PORTA_AN1              0x02
#define _PORTA_RA2              0x04
#define _PORTA_AN2              0x04
#define _PORTA_VREFM            0x04
#define _PORTA_RA3              0x08
#define _PORTA_AN3              0x08
#define _PORTA_VREFP            0x08
#define _PORTA_RA4              0x10
#define _PORTA_T0CKI            0x10
#define _PORTA_RCV              0x10
#define _PORTA_RA5              0x20
#define _PORTA_AN4              0x20
#define _PORTA_LVDIN            0x20
#define _PORTA_HLVDIN           0x20
#define _PORTA_RA6              0x40
#define _PORTA_OSC2             0x40

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x0F81) __sfr PORTB;

typedef union
  {
  struct
    {
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RB2                : 1;
    unsigned RB3                : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };

  struct
    {
    unsigned INT0               : 1;
    unsigned INT1               : 1;
    unsigned INT2               : 1;
    unsigned AN9                : 1;
    unsigned KBI0               : 1;
    unsigned KBI1               : 1;
    unsigned KBI2               : 1;
    unsigned KBI3               : 1;
    };

  struct
    {
    unsigned AN12               : 1;
    unsigned AN10               : 1;
    unsigned AN8                : 1;
    unsigned VPO                : 1;
    unsigned AN11               : 1;
    unsigned PGM                : 1;
    unsigned PGC                : 1;
    unsigned PGD                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned VMO                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned INT                : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 4;
    unsigned KBI                : 4;
    };
  } __PORTBbits_t;

extern __at(0x0F81) volatile __PORTBbits_t PORTBbits;

#define _PORTB_RB0              0x01
#define _PORTB_INT0             0x01
#define _PORTB_AN12             0x01
#define _PORTB_RB1              0x02
#define _PORTB_INT1             0x02
#define _PORTB_AN10             0x02
#define _PORTB_RB2              0x04
#define _PORTB_INT2             0x04
#define _PORTB_AN8              0x04
#define _PORTB_VMO              0x04
#define _PORTB_RB3              0x08
#define _PORTB_AN9              0x08
#define _PORTB_VPO              0x08
#define _PORTB_RB4              0x10
#define _PORTB_KBI0             0x10
#define _PORTB_AN11             0x10
#define _PORTB_RB5              0x20
#define _PORTB_KBI1             0x20
#define _PORTB_PGM              0x20
#define _PORTB_RB6              0x40
#define _PORTB_KBI2             0x40
#define _PORTB_PGC              0x40
#define _PORTB_RB7              0x80
#define _PORTB_KBI3             0x80
#define _PORTB_PGD              0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x0F82) __sfr PORTC;

typedef union
  {
  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned                    : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };

  struct
    {
    unsigned T1OSO              : 1;
    unsigned T1OSI              : 1;
    unsigned CCP1               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TX                 : 1;
    unsigned RX                 : 1;
    };

  struct
    {
    unsigned T1CKI              : 1;
    unsigned NOT_UOE            : 1;
    unsigned P1A                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CK                 : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned UOE                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PORTCbits_t;

extern __at(0x0F82) volatile __PORTCbits_t PORTCbits;

#define _PORTC_RC0              0x01
#define _PORTC_T1OSO            0x01
#define _PORTC_T1CKI            0x01
#define _PORTC_RC1              0x02
#define _PORTC_T1OSI            0x02
#define _PORTC_NOT_UOE          0x02
#define _PORTC_UOE              0x02
#define _PORTC_RC2              0x04
#define _PORTC_CCP1             0x04
#define _PORTC_P1A              0x04
#define _PORTC_RC4              0x10
#define _PORTC_RC5              0x20
#define _PORTC_RC6              0x40
#define _PORTC_TX               0x40
#define _PORTC_CK               0x40
#define _PORTC_RC7              0x80
#define _PORTC_RX               0x80

//==============================================================================


//==============================================================================
//        PORTD Bits

extern __at(0x0F83) __sfr PORTD;

typedef struct
  {
  unsigned RD0                  : 1;
  unsigned RD1                  : 1;
  unsigned RD2                  : 1;
  unsigned RD3                  : 1;
  unsigned RD4                  : 1;
  unsigned RD5                  : 1;
  unsigned RD6                  : 1;
  unsigned RD7                  : 1;
  } __PORTDbits_t;

extern __at(0x0F83) volatile __PORTDbits_t PORTDbits;

#define _PORTD_RD0              0x01
#define _PORTD_RD1              0x02
#define _PORTD_RD2              0x04
#define _PORTD_RD3              0x08
#define _PORTD_RD4              0x10
#define _PORTD_RD5              0x20
#define _PORTD_RD6              0x40
#define _PORTD_RD7              0x80

//==============================================================================


//==============================================================================
//        PORTE Bits

extern __at(0x0F84) __sfr PORTE;

typedef union
  {
  struct
    {
    unsigned RE0                : 1;
    unsigned RE1                : 1;
    unsigned RE2                : 1;
    unsigned RE3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned AN5                : 1;
    unsigned AN6                : 1;
    unsigned AN7                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RE                 : 4;
    unsigned                    : 4;
    };
  } __PORTEbits_t;

extern __at(0x0F84) volatile __PORTEbits_t PORTEbits;

#define _PORTE_RE0              0x01
#define _PORTE_AN5              0x01
#define _PORTE_RE1              0x02
#define _PORTE_AN6              0x02
#define _PORTE_RE2              0x04
#define _PORTE_AN7              0x04
#define _PORTE_RE3              0x08

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x0F89) __sfr LATA;

typedef union
  {
  struct
    {
    unsigned LATA0              : 1;
    unsigned LATA1              : 1;
    unsigned LATA2              : 1;
    unsigned LATA3              : 1;
    unsigned LATA4              : 1;
    unsigned LATA5              : 1;
    unsigned LATA6              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LATA               : 7;
    unsigned                    : 1;
    };
  } __LATAbits_t;

extern __at(0x0F89) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04
#define _LATA3                  0x08
#define _LATA4                  0x10
#define _LATA5                  0x20
#define _LATA6                  0x40

//==============================================================================


//==============================================================================
//        LATB Bits

extern __at(0x0F8A) __sfr LATB;

typedef struct
  {
  unsigned LATB0                : 1;
  unsigned LATB1                : 1;
  unsigned LATB2                : 1;
  unsigned LATB3                : 1;
  unsigned LATB4                : 1;
  unsigned LATB5                : 1;
  unsigned LATB6                : 1;
  unsigned LATB7                : 1;
  } __LATBbits_t;

extern __at(0x0F8A) volatile __LATBbits_t LATBbits;

#define _LATB0                  0x01
#define _LATB1                  0x02
#define _LATB2                  0x04
#define _LATB3                  0x08
#define _LATB4                  0x10
#define _LATB5                  0x20
#define _LATB6                  0x40
#define _LATB7                  0x80

//==============================================================================


//==============================================================================
//        LATC Bits

extern __at(0x0F8B) __sfr LATC;

typedef struct
  {
  unsigned LATC0                : 1;
  unsigned LATC1                : 1;
  unsigned LATC2                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned LATC6                : 1;
  unsigned LATC7                : 1;
  } __LATCbits_t;

extern __at(0x0F8B) volatile __LATCbits_t LATCbits;

#define _LATC0                  0x01
#define _LATC1                  0x02
#define _LATC2                  0x04
#define _LATC6                  0x40
#define _LATC7                  0x80

//==============================================================================


//==============================================================================
//        LATD Bits

extern __at(0x0F8C) __sfr LATD;

typedef struct
  {
  unsigned LATD0                : 1;
  unsigned LATD1                : 1;
  unsigned LATD2                : 1;
  unsigned LATD3                : 1;
  unsigned LATD4                : 1;
  unsigned LATD5                : 1;
  unsigned LATD6                : 1;
  unsigned LATD7                : 1;
  } __LATDbits_t;

extern __at(0x0F8C) volatile __LATDbits_t LATDbits;

#define _LATD0                  0x01
#define _LATD1                  0x02
#define _LATD2                  0x04
#define _LATD3                  0x08
#define _LATD4                  0x10
#define _LATD5                  0x20
#define _LATD6                  0x40
#define _LATD7                  0x80

//==============================================================================


//==============================================================================
//        LATE Bits

extern __at(0x0F8D) __sfr LATE;

typedef union
  {
  struct
    {
    unsigned LATE0              : 1;
    unsigned LATE1              : 1;
    unsigned LATE2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LATE               : 3;
    unsigned                    : 5;
    };
  } __LATEbits_t;

extern __at(0x0F8D) volatile __LATEbits_t LATEbits;

#define _LATE0                  0x01
#define _LATE1                  0x02
#define _LATE2                  0x04

//==============================================================================


//==============================================================================
//        DDRA Bits

extern __at(0x0F92) __sfr DDRA;

typedef union
  {
  struct
    {
    unsigned TRISA0             : 1;
    unsigned TRISA1             : 1;
    unsigned TRISA2             : 1;
    unsigned TRISA3             : 1;
    unsigned TRISA4             : 1;
    unsigned TRISA5             : 1;
    unsigned TRISA6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned RA6                : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA                 : 7;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISA              : 7;
    unsigned                    : 1;
    };
  } __DDRAbits_t;

extern __at(0x0F92) volatile __DDRAbits_t DDRAbits;

#define _TRISA0                 0x01
#define _RA0                    0x01
#define _TRISA1                 0x02
#define _RA1                    0x02
#define _TRISA2                 0x04
#define _RA2                    0x04
#define _TRISA3                 0x08
#define _RA3                    0x08
#define _TRISA4                 0x10
#define _RA4                    0x10
#define _TRISA5                 0x20
#define _RA5                    0x20
#define _TRISA6                 0x40
#define _RA6                    0x40

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x0F92) __sfr TRISA;

typedef union
  {
  struct
    {
    unsigned TRISA0             : 1;
    unsigned TRISA1             : 1;
    unsigned TRISA2             : 1;
    unsigned TRISA3             : 1;
    unsigned TRISA4             : 1;
    unsigned TRISA5             : 1;
    unsigned TRISA6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned RA6                : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RA                 : 7;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISA              : 7;
    unsigned                    : 1;
    };
  } __TRISAbits_t;

extern __at(0x0F92) volatile __TRISAbits_t TRISAbits;

#define _TRISA_TRISA0           0x01
#define _TRISA_RA0              0x01
#define _TRISA_TRISA1           0x02
#define _TRISA_RA1              0x02
#define _TRISA_TRISA2           0x04
#define _TRISA_RA2              0x04
#define _TRISA_TRISA3           0x08
#define _TRISA_RA3              0x08
#define _TRISA_TRISA4           0x10
#define _TRISA_RA4              0x10
#define _TRISA_TRISA5           0x20
#define _TRISA_RA5              0x20
#define _TRISA_TRISA6           0x40
#define _TRISA_RA6              0x40

//==============================================================================


//==============================================================================
//        DDRB Bits

extern __at(0x0F93) __sfr DDRB;

typedef union
  {
  struct
    {
    unsigned TRISB0             : 1;
    unsigned TRISB1             : 1;
    unsigned TRISB2             : 1;
    unsigned TRISB3             : 1;
    unsigned TRISB4             : 1;
    unsigned TRISB5             : 1;
    unsigned TRISB6             : 1;
    unsigned TRISB7             : 1;
    };

  struct
    {
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RB2                : 1;
    unsigned RB3                : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };
  } __DDRBbits_t;

extern __at(0x0F93) volatile __DDRBbits_t DDRBbits;

#define _TRISB0                 0x01
#define _RB0                    0x01
#define _TRISB1                 0x02
#define _RB1                    0x02
#define _TRISB2                 0x04
#define _RB2                    0x04
#define _TRISB3                 0x08
#define _RB3                    0x08
#define _TRISB4                 0x10
#define _RB4                    0x10
#define _TRISB5                 0x20
#define _RB5                    0x20
#define _TRISB6                 0x40
#define _RB6                    0x40
#define _TRISB7                 0x80
#define _RB7                    0x80

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x0F93) __sfr TRISB;

typedef union
  {
  struct
    {
    unsigned TRISB0             : 1;
    unsigned TRISB1             : 1;
    unsigned TRISB2             : 1;
    unsigned TRISB3             : 1;
    unsigned TRISB4             : 1;
    unsigned TRISB5             : 1;
    unsigned TRISB6             : 1;
    unsigned TRISB7             : 1;
    };

  struct
    {
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RB2                : 1;
    unsigned RB3                : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };
  } __TRISBbits_t;

extern __at(0x0F93) volatile __TRISBbits_t TRISBbits;

#define _TRISB_TRISB0           0x01
#define _TRISB_RB0              0x01
#define _TRISB_TRISB1           0x02
#define _TRISB_RB1              0x02
#define _TRISB_TRISB2           0x04
#define _TRISB_RB2              0x04
#define _TRISB_TRISB3           0x08
#define _TRISB_RB3              0x08
#define _TRISB_TRISB4           0x10
#define _TRISB_RB4              0x10
#define _TRISB_TRISB5           0x20
#define _TRISB_RB5              0x20
#define _TRISB_TRISB6           0x40
#define _TRISB_RB6              0x40
#define _TRISB_TRISB7           0x80
#define _TRISB_RB7              0x80

//==============================================================================


//==============================================================================
//        DDRC Bits

extern __at(0x0F94) __sfr DDRC;

typedef union
  {
  struct
    {
    unsigned TRISC0             : 1;
    unsigned TRISC1             : 1;
    unsigned TRISC2             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TRISC6             : 1;
    unsigned TRISC7             : 1;
    };

  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };
  } __DDRCbits_t;

extern __at(0x0F94) volatile __DDRCbits_t DDRCbits;

#define _TRISC0                 0x01
#define _RC0                    0x01
#define _TRISC1                 0x02
#define _RC1                    0x02
#define _TRISC2                 0x04
#define _RC2                    0x04
#define _TRISC6                 0x40
#define _RC6                    0x40
#define _TRISC7                 0x80
#define _RC7                    0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x0F94) __sfr TRISC;

typedef union
  {
  struct
    {
    unsigned TRISC0             : 1;
    unsigned TRISC1             : 1;
    unsigned TRISC2             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TRISC6             : 1;
    unsigned TRISC7             : 1;
    };

  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };
  } __TRISCbits_t;

extern __at(0x0F94) volatile __TRISCbits_t TRISCbits;

#define _TRISC_TRISC0           0x01
#define _TRISC_RC0              0x01
#define _TRISC_TRISC1           0x02
#define _TRISC_RC1              0x02
#define _TRISC_TRISC2           0x04
#define _TRISC_RC2              0x04
#define _TRISC_TRISC6           0x40
#define _TRISC_RC6              0x40
#define _TRISC_TRISC7           0x80
#define _TRISC_RC7              0x80

//==============================================================================


//==============================================================================
//        DDRD Bits

extern __at(0x0F95) __sfr DDRD;

typedef union
  {
  struct
    {
    unsigned TRISD0             : 1;
    unsigned TRISD1             : 1;
    unsigned TRISD2             : 1;
    unsigned TRISD3             : 1;
    unsigned TRISD4             : 1;
    unsigned TRISD5             : 1;
    unsigned TRISD6             : 1;
    unsigned TRISD7             : 1;
    };

  struct
    {
    unsigned RD0                : 1;
    unsigned RD1                : 1;
    unsigned RD2                : 1;
    unsigned RD3                : 1;
    unsigned RD4                : 1;
    unsigned RD5                : 1;
    unsigned RD6                : 1;
    unsigned RD7                : 1;
    };
  } __DDRDbits_t;

extern __at(0x0F95) volatile __DDRDbits_t DDRDbits;

#define _TRISD0                 0x01
#define _RD0                    0x01
#define _TRISD1                 0x02
#define _RD1                    0x02
#define _TRISD2                 0x04
#define _RD2                    0x04
#define _TRISD3                 0x08
#define _RD3                    0x08
#define _TRISD4                 0x10
#define _RD4                    0x10
#define _TRISD5                 0x20
#define _RD5                    0x20
#define _TRISD6                 0x40
#define _RD6                    0x40
#define _TRISD7                 0x80
#define _RD7                    0x80

//==============================================================================


//==============================================================================
//        TRISD Bits

extern __at(0x0F95) __sfr TRISD;

typedef union
  {
  struct
    {
    unsigned TRISD0             : 1;
    unsigned TRISD1             : 1;
    unsigned TRISD2             : 1;
    unsigned TRISD3             : 1;
    unsigned TRISD4             : 1;
    unsigned TRISD5             : 1;
    unsigned TRISD6             : 1;
    unsigned TRISD7             : 1;
    };

  struct
    {
    unsigned RD0                : 1;
    unsigned RD1                : 1;
    unsigned RD2                : 1;
    unsigned RD3                : 1;
    unsigned RD4                : 1;
    unsigned RD5                : 1;
    unsigned RD6                : 1;
    unsigned RD7                : 1;
    };
  } __TRISDbits_t;

extern __at(0x0F95) volatile __TRISDbits_t TRISDbits;

#define _TRISD_TRISD0           0x01
#define _TRISD_RD0              0x01
#define _TRISD_TRISD1           0x02
#define _TRISD_RD1              0x02
#define _TRISD_TRISD2           0x04
#define _TRISD_RD2              0x04
#define _TRISD_TRISD3           0x08
#define _TRISD_RD3              0x08
#define _TRISD_TRISD4           0x10
#define _TRISD_RD4              0x10
#define _TRISD_TRISD5           0x20
#define _TRISD_RD5              0x20
#define _TRISD_TRISD6           0x40
#define _TRISD_RD6              0x40
#define _TRISD_TRISD7           0x80
#define _TRISD_RD7              0x80

//==============================================================================


//==============================================================================
//        DDRE Bits

extern __at(0x0F96) __sfr DDRE;

typedef union
  {
  struct
    {
    unsigned TRISE0             : 1;
    unsigned TRISE1             : 1;
    unsigned TRISE2             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RE0                : 1;
    unsigned RE1                : 1;
    unsigned RE2                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RE                 : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned TRISE              : 3;
    unsigned                    : 5;
    };
  } __DDREbits_t;

extern __at(0x0F96) volatile __DDREbits_t DDREbits;

#define _TRISE0                 0x01
#define _RE0                    0x01
#define _TRISE1                 0x02
#define _RE1                    0x02
#define _TRISE2                 0x04
#define _RE2                    0x04

//==============================================================================


//==============================================================================
//        TRISE Bits

extern __at(0x0F96) __sfr TRISE;

typedef union
  {
  struct
    {
    unsigned TRISE0             : 1;
    unsigned TRISE1             : 1;
    unsigned TRISE2             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RE0                : 1;
    unsigned RE1                : 1;
    unsigned RE2                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RE                 : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned TRISE              : 3;
    unsigned                    : 5;
    };
  } __TRISEbits_t;

extern __at(0x0F96) volatile __TRISEbits_t TRISEbits;

#define _TRISE_TRISE0           0x01
#define _TRISE_RE0              0x01
#define _TRISE_TRISE1           0x02
#define _TRISE_RE1              0x02
#define _TRISE_TRISE2           0x04
#define _TRISE_RE2              0x04

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x0F9D) __sfr PIE1;

typedef struct
  {
  unsigned TMR1IE               : 1;
  unsigned TMR2IE               : 1;
  unsigned CCP1IE               : 1;
  unsigned                      : 1;
  unsigned TXIE                 : 1;
  unsigned RCIE                 : 1;
  unsigned ADIE                 : 1;
  unsigned                      : 1;
  } __PIE1bits_t;

extern __at(0x0F9D) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _CCP1IE                 0x04
#define _TXIE                   0x10
#define _RCIE                   0x20
#define _ADIE                   0x40

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x0F9E) __sfr PIR1;

typedef struct
  {
  unsigned TMR1IF               : 1;
  unsigned TMR2IF               : 1;
  unsigned CCP1IF               : 1;
  unsigned                      : 1;
  unsigned TXIF                 : 1;
  unsigned RCIF                 : 1;
  unsigned ADIF                 : 1;
  unsigned                      : 1;
  } __PIR1bits_t;

extern __at(0x0F9E) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _CCP1IF                 0x04
#define _TXIF                   0x10
#define _RCIF                   0x20
#define _ADIF                   0x40

//==============================================================================


//==============================================================================
//        IPR1 Bits

extern __at(0x0F9F) __sfr IPR1;

typedef struct
  {
  unsigned TMR1IP               : 1;
  unsigned TMR2IP               : 1;
  unsigned CCP1IP               : 1;
  unsigned                      : 1;
  unsigned TXIP                 : 1;
  unsigned RCIP                 : 1;
  unsigned ADIP                 : 1;
  unsigned                      : 1;
  } __IPR1bits_t;

extern __at(0x0F9F) volatile __IPR1bits_t IPR1bits;

#define _TMR1IP                 0x01
#define _TMR2IP                 0x02
#define _CCP1IP                 0x04
#define _TXIP                   0x10
#define _RCIP                   0x20
#define _ADIP                   0x40

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0FA0) __sfr PIE2;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned HLVDIE             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned USBIE              : 1;
    unsigned                    : 1;
    unsigned OSCFIE             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LVDIE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIE2bits_t;

extern __at(0x0FA0) volatile __PIE2bits_t PIE2bits;

#define _HLVDIE                 0x04
#define _LVDIE                  0x04
#define _USBIE                  0x20
#define _OSCFIE                 0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x0FA1) __sfr PIR2;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned HLVDIF             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned USBIF              : 1;
    unsigned                    : 1;
    unsigned OSCFIF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LVDIF              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PIR2bits_t;

extern __at(0x0FA1) volatile __PIR2bits_t PIR2bits;

#define _HLVDIF                 0x04
#define _LVDIF                  0x04
#define _USBIF                  0x20
#define _OSCFIF                 0x80

//==============================================================================


//==============================================================================
//        IPR2 Bits

extern __at(0x0FA2) __sfr IPR2;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned HLVDIP             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned USBIP              : 1;
    unsigned                    : 1;
    unsigned OSCFIP             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LVDIP              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __IPR2bits_t;

extern __at(0x0FA2) volatile __IPR2bits_t IPR2bits;

#define _HLVDIP                 0x04
#define _LVDIP                  0x04
#define _USBIP                  0x20
#define _OSCFIP                 0x80

//==============================================================================


//==============================================================================
//        EECON1 Bits

extern __at(0x0FA6) __sfr EECON1;

typedef struct
  {
  unsigned                      : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned FREE                 : 1;
  unsigned                      : 1;
  unsigned CFGS                 : 1;
  unsigned                      : 1;
  } __EECON1bits_t;

extern __at(0x0FA6) volatile __EECON1bits_t EECON1bits;

#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _CFGS                   0x40

//==============================================================================

extern __at(0x0FA7) __sfr EECON2;

//==============================================================================
//        RCSTA Bits

extern __at(0x0FAB) __sfr RCSTA;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned ADDEN              : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADEN               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __RCSTAbits_t;

extern __at(0x0FAB) volatile __RCSTAbits_t RCSTAbits;

#define _RX9D                   0x01
#define _OERR                   0x02
#define _FERR                   0x04
#define _ADDEN                  0x08
#define _ADEN                   0x08
#define _CREN                   0x10
#define _SREN                   0x20
#define _RX9                    0x40
#define _SPEN                   0x80

//==============================================================================


//==============================================================================
//        TXSTA Bits

extern __at(0x0FAC) __sfr TXSTA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTAbits_t;

extern __at(0x0FAC) volatile __TXSTAbits_t TXSTAbits;

#define _TX9D                   0x01
#define _TRMT                   0x02
#define _BRGH                   0x04
#define _SENDB                  0x08
#define _SYNC                   0x10
#define _TXEN                   0x20
#define _TX9                    0x40
#define _CSRC                   0x80

//==============================================================================

extern __at(0x0FAD) __sfr TXREG;
extern __at(0x0FAE) __sfr RCREG;
extern __at(0x0FAF) __sfr SPBRG;
extern __at(0x0FB0) __sfr SPBRGH;

//==============================================================================
//        BAUDCON Bits

extern __at(0x0FB8) __sfr BAUDCON;

typedef union
  {
  struct
    {
    unsigned ABDEN              : 1;
    unsigned WUE                : 1;
    unsigned                    : 1;
    unsigned BRG16              : 1;
    unsigned TXCKP              : 1;
    unsigned RXDTP              : 1;
    unsigned RCIDL              : 1;
    unsigned ABDOVF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SCKP               : 1;
    unsigned                    : 1;
    unsigned RCMT               : 1;
    unsigned                    : 1;
    };
  } __BAUDCONbits_t;

extern __at(0x0FB8) volatile __BAUDCONbits_t BAUDCONbits;

#define _ABDEN                  0x01
#define _WUE                    0x02
#define _BRG16                  0x08
#define _TXCKP                  0x10
#define _SCKP                   0x10
#define _RXDTP                  0x20
#define _RCIDL                  0x40
#define _RCMT                   0x40
#define _ABDOVF                 0x80

//==============================================================================


//==============================================================================
//        BAUDCTL Bits

extern __at(0x0FB8) __sfr BAUDCTL;

typedef union
  {
  struct
    {
    unsigned ABDEN              : 1;
    unsigned WUE                : 1;
    unsigned                    : 1;
    unsigned BRG16              : 1;
    unsigned TXCKP              : 1;
    unsigned RXDTP              : 1;
    unsigned RCIDL              : 1;
    unsigned ABDOVF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SCKP               : 1;
    unsigned                    : 1;
    unsigned RCMT               : 1;
    unsigned                    : 1;
    };
  } __BAUDCTLbits_t;

extern __at(0x0FB8) volatile __BAUDCTLbits_t BAUDCTLbits;

#define _BAUDCTL_ABDEN          0x01
#define _BAUDCTL_WUE            0x02
#define _BAUDCTL_BRG16          0x08
#define _BAUDCTL_TXCKP          0x10
#define _BAUDCTL_SCKP           0x10
#define _BAUDCTL_RXDTP          0x20
#define _BAUDCTL_RCIDL          0x40
#define _BAUDCTL_RCMT           0x40
#define _BAUDCTL_ABDOVF         0x80

//==============================================================================


//==============================================================================
//        CCP1CON Bits

extern __at(0x0FBD) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };
  } __CCP1CONbits_t;

extern __at(0x0FBD) volatile __CCP1CONbits_t CCP1CONbits;

#define _CCP1M0                 0x01
#define _CCP1M1                 0x02
#define _CCP1M2                 0x04
#define _CCP1M3                 0x08
#define _DC1B0                  0x10
#define _DC1B1                  0x20

//==============================================================================

extern __at(0x0FBE) __sfr CCPR1;
extern __at(0x0FBE) __sfr CCPR1L;
extern __at(0x0FBF) __sfr CCPR1H;

//==============================================================================
//        ADCON2 Bits

extern __at(0x0FC0) __sfr ADCON2;

typedef union
  {
  struct
    {
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    unsigned ACQT0              : 1;
    unsigned ACQT1              : 1;
    unsigned ACQT2              : 1;
    unsigned                    : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned ADCS               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned ACQT               : 3;
    unsigned                    : 2;
    };
  } __ADCON2bits_t;

extern __at(0x0FC0) volatile __ADCON2bits_t ADCON2bits;

#define _ADCS0                  0x01
#define _ADCS1                  0x02
#define _ADCS2                  0x04
#define _ACQT0                  0x08
#define _ACQT1                  0x10
#define _ACQT2                  0x20
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x0FC1) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned PCFG0              : 1;
    unsigned PCFG1              : 1;
    unsigned PCFG2              : 1;
    unsigned PCFG3              : 1;
    unsigned VCFG0              : 1;
    unsigned VCFG1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PCFG               : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned VCFG               : 2;
    unsigned                    : 2;
    };
  } __ADCON1bits_t;

extern __at(0x0FC1) volatile __ADCON1bits_t ADCON1bits;

#define _PCFG0                  0x01
#define _PCFG1                  0x02
#define _PCFG2                  0x04
#define _PCFG3                  0x08
#define _VCFG0                  0x10
#define _VCFG1                  0x20

//==============================================================================


//==============================================================================
//        ADCON0 Bits

extern __at(0x0FC2) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO_DONE            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned DONE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned NOT_DONE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 4;
    unsigned                    : 2;
    };
  } __ADCON0bits_t;

extern __at(0x0FC2) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _GO_DONE                0x02
#define _DONE                   0x02
#define _GO                     0x02
#define _NOT_DONE               0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _CHS3                   0x20

//==============================================================================

extern __at(0x0FC3) __sfr ADRES;
extern __at(0x0FC3) __sfr ADRESL;
extern __at(0x0FC4) __sfr ADRESH;

//==============================================================================
//        T2CON Bits

extern __at(0x0FCA) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned T2OUTPS0           : 1;
    unsigned T2OUTPS1           : 1;
    unsigned T2OUTPS2           : 1;
    unsigned T2OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T2OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x0FCA) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _T2OUTPS0               0x08
#define _T2OUTPS1               0x10
#define _T2OUTPS2               0x20
#define _T2OUTPS3               0x40

//==============================================================================

extern __at(0x0FCB) __sfr PR2;
extern __at(0x0FCC) __sfr TMR2;

//==============================================================================
//        T1CON Bits

extern __at(0x0FCD) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned TMR1CS             : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned T1OSCEN            : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned T1RUN              : 1;
    unsigned RD16               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1SYNC             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };
  } __T1CONbits_t;

extern __at(0x0FCD) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _TMR1CS                 0x02
#define _NOT_T1SYNC             0x04
#define _T1SYNC                 0x04
#define _T1OSCEN                0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _T1RUN                  0x40
#define _RD16                   0x80

//==============================================================================

extern __at(0x0FCE) __sfr TMR1;
extern __at(0x0FCE) __sfr TMR1L;
extern __at(0x0FCF) __sfr TMR1H;

//==============================================================================
//        RCON Bits

extern __at(0x0FD0) __sfr RCON;

typedef union
  {
  struct
    {
    unsigned NOT_BOR            : 1;
    unsigned NOT_POR            : 1;
    unsigned NOT_PD             : 1;
    unsigned NOT_TO             : 1;
    unsigned NOT_RI             : 1;
    unsigned                    : 1;
    unsigned SBOREN             : 1;
    unsigned IPEN               : 1;
    };

  struct
    {
    unsigned BOR                : 1;
    unsigned POR                : 1;
    unsigned PD                 : 1;
    unsigned TO                 : 1;
    unsigned RI                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_IPEN           : 1;
    };
  } __RCONbits_t;

extern __at(0x0FD0) volatile __RCONbits_t RCONbits;

#define _NOT_BOR                0x01
#define _BOR                    0x01
#define _NOT_POR                0x02
#define _POR                    0x02
#define _NOT_PD                 0x04
#define _PD                     0x04
#define _NOT_TO                 0x08
#define _TO                     0x08
#define _NOT_RI                 0x10
#define _RI                     0x10
#define _SBOREN                 0x40
#define _IPEN                   0x80
#define _NOT_IPEN               0x80

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0FD1) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SWDTE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __WDTCONbits_t;

extern __at(0x0FD1) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _SWDTE                  0x01

//==============================================================================


//==============================================================================
//        HLVDCON Bits

extern __at(0x0FD2) __sfr HLVDCON;

typedef union
  {
  struct
    {
    unsigned HLVDL0             : 1;
    unsigned HLVDL1             : 1;
    unsigned HLVDL2             : 1;
    unsigned HLVDL3             : 1;
    unsigned HLVDEN             : 1;
    unsigned IRVST              : 1;
    unsigned                    : 1;
    unsigned VDIRMAG            : 1;
    };

  struct
    {
    unsigned LVDL0              : 1;
    unsigned LVDL1              : 1;
    unsigned LVDL2              : 1;
    unsigned LVDL3              : 1;
    unsigned LVDEN              : 1;
    unsigned IVRST              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LVV0               : 1;
    unsigned LVV1               : 1;
    unsigned LVV2               : 1;
    unsigned LVV3               : 1;
    unsigned                    : 1;
    unsigned BGST               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LVV                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned HLVDL              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned LVDL               : 4;
    unsigned                    : 4;
    };
  } __HLVDCONbits_t;

extern __at(0x0FD2) volatile __HLVDCONbits_t HLVDCONbits;

#define _HLVDL0                 0x01
#define _LVDL0                  0x01
#define _LVV0                   0x01
#define _HLVDL1                 0x02
#define _LVDL1                  0x02
#define _LVV1                   0x02
#define _HLVDL2                 0x04
#define _LVDL2                  0x04
#define _LVV2                   0x04
#define _HLVDL3                 0x08
#define _LVDL3                  0x08
#define _LVV3                   0x08
#define _HLVDEN                 0x10
#define _LVDEN                  0x10
#define _IRVST                  0x20
#define _IVRST                  0x20
#define _BGST                   0x20
#define _VDIRMAG                0x80

//==============================================================================


//==============================================================================
//        LVDCON Bits

extern __at(0x0FD2) __sfr LVDCON;

typedef union
  {
  struct
    {
    unsigned HLVDL0             : 1;
    unsigned HLVDL1             : 1;
    unsigned HLVDL2             : 1;
    unsigned HLVDL3             : 1;
    unsigned HLVDEN             : 1;
    unsigned IRVST              : 1;
    unsigned                    : 1;
    unsigned VDIRMAG            : 1;
    };

  struct
    {
    unsigned LVDL0              : 1;
    unsigned LVDL1              : 1;
    unsigned LVDL2              : 1;
    unsigned LVDL3              : 1;
    unsigned LVDEN              : 1;
    unsigned IVRST              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LVV0               : 1;
    unsigned LVV1               : 1;
    unsigned LVV2               : 1;
    unsigned LVV3               : 1;
    unsigned                    : 1;
    unsigned BGST               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LVV                : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned HLVDL              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned LVDL               : 4;
    unsigned                    : 4;
    };
  } __LVDCONbits_t;

extern __at(0x0FD2) volatile __LVDCONbits_t LVDCONbits;

#define _LVDCON_HLVDL0          0x01
#define _LVDCON_LVDL0           0x01
#define _LVDCON_LVV0            0x01
#define _LVDCON_HLVDL1          0x02
#define _LVDCON_LVDL1           0x02
#define _LVDCON_LVV1            0x02
#define _LVDCON_HLVDL2          0x04
#define _LVDCON_LVDL2           0x04
#define _LVDCON_LVV2            0x04
#define _LVDCON_HLVDL3          0x08
#define _LVDCON_LVDL3           0x08
#define _LVDCON_LVV3            0x08
#define _LVDCON_HLVDEN          0x10
#define _LVDCON_LVDEN           0x10
#define _LVDCON_IRVST           0x20
#define _LVDCON_IVRST           0x20
#define _LVDCON_BGST            0x20
#define _LVDCON_VDIRMAG         0x80

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x0FD3) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS0               : 1;
    unsigned SCS1               : 1;
    unsigned                    : 1;
    unsigned OSTS               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned IDLEN              : 1;
    };

  struct
    {
    unsigned SCS                : 2;
    unsigned                    : 6;
    };
  } __OSCCONbits_t;

extern __at(0x0FD3) volatile __OSCCONbits_t OSCCONbits;

#define _SCS0                   0x01
#define _SCS1                   0x02
#define _OSTS                   0x08
#define _IDLEN                  0x80

//==============================================================================


//==============================================================================
//        T0CON Bits

extern __at(0x0FD5) __sfr T0CON;

typedef union
  {
  struct
    {
    unsigned T0PS0              : 1;
    unsigned T0PS1              : 1;
    unsigned T0PS2              : 1;
    unsigned PSA                : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned T08BIT             : 1;
    unsigned TMR0ON             : 1;
    };

  struct
    {
    unsigned T0PS               : 3;
    unsigned                    : 5;
    };
  } __T0CONbits_t;

extern __at(0x0FD5) volatile __T0CONbits_t T0CONbits;

#define _T0PS0                  0x01
#define _T0PS1                  0x02
#define _T0PS2                  0x04
#define _PSA                    0x08
#define _T0SE                   0x10
#define _T0CS                   0x20
#define _T08BIT                 0x40
#define _TMR0ON                 0x80

//==============================================================================

extern __at(0x0FD6) __sfr TMR0;
extern __at(0x0FD6) __sfr TMR0L;
extern __at(0x0FD7) __sfr TMR0H;

//==============================================================================
//        STATUS Bits

extern __at(0x0FD8) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned OV                   : 1;
  unsigned N                    : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0FD8) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _OV                     0x08
#define _N                      0x10

//==============================================================================

extern __at(0x0FD9) __sfr FSR2L;
extern __at(0x0FDA) __sfr FSR2H;
extern __at(0x0FDB) __sfr PLUSW2;
extern __at(0x0FDC) __sfr PREINC2;
extern __at(0x0FDD) __sfr POSTDEC2;
extern __at(0x0FDE) __sfr POSTINC2;
extern __at(0x0FDF) __sfr INDF2;
extern __at(0x0FE0) __sfr BSR;
extern __at(0x0FE1) __sfr FSR1L;
extern __at(0x0FE2) __sfr FSR1H;
extern __at(0x0FE3) __sfr PLUSW1;
extern __at(0x0FE4) __sfr PREINC1;
extern __at(0x0FE5) __sfr POSTDEC1;
extern __at(0x0FE6) __sfr POSTINC1;
extern __at(0x0FE7) __sfr INDF1;
extern __at(0x0FE8) __sfr WREG;
extern __at(0x0FE9) __sfr FSR0L;
extern __at(0x0FEA) __sfr FSR0H;
extern __at(0x0FEB) __sfr PLUSW0;
extern __at(0x0FEC) __sfr PREINC0;
extern __at(0x0FED) __sfr POSTDEC0;
extern __at(0x0FEE) __sfr POSTINC0;
extern __at(0x0FEF) __sfr INDF0;

//==============================================================================
//        INTCON3 Bits

extern __at(0x0FF0) __sfr INTCON3;

typedef union
  {
  struct
    {
    unsigned INT1IF             : 1;
    unsigned INT2IF             : 1;
    unsigned                    : 1;
    unsigned INT1IE             : 1;
    unsigned INT2IE             : 1;
    unsigned                    : 1;
    unsigned INT1IP             : 1;
    unsigned INT2IP             : 1;
    };

  struct
    {
    unsigned INT1F              : 1;
    unsigned INT2F              : 1;
    unsigned                    : 1;
    unsigned INT1E              : 1;
    unsigned INT2E              : 1;
    unsigned                    : 1;
    unsigned INT1P              : 1;
    unsigned INT2P              : 1;
    };
  } __INTCON3bits_t;

extern __at(0x0FF0) volatile __INTCON3bits_t INTCON3bits;

#define _INT1IF                 0x01
#define _INT1F                  0x01
#define _INT2IF                 0x02
#define _INT2F                  0x02
#define _INT1IE                 0x08
#define _INT1E                  0x08
#define _INT2IE                 0x10
#define _INT2E                  0x10
#define _INT1IP                 0x40
#define _INT1P                  0x40
#define _INT2IP                 0x80
#define _INT2P                  0x80

//==============================================================================


//==============================================================================
//        INTCON2 Bits

extern __at(0x0FF1) __sfr INTCON2;

typedef union
  {
  struct
    {
    unsigned RBIP               : 1;
    unsigned                    : 1;
    unsigned TMR0IP             : 1;
    unsigned                    : 1;
    unsigned INTEDG2            : 1;
    unsigned INTEDG1            : 1;
    unsigned INTEDG0            : 1;
    unsigned NOT_RBPU           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RBPU               : 1;
    };
  } __INTCON2bits_t;

extern __at(0x0FF1) volatile __INTCON2bits_t INTCON2bits;

#define _RBIP                   0x01
#define _TMR0IP                 0x04
#define _T0IP                   0x04
#define _INTEDG2                0x10
#define _INTEDG1                0x20
#define _INTEDG0                0x40
#define _NOT_RBPU               0x80
#define _RBPU                   0x80

//==============================================================================


//==============================================================================
//        INTCON Bits

extern __at(0x0FF2) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned RBIF               : 1;
    unsigned INT0IF             : 1;
    unsigned TMR0IF             : 1;
    unsigned RBIE               : 1;
    unsigned INT0IE             : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE_GIEL          : 1;
    unsigned GIE_GIEH           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned INT0F              : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned INT0E              : 1;
    unsigned T0IE               : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GIEL               : 1;
    unsigned GIEH               : 1;
    };
  } __INTCONbits_t;

extern __at(0x0FF2) volatile __INTCONbits_t INTCONbits;

#define _RBIF                   0x01
#define _INT0IF                 0x02
#define _INT0F                  0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _RBIE                   0x08
#define _INT0IE                 0x10
#define _INT0E                  0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE_GIEL              0x40
#define _PEIE                   0x40
#define _GIEL                   0x40
#define _GIE_GIEH               0x80
#define _GIE                    0x80
#define _GIEH                   0x80

//==============================================================================

extern __at(0x0FF3) __sfr PROD;
extern __at(0x0FF3) __sfr PRODL;
extern __at(0x0FF4) __sfr PRODH;
extern __at(0x0FF5) __sfr TABLAT;
extern __at(0x0FF6) __sfr TBLPTR;
extern __at(0x0FF6) __sfr TBLPTRL;
extern __at(0x0FF7) __sfr TBLPTRH;
extern __at(0x0FF8) __sfr TBLPTRU;
extern __at(0x0FF9) __sfr PC;
extern __at(0x0FF9) __sfr PCL;
extern __at(0x0FFA) __sfr PCLATH;
extern __at(0x0FFB) __sfr PCLATU;

//==============================================================================
//        STKPTR Bits

extern __at(0x0FFC) __sfr STKPTR;

typedef union
  {
  struct
    {
    unsigned STKPTR0            : 1;
    unsigned STKPTR1            : 1;
    unsigned STKPTR2            : 1;
    unsigned STKPTR3            : 1;
    unsigned STKPTR4            : 1;
    unsigned                    : 1;
    unsigned STKUNF             : 1;
    unsigned STKFUL             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned STKOVF             : 1;
    };

  struct
    {
    unsigned STKPTR             : 5;
    unsigned                    : 3;
    };
  } __STKPTRbits_t;

extern __at(0x0FFC) volatile __STKPTRbits_t STKPTRbits;

#define _STKPTR0                0x01
#define _STKPTR1                0x02
#define _STKPTR2                0x04
#define _STKPTR3                0x08
#define _STKPTR4                0x10
#define _STKUNF                 0x40
#define _STKFUL                 0x80
#define _STKOVF                 0x80

//==============================================================================

extern __at(0x0FFD) __sfr TOS;
extern __at(0x0FFD) __sfr TOSL;
extern __at(0x0FFE) __sfr TOSH;
extern __at(0x0FFF) __sfr TOSU;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define __CONFIG1L              0x300000
#define __CONFIG1H              0x300001
#define __CONFIG2L              0x300002
#define __CONFIG2H              0x300003
#define __CONFIG3H              0x300005
#define __CONFIG4L              0x300006
#define __CONFIG5L              0x300008
#define __CONFIG5H              0x300009
#define __CONFIG6L              0x30000A
#define __CONFIG6H              0x30000B
#define __CONFIG7L              0x30000C
#define __CONFIG7H              0x30000D

//----------------------------- CONFIG1L Options -------------------------------

#define _PLLDIV_1_1L            0xF8    // No prescale (4 MHz oscillator input drives PLL directly).
#define _PLLDIV_2_1L            0xF9    // Divide by 2 (8 MHz oscillator input).
#define _PLLDIV_3_1L            0xFA    // Divide by 3 (12 MHz oscillator input).
#define _PLLDIV_4_1L            0xFB    // Divide by 4 (16 MHz oscillator input).
#define _PLLDIV_5_1L            0xFC    // Divide by 5 (20 MHz oscillator input).
#define _PLLDIV_6_1L            0xFD    // Divide by 6 (24 MHz oscillator input).
#define _PLLDIV_10_1L           0xFE    // Divide by 10 (40 MHz oscillator input).
#define _PLLDIV_12_1L           0xFF    // Divide by 12 (48 MHz oscillator input).
#define _CPUDIV_OSC1_PLL2_1L    0xE7    // [Primary Oscillator Src: /1][96 MHz PLL Src: /2].
#define _CPUDIV_OSC2_PLL3_1L    0xEF    // [Primary Oscillator Src: /2][96 MHz PLL Src: /3].
#define _CPUDIV_OSC3_PLL4_1L    0xF7    // [Primary Oscillator Src: /3][96 MHz PLL Src: /4].
#define _CPUDIV_OSC4_PLL6_1L    0xFF    // [Primary Oscillator Src: /4][96 MHz PLL Src: /6].
#define _USBDIV_1_1L            0xDF    // USB clock source comes directly from the primary oscillator block with no postscale.
#define _USBDIV_2_1L            0xFF    // USB clock source comes from the 96 MHz PLL divided by 2.

//----------------------------- CONFIG1H Options -------------------------------

#define _FOSC_XT_XT_1H          0xF0    // XT oscillator (XT).
#define _FOSC_XTPLL_XT_1H       0xF2    // XT oscillator, PLL enabled (XTPLL).
#define _FOSC_ECIO_EC_1H        0xF4    // EC oscillator, port function on RA6 (ECIO).
#define _FOSC_EC_EC_1H          0xF5    // EC oscillator, CLKO function on RA6 (EC).
#define _FOSC_ECPLLIO_EC_1H     0xF6    // EC oscillator, PLL enabled, port function on RA6 (ECPIO).
#define _FOSC_ECPLL_EC_1H       0xF7    // EC oscillator, PLL enabled, CLKO function on RA6 (ECPLL).
#define _FOSC_INTOSCIO_EC_1H    0xF8    // Internal oscillator, port function on RA6, EC used by USB (INTIO).
#define _FOSC_INTOSC_EC_1H      0xF9    // Internal oscillator, CLKO function on RA6, EC used by USB (INTCKO).
#define _FOSC_INTOSC_XT_1H      0xFA    // Internal oscillator, XT used by USB (INTXT).
#define _FOSC_INTOSC_HS_1H      0xFB    // Internal oscillator, HS oscillator used by USB (INTHS).
#define _FOSC_HS_1H             0xFC    // HS oscillator (HS).
#define _FOSC_HSPLL_HS_1H       0xFE    // HS oscillator, PLL enabled (HSPLL).
#define _FCMEN_OFF_1H           0xBF    // Fail-Safe Clock Monitor disabled.
#define _FCMEN_ON_1H            0xFF    // Fail-Safe Clock Monitor enabled.
#define _IESO_OFF_1H            0x7F    // Oscillator Switchover mode disabled.
#define _IESO_ON_1H             0xFF    // Oscillator Switchover mode enabled.

//----------------------------- CONFIG2L Options -------------------------------

#define _PWRT_ON_2L             0xFE    // PWRT enabled.
#define _PWRT_OFF_2L            0xFF    // PWRT disabled.
#define _BOR_OFF_2L             0xF9    // Brown-out Reset disabled in hardware and software.
#define _BOR_SOFT_2L            0xFB    // Brown-out Reset enabled and controlled by software (SBOREN is enabled).
#define _BOR_ON_ACTIVE_2L       0xFD    // Brown-out Reset enabled in hardware only and disabled in Sleep mode (SBOREN is disabled).
#define _BOR_ON_2L              0xFF    // Brown-out Reset enabled in hardware only (SBOREN is disabled).
#define _BORV_46_2L             0xE7    // 4.6V.
#define _BORV_43_2L             0xEF    // 4.3V.
#define _BORV_28_2L             0xF7    // 2.8V.
#define _BORV_21_2L             0xFF    // 2.1V.
#define _VREGEN_OFF_2L          0xDF    // USB voltage regulator disabled.
#define _VREGEN_ON_2L           0xFF    // USB voltage regulator enabled.

//----------------------------- CONFIG2H Options -------------------------------

#define _WDT_OFF_2H             0xFE    // WDT disabled (control is placed on the SWDTEN bit).
#define _WDT_ON_2H              0xFF    // WDT enabled.
#define _WDTPS_1_2H             0xE1    // 1:1.
#define _WDTPS_2_2H             0xE3    // 1:2.
#define _WDTPS_4_2H             0xE5    // 1:4.
#define _WDTPS_8_2H             0xE7    // 1:8.
#define _WDTPS_16_2H            0xE9    // 1:16.
#define _WDTPS_32_2H            0xEB    // 1:32.
#define _WDTPS_64_2H            0xED    // 1:64.
#define _WDTPS_128_2H           0xEF    // 1:128.
#define _WDTPS_256_2H           0xF1    // 1:256.
#define _WDTPS_512_2H           0xF3    // 1:512.
#define _WDTPS_1024_2H          0xF5    // 1:1024.
#define _WDTPS_2048_2H          0xF7    // 1:2048.
#define _WDTPS_4096_2H          0xF9    // 1:4096.
#define _WDTPS_8192_2H          0xFB    // 1:8192.
#define _WDTPS_16384_2H         0xFD    // 1:16384.
#define _WDTPS_32768_2H         0xFF    // 1:32768.

//----------------------------- CONFIG3H Options -------------------------------

#define _PBADEN_OFF_3H          0xFD    // PORTB<4:0> pins are configured as digital I/O on Reset.
#define _PBADEN_ON_3H           0xFF    // PORTB<4:0> pins are configured as analog input channels on Reset.
#define _LPT1OSC_OFF_3H         0xFB    // Timer1 configured for higher power operation.
#define _LPT1OSC_ON_3H          0xFF    // Timer1 configured for low-power operation.
#define _MCLRE_OFF_3H           0x7F    // RE3 input pin enabled; MCLR pin disabled.
#define _MCLRE_ON_3H            0xFF    // MCLR pin enabled; RE3 input pin disabled.

//----------------------------- CONFIG4L Options -------------------------------

#define _STVREN_OFF_4L          0xFE    // Stack full/underflow will not cause Reset.
#define _STVREN_ON_4L           0xFF    // Stack full/underflow will cause Reset.
#define _LVP_OFF_4L             0xFB    // Single-Supply ICSP disabled.
#define _LVP_ON_4L              0xFF    // Single-Supply ICSP enabled.
#define _BBSIZ_BB1K_4L          0xF7    // 1KW Boot block size.
#define _BBSIZ_BB2K_4L          0xFF    // 2KW Boot block size.
#define _ICPRT_OFF_4L           0xDF    // ICPORT disabled.
#define _ICPRT_ON_4L            0xFF    // ICPORT enabled.
#define _XINST_OFF_4L           0xBF    // Instruction set extension and Indexed Addressing mode disabled (Legacy mode).
#define _XINST_ON_4L            0xFF    // Instruction set extension and Indexed Addressing mode enabled.
#define _DEBUG_ON_4L            0x7F    // Background debugger enabled, RB6 and RB7 are dedicated to In-Circuit Debug.
#define _DEBUG_OFF_4L           0xFF    // Background debugger disabled, RB6 and RB7 configured as general purpose I/O pins.

//----------------------------- CONFIG5L Options -------------------------------

#define _CP0_ON_5L              0xFE    // Block 0 (000800-001FFFh) or (001000-001FFFh) is code-protected.
#define _CP0_OFF_5L             0xFF    // Block 0 (000800-001FFFh) or (001000-001FFFh) is not code-protected.
#define _CP1_ON_5L              0xFD    // Block 1 (002000-003FFFh) is code-protected.
#define _CP1_OFF_5L             0xFF    // Block 1 (002000-003FFFh) is not code-protected.

//----------------------------- CONFIG5H Options -------------------------------

#define _CPB_ON_5H              0xBF    // Boot block (000000-0007FFh) or (000000-000FFFh) is code-protected.
#define _CPB_OFF_5H             0xFF    // Boot block (000000-0007FFh) or (000000-000FFFh) is not code-protected.

//----------------------------- CONFIG6L Options -------------------------------

#define _WRT0_ON_6L             0xFE    // Block 0 (000800-001FFFh) or (001000-001FFFh) is write-protected.
#define _WRT0_OFF_6L            0xFF    // Block 0 (000800-001FFFh) or (001000-001FFFh) is not write-protected.
#define _WRT1_ON_6L             0xFD    // Block 1 (002000-003FFFh) is write-protected.
#define _WRT1_OFF_6L            0xFF    // Block 1 (002000-003FFFh) is not write-protected.

//----------------------------- CONFIG6H Options -------------------------------

#define _WRTC_ON_6H             0xDF    // Configuration registers (300000-3000FFh) are write-protected.
#define _WRTC_OFF_6H            0xFF    // Configuration registers (300000-3000FFh) are not write-protected.
#define _WRTB_ON_6H             0xBF    // Boot block (000000-0007FFh) or (000000-000FFFh) is write-protected.
#define _WRTB_OFF_6H            0xFF    // Boot block (000000-0007FFh) or (000000-000FFFh) is not write-protected.

//----------------------------- CONFIG7L Options -------------------------------

#define _EBTR0_ON_7L            0xFE    // Block 0 (000800-001FFFh) or (001000-001FFFh) is protected from table reads executed in other blocks.
#define _EBTR0_OFF_7L           0xFF    // Block 0 (000800-001FFFh) or (001000-001FFFh) is not protected from table reads executed in other blocks.
#define _EBTR1_ON_7L            0xFD    // Block 1 (002000-003FFFh) is protected from table reads executed in other blocks.
#define _EBTR1_OFF_7L           0xFF    // Block 1 (002000-003FFFh) is not protected from table reads executed in other blocks.

//----------------------------- CONFIG7H Options -------------------------------

#define _EBTRB_ON_7H            0xBF    // Boot block (000000-0007FFh) or (000000-000FFFh) is protected from table reads executed in other blocks.
#define _EBTRB_OFF_7H           0xFF    // Boot block (000000-0007FFh) or (000000-000FFFh) is not protected from table reads executed in other blocks.

//==============================================================================

#define __DEVID1                0x3FFFFE
#define __DEVID2                0x3FFFFF

#define __IDLOC0                0x200000
#define __IDLOC1                0x200001
#define __IDLOC2                0x200002
#define __IDLOC3                0x200003
#define __IDLOC4                0x200004
#define __IDLOC5                0x200005
#define __IDLOC6                0x200006
#define __IDLOC7                0x200007

#endif // #ifndef __PIC18F4450_H__
