/*
 * This declarations of the PIC18F13K50 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2014.
 *
 * This file is generated automatically by the cinc2h.pl, 2014-03-09 13:32:32 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC18F13K50_H__
#define __PIC18F13K50_H__

//==============================================================================

//==============================================================================
//
//	Register Definitions
//
//==============================================================================


//==============================================================================
//        UEP0 Bits

extern __at(0x0F53) __sfr UEP0;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP0bits_t;

extern __at(0x0F53) volatile __UEP0bits_t UEP0bits;

#define _EPSTALL                0x01
#define _EPINEN                 0x02
#define _EPOUTEN                0x04
#define _EPCONDIS               0x08
#define _EPHSHK                 0x10

//==============================================================================


//==============================================================================
//        UEP1 Bits

extern __at(0x0F54) __sfr UEP1;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP1bits_t;

extern __at(0x0F54) volatile __UEP1bits_t UEP1bits;

#define _UEP1_EPSTALL           0x01
#define _UEP1_EPINEN            0x02
#define _UEP1_EPOUTEN           0x04
#define _UEP1_EPCONDIS          0x08
#define _UEP1_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP2 Bits

extern __at(0x0F55) __sfr UEP2;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP2bits_t;

extern __at(0x0F55) volatile __UEP2bits_t UEP2bits;

#define _UEP2_EPSTALL           0x01
#define _UEP2_EPINEN            0x02
#define _UEP2_EPOUTEN           0x04
#define _UEP2_EPCONDIS          0x08
#define _UEP2_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP3 Bits

extern __at(0x0F56) __sfr UEP3;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP3bits_t;

extern __at(0x0F56) volatile __UEP3bits_t UEP3bits;

#define _UEP3_EPSTALL           0x01
#define _UEP3_EPINEN            0x02
#define _UEP3_EPOUTEN           0x04
#define _UEP3_EPCONDIS          0x08
#define _UEP3_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP4 Bits

extern __at(0x0F57) __sfr UEP4;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP4bits_t;

extern __at(0x0F57) volatile __UEP4bits_t UEP4bits;

#define _UEP4_EPSTALL           0x01
#define _UEP4_EPINEN            0x02
#define _UEP4_EPOUTEN           0x04
#define _UEP4_EPCONDIS          0x08
#define _UEP4_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP5 Bits

extern __at(0x0F58) __sfr UEP5;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP5bits_t;

extern __at(0x0F58) volatile __UEP5bits_t UEP5bits;

#define _UEP5_EPSTALL           0x01
#define _UEP5_EPINEN            0x02
#define _UEP5_EPOUTEN           0x04
#define _UEP5_EPCONDIS          0x08
#define _UEP5_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP6 Bits

extern __at(0x0F59) __sfr UEP6;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP6bits_t;

extern __at(0x0F59) volatile __UEP6bits_t UEP6bits;

#define _UEP6_EPSTALL           0x01
#define _UEP6_EPINEN            0x02
#define _UEP6_EPOUTEN           0x04
#define _UEP6_EPCONDIS          0x08
#define _UEP6_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP7 Bits

extern __at(0x0F5A) __sfr UEP7;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP7bits_t;

extern __at(0x0F5A) volatile __UEP7bits_t UEP7bits;

#define _UEP7_EPSTALL           0x01
#define _UEP7_EPINEN            0x02
#define _UEP7_EPOUTEN           0x04
#define _UEP7_EPCONDIS          0x08
#define _UEP7_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEIE Bits

extern __at(0x0F5B) __sfr UEIE;

typedef struct
  {
  unsigned PIDEE                : 1;
  unsigned CRC5EE               : 1;
  unsigned CRC16EE              : 1;
  unsigned DFN8EE               : 1;
  unsigned BTOEE                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BTSEE                : 1;
  } __UEIEbits_t;

extern __at(0x0F5B) volatile __UEIEbits_t UEIEbits;

#define _PIDEE                  0x01
#define _CRC5EE                 0x02
#define _CRC16EE                0x04
#define _DFN8EE                 0x08
#define _BTOEE                  0x10
#define _BTSEE                  0x80

//==============================================================================


//==============================================================================
//        UADDR Bits

extern __at(0x0F5C) __sfr UADDR;

typedef union
  {
  struct
    {
    unsigned ADDR0              : 1;
    unsigned ADDR1              : 1;
    unsigned ADDR2              : 1;
    unsigned ADDR3              : 1;
    unsigned ADDR4              : 1;
    unsigned ADDR5              : 1;
    unsigned ADDR6              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADDR               : 7;
    unsigned                    : 1;
    };
  } __UADDRbits_t;

extern __at(0x0F5C) volatile __UADDRbits_t UADDRbits;

#define _ADDR0                  0x01
#define _ADDR1                  0x02
#define _ADDR2                  0x04
#define _ADDR3                  0x08
#define _ADDR4                  0x10
#define _ADDR5                  0x20
#define _ADDR6                  0x40

//==============================================================================


//==============================================================================
//        UFRML Bits

extern __at(0x0F5D) __sfr UFRML;

typedef struct
  {
  unsigned FRM0                 : 1;
  unsigned FRM1                 : 1;
  unsigned FRM2                 : 1;
  unsigned FRM3                 : 1;
  unsigned FRM4                 : 1;
  unsigned FRM5                 : 1;
  unsigned FRM6                 : 1;
  unsigned FRM7                 : 1;
  } __UFRMLbits_t;

extern __at(0x0F5D) volatile __UFRMLbits_t UFRMLbits;

#define _FRM0                   0x01
#define _FRM1                   0x02
#define _FRM2                   0x04
#define _FRM3                   0x08
#define _FRM4                   0x10
#define _FRM5                   0x20
#define _FRM6                   0x40
#define _FRM7                   0x80

//==============================================================================


//==============================================================================
//        UFRMH Bits

extern __at(0x0F5E) __sfr UFRMH;

typedef struct
  {
  unsigned FRM8                 : 1;
  unsigned FRM9                 : 1;
  unsigned FRM10                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UFRMHbits_t;

extern __at(0x0F5E) volatile __UFRMHbits_t UFRMHbits;

#define _FRM8                   0x01
#define _FRM9                   0x02
#define _FRM10                  0x04

//==============================================================================


//==============================================================================
//        UEIR Bits

extern __at(0x0F5F) __sfr UEIR;

typedef struct
  {
  unsigned PIDEF                : 1;
  unsigned CRC5EF               : 1;
  unsigned CRC16EF              : 1;
  unsigned DFN8EF               : 1;
  unsigned BTOEF                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BTSEF                : 1;
  } __UEIRbits_t;

extern __at(0x0F5F) volatile __UEIRbits_t UEIRbits;

#define _PIDEF                  0x01
#define _CRC5EF                 0x02
#define _CRC16EF                0x04
#define _DFN8EF                 0x08
#define _BTOEF                  0x10
#define _BTSEF                  0x80

//==============================================================================


//==============================================================================
//        UIE Bits

extern __at(0x0F60) __sfr UIE;

typedef struct
  {
  unsigned URSTIE               : 1;
  unsigned UERRIE               : 1;
  unsigned ACTVIE               : 1;
  unsigned TRNIE                : 1;
  unsigned IDLEIE               : 1;
  unsigned STALLIE              : 1;
  unsigned SOFIE                : 1;
  unsigned                      : 1;
  } __UIEbits_t;

extern __at(0x0F60) volatile __UIEbits_t UIEbits;

#define _URSTIE                 0x01
#define _UERRIE                 0x02
#define _ACTVIE                 0x04
#define _TRNIE                  0x08
#define _IDLEIE                 0x10
#define _STALLIE                0x20
#define _SOFIE                  0x40

//==============================================================================


//==============================================================================
//        UCFG Bits

extern __at(0x0F61) __sfr UCFG;

typedef union
  {
  struct
    {
    unsigned PPB0               : 1;
    unsigned PPB1               : 1;
    unsigned FSEN               : 1;
    unsigned                    : 1;
    unsigned UPUEN              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned UTEYE              : 1;
    };

  struct
    {
    unsigned PPB                : 2;
    unsigned                    : 6;
    };
  } __UCFGbits_t;

extern __at(0x0F61) volatile __UCFGbits_t UCFGbits;

#define _PPB0                   0x01
#define _PPB1                   0x02
#define _FSEN                   0x04
#define _UPUEN                  0x10
#define _UTEYE                  0x80

//==============================================================================


//==============================================================================
//        UIR Bits

extern __at(0x0F62) __sfr UIR;

typedef struct
  {
  unsigned URSTIF               : 1;
  unsigned UERRIF               : 1;
  unsigned ACTVIF               : 1;
  unsigned TRNIF                : 1;
  unsigned IDLEIF               : 1;
  unsigned STALLIF              : 1;
  unsigned SOFIF                : 1;
  unsigned                      : 1;
  } __UIRbits_t;

extern __at(0x0F62) volatile __UIRbits_t UIRbits;

#define _URSTIF                 0x01
#define _UERRIF                 0x02
#define _ACTVIF                 0x04
#define _TRNIF                  0x08
#define _IDLEIF                 0x10
#define _STALLIF                0x20
#define _SOFIF                  0x40

//==============================================================================


//==============================================================================
//        USTAT Bits

extern __at(0x0F63) __sfr USTAT;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned PPBI               : 1;
    unsigned DIR                : 1;
    unsigned ENDP0              : 1;
    unsigned ENDP1              : 1;
    unsigned ENDP2              : 1;
    unsigned ENDP3              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 3;
    unsigned ENDP               : 4;
    unsigned                    : 1;
    };
  } __USTATbits_t;

extern __at(0x0F63) volatile __USTATbits_t USTATbits;

#define _PPBI                   0x02
#define _DIR                    0x04
#define _ENDP0                  0x08
#define _ENDP1                  0x10
#define _ENDP2                  0x20
#define _ENDP3                  0x40

//==============================================================================


//==============================================================================
//        UCON Bits

extern __at(0x0F64) __sfr UCON;

typedef struct
  {
  unsigned                      : 1;
  unsigned SUSPND               : 1;
  unsigned RESUME               : 1;
  unsigned USBEN                : 1;
  unsigned PKTDIS               : 1;
  unsigned SE0                  : 1;
  unsigned PPBRST               : 1;
  unsigned                      : 1;
  } __UCONbits_t;

extern __at(0x0F64) volatile __UCONbits_t UCONbits;

#define _SUSPND                 0x02
#define _RESUME                 0x04
#define _USBEN                  0x08
#define _PKTDIS                 0x10
#define _SE0                    0x20
#define _PPBRST                 0x40

//==============================================================================


//==============================================================================
//        SRCON0 Bits

extern __at(0x0F68) __sfr SRCON0;

typedef union
  {
  struct
    {
    unsigned SRPR               : 1;
    unsigned SRPS               : 1;
    unsigned SRNQEN             : 1;
    unsigned SRQEN              : 1;
    unsigned SRCLK0             : 1;
    unsigned SRCLK1             : 1;
    unsigned SRCLK2             : 1;
    unsigned SRLEN              : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned SRCLK              : 3;
    unsigned                    : 1;
    };
  } __SRCON0bits_t;

extern __at(0x0F68) volatile __SRCON0bits_t SRCON0bits;

#define _SRPR                   0x01
#define _SRPS                   0x02
#define _SRNQEN                 0x04
#define _SRQEN                  0x08
#define _SRCLK0                 0x10
#define _SRCLK1                 0x20
#define _SRCLK2                 0x40
#define _SRLEN                  0x80

//==============================================================================


//==============================================================================
//        SRCON1 Bits

extern __at(0x0F69) __sfr SRCON1;

typedef struct
  {
  unsigned SRRC1E               : 1;
  unsigned SRRC2E               : 1;
  unsigned SRRCKE               : 1;
  unsigned SRRPE                : 1;
  unsigned SRSC1E               : 1;
  unsigned SRSC2E               : 1;
  unsigned SRSCKE               : 1;
  unsigned SRSPE                : 1;
  } __SRCON1bits_t;

extern __at(0x0F69) volatile __SRCON1bits_t SRCON1bits;

#define _SRRC1E                 0x01
#define _SRRC2E                 0x02
#define _SRRCKE                 0x04
#define _SRRPE                  0x08
#define _SRSC1E                 0x10
#define _SRSC2E                 0x20
#define _SRSCKE                 0x40
#define _SRSPE                  0x80

//==============================================================================


//==============================================================================
//        CM2CON0 Bits

extern __at(0x0F6B) __sfr CM2CON0;

typedef union
  {
  struct
    {
    unsigned C2CH0              : 1;
    unsigned C2CH1              : 1;
    unsigned C2R                : 1;
    unsigned C2SP               : 1;
    unsigned C2POL              : 1;
    unsigned C2OE               : 1;
    unsigned C2OUT              : 1;
    unsigned C2ON               : 1;
    };

  struct
    {
    unsigned C2CH               : 2;
    unsigned                    : 6;
    };
  } __CM2CON0bits_t;

extern __at(0x0F6B) volatile __CM2CON0bits_t CM2CON0bits;

#define _C2CH0                  0x01
#define _C2CH1                  0x02
#define _C2R                    0x04
#define _C2SP                   0x08
#define _C2POL                  0x10
#define _C2OE                   0x20
#define _C2OUT                  0x40
#define _C2ON                   0x80

//==============================================================================


//==============================================================================
//        CM2CON1 Bits

extern __at(0x0F6C) __sfr CM2CON1;

typedef struct
  {
  unsigned C2SYNC               : 1;
  unsigned C1SYNC               : 1;
  unsigned C2HYS                : 1;
  unsigned C1HYS                : 1;
  unsigned C2RSEL               : 1;
  unsigned C1RSEL               : 1;
  unsigned MC2OUT               : 1;
  unsigned MC1OUT               : 1;
  } __CM2CON1bits_t;

extern __at(0x0F6C) volatile __CM2CON1bits_t CM2CON1bits;

#define _C2SYNC                 0x01
#define _C1SYNC                 0x02
#define _C2HYS                  0x04
#define _C1HYS                  0x08
#define _C2RSEL                 0x10
#define _C1RSEL                 0x20
#define _MC2OUT                 0x40
#define _MC1OUT                 0x80

//==============================================================================


//==============================================================================
//        CM1CON0 Bits

extern __at(0x0F6D) __sfr CM1CON0;

typedef union
  {
  struct
    {
    unsigned C1CH0              : 1;
    unsigned C1CH1              : 1;
    unsigned C1R                : 1;
    unsigned C1SP               : 1;
    unsigned C1POL              : 1;
    unsigned C1OE               : 1;
    unsigned C1OUT              : 1;
    unsigned C1ON               : 1;
    };

  struct
    {
    unsigned C1CH               : 2;
    unsigned                    : 6;
    };
  } __CM1CON0bits_t;

extern __at(0x0F6D) volatile __CM1CON0bits_t CM1CON0bits;

#define _C1CH0                  0x01
#define _C1CH1                  0x02
#define _C1R                    0x04
#define _C1SP                   0x08
#define _C1POL                  0x10
#define _C1OE                   0x20
#define _C1OUT                  0x40
#define _C1ON                   0x80

//==============================================================================


//==============================================================================
//        SSPMSK Bits

extern __at(0x0F6F) __sfr SSPMSK;

typedef struct
  {
  unsigned MSK0                 : 1;
  unsigned MSK1                 : 1;
  unsigned MSK2                 : 1;
  unsigned MSK3                 : 1;
  unsigned MSK4                 : 1;
  unsigned MSK5                 : 1;
  unsigned MSK6                 : 1;
  unsigned MSK7                 : 1;
  } __SSPMSKbits_t;

extern __at(0x0F6F) volatile __SSPMSKbits_t SSPMSKbits;

#define _MSK0                   0x01
#define _MSK1                   0x02
#define _MSK2                   0x04
#define _MSK3                   0x08
#define _MSK4                   0x10
#define _MSK5                   0x20
#define _MSK6                   0x40
#define _MSK7                   0x80

//==============================================================================


//==============================================================================
//        SLRCON Bits

extern __at(0x0F76) __sfr SLRCON;

typedef struct
  {
  unsigned SLRA                 : 1;
  unsigned SLRB                 : 1;
  unsigned SLRC                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __SLRCONbits_t;

extern __at(0x0F76) volatile __SLRCONbits_t SLRCONbits;

#define _SLRA                   0x01
#define _SLRB                   0x02
#define _SLRC                   0x04

//==============================================================================


//==============================================================================
//        WPUA Bits

extern __at(0x0F77) __sfr WPUA;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned WPUA3                : 1;
  unsigned WPUA4                : 1;
  unsigned WPUA5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __WPUAbits_t;

extern __at(0x0F77) volatile __WPUAbits_t WPUAbits;

#define _WPUA3                  0x08
#define _WPUA4                  0x10
#define _WPUA5                  0x20

//==============================================================================


//==============================================================================
//        WPUB Bits

extern __at(0x0F78) __sfr WPUB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned WPUB4                : 1;
  unsigned WPUB5                : 1;
  unsigned WPUB6                : 1;
  unsigned WPUB7                : 1;
  } __WPUBbits_t;

extern __at(0x0F78) volatile __WPUBbits_t WPUBbits;

#define _WPUB4                  0x10
#define _WPUB5                  0x20
#define _WPUB6                  0x40
#define _WPUB7                  0x80

//==============================================================================


//==============================================================================
//        IOCA Bits

extern __at(0x0F79) __sfr IOCA;

typedef struct
  {
  unsigned IOCA0                : 1;
  unsigned IOCA1                : 1;
  unsigned                      : 1;
  unsigned IOCA3                : 1;
  unsigned IOCA4                : 1;
  unsigned IOCA5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __IOCAbits_t;

extern __at(0x0F79) volatile __IOCAbits_t IOCAbits;

#define _IOCA0                  0x01
#define _IOCA1                  0x02
#define _IOCA3                  0x08
#define _IOCA4                  0x10
#define _IOCA5                  0x20

//==============================================================================


//==============================================================================
//        IOCB Bits

extern __at(0x0F7A) __sfr IOCB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCB4                : 1;
  unsigned IOCB5                : 1;
  unsigned IOCB6                : 1;
  unsigned IOCB7                : 1;
  } __IOCBbits_t;

extern __at(0x0F7A) volatile __IOCBbits_t IOCBbits;

#define _IOCB4                  0x10
#define _IOCB5                  0x20
#define _IOCB6                  0x40
#define _IOCB7                  0x80

//==============================================================================


//==============================================================================
//        ANSEL Bits

extern __at(0x0F7E) __sfr ANSEL;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ANS3                 : 1;
  unsigned ANS4                 : 1;
  unsigned ANS5                 : 1;
  unsigned ANS6                 : 1;
  unsigned ANS7                 : 1;
  } __ANSELbits_t;

extern __at(0x0F7E) volatile __ANSELbits_t ANSELbits;

#define _ANS3                   0x08
#define _ANS4                   0x10
#define _ANS5                   0x20
#define _ANS6                   0x40
#define _ANS7                   0x80

//==============================================================================


//==============================================================================
//        ANSELH Bits

extern __at(0x0F7F) __sfr ANSELH;

typedef struct
  {
  unsigned ANS8                 : 1;
  unsigned ANS9                 : 1;
  unsigned ANS10                : 1;
  unsigned ANS11                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ANSELHbits_t;

extern __at(0x0F7F) volatile __ANSELHbits_t ANSELHbits;

#define _ANS8                   0x01
#define _ANS9                   0x02
#define _ANS10                  0x04
#define _ANS11                  0x08

//==============================================================================


//==============================================================================
//        PORTA Bits

extern __at(0x0F80) __sfr PORTA;

typedef union
  {
  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned                    : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned AN3                : 1;
    unsigned OSC1               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned OSC2               : 1;
    unsigned CLKIN              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CLKOUT             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PORTAbits_t;

extern __at(0x0F80) volatile __PORTAbits_t PORTAbits;

#define _PORTA_RA0              0x01
#define _PORTA_RA1              0x02
#define _PORTA_RA3              0x08
#define _PORTA_RA4              0x10
#define _PORTA_AN3              0x10
#define _PORTA_OSC2             0x10
#define _PORTA_CLKOUT           0x10
#define _PORTA_RA5              0x20
#define _PORTA_OSC1             0x20
#define _PORTA_CLKIN            0x20

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x0F81) __sfr PORTB;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SDI                : 1;
    unsigned RX                 : 1;
    unsigned SCL                : 1;
    unsigned TX                 : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SDA                : 1;
    unsigned AN11               : 1;
    unsigned SCK                : 1;
    unsigned CK                 : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned AN10               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PORTBbits_t;

extern __at(0x0F81) volatile __PORTBbits_t PORTBbits;

#define _PORTB_RB4              0x10
#define _PORTB_SDI              0x10
#define _PORTB_SDA              0x10
#define _PORTB_AN10             0x10
#define _PORTB_RB5              0x20
#define _PORTB_RX               0x20
#define _PORTB_AN11             0x20
#define _PORTB_RB6              0x40
#define _PORTB_SCL              0x40
#define _PORTB_SCK              0x40
#define _PORTB_RB7              0x80
#define _PORTB_TX               0x80
#define _PORTB_CK               0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x0F82) __sfr PORTC;

typedef union
  {
  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };

  struct
    {
    unsigned AN4                : 1;
    unsigned AN5                : 1;
    unsigned AN6                : 1;
    unsigned AN7                : 1;
    unsigned C12OUT             : 1;
    unsigned CCP1               : 1;
    unsigned AN8                : 1;
    unsigned AN9                : 1;
    };

  struct
    {
    unsigned C12INP             : 1;
    unsigned C12IN1M            : 1;
    unsigned C12IN2M            : 1;
    unsigned C12IN3M            : 1;
    unsigned SRQ                : 1;
    unsigned T0CKI              : 1;
    unsigned NOT_SS             : 1;
    unsigned T1OSCO             : 1;
    };

  struct
    {
    unsigned INT0               : 1;
    unsigned INT1               : 1;
    unsigned INT2               : 1;
    unsigned PGM                : 1;
    unsigned P1B                : 1;
    unsigned P1A                : 1;
    unsigned T13CKI             : 1;
    unsigned SDO                : 1;
    };

  struct
    {
    unsigned VREFP              : 1;
    unsigned VREFM              : 1;
    unsigned CVREF              : 1;
    unsigned P1C                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1OSCI             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned P1D                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SS                 : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned INT                : 3;
    unsigned                    : 5;
    };
  } __PORTCbits_t;

extern __at(0x0F82) volatile __PORTCbits_t PORTCbits;

#define _PORTC_RC0              0x01
#define _PORTC_AN4              0x01
#define _PORTC_C12INP           0x01
#define _PORTC_INT0             0x01
#define _PORTC_VREFP            0x01
#define _PORTC_RC1              0x02
#define _PORTC_AN5              0x02
#define _PORTC_C12IN1M          0x02
#define _PORTC_INT1             0x02
#define _PORTC_VREFM            0x02
#define _PORTC_RC2              0x04
#define _PORTC_AN6              0x04
#define _PORTC_C12IN2M          0x04
#define _PORTC_INT2             0x04
#define _PORTC_CVREF            0x04
#define _PORTC_P1D              0x04
#define _PORTC_RC3              0x08
#define _PORTC_AN7              0x08
#define _PORTC_C12IN3M          0x08
#define _PORTC_PGM              0x08
#define _PORTC_P1C              0x08
#define _PORTC_RC4              0x10
#define _PORTC_C12OUT           0x10
#define _PORTC_SRQ              0x10
#define _PORTC_P1B              0x10
#define _PORTC_RC5              0x20
#define _PORTC_CCP1             0x20
#define _PORTC_T0CKI            0x20
#define _PORTC_P1A              0x20
#define _PORTC_RC6              0x40
#define _PORTC_AN8              0x40
#define _PORTC_NOT_SS           0x40
#define _PORTC_T13CKI           0x40
#define _PORTC_T1OSCI           0x40
#define _PORTC_SS               0x40
#define _PORTC_RC7              0x80
#define _PORTC_AN9              0x80
#define _PORTC_T1OSCO           0x80
#define _PORTC_SDO              0x80

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x0F89) __sfr LATA;

typedef struct
  {
  unsigned LATA0                : 1;
  unsigned LATA1                : 1;
  unsigned                      : 1;
  unsigned LATA3                : 1;
  unsigned LATA4                : 1;
  unsigned LATA5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __LATAbits_t;

extern __at(0x0F89) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA3                  0x08
#define _LATA4                  0x10
#define _LATA5                  0x20

//==============================================================================


//==============================================================================
//        LATB Bits

extern __at(0x0F8A) __sfr LATB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned LATB4                : 1;
  unsigned LATB5                : 1;
  unsigned LATB6                : 1;
  unsigned LATB7                : 1;
  } __LATBbits_t;

extern __at(0x0F8A) volatile __LATBbits_t LATBbits;

#define _LATB4                  0x10
#define _LATB5                  0x20
#define _LATB6                  0x40
#define _LATB7                  0x80

//==============================================================================


//==============================================================================
//        LATC Bits

extern __at(0x0F8B) __sfr LATC;

typedef struct
  {
  unsigned LATC0                : 1;
  unsigned LATC1                : 1;
  unsigned LATC2                : 1;
  unsigned LATC3                : 1;
  unsigned LATC4                : 1;
  unsigned LATC5                : 1;
  unsigned LATC6                : 1;
  unsigned LATC7                : 1;
  } __LATCbits_t;

extern __at(0x0F8B) volatile __LATCbits_t LATCbits;

#define _LATC0                  0x01
#define _LATC1                  0x02
#define _LATC2                  0x04
#define _LATC3                  0x08
#define _LATC4                  0x10
#define _LATC5                  0x20
#define _LATC6                  0x40
#define _LATC7                  0x80

//==============================================================================


//==============================================================================
//        DDRA Bits

extern __at(0x0F92) __sfr DDRA;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TRISA4             : 1;
    unsigned TRISA5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __DDRAbits_t;

extern __at(0x0F92) volatile __DDRAbits_t DDRAbits;

#define _TRISA4                 0x10
#define _RA4                    0x10
#define _TRISA5                 0x20
#define _RA5                    0x20

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x0F92) __sfr TRISA;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TRISA4             : 1;
    unsigned TRISA5             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __TRISAbits_t;

extern __at(0x0F92) volatile __TRISAbits_t TRISAbits;

#define _TRISA_TRISA4           0x10
#define _TRISA_RA4              0x10
#define _TRISA_TRISA5           0x20
#define _TRISA_RA5              0x20

//==============================================================================


//==============================================================================
//        DDRB Bits

extern __at(0x0F93) __sfr DDRB;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TRISB4             : 1;
    unsigned TRISB5             : 1;
    unsigned TRISB6             : 1;
    unsigned TRISB7             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };
  } __DDRBbits_t;

extern __at(0x0F93) volatile __DDRBbits_t DDRBbits;

#define _TRISB4                 0x10
#define _RB4                    0x10
#define _TRISB5                 0x20
#define _RB5                    0x20
#define _TRISB6                 0x40
#define _RB6                    0x40
#define _TRISB7                 0x80
#define _RB7                    0x80

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x0F93) __sfr TRISB;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TRISB4             : 1;
    unsigned TRISB5             : 1;
    unsigned TRISB6             : 1;
    unsigned TRISB7             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };
  } __TRISBbits_t;

extern __at(0x0F93) volatile __TRISBbits_t TRISBbits;

#define _TRISB_TRISB4           0x10
#define _TRISB_RB4              0x10
#define _TRISB_TRISB5           0x20
#define _TRISB_RB5              0x20
#define _TRISB_TRISB6           0x40
#define _TRISB_RB6              0x40
#define _TRISB_TRISB7           0x80
#define _TRISB_RB7              0x80

//==============================================================================


//==============================================================================
//        DDRC Bits

extern __at(0x0F94) __sfr DDRC;

typedef union
  {
  struct
    {
    unsigned TRISC0             : 1;
    unsigned TRISC1             : 1;
    unsigned TRISC2             : 1;
    unsigned TRISC3             : 1;
    unsigned TRISC4             : 1;
    unsigned TRISC5             : 1;
    unsigned TRISC6             : 1;
    unsigned TRISC7             : 1;
    };

  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };
  } __DDRCbits_t;

extern __at(0x0F94) volatile __DDRCbits_t DDRCbits;

#define _TRISC0                 0x01
#define _RC0                    0x01
#define _TRISC1                 0x02
#define _RC1                    0x02
#define _TRISC2                 0x04
#define _RC2                    0x04
#define _TRISC3                 0x08
#define _RC3                    0x08
#define _TRISC4                 0x10
#define _RC4                    0x10
#define _TRISC5                 0x20
#define _RC5                    0x20
#define _TRISC6                 0x40
#define _RC6                    0x40
#define _TRISC7                 0x80
#define _RC7                    0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x0F94) __sfr TRISC;

typedef union
  {
  struct
    {
    unsigned TRISC0             : 1;
    unsigned TRISC1             : 1;
    unsigned TRISC2             : 1;
    unsigned TRISC3             : 1;
    unsigned TRISC4             : 1;
    unsigned TRISC5             : 1;
    unsigned TRISC6             : 1;
    unsigned TRISC7             : 1;
    };

  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned RC3                : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };
  } __TRISCbits_t;

extern __at(0x0F94) volatile __TRISCbits_t TRISCbits;

#define _TRISC_TRISC0           0x01
#define _TRISC_RC0              0x01
#define _TRISC_TRISC1           0x02
#define _TRISC_RC1              0x02
#define _TRISC_TRISC2           0x04
#define _TRISC_RC2              0x04
#define _TRISC_TRISC3           0x08
#define _TRISC_RC3              0x08
#define _TRISC_TRISC4           0x10
#define _TRISC_RC4              0x10
#define _TRISC_TRISC5           0x20
#define _TRISC_RC5              0x20
#define _TRISC_TRISC6           0x40
#define _TRISC_RC6              0x40
#define _TRISC_TRISC7           0x80
#define _TRISC_RC7              0x80

//==============================================================================


//==============================================================================
//        OSCTUNE Bits

extern __at(0x0F9B) __sfr OSCTUNE;

typedef union
  {
  struct
    {
    unsigned TUN0               : 1;
    unsigned TUN1               : 1;
    unsigned TUN2               : 1;
    unsigned TUN3               : 1;
    unsigned TUN4               : 1;
    unsigned TUN5               : 1;
    unsigned SPLLEN             : 1;
    unsigned INTSRC             : 1;
    };

  struct
    {
    unsigned TUN                : 6;
    unsigned                    : 2;
    };
  } __OSCTUNEbits_t;

extern __at(0x0F9B) volatile __OSCTUNEbits_t OSCTUNEbits;

#define _TUN0                   0x01
#define _TUN1                   0x02
#define _TUN2                   0x04
#define _TUN3                   0x08
#define _TUN4                   0x10
#define _TUN5                   0x20
#define _SPLLEN                 0x40
#define _INTSRC                 0x80

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x0F9D) __sfr PIE1;

typedef struct
  {
  unsigned TMR1IE               : 1;
  unsigned TMR2IE               : 1;
  unsigned CCP1IE               : 1;
  unsigned SSPIE                : 1;
  unsigned TXIE                 : 1;
  unsigned RCIE                 : 1;
  unsigned ADIE                 : 1;
  unsigned                      : 1;
  } __PIE1bits_t;

extern __at(0x0F9D) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _CCP1IE                 0x04
#define _SSPIE                  0x08
#define _TXIE                   0x10
#define _RCIE                   0x20
#define _ADIE                   0x40

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x0F9E) __sfr PIR1;

typedef struct
  {
  unsigned TMR1IF               : 1;
  unsigned TMR2IF               : 1;
  unsigned CCP1IF               : 1;
  unsigned SSPIF                : 1;
  unsigned TXIF                 : 1;
  unsigned RCIF                 : 1;
  unsigned ADIF                 : 1;
  unsigned                      : 1;
  } __PIR1bits_t;

extern __at(0x0F9E) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _CCP1IF                 0x04
#define _SSPIF                  0x08
#define _TXIF                   0x10
#define _RCIF                   0x20
#define _ADIF                   0x40

//==============================================================================


//==============================================================================
//        IPR1 Bits

extern __at(0x0F9F) __sfr IPR1;

typedef struct
  {
  unsigned TMR1IP               : 1;
  unsigned TMR2IP               : 1;
  unsigned CCP1IP               : 1;
  unsigned SSPIP                : 1;
  unsigned TXIP                 : 1;
  unsigned RCIP                 : 1;
  unsigned ADIP                 : 1;
  unsigned                      : 1;
  } __IPR1bits_t;

extern __at(0x0F9F) volatile __IPR1bits_t IPR1bits;

#define _TMR1IP                 0x01
#define _TMR2IP                 0x02
#define _CCP1IP                 0x04
#define _SSPIP                  0x08
#define _TXIP                   0x10
#define _RCIP                   0x20
#define _ADIP                   0x40

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0FA0) __sfr PIE2;

typedef struct
  {
  unsigned                      : 1;
  unsigned TMR3IE               : 1;
  unsigned USBIE                : 1;
  unsigned BCLIE                : 1;
  unsigned EEIE                 : 1;
  unsigned C2IE                 : 1;
  unsigned C1IE                 : 1;
  unsigned OSCFIE               : 1;
  } __PIE2bits_t;

extern __at(0x0FA0) volatile __PIE2bits_t PIE2bits;

#define _TMR3IE                 0x02
#define _USBIE                  0x04
#define _BCLIE                  0x08
#define _EEIE                   0x10
#define _C2IE                   0x20
#define _C1IE                   0x40
#define _OSCFIE                 0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x0FA1) __sfr PIR2;

typedef struct
  {
  unsigned                      : 1;
  unsigned TMR3IF               : 1;
  unsigned USBIF                : 1;
  unsigned BCLIF                : 1;
  unsigned EEIF                 : 1;
  unsigned C2IF                 : 1;
  unsigned C1IF                 : 1;
  unsigned OSCFIF               : 1;
  } __PIR2bits_t;

extern __at(0x0FA1) volatile __PIR2bits_t PIR2bits;

#define _TMR3IF                 0x02
#define _USBIF                  0x04
#define _BCLIF                  0x08
#define _EEIF                   0x10
#define _C2IF                   0x20
#define _C1IF                   0x40
#define _OSCFIF                 0x80

//==============================================================================


//==============================================================================
//        IPR2 Bits

extern __at(0x0FA2) __sfr IPR2;

typedef struct
  {
  unsigned                      : 1;
  unsigned TMR3IP               : 1;
  unsigned USBIP                : 1;
  unsigned BCLIP                : 1;
  unsigned EEIP                 : 1;
  unsigned C2IP                 : 1;
  unsigned C1IP                 : 1;
  unsigned OSCFIP               : 1;
  } __IPR2bits_t;

extern __at(0x0FA2) volatile __IPR2bits_t IPR2bits;

#define _TMR3IP                 0x02
#define _USBIP                  0x04
#define _BCLIP                  0x08
#define _EEIP                   0x10
#define _C2IP                   0x20
#define _C1IP                   0x40
#define _OSCFIP                 0x80

//==============================================================================


//==============================================================================
//        EECON1 Bits

extern __at(0x0FA6) __sfr EECON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned FREE                 : 1;
  unsigned                      : 1;
  unsigned CFGS                 : 1;
  unsigned EEPGD                : 1;
  } __EECON1bits_t;

extern __at(0x0FA6) volatile __EECON1bits_t EECON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _CFGS                   0x40
#define _EEPGD                  0x80

//==============================================================================

extern __at(0x0FA7) __sfr EECON2;
extern __at(0x0FA8) __sfr EEDATA;

//==============================================================================
//        EEADR Bits

extern __at(0x0FA9) __sfr EEADR;

typedef struct
  {
  unsigned EEADR0               : 1;
  unsigned EEADR1               : 1;
  unsigned EEADR2               : 1;
  unsigned EEADR3               : 1;
  unsigned EEADR4               : 1;
  unsigned EEADR5               : 1;
  unsigned EEADR6               : 1;
  unsigned EEADR7               : 1;
  } __EEADRbits_t;

extern __at(0x0FA9) volatile __EEADRbits_t EEADRbits;

#define _EEADR0                 0x01
#define _EEADR1                 0x02
#define _EEADR2                 0x04
#define _EEADR3                 0x08
#define _EEADR4                 0x10
#define _EEADR5                 0x20
#define _EEADR6                 0x40
#define _EEADR7                 0x80

//==============================================================================


//==============================================================================
//        RCSTA Bits

extern __at(0x0FAB) __sfr RCSTA;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned ADDEN              : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADEN               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __RCSTAbits_t;

extern __at(0x0FAB) volatile __RCSTAbits_t RCSTAbits;

#define _RX9D                   0x01
#define _OERR                   0x02
#define _FERR                   0x04
#define _ADDEN                  0x08
#define _ADEN                   0x08
#define _CREN                   0x10
#define _SREN                   0x20
#define _RX9                    0x40
#define _SPEN                   0x80

//==============================================================================


//==============================================================================
//        TXSTA Bits

extern __at(0x0FAC) __sfr TXSTA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTAbits_t;

extern __at(0x0FAC) volatile __TXSTAbits_t TXSTAbits;

#define _TX9D                   0x01
#define _TRMT                   0x02
#define _BRGH                   0x04
#define _SENDB                  0x08
#define _SYNC                   0x10
#define _TXEN                   0x20
#define _TX9                    0x40
#define _CSRC                   0x80

//==============================================================================

extern __at(0x0FAD) __sfr TXREG;
extern __at(0x0FAE) __sfr RCREG;
extern __at(0x0FAF) __sfr SPBRG;
extern __at(0x0FB0) __sfr SPBRGH;

//==============================================================================
//        T3CON Bits

extern __at(0x0FB1) __sfr T3CON;

typedef union
  {
  struct
    {
    unsigned TMR3ON             : 1;
    unsigned TMR3CS             : 1;
    unsigned NOT_T3SYNC         : 1;
    unsigned T3CCP1             : 1;
    unsigned T3CKPS0            : 1;
    unsigned T3CKPS1            : 1;
    unsigned                    : 1;
    unsigned RD16               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T3SYNC             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T3CKPS             : 2;
    unsigned                    : 2;
    };
  } __T3CONbits_t;

extern __at(0x0FB1) volatile __T3CONbits_t T3CONbits;

#define _T3CON_TMR3ON           0x01
#define _T3CON_TMR3CS           0x02
#define _T3CON_NOT_T3SYNC       0x04
#define _T3CON_T3SYNC           0x04
#define _T3CON_T3CCP1           0x08
#define _T3CON_T3CKPS0          0x10
#define _T3CON_T3CKPS1          0x20
#define _T3CON_RD16             0x80

//==============================================================================

extern __at(0x0FB2) __sfr TMR3;
extern __at(0x0FB2) __sfr TMR3L;
extern __at(0x0FB3) __sfr TMR3H;

//==============================================================================
//        ECCP1AS Bits

extern __at(0x0FB6) __sfr ECCP1AS;

typedef union
  {
  struct
    {
    unsigned PSSBD0             : 1;
    unsigned PSSBD1             : 1;
    unsigned PSSAC0             : 1;
    unsigned PSSAC1             : 1;
    unsigned ECCPAS0            : 1;
    unsigned ECCPAS1            : 1;
    unsigned ECCPAS2            : 1;
    unsigned ECCPASE            : 1;
    };

  struct
    {
    unsigned PSSBD              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSSAC              : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ECCPAS             : 3;
    unsigned                    : 1;
    };
  } __ECCP1ASbits_t;

extern __at(0x0FB6) volatile __ECCP1ASbits_t ECCP1ASbits;

#define _PSSBD0                 0x01
#define _PSSBD1                 0x02
#define _PSSAC0                 0x04
#define _PSSAC1                 0x08
#define _ECCPAS0                0x10
#define _ECCPAS1                0x20
#define _ECCPAS2                0x40
#define _ECCPASE                0x80

//==============================================================================


//==============================================================================
//        PWM1CON Bits

extern __at(0x0FB7) __sfr PWM1CON;

typedef union
  {
  struct
    {
    unsigned PDC0               : 1;
    unsigned PDC1               : 1;
    unsigned PDC2               : 1;
    unsigned PDC3               : 1;
    unsigned PDC4               : 1;
    unsigned PDC5               : 1;
    unsigned PDC6               : 1;
    unsigned PRSEN              : 1;
    };

  struct
    {
    unsigned PDC                : 7;
    unsigned                    : 1;
    };
  } __PWM1CONbits_t;

extern __at(0x0FB7) volatile __PWM1CONbits_t PWM1CONbits;

#define _PDC0                   0x01
#define _PDC1                   0x02
#define _PDC2                   0x04
#define _PDC3                   0x08
#define _PDC4                   0x10
#define _PDC5                   0x20
#define _PDC6                   0x40
#define _PRSEN                  0x80

//==============================================================================


//==============================================================================
//        BAUDCON Bits

extern __at(0x0FB8) __sfr BAUDCON;

typedef union
  {
  struct
    {
    unsigned ABDEN              : 1;
    unsigned WUE                : 1;
    unsigned                    : 1;
    unsigned BRG16              : 1;
    unsigned CKTXP              : 1;
    unsigned DTRXP              : 1;
    unsigned RCIDL              : 1;
    unsigned ABDOVF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SCKP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __BAUDCONbits_t;

extern __at(0x0FB8) volatile __BAUDCONbits_t BAUDCONbits;

#define _ABDEN                  0x01
#define _WUE                    0x02
#define _BRG16                  0x08
#define _CKTXP                  0x10
#define _SCKP                   0x10
#define _DTRXP                  0x20
#define _RCIDL                  0x40
#define _ABDOVF                 0x80

//==============================================================================


//==============================================================================
//        BAUDCTL Bits

extern __at(0x0FB8) __sfr BAUDCTL;

typedef union
  {
  struct
    {
    unsigned ABDEN              : 1;
    unsigned WUE                : 1;
    unsigned                    : 1;
    unsigned BRG16              : 1;
    unsigned CKTXP              : 1;
    unsigned DTRXP              : 1;
    unsigned RCIDL              : 1;
    unsigned ABDOVF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SCKP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __BAUDCTLbits_t;

extern __at(0x0FB8) volatile __BAUDCTLbits_t BAUDCTLbits;

#define _BAUDCTL_ABDEN          0x01
#define _BAUDCTL_WUE            0x02
#define _BAUDCTL_BRG16          0x08
#define _BAUDCTL_CKTXP          0x10
#define _BAUDCTL_SCKP           0x10
#define _BAUDCTL_DTRXP          0x20
#define _BAUDCTL_RCIDL          0x40
#define _BAUDCTL_ABDOVF         0x80

//==============================================================================


//==============================================================================
//        PSTRCON Bits

extern __at(0x0FB9) __sfr PSTRCON;

typedef struct
  {
  unsigned STRA                 : 1;
  unsigned STRB                 : 1;
  unsigned STRC                 : 1;
  unsigned STRD                 : 1;
  unsigned STRSYNC              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PSTRCONbits_t;

extern __at(0x0FB9) volatile __PSTRCONbits_t PSTRCONbits;

#define _STRA                   0x01
#define _STRB                   0x02
#define _STRC                   0x04
#define _STRD                   0x08
#define _STRSYNC                0x10

//==============================================================================


//==============================================================================
//        REFCON0 Bits

extern __at(0x0FBA) __sfr REFCON0;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned FVR1S0             : 1;
    unsigned FVR1S1             : 1;
    unsigned FVR1ST             : 1;
    unsigned FVR1EN             : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned FVR1S              : 2;
    unsigned                    : 2;
    };
  } __REFCON0bits_t;

extern __at(0x0FBA) volatile __REFCON0bits_t REFCON0bits;

#define _FVR1S0                 0x10
#define _FVR1S1                 0x20
#define _FVR1ST                 0x40
#define _FVR1EN                 0x80

//==============================================================================


//==============================================================================
//        VREFCON0 Bits

extern __at(0x0FBA) __sfr VREFCON0;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned FVR1S0             : 1;
    unsigned FVR1S1             : 1;
    unsigned FVR1ST             : 1;
    unsigned FVR1EN             : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned FVR1S              : 2;
    unsigned                    : 2;
    };
  } __VREFCON0bits_t;

extern __at(0x0FBA) volatile __VREFCON0bits_t VREFCON0bits;

#define _VREFCON0_FVR1S0        0x10
#define _VREFCON0_FVR1S1        0x20
#define _VREFCON0_FVR1ST        0x40
#define _VREFCON0_FVR1EN        0x80

//==============================================================================


//==============================================================================
//        REFCON1 Bits

extern __at(0x0FBB) __sfr REFCON1;

typedef union
  {
  struct
    {
    unsigned D1NSS              : 1;
    unsigned                    : 1;
    unsigned D1PSS0             : 1;
    unsigned D1PSS1             : 1;
    unsigned                    : 1;
    unsigned DAC1OE             : 1;
    unsigned D1LPS              : 1;
    unsigned D1EN               : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned D1PSS              : 2;
    unsigned                    : 4;
    };
  } __REFCON1bits_t;

extern __at(0x0FBB) volatile __REFCON1bits_t REFCON1bits;

#define _D1NSS                  0x01
#define _D1PSS0                 0x04
#define _D1PSS1                 0x08
#define _DAC1OE                 0x20
#define _D1LPS                  0x40
#define _D1EN                   0x80

//==============================================================================


//==============================================================================
//        VREFCON1 Bits

extern __at(0x0FBB) __sfr VREFCON1;

typedef union
  {
  struct
    {
    unsigned D1NSS              : 1;
    unsigned                    : 1;
    unsigned D1PSS0             : 1;
    unsigned D1PSS1             : 1;
    unsigned                    : 1;
    unsigned DAC1OE             : 1;
    unsigned D1LPS              : 1;
    unsigned D1EN               : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned D1PSS              : 2;
    unsigned                    : 4;
    };
  } __VREFCON1bits_t;

extern __at(0x0FBB) volatile __VREFCON1bits_t VREFCON1bits;

#define _VREFCON1_D1NSS         0x01
#define _VREFCON1_D1PSS0        0x04
#define _VREFCON1_D1PSS1        0x08
#define _VREFCON1_DAC1OE        0x20
#define _VREFCON1_D1LPS         0x40
#define _VREFCON1_D1EN          0x80

//==============================================================================


//==============================================================================
//        REFCON2 Bits

extern __at(0x0FBC) __sfr REFCON2;

typedef union
  {
  struct
    {
    unsigned DAC1R0             : 1;
    unsigned DAC1R1             : 1;
    unsigned DAC1R2             : 1;
    unsigned DAC1R3             : 1;
    unsigned DAC1R4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC1R              : 5;
    unsigned                    : 3;
    };
  } __REFCON2bits_t;

extern __at(0x0FBC) volatile __REFCON2bits_t REFCON2bits;

#define _DAC1R0                 0x01
#define _DAC1R1                 0x02
#define _DAC1R2                 0x04
#define _DAC1R3                 0x08
#define _DAC1R4                 0x10

//==============================================================================


//==============================================================================
//        VREFCON2 Bits

extern __at(0x0FBC) __sfr VREFCON2;

typedef union
  {
  struct
    {
    unsigned DAC1R0             : 1;
    unsigned DAC1R1             : 1;
    unsigned DAC1R2             : 1;
    unsigned DAC1R3             : 1;
    unsigned DAC1R4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DAC1R              : 5;
    unsigned                    : 3;
    };
  } __VREFCON2bits_t;

extern __at(0x0FBC) volatile __VREFCON2bits_t VREFCON2bits;

#define _VREFCON2_DAC1R0        0x01
#define _VREFCON2_DAC1R1        0x02
#define _VREFCON2_DAC1R2        0x04
#define _VREFCON2_DAC1R3        0x08
#define _VREFCON2_DAC1R4        0x10

//==============================================================================


//==============================================================================
//        CCP1CON Bits

extern __at(0x0FBD) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned P1M0               : 1;
    unsigned P1M1               : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P1M                : 2;
    };
  } __CCP1CONbits_t;

extern __at(0x0FBD) volatile __CCP1CONbits_t CCP1CONbits;

#define _CCP1M0                 0x01
#define _CCP1M1                 0x02
#define _CCP1M2                 0x04
#define _CCP1M3                 0x08
#define _DC1B0                  0x10
#define _DC1B1                  0x20
#define _P1M0                   0x40
#define _P1M1                   0x80

//==============================================================================

extern __at(0x0FBE) __sfr CCPR1;
extern __at(0x0FBE) __sfr CCPR1L;
extern __at(0x0FBF) __sfr CCPR1H;

//==============================================================================
//        ADCON2 Bits

extern __at(0x0FC0) __sfr ADCON2;

typedef union
  {
  struct
    {
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    unsigned ACQT0              : 1;
    unsigned ACQT1              : 1;
    unsigned ACQT2              : 1;
    unsigned                    : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned ADCS               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned ACQT               : 3;
    unsigned                    : 2;
    };
  } __ADCON2bits_t;

extern __at(0x0FC0) volatile __ADCON2bits_t ADCON2bits;

#define _ADCS0                  0x01
#define _ADCS1                  0x02
#define _ADCS2                  0x04
#define _ACQT0                  0x08
#define _ACQT1                  0x10
#define _ACQT2                  0x20
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x0FC1) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned NVCFG0             : 1;
    unsigned NVCFG1             : 1;
    unsigned PVCFG0             : 1;
    unsigned PVCFG1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned NVCFG              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PVCFG              : 2;
    unsigned                    : 4;
    };
  } __ADCON1bits_t;

extern __at(0x0FC1) volatile __ADCON1bits_t ADCON1bits;

#define _NVCFG0                 0x01
#define _NVCFG1                 0x02
#define _PVCFG0                 0x04
#define _PVCFG1                 0x08

//==============================================================================


//==============================================================================
//        ADCON0 Bits

extern __at(0x0FC2) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned DONE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned NOT_DONE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO_DONE            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 4;
    unsigned                    : 2;
    };
  } __ADCON0bits_t;

extern __at(0x0FC2) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _GO                     0x02
#define _DONE                   0x02
#define _NOT_DONE               0x02
#define _GO_DONE                0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _CHS3                   0x20

//==============================================================================

extern __at(0x0FC3) __sfr ADRES;
extern __at(0x0FC3) __sfr ADRESL;
extern __at(0x0FC4) __sfr ADRESH;

//==============================================================================
//        SSPCON2 Bits

extern __at(0x0FC5) __sfr SSPCON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSPCON2bits_t;

extern __at(0x0FC5) volatile __SSPCON2bits_t SSPCON2bits;

#define _SEN                    0x01
#define _RSEN                   0x02
#define _PEN                    0x04
#define _RCEN                   0x08
#define _ACKEN                  0x10
#define _ACKDT                  0x20
#define _ACKSTAT                0x40
#define _GCEN                   0x80

//==============================================================================


//==============================================================================
//        SSPCON1 Bits

extern __at(0x0FC6) __sfr SSPCON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCON1bits_t;

extern __at(0x0FC6) volatile __SSPCON1bits_t SSPCON1bits;

#define _SSPM0                  0x01
#define _SSPM1                  0x02
#define _SSPM2                  0x04
#define _SSPM3                  0x08
#define _CKP                    0x10
#define _SSPEN                  0x20
#define _SSPOV                  0x40
#define _WCOL                   0x80

//==============================================================================


//==============================================================================
//        SSPSTAT Bits

extern __at(0x0FC7) __sfr SSPSTAT;

typedef union
  {
  struct
    {
    unsigned BF                 : 1;
    unsigned UA                 : 1;
    unsigned R_NOT_W            : 1;
    unsigned S                  : 1;
    unsigned P                  : 1;
    unsigned D_NOT_A            : 1;
    unsigned CKE                : 1;
    unsigned SMP                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R                  : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned D                  : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_W              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_A              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned R_W                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned D_A                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_WRITE          : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_ADDRESS        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __SSPSTATbits_t;

extern __at(0x0FC7) volatile __SSPSTATbits_t SSPSTATbits;

#define _BF                     0x01
#define _UA                     0x02
#define _R_NOT_W                0x04
#define _R                      0x04
#define _NOT_W                  0x04
#define _R_W                    0x04
#define _NOT_WRITE              0x04
#define _S                      0x08
#define _P                      0x10
#define _D_NOT_A                0x20
#define _D                      0x20
#define _NOT_A                  0x20
#define _D_A                    0x20
#define _NOT_ADDRESS            0x20
#define _CKE                    0x40
#define _SMP                    0x80

//==============================================================================

extern __at(0x0FC8) __sfr SSPADD;
extern __at(0x0FC9) __sfr SSPBUF;

//==============================================================================
//        T2CON Bits

extern __at(0x0FCA) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned T2OUTPS0           : 1;
    unsigned T2OUTPS1           : 1;
    unsigned T2OUTPS2           : 1;
    unsigned T2OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T2OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x0FCA) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _T2OUTPS0               0x08
#define _T2OUTPS1               0x10
#define _T2OUTPS2               0x20
#define _T2OUTPS3               0x40

//==============================================================================

extern __at(0x0FCB) __sfr PR2;
extern __at(0x0FCC) __sfr TMR2;

//==============================================================================
//        T1CON Bits

extern __at(0x0FCD) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned TMR1CS             : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned T1OSCEN            : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned T1RUN              : 1;
    unsigned RD16               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1SYNC             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };
  } __T1CONbits_t;

extern __at(0x0FCD) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _TMR1CS                 0x02
#define _NOT_T1SYNC             0x04
#define _T1SYNC                 0x04
#define _T1OSCEN                0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _T1RUN                  0x40
#define _RD16                   0x80

//==============================================================================

extern __at(0x0FCE) __sfr TMR1;
extern __at(0x0FCE) __sfr TMR1L;
extern __at(0x0FCF) __sfr TMR1H;

//==============================================================================
//        RCON Bits

extern __at(0x0FD0) __sfr RCON;

typedef union
  {
  struct
    {
    unsigned NOT_BOR            : 1;
    unsigned NOT_POR            : 1;
    unsigned NOT_PD             : 1;
    unsigned NOT_TO             : 1;
    unsigned NOT_RI             : 1;
    unsigned                    : 1;
    unsigned SBOREN             : 1;
    unsigned IPEN               : 1;
    };

  struct
    {
    unsigned BOR                : 1;
    unsigned POR                : 1;
    unsigned PD                 : 1;
    unsigned TO                 : 1;
    unsigned RI                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __RCONbits_t;

extern __at(0x0FD0) volatile __RCONbits_t RCONbits;

#define _NOT_BOR                0x01
#define _BOR                    0x01
#define _NOT_POR                0x02
#define _POR                    0x02
#define _NOT_PD                 0x04
#define _PD                     0x04
#define _NOT_TO                 0x08
#define _TO                     0x08
#define _NOT_RI                 0x10
#define _RI                     0x10
#define _SBOREN                 0x40
#define _IPEN                   0x80

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0FD1) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SWDTE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __WDTCONbits_t;

extern __at(0x0FD1) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _SWDTE                  0x01

//==============================================================================


//==============================================================================
//        OSCCON2 Bits

extern __at(0x0FD2) __sfr OSCCON2;

typedef struct
  {
  unsigned LFIOFS               : 1;
  unsigned HFIOFL               : 1;
  unsigned PRI_SD               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __OSCCON2bits_t;

extern __at(0x0FD2) volatile __OSCCON2bits_t OSCCON2bits;

#define _LFIOFS                 0x01
#define _HFIOFL                 0x02
#define _PRI_SD                 0x04

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x0FD3) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS0               : 1;
    unsigned SCS1               : 1;
    unsigned IOFS               : 1;
    unsigned OSTS               : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned IDLEN              : 1;
    };

  struct
    {
    unsigned SCS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned IRCF               : 3;
    unsigned                    : 1;
    };
  } __OSCCONbits_t;

extern __at(0x0FD3) volatile __OSCCONbits_t OSCCONbits;

#define _SCS0                   0x01
#define _SCS1                   0x02
#define _IOFS                   0x04
#define _OSTS                   0x08
#define _IRCF0                  0x10
#define _IRCF1                  0x20
#define _IRCF2                  0x40
#define _IDLEN                  0x80

//==============================================================================


//==============================================================================
//        T0CON Bits

extern __at(0x0FD5) __sfr T0CON;

typedef union
  {
  struct
    {
    unsigned T0PS0              : 1;
    unsigned T0PS1              : 1;
    unsigned T0PS2              : 1;
    unsigned PSA                : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned T08BIT             : 1;
    unsigned TMR0ON             : 1;
    };

  struct
    {
    unsigned T0PS               : 3;
    unsigned                    : 5;
    };
  } __T0CONbits_t;

extern __at(0x0FD5) volatile __T0CONbits_t T0CONbits;

#define _T0PS0                  0x01
#define _T0PS1                  0x02
#define _T0PS2                  0x04
#define _PSA                    0x08
#define _T0SE                   0x10
#define _T0CS                   0x20
#define _T08BIT                 0x40
#define _TMR0ON                 0x80

//==============================================================================

extern __at(0x0FD6) __sfr TMR0;
extern __at(0x0FD6) __sfr TMR0L;
extern __at(0x0FD7) __sfr TMR0H;

//==============================================================================
//        STATUS Bits

extern __at(0x0FD8) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned OV                   : 1;
  unsigned N                    : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0FD8) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _OV                     0x08
#define _N                      0x10

//==============================================================================

extern __at(0x0FD9) __sfr FSR2L;
extern __at(0x0FDA) __sfr FSR2H;
extern __at(0x0FDB) __sfr PLUSW2;
extern __at(0x0FDC) __sfr PREINC2;
extern __at(0x0FDD) __sfr POSTDEC2;
extern __at(0x0FDE) __sfr POSTINC2;
extern __at(0x0FDF) __sfr INDF2;
extern __at(0x0FE0) __sfr BSR;
extern __at(0x0FE1) __sfr FSR1L;
extern __at(0x0FE2) __sfr FSR1H;
extern __at(0x0FE3) __sfr PLUSW1;
extern __at(0x0FE4) __sfr PREINC1;
extern __at(0x0FE5) __sfr POSTDEC1;
extern __at(0x0FE6) __sfr POSTINC1;
extern __at(0x0FE7) __sfr INDF1;
extern __at(0x0FE8) __sfr WREG;
extern __at(0x0FE9) __sfr FSR0L;
extern __at(0x0FEA) __sfr FSR0H;
extern __at(0x0FEB) __sfr PLUSW0;
extern __at(0x0FEC) __sfr PREINC0;
extern __at(0x0FED) __sfr POSTDEC0;
extern __at(0x0FEE) __sfr POSTINC0;
extern __at(0x0FEF) __sfr INDF0;

//==============================================================================
//        INTCON3 Bits

extern __at(0x0FF0) __sfr INTCON3;

typedef union
  {
  struct
    {
    unsigned INT1IF             : 1;
    unsigned INT2IF             : 1;
    unsigned                    : 1;
    unsigned INT1IE             : 1;
    unsigned INT2IE             : 1;
    unsigned                    : 1;
    unsigned INT1IP             : 1;
    unsigned INT2IP             : 1;
    };

  struct
    {
    unsigned INT1F              : 1;
    unsigned INT2F              : 1;
    unsigned                    : 1;
    unsigned INT1E              : 1;
    unsigned INT2E              : 1;
    unsigned                    : 1;
    unsigned INT1P              : 1;
    unsigned INT2P              : 1;
    };
  } __INTCON3bits_t;

extern __at(0x0FF0) volatile __INTCON3bits_t INTCON3bits;

#define _INT1IF                 0x01
#define _INT1F                  0x01
#define _INT2IF                 0x02
#define _INT2F                  0x02
#define _INT1IE                 0x08
#define _INT1E                  0x08
#define _INT2IE                 0x10
#define _INT2E                  0x10
#define _INT1IP                 0x40
#define _INT1P                  0x40
#define _INT2IP                 0x80
#define _INT2P                  0x80

//==============================================================================


//==============================================================================
//        INTCON2 Bits

extern __at(0x0FF1) __sfr INTCON2;

typedef union
  {
  struct
    {
    unsigned RABIP              : 1;
    unsigned                    : 1;
    unsigned TMR0IP             : 1;
    unsigned                    : 1;
    unsigned INTEDG2            : 1;
    unsigned INTEDG1            : 1;
    unsigned INTEDG0            : 1;
    unsigned NOT_RABPU          : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RABPU              : 1;
    };
  } __INTCON2bits_t;

extern __at(0x0FF1) volatile __INTCON2bits_t INTCON2bits;

#define _RABIP                  0x01
#define _TMR0IP                 0x04
#define _INTEDG2                0x10
#define _INTEDG1                0x20
#define _INTEDG0                0x40
#define _NOT_RABPU              0x80
#define _RABPU                  0x80

//==============================================================================


//==============================================================================
//        INTCON Bits

extern __at(0x0FF2) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned RABIF              : 1;
    unsigned INT0IF             : 1;
    unsigned TMR0IF             : 1;
    unsigned RABIE              : 1;
    unsigned INT0IE             : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE_GIEL          : 1;
    unsigned GIE_GIEH           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned INT0F              : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned INT0E              : 1;
    unsigned T0IE               : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GIEL               : 1;
    unsigned GIEH               : 1;
    };
  } __INTCONbits_t;

extern __at(0x0FF2) volatile __INTCONbits_t INTCONbits;

#define _RABIF                  0x01
#define _INT0IF                 0x02
#define _INT0F                  0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _RABIE                  0x08
#define _INT0IE                 0x10
#define _INT0E                  0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE_GIEL              0x40
#define _PEIE                   0x40
#define _GIEL                   0x40
#define _GIE_GIEH               0x80
#define _GIE                    0x80
#define _GIEH                   0x80

//==============================================================================

extern __at(0x0FF3) __sfr PROD;
extern __at(0x0FF3) __sfr PRODL;
extern __at(0x0FF4) __sfr PRODH;
extern __at(0x0FF5) __sfr TABLAT;
extern __at(0x0FF6) __sfr TBLPTR;
extern __at(0x0FF6) __sfr TBLPTRL;
extern __at(0x0FF7) __sfr TBLPTRH;
extern __at(0x0FF8) __sfr TBLPTRU;
extern __at(0x0FF9) __sfr PC;
extern __at(0x0FF9) __sfr PCL;
extern __at(0x0FFA) __sfr PCLATH;
extern __at(0x0FFB) __sfr PCLATU;

//==============================================================================
//        STKPTR Bits

extern __at(0x0FFC) __sfr STKPTR;

typedef union
  {
  struct
    {
    unsigned SP0                : 1;
    unsigned SP1                : 1;
    unsigned SP2                : 1;
    unsigned SP3                : 1;
    unsigned SP4                : 1;
    unsigned                    : 1;
    unsigned STKUNF             : 1;
    unsigned STKFUL             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned STKOVF             : 1;
    };

  struct
    {
    unsigned SP                 : 5;
    unsigned                    : 3;
    };
  } __STKPTRbits_t;

extern __at(0x0FFC) volatile __STKPTRbits_t STKPTRbits;

#define _SP0                    0x01
#define _SP1                    0x02
#define _SP2                    0x04
#define _SP3                    0x08
#define _SP4                    0x10
#define _STKUNF                 0x40
#define _STKFUL                 0x80
#define _STKOVF                 0x80

//==============================================================================

extern __at(0x0FFD) __sfr TOS;
extern __at(0x0FFD) __sfr TOSL;
extern __at(0x0FFE) __sfr TOSH;
extern __at(0x0FFF) __sfr TOSU;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define __CONFIG1L              0x300000
#define __CONFIG1H              0x300001
#define __CONFIG2L              0x300002
#define __CONFIG2H              0x300003
#define __CONFIG3H              0x300005
#define __CONFIG4L              0x300006
#define __CONFIG5L              0x300008
#define __CONFIG5H              0x300009
#define __CONFIG6L              0x30000A
#define __CONFIG6H              0x30000B
#define __CONFIG7L              0x30000C
#define __CONFIG7H              0x30000D

//----------------------------- CONFIG1L Options -------------------------------

#define _CPUDIV_NOCLKDIV_1L     0xE7    // No CPU System Clock divide.
#define _CPUDIV_CLKDIV2_1L      0xEF    // CPU System Clock divided by 2.
#define _CPUDIV_CLKDIV3_1L      0xF7    // CPU System Clock divided by 3.
#define _CPUDIV_CLKDIV4_1L      0xFF    // CPU System Clock divided by 4.
#define _USBDIV_OFF_1L          0xDF    // USB clock comes directly from the OSC1/OSC2 oscillator block; no divide.
#define _USBDIV_ON_1L           0xFF    // USB clock comes from the OSC1/OSC2 divided by 2.

//----------------------------- CONFIG1H Options -------------------------------

#define _FOSC_LP_1H             0xF0    // LP oscillator.
#define _FOSC_XT_1H             0xF1    // XT oscillator.
#define _FOSC_HS_1H             0xF2    // HS oscillator.
#define _FOSC_ERCCLKOUT_1H      0xF3    // External RC oscillator, CLKOUT function on OSC2.
#define _FOSC_ECCLKOUTH_1H      0xF4    // EC, CLKOUT function on OSC2 (high).
#define _FOSC_ECH_1H            0xF5    // EC (high).
#define _FOSC_ERC_1H            0xF7    // External RC oscillator.
#define _FOSC_IRC_1H            0xF8    // Internal RC oscillator.
#define _FOSC_IRCCLKOUT_1H      0xF9    // Internal RC oscillator, CLKOUT function on OSC2.
#define _FOSC_ECCLKOUTM_1H      0xFA    // EC, CLKOUT function on OSC2 (medium).
#define _FOSC_ECM_1H            0xFB    // EC (medium).
#define _FOSC_ECCLKOUTL_1H      0xFC    // EC, CLKOUT function on OSC2 (low).
#define _FOSC_ECL_1H            0xFD    // EC (low).
#define _PLLEN_OFF_1H           0xEF    // PLL is under software control.
#define _PLLEN_ON_1H            0xFF    // Oscillator multiplied by 4.
#define _PCLKEN_OFF_1H          0xDF    // Primary clock is under software control.
#define _PCLKEN_ON_1H           0xFF    // Primary clock enabled.
#define _FCMEN_OFF_1H           0xBF    // Fail-Safe Clock Monitor disabled.
#define _FCMEN_ON_1H            0xFF    // Fail-Safe Clock Monitor enabled.
#define _IESO_OFF_1H            0x7F    // Oscillator Switchover mode disabled.
#define _IESO_ON_1H             0xFF    // Oscillator Switchover mode enabled.

//----------------------------- CONFIG2L Options -------------------------------

#define _PWRTEN_ON_2L           0xFE    // PWRT enabled.
#define _PWRTEN_OFF_2L          0xFF    // PWRT disabled.
#define _BOREN_OFF_2L           0xF9    // Brown-out Reset disabled in hardware and software.
#define _BOREN_ON_2L            0xFB    // Brown-out Reset enabled and controlled by software (SBOREN is enabled).
#define _BOREN_NOSLP_2L         0xFD    // Brown-out Reset enabled in hardware only and disabled in Sleep mode (SBOREN is disabled).
#define _BOREN_SBORDIS_2L       0xFF    // Brown-out Reset enabled in hardware only (SBOREN is disabled).
#define _BORV_30_2L             0xE7    // VBOR set to 3.0 V nominal.
#define _BORV_27_2L             0xEF    // VBOR set to 2.7 V nominal.
#define _BORV_22_2L             0xF7    // VBOR set to 2.2 V nominal.
#define _BORV_19_2L             0xFF    // VBOR set to 1.9 V nominal.

//----------------------------- CONFIG2H Options -------------------------------

#define _WDTEN_OFF_2H           0xFE    // WDT is controlled by SWDTEN bit of the WDTCON register.
#define _WDTEN_ON_2H            0xFF    // WDT is always enabled. SWDTEN bit has no effect.
#define _WDTPS_1_2H             0xE1    // 1:1.
#define _WDTPS_2_2H             0xE3    // 1:2.
#define _WDTPS_4_2H             0xE5    // 1:4.
#define _WDTPS_8_2H             0xE7    // 1:8.
#define _WDTPS_16_2H            0xE9    // 1:16.
#define _WDTPS_32_2H            0xEB    // 1:32.
#define _WDTPS_64_2H            0xED    // 1:64.
#define _WDTPS_128_2H           0xEF    // 1:128.
#define _WDTPS_256_2H           0xF1    // 1:256.
#define _WDTPS_512_2H           0xF3    // 1:512.
#define _WDTPS_1024_2H          0xF5    // 1:1024.
#define _WDTPS_2048_2H          0xF7    // 1:2048.
#define _WDTPS_4096_2H          0xF9    // 1:4096.
#define _WDTPS_8192_2H          0xFB    // 1:8192.
#define _WDTPS_16384_2H         0xFD    // 1:16384.
#define _WDTPS_32768_2H         0xFF    // 1:32768.

//----------------------------- CONFIG3H Options -------------------------------

#define _HFOFST_OFF_3H          0xF7    // The system clock is held off until the HFINTOSC is stable.
#define _HFOFST_ON_3H           0xFF    // HFINTOSC starts clocking the CPU without waiting for the oscillator to stablize.
#define _MCLRE_OFF_3H           0x7F    // RA3 input pin enabled; MCLR disabled.
#define _MCLRE_ON_3H            0xFF    // MCLR pin enabled; RA3 input pin disabled.

//----------------------------- CONFIG4L Options -------------------------------

#define _STVREN_OFF_4L          0xFE    // Stack full/underflow will not cause Reset.
#define _STVREN_ON_4L           0xFF    // Stack full/underflow will cause Reset.
#define _LVP_OFF_4L             0xFB    // Single-Supply ICSP disabled.
#define _LVP_ON_4L              0xFF    // Single-Supply ICSP enabled.
#define _BBSIZ_OFF_4L           0xF7    // 512W boot block size.
#define _BBSIZ_ON_4L            0xFF    // 1kW boot block size.
#define _XINST_OFF_4L           0xBF    // Instruction set extension and Indexed Addressing mode disabled (Legacy mode).
#define _XINST_ON_4L            0xFF    // Instruction set extension and Indexed Addressing mode enabled.
#define _DEBUG_ON_4L            0x7F    // Background debugger enabled, RA0 and RA1 are dedicated to In-Circuit Debug.
#define _DEBUG_OFF_4L           0xFF    // Background debugger disabled, RA0 and RA1 configured as general purpose I/O pins.

//----------------------------- CONFIG5L Options -------------------------------

#define _CP0_ON_5L              0xFE    // Block 0 code-protected.
#define _CP0_OFF_5L             0xFF    // Block 0 not code-protected.
#define _CP1_ON_5L              0xFD    // Block 1 code-protected.
#define _CP1_OFF_5L             0xFF    // Block 1 not code-protected.

//----------------------------- CONFIG5H Options -------------------------------

#define _CPB_ON_5H              0xBF    // Boot block code-protected.
#define _CPB_OFF_5H             0xFF    // Boot block not code-protected.
#define _CPD_ON_5H              0x7F    // Data EEPROM code-protected.
#define _CPD_OFF_5H             0xFF    // Data EEPROM not code-protected.

//----------------------------- CONFIG6L Options -------------------------------

#define _WRT0_ON_6L             0xFE    // Block 0 write-protected.
#define _WRT0_OFF_6L            0xFF    // Block 0 not write-protected.
#define _WRT1_ON_6L             0xFD    // Block 1 write-protected.
#define _WRT1_OFF_6L            0xFF    // Block 1 not write-protected.

//----------------------------- CONFIG6H Options -------------------------------

#define _WRTC_ON_6H             0xDF    // Configuration registers write-protected.
#define _WRTC_OFF_6H            0xFF    // Configuration registers not write-protected.
#define _WRTB_ON_6H             0xBF    // Boot block write-protected.
#define _WRTB_OFF_6H            0xFF    // Boot block not write-protected.
#define _WRTD_ON_6H             0x7F    // Data EEPROM write-protected.
#define _WRTD_OFF_6H            0xFF    // Data EEPROM not write-protected.

//----------------------------- CONFIG7L Options -------------------------------

#define _EBTR0_ON_7L            0xFE    // Block 0 protected from table reads executed in other blocks.
#define _EBTR0_OFF_7L           0xFF    // Block 0 not protected from table reads executed in other blocks.
#define _EBTR1_ON_7L            0xFD    // Block 1 protected from table reads executed in other blocks.
#define _EBTR1_OFF_7L           0xFF    // Block 1 not protected from table reads executed in other blocks.

//----------------------------- CONFIG7H Options -------------------------------

#define _EBTRB_ON_7H            0xBF    // Boot block protected from table reads executed in other blocks.
#define _EBTRB_OFF_7H           0xFF    // Boot block not protected from table reads executed in other blocks.

//==============================================================================

#define __DEVID1                0x3FFFFE
#define __DEVID2                0x3FFFFF

#define __IDLOC0                0x200000
#define __IDLOC1                0x200001
#define __IDLOC2                0x200002
#define __IDLOC3                0x200003
#define __IDLOC4                0x200004
#define __IDLOC5                0x200005
#define __IDLOC6                0x200006
#define __IDLOC7                0x200007

#endif // #ifndef __PIC18F13K50_H__
