/*
 * include/linux/sm_drv_wpa.h
 *
 * WPA definitions for Conexant ISL_3825 chipset.
 *
 * Copyright (C) 2004 Nokia Corporation
 * Author: Samuel Ortiz <samuel.ortiz@nokia.com>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */
#ifndef _SM_DRV_WPA_H
#define _SM_DRV_WPA_H

/* Wireless extensions extensions...*/
#define IW_ENCODE_TKIP       0x0200
#define IW_ENCODE_AES        0x0100
#define IW_ENCODE_UNICAST    0x0080
#define IW_ENCODE_MULTICAST  0x0040

/* 
 * WPA wireless extensions. 
 * This will be included in WE18 
 */
#define IWEVMICHAELMICFAILURE 0x8C06
/* IWEVMICHAELMICFAILURE : struct iw_michaelmicfailure ->flags */
#define IW_MICFAILURE_KEY_ID	0x00000003 /* Key ID 0..3 */
#define IW_MICFAILURE_GROUP	0x00000004
#define IW_MICFAILURE_PAIRWISE	0x00000008
#define IW_MICFAILURE_STAKEY	0x00000010
#define IW_MICFAILURE_COUNT	0x00000060 /* 1 or 2 (0 = count not supported) */

#define IW_ENCODE_SEQ_MAX_SIZE	8

struct iw_michaelmicfailure
{
	__u32		flags;
	struct sockaddr	src_addr;
	__u8		tsc[IW_ENCODE_SEQ_MAX_SIZE]; /* LSB first */
};

/* Authentication order flags. We let the 8 first
   bits free for WE-17 */
#define IW_AUTH_MASK            0xff00
#define IW_AUTH_NOWPA           0x100
#define IW_AUTH_WPA             0x200
#define IW_AUTH_WPA_PSK         0x300
#define IW_AUTH_WPA2            0x400
#define IW_AUTH_WPA2_PSK        0x500

/* SIOCSIWPMKSA data */
#define IW_PMKSA_ADD		1
#define IW_PMKSA_REMOVE		2
#define IW_PMKSA_FLUSH		3

#define IW_PMKID_LEN	16

struct iw_pmksa
{
	__u32		cmd; /* IW_PMKSA_* */
	struct sockaddr	bssid;
	__u8		pmkid[IW_PMKID_LEN];
};


/* Privacy invoked when calling set_wpa */
#define DOT11_PRIV_INV_NONE                     0
#define DOT11_PRIV_INV_WEP                      1
#define DOT11_PRIV_INV_TKIP                     2
#define DOT11_PRIV_INV_AES_CCMP                 3

/* 
 * WPA strucutres definitions
 * We're trying to stay somehow compatible with
 * the GPL wpa_supplicant and hostapd.
 */

/* Generic IE to pass to the driver */
typedef struct generic_element{
	/*
	 * If len is 0, we detach the generic element from the
	 * frames.
	 */
	__u8   len;
	__u8*  data;
} generic_element;

#define CRYPT_ALG_NAME_LEN 16
typedef struct wlan_crypt {
	__u8   alg[CRYPT_ALG_NAME_LEN];
	__u32  flags; // IW_ENCODE_*
	__u32  err;
	__u8   idx;
	__u8   seq[8]; /* sequence counter (set: RX, get: TX) */
	__u16  key_len;
	__u8   key[0];
} wlan_crypt;


/* Private ioctls numbers */
#define SM_DRV_WPA_SCAN                          SIOCIWFIRSTPRIV + 2
#define SM_DRV_WPA_GEN_ELT                       SIOCIWFIRSTPRIV + 4
#define SM_DRV_WPA_GET_WPA                       SIOCIWFIRSTPRIV + 5
#define SM_DRV_WPA_SET_WPA                       SIOCIWFIRSTPRIV + 6
#define SM_DRV_WPA_GET_KEY                       SIOCIWFIRSTPRIV + 7
#define SM_DRV_WPA_SET_KEY                       SIOCIWFIRSTPRIV + 8
#define SM_DRV_WPA_PMK_SET_KEY                   SIOCIWFIRSTPRIV + 10 

#endif
