#ifndef _OMAP_BOARD_NOKIA_H
#define _OMAP_BOARD_NOKIA_H

#define OMAP_TAG_BLUETOOTH	0x4e01
#define OMAP_TAG_WLAN		0x4e02
#define OMAP_TAG_CBUS		0x4e03
#define OMAP_TAG_EM_ASIC	0x4e04
#define OMAP_TAG_VERSION_STR	0x4e05

#define OMAP_BT_CHIP_CSR        1
#define OMAP_BT_CHIP_TI         2

#define OMAP_BT_SYSCLK_12       1
#define OMAP_BT_SYSCLK_38_4     2

struct omap_bluetooth_config {
	u8    chip_type;
	u8    bt_wakeup_pin;
	u8    host_wakeup_pin;
	u8    reset_pin;
	u8    bt_uart;
	u8    bd_addr[6];
	u8    bt_sysclk;
};


struct omap_wlan_config {
	s16 antenna_sw_gpio;
	s16 power_gpio;
	s16 irq_gpio;
	s16 spi_cs_gpio;
};

struct omap_cbus_config {
	s16 clk_pin;
	s16 dat_pin;
	s16 sel_pin;
};

struct omap_em_asic_config {
	s16 retu_irq_pin;
	s16 tahvo_irq_pin;
};

struct omap_version_config {
	char component[12];
	char version[12];
};

#endif
