/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.optional.junit.BaseTest;
import org.apache.tools.ant.taskdefs.optional.junit.Enumerations;
import org.apache.tools.ant.taskdefs.optional.junit.FormatterElement;
import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.types.FileSet;

public final class BatchTest
extends BaseTest {
    private Project project;
    private Vector filesets = new Vector();

    public BatchTest(Project project) {
        this.project = project;
    }

    public void addFileSet(FileSet fileSet) {
        this.filesets.addElement(fileSet);
    }

    public final Enumeration elements() {
        Object[] objectArray = this.createAllJUnitTest();
        return Enumerations.fromArray(objectArray);
    }

    final void addTestsTo(Vector vector) {
        JUnitTest[] jUnitTestArray = this.createAllJUnitTest();
        vector.ensureCapacity(vector.size() + jUnitTestArray.length);
        int n = 0;
        while (n < jUnitTestArray.length) {
            vector.addElement(jUnitTestArray[n]);
            ++n;
        }
    }

    private JUnitTest[] createAllJUnitTest() {
        String[] stringArray = this.getFilenames();
        JUnitTest[] jUnitTestArray = new JUnitTest[stringArray.length];
        int n = 0;
        while (n < jUnitTestArray.length) {
            String string = BatchTest.javaToClass(stringArray[n]);
            jUnitTestArray[n] = this.createJUnitTest(string);
            ++n;
        }
        return jUnitTestArray;
    }

    private String[] getFilenames() {
        FileSet fileSet;
        Vector<String> vector = new Vector<String>();
        int n = this.filesets.size();
        int n2 = 0;
        while (n2 < n) {
            fileSet = (FileSet)this.filesets.elementAt(n2);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.project);
            directoryScanner.scan();
            String[] stringArray = directoryScanner.getIncludedFiles();
            int n3 = 0;
            while (n3 < stringArray.length) {
                String string = stringArray[n3];
                if (string.endsWith(".java")) {
                    vector.addElement(string.substring(0, string.length() - ".java".length()));
                } else if (string.endsWith(".class")) {
                    vector.addElement(string.substring(0, string.length() - ".class".length()));
                }
                ++n3;
            }
            ++n2;
        }
        fileSet = new String[vector.size()];
        vector.copyInto((Object[])fileSet);
        return fileSet;
    }

    public static final String javaToClass(String string) {
        return string.replace(File.separatorChar, '.');
    }

    private JUnitTest createJUnitTest(String string) {
        JUnitTest jUnitTest = new JUnitTest();
        jUnitTest.setName(string);
        jUnitTest.setHaltonerror(this.haltOnError);
        jUnitTest.setHaltonfailure(this.haltOnFail);
        jUnitTest.setFork(this.fork);
        jUnitTest.setIf(this.ifProperty);
        jUnitTest.setUnless(this.unlessProperty);
        jUnitTest.setTodir(this.destDir);
        Enumeration enumeration = this.formatters.elements();
        while (enumeration.hasMoreElements()) {
            jUnitTest.addFormatter((FormatterElement)enumeration.nextElement());
        }
        return jUnitTest;
    }
}

