/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ide;

import com.ibm.ivj.util.base.ExportCodeSpec;
import com.ibm.ivj.util.base.IvjException;
import com.ibm.ivj.util.base.Package;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.optional.ide.VAJUtil;
import org.apache.tools.ant.taskdefs.optional.ide.VAJWorkspaceScanner;
import org.apache.tools.ant.types.PatternSet;

public class VAJExport
extends Task {
    protected File destDir;
    protected boolean exportSources = true;
    protected boolean exportResources = true;
    protected boolean exportClasses = false;
    protected boolean exportDebugInfo = false;
    protected boolean useDefaultExcludes = true;
    protected PatternSet patternSet = new PatternSet();

    public PatternSet.NameEntry createExclude() {
        return this.patternSet.createExclude();
    }

    public PatternSet.NameEntry createInclude() {
        return this.patternSet.createInclude();
    }

    public void execute() throws BuildException {
        if (this.destDir == null) {
            throw new BuildException("destdir attribute must be set!");
        }
        VAJWorkspaceScanner vAJWorkspaceScanner = this.getWorkspaceScanner();
        Package[] packageArray = vAJWorkspaceScanner.getIncludedPackages();
        this.export(packageArray);
    }

    public void export(Package[] packageArray) {
        try {
            String string = this.destDir.getAbsolutePath();
            this.log("Exporting " + packageArray.length + " package(s) to " + string);
            int n = 0;
            while (n < packageArray.length) {
                this.log("    " + packageArray[n].getName(), 3);
                ++n;
            }
            ExportCodeSpec exportCodeSpec = new ExportCodeSpec();
            exportCodeSpec.setPackages(packageArray);
            exportCodeSpec.includeJava(this.exportSources);
            exportCodeSpec.includeClass(this.exportClasses);
            exportCodeSpec.includeResources(this.exportResources);
            exportCodeSpec.includeClassDebugInfo(this.exportDebugInfo);
            exportCodeSpec.useSubdirectories(true);
            exportCodeSpec.overwriteFiles(true);
            exportCodeSpec.setExportDirectory(string);
            VAJUtil.getWorkspace().exportData(exportCodeSpec);
        }
        catch (IvjException ivjException) {
            throw VAJUtil.createBuildException("Exporting failed!", ivjException);
        }
    }

    protected VAJWorkspaceScanner getWorkspaceScanner() {
        VAJWorkspaceScanner vAJWorkspaceScanner = new VAJWorkspaceScanner();
        vAJWorkspaceScanner.setIncludes(this.patternSet.getIncludePatterns(this.getProject()));
        vAJWorkspaceScanner.setExcludes(this.patternSet.getExcludePatterns(this.getProject()));
        if (this.useDefaultExcludes) {
            vAJWorkspaceScanner.addDefaultExcludes();
        }
        vAJWorkspaceScanner.scan();
        return vAJWorkspaceScanner;
    }

    public void setDefaultexcludes(boolean bl) {
        this.useDefaultExcludes = bl;
    }

    public void setDestdir(File file) {
        this.destDir = file;
    }

    public void setExcludes(String string) {
        this.patternSet.setExcludes(string);
    }

    public void setExportClasses(boolean bl) {
        this.exportClasses = bl;
    }

    public void setExportDebugInfo(boolean bl) {
        this.exportDebugInfo = bl;
    }

    public void setExportResources(boolean bl) {
        this.exportResources = bl;
    }

    public void setExportSources(boolean bl) {
        this.exportSources = bl;
    }

    public void setIncludes(String string) {
        this.patternSet.setIncludes(string);
    }
}

