#ifndef __vaulter_h__
#define __vaulter_h__

#include "asserts.h"
#include "rconfig.h"
#include "logger.h"

/** Select, monitor, and prepare vaults */
class vault_manager
{
public:
	enum vault_manager_overflow_type {
		quit,
		delete_oldest,
		delete_until_free
	};
	enum vault_manager_selection_type {
		max_free,
		round_robbin
	};

	vault_manager();

	void clear(void);
	void init(void);
	const bool initialized(void) const;

	void select(void);
	const std::string vault(void) const; 
	const bool selected(void) const;
	void usage(uint16 &a_blocks, uint16 &a_inodes) const;
	const bool overflow(bool a_report = false);
	void delete_oldest_archive(void);
	void prepare(bool a_assume_overflow = false);
	const std::vector<std::string>& deleted_archives(void) const;
	const bool err_deleted_archives(void) const;

	const subdirectory get_archive_list(void);

private:
	std::string m_selected_vault;
	std::vector<std::string> m_deleted_archives;
	bool m_da_err;
	bool m_initialized;
	simple_lock m_lock;
};

extern vault_manager vaulter;

#endif
