#include "config.h"

#include <iostream>
#include <fstream>
#include <iomanip>
#include <string>
#include <cassert>

#include "error.h"
#include "fs.h"
#include "vaulter.h"
#include "test-vaulter-setup.h"

#define ERR_OUT(e) std::cerr << e
// #define ERR_OUT(e)

void test_vaulter(void)
{
	char const * argv[256] = { 0 };
	int argc = 0;
	bool thrown = false;
	subdirectory subdir;

	argv[argc++] = "<program>";
	argv[argc++] = "--archive";
	argv[argc++] = "--timestamp";
	argv[argc++] = "2003-09-21";

	config.default_file("./test-vaulter.dir/file-2.conf");
	try {
		config.init(argc, argv);
		logger.init();
		vaulter.init();
		vaulter.select();
		vaulter.delete_oldest_archive();

	}
	catch(error e) {
		ERR_OUT(e);
		thrown = true;
	}
	catch(...) {
		ERR_OUT(err_unknown);
		assert(0);
	}
	assert(!thrown);
	assert(vaulter.deleted_archives().size() == 1);
	assert(vaulter.deleted_archives()[0] == "2006-06-20");

	subdir.path("./test-vaulter.dir/log.dir/log-3.dir");
	assert(find(subdir.begin(),subdir.end(),"2006-06-20.log") == subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-20.report") != subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-21.relink") != subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-22.log") != subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-22.report") != subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-23.log") != subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-23.report") != subdir.end());

	config.clear();
	logger.clear();
	vaulter.clear();

	config.default_file("./test-vaulter.dir/file-2.conf");
	try {
		config.init(argc, argv);
		logger.init();
		vaulter.init();
		vaulter.select();
		vaulter.delete_oldest_archive();

	}
	catch(error e) {
		ERR_OUT(e);
		thrown = true;
	}
	catch(...) {
		ERR_OUT(err_unknown);
		assert(0);
	}
	assert(!thrown);
	assert(vaulter.deleted_archives().size() == 1);
	assert(vaulter.deleted_archives()[0] == "2006-06-21");

	subdir.path("./test-vaulter.dir/log.dir/log-3.dir");
	assert(find(subdir.begin(),subdir.end(),"2006-06-20.log") == subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-20.report") != subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-21.relink") == subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-22.log") != subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-22.report") != subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-23.log") != subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-23.report") != subdir.end());

	config.clear();
	logger.clear();
	vaulter.clear();

	config.default_file("./test-vaulter.dir/file-3.conf");
	try {
		config.init(argc, argv);
		logger.init();
		vaulter.init();
		vaulter.select();
		vaulter.delete_oldest_archive();

	}
	catch(error e) {
		ERR_OUT(e);
		thrown = true;
	}
	catch(...) {
		ERR_OUT(err_unknown);
		assert(0);
	}
	assert(!thrown);
	assert(vaulter.deleted_archives().size() == 1);
	assert(vaulter.deleted_archives()[0] == "2006-06-22");

	subdir.path("./test-vaulter.dir/log.dir/log-3.dir");
	assert(find(subdir.begin(),subdir.end(),"2006-06-20.log") == subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-20.report") != subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-21.relink") == subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-22.log") != subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-22.report") == subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-23.log") != subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-23.report") != subdir.end());

	config.clear();
	logger.clear();
	vaulter.clear();

	config.default_file("./test-vaulter.dir/file-4.conf");
	try {
		config.init(argc, argv);
		logger.init();
		vaulter.init();
		vaulter.select();
		vaulter.delete_oldest_archive();

	}
	catch(error e) {
		ERR_OUT(e);
		thrown = true;
	}
	catch(...) {
		ERR_OUT(err_unknown);
		assert(0);
	}
	assert(!thrown);
	assert(vaulter.deleted_archives().size() == 1);
	assert(vaulter.deleted_archives()[0] == "2006-06-23");

	subdir.path("./test-vaulter.dir/log.dir/log-3.dir");
	assert(find(subdir.begin(),subdir.end(),"2006-06-20.log") == subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-20.report") != subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-21.relink") == subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-22.log") != subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-22.report") == subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-23.log") == subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-23.report") == subdir.end());

	config.clear();
	logger.clear();
	vaulter.clear();

	config.default_file("./test-vaulter.dir/file-4.conf");
	try {
		config.init(argc, argv);
		logger.init();
		vaulter.init();
		vaulter.select();
		vaulter.delete_oldest_archive();

	}
	catch(error e) {
		ERR_OUT(e);
		thrown = true;
	}
	catch(...) {
		ERR_OUT(err_unknown);
		assert(0);
	}
	assert(!thrown);
	assert(vaulter.deleted_archives().size() == 1);
	assert(vaulter.deleted_archives()[0] == "2006-06-24");

	subdir.path("./test-vaulter.dir/log.dir/log-3.dir");
	assert(find(subdir.begin(),subdir.end(),"2006-06-20.log") == subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-20.report") != subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-21.relink") == subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-22.log") != subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-22.report") == subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-23.log") == subdir.end());
	assert(find(subdir.begin(),subdir.end(),"2006-06-23.report") == subdir.end());
}

int main(int argc, char const * argv[])
{
	cleanup();
	setup();
	try {
		test_vaulter();
	}
	catch(error e) {
		std::cerr << e;
		assert(0);
	}
	catch(...) {
		std::cerr << err_unknown;
		assert(0);
	}
	cleanup();
	return(0);
}

