#include "config.h"

#include <iostream>
#include <iomanip>
#include <string>
#include <cassert>

#ifdef HAVE_TIME_H
#include <time.h>
#endif
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#include "asserts.h"
#include "error.h"
#include "estring.h"
#include "tstamp.h"

void test1(void)
{
	timestamp t;
	std::string str;
	estring estr;

	estr.width(4);
	estr.align(estring::right);
	estr.left_fillchar('0');
	estr = t.year();
	str += estr.fmt_str();

	str += "-";

	estr.width(2);
	estr.align(estring::right);
	estr.left_fillchar('0');
	estr = t.month();
	str += estr.fmt_str();

	str += "-";

	estr.width(2);
	estr.align(estring::right);
	estr.left_fillchar('0');
	estr = t.day();
	str += estr.fmt_str();

	str += ".";

	estr.width(2);
	estr.align(estring::right);
	estr.left_fillchar('0');
	estr = t.hour();
	str += estr.fmt_str();

	estr.width(2);
	estr.align(estring::right);
	estr.left_fillchar('0');
	estr = t.minute();
	str += estr.fmt_str();

	estr.width(2);
	estr.align(estring::right);
	estr.left_fillchar('0');
	estr = t.second();
	str += estr.fmt_str();

	// cerr << "t.str() = " << t.str() << endl;
	assert(t.str(timestamp::resolution_second) == str);
}

void test2(void)
{
	time_t t;
	struct tm* l = 0;
	timestamp ts;
	int year = 0;
	int month = 0;
	int day = 0;
	int hour = 0;
	int minute = 0;
	int second = 0;

	t = time(0);
	l = localtime(&t);
	ts.set();
	year = l->tm_year + 1900;
	month = l->tm_mon + 1;
	day = l->tm_mday;
	hour = l->tm_hour;
	minute = l->tm_min;
	second = l->tm_sec;

	assert(ts.year() == year);
	assert(ts.month() == month);
	assert(ts.day() == day);
	assert(ts.hour() == hour);
	assert(ts.minute() == minute);
	assert(ts.second() == second);
}

void test3(void)
{
	timestamp t;
	bool thrown;

	thrown = false; try { t.assign(""); } catch(...) { thrown = true; }
	assert(thrown);

	thrown = false; try { t.assign("a"); } catch(...) { thrown = true; }
	assert(thrown);

	thrown = false; try { t.assign("2"); } catch(...) { thrown = true; }
	assert(thrown);

	thrown = false; try { t.assign("20"); } catch(...) { thrown = true; }
	assert(thrown);

	thrown = false; try { t.assign("200"); } catch(...) { thrown = true; }
	assert(thrown);

	thrown = false; try { t.assign("2003"); } catch(...) { thrown = true; }
	assert(!thrown);
	assert(t.year() == 2003);
	assert(t.month() == 1);
	assert(t.day() == 1);
	assert(t.hour() == 0);
	assert(t.minute() == 0);
	assert(t.second() == 0);
	assert(t.resolution() == timestamp::resolution_year);

	thrown = false; try { t.assign("2a03"); } catch(...) { thrown = true; }
	assert(thrown);

	thrown = false; try { t.assign("2003-"); } catch(...) { thrown = true; }
	assert(thrown);

	thrown = false; try { t.assign("2003-1"); } catch(...) { thrown = true; }
	assert(thrown);

	thrown = false; try { t.assign("2003-10"); } catch(...) { thrown = true; }
	assert(!thrown);
	assert(t.year() == 2003);
	assert(t.month() == 10);
	assert(t.day() == 1);
	assert(t.hour() == 0);
	assert(t.minute() == 0);
	assert(t.second() == 0);
	assert(t.resolution() == timestamp::resolution_month);

	thrown = false; try { t.assign("2003-1b"); } catch(...) { thrown = true; }
	assert(thrown);

	thrown = false; try { t.assign("2003-19"); } catch(...) { thrown = true; }
	assert(thrown);

	thrown = false; try { t.assign("2003-10-"); } catch(...) { thrown = true; }
	assert(thrown);

	thrown = false; try { t.assign("2003-10-1"); } catch(...) { thrown = true; }
	assert(thrown);

	thrown = false; try { t.assign("2003-10-19"); } catch(...) { thrown = true; }
	assert(!thrown);
	assert(t.year() == 2003);
	assert(t.month() == 10);
	assert(t.day() == 19);
	assert(t.hour() == 0);
	assert(t.minute() == 0);
	assert(t.second() == 0);
	assert(t.resolution() == timestamp::resolution_day);

	thrown = false; try { t.assign("2003-10-19."); } catch(...) { thrown = true; }
	assert(thrown);

	thrown = false; try { t.assign("2003-10-19.2"); } catch(...) { thrown = true; }
	assert(thrown);

	thrown = false; try { t.assign("2003-10-19.24"); } catch(...) { thrown = true; }
	assert(thrown);

	thrown = false; try { t.assign("2003-10-19.23"); } catch(...) { thrown = true; }
	assert(!thrown);
	assert(t.year() == 2003);
	assert(t.month() == 10);
	assert(t.day() == 19);
	assert(t.hour() == 23);
	assert(t.minute() == 0);
	assert(t.second() == 0);
	assert(t.resolution() == timestamp::resolution_hour);

	thrown = false; try { t.assign("2003-10-19.230"); } catch(...) { thrown = true; }
	assert(thrown);

	thrown = false; try { t.assign("2003-10-19.2307"); } catch(...) { thrown = true; }
	assert(!thrown);
	assert(t.year() == 2003);
	assert(t.month() == 10);
	assert(t.day() == 19);
	assert(t.hour() == 23);
	assert(t.minute() == 7);
	assert(t.second() == 0);
	assert(t.resolution() == timestamp::resolution_minute);

	thrown = false; try { t.assign("2003-10-19.23070"); } catch(...) { thrown = true; }
	assert(thrown);

	thrown = false; try { t.assign("2003-10-19.230708"); } catch(...) { thrown = true; }
	assert(!thrown);
	assert(t.year() == 2003);
	assert(t.month() == 10);
	assert(t.day() == 19);
	assert(t.hour() == 23);
	assert(t.minute() == 7);
	assert(t.second() == 8);
	assert(t.resolution() == timestamp::resolution_second);

	thrown = false; try { t.assign("2003-10-19.2307089"); } catch(...) { thrown = true; }
	assert(thrown);
}

int main(int argc, char const * argv[])
{
	try {
		test1();
		test2();
		test3();
	}
	catch(error e) {
		std::cerr << e;
		assert(0);
	}
	catch(...) {
		std::cerr << err_unknown;
		assert(0);
	}
	return(0);
}
