#include "config.h"

#include <iostream>
#include <string>
#include <cassert>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <errno.h>

#include "asserts.h"
#include "types.h"
#include "error.h"
#include "estring.h"
#include "fs.h"
#include "tstamp.h"
#include "rconfig.h"

// #define ERR_OUT(e) std::cerr << e;
#define ERR_OUT(e)

bool make_dir(const std::string& path)
{
	bool thrown;

	thrown = false;
	try {
		mk_dir(path);
	}
	catch(...) {
		thrown = true;
	}
	return(thrown == false);
}

void cleanup(void)
{
	assert(system("rm -fr ./test-rconfig.dir") == 0);
}

void setup(void)
{
	std::ofstream out;

	assert(make_dir("./test-rconfig.dir"));
	assert(make_dir("./test-rconfig.dir/catalog.dir"));
	assert(make_dir("./test-rconfig.dir/log.dir"));
	assert(make_dir("./test-rconfig.dir/vaults"));
	assert(make_dir("./test-rconfig.dir/vaults/vault-1"));
	assert(make_dir("./test-rconfig.dir/vaults/vault-2"));
	assert(make_dir("./test-rconfig.dir/vaults/vault-3"));
	assert(make_dir("./test-rconfig.dir/excludes.dir"));

	out.open("./test-rconfig.dir/excludes.dir/excludes.group-A.file-1");
	assert(out.is_open());
	out.close();
	out.open("./test-rconfig.dir/excludes.dir/excludes.group-A.file-2");
	assert(out.is_open());
	out.close();
	out.open("./test-rconfig.dir/excludes.dir/excludes.group-A.file-3");
	assert(out.is_open());
	out.close();
	out.open("./test-rconfig.dir/excludes.dir/excludes.group-B.file-1");
	assert(out.is_open());
	out.close();
	out.open("./test-rconfig.dir/excludes.dir/excludes.group-B.file-2");
	assert(out.is_open());
	out.close();

	//
	// Configuration with nonexistent file
	//
	assert(make_dir("./test-rconfig.dir/nonexistent"));
	out.open("./test-rconfig.dir/nonexistent/default.conf");
	out << "include nonexistent-file.conf" << std::endl;
	assert(out.is_open());
	out.close();

	//
	// Test global include command
	//
	assert(make_dir("./test-rconfig.dir/global-include.dir"));

	out.open("./test-rconfig.dir/global-include.dir/file-1.conf");
	assert(out.is_open());
	out << "include nonexistent-file.conf" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-include.dir/file-2.conf");
	assert(out.is_open());
	out << "include file-2.1.conf" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-include.dir/file-2.1.conf");
	assert(out.is_open());
	out << "include file-2.2.conf" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-include.dir/file-3.conf");
	assert(out.is_open());
	out << "include file-3.1.conf" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-include.dir/file-3.1.conf");
	assert(out.is_open());
	out << "include file-3.2.conf"; // NOTE: No endl
	out.close();

	out.open("./test-rconfig.dir/global-include.dir/file-3.2.conf");
	assert(out.is_open());
	out.close();

	out.open("./test-rconfig.dir/global-include.dir/file-4.conf");
	assert(out.is_open());
	out << "include file-4.1.conf" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-include.dir/file-4.1.conf");
	assert(out.is_open());
	out << std::endl;
	out << std::endl;
	out << "include file-4.2.conf" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-include.dir/file-4.2.conf");
	assert(out.is_open());
	out << std::endl;
	out << "include " << std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-include.dir/file-5.conf");
	assert(out.is_open());
	out << "include file-5.1.conf" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-include.dir/file-5.1.conf");
	assert(out.is_open());
	out << std::endl;
	out << std::endl;
	out << "include file-5.2.conf" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-include.dir/file-5.2.conf");
	assert(out.is_open());
	out << std::endl;
	out << "include file-5.conf" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-include.dir/file-6.conf");
	assert(out.is_open());
	out << "# This is a comment" << std::endl;
	out << "# include" << std::endl;
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-include.dir/file-7.conf");
	assert(out.is_open());
	out << "include file-7.dir/file-7.1.conf" << std::endl;
	out.close();

	assert(make_dir("./test-rconfig.dir/global-include.dir/file-7.dir"));

	out.open("./test-rconfig.dir/global-include.dir/file-7.dir/file-7.1.conf");
	assert(out.is_open());
	out << "include ../file-7.2.conf" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-include.dir/file-7.2.conf");
	assert(out.is_open());
	out << "include file-7.dir/dir.2/*" << std::endl;
	out.close();

	assert(make_dir("./test-rconfig.dir/global-include.dir/file-7.dir/dir.2"));

	out.open("./test-rconfig.dir/global-include.dir/file-7.dir/dir.2/file-7.3.1.conf");
	assert(out.is_open());
	out.close();

	out.open("./test-rconfig.dir/global-include.dir/file-7.dir/dir.2/file-7.3.2.conf");
	assert(out.is_open());
	out.close();

	out.open("./test-rconfig.dir/global-include.dir/file-7.dir/dir.2/file-7.3.3.conf");
	assert(out.is_open());
	out.close();

	out.open("./test-rconfig.dir/global-include.dir/file-7.dir/dir.2/file-7.3.4.conf");
	assert(out.is_open());
	out << "include ../../nonexistent-file.conf" << std::endl;
	out.close();

	//
	// Test global default command
	// Test global include-job command
	// Test global job command
	//
	assert(make_dir("./test-rconfig.dir/job-include.dir"));

	out.open("./test-rconfig.dir/job-include.dir/file-1.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "<default>" << std::endl;
	out << "	path /var/spool" << std::endl;
	out << "</default>" << std::endl;
	out << std::endl;
	out << "<job>" << std::endl;
	out << "	hostname host-A" << std::endl;
	out << "</job>" << std::endl;
	out << "include file-1.job-1.job" << std::endl;
	out << "include-job file-1.job-2.job" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/job-include.dir/file-1.job-1.job");
	assert(out.is_open());
	out << "<job>" << std::endl;
	out << "	include file-1.job-1.2.job" << std::endl;
	out << "</job>" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/job-include.dir/file-1.job-1.2.job");
	assert(out.is_open());
	out << "hostname host-B" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/job-include.dir/file-1.job-2.job");
	assert(out.is_open());
	out << "hostname host-C" << std::endl;
	out.close();

	//
	// Test global link-catalog-dir command
	//
	assert(make_dir("./test-rconfig.dir/global-link-catalog-dir.dir"));

	out.open("./test-rconfig.dir/global-link-catalog-dir.dir/file-1.conf");
	assert(out.is_open());
	out << "link-catalog-dir ./test-rconfig.dir/dne-catalog.dir" << std::endl;
	out.close();
	
	out.open("./test-rconfig.dir/global-link-catalog-dir.dir/file-2.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "link-catalog-dir ./test-rconfig.dir/catalog.dir" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-link-catalog-dir.dir/file-3.conf");
	assert(out.is_open());
	out << "link-catalog-dir ./test-rconfig.dir/global-link-catalog-dir.dir/file-1.conf" << std::endl;
	out.close();

	//
	// Test global log-dir command
	//
	assert(make_dir("./test-rconfig.dir/global-log-dir.dir"));

	out.open("./test-rconfig.dir/global-log-dir.dir/file-1.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/dne-log.dir" << std::endl;
	out.close();
	
	out.open("./test-rconfig.dir/global-log-dir.dir/file-2.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-log-dir.dir/file-3.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/global-log-dir.dir/file-1.conf" << std::endl;
	out.close();

	//
	// Test global rsync-local-path command
	//
	assert(make_dir("./test-rconfig.dir/global-rsync-local-path.dir"));

	out.open("./test-rconfig.dir/global-rsync-local-path.dir/file-1.conf");
	assert(out.is_open());
	out 
		<< "rsync-local-path ./test-rconfig.dir/global-rsync-local-path.dir/nonexistent-path" 
		<< std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-rsync-local-path.dir/file-2.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out
		<< "rsync-local-path "
		<< "./test-rconfig.dir/global-rsync-local-path.dir/file-1.conf"
		<< std::endl;
	out.close();

	//
	// Test global rsync-parallel command
	//
	assert(make_dir("./test-rconfig.dir/global-rsync-parallel.dir"));

	out.open("./test-rconfig.dir/global-rsync-parallel.dir/file-1.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "rsync-parallel 0" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-rsync-parallel.dir/file-2.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "rsync-parallel 2" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-rsync-parallel.dir/file-3.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "rsync-parallel 100" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-rsync-parallel.dir/file-4.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "rsync-parallel abc" << std::endl;
	out.close();

	//
	// Test global timestamp-resolution command
	//
	assert(make_dir("./test-rconfig.dir/global-timestamp-resolution.dir"));

	out.open("./test-rconfig.dir/global-timestamp-resolution.dir/file-1.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "timestamp-resolution month" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-timestamp-resolution.dir/file-2.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "timestamp-resolution leap-year" << std::endl;
	out.close();

	//
	// Test global vault command
	//
	assert(make_dir("./test-rconfig.dir/global-vault.dir"));
	
	out.open("./test-rconfig.dir/global-vault.dir/file-1.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out 
		<< "vault ./test-rconfig.dir/global-vault.dir/nonexistent-vault.dir"
		<< std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-vault.dir/file-2.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out 
		<< "vault ./test-rconfig.dir/global-vault.dir/file-1.conf"
		<< std::endl;
	out.close();

	assert(make_dir("./test-rconfig.dir/global-vault.dir/00-vault.dir"));

	out.open("./test-rconfig.dir/global-vault.dir/file-3.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out 
		<< "vault ./test-rconfig.dir/global-vault.dir/*"
		<< std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-vault.dir/file-4.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out 
		<< "vault ./test-rconfig.dir/vaults/*"
		<< std::endl;
	out.close();

	assert(make_dir("./test-rconfig.dir/global-vault-2.dir/"));
	assert(make_dir("./test-rconfig.dir/global-vault-2.dir/vaults"));
	assert(make_dir("./test-rconfig.dir/global-vault-2.dir/vaults/1"));
	assert(make_dir("./test-rconfig.dir/global-vault-2.dir/vaults/3"));
	assert(make_dir("./test-rconfig.dir/global-vault-2.dir/vaults/4"));

	out.open("./test-rconfig.dir/global-vault-2.dir/vaults/2");
	assert(out.is_open());
	out << "Hello World" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-vault-2.dir/file-1.conf");
	assert(out.is_open());
	out
		<< "log-dir ./test-rconfig.dir/log.dir"
		<< std::endl;
	out
		<< "vault ./test-rconfig.dir/global-vault-2.dir/vaults/*"
		<< std::endl;
	out.close();

	//
	// Test global vault-overflow-behavior command
	//
	assert(make_dir("./test-rconfig.dir/global-vault-overflow-behavior.dir"));

	out.open("./test-rconfig.dir/global-vault-overflow-behavior.dir/file-1.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "vault-overflow-behavior lksdjflkj" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-vault-overflow-behavior.dir/file-2.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "vault-overflow-behavior delete-oldest" << std::endl;
	out.close();

	//
	// Test global vault-overflow-blocks command
	//
	assert(make_dir("./test-rconfig.dir/global-vault-overflow-blocks.dir"));

	out.open("./test-rconfig.dir/global-vault-overflow-blocks.dir/file-1.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "vault-overflow-blocks 0" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-vault-overflow-blocks.dir/file-2.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "vault-overflow-blocks 51" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-vault-overflow-blocks.dir/file-3.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "vault-overflow-blocks 50" << std::endl;
	out.close();

	//
	// Test global vault-overflow-inodes command
	//
	assert(make_dir("./test-rconfig.dir/global-vault-overflow-inodes.dir"));

	out.open("./test-rconfig.dir/global-vault-overflow-inodes.dir/file-1.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "vault-overflow-inodes 0" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-vault-overflow-inodes.dir/file-2.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "vault-overflow-inodes 51" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-vault-overflow-inodes.dir/file-3.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "vault-overflow-inodes 25" << std::endl;
	out.close();

	//
	// Test global vault-selection-behavior command
	//
	assert(make_dir("./test-rconfig.dir/global-vault-selection-behavior.dir"));

	out.open("./test-rconfig.dir/global-vault-selection-behavior.dir/file-1.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "vault-selection-behavior lolksjdf" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-vault-selection-behavior.dir/file-2.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "vault-selection-behavior max-free" << std::endl;
	out.close();

	//
	// Test vault-locking command
	//
	assert(make_dir("./test-rconfig.dir/global-vault-locking.dir"));

	out.open("./test-rconfig.dir/global-vault-locking.dir/file-1.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-vault-locking.dir/file-2.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "vault-locking no" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/global-vault-locking.dir/file-3.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "vault-locking yes" << std::endl;
	out.close();

	//
	// Test job commands
	//
	assert(make_dir("./test-rconfig.dir/job.dir"));

	out.open("./test-rconfig.dir/job.dir/exclude-file-1");
	assert(out.is_open());
	out.close();

	out.open("./test-rconfig.dir/job.dir/exclude-file-2");
	assert(out.is_open());
	out.close();

	out.open("./test-rconfig.dir/job.dir/exclude-file-3");
	assert(out.is_open());
	out.close();

	out.open("./test-rconfig.dir/job.dir/file-1.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "<default>" << std::endl;
	out << std::endl << std::endl;
	out << "	booga-booga!" << std::endl;
	out << "</default>" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/job.dir/file-2.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << std::endl;
	out << "include-job file-2.1.conf" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/job.dir/file-2.1.conf");
	out << std::endl << std::endl << std::endl;
	assert(out.is_open());
	out << "booga-booga again!" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/job.dir/file-3.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "<default>" << std::endl << std::endl;
	out << "	include file-3.1.conf" << std::endl;
	out << "</default>" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/job.dir/file-3.1.conf");
	assert(out.is_open());
	out << "booga?" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/job.dir/file-4.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "<default>" << std::endl;
	out << "	archive-path	groupname/\"literal-text\"/jobname" << std::endl;
	out << "</default>" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/job.dir/file-5.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "<default>" << std::endl;
	out << "	exclude-from ../excludes.dir/excludes.group-A.file-1" << std::endl;
	out << "</default>" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/job.dir/file-6.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "<default>" << std::endl;
	out << "	exclude-from ../excludes.dir/excludes.group-A.*" << std::endl;
	out << "	rsync-connection-type local" << std::endl;
	out << "	path /var/spool" << std::endl;
	out << "</default>" << std::endl;
	out << "<job>" << std::endl;
	out << "	exclude-from ../excludes.dir/excludes.group-B.file-2" << std::endl;
	out << "	hostname gus-A" << std::endl;
	out << "</job>" << std::endl;
	out << "<default>" << std::endl;
	out << "	exclude-from ../excludes.dir/excludes.group-B.file-1" << std::endl;
	out << "	rsync-connection-type local" << std::endl;
	out << "	path /var/spool" << std::endl;
	out << "</default>" << std::endl;
	out << "<job>" << std::endl;
	out << "	exclude-from ../excludes.dir/excludes.group-A.file-3" << std::endl;
	out << "	hostname gus-B" << std::endl;
	out << "</job>" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/job.dir/file-7.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "<default>" << std::endl;
	out << "	groupname group-A" << std::endl;
	out << "	hostname	host-A" << std::endl;
	out << "	rsync-behavior clear" << std::endl;
	out << "	rsync-behavior * = fail" << std::endl;
	out << "	rsync-behavior 5 = ok" << std::endl;
	out << "	rsync-connection-type	server" << std::endl;
	out << "	rsync-hardlink off" << std::endl;
	out << "	rsync-options --some  -options for-rsync" << std::endl;
	out << "	rsync-remote-user alice" << std::endl;
	out << "	rsync-remote-port	4338" << std::endl;
	out << "	path /var/spool" << std::endl;
	out << "</default>" << std::endl;
	out << "<job>" << std::endl;
	out << "	jobname		job-A" << std::endl;
	out << "	rsync-behavior reset" << std::endl;
	out << "	rsync-connection-type	local" << std::endl;
	out << "	rsync-hardlink on" << std::endl;
	out << "	<rsync-options>" << std::endl;
	out << "		some more" << std::endl;
	out << "		\"options for\"" << std::endl;
	out << "			the\\trsync\\ program" << std::endl;
	out << "	</rsync-options>" << std::endl;
	out << "	rsync-remote-user" << std::endl;
	out << "	rsync-remote-port" << std::endl;
	out << "</job>" << std::endl;
	out << "<job>" << std::endl;
	out << "	hostname host-B" << std::endl;
	out << "</job>" << std::endl;
	out << "<job>" << std::endl;
	out << "  hostname host-C" << std::endl;
	out << "  rsync-hardlink on" << std::endl;
	out << "  rsync-multi-hardlink on" << std::endl;
	out << "  rsync-multi-hardlink-max 7" << std::endl;
	out << "</job>" << std::endl;
	out << "<job>" << std::endl;
	out << "	jobname		job-D" << std::endl;
	out << "  hostname  host-D" << std::endl;
	out << "	rsync-behavior reset" << std::endl;
	out << "	rsync-connection-type	remote" << std::endl;
	out << "	rsync-hardlink on" << std::endl;
	out << "	<rsync-options>" << std::endl;
	out << "		-e \"-i foo\"" << std::endl;
	out << "	</rsync-options>" << std::endl;
	out << "	rsync-remote-user" << std::endl;
	out << "	rsync-remote-port" << std::endl;
	out << "</job>" << std::endl;
	out << "<job>" << std::endl;
	out << "	jobname		job-E" << std::endl;
	out << "  hostname  host-E" << std::endl;
	out << "	rsync-behavior reset" << std::endl;
	out << "	rsync-connection-type	remote" << std::endl;
	out << "	rsync-hardlink on" << std::endl;
	out << "	<rsync-options>" << std::endl;
	out << "		--rsh=\"/usr/bin/rsh -i foo\"" << std::endl;
	out << "	</rsync-options>" << std::endl;
	out << "	rsync-remote-user" << std::endl;
	out << "	rsync-remote-port" << std::endl;
	out << "</job>" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/job.dir/file-8.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "<default>" << std::endl;
	out << "	jobname	job-A" << std::endl;
	out << "</default>" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/job.dir/file-9.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "<job>" << std::endl;
	out << "	rsync-connection-type local" << std::endl;
	out << "	archive-path jobname" << std::endl;
	out << "	path	/var/spool" << std::endl;
	out << "</job>" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/job.dir/file-10.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "<job>" << std::endl;
	out << "	rsync-connection-type local" << std::endl;
	out << "	archive-path groupname" << std::endl;
	out << "	path	/var/spool" << std::endl;
	out << "</job>" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/job.dir/file-11.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "<job>" << std::endl;
	out << "	rsync-connection-type local" << std::endl;
	out << "	archive-path hostname" << std::endl;
	out << "	path	/var/spool" << std::endl;
	out << "</job>" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/job.dir/file-12.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "<default>" << std::endl;
	out << "	rsync-connection-type local" << std::endl;
	out << "	path /var/spool" << std::endl;
	out << "</default>" << std::endl;
	out << "<job>" << std::endl;
	out << "	archive-path permutation" << std::endl;
	out << "</job>" << std::endl;
	out << "<job>" << std::endl;
	out << "	jobname job-A" << std::endl;
	out << "	archive-path permutation/jobname" << std::endl;
	out << "</job>" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/job.dir/file-13.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "<default>" << std::endl;
	out << "	rsync-connection-type local" << std::endl;
	out << "	path /var/spool" << std::endl;
	out << "	clear rsync-behavior" << std::endl;
	out << "	clear archive-path" << std::endl;
	out << "	archive-path pathname" << std::endl;
	out << "</default>" << std::endl;
	out << "<job>" << std::endl;
	out << "</job>" << std::endl;
	out << "<job>" << std::endl;
	out << "	clear paths" << std::endl;
	out << "	path /etc" << std::endl;
	out << "</job>" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/job.dir/file-14.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "<default>" << std::endl;
	out << "	path /var/spool" << std::endl;
	out << "</default>" << std::endl;
	out << "<job>" << std::endl;
	out << "	hostname local-default" << std::endl;
	out << "	rsync-connection-type local" << std::endl;
	out << "</job>" << std::endl;
	out << "<job>" << std::endl;
	out << "	hostname local-port" << std::endl;
	out << "	rsync-connection-type local" << std::endl;
	out << "	rsync-remote-port 1234" << std::endl;
	out << "</job>" << std::endl;
	out << "<job>" << std::endl;
	out << "	hostname remote-default" << std::endl;
	out << "	rsync-connection-type remote" << std::endl;
	out << "</job>" << std::endl;
	out << "<job>" << std::endl;
	out << "	hostname remote-port" << std::endl;
	out << "	rsync-connection-type remote" << std::endl;
	out << "	rsync-remote-port 1234" << std::endl;
	out << "</job>" << std::endl;
	out << "<job>" << std::endl;
	out << "	hostname server-default" << std::endl;
	out << "	rsync-connection-type server" << std::endl;
	out << "</job>" << std::endl;
	out << "<job>" << std::endl;
	out << "	hostname server-port" << std::endl;
	out << "	rsync-connection-type server" << std::endl;
	out << "	rsync-remote-port 1234" << std::endl;
	out << "</job>" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/job.dir/file-15.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "<default>" << std::endl;
	out << "	path /var/spool" << std::endl;
	out << "</default>" << std::endl;
	out << "<job>" << std::endl;
	out << "	rsync-connection-type local" << std::endl;
	out << "	rsync-hardlink yes" << std::endl;
	out << "	rsync-timeout 600" << std::endl;
	out << "	rsync-retry-count 6" << std::endl;
	out << "	<rsync-options>" << std::endl;
	out << "		-a" << std::endl;
	out << "		--delete" << std::endl;
	out << "		--delete-excluded" << std::endl;
	out << "		--force" << std::endl;
	out << "		--ignore-errors" << std::endl;
	out << "		--one-file-system" << std::endl;
	out << "		--progress" << std::endl;
	out << "	</rsync-options>" << std::endl;
	out << "	archive-path pathname" << std::endl;
	out << "	path /net/host-name.domain.name/home/" << std::endl;
	out << "	path /net/host-name.domain.name/root/" << std::endl;
	out << "	path /net/host-name.domain.name/etc/" << std::endl;
	out << "	path /net/host-name.domain.name/boot/" << std::endl;
	out << "</job>" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/job.dir/file-16.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "<job>" << std::endl;
	out << "	rsync-connection-type local" << std::endl;
	out << "	rsync-hardlink yes" << std::endl;
	out << "	rsync-timeout 600" << std::endl;
	out << "	rsync-retry-count 6" << std::endl;
	out << "	<rsync-options>" << std::endl;
	out << "		-a" << std::endl;
	out << "		--delete" << std::endl;
	out << "		--delete-excluded" << std::endl;
	out << "		--force" << std::endl;
	out << "		--ignore-errors" << std::endl;
	out << "		--one-file-system" << std::endl;
	out << "		--progress" << std::endl;
	out << "	</rsync-options>" << std::endl;
	out << "	archive-path pathname" << std::endl;
	out << "	path /net/host-name.domain.name/home/" << std::endl;
	out << "	path /net/host-name.domain.name/root/" << std::endl;
	out << "	path /net/host-name.domain.name/etc/" << std::endl;
	out << "	path /net/host-name.domain.name/boot/" << std::endl;
	out << "</job>" << std::endl;
	out.close();

	assert(make_dir("./test-rconfig.dir/old-log-files.dir"));

	out.open("./test-rconfig.dir/old-log-files.dir/file-1.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "<job>" << std::endl;
	out << "	rsync-connection-type local" << std::endl;
	out << "	rsync-hardlink yes" << std::endl;
	out << "	rsync-timeout 600" << std::endl;
	out << "	rsync-retry-count 6" << std::endl;
	out << "	<rsync-options>" << std::endl;
	out << "		-a" << std::endl;
	out << "		--delete" << std::endl;
	out << "		--delete-excluded" << std::endl;
	out << "		--force" << std::endl;
	out << "		--ignore-errors" << std::endl;
	out << "		--one-file-system" << std::endl;
	out << "		--progress" << std::endl;
	out << "	</rsync-options>" << std::endl;
	out << "	archive-path pathname" << std::endl;
	out << "	path /net/host-name.domain.name/home/" << std::endl;
	out << "	path /net/host-name.domain.name/root/" << std::endl;
	out << "	path /net/host-name.domain.name/etc/" << std::endl;
	out << "	path /net/host-name.domain.name/boot/" << std::endl;
	out << "</job>" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/old-log-files.dir/file-2.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "delete-old-log-files yes" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "<job>" << std::endl;
	out << "	rsync-connection-type local" << std::endl;
	out << "	rsync-hardlink yes" << std::endl;
	out << "	rsync-timeout 600" << std::endl;
	out << "	rsync-retry-count 6" << std::endl;
	out << "	<rsync-options>" << std::endl;
	out << "		-a" << std::endl;
	out << "		--delete" << std::endl;
	out << "		--delete-excluded" << std::endl;
	out << "		--force" << std::endl;
	out << "		--ignore-errors" << std::endl;
	out << "		--one-file-system" << std::endl;
	out << "		--progress" << std::endl;
	out << "	</rsync-options>" << std::endl;
	out << "	archive-path pathname" << std::endl;
	out << "	path /net/host-name.domain.name/home/" << std::endl;
	out << "	path /net/host-name.domain.name/root/" << std::endl;
	out << "	path /net/host-name.domain.name/etc/" << std::endl;
	out << "	path /net/host-name.domain.name/boot/" << std::endl;
	out << "</job>" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/old-log-files.dir/file-3.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "delete-old-report-files yes" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "<job>" << std::endl;
	out << "	rsync-connection-type local" << std::endl;
	out << "	rsync-hardlink yes" << std::endl;
	out << "	rsync-timeout 600" << std::endl;
	out << "	rsync-retry-count 6" << std::endl;
	out << "	<rsync-options>" << std::endl;
	out << "		-a" << std::endl;
	out << "		--delete" << std::endl;
	out << "		--delete-excluded" << std::endl;
	out << "		--force" << std::endl;
	out << "		--ignore-errors" << std::endl;
	out << "		--one-file-system" << std::endl;
	out << "		--progress" << std::endl;
	out << "	</rsync-options>" << std::endl;
	out << "	archive-path pathname" << std::endl;
	out << "	path /net/host-name.domain.name/home/" << std::endl;
	out << "	path /net/host-name.domain.name/root/" << std::endl;
	out << "	path /net/host-name.domain.name/etc/" << std::endl;
	out << "	path /net/host-name.domain.name/boot/" << std::endl;
	out << "</job>" << std::endl;
	out.close();

	out.open("./test-rconfig.dir/old-log-files.dir/file-4.conf");
	assert(out.is_open());
	out << "log-dir ./test-rconfig.dir/log.dir" << std::endl;
	out << "delete-old-log-files yes" << std::endl;
	out << "delete-old-report-files yes" << std::endl;
	out << "vault ./test-rconfig.dir/vaults/vault-1" << std::endl;
	out << "<job>" << std::endl;
	out << "	rsync-connection-type local" << std::endl;
	out << "	rsync-hardlink yes" << std::endl;
	out << "	rsync-timeout 600" << std::endl;
	out << "	rsync-retry-count 6" << std::endl;
	out << "	<rsync-options>" << std::endl;
	out << "		-a" << std::endl;
	out << "		--delete" << std::endl;
	out << "		--delete-excluded" << std::endl;
	out << "		--force" << std::endl;
	out << "		--ignore-errors" << std::endl;
	out << "		--one-file-system" << std::endl;
	out << "		--progress" << std::endl;
	out << "	</rsync-options>" << std::endl;
	out << "	archive-path pathname" << std::endl;
	out << "	path /net/host-name.domain.name/home/" << std::endl;
	out << "	path /net/host-name.domain.name/root/" << std::endl;
	out << "	path /net/host-name.domain.name/etc/" << std::endl;
	out << "	path /net/host-name.domain.name/boot/" << std::endl;
	out << "</job>" << std::endl;
	out.close();

}

