#include "config.h"

#include <unistd.h>

#include "error.h"
#include "fdstream.h"

//-----------------------------------------------------------------------------

fdoutbuf::fdoutbuf()
{
}

fdoutbuf::fdoutbuf(int a_fd)
{
	attach(a_fd);
}

void fdoutbuf::attach(int a_fd)
{
	m_fd = a_fd;
}

int fdoutbuf::overflow(int a_c)
{
	if (a_c != EOF) {
		char z = a_c;
		if (::write(m_fd, &z, 1) != 1)
			return(EOF);
	}
	return(a_c);
}

std::streamsize fdoutbuf::xsputn(const char* a_s, std::streamsize a_num)
{
	return(::write(m_fd, a_s, a_num));
}

//-----------------------------------------------------------------------------

ofdstream::ofdstream() : std::ostream(&m_buf)
{
}

ofdstream::ofdstream(int a_fd) : std::ostream(&m_buf)
{
	m_fd = a_fd;
	m_buf.attach(a_fd);
}

void ofdstream::attach(int a_fd)
{
	m_fd = a_fd;
	m_buf.attach(a_fd);
}

int ofdstream::fd(void)
{
	return(m_fd);
}

//-----------------------------------------------------------------------------

fdinbuf::fdinbuf()
{
	setg(m_buffer+4, m_buffer+4, m_buffer+4);
}

fdinbuf::fdinbuf(int a_fd)
{
	m_fd = a_fd;
	setg(m_buffer+4, m_buffer+4, m_buffer+4);
}

void fdinbuf::attach(int a_fd)
{
	m_fd = a_fd;
}

int fdinbuf::underflow(void)
{
	int num_put_back;
	int num;

	if (gptr() < egptr()) {
		return(*gptr());
	}

	num_put_back = gptr() - eback();
	if (num_put_back > 0)
		num_put_back = 4;
	
	memcpy(m_buffer+(4-num_put_back), gptr()-num_put_back, num_put_back);

	num = ::read(m_fd, m_buffer+4, m_buffer_size-4);
	if (num <= 0)
		return(EOF);
	
	setg(m_buffer+(4-num_put_back), m_buffer+4, m_buffer+4+num);

	return(*gptr());
}

//-----------------------------------------------------------------------------

ifdstream::ifdstream() : std::istream(&m_buf)
{
}

ifdstream::ifdstream(int a_fd) : std::istream(&m_buf)
{
	m_fd = a_fd;
	m_buf.attach(a_fd);
}

void ifdstream::attach(int a_fd)
{
	m_fd = a_fd;
	m_buf.attach(a_fd);
}

int ifdstream::fd(void)
{
	return(m_fd);
}

//-----------------------------------------------------------------------------

