#include "config.h"

#include <iostream>
#include <fstream>
#include <iomanip>
#include <string>
#include <cassert>

#include "error.h"
#include "fs.h"
#include "vaulter.h"
#include "test-vaulter-setup.h"

#define ERR_OUT(e) std::cerr << e
// #define ERR_OUT(e)

void test_vaulter1(void)
{
	char const * argv[256] = { 0 };
	int argc = 0;
	bool thrown = false;

	argv[argc++] = "<program>";
	argv[argc++] = "--archive";
	argv[argc++] = "--timestamp";
	argv[argc++] = "2003-09-16";

	config.default_file("./test-vaulter.dir/file-1.conf");
	try {
		config.init(argc, argv);
		logger.init();
		vaulter.init();
		vaulter.select();
		logger.clear();
		assert(vaulter.vault() == "./test-vaulter.dir/group-1/vault-2");
	}
	catch(error e) {
		ERR_OUT(e);
		thrown = true;
	}
	catch(...) {
		ERR_OUT(err_unknown);
		assert(0);
	}
	assert(!thrown);
}

void test_vaulter2(void)
{
	char const * argv[256] = { 0 };
	int argc = 0;
	bool thrown = false;

	argv[argc++] = "<program>";
	argv[argc++] = "--archive";
	argv[argc++] = "--timestamp";
	argv[argc++] = "2003-09-18";

	config.default_file("./test-vaulter.dir/file-1.conf");
	try {
		config.init(argc, argv);
		logger.init();
		vaulter.init();
		vaulter.select();
		logger.clear();
		assert(vaulter.vault() == "./test-vaulter.dir/group-1/vault-1");
	}
	catch(error e) {
		ERR_OUT(e);
		thrown = true;
	}
	catch(...) {
		ERR_OUT(err_unknown);
		assert(0);
	}
	assert(!thrown);
}

void test_vaulter3(void)
{
	char const * argv[256] = { 0 };
	int argc = 0;
	bool thrown = false;

	argv[argc++] = "<program>";
	argv[argc++] = "--archive";
	argv[argc++] = "--timestamp";
	argv[argc++] = "2003-09-18";

	config.default_file("./test-vaulter.dir/file-1.conf");
	try {
		config.init(argc, argv);
		logger.init();
		vaulter.init();
		vaulter.select();
		logger.clear();
		assert(vaulter.vault() == "./test-vaulter.dir/group-1/vault-1");

		subdirectory subdir = vaulter.get_archive_list();
		subdirectory::iterator sdi;

		for (sdi = subdir.begin(); sdi != subdir.end(); sdi++) {
			assert((*sdi).find(".corrupt") == std::string::npos);
		}
	}
	catch(error e) {
		ERR_OUT(e);
		thrown = true;
	}
	catch(...) {
		ERR_OUT(err_unknown);
		assert(0);
	}
	assert(!thrown);
}

int main(int argc, char const * argv[])
{
	cleanup();
	setup();
	try {
		test_vaulter1();
		test_vaulter2();
		test_vaulter3();
	}
	catch(error e) {
		std::cerr << e;
		assert(0);
	}
	catch(...) {
		std::cerr << err_unknown;
		assert(0);
	}
	cleanup();
	return(0);
}

