#include "config.h"

#include <iostream>
#include <string>
#include <cassert>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <errno.h>

#include "asserts.h"
#include "types.h"
#include "error.h"
#include "estring.h"
#include "fs.h"
#include "tstamp.h"
#include "rconfig.h"
#include "test-rconfig-setup.h"

#define ERR_OUT(e) std::cerr << e;
// #define ERR_OUT(e)

void test(void)
{
	char const * argv[256] = { 0 };
	int argc = 0;
	bool thrown = false;

	argv[argc++] = "<program>";
	argv[argc++] = "--archive";

	config.default_file("./test-rconfig.dir/job.dir/file-14.conf");
	config.default_logdir("./test-rconfig.dir/log.dir");
	try {
		config.init(argc, argv);
	}
	catch(error e) {
		ERR_OUT(e);
		thrown = true;
	}
	catch(...) {
		assert(0);
	}
	assert(!thrown);
	assert(config.jobs().size() == 6);
	assert(config.jobs()[0].generate_source_path("/var/spool/") == "/var/spool/");
	assert(config.jobs()[1].generate_source_path("/var/spool/") == "/var/spool/");
	assert(config.jobs()[2].generate_source_path("/var/spool/") == "remote-default:/var/spool/");
	assert(config.jobs()[3].generate_source_path("/var/spool/") == "remote-port:/var/spool/");
	assert(config.jobs()[4].generate_source_path("/var/spool/") == "rsync://server-default/var/spool/");
	assert(config.jobs()[5].generate_source_path("/var/spool/") == "rsync://server-port:1234/var/spool/");
}

int main(int argc, char const * argv[])
{
	cleanup();
	setup();
	try {
		test();
	}
	catch(error e) {
		std::cerr << e;
		assert(0);
	}
	catch(...) {
		std::cerr << err_unknown;
		assert(0);
	}
	cleanup();
	return(0);
}

