#include "config.h"

#include <iostream>
#include <string>
#include <cassert>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <errno.h>

#include "asserts.h"
#include "types.h"
#include "error.h"
#include "estring.h"
#include "fs.h"
#include "tstamp.h"
#include "rconfig.h"
#include "test-rconfig-setup.h"

#define ERR_OUT(e) std::cerr << e;
// #define ERR_OUT(e)

void test(void)
{
	char const * argv[256] = { 0 };
	int argc = 0;
	bool thrown = false;

	argv[argc++] = "<program>";
	argv[argc++] = "--archive";

	config.default_file("./test-rconfig.dir/job.dir/file-4.conf");
	config.default_logdir("./test-rconfig.dir/log.dir");
	try {
		config.init(argc, argv);
	}
	catch(error e) {
		ERR_OUT(e);
		thrown = true;
	}
	catch(...) {
		assert(0);
	}
	assert(!thrown);
	assert(config.default_job().archive_path.size() == 3);
	assert(config.default_job().archive_path[0].type() 
		== archive_path_element::groupname);
	assert(config.default_job().archive_path[1].type()
		== archive_path_element::literal);
	assert(config.default_job().archive_path[1].value()
		== "literal-text");
	assert(config.default_job().archive_path[2].type()
		== archive_path_element::jobname);
	assert(config.default_job().archive_path.str()
		== "groupname/\"literal-text\"/jobname");
}

int main(int argc, char const * argv[])
{
	cleanup();
	setup();
	try {
		test();
	}
	catch(error e) {
		std::cerr << e;
		assert(0);
	}
	catch(...) {
		std::cerr << err_unknown;
		assert(0);
	}
	cleanup();
	return(0);
}

