#ifndef __logger_h__
#define __logger_h__

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <iostream>
#include <string>

#include "asserts.h"
#include "types.h"
#include "fs.h"
#include "rconfig.h"

/** Write information to a log file */
class log_manager {
public:
	log_manager();

	void clear(void);
	void init(void);
	const bool initialized(void) const;

	void write(
		const std::string& a_str,
		const uint16 a_indention = 0,
		const configuration_manager::logging_type a_logging_level
			= configuration_manager::logging_manager,
		const pid_t a_pid = pid()
		);

	void set_error_logging(bool a_b);

private:
	bool m_new_line;
	std::ofstream m_out;
	bool m_initialized;
	bool m_use_error_logging_level;
};

extern log_manager logger;

#endif
