#ifndef __exec_h__
#define __exec_h__

#include <iostream>
#include <vector>
#include <string>

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_SIGNAL_H
#include <signal.h>
#endif

#include "asserts.h"

/** Fork a child process or execute an external program */
class execute
{
public:
	execute();
	~execute();

	void fork(void);
	void clear(void);
	bool is_child(void);
	bool is_parent(void);
	pid_t my_pid(void);

	// Child-specific functions:
	void exit(int code = 0);					// For child, exit with code
	void reroute_stdio(void);					// Re-route stdin/out/err to parent

	// Parent-specific functions:
	pid_t child_pid(void);						// PID of child process
	void signal_child(int signal_no);	// Send signal to child
	void hup_child(void);							// Send child HUP signal
	void kill_child(void);						// Send child KILL signal
	void wait(void);									// Wait for child to exit
	bool child_started(void) const;		// True if child has been started
	bool child_running(void);					// True if child is still running
	bool child_exited(void);					// True if child has exited
	bool child_exited_normally(void); // Exit code = 0, signal = ?
	bool child_signaled(void);				// Exit code = ?, signal = yes
	bool child_exited_success(void);  // Exit code = 0, signal = no
	int child_exit_code(void);				// Child's exit code
	int child_signal_no(void);				// Child's uncaught signal

	// Command execution
	void exec(const std::string command);
	void exec(const std::string binary, const std::vector<std::string> argv);

	int in_fd(void);
	int out_fd(void);
	int err_fd(void);
	bool in_ready(void);
	bool out_ready(void);
	bool err_ready(void);

	bool in_eof(void);
	bool out_eof(void);
	bool err_eof(void);
	int in_read(char* buf, const int len);
	int in_write(const char* buf, const int len);
	int out_read(char* buf, const int len);
	int out_write(const char* buf, const int len);
	int err_read(char* buf, const int len);
	int err_write(const char* buf, const int len);

	void print(std::ostream& out);

private:
	int m_fd1[2];
	int m_fd2[2];
	int m_fd3[2];
	pid_t m_pid;
	int m_status;
	bool m_in_eof;
	bool m_out_eof;
	bool m_err_eof;
	bool m_child_started;

	pid_t check_child_(void);
	bool check_write_ready_(int fd);
	bool check_read_ready_(int fd);
};

std::ostream& operator << (std::ostream& out, execute& exe);

#endif
