/// \file
/// \ingroup tutorial_tree
///
/// Copy a subset of a Tree to a new Tree, one branch in a separate file
///
/// One branch of the new Tree is written to a separate file
/// The input file has been generated by the program in $ROOTSYS/test/Event
/// with the command `Event 1000 1 1 1`
/// \macro_code
/// \author Rene Brun

void copytree2() {

   gSystem->Load("$ROOTSYS/test/libEvent");

   //Get old file, old tree and set top branch address
   TFile *oldfile = new TFile("$ROOTSYS/test/Event.root");
   TTree *oldtree = (TTree*)oldfile->Get("T");
   Event *event   = new Event();
   oldtree->SetBranchAddress("event",&event);
   oldtree->SetBranchStatus("*",0);
   oldtree->SetBranchStatus("event",1);
   oldtree->SetBranchStatus("fNtrack",1);
   oldtree->SetBranchStatus("fNseg",1);
   oldtree->SetBranchStatus("fH",1);


   //Create a new file + a clone of old tree header. Do not copy events
   TFile *newfile = new TFile("small.root","recreate");
   TTree *newtree = oldtree->CloneTree(0);

   //Divert branch fH to a separate file and copy all events
   newtree->GetBranch("fH")->SetFile("small_fH.root");
   newtree->CopyEntries(oldtree);

   newtree->Print();
   newfile->Write();
   delete oldfile;
   delete newfile;
}
