
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MODULE      : init-reduce.scm
;; DESCRIPTION : Initialize reduce plugin
;; COPYRIGHT   : (C) 1999, 2012  Joris van der Hoeven and Andrey Grozin
;;
;; This software falls under the GNU general public license version 3 or later.
;; It comes WITHOUT ANY WARRANTY WHATSOEVER. For details, see the file LICENSE
;; in the root directory or <http://www.gnu.org/licenses/gpl-3.0.html>.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; Modifications: Arthur C. Norman, Eberhard Schruefer

(define reduce-doc-dir #f)

(define (reduce-serialize lan t)
  (with s (string-drop-right (verbatim-serialize lan t) 1)
    (cond ((== s "") "0;\n")
          ((in? (string-ref s (- (string-length s) 1)) '(#\; #\$))
           (string-append s "\n"))
          (else (string-append s ";\n")))))

(define (reduce-launcher)
   (if (and (url-exists-in-path? "redcsl") (url-exists-in-path? "redpsl"))
       (list (list :launch "redcsl" "redcsl.bat --texmacs") 
             (list :launch "redpsl" "redpsl.bat --texmacs"))
       (if (url-exists-in-path? "redcsl")
          (list :launch "redcsl.bat --texmacs")
          (list :launch "redpsl.bat --texmacs"))))

(define (get-reduce-doc-dir reduce-bin-path)
  (set! reduce-bin-path (url-append reduce-bin-path (url-parent)))
  (set! reduce-bin-path (url-append reduce-bin-path (url-parent)))
  (set! reduce-doc-dir (url-append reduce-bin-path "csl/reduce.doc")) )

(plugin-configure reduce
  (:require (or (url-exists-in-path? "redcsl") (url-exists-in-path? "redpsl")))
  (:initialize (get-reduce-doc-dir (url-resolve-in-path "redcsl")))
  ,@(reduce-launcher)
  (:serializer ,reduce-serialize)
  (:session "Reduce")
  (:scripts "Reduce"))

(when (supports-reduce?)
  (import-from (reduce-kbd))
  (import-from (reduce-menus))
  (lazy-input-converter (reduce-input) reduce))

