/* Free Foundation Classes for thread ver.0.1.5
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $ffcthread: ffcmutex.cpp,v 1.9.0 2001/09/17 22:57:46 Toshihiro Inoue Exp $
 */

#include "ffcmutex.h"



void FFCMutex::__init_class__()
{
}


FFCMutex::FFCMutex()
{
  __init_class__();
  
  #ifdef WIN32
  InitializeCriticalSection(&mutex);
  #else
  pthread_mutex_init(&mutex, NULL);
  #endif
}


FFCMutex::~FFCMutex()
{
  #ifdef WIN32
  DeleteCriticalSection(&mutex);
  #else
  pthread_mutex_destroy(&mutex);
  #endif
}


void FFCMutex::lock()
{
  #ifdef WIN32
  EnterCriticalSection(&mutex);
  #else
  pthread_mutex_lock(&mutex);
  #endif
}


void FFCMutex::unlock()
{
  #ifdef WIN32
  LeaveCriticalSection(&mutex);
  #else
  pthread_mutex_unlock(&mutex);
  #endif
}
