/* Free Foundation Classes for network ver.0.2.6
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $ffcnetwork: ffcurl.cpp,v 1.16.5 2001/09/17 22:57:53 Toshihiro Inoue Exp $
 */

#include "ffcurl.h"




void FFCURL::__init_class__()
{
}


FFCURL::FFCURL(): FFCAddress()
{
  __init_class__();
  
}


FFCURL::FFCURL(const char* url): FFCAddress()
{
  __init_class__();
  
  setURL(url);
}


FFCURL::FFCURL(const FFCString& url): FFCAddress()
{
  __init_class__();
  
  setURL(url);
}


FFCURL::FFCURL(const FFCURL& url)
{
  __init_class__();
  
  operator=(url);
}


FFCString FFCURL::getURL() const
{
  FFCString ret;
  
  ret = "http://" + address;
  if(port != 80) ret += FFCString().sprintf(":%d", port);
  ret += path;
  return ret;
}


void FFCURL::setURL(const FFCString& url)
{
  FFCString ad;
  int p = 0;
  
  clear();
  path.erase();
  
  if(url.prefix("http://")) {
    ad = url.mid(7);
  } else {
    ad = url;
  }
  
  p = ad.find('/');
  if(p < 0) {
    path = "/";
  } else {
    path = ad.mid(p);
    ad = ad.left(p);
  }
  
  p = ad.find(':');
  if(p == 0) {
    address = "127.0.0.1";
  } else if(p > 0) {
    address = ad.left(p);
    port = ad.mid(p + 1).toInt();
  } else {
    address = ad;
  }
  if(port == 0) port = 80;
}


void FFCURL::setURL(FFCString url, FFCURL ref)
{
  if(url.prefix("http://")) {
    setURL(url);
    return;
  }
  
  clear();
  path = "/";
  address = ref.getAddress();
  port = ref.getPort();
  
  if(url.prefix("/")) {
    path = url;
    return;
  }
  
  for(;;) {
    if(url.prefix("./")) {
      url.directRemove(0, 2);
    } else if(url.prefix("../")) {
      ref.setURL(ref.getUpDir(), ref);
      url.directRemove(0, 3);
    } else {
      break;
    }
  }
  path = ref.getDir() + url;
  return;
}


FFCString FFCURL::getDir() const
{
  FFCString ret;
  int p = 0;
  
  if(address.empty()) return "";
  
  p = path.rfind('/');
  if(p < 0) return "/";
  
  return path.left(p + 1);
}


FFCString FFCURL::getUpDir() const
{
  FFCString ret;
  int p = 0;
  
  ret = getDir();
  if(ret.empty() || ret == "/") return ret;
  
  ret -= 1;
  p = ret.rfind('/');
  if(p < 0) return "/";
  
  return ret.left(p + 1);
}


FFCURL& FFCURL::operator=(const FFCString& url)
{
  setURL(url);
  return *this;
}


FFCURL& FFCURL::operator=(const char* url)
{
  setURL(url);
  return *this;
}


FFCURL& FFCURL::operator=(const FFCURL& url)
{
  FFCAddress::operator=(url);
  path = url.path;
  return *this;
}


FFCString FFCURL::encode(const FFCString& s)
{
  FFCString ret;
  FFCString x;
  int len = 0;
  int i = 0;
  int ch = 0;
  
  len = s.length();
  for(i = 0; i < len; i++) {
    ch = (unsigned char)s[i];
    if(
         ch == '*' || ch == '_' || ch == '.' || ch == '@' || ch == '-'
      || ('A' <= ch && ch <= 'Z') || ('a' <= ch && ch <= 'z')
      || ('0' <= ch && ch <= '9')
    ) {
      ret += char(ch);
    } else {
      ret += x.sprintf("%%%02x", int(ch));
    }
  }
  return ret;
}
