/* Free Foundation Classes for list ver.0.1.0
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $list: main.cpp,v 1.12.24 2001/09/17 22:57:49 Toshihiro Inoue Exp $
 */

#include "main.h"

#include <ffclist.h>
#include <ffcstring.h>

#include <iostream.h>
#include <ffcdictstring.h>


int main(int argc, char* argv[])
{
  FFCList lst;
  FFCDict dct;
  FFCDictString dcts;
  int i = 0;
  FFCString k;
  
  lst += (void*)"abc";
  lst += (void*)"def";
  lst += (void*)"ghi";
  for(i = 0; i < lst.length(); i++) {
    cout << (const char*)lst[i] << endl;
  }
  
  cout << endl << "[Dict]" << endl;
  dct.setData("one"  , new int(1));
  dct.setData("two"  , new int(2));
  dct.setData("three", new int(3));
  for(i = 0; i < dct.length(); i++) {
    k = *dct.getKey()[i];
    cout << k << ": " << *(int*)dct[k] << endl;
  }
  
  cout << endl << "[DictString]" << endl;
  dcts.setData("cat" , "neko");
  dcts.setData("dog" , "inu" );
  dcts.setData("bird", "tori");
  for(i = 0; i < dcts.length(); i++) {
    k = *dcts.getKey()[i];
    cout << k << ": " << dcts[k] << endl;
  }
  
  cout << endl << "-- Overwrite Test --" << endl;
  dcts.setData("cat" , "meow"  );
  dcts.setData("dog" , "bowwow");
  for(i = 0; i < dcts.length(); i++) {
    k = *dcts.getKey()[i];
    cout << k << ": " << dcts[k] << endl;
  }
  
  return 0;
}
