/* Free Foundation Classes for list ver.0.1.2
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $ffclist: ffcdictstring.cpp,v 1.14.0 2001/09/17 22:57:49 Toshihiro Inoue Exp $
 */

#include "ffcdictstring.h"




void FFCDictString::__init_class__()
{
}


FFCDictString::FFCDictString(): FFCDict()
{
  __init_class__();
  
  data.useString();
}


FFCDictString::FFCDictString(const FFCDictString& d): FFCDict()
{
  __init_class__();
  
  data.useString();
  *this = d;
}


FFCDictString::~FFCDictString()
{
}


FFCDictString& FFCDictString::operator=(const FFCDictString& d)
{
  key  = d.key;
  data = d.data;
  
  return *this;
}


void FFCDictString::setData(const FFCString& k, const FFCString& s)
{
  int pos = 0;
  
  pos = keyPos(k);
  if(pos == length()) {
    key  += (void*)&k;
    data += (void*)&s;
  } else if(*getKey()[pos] == k) {
    *getString()[pos] = s;
  } else {
    key .directInsert(pos, (void*)&k);
    data.directInsert(pos, (void*)&s);
  }
}


FFCString FFCDictString::operator[](const FFCString& k) const
{
  int pos = 0;
  
  pos = keyPos(k);
  if(pos == length()) return "";
  if(*getKey()[pos] == k) return *getString()[pos];
  return "";
}
