/* Free Foundation Classes for list ver.0.1.2
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $ffclist: ffcdict.cpp,v 1.15.0 2001/09/17 22:57:49 Toshihiro Inoue Exp $
 */

#include "ffcdict.h"


#include <stdlib.h>


void FFCDict::__init_class__()
{
}


FFCDict::FFCDict()
{
  __init_class__();
  
  key.useString();
}


FFCDict::FFCDict(const FFCDict& d)
{
  __init_class__();
  
  key.useString();
  *this = d;
}


FFCDict::~FFCDict()
{
}


void FFCDict::erase()
{
  key .erase();
  data.erase();
}


FFCDict& FFCDict::operator=(const FFCDict& d)
{
  key  = d.key;
  data = d.data;
  
  return *this;
}


void FFCDict::setData(const FFCString& k, void* d)
{
  int pos = 0;
  
  pos = keyPos(k);
  if(pos == length()) {
    key  += (void*)&k;
    data += d;
  } else if(*getKey()[pos] == k) {
    data.setData(pos, d);
  } else {
    key .directInsert(pos, (void*)&k);
    data.directInsert(pos, d);
  }
}


void* FFCDict::operator[](const FFCString& k) const
{
  int pos = 0;
  
  pos = keyPos(k);
  if(pos == length()) return NULL;
  if(*getKey()[pos] == k) return data[pos];
  return NULL;
}


int FFCDict::keyPos(const FFCString& k) const
{
  FFCString** p = 0;
  int pos = 0;
  int len = 0;
  int size = 0;
  bool dir = false;
  int i = 0;
  bool flg = false;
  
  p = getKey();
  len = length();
  size = len;
  
  while(size > 4) {
    if(flg && (size & 1)) size++;
    size /= 2;
    flg = !flg;
    if(!dir) {
      pos += size;
      p   += size;
    } else {
      pos -= size;
      p   -= size;
    }
    if(**p == k) return pos;
    dir = **p > k;
  }
  
  if(!dir) {
    for(i = pos; i < len; i++, p++) {
      if(**p >= k) return i;
    }
    return len;
  }
  
  for(i = pos; i >= 0; i--, p--) {
    if(**p == k) return i;
    if(**p < k) return i + 1;
  }
  return 0;
}
