/* Free Foundation Classes for network ver.0.2.6
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $ffcnetwork: ffchttp.h,v 1.39.1 2001/09/17 22:57:53 Toshihiro Inoue Exp $
 */

#ifndef _FFCHTTP_H_
#define _FFCHTTP_H_

#include "ffcaddress.h"
#include "ffcurl.h"

#include <ffcdictstring.h>
#include <ffcsax.h>
#include <ffcstring.h>

#include "ffcsocket.h"
#include <stdlib.h>

#define FFCHTTPVER "0.2.6"


class FFCHTTP: public FFCSocket
{
public:
  inline const FFCString& getRequest() const { return strRequest; }
  inline const FFCString& getHeader() const { return header; }
  inline const FFCString& getSource() const { return source; }
  inline const FFCDictString& getRequestDict() const { return dctRequest; }
  inline const FFCDictString& getHeaderDict() const { return dctHeader; }
  inline int getResult() const { return result; }
  inline bool checkCancel() const { return flgCancel && *flgCancel; }
  inline void setCancel(bool* flg) { flgCancel = flg; }
  inline void setCount(int* c) { count = c; }
  
public:
  FFCHTTP();
  virtual ~FFCHTTP();
  void setProxy(const FFCAddress& prx);
  void unsetProxy();
  bool connect(FFCAddress& addr);
  bool get(FFCURL url, const FFCString& ref = "");
  bool post(FFCURL url, const FFCDictString& d, const FFCString& ref = "");
  bool readHeader();
  bool readSource(FFCSAX* parser = NULL);
  bool readBuffer();
  bool save(const FFCString& fn);
  static FFCString makePost(const FFCDictString& d);
  static void setUserAgent(const FFCString& agent);
  static FFCString getUserAgent();
  
protected:
  bool request(const FFCString& cmd, FFCURL& url, const FFCString& ref = "");
  void sendRequest(const FFCString& hdr, const FFCString& val);
  void sendRequest(const FFCString& rq);
  
private:
  void __init_class__();
  
protected:
  FFCAddress proxy;
  FFCDictString dctRequest;
  FFCString strRequest;
  FFCDictString dctHeader;
  int result;
  FFCString header;
  FFCString source;
  bool* flgCancel;
  int* count;
};

#endif // _FFCHTTP_H_
