/* Free Foundation Classes for network ver.0.2.6
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $ffcnetwork: ffcaddress.h,v 1.31.1 2001/09/17 22:57:53 Toshihiro Inoue Exp $
 */

#ifndef _FFCADDRESS_H_
#define _FFCADDRESS_H_

#include <ffcstring.h>

#include <sys/types.h>
#ifdef WIN32
#  include <winsock2.h>
#else
#  include <netinet/in.h>
#endif


class FFCAddress
{
public:
  inline FFCString getAddress() const { return address; }
  inline operator const char*() const { return address; }
  inline int getPort() const { return port; }
  inline void setPort(int p) { port = p; }
  inline operator const struct in_addr*() { return getStruct(); }
  
public:
  FFCAddress();
  FFCAddress(const char* ad);
  FFCAddress(const FFCString& ad);
  FFCAddress(const FFCString& ad, int p);
  FFCAddress(int ad1, int ad2, int ad3, int ad4, int p = 0);
  FFCAddress(const FFCAddress& ad);
  virtual ~FFCAddress();
  void clear();
  void setAddress(int ad1, int ad2, int ad3, int ad4, int p = 0);
  void setAddress(const FFCString& ad);
  void setAddress(const FFCString& ad, int p);
  FFCAddress& operator=(const FFCString& ad);
  FFCAddress& operator=(const FFCAddress& ad);
  const struct in_addr* getStruct();
  
protected:
  void setStruct();
  
private:
  void __init_class__();
  
protected:
  struct in_addr addr;
  bool flag;
  FFCString address;
  int port;
};

#endif // _FFCADDRESS_H_
