/* FXSpriteCanvas ver.0.8.0
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $fxspritecanvas: fxspritepolygon.cpp,v 1.24.0 2001/10/12 11:28:59 Toshihiro Inoue Exp $
 */

#include "FXSpritePolygon.h"
#include "FXSpriteLayer.h"

FXIMPLEMENT(FXSpritePolygon, FXSpriteObject, NULL, 0)

FXSpritePolygon::FXSpritePolygon(FXSpriteLayer* layer,FXdouble x,FXdouble y,FXSpritePoint* points,FXint num): FXSpriteObject(layer,x,y) {
  mPoints = 0;
  mNum = 0;
  setPoints(points, num);
  }

FXSpritePolygon::~FXSpritePolygon() {
  if(mPoints) delete [] mPoints;
  }

void FXSpritePolygon::draw(FXDC* dc, FXdouble x, FXdouble y) {
  FXSpriteObject::draw(dc, x, y);
  FXPoint* points = new FXPoint[mNum];
  for(FXint i = 0; i < mNum; i++) {
    points[i].x = FXshort(mPoints[i].x + x);
    points[i].y = FXshort(mPoints[i].y + y);
    }
  dc->fillPolygon(points, mNum);
  delete [] points;
  }

void FXSpritePolygon::setPoints(FXSpritePoint pts[], FXint n) {
  if(mPoints) delete [] mPoints;
  mW = 0;
  mH = 0;
  if(n < 1) {
    mPoints = NULL;
    mNum = 0;
    return;
    }
  mPoints = new FXSpritePoint[n];
  mNum = n;
  for(FXint i = 0; i < n; i++) {
    mPoints[i] = pts[i];
    if(mW < mPoints[i].x) mW = mPoints[i].x;
    if(mH < mPoints[i].y) mH = mPoints[i].y;
    }
  }

