/* FXSpriteCanvas ver.0.8.0
 * 
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 * 
 * $FXSpritecanvas: FXSpriteArc.cpp,v 1.25.0 2001/10/12 11:28:59 Toshihiro Inoue Exp $
 */

#include "FXSpriteArc.h"
#include "FXSpriteLayer.h"

FXIMPLEMENT(FXSpriteArc, FXSpriteObject, NULL, 0)

FXSpriteArc::FXSpriteArc(FXSpriteLayer* layer,FXdouble x, FXdouble y, FXdouble w, FXdouble h, FXdouble ang1, FXdouble ang2): FXSpriteObject(layer,x,y,w,h) {
  mStart  = ang1;
  mCenter = ang2;
  }

void FXSpriteArc::draw(FXDC* dc,FXdouble x,FXdouble y) {
  FXSpriteObject::draw(dc,x,y);
  dc->fillArc(FXint(x),FXint(y),FXint(mW),FXint(mH),
              FXint(mStart * RTOD * 64),FXint(mCenter * RTOD * 64));
  }

void FXSpriteArc::setAngle(FXdouble ang1,FXdouble ang2) {
  redraw();
  mStart = ang1;
  mCenter = ang2;
  }

void FXSpriteArc::setStartAngle(FXdouble ang) {
  redraw();
  mStart = ang;
  }

void FXSpriteArc::setCenterAngle(FXdouble ang) {
  redraw();
  mCenter = ang;
  }

