/* There is probably a better way to detect when the foXdesktop changes the registry.  We
 * should get some sort of event, that we we can decode, before generating the
 * ID_REGISTRY_UPDATE message for the type of object that listens to that type of registry
 * change. ie. an FDButton is only called when the foXdesktop broadcasts an "FDButton
 * modified" message.
 */

#include "FXRegistryMonitor.h"

#define DEFAULT_SCAN_RATE  2000   // two second scan rate
#define REGISTRYPATH "/etc:/usr/lib:/usr/local/lib"
// Map
FXDEFMAP (FXRegistryMonitor) FXRegistryMonitorMap[]={
  FXMAPFUNC(SEL_REGISTRY,0,FXRegistryMonitor::onRegistryModified),
  FXMAPFUNC(SEL_TIMEOUT,FXRegistryMonitor::ID_TIMER,FXRegistryMonitor::onTimeout),
  };
FXIMPLEMENT(FXRegistryMonitor,FXBaseObject,FXRegistryMonitorMap,ARRAYNUMBER(FXRegistryMonitorMap))

// ctor
FXRegistryMonitor::FXRegistryMonitor(FXApp* a,FXObject* tgt,FXSelector sel) : FXBaseObject(a,tgt,sel),scanTimer(NULL),scanRate(DEFAULT_SCAN_RATE),objectCounter(0){
  objectList = new FXDict();
  }

// dtor
FXRegistryMonitor::~FXRegistryMonitor(){
  delete objectList;
  objectList->clear();
  if (scanTimer) scanTimer=getApp->removeTimeout(scanTimer);
  }

// create
void FXRegistryMonitor::create(){
  addObject(this);
  onTimeout(NULL,0,NULL);  // Do a first pass check
  }

// Check if registry is modified.
long FXRegistryMonitor::onTimeout(FXObject* sender,FXSelector,void*){
  if ( regHasChanged() ){
    FXTRACE((101,"The registry has changed.\n"));
    FXObject* o;
    FXint position = objectList->last();
    while(position > -1){
      o=(FXObject*) objectList->data(position);
      o->handle(this,MKUINT(0,SEL_REGISTRY),(void*)registry);
      position = objectList->prev(position);
      }
    }
  scanTimer=getApp()->addTimeout(scanRate,this,ID_TIMER);
  return 1;
  }

// scan through each regsitry file, getting the file stamp 
FXbool FXRegistryMonitor::regHasChanged(){
  return FALSE;
  }

// This class's various parameters are also capable of being changed 'on the fly'
long FXRegistryMonitor::onRegistryModified(FXObject*,FXSelector,void*){
  scanRate=registry->readIntEntry("SETTINGS","registry scan rate",scanRate);
  return 1;
  }

// add objects here
void FXRegistryMonitor::addObject(FXObject* o){
  FXASSERT ( o != NULL );
  objectCounter++;
  FXString key=FXStringFormat("%i",objectCounter);
  objectList->insert(key.text(),o);
  }

// remove objects when finished
void FXRegistryMonitor::removeObject(FXObject* o){
  // How do you remove a widget pointer from an FXDict?
  }

