#include <signal.h>
#include <fox/fx.h>
#include "FXCheckList.h"

class FXAPI TestWindow : public FXMainWindow {
  FXDECLARE(TestWindow)
protected:
  FXMenuPane          *filemenu;            // File menu
  FXMenubar           *menubar;             // Menu bar
  FXToolbar           *toolbar;             // Tool bar
  FXStatusbar         *statusbar;           // Status bar
protected:
  void readRegistry();
  void writeRegistry();
protected:
  TestWindow(){}
public:
  long onCmdQuit(FXObject*,FXSelector,void*);

public:
  enum{
    ID_WINDOW=FXMainWindow::ID_LAST,
    ID_QUIT,
    ID_LAST
    };
public:

  TestWindow(FXApp* a);
  virtual void create();
  virtual ~TestWindow();
  };

// *************************************************************************

// Map
FXDEFMAP(TestWindow) TestWindowMap[]={
  FXMAPFUNC(SEL_COMMAND,TestWindow::ID_QUIT,TestWindow::onCmdQuit),
  FXMAPFUNC(SEL_SIGNAL,TestWindow::ID_QUIT,TestWindow::onCmdQuit),
  FXMAPFUNC(SEL_CLOSE,TestWindow::ID_WINDOW,TestWindow::onCmdQuit),
  };
FXIMPLEMENT(TestWindow,FXMainWindow,TestWindowMap,ARRAYNUMBER(TestWindowMap))

// Make some windows
TestWindow::TestWindow(FXApp* a):FXMainWindow(a,"Test window"){
  setTarget(this);
  setSelector(ID_WINDOW);
  new FXTooltip(getApp());

  // Make menubar/toolbar/statusbar
  FXToolbarShell* dragshell1=new FXToolbarShell(this,FRAME_RAISED|FRAME_THICK);
  menubar=new FXMenubar(this,dragshell1,LAYOUT_SIDE_TOP|LAYOUT_FILL_X);
  new FXToolbarGrip(menubar,menubar,FXMenubar::ID_TOOLBARGRIP,TOOLBARGRIP_DOUBLE);
  FXToolbarShell* dragshell2=new FXToolbarShell(this,FRAME_RAISED|FRAME_THICK);
  toolbar=new FXToolbar(this,dragshell2,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|PACK_UNIFORM_WIDTH|PACK_UNIFORM_HEIGHT);
  new FXToolbarGrip(toolbar,toolbar,FXToolbar::ID_TOOLBARGRIP,TOOLBARGRIP_DOUBLE);
  statusbar=new FXStatusbar(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|STATUSBAR_WITH_DRAGCORNER);

  // File menu
  filemenu=new FXMenuPane(this);
  new FXMenuTitle(menubar,"&File",NULL,filemenu);
  new FXMenuCommand(filemenu,"&Quit\tCtl-Q",NULL,this,ID_QUIT);

  // Toobar buttons
  new FXButton(toolbar,"Quit\tQuit\tQuit.",NULL,this,ID_QUIT,ICON_ABOVE_TEXT|BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);

  // CheckList
  new FXCheckList();
  }

// Clean up the mess
TestWindow::~TestWindow(){
  delete filemenu;
  }

// Read settings from registry
void TestWindow::readRegistry(){
  setX(getApp()->reg().readIntEntry("SETTINGS","x",50));
  setY(getApp()->reg().readIntEntry("SETTINGS","y",50));
  setWidth(getApp()->reg().readIntEntry("SETTINGS","width",600));
  setHeight(getApp()->reg().readIntEntry("SETTINGS","height",400));
  }

// Save settings to registry
void TestWindow::writeRegistry(){
  getApp()->reg().writeIntEntry("SETTINGS","x",getX());
  getApp()->reg().writeIntEntry("SETTINGS","y",getY());
  getApp()->reg().writeIntEntry("SETTINGS","width",getWidth());
  getApp()->reg().writeIntEntry("SETTINGS","height",getHeight());
  }

// Quit
long TestWindow::onCmdQuit(FXObject*,FXSelector,void*){
  writeRegistry();
  getApp()->exit(0);
  return 1;
  }

// Create and show window
void TestWindow::create(){
  FXMainWindow::create();
  readRegistry();
  show(PLACEMENT_DEFAULT);
  }

// Start the whole thing
int main(int argc,char *argv[]){
  FXApp application("test app",FXString::null);
  application.init(argc,argv);
  TestWindow* window=new TestWindow(&application);
  application.addSignal(SIGINT,window,TestWindow::ID_QUIT);
  application.create();
  return application.run();
  }

