/********************************************************************************
*                                                                               *
*                                DbControl Test                                 *
*                                                                               *
********************************************************************************/
#include "fx.h"
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <signal.h>
#ifndef WIN32
#include <unistd.h>
#endif

#include "DbControl.h"
#include "DbNavigator.h"
#include "FXTableBox.h"


/*******************************************************************************/
class Employee : public FXObject
{
    FXDECLARE(Employee)
public:
    Employee() {}
    Employee(FXint nu, FXString na, DateField h, CurrencyField s, FXint st, FXString a, FXString f)
        : number(nu)
        , name(na)
        , hire(h)
        , salary(s)
        , stype(st)
        , address(a)
        , film(f)
    {}
    virtual ~Employee() {}
public:
    FXint         number;
    FXString      name;
    DateField     hire;
    CurrencyField salary;
    FXint         stype;
    FXString      address;
    FXString      film;
};
FXIMPLEMENT(Employee,FXObject,NULL,0)

class MyDb : public DbControl
{
    FXDECLARE(MyDb)
    typedef FXObjectListOf<Employee> Employees;
public:
    MyDb(FXWindow* owner, FXObject* tgt, FXSelector sel)
        : DbControl(owner, tgt, sel)
    {
        //       FieldName      FieldTitle     Data
        addField("EMP_NO",      "Employee No", eRec.number);
        addField("NAME",        "Name",        eRec.name);
        addField("HIRE_DATE",   "Hire date",   eRec.hire);
        addField("SALARY",      "Salary",      eRec.salary);
        addField("SALARY_TYPE", "Salary type", eRec.stype);
        addField("ADDRESS",     "Address",     eRec.address);
        addField("FILM",        "Favourite Film",eRec.film);
    }
    virtual ~MyDb() {}
public:
    Employee  eRec;
    Employees recs;
private:
    FXint recno;
private:
    virtual FXbool doOpen()
    {
        recs.append(new Employee(2, "Robert Nelson", DateField("28/12/1988"), 105900, 1, "15500 Pacific Heights Blvd.", "F001"));
        recs.append(new Employee(5, "Bruce Young",   DateField("12/05/1992"),  85900, 2, "P. O. Box 47000", "F002"));
        recno = 0;
        getField(0)->setEditable(FALSE);
        return TRUE;
    }
    virtual FXbool doClose()
    {
        return TRUE;
    }
    virtual FXbool doInsert()
    {
        if (recs.no()>0) eRec.number = recs[recs.no()-1]->number+1;
        else eRec.number = 1;
        eRec.name    = "";
        eRec.hire    = 0;
        eRec.salary  = 0;
        eRec.stype   = 2;
        eRec.address = "";
        eRec.film    = "";
        getField(0)->setEditable(TRUE);
        return TRUE;
    }
    virtual FXbool doPost()
    {
        switch (getMode())
        {
            case DB_INSERT:
                recs.append(new Employee(
                    eRec.number,
                    eRec.name,
                    eRec.hire,
                    eRec.salary,
                    eRec.stype,
                    eRec.address,
                    eRec.film));
                recno = recs.no()-1;
                break;
            case DB_EDIT:
                if (recs.no()>0)
                {
                    recs[recno]->number = eRec.number;
                    recs[recno]->name   = eRec.name;
                    recs[recno]->hire   = eRec.hire;
                    recs[recno]->salary = eRec.salary;
                    recs[recno]->stype  = eRec.stype;
                    recs[recno]->address= eRec.address;
                    recs[recno]->film   = eRec.film;
                }
                break;
        }
        getField(0)->setEditable(FALSE);
        return TRUE;
    }
    virtual FXbool doCancel()
    {
        getField(0)->setEditable(FALSE);
        return TRUE;
    }
    virtual FXbool doKill()
    {
        recs.remove(recno);
        if (recno > recs.no()-1) recno = recs.no()-1;
        return TRUE;
    }
    virtual FXbool doEdit()
    {
        return TRUE;
    }
    virtual FXbool doQuery()
    {
        return FALSE; // use default query dialog
    }
    virtual FXbool doFetch(DbPosition& p)
    {
        switch (p)
        {
            case DB_FIRST:
                recno = 0;
                p = DB_BOF;
                break;
            case DB_LAST:
                recno = recs.no()-1;
                p = DB_EOF;
                break;
            case DB_PRIOR:
                --recno;
                p = DB_CURRENT;
                if (recno <= 0)
                {
                    recno = 0;
                    p = DB_BOF;
                }
                break;
            case DB_NEXT:
                ++recno;
                p = DB_CURRENT;
                if (recno >= recs.no()-1)
                {
                    recno = recs.no()-1;
                    p = DB_EOF;
                }
                break;
            case DB_CURRENT:
                p = DB_CURRENT;
                break;
            case DB_FIND:
                {
                // after doQuery we are coming here
                FXMessageBox d(getOwner(),"Criteria",getQuery(),NULL,MBOX_OK|DECOR_TITLE|DECOR_BORDER);
                d.execute();
                p = DB_CURRENT;
                }
                break;
        }
        if (recs.no()>0)
        {
            eRec.number = recs[recno]->number;
            eRec.name   = recs[recno]->name;
            eRec.hire   = recs[recno]->hire;
            eRec.salary = recs[recno]->salary;
            eRec.stype  = recs[recno]->stype;
            eRec.address= recs[recno]->address;
            eRec.film   = recs[recno]->film;
        }
        else return insert();
        return TRUE;
    }
    virtual FXbool doPrint()
    {
        return TRUE;
    }
    virtual FXbool doShowError(const FXString&)
    {
        return TRUE;
    }
protected:
    MyDb(){}
};
FXIMPLEMENT(MyDb,DbControl,NULL,0)
/*******************************************************************************/


class DbTestWindow : public FXMainWindow {
  FXDECLARE(DbTestWindow)
protected:
  FXMenubar*         menubar;
  FXMenuPane*        filemenu;
  FXMenuPane*        optionmenu;
  FXMatrix*          matrix;
  MyDb*              db;
  FXTableBox*        tb;
  FXTextField*       filmDetail;
public:
  long onCmdQuit(FXObject*,FXSelector,void*);
  long onFieldUpd(FXObject*,FXSelector, void*);
  long onBeforeOpen(FXObject*,FXSelector, void*);
  long onAfterOpen(FXObject*,FXSelector, void*);
  long onBeforeClose(FXObject*,FXSelector, void*);
  long onAfterClose(FXObject*,FXSelector, void*);
  long onBeforeEdit(FXObject*,FXSelector, void*);
  long onAfterEdit(FXObject*,FXSelector, void*);
  long onBeforeInsert(FXObject*,FXSelector, void*);
  long onAfterInsert(FXObject*,FXSelector, void*);
  long onBeforeKill(FXObject*,FXSelector, void*);
  long onAfterKill(FXObject*,FXSelector, void*);
  long onBeforePost(FXObject*,FXSelector, void*);
  long onAfterPost(FXObject*,FXSelector, void*);
  long onBeforeCancel(FXObject*,FXSelector, void*);
  long onAfterCancel(FXObject*,FXSelector, void*);
  long onBeforeScroll(FXObject*,FXSelector, void*);
  long onAfterScroll(FXObject*,FXSelector, void*);
  long onBeforePrint(FXObject*,FXSelector, void*);
  long onAfterPrint(FXObject*,FXSelector, void*);
public:
  DbTestWindow(){}
public:
  enum {
    ID_QUIT=FXMainWindow::ID_LAST,
    };
public:
  DbTestWindow(FXApp *a);
  void create();
  virtual ~DbTestWindow();
private:
  void updateFilmDetail();
  };



/*******************************************************************************/

// Map
FXDEFMAP(DbTestWindow) DbTestWindowMap[]={
  FXMAPFUNC(SEL_SIGNAL,  DbTestWindow::ID_QUIT, DbTestWindow::onCmdQuit),

  FXMAPFUNC(SEL_CHANGED, DbControl::ID_FIELD,   DbTestWindow::onFieldUpd),

  FXMAPFUNC(SEL_VERIFY,  DbControl::ID_OPEN,    DbTestWindow::onBeforeOpen),
  FXMAPFUNC(SEL_CHANGED, DbControl::ID_OPEN,    DbTestWindow::onAfterOpen),

  FXMAPFUNC(SEL_VERIFY,  DbControl::ID_CLOSE,   DbTestWindow::onBeforeClose),
  FXMAPFUNC(SEL_CHANGED, DbControl::ID_CLOSE,   DbTestWindow::onAfterClose),

  FXMAPFUNC(SEL_VERIFY,  DbControl::ID_EDIT,    DbTestWindow::onBeforeEdit),
  FXMAPFUNC(SEL_CHANGED, DbControl::ID_EDIT,    DbTestWindow::onAfterEdit),

  FXMAPFUNC(SEL_VERIFY,  DbControl::ID_INSERT,  DbTestWindow::onBeforeInsert),
  FXMAPFUNC(SEL_CHANGED, DbControl::ID_INSERT,  DbTestWindow::onAfterInsert),

  FXMAPFUNC(SEL_VERIFY,  DbControl::ID_KILL,    DbTestWindow::onBeforeKill),
  FXMAPFUNC(SEL_CHANGED, DbControl::ID_KILL,    DbTestWindow::onAfterKill),

  FXMAPFUNC(SEL_VERIFY,  DbControl::ID_POST,    DbTestWindow::onBeforePost),
  FXMAPFUNC(SEL_CHANGED, DbControl::ID_POST,    DbTestWindow::onAfterPost),

  FXMAPFUNC(SEL_VERIFY,  DbControl::ID_CANCEL,  DbTestWindow::onBeforeCancel),
  FXMAPFUNC(SEL_CHANGED, DbControl::ID_CANCEL,  DbTestWindow::onAfterCancel),

  FXMAPFUNC(SEL_VERIFY,  DbControl::ID_SCROLL,  DbTestWindow::onBeforeScroll),
  FXMAPFUNC(SEL_CHANGED, DbControl::ID_SCROLL,  DbTestWindow::onAfterScroll),

  FXMAPFUNC(SEL_VERIFY,  DbControl::ID_PRINT,   DbTestWindow::onBeforePrint),
  FXMAPFUNC(SEL_CHANGED, DbControl::ID_PRINT,   DbTestWindow::onAfterPrint),
  };


// Object implementation
FXIMPLEMENT(DbTestWindow,FXMainWindow,DbTestWindowMap,ARRAYNUMBER(DbTestWindowMap))

/* Generated by reswrap from file db_exit.gif */
const unsigned char db_exit_gif[]={
  0x47,0x49,0x46,0x38,0x39,0x61,0x12,0x00,0x12,0x00,0xb3,0x00,0x00,0x00,0x00,0x00,
  0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x80,0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,
  0x80,0x80,0xc0,0xc0,0xc0,0x80,0x80,0x80,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0xff,0xff,0xff,0xff,0xff,0x2c,0x00,0x00,
  0x00,0x00,0x12,0x00,0x12,0x00,0x00,0x04,0x44,0xf0,0xc9,0x49,0xab,0xbd,0x58,0x82,
  0xcd,0x77,0x7e,0xdb,0x22,0x8a,0xc0,0xc7,0x8d,0x4b,0x39,0xa9,0x6b,0x92,0x00,0x23,
  0xeb,0x51,0x80,0xfb,0x92,0x9a,0x3b,0x83,0x36,0x9c,0xf2,0xbd,0x96,0x0e,0x07,0xdc,
  0xd5,0x8e,0x44,0x10,0x2b,0x87,0xfc,0xad,0x2a,0xb5,0xa1,0xf3,0xb2,0xe9,0x75,0x38,
  0x54,0xdd,0x07,0xfa,0xda,0x42,0x97,0x5e,0x50,0x78,0x2c,0x89,0x00,0x00,0x3b
  };


// Make some windows
DbTestWindow::DbTestWindow(FXApp* a):FXMainWindow(a,"Db Test",NULL,NULL,DECOR_ALL,20,20,400,300){

  db=new MyDb(this, this, 0);

  // Menubar
  menubar=new FXMenubar(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X);

  // File menu
  filemenu=new FXMenuPane(this);
  new FXMenuCommand(filemenu,"&Quit\tCtl-Q",NULL,getApp(),FXApp::ID_QUIT,0);
  new FXMenuTitle(menubar,"&File",NULL,filemenu);

  // Option menu
  optionmenu=new FXMenuPane(this);

  // The menu commands change the "some_option" variable via the option_target
  new FXMenuCommand(optionmenu,"Option 1",NULL,db->getField("SALARY_TYPE"),DbField::ID_OPTION+1);
  new FXMenuCommand(optionmenu,"Option 2",NULL,db->getField("SALARY_TYPE"),DbField::ID_OPTION+2);
  new FXMenuCommand(optionmenu,"Option 3",NULL,db->getField("SALARY_TYPE"),DbField::ID_OPTION+3);
  new FXMenuCommand(optionmenu,"Option 4",NULL,db->getField("SALARY_TYPE"),DbField::ID_OPTION+4);
  new FXMenuTitle(menubar,"&Salary type",NULL,optionmenu);

  new FXHorizontalSeparator(this,LAYOUT_SIDE_TOP|SEPARATOR_GROOVE|LAYOUT_FILL_X);
  FXToolbar* bar = new FXToolbar(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|PACK_UNIFORM_HEIGHT,0,0,0,0,3,3,0,0,0,0);
  //new FXButton(bar,"\tQuit\tQuit",new FXGIFIcon(getApp(), db_exit_gif, 0, IMAGE_ALPHAGUESS),this,FXApp::ID_QUIT,ICON_ABOVE_TEXT|BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT);
  new DbNavigator(bar, db, 0, LAYOUT_RIGHT|LAYOUT_SIDE_RIGHT);

  new FXHorizontalSeparator(this,LAYOUT_SIDE_TOP|SEPARATOR_GROOVE|LAYOUT_FILL_X);

  // Arange nicely
  matrix=new FXMatrix(this,2,MATRIX_BY_COLUMNS|LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y);

  new FXLabel(matrix,db->getField("EMP_NO")->getTitle(),NULL,LAYOUT_CENTER_Y|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
  new FXTextField(matrix,10,db->getField("EMP_NO"),DbField::ID_VALUE,TEXTFIELD_INTEGER|JUSTIFY_RIGHT|LAYOUT_CENTER_Y|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);

  new FXLabel(matrix,db->getField("NAME")->getTitle(),NULL,LAYOUT_CENTER_Y|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
  new FXTextField(matrix,30,db->getField("NAME"),DbField::ID_VALUE,LAYOUT_CENTER_Y|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);

  new FXLabel(matrix,db->getField("HIRE_DATE")->getTitle(),NULL,LAYOUT_CENTER_Y|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
  new FXTextField(matrix,10,db->getField("HIRE_DATE"),DbField::ID_VALUE,LAYOUT_CENTER_Y|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);

  new FXLabel(matrix,db->getField("SALARY")->getTitle(),NULL,LAYOUT_CENTER_Y|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
  new FXTextField(matrix,10,db->getField("SALARY"),DbField::ID_VALUE,JUSTIFY_RIGHT|LAYOUT_CENTER_Y|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);

  new FXLabel(matrix,db->getField("SALARY_TYPE")->getTitle(),NULL,LAYOUT_CENTER_Y|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
  FXHorizontalFrame* hf= new FXHorizontalFrame(matrix,LAYOUT_CENTER_Y|LAYOUT_FILL_ROW,0,0,0,0, 0,0,0,0);
  new FXRadioButton(hf,"Option &1",db->getField("SALARY_TYPE"),DbField::ID_OPTION+1,LAYOUT_CENTER_Y|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|ICON_BEFORE_TEXT);
  new FXRadioButton(hf,"Option &2",db->getField("SALARY_TYPE"),DbField::ID_OPTION+2,LAYOUT_CENTER_Y|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|ICON_BEFORE_TEXT);
  new FXRadioButton(hf,"Option &3",db->getField("SALARY_TYPE"),DbField::ID_OPTION+3,LAYOUT_CENTER_Y|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|ICON_BEFORE_TEXT);
  new FXRadioButton(hf,"Option &4",db->getField("SALARY_TYPE"),DbField::ID_OPTION+4,LAYOUT_CENTER_Y|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|ICON_BEFORE_TEXT);

  new FXLabel(matrix,db->getField("ADDRESS")->getTitle(),NULL,LAYOUT_CENTER_Y|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
  new FXTextField(matrix,35,db->getField("ADDRESS"),DbField::ID_VALUE,LAYOUT_CENTER_Y|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);

  new FXLabel(matrix,db->getField("FILM")->getTitle(),NULL,LAYOUT_CENTER_Y|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
  tb=new FXTableBox(matrix,10,5,0,db->getField("FILM"),DbField::ID_VALUE,FRAME_SUNKEN|FRAME_THICK|LAYOUT_CENTER_Y|LAYOUT_FILL_ROW);//,0,0,200,0);
  /**/
  tb->appendHeader("Film Id",NULL,50);
  tb->appendHeader("Name",NULL,100);
  tb->appendHeader("Director",NULL,100);
  FXString its;
  its.format("%s\t%s\t%s", "F001", "Moulin Rouge", "Baz Luhrmann");tb->appendItem(its);
  its.format("%s\t%s\t%s", "F002", "Desert Moon", "Shinji Aoyama");tb->appendItem(its);
  its.format("%s\t%s\t%s", "F003", "The Man Who Wasn't There", "Joel Coen");tb->appendItem(its);
  its.format("%s\t%s\t%s", "F004", "Eloge de l'Amour", "Jean Luc Godard");tb->appendItem(its);
  its.format("%s\t%s\t%s", "F005", "La Pianiste", "Michael Haneke");tb->appendItem(its);
  its.format("%s\t%s\t%s", "F006", "Millennium Mambo", "Hou Hsiao-Hsien");tb->appendItem(its);
  its.format("%s\t%s\t%s", "F007", "De l'eau tiede sous un pont rouge", "Shohei Imamura");tb->appendItem(its);
  its.format("%s\t%s\t%s", "F008", "Shrek", "Victoria Jenson-Andrew Adamson");tb->appendItem(its);
  its.format("%s\t%s\t%s", "F009", "Distance", "Hirokuza Kore-Eda");tb->appendItem(its);
  its.format("%s\t%s\t%s", "F010", "Mulholland Drive", "David Lynch");tb->appendItem(its);
  its.format("%s\t%s\t%s", "F011", "Kandahar", "Mohsen Makhmalbaf");tb->appendItem(its);
  its.format("%s\t%s\t%s", "F012", "La Stanza del figlio", "Nanni Moretti");tb->appendItem(its);
  its.format("%s\t%s\t%s", "F013", "Je rentre a la maison", "Manoel De Oliveria");tb->appendItem(its);
  its.format("%s\t%s\t%s", "F014", "Il mestiere delle armi", "Ermanno Olmi");tb->appendItem(its);
  its.format("%s\t%s\t%s", "F015", "The Pledge", "Sean Penn");tb->appendItem(its);
  its.format("%s\t%s\t%s", "F016", "Pau i el seu germa", "Mare Recha");tb->appendItem(its);
  its.format("%s\t%s\t%s", "F017", "Taurus", "Alexander Sokurov");tb->appendItem(its);
  its.format("%s\t%s\t%s", "F018", "No Man's Land", "Danis Tanovi");tb->appendItem(its);
  its.format("%s\t%s\t%s", "F019", "Et la-bas,quelle heure est-il", "Tsai Ming-Liang");tb->appendItem(its);
  its.format("%s\t%s\t%s", "F020", "La repetition", "Catherine Corsini");tb->appendItem(its);
  its.format("%s\t%s\t%s", "F021", "La Chambre des officiers", "Franois Dupeyron");tb->appendItem(its);
  its.format("%s\t%s\t%s", "F022", "Roberto Succo", "Cedris Kahn");tb->appendItem(its);
  its.format("%s\t%s\t%s", "F023", "Va savoir", "Jacques Rivette");tb->appendItem(its);
  /**/
  new FXLabel(matrix,"Name/Director",NULL,LAYOUT_CENTER_Y|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
  filmDetail=new FXTextField(matrix,35,NULL,0,TEXTFIELD_READONLY|LAYOUT_CENTER_Y|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);

  // Install an accelerator
  getAccelTable()->addAccel(fxparseaccel("Ctl-Q"),getApp(),MKUINT(FXApp::ID_QUIT,SEL_COMMAND));
  new FXTooltip(getApp());
  }


// Clean up
DbTestWindow::~DbTestWindow(){
  delete filemenu;
  delete optionmenu;
  }


// Start
void DbTestWindow::create(){

  // Create windows
  FXMainWindow::create();

  db->open();
  db->first();

  // Show
  show(PLACEMENT_SCREEN);
  }


// Quit
long DbTestWindow::onCmdQuit(FXObject*,FXSelector,void*){
  getApp()->exit(0);
  return 1;
  }


//
void DbTestWindow::updateFilmDetail() {
  FXint i=tb->findItem(db->eRec.film);
  if (i!=-1){
    filmDetail->setText(FXString("\"")+tb->getItemColText(i,1)+FXString("\", by ")+tb->getItemColText(i,2));
    }
  }

// Field updated
long DbTestWindow::onFieldUpd(FXObject*,FXSelector,void* ptr) {
  DbField* f = reinterpret_cast<DbField*>(ptr);
  if (f==db->getField("FILM")) {
    updateFilmDetail();
    }
  return 1;
  }

long DbTestWindow::onBeforeOpen(FXObject*,FXSelector, void*)
{
    return 0;
}
long DbTestWindow::onAfterOpen(FXObject*,FXSelector, void*)
{
    return 1;
}
long DbTestWindow::onBeforeClose(FXObject*,FXSelector, void*)
{
    return 0;
}
long DbTestWindow::onAfterClose(FXObject*,FXSelector, void*)
{
    return 1;
}
long DbTestWindow::onBeforeEdit(FXObject*,FXSelector, void*)
{
    return 0;
}
long DbTestWindow::onAfterEdit(FXObject*,FXSelector, void*)
{
    return 1;
}
long DbTestWindow::onBeforeInsert(FXObject*,FXSelector, void*)
{
    return 0;
}
long DbTestWindow::onAfterInsert(FXObject*,FXSelector, void*)
{
    return 1;
}
long DbTestWindow::onBeforeKill(FXObject*,FXSelector, void*)
{
    return 0;
}
long DbTestWindow::onAfterKill(FXObject*,FXSelector, void*)
{
    return 1;
}
long DbTestWindow::onBeforePost(FXObject*,FXSelector, void*)
{
    return 0;
}
long DbTestWindow::onAfterPost(FXObject*,FXSelector, void*)
{
    return 1;
}
long DbTestWindow::onBeforeCancel(FXObject*,FXSelector, void*)
{
    return 0;
}
long DbTestWindow::onAfterCancel(FXObject*,FXSelector, void*)
{
    return 1;
}
long DbTestWindow::onBeforeScroll(FXObject*,FXSelector, void*)
{
    return 0;
}
long DbTestWindow::onAfterScroll(FXObject*,FXSelector, void*)
{
    updateFilmDetail();
    return 1;
}
long DbTestWindow::onBeforePrint(FXObject*,FXSelector, void*)
{
    return 0;
}
long DbTestWindow::onAfterPrint(FXObject*,FXSelector, void*)
{
    return 1;
}

/*******************************************************************************/


// Start the whole thing
int main(int argc,char *argv[]){

  // Make application
  FXApp application("DbTest","FoxTest");

  // Open display
  application.init(argc,argv);

  // Main window
  DbTestWindow* window=new DbTestWindow(&application);

  // Handle interrupt to save stuff nicely
  application.addSignal(SIGINT,window,DbTestWindow::ID_QUIT);

  // Create app
  application.create();
  
  // Run
  return application.run();
  }
