/* FXExTreeList Sample ver.0.2.0
 *
 * This software is in the public domain.
 * There are no restrictions on any sort of usage of this software.
 *
 * $fxextreelist-test: win.h,v 1.68.0 2001/10/25 10:43:00 Toshihiro Inoue Exp $
 */

#ifndef _WIN_H_
#define _WIN_H_

#define APPNAME "FXExTreeList Sample"
#define VERSION_ "0.2.0"
#define AUTHOR  "Global Interactive Revolution Laboratory"

class Win: public FXTopWindow {
  FXDECLARE(Win)

public:
  enum {
    ID_NEW = FXTopWindow::ID_LAST,
    ID_ABOUT,
    ID_TREE,
    ID_URL,
    ID_STATE,
    ID_LAST
    };
  
public:
  Win(FXApp* app);
  virtual void create();
  virtual ~Win();
  long onChanged(FXObject* sender, FXSelector sel, void* ptr);
  long onCmdState(FXObject* sender, FXSelector sel, void* ptr);
  long onClose(FXObject* sender, FXSelector sel, void* ptr);
  long onMnuNew(FXObject* sender, FXSelector sel, void* ptr);
  long onMnuAbout(FXObject* sender, FXSelector sel, void* ptr);
  
protected:
  Win();
  
private:
  void __init_class__();
  void initMenu();
  
protected:
  FXExTreeItem* selItem;
  FXToolBarShell* tshMenu;
  FXMenuBar* menu;
  FXMenuPane* mnuFile;
  FXMenuPane* mnuEdit;
  FXMenuPane* mnuItem;
  FXMenuPane* mnuHelp;
  FXTreeEditor* tree;
  FXVerticalFrame* lyrProp1;
  FXHorizontalFrame* lyrProp2;
  FXCheckButton* chkEdit;
  FXCheckButton* chkDrag;
  FXHorizontalFrame* lyrProp3;
  FXCheckButton* chkPrev;
  FXCheckButton* chkChild;
  FXCheckButton* chkNext;
};

#endif // _WIN_H_
