#include "resmon.h"
#include "extras.h"

#define SERVER_PORT  10001

// Map & implementation
FXDEFMAP ( resmon ) resmonMap  [] = {
  FXMAPFUNC ( SEL_SIGNAL , FXDaemonApp::ID_QUIT  , resmon::onCmdQuit      ),
  FXMAPFUNC ( SEL_COMMAND, FXDaemonApp::ID_QUIT  , resmon::onCmdQuit      ),
  FXMAPFUNC ( SEL_COMMAND, FXDaemon::ID_CONFIGURE, resmon::onCmdConfigure ),
  FXMAPFUNC ( SEL_COMMAND, resmon::ID_ABOUT      , resmon::onCmdAbout     ),
  FXMAPFUNC ( SEL_COMMAND, resmon::ID_SOCKET_READ, resmon::onCmdSocketRead),
  };
FXIMPLEMENT ( resmon, FXDaemon, resmonMap, ARRAYNUMBER ( resmonMap ) )

// Make some windows
resmon::resmon ( FXDaemonApp* a ) : FXDaemon ( a ){
  FXMETHOD("resmon");
  setTarget(this);
  setSelector(ID_RESMON);
//  server = new FXSocketServer(a, this, ID_SOCKET_READ, SERVER_PORT);
  }

resmon::~resmon (){
  FXMETHOD("~resmon");
  }

void resmon::create(){
  FXDaemon::create();
  }

// Quit
long resmon::onCmdQuit(FXObject*,FXSelector,void*){
  FXMETHOD("onCmdQuit");
  // shut down all connections...
  // save state...
  getApp()->exit();
  return 1;
  }

// About
long resmon::onCmdAbout(FXObject*,FXSelector,void*){
  fxmessage("About: A resource monitor/delegator for the foXdesktop.\n");
  return 1;
  }

// Read socket
long resmon::onCmdSocketRead(FXObject*,FXSelector,void* ptr){
  FXMETHOD("onCmdSocketRead");
  FXchar* data = (FXchar*) ptr;
  fxmessage("message: %s\n", data);
  return 1;
  }

// Re-configure the app - while running
long resmon::onCmdConfigure(FXObject*,FXSelector,void*){
  FXMETHOD("onCmdConfigure");
  return 1;
  }

// Not Yet Implemented
void resmon::NotYetImplemented () {
  fxmessage("That functionality is not yet implemented.");
  }
