#include <fox/fx.h>
#include "fxex.h"
#include "FoxApp.h"
#include "icons.h"

// MAPS ------------------------------------------------------------------
FXDEFMAP(FoxApp) FoxAppMap[] = {
  FXMAPFUNC( SEL_COMMAND, FoxApp::ID_ABOUT,  FoxApp::onCmdAbout ),
  FXMAPFUNC( SEL_COMMAND, FoxApp::ID_NEW,    FoxApp::onCmdNew ),
  FXMAPFUNC( SEL_COMMAND, FoxApp::ID_OPEN,   FoxApp::onCmdOpen ),
  FXMAPFUNC( SEL_COMMAND, FoxApp::ID_SAVE,   FoxApp::onCmdSave ),
  FXMAPFUNC( SEL_COMMAND, FoxApp::ID_SAVEAS, FoxApp::onCmdSaveAs ),
  FXMAPFUNC( SEL_COMMAND, FoxApp::ID_PRINT,  FoxApp::onCmdPrint ),
  FXMAPFUNC( SEL_COMMAND, FoxApp::ID_QUIT,   FoxApp::onCmdQuit ),
  };
FXIMPLEMENT( FoxApp, FXApp, FoxAppMap, ARRAYNUMBER(FoxAppMap))

// =======================================================================
// FXApp inits with "App Name", "Vendor Name" for registry files
FoxApp::FoxApp() : FXApp( "FoxApp", "DigitalArtisans" ) {
   // the main window
   mainwin = new FXMainWindow( this, "Title", NULL, 0, DECOR_ALL, 0,0,200,100, 0,0 );
   // the menu bar
   menubar = new FXMenuBar( mainwin, FRAME_RAISED|LAYOUT_SIDE_TOP|LAYOUT_FILL_X );
   // make a container for the toolbar
   FXHorizontalFrame *tbc = new FXHorizontalFrame( mainwin, LAYOUT_SIDE_TOP|LAYOUT_FILL_X, 0,0,0,0, 0,0,0,0, 0,0 );
   new FXToolBarTab( tbc, NULL, 0, FRAME_RAISED );
   toolbar = new FXHorizontalFrame( tbc, FRAME_RAISED|LAYOUT_SIDE_TOP|LAYOUT_FILL_X, 0,0,0,0, 4,4,4,4, 0,0 );
   // status bar
   statusbar = new FXStatusBar( mainwin, LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|STATUSBAR_WITH_DRAGCORNER);
   // contents of the window
   contents = new FXHorizontalFrame( mainwin, LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y, 0,0,0,0, 0,0,0,0 );
   // Menus
   createMenu();
   // Toolbar
   createToolbar();
   // Statusbar
   createStatusbar();
   // contents
   createContents();
   // Tool tips
   new FXToolTip( this, 0 );
   
   // For opens and saves, etc
   docDirty = FALSE;
}

// -----------------------------------------------------------------------
void FoxApp::start( int &argc, char **argv )
{
   FXint wide, high;
   
   // must call this
   init( argc, argv );
   
   // Read in the last window size
   wide = reg().readIntEntry("SETTINGS", "width", 400 );
   high = reg().readIntEntry("SETTINGS", "height", 300 );
   
   // must call this
   create();
   
   // position the window
   mainwin->position( 0, 0, wide, high );
   // must call this
   mainwin->show(PLACEMENT_SCREEN);
}

// -----------------------------------------------------------------------
void FoxApp::createMenu()
{
   // File menu
   FXMenuPane *fm = new FXMenuPane( mainwin );
   new FXMenuTitle( menubar, "&File", NULL, fm );
   new FXMenuCommand( fm, "&New...\tCtl-N\tCreate new document", 
		     NULL, this, ID_NEW );
   new FXMenuCommand( fm, "&Open...\tCtl-O\tOpen document", 
		     NULL, this, ID_OPEN );
   new FXMenuCommand( fm, "&Save\tCtl-S\tSave document", 
		     NULL, this, ID_SAVE );
   new FXMenuCommand( fm, "Save &As...\t\tSave document as ...", 
		     NULL, this, ID_SAVEAS );
   new FXMenuSeparator( fm );
   new FXMenuCommand( fm, "&Print...\t\tPrint document", 
		     NULL, this, ID_PRINT );
   new FXMenuSeparator( fm );
   new FXMenuCommand( fm, "&Quit", NULL, this, ID_QUIT );
   
   // Help menu
   FXMenuPane *hm = new FXMenuPane( mainwin );
   new FXMenuTitle( menubar, "&Help", NULL, hm, LAYOUT_RIGHT );
   new FXMenuCommand( hm, "&About...\t\tAbout FoxApp", 
		     NULL, NULL, 0 );
   
}

// -----------------------------------------------------------------------
void FoxApp::createToolbar()
{
   new FXButton( toolbar, "\tNew\tCreate new document", 
		new FXGIFIcon( this, filenew_ico ), this, ID_NEW,
		BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT );
   new FXButton( toolbar, "\tOpen\tOpen document", 
		new FXGIFIcon( this, filenew_ico ), this, ID_OPEN,
		BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT );
   new FXButton( toolbar, "\tSave\tSave document", 
		new FXGIFIcon( this, filesave_ico ), this, ID_SAVE,
		BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT );
   new FXButton( toolbar, "\tSave As\tSave document as ...", 
		new FXGIFIcon( this, filesaveas_ico ), this, ID_SAVEAS,
		BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT );
   
   // spacer
   new FXFrame( toolbar, LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT, 0, 0, 4, 20 );
   new FXButton( toolbar, "\tPrint\tPrint document", 
		new FXGIFIcon( this, print_ico ), this, ID_PRINT,
		BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_LEFT );
   
   // on the right
   new FXButton( toolbar, "\tQuit\tQuit application", 
		new FXGIFIcon( this, kill_ico ), this, ID_QUIT,
		BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_TOP|LAYOUT_RIGHT );
}

// -----------------------------------------------------------------------
void FoxApp::createStatusbar()
{
   new FXButton( statusbar, "\tI'm Tux...\nThe symbol for the Linux OS",
		new FXGIFIcon( this, penguin_ico ), NULL, 0, 
		LAYOUT_RIGHT );
}

// -----------------------------------------------------------------------
void FoxApp::createContents()
{
   new FXCalendar( contents, LAYOUT_FILL_X|LAYOUT_FILL_Y );
}

// -----------------------------------------------------------------------
long FoxApp::onCmdQuit( FXObject *, FXSelector, void * )
{
   FXuint ans;
   
   if( docDirty ) {
      ans = FXMessageBox::question( mainwin, MBOX_YES_NO_CANCEL, "Unsaved Document",
				 "Save current document?");
      if( ans == MBOX_CLICKED_CANCEL )
	return 1;
      if( ans == MBOX_CLICKED_YES ) {
	 // save it
      }
   }  
   
   // Save the window size
   reg().writeIntEntry("SETTINGS", "width", mainwin->getWidth());
   reg().writeIntEntry("SETTINGS", "height", mainwin->getHeight());
   
   exit(0);
   return 1;
}

// -----------------------------------------------------------------------
long FoxApp::onCmdAbout( FXObject *, FXSelector, void * )
{
   FXMessageBox::information( mainwin, MBOX_OK, "About", "FXCalendar Widget Demo\nJim Knight\njimbag@kw.igs.net" );
   return 1;
}

// -----------------------------------------------------------------------
long FoxApp::onCmdNew( FXObject *, FXSelector, void * )
{
   FXuint ans;
 
   if( docDirty ) {
      ans = FXMessageBox::question( mainwin, MBOX_YES_NO_CANCEL, "Unsaved document",
				 "Save current document?" );
      if( ans == MBOX_CLICKED_CANCEL )
	return 1;
      if( ans == MBOX_CLICKED_YES ) {
	 // save it
      }
   }
   docDirty = FALSE;
   return 1;
}

// -----------------------------------------------------------------------
long FoxApp::onCmdOpen( FXObject *, FXSelector, void * )
{
   FXuint ans;
   
   if( docDirty ) {
      ans = FXMessageBox::question( mainwin, MBOX_YES_NO_CANCEL, "Unsaved document",
				 "Save current document?" );
      if( ans == MBOX_CLICKED_CANCEL )
	return 1;
      if( ans == MBOX_CLICKED_YES ) {
	 // save it
      }
   }
   
   FXFileDialog open( mainwin, "Open Document" );
   if( open.execute()) {
      // do something
      docDirty = FALSE;
   }
   return 1;
}

// -----------------------------------------------------------------------
long FoxApp::onCmdSave( FXObject *, FXSelector, void * )
{
   docDirty = FALSE;
   return 1;
}

// -----------------------------------------------------------------------
long FoxApp::onCmdSaveAs( FXObject *, FXSelector, void * )
{
   FXFileDialog sd( mainwin, "Save Document" );
   if( sd.execute()) {
      // do something
      docDirty = FALSE;
   }
   return 1;
}

// -----------------------------------------------------------------------
long FoxApp::onCmdPrint( FXObject *, FXSelector, void * )
{
   FXMessageBox::error( mainwin, MBOX_OK, "Not Implemented",
		     "Sorry. You can't print yet!" );
   docDirty = TRUE;
   return 1;
}
