/***********************************************************************
 * copyright Lyle Johnson                                              *
 ***********************************************************************/
#include "config.h"
#include <fox/fx.h>
#include <fox/FXBzStream.h>
#include <stdio.h>

int main(int argc, char **argv){
  // Create a memory stream
  FXBzMemoryStream strmout;

  // Open it
  if(strmout.open(NULL,FXStreamSave)){
    // Write some data
    FXint int1 = 5;
    FXdouble double1 = 6.0;
    FXString text('X', 10000);
    strmout << int1 << double1 << text;
    }
  else{
    fxerror("Couldn't open memory stream for output.\n");
    }

  // Grab the data buffer
  FXuchar *buffer;
  unsigned long sp;
  strmout.takeBuffer(buffer,sp);

  // Close it
  strmout.close();

  printf("Size of compressed data in stream is %d bytes\n",
    strmout.getCompressedSize());

  // Now try to read it back
  FXBzMemoryStream strmin;
  if(strmin.open(buffer,sp,FXStreamLoad)){
    FXint int1;
    FXdouble double1;
    FXString text;
    strmin >> int1 >> double1 >> text;
    //printf("text = %s\n", text.text());
    printf("int1 = %d\n",int1);
    printf("double1 = %g\n",double1);
    }
  else{
    fxerror("Couldn't open memory stream for input.\n");
    }

  return 0;
  }
