/*******************************************************************************
* Copyright (C) 2001,2002 by H. J. Daniel III. All Rights Reserved.            *
********************************************************************************
* This library is free software; you can redistribute it and/or                *
* modify it under the terms of the GNU Lesser General Public                   *
* License as published by the Free Software Foundation; either                 *
* version 2.1 of the License, or (at your option) any later version.           *
*                                                                              *
* This library is distributed in the hope that it will be useful,              *
* but WITHOUT ANY WARRANTY; without even the implied warranty of               *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU            *
* Lesser General Public License for more details.                              *
*                                                                              *
* You should have received a copy of the GNU Lesser General Public             *
* License along with this library; if not, write to the Free Software          *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.   *
*******************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/fxkeys.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
#include <fox/FXImage.h>
#include <fox/FXButton.h>
#include <fox/FXSeparator.h>
#include <fox/FXImageFrame.h>
using namespace FX;
#include "FXArray.h"
#include "FXWizardPage.h"
#include "FXWizardDialog.h"
using namespace FXEX;
namespace FXEX {

FXDEFMAP(FXWizardDialog) FXWizardDialogMap[]= {
  FXMAPFUNC(SEL_COMMAND,FXWizardDialog::ID_WIZARD_PREV,FXWizardDialog::onPrevOrNext),
  FXMAPFUNC(SEL_COMMAND,FXWizardDialog::ID_WIZARD_NEXT,FXWizardDialog::onPrevOrNext),
  FXMAPFUNC(SEL_COMMAND,FXWizardDialog::ID_WIZARD_CANCEL,FXWizardDialog::onCancel),
  FXMAPFUNC(SEL_CLOSE,0,FXWizardDialog::onCancel), //for titlebar close [X]
  FXMAPFUNC(SEL_COMMAND,FXWizardDialog::ID_WIZARD_HELP,FXWizardDialog::onHelp),
  };
FXIMPLEMENT(FXWizardDialog,FXDialogBox,FXWizardDialogMap,ARRAYNUMBER(FXWizardDialogMap))

//****************************************************************************/
// FXWizardDialog
//****************************************************************************/
FXWizardDialog::FXWizardDialog(FXApp* a,const FXString& name,FXImage* image,FXPoint position,FXint padding):FXDialogBox(a,name,DECOR_BORDER|DECOR_TITLE|DECOR_CLOSE,0,0,0,0,padding,padding,padding,padding){
  // just create the dialog itself here, the controls will be created in
  // constructControls() called later when we know our final size
  posWizard = position;
  page = NULL;
  btnPrev = NULL;
  btnNext = NULL;
  btnCancel = NULL;
  sizePage.h = -1;
  sizePage.w = -1;
  wizImage = image;
  constructControls();
  }

/*****************************************************************************/
FXWizardDialog::FXWizardDialog(FXWindow* owner,const FXString& name,FXImage* image,FXPoint position,FXint padding):FXDialogBox(owner,name,DECOR_BORDER|DECOR_TITLE|DECOR_CLOSE,0,0,0,0,padding,padding,padding,padding){
  // just create the dialog itself here, the controls will be created in
  // constructControls() called later when we know our final size
  posWizard = position;
  page = NULL;
  btnPrev = NULL;
  btnNext = NULL;
  btnCancel = NULL;
  sizePage.h = -1;
  sizePage.w = -1;
  wizImage = image;
  constructControls();
  }

/*****************************************************************************/
FXWizardDialog::~FXWizardDialog(){
  delete btnCancel;
  delete btnNext;
  delete btnPrev;
  delete separator;
  if(wizImage) delete wizImageFrame;
  wizImage=(FXImage*)-1;
  }

/*****************************************************************************/
// !!!!!!! This really needs to be looked at for efficiency !!!!!!!
void FXWizardDialog::create() {
  if ( wasCreated() ) return; // do nothing if the controls were already created
  FXDialogBox::create();

  // constants defining the dialog layout
  // ------------------------------------

  // these constants define the position of the upper left corner of the
  // bitmap or the page in the wizard
  static const FXuint X_MARGIN = getPadTop();
  static const FXuint Y_MARGIN = getPadLeft();

  // margin between the bitmap and the panel
  static const FXuint BITMAP_X_MARGIN = X_MARGIN;

  // margin between the bitmap and the static line
  static const FXuint BITMAP_Y_MARGIN = Y_MARGIN;

  // margin between the static line and the buttons
  static const FXuint SEPARATOR_LINE_MARGIN = Y_MARGIN;

  // margin between "Next >" and "Cancel" buttons
  static const FXuint BUTTON_MARGIN = X_MARGIN*2;

  // default width and height of the page
  FXSize defaultPageSize = getPageSizes();
  static const FXuint DEFAULT_PAGE_WIDTH = defaultPageSize.w;
  static const FXuint DEFAULT_PAGE_HEIGHT = defaultPageSize.h;

  // the global dialog layout is: a row of buttons at the bottom (aligned to
  // the right), the static line above them, the bitmap (if any) on the left
  // of the upper part of the dialog and the panel in the remaining space

  // all of the button controls should be the same heigh so we just picked one
  FXuint btnHeight = btnPrev->getHeight();
  FXuint separatorHeight = separator->getDefaultHeight();
  
  // calculate minimum sizes required to hold just the controls.
  FXuint prevBtnWidth = btnPrev->getWidth();
  FXuint nextBtnWidth = btnNext->getWidth();
  FXuint cancelBtnWidth = btnCancel->getWidth();
  FXuint imageWidth = 0;
  FXuint imageHeight = 0;
  
  if(wizImage) {
    FXSize maxImageSize = getImageSizes();
    imageWidth = maxImageSize.w;
    imageHeight = maxImageSize.h;
    imageWidth += BITMAP_X_MARGIN;
    }
  
  FXuint minHeight = Y_MARGIN + imageHeight + BITMAP_Y_MARGIN + separatorHeight 
            + SEPARATOR_LINE_MARGIN + btnHeight + Y_MARGIN;
  FXuint minWidth = X_MARGIN + imageWidth + prevBtnWidth + nextBtnWidth 
            + BUTTON_MARGIN + cancelBtnWidth + X_MARGIN;
  
  // calculate request page sizes
  height = Y_MARGIN + FXMAX(DEFAULT_PAGE_HEIGHT,imageHeight) 
            + BITMAP_Y_MARGIN 
            + separatorHeight + SEPARATOR_LINE_MARGIN 
            + btnHeight + Y_MARGIN;
  width = X_MARGIN + imageWidth + DEFAULT_PAGE_WIDTH + X_MARGIN;


  // make sure the controls will fit in the wizard
  if (height < minHeight) height = minHeight;
  if (width < minWidth) width = minWidth;
  
  // resize the wizard pages to fill any gaps that may have been
  // created due to wizard resizing above.
  setPageSizes(width - X_MARGIN - imageWidth - X_MARGIN, height - Y_MARGIN - BITMAP_Y_MARGIN
                - separatorHeight - SEPARATOR_LINE_MARGIN - btnHeight - Y_MARGIN);
  
  // size the wizard
  resize(width,height);

  // move the image
  if(wizImage) wizImageFrame->move(X_MARGIN,Y_MARGIN);

  // move the separator
  FXuint x = X_MARGIN;
  FXuint y = Y_MARGIN + FXMAX(DEFAULT_PAGE_HEIGHT,imageHeight) + BITMAP_Y_MARGIN;
  separator->move(x,y);
  
  // relocate the button controls
  x = width - (prevBtnWidth + nextBtnWidth + cancelBtnWidth) - BUTTON_MARGIN - X_MARGIN;
  y += separatorHeight + SEPARATOR_LINE_MARGIN;
  
  btnPrev->move(x,y);
  x+=prevBtnWidth;
  btnNext->move(x,y);
  x+=nextBtnWidth + BUTTON_MARGIN;
  btnCancel->move(x,y);
  
  // relocate and resize the wizard pages
  x = X_MARGIN + imageWidth ;
  y = Y_MARGIN;
  movePages(x,y);
  }

/*****************************************************************************/
void FXWizardDialog::move(FXuint x, FXuint y) {
  posWizard.x = x;
  posWizard.y = y;
  }

/*****************************************************************************/
void FXWizardDialog::move(FXPoint pos) {
  posWizard = pos;
  }

/*****************************************************************************/
void FXWizardDialog::setPageSizes(FXuint w, FXuint h) {
  FXint index = pageArray.no()-1;
  FXWizardPage* currentPage;
  while(index >= 0) {
    currentPage=pageArray[index--];
    currentPage->setWidth(w);
    currentPage->setHeight(h);
    }
  }

/*****************************************************************************/
void FXWizardDialog::movePages(FXuint x, FXuint y) {
  FXint index = pageArray.no()-1;
  FXWizardPage* currentPage;
  while(index >= 0) {
    currentPage = pageArray[index--];
    currentPage->move(x,y);
    }
  }

/*****************************************************************************/
FXSize FXWizardDialog::getImageSizes() {
  FXint index = pageArray.no()-1;
  FXWizardPage* currentPage;
  FXint maxWidth=0, maxHeight=0;
  FXint curWidth=0, curHeight=0;

  if(wizImage && wizImage != FXWizardEmptyImage) {
    maxWidth = wizImage->getWidth();
    maxHeight = wizImage->getHeight();
    }

  FXImage* currentImage;
  while(index >= 0) {
    currentPage = pageArray[index--];
    currentImage = currentPage->getImage();
    if( currentImage && (currentImage != FXWizardEmptyImage) ) {
      curWidth = currentImage->getWidth();
      curHeight = currentImage->getHeight();
      if (maxWidth<curWidth) maxWidth = curWidth;
      if (maxHeight<curHeight) maxHeight = curHeight;
      }
    }
  return FXSize(maxWidth,maxHeight);
  }

/*****************************************************************************/
FXSize FXWizardDialog::getPageSizes() {  
  FXint index = pageArray.no()-1;
  FXWizardPage* currentPage;
  FXint maxWidth=0, maxHeight=0;
  FXint curWidth=0, curHeight=0;

  while(index >= 0) {
    currentPage = pageArray[index--];
    curWidth = currentPage->getDefaultWidth();
    curHeight = currentPage->getDefaultHeight();
    if (maxWidth<curWidth) maxWidth = curWidth;
    if (maxHeight<curHeight) maxHeight = curHeight;
    }
  return FXSize(maxWidth,maxHeight);
  }

/*****************************************************************************/
// ask the current page first: notice that we do it before calling
// getNext/Prev() because the data transfered from the controls of the page
// may change the value returned by these methods
long FXWizardDialog::onPrevOrNext(FXObject* sender,FXSelector,void*) { 
  // the page data is incorrect, don't do anything
  if ( page && !page->transferDataFromPage() ) return 1;  // FIXME this used to return 0
  // are we going forward or backward ??
  if ( (FXButton*)sender == btnNext ) showPage(page->getNext(),TRUE);
  else showPage(page->getPrev(),FALSE);
  return 1; 
  }

/*****************************************************************************/
long FXWizardDialog::onCancel(FXObject*,FXSelector,void*) { 
  // lets check and make sure if we really want to cancel
  if( page->handle(this,FXSEL(SEL_COMMAND,ID_WIZARD_CANCEL),NULL) ) {
    getApp()->stopModal(this,0);
    hide();
    // need to bring parent back up to the forground !!!!!!
//    getOwner()->show();
//    getParent()->show();
    }
  return 1; 
  }

/*****************************************************************************/
long FXWizardDialog::onHelp(FXObject*,FXSelector,void*) { 
  // just pass this on to the current wizard page to handle
  return page->handle(this,FXSEL(SEL_COMMAND,ID_WIZARD_HELP),NULL); 
  }

/*****************************************************************************/
// build image frame, seperator and navigation buttons
void FXWizardDialog::constructControls() {
  if(wizImage) wizImageFrame = new FXImageFrame(this,wizImage);
  separator = new FXHorizontalSeparator(this,LAYOUT_FIX_Y|SEPARATOR_GROOVE|LAYOUT_FILL_X);
  btnPrev = new FXButton(this,"< &Prev",NULL,this,ID_WIZARD_PREV,LAYOUT_EXPLICIT|FRAME_LINE|BUTTON_DEFAULT, 0,0,60,20);
  btnNext = new FXButton(this,"&Next >",NULL,this,ID_WIZARD_NEXT,LAYOUT_EXPLICIT|FRAME_LINE|BUTTON_DEFAULT|BUTTON_INITIAL, 0,0,60,20);
  btnCancel = new FXButton(this,"Cancel",NULL,this,ID_WIZARD_CANCEL,LAYOUT_EXPLICIT|FRAME_LINE|BUTTON_DEFAULT, 0,0,60,20);
  }

/*****************************************************************************/
int FXWizardDialog::run(FXWizardPage* startPage) {
  FXuint placement;
  if( (posWizard.x<0) || (posWizard.y<0) ){
    switch(posWizard.x){
      case -1: placement = PLACEMENT_DEFAULT; break;
      case -2: placement = PLACEMENT_VISIBLE; break;
      case -3: placement = PLACEMENT_CURSOR; break;
      case -4: placement = PLACEMENT_OWNER; break;
      case -5: placement = PLACEMENT_SCREEN; break;
      case -6: placement = PLACEMENT_MAXIMIZED; break;
      default: placement = PLACEMENT_SCREEN;
      }
    show(placement);
    }
  else {
    move(posWizard.x,posWizard.y);
    // FIXME changed this: FXWindow::move(posWizard.x,posWizard.y);
    show();
    }
  showPage(startPage, TRUE);
  return getApp()->runModalFor(this);
  }

/*****************************************************************************/
FXbool FXWizardDialog::showPage(FXWizardPage *pg, FXbool goingForward) {
  // we'll use this to decide whether we have to change the label of this
  // button or not (initially the label is "Next")
  bool btnLabelWasNext = TRUE;

  // flag to indicate if this page uses a new image
  bool ImageIsDefault = TRUE;

  // use these labels to determine if we need to change the image
  // for this page
  FXImage* PreviousImage = NULL;
  FXImage* ThisImage = NULL;

  // check for previous page, in case this is the fist invocation of the wizard
  if ( page ) {
    // send the event to the old page
    if (!page->handle(this,FXSEL(SEL_COMMAND,FXWizardPage::ID_WIZARDPAGE_CHANGING),&goingForward)){
      // canceled by the page
      return FALSE;
      }
    page->hide();

    //now disable the previous page
    page->disableFocus();
    btnLabelWasNext = page->getNext() != NULL;

    // Get the image of the previous page (if it exists)
    PreviousImage = page->getImage();
    }

  // set the new page
  page = pg;

  //is this the end?
  if ( !page ) {
    // terminate successfully
    getApp()->stopModal(this,1);
    hide();
    return TRUE;
    }

  // send the change event to the new page now, return values are ignored
  page->handle(this,FXSEL(SEL_COMMAND,FXWizardPage::ID_WIZARDPAGE_CHANGED),NULL);

  // position and show the new page
  page->recalc();
  page->show();

  // check if bitmap needs to be updated
  // update default flag as well
  if ( ThisImage == page->getImage() )
    ImageIsDefault = FALSE;

  // change the image if:
  // 1) a default image was selected in constructor
  // 2) this page was constructed with an image
  // 3) this image is not the previous image
  if( wizImage && (ThisImage != PreviousImage) ) {
    FXImage* image;
    if ( ImageIsDefault ) image = wizImage;
    else image = page->getImage();
    if(image == FXWizardEmptyImage) image = NULL; //set image to null so no image is drawn
    else image->create();
    wizImageFrame->setImage(image);
    FXTRACE((1,"Image = %i\n",(FXint)image));
    }

  // and update the buttons state
  if(page->getPrev() != (FXWizardPage *)NULL) 
    btnPrev->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_ENABLE),NULL); 
  else 
    btnPrev->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_DISABLE),NULL); 

  bool hasNext = page->getNext() != NULL;
  if ( btnLabelWasNext != hasNext ) {
    // need to update
    if (btnLabelWasNext) btnNext->setText("&Finish");
    else btnNext->setText("&Next >");
    }

  //now enable the next page
  page->enableFocus();
  return TRUE;
  }

/*****************************************************************************/
void FXWizardDialog::chain(FXWizardPage *first, ...) {
  FXWizardPage* nextPage;
  FXWizardPage* currentPage = first;
  va_list pageMarker;
  va_start( pageMarker, first );
  if(currentPage) {
    currentPage->setPrev(NULL);
    while(currentPage) {
      currentPage->setNext(NULL);  //in case there are no more pages
      nextPage = va_arg( pageMarker, FXWizardPage* );
      if (nextPage) {
        currentPage->setNext(nextPage);
        nextPage->setPrev(currentPage);
        }
      currentPage = nextPage;
      }
    }
  va_end( pageMarker );
  }

}

