/********************************************************************************
*                                                                               *
*                   Base type for threadable objects                            *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXString.h>
#include <fox/FXStream.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
using namespace FX;
#include "fxexdefs.h"
#include "FXMutex.h"
#include "FXThreadEvent.h"
#include "FXThreadedObject.h"
using namespace FXEX;
namespace FXEX {

// map
FXDEFMAP (FXThreadedObject) FXThreadedObjectMap[]={
  FXMAPTYPE(0,FXThreadedObject::onThreadEvent),
  FXMAPTYPE(FXThreadedObject::ID_THREADED_OBJECT,FXThreadedObject::onThreadSignal),
  };
FXIMPLEMENT_ABSTRACT(FXThreadedObject,FXObject,FXThreadedObjectMap,ARRAYNUMBER(FXThreadedObjectMap))

// Base threadable object
FXThreadedObject::FXThreadedObject(FXObject *tgt,FXSelector sel) : FXObject() {
  target=tgt;
  message=sel;
  event=new FXThreadEvent(this,ID_THREADED_OBJECT);
  mutex=new FXMutex();
  }

// cleanup resources
FXThreadedObject::~FXThreadedObject(){
  delete mutex;
  delete event;
  target=(FXObject*)-1;
  }

// return application object
FXApp* FXThreadedObject::getApp(){
  return FXApp::instance();
  }

// set target
void FXThreadedObject::setTarget(FXObject *tgt){
  mutex->lock();
  target=tgt;
  mutex->unlock();
  }

// get target
FXObject* FXThreadedObject::getTarget(){
  mutex->lock();
  FXObject *tgt(target);
  mutex->unlock();
  return tgt;
  }

// set the selector
void FXThreadedObject::setSelector(FXSelector sel){
  mutex->lock();
  message=sel;
  mutex->unlock();
  }

// get the selector
FXSelector FXThreadedObject::getSelector(){
  mutex->lock();
  FXSelector sel(message);
  mutex->unlock();
  return sel;
  }

// signal the target thread, using the SEL_THREAD message
void FXThreadedObject::signal(){
  event->signal();
  }

// specialised seltype message
void FXThreadedObject::signal(FXuint seltype){
  event->signal(seltype);
  }

// handle signal from 'event' object
long FXThreadedObject::onThreadSignal(FXObject*,FXSelector sel,void*){
  FXuint seltype=FXSELTYPE(sel);
  handle(this,FXSEL(seltype,0),NULL);
  return 1;
  }

// forward event to app
long FXThreadedObject::onThreadEvent(FXObject*,FXSelector sel,void*){
  FXuint seltype=FXSELTYPE(sel);
  mutex->lock();
  FXObject *tgt(target);
  FXSelector msg(message);
  mutex->unlock();
  return tgt && tgt->handle(this,FXSEL(seltype,msg),NULL);
  }
  
}

