/********************************************************************************
*                                                                               *
*                  Primary Thread manager                                       *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
using namespace FX;
#include "exincs.h"
#include "fxexdefs.h"
#include "FXFastMutex.h"
#include "FXRunnable.h"
#include "FXArray.h"
#include "FXThreadManager.h"
using namespace FXEX;
namespace FXEX {

// maps
FXIMPLEMENT(FXThreadManager,FXBaseObject,NULL,0)

// FXThreadManager is a singleton object
FXThreadManager* FXThreadManager::manager=NULL;

// deserialisation
FXThreadManager::FXThreadManager() : FXBaseObject() {
  if (manager!=NULL) fxerror("FXThreadManager: trying to create multiple instances.\n");
  last=-1;
  mutex=new FXFastMutex();
  manager=this;
#ifndef WIN32
  FXMALLOC(&mainthread,pthread_t,1);
  *((pthread_t*)mainthread)=pthread_self();
#else
  mainthread=GetCurrentThreadId();
#endif
  }

// create the thread manager
FXThreadManager::FXThreadManager(FXApp *a,FXObject *tgt,FXSelector sel) : FXBaseObject(a,tgt,sel){
  if (manager!=NULL) fxerror("FXThreadManager: trying to create multiple instances.\n");
  last=-1;
  mutex=new FXFastMutex();
  manager=this;
#ifndef WIN32
  FXMALLOC(&mainthread,pthread_t,1);
  *((pthread_t*)mainthread)=pthread_self();
#else
  mainthread=GetCurrentThread();
#endif
  }

// delete the thread manager (make sure there are no threads running)
FXThreadManager::~FXThreadManager(){
  mutex->lock();
  if(threadlist.no()>0) fxerror("%s: %i threads still in existance",getClassName(),threadlist.no());
#ifndef WIN32
  FXFREE(&mainthread);
#endif
  manager=NULL;
  mutex->unlock();
  delete mutex;
  }

// return an instance to this singleton
FXThreadManager* FXThreadManager::instance(){
  if (!manager) {
    manager=new FXThreadManager(FXApp::instance());
    }
  return manager;
  }

// add a thread to the list of managed threads
void FXThreadManager::add(FXRunnable *r){
  mutex->lock();
  threadlist.append(r);
  mutex->unlock();
  }

// remove a thread from the list of managed threads
void FXThreadManager::remove(FXRunnable *r){
  mutex->lock();
  threadlist.extract(r);
  mutex->unlock();
  if (size() == 0) delete this;
  }

// get size of threadlist
FXint FXThreadManager::size(){
  mutex->lock();
  FXint s=threadlist.no();
  mutex->unlock();
  return s;
  }

// get the next thread
// - this just increments to the next thread
// - if it hits the end, then it resets back to the start
FXRunnable* FXThreadManager::next(){
  mutex->lock();
  if (threadlist.no()>0){
    last++;
    if (last >= threadlist.no()) last=0;
    FXRunnable *r=threadlist[last];
    mutex->unlock();
    return r;
    }
  mutex->unlock();
  return NULL;
  }

}

