/********************************************************************************
*                                                                               *
*                    Vertical text scrolling widget                             *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/fxkeys.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
#include <fox/FXCharset.h>
#include <fox/FXFont.h>
#include <fox/FXText.h>
using namespace FX;
#include "FXTextVScroller.h"
using namespace FXEX;
namespace FXEX {

#define SCROLL_SPEED 500
#define SCROLL_DELAY 5000
#define SCROLL_INCREMENT 1

// Map
FXDEFMAP(FXTextVScroller) FXTextVScrollerMap[]={
  FXMAPFUNC(SEL_TIMEOUT,FXTextVScroller::ID_AUTOSCROLL,FXTextVScroller::onAutoScroll),
  };
FXIMPLEMENT(FXTextVScroller,FXPacker,FXTextVScrollerMap,ARRAYNUMBER(FXTextVScrollerMap))

// For deserialization
FXTextVScroller::FXTextVScroller(){
  flags|=FLAG_ENABLED;
  }

// Text scroller based on existing widget
FXTextVScroller::FXTextVScroller(FXComposite *p,FXText *t,FXObject* tgt,FXSelector sel,FXuint opts,FXbool own,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb): FXPacker(p,opts,x,y,w,h,pl,pr,pt,pb){
  flags|=FLAG_ENABLED;
  setTarget(tgt);
  setSelector(sel);
  text = t;
  speed = SCROLL_SPEED;
  delay = SCROLL_DELAY;
  increment = SCROLL_INCREMENT;
  owned=own;
  }

// Text scroller using our widget
FXTextVScroller::FXTextVScroller(FXComposite *p,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb): FXPacker(p,opts,x,y,w,h,pl,pr,pt,pb){
  flags|=FLAG_ENABLED;
  setTarget(tgt);
  setSelector(sel);
  text = new FXText(this,tgt,sel,opts|LAYOUT_FILL_X|LAYOUT_FILL_Y);
  speed = SCROLL_SPEED;
  delay = SCROLL_DELAY;
  increment = SCROLL_INCREMENT;
  owned=TRUE;
  }

// remove timer, delete text object
FXTextVScroller::~FXTextVScroller(){
  getApp()->removeTimeout(this,ID_AUTOSCROLL);
  if (owned) delete text;
  }

// create resources
void FXTextVScroller::create(){
  FXPacker::create();
  text->create();
  onAutoScroll(NULL,0,NULL);
  }

// detach resources
void FXTextVScroller::detach(){
  text->detach();
  FXPacker::detach();
  }

// destroy resources
void FXTextVScroller::destroy(){
  text->destroy();
  FXPacker::destroy();
  }

// save to stream
void FXTextVScroller::save(FXStream& store) const {
  store << text;
  store << speed;
  store << delay;
  store << increment;
  store << owned;
  }

// load resources
void FXTextVScroller::load(FXStream& store) {
  store >> text;
  store >> speed;
  store >> delay;
  store >> increment;
  store >> owned;
  }

// scroll the contents
void FXTextVScroller::scrollContents(){
  if (text->getDefaultHeight() < text->getContentHeight()) {
    FXint dy=increment;
    if (options&TEXTVSCROLLER_BYLINE) dy=text->getFont()->getFontHeight() * increment;
    text->moveContents(0,dy);
    }
  }

// handle scroll timeout so as to scroll the contents
long FXTextVScroller::onAutoScroll(FXObject*,FXSelector,void*){
  scrollContents();
  getApp()->addTimeout(this,ID_AUTOSCROLL,speed);
  return 1;
  }

}

