/***********************************-*- mode: c++; tab-width: 2 -*-*\
 *
 * NAME:     
 *   FXSplashWindow - Show a splash screen for app startup/about/etc
 *
 * AUTHOR:
 *   Daniel Gehriger (gehriger@linkcad.com)
 *
 * Updates:
 *   Mathew Robertson <mathew@users.sourceforge.net>
 *
 * Copyright (c) 1999 by Daniel Gehriger.  All Rights Reserved.
 *
 * PUPROSE:
 *   Display a splash window
 *
 * NOTE
 *
 * This library is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU Library General Public   
 * License as published by the Free Software Foundation; either  
 * version 2 of the License, or (at your option) any later version.
 *                                                                 
 * This library is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of  
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.                 
 *                                                                  
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free       
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * HISTORY:
 *        dgehrige - Dec, 10 1999: Created.
 *
\*******************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
#include <fox/FXPacker.h>
#include <fox/FXImage.h>
#include <fox/FXGIFImage.h>
#include <fox/FXBMPImage.h>
#include <fox/FXXPMImage.h>
#include <fox/FXPCXImage.h>
#include <fox/FXICOImage.h>
#include <fox/FXTGAImage.h>
#include <fox/FXRGBImage.h>
#include <fox/FXPNGImage.h>
#include <fox/FXJPGImage.h>
#include <fox/FXTIFImage.h>
#include <fox/FXImageFrame.h>
#include <fox/FXFile.h>
using namespace FX;
#include "fxexdefs.h"
#include "fxexutils.h"
#include "FXSplashWindow.h"
using namespace FXEX;
namespace FXEX {

#define SPLASHWINDOW_MASK (SPLASH_AUTORAISE)

FXDEFMAP(FXSplashWindow) FXSplashWindowMap[]={
  FXMAPFUNC(SEL_FOCUSOUT,0,FXSplashWindow::onFocusOut),
  FXMAPFUNC(SEL_TIMEOUT,FXSplashWindow::ID_SPLASH, FXSplashWindow::onTimeout),
  };
FXIMPLEMENT(FXSplashWindow,FXTopWindow,FXSplashWindowMap,ARRAYNUMBER(FXSplashWindowMap))

// ctor
FXSplashWindow::FXSplashWindow(FXApp *a,const FXString &title,FXint to,FXuint opts,FXint w,FXint h,FXint hs,FXint vs) : FXTopWindow(a,title,NULL,NULL,opts,0,0,w,h,0,0,0,0,hs,vs),timeout(to){}


// remove timeout on destruction
FXSplashWindow::~FXSplashWindow() {
  getApp()->removeTimeout(this,ID_SPLASH);
  if (image) delete image;
  }

// save to stream
void FXSplashWindow::save(FXStream& store) const {
  FXTopWindow::save(store);
  store << timeout;
  }

// load from stream
void FXSplashWindow::load(FXStream& store) {
  FXTopWindow::load(store);
  store >> timeout;
  }

// run splashwindow modally
FXuint FXSplashWindow::execute(FXuint placement){
  create();
  show(placement);
  return getApp()->runWhileEvents(NULL);
  }

// Show splash window
void FXSplashWindow::show() {
  if (!shown()){
    getApp()->removeTimeout(this,ID_SPLASH);
    getApp()->addTimeout(this,ID_SPLASH,timeout);
    FXTopWindow::show();
    }
  }

// Hide splash window
void FXSplashWindow::hide() {
  if (shown()) {
    getApp()->removeTimeout(this,ID_SPLASH);
    FXTopWindow::hide();
    }
  if (options & SPLASH_HIDEDESTROY) delete this;
  }

// Show splash window with a given placement
void FXSplashWindow::show(FXuint placement) {
  if (!shown()){
    getApp()->removeTimeout(this,ID_SPLASH);
    getApp()->addTimeout(this,ID_SPLASH,timeout);
    FXTopWindow::show(placement);
    }
  }

// set the image from a file
void FXSplashWindow::setImage(const FXString& file){
  image=FXUtils::loadImage(file);
  if (image) new FXImageFrame(this,image);
  }

// fully update the GUI state
void FXSplashWindow::flush(){
  getApp()->runWhileEvents(NULL);  // this should result in a no-op
  getApp()->forceRefresh();
  getApp()->flush(TRUE);
  getApp()->flush();
  }

// timeout expired -> stop showing it
long FXSplashWindow::onTimeout(FXObject*, FXSelector, void*) {
  hide();
  if (options & SPLASH_AUTODESTROY) delete this;
  return 1;
  }

// Lost focus -> raise window
long FXSplashWindow::onFocusOut(FXObject*, FXSelector, void*) {
  if (options & SPLASH_AUTORAISE) {
    raise();
    return 1;
    }
  return 0;
  }

}

