/********************************************************************************
*                                                                               *
*                  Pane close widget                                            *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
#include <fox/FXLabel.h>
#include <fox/FXButton.h>
using namespace FX;
#include "FXPaneHeader.h"
using namespace FXEX;
namespace FXEX {

FXDEFMAP(FXPaneHeader) FXPaneHeaderMap[]={
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETSTRINGVALUE,FXPaneHeader::onCmdSetStringValue),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_GETSTRINGVALUE,FXPaneHeader::onCmdGetStringValue),
  };
FXIMPLEMENT(FXPaneHeader,FXHorizontalFrame,FXPaneHeaderMap,ARRAYNUMBER(FXPaneHeaderMap))

// Deserialisation
FXPaneHeader::FXPaneHeader(){
  flags|=FLAG_ENABLED;
  }

// Make new pane header
FXPaneHeader::FXPaneHeader(FXComposite* p,const FXString& lbl,FXIcon* icon,FXObject* tgt, FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h,FXint pl,FXint pr,FXint pt,FXint pb) : FXHorizontalFrame(p,opts|LAYOUT_FILL_X,x,y,w,h,pl,pr,pt,pb,0,0){
  FXString buttonText = "\tClose\tClose this pane.";
  if (!icon) buttonText = " X " + buttonText;
  textLabel= new FXLabel(this,lbl,NULL,LAYOUT_CENTER_Y|JUSTIFY_LEFT, 0,0,0,0, 0,0,0,0 );
  closeButton= new FXButton(this,buttonText,icon,tgt,sel,LAYOUT_CENTER_Y|BUTTON_TOOLBAR|FRAME_RAISED|LAYOUT_RIGHT, 0,0,0,0, 0,0,0,0 );
  }

FXPaneHeader::~FXPaneHeader(){
  delete closeButton;
  delete textLabel;
  }

// Change the label text
void FXPaneHeader::setText(const FXString& lbl){
  textLabel->setText(lbl);
  }

// Get the label text
FXString FXPaneHeader::getText() const {
  return textLabel->getText();
  }

// Save data
void FXPaneHeader::save(FXStream& store) const {
  FXHorizontalFrame::save(store);
  store << textLabel;
  store << closeButton;
  }

// Load data
void FXPaneHeader::load(FXStream& store){
  FXHorizontalFrame::load(store);
  store >> textLabel;
  store >> closeButton;
  }

// Update value from a message
long FXPaneHeader::onCmdSetStringValue(FXObject*,FXSelector,void* ptr){
  setText(*((FXString*)ptr));
  return 1;
  }

// Obtain value from text field
long FXPaneHeader::onCmdGetStringValue(FXObject*,FXSelector,void* ptr){
  *((FXString*)ptr)=getText();
  return 1;
  }

}

