/********************************************************************************
*                                                                               *
*                   Simulated worker thread object                              *
*                                                                               *
*********************************************************************************
* Copyright (C) 2003 by Mathew Robertson.   All Rights Reserved.                *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
*********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
using namespace FX;
#include "fxexdefs.h"
#include "FXNullThread.h"
using namespace FXEX;
namespace FXEX {

FXDEFMAP (FXNullThread) FXNullThreadMap[]={
  FXMAPFUNC(SEL_CHORE,FXNullThread::ID_RUN,FXNullThread::onThreadRun),
  FXMAPFUNC(SEL_CHORE,FXNullThread::ID_YIELD,FXNullThread::onThreadYield),
  };
FXIMPLEMENT_ABSTRACT(FXNullThread,FXRunnable,FXNullThreadMap,ARRAYNUMBER(FXNullThreadMap))

// construct a new thread, then execute the specified function
FXNullThread::FXNullThread(FXObject *tgt,FXSelector sel) : FXRunnable(tgt,sel){
  running=FALSE;
  idle=0;
  idleCount=0;
  }

// dtor
FXNullThread::~FXNullThread(){
  getApp()->removeChore(this,ID_YIELD);
  getApp()->removeChore(this,ID_RUN);
  }

// start the thread running
void FXNullThread::start(){
  getApp()->addChore(this,ID_RUN);
  }

// yield the thread
void FXNullThread::yield(){
  getApp()->flush(true);  // catch up with current events
  sleep(0);
  idleCount=0;
  getApp()->addChore(this,ID_YIELD);
  getApp()->runUntil(idle);
  }

// sleep (in lots of OS implementations) results in a reschedule of the task to allow
// other processes to run, ie sleep(0) just allows other processes to run if thy can,
// before returning to this task
void FXNullThread::sleep(FXint ms){
  if (ms==0) yield();
  else FXRunnable::sleep(ms);
  }

// execute the thread
long FXNullThread::onThreadRun(FXObject*,FXSelector,void*){
  running=TRUE;
  fxmessage("%s: running simulated thread\n",getClassName());
  run();
  fxmessage("%s: finished simulated thread\n",getClassName());
  running=FALSE;
  return 1;
  }

// executed when we yield
// Note: we re-chore so as to ensure that we are the last chore on the list of work
//       that FXApp needs to process (ie we redo it a few times to ensure there
//       are no other chores waiting in the list)
long FXNullThread::onThreadYield(FXObject*,FXSelector,void *){
  if (idleCount < 5) {
    idleCount++;
    getApp()->addChore(this,ID_YIELD);
    return 1;
    }
  idle=1;
  return 1;
  }

FXbool FXNullThread::isRunning(){
  return running;
  }

}

