/********************************************************************************
* FXNetworkSelectorEx.cpp                                                       *
* Copyright (C) 2001 by Dustin Graves. All Rights Reserved.                     *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#include <config.h>
#ifdef WIN32
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
using namespace FX;
#include "FXNetworkListEx.h"
#include "FXNetworkSelectorEx.h"
using namespace FXEX;
namespace FXEX {

FXDEFMAP(FXNetworkSelectorEx) FXNetworkSelectorExMap[]={
  FXMAPFUNC(SEL_UPDATE,FXNetworkSelectorEx::ID_NETLIST,FXNetworkSelectorEx::onUpdNetList)
  };
FXIMPLEMENT(FXNetworkSelectorEx,FXPacker,FXNetworkSelectorExMap,ARRAYNUMBER(FXNetworkSelectorExMap))

// ctor
FXNetworkSelectorEx::FXNetworkSelectorEx(FXComposite *p,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h) : FXPacker(p,opts,x,y,w,h) {
  setTarget(tgt);
  setSelector(sel);
  label=new FXLabel(this,"Choose the computer you wish to connect with.",NULL,JUSTIFY_LEFT|LAYOUT_SIDE_TOP|LAYOUT_FILL_X);
  FXHorizontalFrame *buttons=new FXHorizontalFrame(this,LAYOUT_SIDE_BOTTOM|LAYOUT_BOTTOM|LAYOUT_RIGHT,0,0,0,0, 0,0,0,0);
  accept=new FXButton(buttons,"&Accept",NULL,NULL,0,BUTTON_DEFAULT|FRAME_RAISED|FRAME_THICK,0,0,0,0,20,20);
  cancel=new FXButton(buttons,"&Cancel",NULL,NULL,0,FRAME_RAISED|FRAME_THICK,0,0,0,0,20,20);

  FXVerticalFrame *frame=new FXVerticalFrame(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y|FRAME_SUNKEN|FRAME_THICK,0,0,0,0,0,0,0,0);
  netbox=new FXNetworkListEx(frame,0,this,ID_NETLIST,LAYOUT_FILL_X|LAYOUT_FILL_Y|LAYOUT_TOP|TREELIST_SHOWS_LINES|TREELIST_SHOWS_BOXES|TREELIST_ROOT_BOXES|TREELIST_BROWSESELECT);
  }

// dtor
FXNetworkSelectorEx::~FXNetworkSelectorEx() {
  label=(FXLabel*)-1;
  netbox=(FXNetworkListEx*)-1;
  accept=(FXButton*)-1;
  cancel=(FXButton*)-1;
  }

// save to stream
void FXNetworkSelectorEx::save(FXStream& store) const {
  FXPacker::save(store);
  store << label;
  store << netbox;
  store << accept;
  store << cancel;
  }

// load from stream
void FXNetworkSelectorEx::load(FXStream& store) {
  FXPacker::load(store);
  store >> label;
  store >> netbox;
  store >> accept;
  store >> cancel;
  }

//When called, will relist net neighborhood.  A wait cursor is optional.
FXbool FXNetworkSelectorEx::refreshNetworkList(FXbool waitCursor) {
  return netbox->refreshNetworkList(waitCursor);
  }

//When called, option to relist net neighborhood.  A wait cursor is optional.
void FXNetworkSelectorEx::showNetworkShares(FXbool show,FXbool refresh,FXbool waitCursor) {
  netbox->showNetworkShares(show,refresh,waitCursor);
  }

FXbool FXNetworkSelectorEx::showNetworkShares() const {
  return netbox->showNetworkShares();
  }

void FXNetworkSelectorEx::setSelection(const FXString& name) {
  netbox->setCurrentSelection(name);
  }

FXString FXNetworkSelectorEx::getSelection() const {
  return netbox->getCurrentSelection();
  }

FXString FXNetworkSelectorEx::getNetworkName(const FXString& name) const {
  return netbox->getNetworkName(name);
  }

FXString FXNetworkSelectorEx::getSelectionNetworkName() const {
  return netbox->getCurrentNetworkName();
  }

void FXNetworkSelectorEx::setNetBoxStyle(FXuint style) {
  netbox->setListStyle(style);
  }

FXuint FXNetworkSelectorEx::getNetBoxStyle() const {
  return netbox->getListStyle();
  }

// handle the case where the user has correctly clicked on a valid item, then
// make the accept button enabled
long FXNetworkSelectorEx::onUpdNetList(FXObject*,FXSelector,void*) {
  const FXNetworkItemEx* item=(const FXNetworkItemEx*) netbox->getCurrentItem();
  if((item!=NULL)&&(item->isComputer()||item->isShare()))
    accept->handle(this,FXSEL(SEL_COMMAND,ID_ENABLE),NULL);
  else
    accept->handle(this,FXSEL(SEL_COMMAND,ID_DISABLE),NULL);
  return 1;
  }

}
#endif

