/********************************************************************************
*                                                                               *
*                           E x p l o r e r   O b j e c t                       *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998,2001 by Jeroen van der Zijp.   All Rights Reserved.        *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Lesser General Public                    *
* License as published by the Free Software Foundation; either                  *
* version 2.1 of the License, or (at your option) any later version.            *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Lesser General Public License for more details.                               *
*                                                                               *
* You should have received a copy of the GNU Lesser General Public              *
* License along with this library; if not, write to the Free Software           *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA.    *
********************************************************************************/
#include <config.h>
#include <fox/fxver.h>
#include <fox/xincs.h>
#include <fox/fxdefs.h>
#include <fox/FXStream.h>
#include <fox/FXString.h>
#include <fox/FXSize.h>
#include <fox/FXPoint.h>
#include <fox/FXRectangle.h>
#include <fox/FXRegistry.h>
#include <fox/FXApp.h>
#include <fox/FXFileDict.h>
#include <fox/FXGIFIcon.h>
#include <fox/FXBMPIcon.h>
#include <fox/FXFile.h>
#include <fox/FXURL.h>
using namespace FX;
#include "FXExplorer.h"
using namespace FXEX;
namespace FXEX {

#define cEI(ti) static_cast<const FXExplorerItem *>(ti)
#define EI(ti) static_cast<FXExplorerItem *>(ti)

/*
  Notes:
  - One can never create items in constructor:- createItem() may be overloaded!
  - Instead of FXTreeItems, callbacks should pass pointer to directory?
  - Clipboard of a filenames.
  - Should do drag and drop and such.
  - Should be able to set initial directory/filename path, i.e. open all from
    root through last pathname segment which really exists.
  - Clipboard, DND, etc. support.
  - We should NOT assume the root's name is just '/'.  It could be C:\ etc.
  - Try read icons from <path>/.dir.gif and <path>/.opendir.gif!
  - Special icon for root.
  - We should generate SEL_INSERTED, SEL_DELETED, SEL_REPLACED, SEL_CHANGED
    messages as the FXExplorer updates itself from the file system.
  - Under MS-Windows, always pass FILEMATCH_NOESCAPE setting match mode!
*/


#define REFRESHINTERVAL     1000   // Interval between refreshes
#define REFRESHINTERVALLONG 15000
#define REFRESHFREQUENCY    32     // File systems not supporting mod-time, refresh every nth time

/*******************************************************************************/

/* Generated by reswrap from file minifolderopen.gif */
const unsigned char minifolderopen[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x00,0x00,0x00,0x7f,0x7f,0x7f,0xff,0xff,0xff,0xd9,0xd9,0xd9,0xff,0xff,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x42,0x08,0xba,0xdc,0x2c,0x10,0xba,0x37,0x6a,0x15,0x13,0x88,0x41,0x4a,0x27,0x43,
  0x14,0x29,0x9b,0x67,0x82,0x56,0x18,0x68,0xdc,0xe9,0x12,0x42,0x20,0xce,0x62,0x11,
  0x6f,0x69,0x1e,0xc3,0x72,0xfb,0xb9,0xb2,0x18,0xeb,0x47,0xbc,0xad,0x4a,0xc4,0x93,
  0x6c,0xc5,0x7a,0x99,0x62,0x4c,0x1a,0x2d,0xc0,0x04,0x50,0xaf,0x58,0x6c,0x66,0xcb,
  0x6d,0x24,0x00,0x00,0x3b
  };

/* Generated by reswrap from file minifolderclosed.gif */
const unsigned char minifolderclosed[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x80,0x80,0x80,0xc0,0xc0,0xc0,0xff,0xff,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x3b,0x08,0xba,0xdc,0x1b,0x10,0x3a,0x16,0xc4,0xb0,0x22,0x4c,0x50,0xaf,0xcf,0x91,
  0xc4,0x15,0x64,0x69,0x92,0x01,0x31,0x7e,0xac,0x95,0x8e,0x58,0x7b,0xbd,0x41,0x21,
  0xc7,0x74,0x11,0xef,0xb3,0x5a,0xdf,0x9e,0x1c,0x6f,0x97,0x03,0xba,0x7c,0xa1,0x64,
  0x48,0x05,0x20,0x38,0x9f,0x50,0xe8,0x66,0x4a,0x75,0x24,0x00,0x00,0x3b
  };

/* Generated by reswrap from file minidoc.gif */
const unsigned char minidoc[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xbf,0xbf,0xbf,
  0x80,0x80,0x80,0xff,0xff,0xff,0xc0,0xc0,0xc0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x36,0x08,0x10,0xdc,0xae,0x70,0x89,0x49,0xe7,0x08,0x51,0x56,0x3a,0x04,0x86,0xc1,
  0x46,0x11,0x24,0x01,0x8a,0xd5,0x60,0x2a,0x21,0x6a,0xad,0x9a,0xab,0x9e,0xae,0x30,
  0xb3,0xb5,0x0d,0xb7,0xf2,0x9e,0xdf,0x31,0x14,0x90,0x27,0xf4,0xd5,0x86,0x83,0xa4,
  0x72,0x09,0x2c,0x39,0x9f,0xa6,0x04,0x00,0x3b
  };

/* Generated by reswrap from file miniapp.gif */
const unsigned char miniapp[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x10,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x80,0x80,0x80,0xc0,0xc0,0xc0,0x00,0x00,0x00,0xff,0xff,0xff,0x00,0x00,0x80,0x00,
  0x00,0x00,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x00,0x00,0x03,
  0x38,0x08,0xba,0xdc,0x10,0x30,0xca,0x09,0x85,0xbd,0xf8,0x86,0x11,0x44,0xf9,0x60,
  0xf8,0x6d,0x9d,0x58,0x10,0x03,0x8a,0x92,0x02,0xe5,0x72,0x02,0x21,0xcf,0xb4,0xcc,
  0xd6,0x38,0x71,0xe7,0xf4,0xce,0xdb,0xb0,0xdf,0xcc,0xf7,0x23,0xf2,0x48,0xae,0xd7,
  0x60,0xc9,0x6c,0x3a,0x07,0x8e,0xe8,0x22,0x01,0x00,0x3b
  };


const unsigned char floppy[]={
  0x42,0x4d,0xf6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x76,0x00,0x00,0x00,0x28,0x00,
  0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x00,
  0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x80,
  0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x80,
  0x00,0x00,0x80,0x80,0x80,0x00,0xc0,0xc0,0xc0,0x00,0x00,0x00,0xff,0x00,0x00,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0xff,0xff,0xff,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xd0,0x00,
  0x00,0x00,0x00,0x00,0x0d,0xdd,0x77,0x77,0x77,0x77,0x77,0x77,0x70,0xdd,0x78,0x88,
  0xff,0xff,0x88,0x88,0x77,0x0d,0x78,0x77,0x00,0x00,0x77,0x78,0x77,0x0d,0x78,0x88,
  0x77,0x77,0x88,0x88,0x77,0x0d,0x78,0x88,0x88,0x88,0x88,0x98,0x77,0x0d,0x7f,0xff,
  0xff,0xff,0xf0,0x00,0x00,0x0d,0xd7,0x88,0x88,0x88,0x78,0x70,0x7f,0x80,0xdd,0x77,
  0x77,0x77,0x78,0x77,0x77,0x80,0xdd,0xdd,0xdd,0xdd,0x78,0x88,0x88,0x80,0xdd,0xdd,
  0xdd,0xdd,0x78,0xff,0xff,0x80,0xdd,0xdd,0xdd,0xdd,0x78,0xff,0xff,0x80,0xdd,0xdd,
  0xdd,0xdd,0x78,0xff,0xff,0x00,0xdd,0xdd,0xdd,0xdd,0x78,0xff,0xff,0x80,0xdd,0xdd,
  0xdd,0xdd,0xd7,0x77,0x77,0x7d
  };

const unsigned char harddisk[]={
  0x42,0x4d,0xf6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x76,0x00,0x00,0x00,0x28,0x00,
  0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x00,
  0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x80,
  0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x80,
  0x00,0x00,0x80,0x80,0x80,0x00,0xc0,0xc0,0xc0,0x00,0x00,0x00,0xff,0x00,0x00,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0xff,0xff,0xff,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,
  0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0xdd,0x77,0x77,
  0x77,0x77,0x77,0x77,0x77,0x0d,0x78,0xff,0xff,0xff,0xff,0xff,0x87,0x70,0x78,0x77,
  0x77,0x77,0x77,0x77,0x87,0x70,0x78,0x88,0x88,0x88,0x88,0x88,0x87,0x70,0x78,0x88,
  0x88,0x88,0x88,0x82,0x87,0x70,0x7f,0xff,0xff,0xff,0xff,0xff,0xf7,0x70,0xd7,0x88,
  0x88,0x88,0x88,0x88,0x88,0x70,0xdd,0x77,0x77,0x77,0x77,0x77,0x77,0x7d,0xdd,0xdd,
  0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,
  0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,
  0xdd,0xdd,0xdd,0xdd,0xdd,0xdd
  };

const unsigned char cdrom[]={
  0x42,0x4d,0xf6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x76,0x00,0x00,0x00,0x28,0x00,
  0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x00,
  0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x80,
  0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x80,
  0x00,0x00,0x80,0x80,0x80,0x00,0xc0,0xc0,0xc0,0x00,0x00,0x00,0xff,0x00,0x00,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0xff,0xff,0xff,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xd0,0x00,
  0x00,0x00,0x00,0x00,0x00,0xdd,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x0d,0x7f,0x88,
  0xff,0xff,0xf8,0x88,0x87,0x0d,0x7f,0xa2,0x00,0x00,0x00,0x00,0x87,0x0d,0x7f,0x88,
  0x88,0x87,0x78,0x88,0x00,0x0d,0x7f,0xff,0xff,0x78,0xf8,0x88,0xa7,0x0d,0xd7,0x77,
  0x77,0x78,0x8f,0x88,0xbe,0x70,0xdd,0xdd,0xd7,0x88,0x87,0x07,0xe8,0x80,0xdd,0xdd,
  0xd7,0x88,0xa0,0xd0,0x88,0x80,0xdd,0xdd,0xd7,0x8a,0xa7,0x07,0xf8,0x80,0xdd,0xdd,
  0xdd,0x7a,0xeb,0xb8,0x8f,0x0d,0xdd,0xdd,0xdd,0x7e,0xeb,0xb8,0x88,0x0d,0xdd,0xdd,
  0xdd,0xd7,0x7b,0xb8,0x77,0xdd,0xdd,0xdd,0xdd,0xdd,0xd7,0x77,0xdd,0xdd,0xdd,0xdd,
  0xdd,0xdd,0xdd,0xdd,0xdd,0xdd
  };

const unsigned char networkdisk[]={
  0x42,0x4d,0xf6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x76,0x00,0x00,0x00,0x28,0x00,
  0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x00,
  0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x80,
  0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x80,
  0x00,0x00,0x80,0x80,0x80,0x00,0xc0,0xc0,0xc0,0x00,0x00,0x00,0xff,0x00,0x00,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0xff,0xff,0xff,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,
  0xdd,0x00,0x00,0xdd,0xdd,0xdd,0x00,0x00,0x00,0xbf,0x30,0x00,0x00,0x00,0x88,0x88,
  0x88,0x33,0x30,0x88,0x88,0x88,0xdd,0xdd,0xdd,0xd8,0x0d,0xdd,0xdd,0xdd,0xdd,0xdd,
  0xdd,0xd0,0x0d,0xdd,0xdd,0xdd,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0xdd,0x78,0xff,
  0xff,0xff,0xff,0xff,0x87,0x0d,0x78,0x77,0x77,0x77,0x77,0x77,0x87,0x70,0x78,0x88,
  0x88,0x88,0x88,0x88,0x87,0x70,0x78,0x88,0x88,0x88,0x88,0x82,0xa7,0x70,0x7f,0xff,
  0xff,0xff,0xff,0xff,0xf7,0x70,0xd7,0x88,0x88,0x88,0x88,0x88,0x88,0x70,0xdd,0x77,
  0x77,0x77,0x77,0x77,0x77,0x7d,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,
  0xdd,0xdd,0xdd,0xdd,0xdd,0xdd
  };

const unsigned char zipdisk[]={
  0x42,0x4d,0xf6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x76,0x00,0x00,0x00,0x28,0x00,
  0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x00,
  0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x80,
  0x00,0x00,0x00,0x80,0x80,0x00,0x80,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0x80,0x80,
  0x00,0x00,0x80,0x80,0x80,0x00,0xc0,0xc0,0xc0,0x00,0x00,0x00,0xff,0x00,0x00,0xff,
  0x00,0x00,0x00,0xff,0xff,0x00,0xff,0x00,0x00,0x00,0xff,0x00,0xff,0x00,0xff,0xff,
  0x00,0x00,0xff,0xff,0xff,0x00,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,
  0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xd0,0x00,0x00,0x00,0x00,0x00,0x00,0xdd,0x7f,0x77,
  0x77,0x77,0x77,0x77,0x77,0x0d,0x7f,0x88,0x88,0x88,0x88,0x88,0x87,0x70,0x7f,0x88,
  0x8f,0xff,0xff,0xf8,0x87,0x70,0x7f,0x88,0xf0,0x00,0x00,0x0f,0x87,0x70,0x7f,0x98,
  0x70,0x00,0x00,0x07,0x87,0x70,0x7f,0x88,0x88,0x88,0x88,0x88,0x87,0x70,0x7f,0xff,
  0xff,0xff,0xff,0xff,0xf7,0x70,0xd7,0x88,0x88,0x88,0x88,0x88,0x88,0x70,0xdd,0x77,
  0x77,0x77,0x77,0x77,0x77,0x7d,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,
  0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,0xdd,
  0xdd,0xdd,0xdd,0xdd,0xdd,0xdd
  };


/*******************************************************************************/

// Object implementation
FXIMPLEMENT(FXExplorerItem,FXTreeItem,NULL,0)


/*******************************************************************************/

// Map
FXDEFMAP(FXExplorer) FXExplorerMap[]={
  FXMAPFUNC(SEL_DRAGGED,0,FXExplorer::onDragged),
  FXMAPFUNC(SEL_TIMEOUT,FXExplorer::ID_REFRESH,FXExplorer::onRefresh),
  FXMAPFUNC(SEL_DND_ENTER,0,FXExplorer::onDNDEnter),
  FXMAPFUNC(SEL_DND_LEAVE,0,FXExplorer::onDNDLeave),
  FXMAPFUNC(SEL_DND_DROP,0,FXExplorer::onDNDDrop),
  FXMAPFUNC(SEL_DND_MOTION,0,FXExplorer::onDNDMotion),
  FXMAPFUNC(SEL_DND_REQUEST,0,FXExplorer::onDNDRequest),
  FXMAPFUNC(SEL_BEGINDRAG,0,FXExplorer::onBeginDrag),
  FXMAPFUNC(SEL_ENDDRAG,0,FXExplorer::onEndDrag),
  FXMAPFUNC(SEL_OPENED,0,FXExplorer::onOpened),
  FXMAPFUNC(SEL_CLOSED,0,FXExplorer::onClosed),
  FXMAPFUNC(SEL_EXPANDED,0,FXExplorer::onExpanded),
  FXMAPFUNC(SEL_COLLAPSED,0,FXExplorer::onCollapsed),
  FXMAPFUNC(SEL_UPDATE,FXExplorer::ID_SHOW_HIDDEN,FXExplorer::onUpdShowHidden),
  FXMAPFUNC(SEL_UPDATE,FXExplorer::ID_HIDE_HIDDEN,FXExplorer::onUpdHideHidden),
  FXMAPFUNC(SEL_UPDATE,FXExplorer::ID_TOGGLE_HIDDEN,FXExplorer::onUpdToggleHidden),
  FXMAPFUNC(SEL_UPDATE,FXExplorer::ID_SHOW_FILES,FXExplorer::onUpdShowFiles),
  FXMAPFUNC(SEL_UPDATE,FXExplorer::ID_HIDE_FILES,FXExplorer::onUpdHideFiles),
  FXMAPFUNC(SEL_UPDATE,FXExplorer::ID_TOGGLE_FILES,FXExplorer::onUpdToggleFiles),
  FXMAPFUNC(SEL_UPDATE,FXExplorer::ID_SET_PATTERN,FXExplorer::onUpdSetPattern),
  FXMAPFUNC(SEL_UPDATE,FXExplorer::ID_SORT_REVERSE,FXExplorer::onUpdSortReverse),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETVALUE,FXExplorer::onCmdSetValue),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_SETSTRINGVALUE,FXExplorer::onCmdSetStringValue),
  FXMAPFUNC(SEL_COMMAND,FXWindow::ID_GETSTRINGVALUE,FXExplorer::onCmdGetStringValue),
  FXMAPFUNC(SEL_COMMAND,FXExplorer::ID_SHOW_HIDDEN,FXExplorer::onCmdShowHidden),
  FXMAPFUNC(SEL_COMMAND,FXExplorer::ID_HIDE_HIDDEN,FXExplorer::onCmdHideHidden),
  FXMAPFUNC(SEL_COMMAND,FXExplorer::ID_TOGGLE_HIDDEN,FXExplorer::onCmdToggleHidden),
  FXMAPFUNC(SEL_COMMAND,FXExplorer::ID_SHOW_FILES,FXExplorer::onCmdShowFiles),
  FXMAPFUNC(SEL_COMMAND,FXExplorer::ID_HIDE_FILES,FXExplorer::onCmdHideFiles),
  FXMAPFUNC(SEL_COMMAND,FXExplorer::ID_TOGGLE_FILES,FXExplorer::onCmdToggleFiles),
  FXMAPFUNC(SEL_COMMAND,FXExplorer::ID_SET_PATTERN,FXExplorer::onCmdSetPattern),
  FXMAPFUNC(SEL_COMMAND,FXExplorer::ID_SORT_REVERSE,FXExplorer::onCmdSortReverse),
  };


// Object implementation
FXIMPLEMENT(FXExplorer,FXTreeList,FXExplorerMap,ARRAYNUMBER(FXExplorerMap))


// For serialization
FXExplorer::FXExplorer(){
  flags|=FLAG_ENABLED|FLAG_DROPTARGET;
  counter=0;
  associations=NULL;
  dropaction=DRAG_MOVE;
  }


// Directory List Widget
FXExplorer::FXExplorer(FXComposite *p,FXint nvis,FXObject* tgt,FXSelector sel,FXuint opts,FXint x,FXint y,FXint w,FXint h):
  FXTreeList(p,nvis,tgt,sel,opts,x,y,w,h),pattern("*"){
  flags|=FLAG_ENABLED|FLAG_DROPTARGET;
  associations=NULL;
  open_folder=new FXGIFIcon(getApp(),minifolderopen);
  closed_folder=new FXGIFIcon(getApp(),minifolderclosed);
  mini_doc=new FXGIFIcon(getApp(),minidoc);
  mini_app=new FXGIFIcon(getApp(),miniapp);
  cdromicon=new FXBMPIcon(getApp(),cdrom,0,IMAGE_ALPHAGUESS);
  harddiskicon=new FXBMPIcon(getApp(),harddisk,0,IMAGE_ALPHAGUESS);
  networkicon=new FXBMPIcon(getApp(),networkdisk,0,IMAGE_ALPHAGUESS);
  floppyicon=new FXBMPIcon(getApp(),floppy,0,IMAGE_ALPHAGUESS);
  zipdiskicon=new FXBMPIcon(getApp(),zipdisk,0,IMAGE_ALPHAGUESS);
  matchmode=FILEMATCH_FILE_NAME|FILEMATCH_NOESCAPE;
#ifdef WIN32
  matchmode|=FILEMATCH_CASEFOLD;
#endif
  if(!(options&EXPLORER_NO_OWN_ASSOC)) associations=new FXFileDict(getApp());
  sortfunc=cmpFName;
  dropaction=DRAG_MOVE;
  counter=0;
  }


// Create X window
void FXExplorer::create(){
  FXTreeList::create();
  if(!deleteType){deleteType=getApp()->registerDragType(deleteTypeName);}
  if(!urilistType){urilistType=getApp()->registerDragType(urilistTypeName);}
  getApp()->removeTimeout(this,ID_REFRESH);
  getApp()->addTimeout(this,ID_REFRESH,REFRESHINTERVAL);
  open_folder->create();
  closed_folder->create();
  mini_doc->create();
  mini_app->create();
  cdromicon->create();
  harddiskicon->create();
  networkicon->create();
  floppyicon->create();
  zipdiskicon->create();
  scanRootDir(FALSE);
  }


// Detach disconnects the icons
void FXExplorer::detach(){
  FXTreeList::detach();
  getApp()->removeTimeout(this,ID_REFRESH);
  open_folder->detach();
  closed_folder->detach();
  mini_doc->detach();
  mini_app->detach();
  cdromicon->detach();
  harddiskicon->detach();
  networkicon->detach();
  floppyicon->detach();
  zipdiskicon->detach();
  deleteType=0;
  urilistType=0;
  }


// Destroy zaps the icons
void FXExplorer::destroy(){
  FXTreeList::destroy();
  getApp()->removeTimeout(this,ID_REFRESH);
  open_folder->destroy();
  closed_folder->destroy();
  mini_doc->destroy();
  mini_app->destroy();
  }


// Create item
FXTreeItem* FXExplorer::createItem(const FXString& text,FXIcon* oi,FXIcon* ci,void* ptr){
  return (FXTreeItem*) new FXExplorerItem(text,oi,ci,ptr);
  }


// Compare file names
FXint FXExplorer::cmpFName(const FXTreeItem* a,const FXTreeItem* b){
#ifndef WIN32
  return compare(cEI(a)->label,cEI(b)->label);
#else
  return comparecase(cEI(a)->label,cEI(b)->label);
#endif
  }


// Reversed compare file names
FXint FXExplorer::cmpRName(const FXTreeItem* a,const FXTreeItem* b){
  return -FXExplorer::cmpFName(a,b);
  }

// FIXME This needs to be redone using FXFile

// Helper function
FXchar *FXExplorer::getpath(const FXTreeItem* item,FXchar* pathname) const {
  register FXchar *ptr=pathname;
  register const FXchar *p;
  register FXuint ss=0;
  register FXbool notroot = FALSE;
  const FXchar *stack[100];
  FXASSERT(pathname);
  while(item){
    stack[ss++]=cEI(item)->label.text();
    item=cEI(item)->parent;
    }
  FXASSERT(ss<100);
  if(ss){
    p=stack[--ss];
    FXASSERT(p);
    // mind the top level dir side effect
    if(!FXFile::isTopDirectory(p)) notroot=TRUE;
    while(*p){*ptr++=*p++;}
    if (notroot) *ptr++=PATHSEP;
    if(ss){
      while(1){
        p=stack[--ss];
        FXASSERT(p);
        while(*p){*ptr++=*p++;}
        if(!ss) break;
        *ptr++=PATHSEP;
        }
      }
    }
  *ptr='\0';
  FXASSERT((ptr-pathname)<MAXPATHLEN);
  return pathname;
  }

// FIXME This needs to be redone using FXFile
// FIXME also use new findItem() API's!!

// Helper function:- this is one ugly mother
FXTreeItem* FXExplorer::getitem(FXchar* pathname){
  FXchar buffer[MAXPATHLEN];
  register FXchar *ptr;
  FXbool changed;
  FXTreeItem *item,*it;
  recalc();
  update();
  if(!firstitem) scanRootDir(FALSE);
  if(!firstitem) return NULL;

  FXint (*cmpnfunc)(const FXchar*,const FXString&,FXint);
  FXint (*cmpfunc)(const FXchar*,const FXString&);
#ifndef WIN32
  cmpnfunc=compare;
  cmpfunc=compare;
#else
  cmpnfunc=comparecase;
  cmpfunc=comparecase;
#endif

  // Scanning root level
  for (it=firstitem;it;it=EI(it)->next){
    FXuint pathlen=strlen(pathname);
    FXuint len=EI(it)->label.length();
    if (cmpnfunc(pathname,EI(it)->label,len)==0){

      // we've got a root item ?
      if (len==pathlen) return it;

      // The node [it] is a top level dir => mind the side effect
      else if (FXFile::isTopDirectory(EI(it)->label)) len--; 

      if (pathname[len]==PATHSEP){
        // We have to search with [it] as root
        pathname+=len+1;
        ptr=(FXchar*)strchr(pathname,PATHSEP);
        if (ptr) *ptr='\0';
        while (*pathname){
          for (item=EI(it)->first;item;item=EI(item)->next){
            if (cmpfunc(pathname,EI(item)->label)==0) break;
            }

          if (!item){
            // Try relist
            getpath(it,buffer);
            changed=listSubDir((FXExplorerItem*)it,buffer);
            if (changed){

              // Now have knowledge of subitems
              if(!EI(it)->first) EI(it)->state&=~FXExplorerItem::HASITEMS;
              else EI(it)->state|=FXExplorerItem::HASITEMS;

              //////// Missing update here somewhere...
              sortChildItems(it);

              // Now, try to find it again
              for (item=EI(it)->first;item;item=EI(item)->next){
                if (cmpfunc(pathname,EI(item)->label)==0) break;
                }
              }
            }

          // The tree ends here
          if (!item) return it;

          // Found the exact match
          if (!ptr) return item;
          it=item;
          pathname=ptr+1;
          ptr=(FXchar*)strchr(pathname,PATHSEP);
          if (ptr) *ptr='\0';
          }

        // No further match
        return it;
        }

      else{
        // No chance
        return firstitem;
        }
      }
    }
  return firstitem;
  }


/*******************************************************************************/


// Handle drag-and-drop enter
long FXExplorer::onDNDEnter(FXObject* sender,FXSelector sel,void* ptr){
  FXTreeList::onDNDEnter(sender,sel,ptr);
  return 1;
  }


// Handle drag-and-drop leave
long FXExplorer::onDNDLeave(FXObject* sender,FXSelector sel,void* ptr){
  stopAutoScroll();
  FXTreeList::onDNDLeave(sender,sel,ptr);
  return 1;
  }


// Handle drag-and-drop motion
long FXExplorer::onDNDMotion(FXObject* sender,FXSelector sel,void* ptr){
  FXEvent *event=(FXEvent*)ptr;
  FXTreeItem *item;

  // Start autoscrolling
  if(startAutoScroll(event->win_x,event->win_y,FALSE)) return 1;

  // Give base class a shot
  if(FXTreeList::onDNDMotion(sender,sel,ptr)) return 1;

  // Dropping list of filenames
  if(offeredDNDType(FROM_DRAGNDROP,urilistType)){

    // Locate drop place
    item=getItemAt(event->win_x,event->win_y);

    // We can drop in a directory
    if(item && isItemDirectory(item)){

      // Get drop directory
      dropdirectory=getItemPathname(item);

      // What is being done (move,copy,link)
      dropaction=inquireDNDAction();

      // See if this is writable
      if(FXFile::isWritable(dropdirectory)){
        FXTRACE((100,"accepting drop on %s\n",dropdirectory.text()));
        acceptDrop(DRAG_ACCEPT);
        }
      }
    return 1;
    }
  return 0;
  }


// Handle drag-and-drop drop
long FXExplorer::onDNDDrop(FXObject* sender,FXSelector sel,void* ptr){
  FXuchar *data; FXuint len;

  // Stop scrolling
  stopAutoScroll();

  // Perhaps target wants to deal with it
  if(FXTreeList::onDNDDrop(sender,sel,ptr)) return 1;

  // Get uri-list of files being dropped
  if(getDNDData(FROM_DRAGNDROP,urilistType,data,len)){
    FXRESIZE(&data,FXuchar,len+1); data[len]='\0';
    FXchar *p,*q;
    p=q=(FXchar*)data;
    while(*p){
      while(*q && *q!='\r') q++;
      FXString url(p,q-p);
      FXString filesrc(FXURL::fileFromURL(url));
      FXString filedst(dropdirectory+PATHSEPSTRING+FXFile::name(filesrc));

      // Move, Copy, or Link as appropriate
      if(dropaction==DRAG_MOVE){
        FXTRACE((100,"Moving file: %s to %s\n",filesrc.text(),filedst.text()));
        if(!FXFile::move(filesrc,filedst)) getApp()->beep();
        }
      else if(dropaction==DRAG_COPY){
        FXTRACE((100,"Copying file: %s to %s\n",filesrc.text(),filedst.text()));
        if(!FXFile::copy(filesrc,filedst)) getApp()->beep();
        }
      else if(dropaction==DRAG_LINK){
        FXTRACE((100,"Linking file: %s to %s\n",filesrc.text(),filedst.text()));
        if(!FXFile::symlink(filesrc,filedst)) getApp()->beep();
        }
      if(*q=='\r') q+=2;
      p=q;
      }

    FXFREE(&data);
    return 1;
    }

  return 0;
  }


// Somebody wants our dragged data
long FXExplorer::onDNDRequest(FXObject* sender,FXSelector sel,void* ptr){
  FXEvent *event=(FXEvent*)ptr;
  FXuchar *data; FXuint len;

  // Perhaps the target wants to supply its own data
  if(FXTreeList::onDNDRequest(sender,sel,ptr)) return 1;

  // Return list of filenames as a uri-list
  if(event->target==urilistType){
    if(!dragfiles.empty()){
      len=dragfiles.length();
      FXMEMDUP(&data,FXuchar,dragfiles.text(),len);
      setDNDData(FROM_DRAGNDROP,event->target,data,len);
      }
    return 1;
    }

  // Delete selected files
  if(event->target==deleteType){
    FXTRACE((100,"Delete files not yet implemented\n"));
    return 1;
    }

  return 0;
  }


// Start a drag operation
long FXExplorer::onBeginDrag(FXObject* sender,FXSelector sel,void* ptr){
  register FXTreeItem *item;
  if(FXTreeList::onBeginDrag(sender,sel,ptr)) return 1;
  if(beginDrag(&urilistType,1)){
    dragfiles=FXString::null;
    item=firstitem;
    while(item){
      if(item->isSelected()){
        if(!dragfiles.empty()) dragfiles+="\r\n";
        dragfiles+=FXURL::fileToURL(getItemPathname(item));
        }
      if(EI(item)->first) item=EI(item)->first;
      else{
        while(!EI(item)->next && EI(item)->parent) item=EI(item)->parent;
        item=EI(item)->next;
        }
      }
    return 1;
    }
  return 0;
  }


// End drag operation
long FXExplorer::onEndDrag(FXObject* sender,FXSelector sel,void* ptr){
  if(FXTreeList::onEndDrag(sender,sel,ptr)) return 1;
  endDrag((didAccept()!=DRAG_REJECT));
  setDragCursor(getDefaultCursor());
  return 1;
  }


// Dragged stuff around
long FXExplorer::onDragged(FXObject* sender,FXSelector sel,void* ptr){
  FXEvent* event=(FXEvent*)ptr;
  FXDragAction action;
  if(FXTreeList::onDragged(sender,sel,ptr)) return 1;
  action=DRAG_MOVE;
  if(event->state&CONTROLMASK) action=DRAG_COPY;
  if(event->state&SHIFTMASK) action=DRAG_MOVE;
  if(event->state&ALTMASK) action=DRAG_LINK;
  handleDrag(event->root_x,event->root_y,action);
  if(didAccept()!=DRAG_REJECT){
    if(action==DRAG_MOVE) setDragCursor(getApp()->getDefaultCursor(DEF_DNDMOVE_CURSOR));
    else if(action==DRAG_LINK) setDragCursor(getApp()->getDefaultCursor(DEF_DNDLINK_CURSOR));
    else setDragCursor(getApp()->getDefaultCursor(DEF_DNDCOPY_CURSOR));
    }
  else setDragCursor(getApp()->getDefaultCursor(DEF_DNDSTOP_CURSOR));
  return 1;
  }


/*******************************************************************************/


// Open up the path down to the given string
long FXExplorer::onCmdSetValue(FXObject*,FXSelector,void* ptr){
  if(ptr){ setCurrentFile((const FXchar*)ptr); }
  return 1;
  }


// Open up the path down to the given string
long FXExplorer::onCmdSetStringValue(FXObject*,FXSelector,void* ptr){
  if(ptr==NULL){ fxerror("%s::onCmdSetStringValue: NULL pointer.\n",getClassName()); }
  setCurrentFile(*((FXString*)ptr));
  return 1;
  }


// Obtain value of the current item
long FXExplorer::onCmdGetStringValue(FXObject*,FXSelector,void* ptr){
  if(ptr==NULL){ fxerror("%s::onCmdGetStringValue: NULL pointer.\n",getClassName()); }
  *((FXString*)ptr)=getCurrentFile();
  return 1;
  }


// Toggle hidden files
long FXExplorer::onCmdToggleHidden(FXObject*,FXSelector,void*){
  showHiddenFiles(!showHiddenFiles());
  return 1;
  }


// Update toggle hidden files widget
long FXExplorer::onUpdToggleHidden(FXObject* sender,FXSelector,void*){
  if(showHiddenFiles())
    sender->handle(this,FXSEL(SEL_COMMAND,ID_CHECK),NULL);
  else
    sender->handle(this,FXSEL(SEL_COMMAND,ID_UNCHECK),NULL);
  return 1;
  }


// Show hidden files
long FXExplorer::onCmdShowHidden(FXObject*,FXSelector,void*){
  showHiddenFiles(TRUE);
  return 1;
  }


// Update show hidden files widget
long FXExplorer::onUpdShowHidden(FXObject* sender,FXSelector,void*){
  if(showHiddenFiles())
    sender->handle(this,FXSEL(SEL_COMMAND,ID_CHECK),NULL);
  else
    sender->handle(this,FXSEL(SEL_COMMAND,ID_UNCHECK),NULL);
  return 1;
  }


// Hide hidden files
long FXExplorer::onCmdHideHidden(FXObject*,FXSelector,void*){
  showHiddenFiles(FALSE);
  return 1;
  }


// Update hide hidden files widget
long FXExplorer::onUpdHideHidden(FXObject* sender,FXSelector,void*){
  if(!showHiddenFiles())
    sender->handle(this,FXSEL(SEL_COMMAND,ID_CHECK),NULL);
  else
    sender->handle(this,FXSEL(SEL_COMMAND,ID_UNCHECK),NULL);
  return 1;
  }


// Toggle files display
long FXExplorer::onCmdToggleFiles(FXObject*,FXSelector,void*){
  showFiles(!showFiles());
  return 1;
  }


// Update toggle files widget
long FXExplorer::onUpdToggleFiles(FXObject* sender,FXSelector,void*){
  if(showFiles())
    sender->handle(this,FXSEL(SEL_COMMAND,ID_CHECK),NULL);
  else
    sender->handle(this,FXSEL(SEL_COMMAND,ID_UNCHECK),NULL);
  return 1;
  }


// Show files
long FXExplorer::onCmdShowFiles(FXObject*,FXSelector,void*){
  showFiles(TRUE);
  return 1;
  }


// Update show files widget
long FXExplorer::onUpdShowFiles(FXObject* sender,FXSelector,void*){
  if(showFiles())
    sender->handle(this,FXSEL(SEL_COMMAND,ID_CHECK),NULL);
  else
    sender->handle(this,FXSEL(SEL_COMMAND,ID_UNCHECK),NULL);
  return 1;
  }


// Hide files
long FXExplorer::onCmdHideFiles(FXObject*,FXSelector,void*){
  showFiles(FALSE);
  return 1;
  }


// Update hide files widget
long FXExplorer::onUpdHideFiles(FXObject* sender,FXSelector,void*){
  if(!showFiles())
    sender->handle(this,FXSEL(SEL_COMMAND,ID_CHECK),NULL);
  else
    sender->handle(this,FXSEL(SEL_COMMAND,ID_UNCHECK),NULL);
  return 1;
  }


// Change pattern
long FXExplorer::onCmdSetPattern(FXObject*,FXSelector,void* ptr){
  if(!ptr) return 0;
  setPattern((const char*)ptr);
  return 1;
  }


// Update pattern
long FXExplorer::onUpdSetPattern(FXObject* sender,FXSelector,void*){
  sender->handle(this,FXSEL(SEL_COMMAND,FXWindow::ID_SETVALUE),(void*)pattern.text());
  return 1;
  }


// Reverse sort order
long FXExplorer::onCmdSortReverse(FXObject*,FXSelector,void*){
  if(sortfunc==cmpFName) sortfunc=cmpRName;
  else if(sortfunc==cmpRName) sortfunc=cmpFName;
  scanRootDir(TRUE);
  return 1;
  }


// Update sender
long FXExplorer::onUpdSortReverse(FXObject* sender,FXSelector,void* ptr){
  FXuint msg=(sortfunc==cmpRName)?ID_CHECK:ID_UNCHECK;
  sender->handle(this,FXSEL(SEL_COMMAND,msg),ptr);
  return 1;
  }

/*******************************************************************************/

// FIXME look more carefully at this four handlers below...

// Close directory
long FXExplorer::onClosed(FXObject*,FXSelector,void* ptr){
  FXExplorerItem *item=(FXExplorerItem*)ptr;
  if(item->state&FXExplorerItem::FOLDER){
    return target && target->handle(this,FXSEL(SEL_CLOSED,message),ptr);
    }
  return 1;
//   FXExplorerItem *item=(FXExplorerItem*)ptr;
//   if(!(item->state&FXExplorerItem::FOLDER)) return 0;
//   FXTreeList::onClosed(sender,sel,ptr);
//   FXTRACE((100,"%s::onItemClosed: %s\n",getClassName(),item->label.text()));
//   return 1;
  }


// Open directory
long FXExplorer::onOpened(FXObject*,FXSelector,void* ptr){
  FXExplorerItem *item=(FXExplorerItem*)ptr;
  if(item->state&FXExplorerItem::FOLDER){
    return target && target->handle(this,FXSEL(SEL_OPENED,message),ptr);
    }
  return 1;
//   FXExplorerItem *item=(FXExplorerItem*)ptr;
//   FXchar path[MAXPATHLEN];
//   FXbool changed;
//   if(!(item->state&FXExplorerItem::FOLDER)) return 0;
//   FXTreeList::onOpened(sender,sel,ptr);
//
//   // Get path to item
//   getpath(item,path);
//
//   FXTRACE((100,"%s::onItemOpened: %s path=%s\n",getClassName(),item->label.text(),path));
//
//   // List stuff in item directory
//   changed=listSubDir(item,path);
//
//   // Now we know for sure whether we really have subitems or not
//   if(!item->first) item->state&=~FXExplorerItem::HASITEMS; else item->state|=FXExplorerItem::HASITEMS;
//   //////// Missing update here somewhere...
//   // Sort items
//   if(changed){
//     sortChildItems(item);
//     }
//   return 1;
  }


// Item opened
long FXExplorer::onExpanded(FXObject* sender,FXSelector sel,void* ptr){
  FXExplorerItem *item=(FXExplorerItem*)ptr;
  if(!FXFile::exists(getItemPathname(item))){
    collapseTree(item);
    return 1;
    }
  FXchar path[MAXPATHLEN];
  FXbool changed;
  if(!(item->state&FXExplorerItem::FOLDER)) return 0;

  // Expand tree item
  FXTreeList::onExpanded(sender,sel,ptr);

  // Get path to item
  getpath(item,path);

  FXTRACE((100,"%s::onItemExpanded: %s path=%s\n",getClassName(),item->label.text(),path));

  // List stuff in item directory
  changed=listSubDir(item,path);

  // Now we know for sure whether we really have subitems or not
  if(!item->first) item->state&=~FXExplorerItem::HASITEMS;
  else item->state|=FXExplorerItem::HASITEMS;
  //////// Missing update here somewhere...

  // Sort items
  if(changed) sortChildItems(item);
  return 1;
  }


// Item closed
long FXExplorer::onCollapsed(FXObject* sender,FXSelector sel,void* ptr){
  FXExplorerItem *item=(FXExplorerItem*)ptr;
  if(!(item->state&FXExplorerItem::FOLDER)) return 0;

  // Collapse tree item
  FXTRACE((100,"%s::onItemCollapsed: %s\n",getClassName(),item->label.text()));
  FXTreeList::onCollapsed(sender,sel,ptr);

  // As a memory saving feature, all knowledge below this item
  // is deleted; we'll just recreate it when its reexpanded!
  //removeItems(item->first,item->last);
  //recalc();
  return 1;
  }


/*******************************************************************************/


// Refresh
long FXExplorer::onRefresh(FXObject*,FXSelector,void*){
  FXbool changed;

  // Only update if user is not interacting with the file list
  if(flags&FLAG_UPDATE){
    changed=scanRootDir(FALSE);
    if(changed) recalc();
    counter=(counter+1)%REFRESHFREQUENCY;
    }

  // Reset timer again
  getApp()->addTimeout(this,ID_REFRESH,REFRESHINTERVAL);

  return 0;
  }


/********************************************************************************
*                                    X-Windows                                  *
********************************************************************************/
#ifndef WIN32

// List root directories
FXbool FXExplorer::listRoots(){
  return (firstitem)?FALSE:effectiveAddRoot(PATHSEPSTRING);
  }



// Scan root directory for changes
FXbool FXExplorer::scanRootDir(FXbool relist){
  FXbool changed=FALSE;
  FXchar pathname[MAXPATHLEN];
  FXExplorerItem *item;
  long filetime;
  struct stat info;

  // Update root items
  if (!(options&EXPLORER_USER_ROOTS)) changed = listRoots();

  for (item=EI(firstitem); item; item = EI(item->next)) {

    // Item is directory; check regardless of children
    if((item->state&FXExplorerItem::FOLDER) && (item->state&FXExplorerItem::EXPANDED)){
      strncpy(pathname, item->label.text(), MAXPATHLEN);

      // Refresh subitems of root if necessary
      if(stat(pathname,&info)==0){
        filetime=FXMAX(info.st_mtime,info.st_ctime);
        if(relist || (item->date!=filetime) || ((filetime==0) && (counter==0))){
          if(listSubDir(item,pathname)){
            sortChildItems(item);
            changed=TRUE;
            }
          }
        item->date=filetime;
        }

      // Then check subdirectories
      changed|=scanSubDir(item,pathname,relist);
      }
    }
  return changed;
  }


// Scan sub directories
FXbool FXExplorer::scanSubDir(FXExplorerItem *par,FXchar *pathname,FXbool relist){
  FXbool changed=FALSE;
  FXchar *pathtail,*pathend;
  FXExplorerItem *item;
  long filetime;
  struct stat info;

  if(par->first){

    // Build path prefix
    pathend=pathtail=pathname+strlen(pathname);
    if(!ISPATHSEP(*(pathtail-1))) *pathtail++=PATHSEP;

    // Loop over contents
    for(item=(FXExplorerItem*)par->first; item; item=(FXExplorerItem*)item->next){

      // Item is directory; check regardless of children
      if((item->state&FXExplorerItem::FOLDER) && (item->state&FXExplorerItem::EXPANDED)){

        // Sub item path
        strcpy(pathtail,item->label.text());

        // Refresh subitems of item if necessary
        if(stat(pathname,&info)==0){
          filetime=FXMAX(info.st_mtime,info.st_ctime);
          if(relist || (item->date!=filetime) || ((filetime==0) && (counter==0))){
            if(listSubDir(item,pathname)){
              sortChildItems(item);
              changed=TRUE;
              }
            }
          item->date=filetime;
          }

        // Then check subdirectories
        changed|=scanSubDir(item,pathname,relist);
        }
      }
    *pathend='\0';
    }
  return changed;
  }




// List subdirectories
FXbool FXExplorer::listSubDir(FXExplorerItem *par,FXchar *pathname){
  FXExplorerItem *after,*before,*newlist,*item,*it;
  FXIcon *openicon,*closedicon;
  FXchar *pathtail,*pathend,*name;
  FXbool changed=FALSE;
  FXFileAssoc *fileassoc;
  long filetime;
  struct dirent *dp;
  struct stat info;
  DIR *dirp;
  int islink;

  // Find end of original pathname
  pathend=pathtail=pathname+strlen(pathname);

  // Build new insert-order list
  after=NULL;
  before=par->list;
  newlist=NULL;
  if(!par->first) before=NULL;

  // Get directory stream pointer
  dirp=opendir(pathname);

  // Managed to open directory
  if(dirp){

    // Insert a '/' if needed
    if(!ISPATHSEP(*(pathtail-1))) *pathtail++=PATHSEP;

    // Process directory entries
    while((dp=readdir(dirp))!=NULL){
      name=dp->d_name;

      // A dot special file?
      if(name[0]=='.' && (name[1]==0 || (name[1]=='.' && name[2]==0))) continue;

      // Hidden file or directory normally not shown
      if(name[0]=='.' && !(options&EXPLORER_SHOWHIDDEN)) continue;

      // Build full pathname
      strcpy(pathtail,name);

      // Get File info
      if(lstat(pathname,&info)!=0) continue;

      // If its a link, get the file info
      islink=S_ISLNK(info.st_mode);
      if(islink && stat(pathname,&info)!=0) continue;

      // If it is not a directory, and not showing files and matching pattern skip it
      if(!S_ISDIR(info.st_mode) && !((options&EXPLORER_SHOWFILES) && fxfilematch(pattern.text(),name,matchmode))) continue;

      // File change/mod time
      filetime=FXMAX(info.st_mtime,info.st_ctime);

      // Find it
      for(item=before; item; item=item->inext){
        if(compare(item->label,name)==0){
          while(before!=item){
            it=before;
            before=before->inext;
            if(it->prev) EI(it->prev)->next=it->next; else EI(it->parent)->first=it->next;
            if(it->next) EI(it->next)->prev=it->prev; else EI(it->parent)->last=it->prev;
            if(currentitem==it) currentitem=NULL;
            if(anchoritem==it) anchoritem=NULL;
            removeItems(it->first,it->last);
            changed=TRUE;
            delete it;
            }
          before=item->inext;
          if(before) before->iprev=NULL;
          item->inext=NULL;
          item->iprev=NULL;
          goto fnd;
          }
        }

      // Not found; prepend before list
      item=(FXExplorerItem*)createItem(name,open_folder,closed_folder,NULL);
      item->prev=par->last;
      item->next=NULL;
      item->parent=par;
      item->first=NULL;
      item->last=NULL;
      item->label=name;
      item->iprev=NULL;
      item->inext=NULL;
      item->list=NULL;
      item->state=FXExplorerItem::HASITEMS;
      item->date=0;
      if(item->prev) EI(item->prev)->next=item; else par->first=item;
      par->last=item;
      changed=TRUE;

      // Next gets hung after this one
fnd:  item->iprev=after;
      if(after) after->inext=item; else newlist=item;

      // Fill item with updated information, if data has changed

      // Anything about the file changed?
      if((item->date!=filetime) || (filetime==0)){

        // Item flags
        if(info.st_mode&(S_IXUSR|S_IXGRP|S_IXOTH)) item->state|=FXExplorerItem::EXECUTABLE;
	else item->state&=~FXExplorerItem::EXECUTABLE;

        if(S_ISDIR(info.st_mode)) item->state|=FXExplorerItem::FOLDER;
	else item->state&=~(FXExplorerItem::FOLDER|FXExplorerItem::HASITEMS);

        if(S_ISLNK(info.st_mode)) item->state|=FXExplorerItem::SYMLINK;
	else item->state&=~FXExplorerItem::SYMLINK;

        if(S_ISCHR(info.st_mode)) item->state|=FXExplorerItem::CHARDEV;
	else item->state&=~FXExplorerItem::CHARDEV;

        if(S_ISBLK(info.st_mode)) item->state|=FXExplorerItem::BLOCKDEV;
	else item->state&=~FXExplorerItem::BLOCKDEV;

        if(S_ISFIFO(info.st_mode)) item->state|=FXExplorerItem::FIFO;
	else item->state&=~FXExplorerItem::FIFO;

        if(S_ISSOCK(info.st_mode)) item->state|=FXExplorerItem::SOCK;
	else item->state&=~FXExplorerItem::SOCK;


        // We can drag items
        item->state|=FXExplorerItem::DRAGGABLE;

        // Assume no associations
        fileassoc=NULL;

        // Determine icons and type
        if(item->state&FXExplorerItem::FOLDER){
          openicon=open_folder;
          closedicon=closed_folder;
          if(associations) fileassoc=associations->findDirBinding(pathname);
          }
        else if(item->state&FXExplorerItem::EXECUTABLE){
          openicon=mini_app;
          closedicon=mini_app;
          if(associations) fileassoc=associations->findExecBinding(pathname);
          }
        else{
          openicon=mini_doc;
          closedicon=mini_doc;
          if(associations) fileassoc=associations->findFileBinding(pathname);
          }

        // If association is found, use it
        if(fileassoc){
          if(fileassoc->miniicon) closedicon=fileassoc->miniicon;
          if(fileassoc->miniiconopen) openicon=fileassoc->miniiconopen;
          }

        // Update item information
        item->openIcon=openicon;
        item->closedIcon=closedicon;
        item->size=(unsigned long)info.st_size;
        item->assoc=fileassoc;
        item->date=filetime;

        // Create item
        if(id()) item->create();

        // Info has changed
        changed=TRUE;
        }

      // Next one goes after item
      after=item;
      }

    // Close it
    closedir(dirp);
    }

  // Wipe items remaining in list:- they have disappeared!!
  while(before){
    it=before;
    before=before->inext;
    if(it->prev) EI(it->prev)->next=it->next; else EI(it->parent)->first=it->next;
    if(it->next) EI(it->next)->prev=it->prev; else EI(it->parent)->last=it->prev;
    if(currentitem==it) currentitem=NULL;
    if(anchoritem==it) anchoritem=NULL;
    removeItems(it->first,it->last);
    changed=TRUE;
    delete it;
    }

  // Remember new list
  par->list=newlist;

  // Restore original path
  *pathend='\0';
  return changed;
  }



/********************************************************************************
*                                   MS-Windows                                  *
********************************************************************************/
#else


// Convert FILETIME (# 100ns since 01/01/1601) to time_t (# s since 01/01/1970)
static time_t fxfiletime(const FILETIME& ft){
  FXlong ll=(((FXlong)ft.dwHighDateTime)<<32) | (FXlong)ft.dwLowDateTime;
#if defined(__CYGWIN__) || defined(__MINGW32__)
  ll=ll-116444736000000000LL;
#else
  ll=ll-116444736000000000L;    // 0x19DB1DED53E8000
#endif
  ll=ll/10000000;
  return (time_t)ll;
  }


// List root directories
FXbool FXExplorer::listRoots(){
  FXbool changed=FALSE;
  // FIXME we want to move this logic into FXFileDict
  DWORD drivemask=GetLogicalDrives();
  TCHAR drivename[10];
  drivename[1]=TEXT(':');
  drivename[2]=TEXT('\\');
  drivename[3]=0;
  for(drivename[0]=TEXT('a'); drivename[0]<=TEXT('z'); drivename[0]++){
    if(drivemask&1){
      UINT drivetype=GetDriveType(drivename);
      changed|=effectiveAddRoot(drivename);
      }
    drivemask>>=1;
    }
  if (changed) sortItems();
  return changed;
  }


// Scan root directory for changes
FXbool FXExplorer::scanRootDir(FXbool relist){
  FXbool changed=FALSE;
  FXchar pathname[MAXPATHLEN];
  FXExplorerItem *item;
  time_t filetime;
  HANDLE hFile;
  FILETIME ftLastWriteTime;
  FXString drive=FXFile::getCurrentDrive();


  // Update root items
  if (!(options&EXPLORER_USER_ROOTS)) changed = listRoots();
  for (item=EI(firstitem); item; item = EI(item->next)) {

    // Item is directory; check regardless of children
    if((item->state&FXExplorerItem::FOLDER) && (item->state&FXExplorerItem::EXPANDED)){
      strncpy(pathname, item->label.text(), MAXPATHLEN);

      // Refresh subitems of root if necessary
      hFile=CreateFile(pathname,GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_FLAG_BACKUP_SEMANTICS,NULL);
      if(hFile!=INVALID_HANDLE_VALUE){
        if(GetFileTime(hFile,NULL,NULL,&ftLastWriteTime)){

          // Convert
          filetime=fxfiletime(ftLastWriteTime);

          if(relist || (item->date!=filetime) || (filetime==0) && (counter==0)){
            if(listSubDir(item,pathname)){
              sortChildItems(item);
              changed=TRUE;
              }
            }
          item->date=filetime;
          }
        CloseHandle(hFile);
        }

      // Then check subdirectories
      changed|=scanSubDir(item,pathname,relist);
      }
    }
  return changed;
  }


// Scan sub directories
FXbool FXExplorer::scanSubDir(FXExplorerItem *par,FXchar *pathname,FXbool relist){
  FXbool changed=FALSE;
  FXchar *pathtail,*pathend;
  FXExplorerItem *item;
  time_t filetime;
  HANDLE hFile;
  FILETIME ftLastWriteTime;
  if(par->first){

    // Build path prefix
    pathend=pathtail=pathname+strlen(pathname);
    if(!ISPATHSEP(*(pathtail-1))) *pathtail++=PATHSEP;

    // Loop over contents
    for(item=(FXExplorerItem*)par->first; item; item=(FXExplorerItem*)item->next){

      // Item is directory; check regardless of children
      if((item->state&FXExplorerItem::FOLDER) && (item->state&FXExplorerItem::EXPANDED)){

        // Sub item path
        strcpy(pathtail,item->label.text());

        // Refresh subitems of item if necessary
        hFile=CreateFile(pathname,GENERIC_READ,0,NULL,OPEN_EXISTING,FILE_FLAG_BACKUP_SEMANTICS,NULL);
        if(hFile!=INVALID_HANDLE_VALUE){
          if(GetFileTime(hFile,NULL,NULL,&ftLastWriteTime)){

            // Convert
            filetime=fxfiletime(ftLastWriteTime);

            if(relist || (item->date!=filetime) || ((filetime==0) && (counter==0))){
              if(listSubDir(item,pathname)){
                sortChildItems(item);
                changed=TRUE;
                }
              }
            item->date=filetime;
            }
          CloseHandle(hFile);
          }

        // Then check subdirectories
        changed|=scanSubDir(item,pathname,relist);
        }
      }
    *pathend='\0';
    }
  return changed;
  }




// List subdirectories
FXbool FXExplorer::listSubDir(FXExplorerItem *par,FXchar *pathname){
  FXExplorerItem *after,*before,*newlist,*item,*it;
  FXIcon *openicon,*closedicon;
  FXchar *pathtail,*pathend,*name;
  FXbool changed=FALSE;
  FXFileAssoc *fileassoc;
  time_t filetime;
  WIN32_FIND_DATA ffData;
  HANDLE hFindFile;

  // Find end of original pathname
  pathend=pathtail=pathname+strlen(pathname);

  // Build new insert-order list
  after=NULL;
  before=par->list;
  newlist=NULL;
  if(!par->first) before=NULL;

  // Insert a '\' if needed
  if(!ISPATHSEP(*(pathtail-1))) *pathtail++=PATHSEP;

  // Get file find handle and first file's info
  strcpy(pathtail,"*");
  hFindFile=FindFirstFile(pathname,&ffData);

  // Found first file?
  if(hFindFile!=INVALID_HANDLE_VALUE){

    // Loop over directory entries
    do{
      name=ffData.cFileName;

      // A dot special file?
      if(name[0]=='.' && (name[1]==0 || (name[1]=='.' && name[2]==0))) continue;

      // Hidden file or directory normally not shown
      if((ffData.dwFileAttributes&FILE_ATTRIBUTE_HIDDEN || name[0]=='.') && !(options&EXPLORER_SHOWHIDDEN)) continue;

      // If it is not a directory, and not showing files and matching pattern skip it
      if(!(ffData.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY) && !((options&EXPLORER_SHOWFILES) && fxfilematch(pattern.text(),name,matchmode))) continue;

      // Build full pathname
      strcpy(pathtail,name);

      // Convert it
      filetime=fxfiletime(ffData.ftLastWriteTime);

      // Find it
      for(item=before; item; item=item->inext){
        if(comparecase(item->label,name)==0){
          while(before!=item){
            it=before;
            before=before->inext;
            if(it->prev) EI(it->prev)->next=it->next; else EI(it->parent)->first=it->next;
            if(it->next) EI(it->next)->prev=it->prev; else EI(it->parent)->last=it->prev;
            if(currentitem==it) currentitem=NULL;
            if(anchoritem==it) anchoritem=NULL;
            removeItems(it->first,it->last);
            changed=TRUE;
            delete it;
            }
          before=item->inext;
          if(before) before->iprev=NULL;
          item->inext=NULL;
          item->iprev=NULL;
          goto fnd;
          }
        }

      // Not found; prepend before list
      item=(FXExplorerItem*)createItem(name,open_folder,closed_folder,NULL);
      item->prev=par->last;
      item->next=NULL;
      item->parent=par;
      item->first=NULL;
      item->last=NULL;
      item->label=name;
      item->iprev=NULL;
      item->inext=NULL;
      item->list=NULL;
      item->state=FXExplorerItem::HASITEMS;
      item->date=0;
      if(item->prev) EI(item->prev)->next=item; else par->first=item;
      par->last=item;
      changed=TRUE;

      // Next gets hung after this one
fnd:  item->iprev=after;
      if(after) after->inext=item; else newlist=item;

      // Anything about the file changed?
      if((item->date!=filetime) || (filetime==0)){

        // Item flags
        if(ffData.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY) item->state|=FXExplorerItem::FOLDER; else item->state&=~(FXExplorerItem::FOLDER|FXExplorerItem::HASITEMS);

        // Is it an executable file type?
        // GetBinaryType() is not supported for Win95/98! Try SHGetFileInfo() instead.
        // if(!GetBinaryType(pathname,&dwBinaryType)) item->state&=~FXExplorerItem::EXECUTABLE; else item->state|=FXExplorerItem::EXECUTABLE;
        SHFILEINFO sfi;
        if(SHGetFileInfo(pathname,0,&sfi,sizeof(SHFILEINFO),SHGFI_EXETYPE)==0){
          item->state&=~FXExplorerItem::EXECUTABLE;
          }
        else{
          item->state|=FXExplorerItem::EXECUTABLE;
          }

        // We can drag items
        item->state|=FXExplorerItem::DRAGGABLE;

        // Assume no associations
        fileassoc=NULL;

        // Determine icons and type
        if(item->state&FXExplorerItem::FOLDER){
          openicon=open_folder;
          closedicon=closed_folder;
          if(associations) fileassoc=associations->findDirBinding(pathname);
          }
        else if(item->state&FXExplorerItem::EXECUTABLE){
          openicon=mini_app;
          closedicon=mini_app;
          if(associations) fileassoc=associations->findExecBinding(pathname);
          }
        else{
          openicon=mini_doc;
          closedicon=mini_doc;
          if(associations) fileassoc=associations->findFileBinding(pathname);
          }

        // If association is found, use it
        if(fileassoc){
          if(fileassoc->miniicon) closedicon=fileassoc->miniicon;
          if(fileassoc->miniiconopen) openicon=fileassoc->miniiconopen;
          }

        // Update item information
        item->openIcon=openicon;
        item->closedIcon=closedicon;
        item->size=ffData.nFileSizeLow;
        item->assoc=fileassoc;
        item->date=filetime;

        // Create item
        if(id()) item->create();

        // Info has changed
        changed=TRUE;
        }

      // Next one goes after item
      after=item;
      }
    while(FindNextFile(hFindFile,&ffData));

    // Close it
    FindClose(hFindFile);
    }

  // Wipe items remaining in list:- they have disappeared!!
  while(before){
    it=before;
    before=before->inext;
    if(it->prev) EI(it->prev)->next=it->next; else EI(it->parent)->first=it->next;
    if(it->next) EI(it->next)->prev=it->prev; else EI(it->parent)->last=it->prev;
    if(currentitem==it) currentitem=NULL;
    if(anchoritem==it) anchoritem=NULL;
    removeItems(it->first,it->last);
    changed=TRUE;
    delete it;
    }

  // Remember new list
  par->list=newlist;

  // Restore original path
  *pathend='\0';
  return changed;
  }

#endif


// Create a root item
void FXExplorer::createRootItem(const char * path) {
  // Do nothing if uninitialized
  if (!xid) return;
  FXString up = FXFile::upLevel(path);
  FXIcon *open, *closed;
#ifndef WIN32
  FXbool isRoot(up == path);
  open=(isRoot)?harddiskicon:open_folder;
  closed=(isRoot)?harddiskicon:closed_folder;
#else
  FXbool isDrive((path[0]>='a')&&(path[0]<='z')&&(path[1]==':')&&(path[2]=='\\')&&(path[3]=='\0'));
  if (isDrive){
    UINT drivetype=GetDriveType(path);
    switch(drivetype){
      case DRIVE_REMOVABLE:
        if(path[0]==TEXT('a') || path[0]==TEXT('b')) open=closed=floppyicon;
        else open=closed=zipdiskicon;
        break;
      case DRIVE_FIXED:
        open=closed=harddiskicon;
        break;
      case DRIVE_REMOTE:
        open=closed=networkicon;
        break;
      case DRIVE_CDROM:
        open=closed=cdromicon;
        break;
      case DRIVE_RAMDISK:
      case DRIVE_UNKNOWN:
      case DRIVE_NO_ROOT_DIR:
      default:
        open=open_folder;
        closed=closed_folder;
        break;
      }
    }
  else{
    open=open_folder;
    closed=closed_folder;
    }
#endif // WIN32
  FXExplorerItem *item=EI(createItem(path,open,closed,NULL));
  item->parent=NULL;
  item->next=NULL;
  item->prev=lastitem;
  item->inext=NULL;
  item->iprev=EI(lastitem);
  item->list=NULL;
  item->date=0;
  item->state=FXExplorerItem::FOLDER|FXExplorerItem::HASITEMS;
  item->first=NULL;
  item->last=NULL;
  if (!firstitem) firstitem=item;
  if (lastitem) {
    EI(lastitem)->next = item;
    EI(lastitem)->inext = item;
    }
  lastitem = item;
  }

// Add a root directory
FXbool FXExplorer::addRoot(const FXString & dir) {
  if (!xid||!(options&EXPLORER_USER_ROOTS)) return FALSE;
  FXbool changed=effectiveAddRoot(dir);
  if (changed){
    sortItems();
    scanRootDir(FALSE);
    layout();
    }
  makeItemVisible(findItem(dir));
  killSelection();
  setCurrentItem(findItem(dir));
  return changed;
  }

FXbool FXExplorer::effectiveAddRoot(const FXString & dir) {
  FXExplorerItem *item;
#ifndef WIN32
  if (!FXFile::isDirectory(dir)) return FALSE;
#else
  FXbool check((dir[0]>='a')&&(dir[0]<='z')&&(dir[1]==':')&&(dir[2]=='\\')&&(dir[3]=='\0'));
  if (check){
    UINT drivetype=GetDriveType(dir.text());
    switch(drivetype){
      case DRIVE_REMOVABLE:
        check=FALSE;
        break;
      default:
	check=TRUE;
      }
    }
  if(check){
    if(!FXFile::isDirectory(dir)) return FALSE;
    }
#endif // WIN32
  if (!(options&EXPLORER_SHOWHIDDEN)){
    FXString name=FXFile::name(dir);
    FXbool hidden;
#ifndef WIN32
    hidden=(name[0]=='.');
#else
    hidden=(GetFileAttributes("d:\\bliqid.zip")&FILE_ATTRIBUTE_HIDDEN)||(name[0]=='.');
#endif
    if (hidden) return FALSE;
    }
  for(item=EI(firstitem);item;item=EI(item->next)){
    if (item->label==dir) return FALSE;
    }
  createRootItem(dir.text());
  return TRUE;
  }

// Remove a root directory
FXbool FXExplorer::removeRoot(const FXString & dir) {
  if (!xid||!(options&EXPLORER_USER_ROOTS)) return FALSE;
  FXbool changed=effectiveRemoveRoot(dir);
  if (changed) layout();
  return changed;
  }

FXbool FXExplorer::effectiveRemoveRoot(const FXString & dir) {
  FXExplorerItem *item;
  for (item=EI(firstitem);item;item=EI(item->next)){
    if (item->label==dir){
      removeItem(item);
      return TRUE;
      }
    }
  return FALSE;
  }

// Is directory
FXbool FXExplorer::isItemDirectory(const FXTreeItem* item) const {
  if(item==NULL){ fxerror("%s::isItemDirectory: item is NULL.\n",getClassName()); }
  return (cEI(item)->state&FXExplorerItem::FOLDER)!=0;
  }


// Is file
FXbool FXExplorer::isItemFile(const FXTreeItem* item) const {
  if(item==NULL){ fxerror("%s::isItemFile: item is NULL.\n",getClassName()); }
  return (cEI(item)->state&(FXExplorerItem::FOLDER|FXExplorerItem::CHARDEV|FXExplorerItem::BLOCKDEV|FXExplorerItem::FIFO|FXExplorerItem::SOCK))==0;
  }


// Is executable
FXbool FXExplorer::isItemExecutable(const FXTreeItem* item) const {
  if(item==NULL){ fxerror("%s::isItemExecutable: item is NULL.\n",getClassName()); }
  return (cEI(item)->state&FXExplorerItem::EXECUTABLE)!=0;
  }


// Obtain full pathname down from root
FXString FXExplorer::getItemPathname(const FXTreeItem* item) const {
  if(item==NULL){ fxerror("%s::getItemPathname: item is NULL.\n",getClassName()); }
  if(!cEI(item)->parent) return cEI(item)->label;
  if(!cEI(cEI(item)->parent)->parent) {
    if (FXFile::isTopDirectory(cEI(cEI(item)->parent)->label))
      return cEI(cEI(item)->parent)->label+cEI(item)->label;
    }
  return getItemPathname(cEI(item)->parent)+PATHSEPSTRING+cEI(item)->label;
  }


// Obtain item's file name only
FXString FXExplorer::getItemFilename(const FXTreeItem* item) const {
  if(item==NULL){ fxerror("%s::getItemFilename: item is NULL.\n",getClassName()); }
  return cEI(item)->label;
  }


// Open all intermediate directories down toward given one
void FXExplorer::setDirectory(const FXString& pathname){    // FIXME notify argument?
  FXTreeItem *item;
  if(!pathname.empty()){
    FXTRACE((100,"%s::setDirectory(%s)\n",getClassName(),pathname.text()));
    FXString path=FXFile::absolute(pathname);
    while(!FXFile::isTopDirectory(path) && !FXFile::isDirectory(path)){
      path=FXFile::upLevel(path);
      }
#ifdef WIN32
    //Handle a drive change
    if(firstitem){
      if((path.length()>=2)&&path[1]==':'){
        FXString drive(path.left(2));
        drive.append(PATHSEP);
        if(EI(firstitem)->label!=drive){
//          if(_chdrive(drive[0]-'a'+1)==0){
          if(FXFile::setCurrentDrive(drive)){
            FXchar itempath[MAXPATHLEN+1];
            FXbool changed;
            scanRootDir(FALSE);
            getpath(firstitem,itempath);
            changed=listSubDir((FXExplorerItem*)firstitem,itempath);
            if(changed) sortChildItems(firstitem);
            }
          }
        }
      }
#endif
    item=getitem((FXchar*)path.text());   // FIXME
    makeItemVisible(item);
    setCurrentItem(item);
    }
  }


// Return directory part of path to current item
FXString FXExplorer::getDirectory() const {
  const FXTreeItem* item=currentitem;
  while(item){
    if(cEI(item)->state&FXExplorerItem::FOLDER) return getItemPathname(item);
    item=cEI(item)->parent;
    }
  return "";
  }


// Set current (dir/file) name path
void FXExplorer::setCurrentFile(const FXString& pathname){    // FIXME notify argument?
  FXTreeItem *item;
  if(!pathname.empty()){
    FXTRACE((100,"%s::setCurrentFile(%s)\n",getClassName(),pathname.text()));
    FXString path=FXFile::absolute(pathname);
    while(!FXFile::isTopDirectory(path) && !FXFile::exists(path)){
      path=FXFile::upLevel(path);
      }
#ifdef WIN32
    //Handle a drive change
    if(firstitem){
      if((path.length()>=2)&&path[1]==':'){
        FXString drive(path.left(2));
        drive.append(PATHSEP);
        if(EI(firstitem)->label!=drive){
//          if(_chdrive(drive[0]-'a'+1)==0){
          if(FXFile::setCurrentDrive(drive)){
            FXchar itempath[MAXPATHLEN+1];
            FXbool changed;
            scanRootDir(FALSE);
            getpath(firstitem,itempath);
            changed=listSubDir((FXExplorerItem*)firstitem,itempath);
            if(changed) sortChildItems(firstitem);
            }
          }
        }
      }
#endif
    item=getitem((FXchar*)path.text());     // FIXME
    makeItemVisible(item);
    setCurrentItem(item);
    }
  }


// Get current (dir/file) name path
FXString FXExplorer::getCurrentFile() const {
  if(currentitem==NULL) return FXString::null;
  return getItemPathname(currentitem);
  }



// Get list style
FXbool FXExplorer::showFiles() const {
  return (options&EXPLORER_SHOWFILES)!=0;
  }


// Change list style
void FXExplorer::showFiles(FXbool showing){
  FXuint opts=options;
  if(showing) opts|=EXPLORER_SHOWFILES; else opts&=~EXPLORER_SHOWFILES;
  if(options!=opts){
    options=opts;
    scanRootDir(TRUE);
    }
  }


// Return TRUE if showing hidden files
FXbool FXExplorer::showHiddenFiles() const {
  return (options&EXPLORER_SHOWHIDDEN)!=0;
  }


// Change show hidden files mode
void FXExplorer::showHiddenFiles(FXbool showing){
  FXuint opts=options;
  if(showing) opts|=EXPLORER_SHOWHIDDEN; else opts&=~EXPLORER_SHOWHIDDEN;
  if(opts!=options){
    options=opts;
    scanRootDir(TRUE);
    }
  }


// Set associations
void FXExplorer::setAssociations(FXFileDict* assoc){
  associations=assoc;
  }


// Set the pattern to filter
void FXExplorer::setPattern(const FXString& ptrn){
  if(ptrn.empty()) return;
  if(pattern!=ptrn){
    pattern=ptrn;
    scanRootDir(TRUE);
    }
  }


// Change file match mode
void FXExplorer::setMatchMode(FXuint mode){
  if(matchmode!=mode){
    matchmode=mode;
    scanRootDir(TRUE);
    }
  }


// Save data
void FXExplorer::save(FXStream& store) const {
  FXTreeList::save(store);
  store << associations;
  store << pattern;
  store << matchmode;
  store << closed_folder;
  store << open_folder;
  store << mini_doc;
  store << mini_app;
  }


// Load data
void FXExplorer::load(FXStream& store){
  FXTreeList::load(store);
  store >> associations;
  store >> pattern;
  store >> matchmode;
  store >> closed_folder;
  store >> open_folder;
  store >> mini_doc;
  store >> mini_app;
  }


// Cleanup
FXExplorer::~FXExplorer(){
  clearItems();
  getApp()->removeTimeout(this,ID_REFRESH);
  if(!(options&EXPLORER_NO_OWN_ASSOC)) delete associations;
  delete closed_folder;
  delete open_folder;
  delete mini_doc;
  delete mini_app;
  delete cdromicon;
  delete harddiskicon;
  delete networkicon;
  delete floppyicon;
  delete zipdiskicon;
  associations=(FXFileDict*)-1;
  closed_folder=(FXGIFIcon*)-1;
  open_folder=(FXGIFIcon*)-1;
  mini_doc=(FXGIFIcon*)-1;
  mini_app=(FXGIFIcon*)-1;
  cdromicon=(FXIcon*)-1;
  harddiskicon=(FXIcon*)-1;
  networkicon=(FXIcon*)-1;
  floppyicon=(FXIcon*)-1;
  zipdiskicon=(FXIcon*)-1;
  }

}

